{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2025 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnFormatterIntf;
{* |<PRE>
================================================================================
* ƣCnPack ʽר
* Ԫƣʽӿ
* ԪߣCnPack 
*     עõԪʽĶӿ
* ƽ̨WinXP + Delphi 5.0
* ݲԣƽ̨
*   Ҫ
* ޸ļ¼2015.02.11 V1.0
*               Ԫ
================================================================================
|</PRE>}

interface

{$I CnPack.inc}

uses
  Classes, SysUtils, Windows;

const
  //  IFDEF ELSE ENDIF ʱĴģʽ
  CN_RULE_DIRECTIVE_MODE_ASCOMMENT    = 1;
  {* עʹ}
  CN_RULE_DIRECTIVE_MODE_ONLYFIRST    = 2;
  {* ֻһ}
  CN_RULE_DIRECTIVE_MODE_DEFAULT      = CN_RULE_DIRECTIVE_MODE_ASCOMMENT;

  // ؼִСд
  CN_RULE_KEYWORD_STYLE_UPPER         = 1;
  {* ȫд}
  CN_RULE_KEYWORD_STYLE_LOWER         = 2;
  {* ȫСд}
  CN_RULE_KEYWORD_STYLE_UPPERFIRST    = 3;
  {* ĸд}
  CN_RULE_KEYWORD_STYLE_NOCHANGE      = 4;
  {*ıԭе}
  CN_RULE_KEYWORD_STYLE_DEFAULT       = CN_RULE_KEYWORD_STYLE_LOWER;

  // Begin 鿪ʼģʽ
  CN_RULE_BEGIN_STYLE_NEXTLINE        = 1;
  {* begin һ}
  CN_RULE_BEGIN_STYLE_SAMELINE        = 2;
  {* begin ڱ}
  CN_RULE_BEGIN_STYLE_DEFAULT         = CN_RULE_BEGIN_STYLE_NEXTLINE;

  // 뻻ģʽ
  CN_RULE_CODE_WRAP_MODE_NONE         = 1;
  {* Զ}
  CN_RULE_CODE_WRAP_MODE_SIMPLE       = 2;
  {* õ WrapWidth Զ}
  CN_RULE_CODE_WRAP_MODE_ADVANCED     = 3;
  {* õ WrapNewLineWidth   WrapWidth Զ}
  CN_RULE_CODE_WRAP_MODE_DEFAULT      = CN_RULE_CODE_WRAP_MODE_NONE;

  // Ĭո
  CN_RULE_TABSPACE_DEFAULT            = 2;

  // ˫ĿǰĬϿո
  CN_RULE_SPACE_BEFORE_OPERATOR       = 1;

  // ˫ĿĬϿո
  CN_RULE_SPACE_AFTER_OPERATOR        = 1;

  // ָĬ
  CN_RULE_SPACE_BEFORE_ASM            = 8;

  // ָ Tab 
  CN_RULE_SPACE_TAB_ASM               = 8;

  // Ĭϻг˿
  CN_RULE_LINE_WRAP_WIDTH             = 80;

  // Ĭϸ߼г˿
  CN_RULE_LINE_WRAP_NEWLINE_WIDTH     = 100;

  // ⲿָʼԪ
  CN_START_UNKNOWN_ALL                = 0;
  CN_START_USES                       = 1;
  CN_START_CONST                      = 2;
  CN_START_TYPE                       = 3;
  CN_START_VAR                        = 4;
  CN_START_PROC                       = 5;
  CN_START_STATEMENT                  = 6;

  // 
  CN_ERRCODE_OK                       = 0;
  CN_ERRCODE_START                    = 1;

  CN_ERRCODE_PASCAL_IDENT_EXP         = 1;
  CN_ERRCODE_PASCAL_STRING_EXP        = 2;
  CN_ERRCODE_PASCAL_NUMBER_EXP        = 3;
  CN_ERRCODE_PASCAL_CHAR_EXP          = 4;
  CN_ERRCODE_PASCAL_SYMBOL_EXP        = 5;
  CN_ERRCODE_PASCAL_PARSE_ERR         = 6;
  CN_ERRCODE_PASCAL_INVALID_BIN       = 7;
  CN_ERRCODE_PASCAL_INVALID_STRING    = 8;
  CN_ERRCODE_PASCAL_INVALID_BOOKMARK  = 9;
  CN_ERRCODE_PASCAL_LINE_TOOLONG      = 10;
  CN_ERRCODE_PASCAL_ENDCOMMENT_EXP    = 11;
  CN_ERRCODE_PASCAL_NOT_SUPPORT       = 12;

  CN_ERRCODE_PASCAL_ERROR_DIRECTIVE   = 13;
  CN_ERRCODE_PASCAL_NO_METHODHEADING  = 14;
  CN_ERRCODE_PASCAL_NO_STRUCTTYPE     = 15;
  CN_ERRCODE_PASCAL_NO_TYPEDCONSTANT  = 16;
  CN_ERRCODE_PASCAL_NO_EQUALCOLON     = 17;
  CN_ERRCODE_PASCAL_NO_DECLSECTION    = 18;
  CN_ERRCODE_PASCAL_NO_PROCFUNC       = 19;
  CN_ERRCODE_PASCAL_UNKNOWN_GOAL      = 20;
  CN_ERRCODE_PASCAL_ERROR_INTERFACE   = 21;
  CN_ERRCODE_PASCAL_INVALID_STATEMENT = 22;

  CN_ERRCODE_END                      = 22;

type
  ICnPascalFormatterIntf = interface
    ['{0CC0F874-227A-4516-9D17-6331EA86CBCA}']
    procedure SetPascalFormatRule(DirectiveMode: DWORD; KeywordStyle: DWORD;
      BeginStyle: DWORD; WrapMode: DWORD; TabSpace: DWORD; SpaceBeforeOperator: DWORD;
      SpaceAfterOperator: DWORD; SpaceBeforeAsm: DWORD; SpaceTabAsm: DWORD;
      LineWrapWidth: DWORD; NewLineWrapWidth: DWORD; UsesSingleLine: LongBool;
      UseIgnoreArea: LongBool; UsesLineWrapWidth: DWORD; KeepUserLineBreak: LongBool);
    {* øʽѡ}

    procedure SetPreIdentifierNames(Names: PLPSTR);
    {* ԤúõıʶСдãעָڴڸʽϺͷ}

    procedure SetInputLineMarks(Marks: PDWORD);
    {* ԴļӳϵеԴУǩϵʹá
       һ DWORD ķʽݣ0 β nil ʾ}

    function FormatOnePascalUnit(Input: PAnsiChar; Len: DWORD): PAnsiChar;
    {* ʽһ Pascal ļݣ AnsiString ʽ롣
       ؽ洢 AnsiString ַݵָ룬ͷš
        nil˵Ҫ RetrieveLastError ô}

    function FormatOnePascalUnitUtf8(Input: PAnsiChar; Len: DWORD): PAnsiChar;
    {* ʽһ Pascal ļݣ UTF8String ʽ롣
       ؽ洢 Utf8String ַݵָ룬ͷš
        nil˵Ҫ RetrieveLastError ô}

    function FormatOnePascalUnitW(Input: PWideChar; Len: DWORD): PWideChar;
    {* ʽһ Pascal ļݣ UnicodeString ʽ롣Len ַ
       ؽ洢 UnicodeString ַݵָ룬ͷš
        nil˵Ҫ RetrieveLastError ô}

    function FormatPascalBlock(Input: PAnsiChar; Len: DWORD; StartOffset: DWORD;
      EndOffset: DWORD): PAnsiChar;
    {* ʽһ飬 Pascal ļ AnsiString ʽ롣
       StartOffset  EndOffset Ǵļеƫ IDE еѡֱӻá
        Copy  Input лô StartOffset  EndOffset Ӧѡݡ
       ؽ洢 AnsiString ַݵָ룬ͷš
        nil˵Ҫ RetrieveLastError ô}

    function FormatPascalBlockUtf8(Input: PAnsiChar; Len: DWORD; StartOffset: DWORD;
      EndOffset: DWORD): PAnsiChar;
    {* ʽһ飬 Pascal ļ UTF8String ʽ롣
       StartOffset  EndOffset Ǵļе UTF8 ƫ IDE еѡֱӻá
        Copy  Input лô StartOffset  EndOffset Ӧѡ Utf8ݡ
       ؽ洢 Utf8String ַݵָ룬ͷš
        nil˵Ҫ RetrieveLastError ô}

    function FormatPascalBlockW(Input: PWideChar; Len: DWORD; StartOffset: DWORD;
      EndOffset: DWORD): PWideChar;
    {* ʽһ飬 Pascal ļ UnicodeString ʽ롣Len ַ
       StartOffset  EndOffset Ǵļе Unicode ַƫ
       ɴ IDE еѡֱӻãҪһ Utf8 תܴ롣
        Copy  Input лô StartOffset  EndOffset Ӧѡ Unicode ݡ
       ؽ洢 UnicodeString ַݵָ룬ͷš
        nil˵Ҫ RetrieveLastError ô}

    function RetrieveOutputLinkMarks: PDWORD;
    {* ȡԴļӳϵеĿУʽϺǩϵʹá
       һ DWORD ָķʽݣ0 β߲ͷŴڴ}

    function RetrievePascalLastError(out SourceLine: Integer; out SourceCol: Integer;
      out SourcePos: Integer; out CurrentToken: PAnsiChar): Integer;
    {* ȡԼʱĴƫԼʱĵǰ Token
       CurrentToken ӦƳʹãͷ}
  end;

  TCnGetFormatterProvider = function: ICnPascalFormatterIntf; stdcall;
  {* DLL ĺ}

implementation

end.
