{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2025 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnFrmAICoderOption;
{ |<PRE>
================================================================================
* ƣCnPack IDE רҰ
* ԪƣAI ѡ Frame Ԫ
* ԪߣCnPack 
*     ע
* ƽ̨PWin7 + Delphi 5
* ݲԣPWin7/10/11 + Delphi + C++Builder
*   ôеַݲֱ֧ػʽ
* ޸ļ¼2024.05.09 V1.0
*               Ԫ
================================================================================
|</PRE>}

interface

{$I CnWizards.inc}

uses 
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, TypInfo, Contnrs, CnCommon, CnWizMultiLangFrame, CnAICoderConfig;

const
  WM_CALCEXTRA = WM_USER + $1234;
  WM_BUILDEXTRA = WM_USER + $1235;

type
  TCnAICoderOptionFrame = class(TCnTranslateFrame)
    lblURL: TLabel;
    lblAPIKey: TLabel;
    edtURL: TEdit;
    edtAPIKey: TEdit;
    lblModel: TLabel;
    lblApply: TLabel;
    cbbModel: TComboBox;
    procedure lblApplyClick(Sender: TObject);
  private
    FWebAddr: string;
    FExtraBuilt: Boolean;
    FExtraOptions: TObjectList;        // ɶѡб
    FVerticalDistance: Integer;        // ѡ Top 
    FVerticalLabelStart: Integer;      // ѡ Label ؼʼ
    FVerticalEditStart: Integer;       // ѡ Edit ؼʼ
    FHoriLabelStart: Integer;          // ѡ Label ؼʼ
    FHoriEditStart: Integer;           // ѡ Edit ؼʼ
    procedure CalcExtraPositions;      // Ϊ׼ HDPI Ӱ
  protected
    procedure OnBuildExtra(var Msg: TMessage); message WM_BUILDEXTRA;
    procedure CreateWnd; override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;

    procedure RegisterExtraOption(AnOption: TCnAIEngineOption;
      const AName: string; AType: TTypeKind);
    {* ⲿעҪõԣö}
    procedure BuildExtraOptionElements;
    {* ⲿעĶԣý棬ıͱ༭}
    procedure SaveExtraOptions;
    {* ⲿȥ}

    property WebAddr: string read FWebAddr write FWebAddr;
  end;

implementation

{$R *.DFM}


uses
  CnWizOptions, CnWizIdeUtils {$IFDEF DEBUG}, CnDebug {$ENDIF};

const
  CN_AI_CODER_SUPPORT_TYPES: TTypeKinds = [tkInteger, tkFloat, tkString];

type
  TCnAIExtraItem = class
  private
    FOptionName: string;
    FOptionType: TTypeKind;
    FOption: TCnAIEngineOption;
  public
    function GetStringValue: string;

    property Option: TCnAIEngineOption read FOption write FOption;
    {* ѡӦѡʵ}
    property OptionName: string read FOptionName write FOptionName;
    {* ѡ}
    property OptionType: TTypeKind read FOptionType write FOptionType;
    {* ѡֻ֧ͣ tkInteger, tkFloat, tkString }
  end;

procedure TCnAICoderOptionFrame.BuildExtraOptionElements;
begin
{$IFDEF DEBUG}
  CnDebugger.LogMsg('TCnAICoderOptionFrame BuildExtraOptionElements to Post');
{$ENDIF}
  // ߰汾ƺΪ Handle ´֮ԭղϢ
  PostMessage(Self.Handle, WM_BUILDEXTRA, 0, 0);
end;

procedure TCnAICoderOptionFrame.CalcExtraPositions;
begin
  // ע˴Ļʵʳߴ磬 HDPI 
  FVerticalDistance := lblAPIKey.Top - lblModel.Top;
  FVerticalLabelStart := lblAPIKey.Top + FVerticalDistance;
  FVerticalEditStart := edtAPIKey.Top + FVerticalDistance;
  FHoriEditStart := edtAPIKey.Left;
  FHoriLabelStart := lblAPIKey.Left;
end;

constructor TCnAICoderOptionFrame.Create(AOwner: TComponent);
begin
  inherited;
  FExtraOptions := TObjectList.Create(True);
end;

procedure TCnAICoderOptionFrame.CreateWnd;
begin
  inherited;
  PostMessage(Self.Handle, WM_BUILDEXTRA, 0, 0);
  //  Post һαʧЧϢڲش
end;

destructor TCnAICoderOptionFrame.Destroy;
begin
  FExtraOptions.Free;
  inherited;
end;

procedure TCnAICoderOptionFrame.lblApplyClick(Sender: TObject);
begin
  if FWebAddr <> '' then
    OpenUrl(FWebAddr);
end;

procedure TCnAICoderOptionFrame.OnBuildExtra(var Msg: TMessage);
var
  I: Integer;
  Lbl: TLabel;
  Edt: TEdit;
  Item: TCnAIExtraItem;
begin
  if FExtraBuilt then // ֹظ
    Exit;

{$IFDEF DEBUG}
  CnDebugger.LogMsg('TCnAICoderOptionFrame OnBuildExtra ' + IntToStr(FExtraOptions.Count));
{$ENDIF}

  if FExtraOptions.Count = 0 then
    Exit;

  CalcExtraPositions;

  for I := 0 to FExtraOptions.Count - 1 do
  begin
    Item := TCnAIExtraItem(FExtraOptions[I]);
    Lbl := TLabel.Create(Self);
{$IFDEF IDE_SUPPORT_HDPI}
    Lbl.Left := Trunc(FHoriLabelStart / IdeGetScaledFactor);
    Lbl.Top := Trunc((FVerticalLabelStart + I * FVerticalDistance) / IdeGetScaledFactor);
{$ELSE}
    Lbl.Left := FHoriLabelStart;
    Lbl.Top := FVerticalLabelStart + I * FVerticalDistance;
{$ENDIF}
    if (WizOptions.CurrentLangID = 2052) or (WizOptions.CurrentLangID = 1028) then
      Lbl.Caption := Item.OptionName + ''
    else
      Lbl.Caption := Item.OptionName + ':';
    Lbl.Parent := Self;

    Edt := TEdit.Create(Self);
{$IFDEF IDE_SUPPORT_HDPI}
    Edt.Left := Trunc(FHoriEditStart / IdeGetScaledFactor);;
    Edt.Top := Trunc((FVerticalEditStart + I * FVerticalDistance) / IdeGetScaledFactor);;
    Edt.Width := Trunc(edtURL.Width / IdeGetScaledFactor);;
{$ELSE}
    Edt.Left := FHoriEditStart;
    Edt.Top := FVerticalEditStart + I * FVerticalDistance;
    Edt.Width := edtURL.Width;
{$ENDIF}
    Edt.Name := 'edt' + Item.OptionName;
    Edt.Text := Item.GetStringValue;
    // Edt.Anchors := [akLeft, akTop, akRight];
    Edt.Parent := Self;
  end;
  lblApply.Top := lblApply.Top + FExtraOptions.Count * FVerticalDistance;

  FExtraBuilt := True;
end;

procedure TCnAICoderOptionFrame.RegisterExtraOption(AnOption: TCnAIEngineOption;
  const AName: string; AType: TTypeKind);
var
  Item: TCnAIExtraItem;
begin
  if (AnOption = nil) or (AName = '') then
    Exit;

  if not (AType in CN_AI_CODER_SUPPORT_TYPES) then
    Exit;

{$IFDEF DEBUG}
  CnDebugger.LogMsg('TCnAICoderOptionFrame RegisterExtraOption ' + AName);
{$ENDIF}

  Item := TCnAIExtraItem.Create;
  Item.Option := AnOption;
  Item.OptionName := AName;
  Item.OptionType := AType;

  FExtraOptions.Add(Item);
end;

{ TCnAIExtraItem }

function TCnAIExtraItem.GetStringValue: string;
var
  P: PPropInfo;
begin
  Result := '';
  //  Option Ϊ OptionName Բ
  if FOption <> nil then
  begin
    case FOptionType of
      tkInteger: Result := IntToStr(GetOrdProp(FOption, FOptionName));
      tkFloat: Result := FloatToStr(GetFloatProp(FOption, FOptionName));
      tkString: Result := GetStrProp(FOption, FOptionName);
    end;
  end;
end;

procedure TCnAICoderOptionFrame.SaveExtraOptions;
var
  I: Integer;
  Edt: TEdit;
  S: string;
  Item: TCnAIExtraItem;
begin
  // ע OptionNamesӦ༭ضȥ
  for I := 0 to FExtraOptions.Count - 1 do
  begin
    Item := TCnAIExtraItem(FExtraOptions[I]);
    S := 'edt' + Item.OptionName;
    Edt := TEdit(FindComponent(S));
    if Edt <> nil then
    begin
      S := Edt.Text;
      try
        case Item.OptionType of
          tkInteger: SetOrdProp(Item.Option, Item.OptionName, StrToInt(S));
          tkFloat: SetFloatProp(Item.Option, Item.OptionName, StrToFloat(S));
          tkString: SetStrProp(Item.Option, Item.OptionName, S);
        end;
      except
        Application.HandleException(Application);
      end;
    end;
  end;
end;

end.
