{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2025 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttps://www.cnpack.org                                  }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnAICoderConfig;
{ |<PRE>
================================================================================
* ƣCnPack IDE רҰ
* ԪƣAI רҵô洢뵥Ԫ
* ԪߣCnPack 
*     עCnAIEngineOptionManager  TCnAIEngineOption ĸ洢ӿӦ
*           CnAIEngineManager ͳһãطӦҵãΪ漰ļ
*           Ŀǰ AI ͨôһļÿ AI Ҳһ
*           ļ
* ƽ̨PWin7 + Delphi 5.01
* ݲԣPWin9X/2000/XP + Delphi 5/6/7 + C++Builder 5/6
*   ôеַݲֱ֧ػʽ
* ޸ļ¼2024.04.30 V1.0
*               Ԫ
================================================================================
|</PRE>}

interface

{$I CnWizards.inc}

{$IFDEF CNWIZARDS_CNAICODERWIZARD}

uses
  SysUtils, Classes, Contnrs, TypInfo, CnJSON, CnNative, CnWizConsts,
  CnWizCompilerConst {$IFNDEF TEST_APP} , CnWizMultiLang {$ENDIF};

type
  TCnAIEngineOption = class(TPersistent)
  {* һ AI ࣬δҪչ͵ԣֻ published 
    ֱӿɶдԼɣ¾ĬֵݲҲʧû}
  private
    FURL: string;
    FApiKey: string;
    FModel: string;
    FEngineName: string;
    FTemperature: Extended;
    FWebAddress: string;
    FModelList: string;
    function GetExplainCodePrompt: string;
    function GetSystemMessage: string;
    function GetReviewCodePrompt: string;
  protected
    function GetCurrentLangName: string;
    // SM4-GCM ʮƼӽ
    function EncryptKey(const Key: string): string;
    function DecryptKey(const Text: string): string;
  public
    constructor Create; virtual;
    destructor Destroy; override;

    // ⲿʾֶεıͱ༭עҪ published ĶԶӦ
    function GetExtraOptionCount: Integer; virtual;
    function GetExtraOptionName(Index: Integer): string; virtual;
    function GetExtraOptionType(Index: Integer): TTypeKind; virtual;

    procedure AssignToEmpty(Dest: TCnAIEngineOption);
    {* ԴԷǿĿԿʱֵӵɰ汾Ժϲ}

    procedure LoadFromJSON(const JSON: AnsiString);
    {*  UTF8 ʽ JSON ַмһѡʵõ}
    function SaveToJSON: AnsiString;
    {* ѡʵ UTF8 ʽ JSON ַ}

    property SystemMessage: string read GetSystemMessage;
    {* ϵͳԤϢ}
    property ExplainCodePrompt: string read GetExplainCodePrompt;
    {* ʹʾ}
    property ReviewCodePrompt: string read GetReviewCodePrompt;
    {* ʾ}
  published
    property EngineName: string read FEngineName write FEngineName;
    {* AI }

    property URL: string read FURL write FURL;
    {* ַ}
    property ApiKey: string read FApiKey write FApiKey;
    {* õȨ룬洢ʱ}
    property Model: string read FModel write FModel;
    {* ģ}
    property Temperature: Extended read FTemperature write FTemperature;
    {* ¶Ȳ}
    property ModelList: string read FModelList write FModelList;
    {* õģбǶŷָ}

    property WebAddress: string read FWebAddress write FWebAddress;
    {*  APIKEY ַ}
  end;

  TCnAIEngineOptionClass = class of TCnAIEngineOption;

  TCnClaudeAIEngineOption = class(TCnAIEngineOption)
  {*  Claude רõ˼ѡ}
  private
    FAnthropicVersion: string;
    FMaxTokens: Integer;
  public
    constructor Create; override;
    destructor Destroy; override;

    // עⱾϻ published  2 ԣط
    function GetExtraOptionCount: Integer; override;
    function GetExtraOptionName(Index: Integer): string; override;
    function GetExtraOptionType(Index: Integer): TTypeKind; override;
  published
    property MaxTokens: Integer read FMaxTokens write FMaxTokens;
    {*  Token Claude 룬Ĭ}
    property AnthropicVersion: string read FAnthropicVersion write FAnthropicVersion;
    {* Claude İ汾}
  end;

  TCnAIEngineOptionManager = class(TPersistent)
  {* AI ù࣬в TCnAIEngineOption ˳ EngineManager һ}
  private
    FOptions: TObjectList; // ɶ TCnAIEngineOption 󣬿
    FActiveEngine: string;
    FProxyServer: string;
    FProxyUserName: string;
    FProxyPassword: string;
    FUseProxy: Boolean;
    FChatFontStr: string;
    FTimeoutSec: Cardinal;
    function GetOptionCount: Integer;
    function GetOption(Index: Integer): TCnAIEngineOption;
  public
    constructor Create; virtual;
    destructor Destroy; override;

    procedure Clear;

    function GetOptionByEngine(const EngineName: string): TCnAIEngineOption;
    {* ҶӦö}
    procedure RemoveOptionByEngine(const EngineName: string);
    {* ɾӦö}

    procedure AddOption(Option: TCnAIEngineOption);
    {* һ紴úõ AI öڲж EngineName Ƿظ}

    procedure LoadFromFile(const FileName: string);
    {*  JSON ļмػ}
    procedure SaveToFile(const FileName: string);
    {* ñ JSON ļ}

    procedure LoadFromJSON(const JSON: AnsiString);
    {*  UTF8 ʽ JSON ַмػ}
    function SaveToJSON: AnsiString;
    {*  UTF8 ʽ JSON ַ}

    function CreateOptionFromFile(const EngineName, FileName: string;
      OptionClass: TCnAIEngineOptionClass = nil; Managed: Boolean = True): TCnAIEngineOption;
    {* ָļָ OptionClass һ Option ʵ
       Managed Ϊ True ӵйΪ}
    procedure SaveOptionToFile(const EngineName, FileName: string);
    {* ָƵӦ Option ʵָļ}

    property OptionCount: Integer read GetOptionCount;
    {* еö}
    property Options[Index: Integer]: TCnAIEngineOption read GetOption;
    {* ŻȡеĶ}
  published
    property ChatFontStr: string read FChatFontStr write FChatFontStr;
    {* 촰ڵ}

    property ActiveEngine: string read FActiveEngine write FActiveEngine;
    {* ƣ洢û棬á}

    property TimeoutSec: Cardinal read FTimeoutSec write FTimeoutSec;
    {* 糬ʱ0 ΪϵͳĬ}

    property UseProxy: Boolean read FUseProxy write FUseProxy;
    {* Ƿʹôʾֱǵ FProxyServer Ϊգʾʹϵͳ}
    property ProxyServer: string read FProxyServer write FProxyServer;
    {* HTTP(s) Ĵձʾֱ}
    property ProxyUserName: string read FProxyUserName write FProxyUserName;
    {* û}
    property ProxyPassword: string read FProxyPassword write FProxyPassword;
    {* }
  end;

function CnAIEngineOptionManager: TCnAIEngineOptionManager;
{* һȫֵ AI ù}

{$ENDIF CNWIZARDS_CNAICODERWIZARD}

implementation

{$IFDEF CNWIZARDS_CNAICODERWIZARD}

uses
  CnSM4, CnAEAD;

const
  SM4_KEY: TCnSM4Key = ($43, $6E, $50, $61, $63, $6B, $20, $41, $49, $20, $43, $72, $79, $70, $74, $21);
  SM4_IV: TCnSM4Iv   = ($18, $40, $19, $21, $19, $31, $19, $37, $19, $45, $19, $49, $19, $53, $19, $78);
  SM4_AD: AnsiString = 'CnPack';

var
  FAIEngineOptionManager: TCnAIEngineOptionManager = nil;

function CnAIEngineOptionManager: TCnAIEngineOptionManager;
begin
  if FAIEngineOptionManager = nil then
    FAIEngineOptionManager := TCnAIEngineOptionManager.Create;
  Result := FAIEngineOptionManager;
end;

{ TCnAIEngineOptionManager }

procedure TCnAIEngineOptionManager.AddOption(Option: TCnAIEngineOption);
begin
  if (Option.EngineName = '') or (GetOptionByEngine(Option.EngineName) <> nil) then
    Exit;

  FOptions.Add(Option);
end;

procedure TCnAIEngineOptionManager.Clear;
begin
  FOptions.Clear;
end;

constructor TCnAIEngineOptionManager.Create;
begin
  inherited;
  FOptions := TObjectList.Create(True);
end;

function TCnAIEngineOptionManager.CreateOptionFromFile(const EngineName,
  FileName: string; OptionClass: TCnAIEngineOptionClass;
  Managed: Boolean): TCnAIEngineOption;
begin
  if OptionClass = nil then
    Result := TCnAIEngineOption.Create
  else
  begin
    try
      Result := TCnAIEngineOption(OptionClass.NewInstance);
      Result.Create;
    except
      Result := nil;
    end;
  end;

  // 쳣˾ͻ´
  if Result = nil then
    Result := TCnAIEngineOption.Create;

  if FileExists(FileName) then
    Result.LoadFromJSON(TCnJSONReader.FileToJSON(FileName));

  Result.EngineName := EngineName;

  if Managed then
    AddOption(Result);
end;

destructor TCnAIEngineOptionManager.Destroy;
begin
  FOptions.Free;
  inherited;
end;

function TCnAIEngineOptionManager.GetOption(Index: Integer): TCnAIEngineOption;
begin
  Result := TCnAIEngineOption(FOptions[Index]);
end;

function TCnAIEngineOptionManager.GetOptionByEngine(const EngineName: string): TCnAIEngineOption;
var
  I: Integer;
begin
  for I := 0 to FOptions.Count - 1 do
  begin
    if EngineName = TCnAIEngineOption(FOptions[I]).EngineName then
    begin
      Result := TCnAIEngineOption(FOptions[I]);
      Exit;
    end;
  end;
  Result := nil;
end;

function TCnAIEngineOptionManager.GetOptionCount: Integer;
begin
  Result := FOptions.Count;
end;

procedure TCnAIEngineOptionManager.LoadFromFile(const FileName: string);
begin
  LoadFromJSON(TCnJSONReader.FileToJSON(FileName));
end;

procedure TCnAIEngineOptionManager.LoadFromJSON(const JSON: AnsiString);
var
  Root: TCnJSONObject;
begin
  Root := CnJSONParse(JSON);
  if Root = nil then
    Exit;

  try
    TCnJSONReader.Read(Self, Root);
  finally
    Root.Free;
  end;
end;

procedure TCnAIEngineOptionManager.RemoveOptionByEngine(const EngineName: string);
var
  I: Integer;
begin
  for I := FOptions.Count - 1 downto 0 do
  begin
    if EngineName = TCnAIEngineOption(FOptions[I]).EngineName then
      FOptions.Delete(I);
  end;
end;

procedure TCnAIEngineOptionManager.SaveOptionToFile(const EngineName,
  FileName: string);
var
  Option: TCnAIEngineOption;
begin
  Option := GetOptionByEngine(EngineName);

  // ûѡͲ
  if Option <> nil then
    TCnJSONWriter.JSONToFile(Option.SaveToJSON, FileName);
end;

procedure TCnAIEngineOptionManager.SaveToFile(const FileName: string);
begin
  TCnJSONWriter.JSONToFile(SaveToJSON, FileName);
end;

function TCnAIEngineOptionManager.SaveToJSON: AnsiString;
var
  Root: TCnJSONObject;
begin
  Root := TCnJSONObject.Create;
  try
    TCnJSONWriter.Write(Self, Root);
    Result := CnJSONConstruct(Root);
  finally
    Root.Free;
  end;
end;

{ TCnAIEngineOption }

constructor TCnAIEngineOption.Create;
begin
  inherited;
  FTemperature := 0.3; // Ĭֵ
end;

destructor TCnAIEngineOption.Destroy;
begin

  inherited;
end;

function TCnAIEngineOption.GetCurrentLangName: string;
begin
  Result := '';
{$IFNDEF TEST_APP}
  if CnWizLangMgr.LanguageStorage <> nil then
    if CnWizLangMgr.LanguageStorage.CurrentLanguage <> nil then
      if CnWizLangMgr.LanguageStorage.CurrentLanguage.LanguageName <> '' then
        Result := CnWizLangMgr.LanguageStorage.CurrentLanguage.LanguageName;
{$ENDIF}
end;

function TCnAIEngineOption.EncryptKey(const Key: string): string;
var
  K, Iv, AD: TBytes;
begin
  if Key = '' then
  begin
    Result := '';
    Exit;
  end;

  SetLength(K, SizeOf(SM4_KEY));
  Move(SM4_KEY[0], K[0], SizeOf(SM4_KEY));

  SetLength(Iv, SizeOf(SM4_IV));
  Move(SM4_IV[0], Iv[0], SizeOf(SM4_Iv));

  SetLength(AD, Length(SM4_AD));
  Move(SM4_AD[1], AD[0], Length(AD));

  Result := SM4GCMEncryptToHex(K, Iv, AD, AnsiToBytes(Key));
end;

function TCnAIEngineOption.DecryptKey(const Text: string): string;
var
  K, Iv, AD, Res: TBytes;
begin
  if Text = '' then
  begin
    Result := '';
    Exit;
  end;

  SetLength(K, SizeOf(SM4_KEY));
  Move(SM4_KEY[0], K[0], SizeOf(SM4_KEY));

  SetLength(Iv, SizeOf(SM4_IV));
  Move(SM4_IV[0], Iv[0], SizeOf(SM4_Iv));

  SetLength(AD, Length(SM4_AD));
  Move(SM4_AD[1], AD[0], Length(AD));

  Res := SM4GCMDecryptFromHex(K, Iv, AD, Text);
  Result := BytesToString(Res);
end;

function TCnAIEngineOption.GetExplainCodePrompt: string;
begin
  Result := Format(SCNAICoderWizardUserMessageExplainFmt, [GetCurrentLangName]);
end;

function TCnAIEngineOption.GetReviewCodePrompt: string;
begin
  Result := Format(SCNAICoderWizardUserMessageReviewFmt, [GetCurrentLangName]);
end;

function TCnAIEngineOption.GetSystemMessage: string;
begin
  Result := Format(SCNAICoderWizardSystemMessageFmt, [CompilerName]);
end;

procedure TCnAIEngineOption.LoadFromJSON(const JSON: AnsiString);
var
  Root: TCnJSONObject;
begin
  Root := CnJSONParse(JSON);
  if Root = nil then
    Exit;

  try
    TCnJSONReader.Read(Self, Root);
  finally
    Root.Free;
  end;

  ApiKey := DecryptKey(ApiKey);
end;

function TCnAIEngineOption.SaveToJSON: AnsiString;
var
  Root: TCnJSONObject;
  PlainKey: string;
begin
  Root := TCnJSONObject.Create;
  try
    PlainKey := ApiKey;
    try
      // ԭؼ APIKey
      ApiKey := EncryptKey(ApiKey);
      TCnJSONWriter.Write(Self, Root);
    finally
      // ڴٻԭ
      ApiKey := PlainKey;
    end;

    Result := CnJSONConstruct(Root);
  finally
    Root.Free;
  end;
end;

procedure TCnAIEngineOption.AssignToEmpty(Dest: TCnAIEngineOption);
var
  Count: Integer;
  PropIdx: Integer;
  PropList: PPropList;
  PropInfo: PPropInfo;
  AKind: TTypeKind;
  VI, VI1: Integer;
  VE, VE1: Extended;
  VS, VS1: string;
  V64, V641: Int64;
begin
  Count := GetPropList(Self.ClassInfo, tkProperties - [tkArray, tkRecord,
    tkInterface], nil);
  if Count <= 0 then
    Exit;

  GetMem(PropList, Count * SizeOf(Pointer));
  try
    GetPropList(Self.ClassInfo, tkProperties - [tkArray, tkRecord,
      tkInterface], @PropList^[0]);

    for PropIdx := 0 to Count - 1 do
    begin
      PropInfo := PropList^[PropIdx];
      if PropInfo^.SetProc = nil then // Բд
        Continue;

      AKind := PropInfo^.PropType^^.Kind;
      case AKind of
        tkInteger, tkChar, tkWChar, tkClass, tkEnumeration, tkSet:
          begin
            VI := GetOrdProp(Self, PropInfo);    // Դ 0Ŀ 0Ÿֵ
            if VI <> 0 then
            begin
              VI1 := GetOrdProp(Dest, PropInfo);
              if VI1 = 0 then
                SetOrdProp(Dest, PropInfo, VI);
            end;
          end;
        tkFloat:
          begin
            VE := GetFloatProp(Self, PropInfo);  // Դ 0Ŀ 0Ÿֵ
            if VE <> 0 then
            begin
              VE1 := GetOrdProp(Dest, PropInfo);
              if VE1 = 0.0 then
                SetFloatProp(Dest, PropInfo, VE);
            end;
          end;
        tkString, tkLString, tkWString{$IFDEF UNICODE}, tkUString{$ENDIF}:
          begin
            VS := GetStrProp(Self, PropInfo);    // ԴǿգĿգŸֵ
            if VS <> '' then
            begin
              VS1 := GetStrProp(Dest, PropInfo);
              if VS1 = '' then
                SetStrProp(Dest, PropInfo, VS);
            end;
          end;
        tkInt64:
          begin
            V64 := GetInt64Prop(Self, PropInfo);  // Դ 0Ŀ 0Ÿֵ
            if V64 <> 0 then
            begin
              V641 := GetInt64Prop(Dest, PropInfo);
              if V641 = 0 then
                SetInt64Prop(Dest, PropInfo, V64);
            end;
          end;
      end;
    end;
  finally
    FreeMem(PropList);
  end;
end;

function TCnAIEngineOption.GetExtraOptionCount: Integer;
begin
  Result := 0;
end;

function TCnAIEngineOption.GetExtraOptionName(Index: Integer): string;
begin
  Result := '';
end;

function TCnAIEngineOption.GetExtraOptionType(Index: Integer): TTypeKind;
begin
  Result := tkUnknown;
end;

{ TCnClaudeAIEngineOption }

constructor TCnClaudeAIEngineOption.Create;
begin
  inherited;
  Temperature := 1.0;
  AnthropicVersion := '2023-06-01';
  MaxTokens := 4096;
end;

destructor TCnClaudeAIEngineOption.Destroy;
begin

  inherited;
end;

function TCnClaudeAIEngineOption.GetExtraOptionCount: Integer;
begin
  Result := 2;
end;

function TCnClaudeAIEngineOption.GetExtraOptionName(
  Index: Integer): string;
begin
  case Index of
    0: Result := 'MaxTokens';
    1: Result := 'AnthropicVersion';
  else
    Result := '';
  end;
end;

function TCnClaudeAIEngineOption.GetExtraOptionType(
  Index: Integer): TTypeKind;
begin
  case Index of
    0: Result := tkInteger;
    1: Result := tkString;
  else
    Result := tkUnknown;
  end;
end;

initialization

finalization
  FAIEngineOptionManager.Free;

{$ENDIF CNWIZARDS_CNAICODERWIZARD}
end.
