{*******************************************************}
{                                                       }
{       Pascal Script Source File                       }
{       Run by RemObjects Pascal Script in CnWizards    }
{                                                       }
{       Generated by CnPack IDE Wizards                 }
{                                                       }
{*******************************************************}

program ToolPalette;

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

const
  TOOL_PALETTE_FORM = 'TToolForm';
  PALETTE_NAME = 'Palette';
  CATEGORIES_PROPNAME = 'Categories';
  ITEMS_PROPNAME = 'Items';
  CAPTION_PROPNAME = 'Caption';

var
  I, J: Integer;
  Obj: TObject;
  ToolForm: TCustomForm;
  Palette: TComponent;
  Categories: TCollection;
  Category: TCollectionItem;
  ComponentButtons: TCollection;
  ComponentButton: TCollectionItem;
begin
  ToolForm := nil;
  for I := 0 to Screen.CustomFormCount - 1 do
  begin
    if Screen.CustomForms[I].ClassNameIs(TOOL_PALETTE_FORM) then
    begin
      ToolForm := Screen.CustomForms[I];
      Break;
    end;
  end;

  if ToolForm = nil then
  begin
    ErrorDlg('No ToolForm Found.');
    Exit;
  end;

  Palette := ToolForm.FindComponent(PALETTE_NAME);
  if Palette = nil then
  begin
    ErrorDlg('No Palette Found.');
    Exit;
  end;

  Obj := GetObjectProp(Palette, CATEGORIES_PROPNAME);
  if (Obj = nil) or not (Obj is TCollection) then
  begin
    ErrorDlg('No Categories Found.');
    Exit;
  end;
  Categories := TCollection(Obj);

  for I := 0 to Categories.Count - 1 do
  begin
    Category := Categories.Items[I];
    Writeln(GetStrProp(Category, CAPTION_PROPNAME));

    Obj := GetObjectProp(Category, ITEMS_PROPNAME);
    if (Obj = nil) or not (Obj is TCollection) then
      Continue;

    ComponentButtons := TCollection(Obj);
    for J := 0 to ComponentButtons.Count - 1 do
    begin
      ComponentButton := ComponentButtons.Items[J];
      Writeln('  ' + GetStrProp(ComponentButton, CAPTION_PROPNAME));
    end;
    Writeln('');
  end;
end.

