{*******************************************************}
{                                                       }
{       Pascal Script Source File                       }
{       Run by RemObjects Pascal Script in CnWizards    }
{                                                       }
{       Generated by CnPack IDE Wizards                 }
{                                                       }
{*******************************************************}

program ObjectInspector;

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

var
  ObjectInspectorForm: TCustomForm;
  PropList, EditControl: TComponent;
  F: TObject;
begin
  ObjectInspectorForm := GetObjectInspectorForm;
  if ObjectInspectorForm = nil then
  begin
    Writeln('ObjectInspector NOT Found.');
    Exit;
  end;

  PropList := ObjectInspectorForm.FindComponent('PropList');
  if (PropList = nil) or not PropList.ClassNameIs('TInspListBox') then
  begin
    Writeln('PropList NOT Found.');
    Exit;
  end;

  EditControl := PropList.FindComponent('EditControl');
  if (EditControl = nil) or not EditControl.ClassNameIs('TPropInspEdit') then
  begin
    Writeln('EditControl NOT Found.');
    Exit;
  end;

  if EditControl is TEdit then
  begin
    Writeln('Current Selected Property Value is: ' + TEdit(EditControl).Text);
  end;

  // Զ Object Inspector бĿ߶ֳߴ
  if PropList is TCustomListBox then
  begin
    if QueryDlg('Do you want to Enlarge Object Inspector List Size?', True) then
    begin
      SetPropValue(PropList, 'ItemHeight', 50);
      F := GetObjectProp(PropList, 'Font');
      if (F <> nil) and (F is TFont) then
        TFont(F).Size := 14;
    end;
  end;
end.
 
