{*******************************************************}
{                                                       }
{       Pascal Script Source File                       }
{       Run by RemObjects Pascal Script in CnWizards    }
{                                                       }
{       Generated by CnPack IDE Wizards                 }
{                                                       }
{*******************************************************}

program FormDemo1;

uses
  Windows, SysUtils, Classes, StdCtrls, ExtCtrls, Forms;

var
  Form: TForm;

function CreateButton(Parent: TForm; Name: string; Left, Top: Integer;
  Caption: string): TButton;
begin
  Result := TButton.Create(Parent);
  Result.Name := Name;
  Result.Parent := Parent;
  Result.Left := Left;
  Result.Top := Top;
  Result.Caption := Caption;
end;

function CreateEdit(Parent: TForm; Name: string; Left, Top: Integer;
  Text: string): TEdit;
begin
  Result := TEdit.Create(Parent);
  Result.Name := Name;
  Result.Parent := Parent;
  Result.Left := Left;
  Result.Top := Top;
  Result.Text := Text;
end;

procedure edtMsgKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #13 then
  begin
    Key := #0;
    TButton(Form.FindComponent('btnOk')).SetFocus;
  end;
end;

procedure btnOkClick(Sender: TObject);
begin
  Form.ModalResult := mrOk;
end;

procedure btnCancelClick(Sender: TObject);
begin
  Form.ModalResult := mrCancel;
end;

begin
  Form := TForm.Create(nil);
  try
    Form.BorderStyle := bsSizeToolWin;
    Form.SetBounds(100, 100, 400, 300);
    Form.Position := poScreenCenter;
    Form.Caption := 'Form Demo1';
    CreateEdit(Form, 'edtMsg', 20, 20, '').OnKeyPress := @edtMsgKeyPress;
    CreateButton(Form, 'btnOk', 20, 60, '&Ok').OnClick := @btnOkClick;
    CreateButton(Form, 'btnCancel', 100, 60, '&Cancel').OnClick := @btnCancelClick;
    case Form.ShowModal of
      mrOk: Application.MessageBox('Input text:' + #13#10#13#10 +
          TEdit(Form.FindComponent('edtMsg')).Text, 'Script', MB_OK + MB_ICONINFORMATION);
      mrCancel: Application.MessageBox('You click Cancel', 'Script', MB_OK + MB_ICONERROR);
    else
      Application.MessageBox('Others', 'Script', MB_OK + MB_ICONERROR);
    end;
  finally
    Form.Free;
  end;
end.
