{*******************************************************}
{                                                       }
{       Pascal Script Source File                       }
{       Run by RemObjects Pascal Script in CnWizards    }
{                                                       }
{       Generated by CnPack IDE Wizards                 }
{                                                       }
{*******************************************************}

program EditorTab;

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

var
  EditWindow: TCustomForm;
  TabControl: TControl;
  Tab: TTabControl;
  TabControlClassName: string;
  Tabs: TStrings;
begin
  EditWindow := CnOtaGetCurrentEditWindow;
  if EditWindow = nil then
  begin
    ErrorDlg('NO Editor Window Found');
    Exit;
  end;

  if (Compiler = cnDelphi5) or (Compiler = cnDelphi6) or (Compiler = cnDelphi7)
    or (Compiler = cnBCB5) or (Compiler = cnBCB6) then
     TabControlClassName := 'TXTabControl'
  else if (Compiler = cnDelphi9) then // BDS 2005
     TabControlClassName := 'TCodeEditorTabControl'
  else // BDS 2006/2007/2009 and above
     TabControlClassName := 'TIDEGradientTabSet';

  TabControl := TControl(FindComponentByClassName(EditWindow, TabControlClassName, 'TabControl'));
  if TabControl = nil then
  begin
    ErrorDlg('NO Tab Found');
    Exit;
  end;
  cndebugger.evaluateobject(tabcontrol);
  // Change Multi Line Style in D7 or below.
  if (Compiler = cnDelphi5) or (Compiler = cnDelphi6) or (Compiler = cnDelphi7)
    or (Compiler = cnBCB5) or (Compiler = cnBCB6) then
  begin
    if TabControl is TTabControl then
    begin
      Tab := TTabControl(TabControl);
      Tab.MultiLine := not Tab.MultiLine;
      ShowMessage('TabControl Multi-Line Changed.');
    end
    else
      ShowMessage('Not TabControl. Can NOT change Multi-Line.');
  end
  else
  begin
    if Compiler = cnDelphi9 then
      Tabs := TStrings(GetObjectProp(TabControl, 'Tabs'))
    else
      Tabs := TStrings(GetObjectProp(TabControl, 'Items'));

    if Tabs = nil then
    begin
      ErrorDlg('No Tabs Property');
      Exit;
    end;

    ShowMessage(Tabs.Text);
    if Tabs.Count > 0 then
      Tabs[0] := 'Test Caption from Script.';
  end;
end.

