{*******************************************************}
{                                                       }
{       Pascal Script Source File                       }
{       Run by RemObjects Pascal Script in CnWizards    }
{                                                       }
{       Generated by CnPack IDE Wizards                 }
{                                                       }
{*******************************************************}

program EditorSyncButton;

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

var
  Button: TControl;
  View: IOTAEditView;
  Block: IOTAEditBlock;
begin
  Button := GetCurrentSyncButton;
  if Button = nil then
  begin
    ShowMessage('No Editor Control or Sync Button NOT Support.');
    Exit;
  end;

  if Button.Visible then
    Writeln('Is in Sync Edit Mode. Button Visible')
  else
    Writeln('NOT in Sync Edit Mode. Button Invisible');

  View := CnOtaGetTopMostEditView(nil);
  if View <> nil then
  begin
    Block := View.GetBlock;
    if (Block <> nil) and Block.GetIsValid then
    begin
      Writeln(IntToStr(Ord(Block.GetSyncMode)));
      if Ord(Block.GetSyncMode) = 0 then
      begin
        Writeln('Try to Enter Sync Block Mode.');
        Block.SyncEditBlock(nil);
      end;
    end;
  end;
end.
 
