{******************************************************************************}
{                                                                              }
{                       Pascal Script Source File                              }
{                                                                              }
{             Run by RemObjects Pascal Script in CnPack IDE Wizards            }
{                                                                              }
{                                   Generated by CnPack IDE Wizards            }
{                                                                              }
{******************************************************************************}

program EditorOptions;

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ActnList, Buttons, ClipBrd, ComCtrls, ExtCtrls, ComObj, ExtDlgs, IniFiles,
  Menus, Printers, Registry, StdCtrls, TypInfo, ToolsAPI, CnDebug,
  RegExpr, ScriptEvent, CnCommon, CnWizClasses, CnWizUtils, CnWizIdeUtils,
  CnWizShortCut, CnWizOptions;

  // If need to access IDE Components, please uses IdeInstComp

  // Note: This script can only run under Delphi 7 or above

function GetBoolString(B: Boolean): string;
begin
  if B then
    Result := 'True'
  else
    Result := 'False';
end;

var
  I, J, C: Integer;
  Options: IOTAEditOptions;
  Buffer: IOTABufferOptions;
  EditorService: IOTAEditorServices;
begin
  EditorService := IOTAEditorServices(BorlandIDEServices);
  if EditorService = nil then
  begin
    Writeln('NO EditorService Found.');
    Exit;
  end;

  C := EditorService.GetEditOptionsCount;
  Writeln('EditOptionsCount: ' + IntToStr(C));
  for I := 0 to C - 1 do
  begin
    Options := EditorService.GetEditOptionsIndex(I);
    Writeln(Format('%d: Name: ''%s'' ID: ''%s'' File Extensions: %s', [I, Options.GetOptionsName,
      Options.GetOptionsIDString, Options.GetExtensions]));
    Writeln('    FontName: ' + Options.GetFontName);
    Writeln('    FontSize: ' + IntToStr(Options.GetFontSize));
    Writeln('    BlockIndent: ' + IntToStr(Options.GetBlockIndent));
    Writeln('    ForceCutCopyEnabled: ' + GetBoolString(Options.GetForceCutCopyEnabled));
    Writeln('    UseBriefCursorShapes: ' + GetBoolString(Options.GetUseBriefCursorShapes));
    Writeln('    UseBriefRegularExpressions: ' + GetBoolString(Options.GetUseBriefRegularExpressions));
    Writeln('    SpeedSettingCount: ' + IntToStr(Options.GetSpeedSettingCount));
    for J := 0 to Options.GetSpeedSettingCount - 1 do
      Writeln('        SpeedSetting ' + IntToStr(J) + ': ' + Options.GetSpeedSetting(J).GetDisplayName);

    Buffer := Options.GetBufferOptions;
    Writeln('    Buffer Options:');
    if Buffer <> nil then
    begin
      Writeln('        AutoIndent: ' + GetBoolString(Buffer.GetAutoIndent));
      Writeln('        BackspaceUnindents: ' + GetBoolString(Buffer.GetBackspaceUnindents));
      Writeln('        CreateBackupFile: ' + GetBoolString(Buffer.GetCreateBackupFile));
      Writeln('        CursorThroughTabs: ' + GetBoolString(Buffer.GetCursorThroughTabs));
      Writeln('        InsertMode: ' + GetBoolString(Buffer.GetInsertMode));
      Writeln('        GroupUndo: ' + GetBoolString(Buffer.GetGroupUndo));
      Writeln('        KeepTrailingBlanks: ' + GetBoolString(Buffer.GetKeepTrailingBlanks));
      Writeln('        LeftGutterWidth: ' + IntToStr(Buffer.GetLeftGutterWidth));
      Writeln('        RightMargin: ' + IntToStr(Buffer.GetRightMargin));
      Writeln('        OverwriteBlocks: ' + GetBoolString(Buffer.GetOverwriteBlocks));
      Writeln('        PersistentBlocks: ' + GetBoolString(Buffer.GetPersistentBlocks));
      Writeln('        PreserveLineEnds: ' + GetBoolString(Buffer.GetPreserveLineEnds));
      Writeln('        SmartTab: ' + GetBoolString(Buffer.GetSmartTab));
      Writeln('        SyntaxHighlight: ' + GetBoolString(Buffer.GetSyntaxHighlight));
      Writeln('        TabStops: ' + Buffer.GetTabStops);
      Writeln('        UndoAfterSave: ' + GetBoolString(Buffer.GetUndoAfterSave));
      Writeln('        UndoLimit: ' + IntToStr(Buffer.GetUndoLimit));
      Writeln('        UseTabCharacter: ' + GetBoolString(Buffer.GetUseTabCharacter));
    end;
  end;
end.
 
