{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2025 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttp://www.cnpack.org                                   }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

{******************************************************************************}
{ Unit Note:                                                                   }
{    This file is partly derived from GExperts 1.2                             }
{                                                                              }
{ Original author:                                                             }
{    GExperts, Inc  http://www.gexperts.org/                                   }
{    Erik Berry <eberry@gexperts.org> or <eb@techie.com>                       }
{******************************************************************************}

unit CnWizIdeUtils;
{* |<PRE>
================================================================================
* ƣCnPack IDE רҰ
* Ԫƣڽűʹõ CnIdeWizUtils Ԫ
* ԪߣCnPack 
*     עԪͺͺ PasScript űʹ
* ƽ̨PWin2000Pro + Delphi 5.01
* ݲԣPWin9X/2000/XP + Delphi 5/6/7 + C++Builder 5/6
*   õԪеַϱػʽ
* ޸ļ¼2006.12.31 V1.0
*               Ԫ
================================================================================
|</PRE>}

interface

uses
  Windows, Messages, Classes, Controls, SysUtils, Graphics, Forms, ComCtrls,
  ExtCtrls, Menus, Buttons, Tabs,
{$IFNDEF VER130}
  DesignIntf,
{$ENDIF}
  ToolsAPI;

type
  TCnModuleSearchType = (mstInvalid, mstProject, mstProjectSearch, mstSystemSearch);
  {* ԴλͣǷڡĿ¼ڡϵͳĿ¼}

//==============================================================================
// IDE ༭ܺ
//==============================================================================

function IdeGetEditorSelectedLines(Lines: TStringList): Boolean;
{* ȡõǰ༭ѡеĴ룬ʹģʽѡΪգ򷵻صǰд롣}

function IdeGetEditorSelectedText(Lines: TStringList): Boolean;
{* ȡõǰ༭ѡĴ롣}

function IdeGetEditorSourceLines(Lines: TStringList): Boolean;
{* ȡõǰ༭ȫԴ롣}

function IdeSetEditorSelectedLines(Lines: TStringList): Boolean;
{* 滻ǰ༭ѡеĴ룬ʹģʽѡΪգ滻ǰд롣}

function IdeSetEditorSelectedText(Lines: TStringList): Boolean;
{* 滻ǰ༭ѡĴ롣}

function IdeSetEditorSourceLines(Lines: TStringList): Boolean;
{* 滻ǰ༭ȫԴ롣}

function IdeInsertTextIntoEditor(const Text: string): Boolean;
{* ıǰ༭ֶ֧ı}

function IdeEditorGetEditPos(var Col, Line: Integer): Boolean;
{* صǰλã EditView Ϊʹõǰֵ }

function IdeEditorGotoEditPos(Col, Line: Integer; Middle: Boolean): Boolean;
{* ƶ굽ָλãMiddle ʾǷƶͼġ}

function IdeGetBlockIndent: Integer;
{* õǰ༭ }

function IdeGetSourceByFileName(const FileName: string): string;
{* ļȡݡļ IDE д򿪣ر༭еݣ򷵻ļݡ}

function IdeSetSourceByFileName(const FileName: string; Source: TStrings;
  OpenInIde: Boolean): Boolean;
{* ļдݡļ IDE д򿪣дݵ༭У
   OpenInIde Ϊļд뵽༭OpenInIde Ϊֱдļ}

//==============================================================================
// IDE ༭ܺ
//==============================================================================

function IdeGetFormDesigner(FormEditor: IOTAFormEditor = nil): IDesigner;
{* ȡô༭FormEditor Ϊ nil ʾȡǰ }

function IdeGetDesignedForm(Designer: IDesigner = nil): TCustomForm;
{* ȡõǰƵĴ }

function IdeGetFormSelection(Selections: TList; Designer: IDesigner = nil;
  ExcludeForm: Boolean = True): Boolean;
{* ȡõǰƴѡ }
 
//==============================================================================
// ޸ GExperts Src 1.12  IDE غ
//==============================================================================

function GetIdeMainForm: TCustomForm;
{*  IDE  (TAppBuilder) }

function GetIdeEdition: string;
{*  IDE 汾}

function GetComponentPaletteTabControl: TTabControl;
{* 󣬿Ϊգֻ֧ 2010 °汾}

function GetNewComponentPaletteTabControl: TWinControl;
{*  2010 ϵϰ벿 Tab 󣬿Ϊ}

function GetNewComponentPaletteComponentPanel: TWinControl;
{*  2010 ϵ°벿б󣬿Ϊ}

function GetObjectInspectorForm: TCustomForm;
{* ض壬Ϊ}

function GetComponentPalettePopupMenu: TPopupMenu;
{* Ҽ˵Ϊ}

function GetComponentPaletteControlBar: TControlBar;
{* ڵControlBarΪ}

function GetMainMenuItemHeight: Integer;
{* ˵߶ }

function IsIdeEditorForm(AForm: TCustomForm): Boolean;
{* жָǷ༭}

function IsIdeDesignForm(AForm: TCustomForm): Boolean;
{* жָǷڴ}

procedure BringIdeEditorFormToFront;
{* Դ༭ΪԾ}

function IDEIsCurrentWindow: Boolean;
{* ж IDE ǷǵǰĻ }

//==============================================================================
//  IDE غ
//==============================================================================

function GetInstallDir: string;
{* ȡװĿ¼}

{$IFDEF BDS}
function GetBDSUserDataDir: string;
{* ȡ BDS (Delphi8/9) ûĿ¼ }
{$ENDIF}

procedure GetProjectLibPath(Paths: TStrings);
{* ȡǰ Path }

function GetFileNameFromModuleName(AName: string; AProject: IOTAProject = nil): string;
{* ģļ}

function CnOtaGetVersionInfoKeys(Project: IOTAProject = nil): TStrings;
{* ȡǰĿеİ汾Ϣֵ}

procedure GetLibraryPath(Paths: TStrings; IncludeProjectPath: Boolean = True);
{* ȡе LibraryPath }

function GetComponentUnitName(const ComponentName: string): string;
{* ȡڵĵԪ}

procedure GetInstalledComponents(Packages, Components: TStrings);
{* ȡѰװİΪ nilԣ}

function GetEditControlFromEditorForm(AForm: TCustomForm): TControl;
{* ر༭ڵı༭ؼ }

function GetCurrentEditControl: TControl;
{* صǰĴ༭ؼ }

function GetStatusBarFromEditor(EditControl: TControl): TStatusBar;
{* ӱ༭ؼı༭ڵ״̬}

function GetCurrentSyncButton: TControl;
{* ȡǰǰ˱༭﷨༭ťע﷨༭ťڲڿɼ}

function GetCurrentSyncButtonVisible: Boolean;
{* ȡǰǰ˱༭﷨༭ťǷɼްť򲻿ɼ False}

function GetCodeTemplateListBox: TControl;
{* ر༭еĴģԶ}

function GetCodeTemplateListBoxVisible: Boolean;
{* ر༭еĴģԶǷɼ޻򲻿ɼ False}

function IsCurrentEditorInSyncMode: Boolean;
{* ǰ༭Ƿ﷨༭ģʽ£ֻ֧ڿģʽ· False}

function IsKeyMacroRunning: Boolean;
{* ǰǷڼ̺¼ƻطţֻ֧ڷ False}

function GetCurrentCompilingProject: IOTAProject;
{* صǰڱḶ́עⲻһǵǰ}

function CompileProject(AProject: IOTAProject): Boolean;
{* 빤̣رǷɹ}

//==============================================================================
// װ
//==============================================================================

type

{ TCnPaletteWrapper }

  TCnPaletteWrapper = class(TObject)
  private
    function GetActiveTab: string;
    function GetEnabled: Boolean;
    function GetIsMultiLine: Boolean;
    function GetPalToolCount: Integer;
    function GetSelectedIndex: Integer;
    function GetSelectedToolName: string;
    function GetSelector: TSpeedButton;
    function GetTabCount: Integer;
    function GetTabIndex: Integer;
    function GetTabs(Index: Integer): string;
    function GetVisible: Boolean;
    procedure SetEnabled(const Value: Boolean);
    procedure SetSelectedIndex(const Value: Integer);
    procedure SetTabIndex(const Value: Integer);
    procedure SetVisible(const Value: Boolean);

  public
    constructor Create;

    procedure BeginUpdate;
    {* ʼ£ֹˢҳ }
    procedure EndUpdate;
    {* ֹͣ£ָˢҳ }
    function SelectComponent(const AComponent: string; const ATab: string): Boolean;
    {* ѡпؼеĳؼ }
    function FindTab(const ATab: string): Integer;
    {* ĳҳ }
    property SelectedIndex: Integer read GetSelectedIndex write SetSelectedIndex;
    {* µĿؼڱҳţ0 ͷ }
    property SelectedToolName: string read GetSelectedToolName;
    {* µĿؼδΪ }
    property Selector: TSpeedButton read GetSelector;
    {* л SpeedButton }
    property PalToolCount: Integer read GetPalToolCount;
    {* ǰҳؼ }
    property ActiveTab: string read GetActiveTab;
    {* ǰҳ }
    property TabIndex: Integer read GetTabIndex write SetTabIndex;
    {* ǰҳ }
    property Tabs[Index: Integer]: string read GetTabs;
    {* õҳ }
    property TabCount: Integer read GetTabCount;
    {* ؼҳ }
    property IsMultiLine: Boolean read GetIsMultiLine;
    {* ؼǷ }
    property Visible: Boolean read GetVisible write SetVisible;
    {* ؼǷɼ }
    property Enabled: Boolean read GetEnabled write SetEnabled;
    {* ؼǷʹ }
  end;

{ TCnMessageViewWrapper }

{$IFDEF BDS}
  TXTreeView = TCustomControl;
{$ELSE}
  TXTreeView = TTreeView;
{$ENDIF BDS}

  TCnMessageViewWrapper = class(TObject)
  {* װϢʾڵĸԵ }
  private
    FMessageViewForm: TCustomForm;
    FEditMenuItem: TMenuItem;
    FTabSet: TTabSet;
    FTreeView: TXTreeView;
{$IFNDEF BDS}
    function GetMessageCount: Integer;
    function GetSelectedIndex: Integer;
    procedure SetSelectedIndex(const Value: Integer);
    function GetCurrentMessage: string;
{$ENDIF}
    function GetTabCaption: string;
    function GetTabCount: Integer;
    function GetTabIndex: Integer;
    procedure SetTabIndex(const Value: Integer);
    function GetTabSetVisible: Boolean;
  public
    constructor Create;

    procedure UpdateAllItems;

    procedure EditMessageSource;
    {* ˫Ϣ}

    property MessageViewForm: TCustomForm read FMessageViewForm;
    {* Ϣ}
    property TreeView: TXTreeView read FTreeView;
    {* ϢʵBDS · TreeViewֻܷ CustomControl }
{$IFNDEF BDS}
    property SelectedIndex: Integer read GetSelectedIndex write SetSelectedIndex;
    {* Ϣѡе}
    property MessageCount: Integer read GetMessageCount;
    {* еϢ}
    property CurrentMessage: string read GetCurrentMessage;
    {* ǰѡеϢƺǷؿ}
{$ENDIF}
    property TabSet: TTabSet read FTabSet;
    {* طҳʵ}
    property TabSetVisible: Boolean read GetTabSetVisible;
    {* طҳǷɼD5 Ĭϲɼ}
    property TabIndex: Integer read GetTabIndex write SetTabIndex;
    {* /õǰҳ}
    property TabCount: Integer read GetTabCount;
    {* ҳ}
    property TabCaption: string read GetTabCaption;
    {* صǰҳַ}
    property EditMenuItem: TMenuItem read FEditMenuItem;
    {* '༭'˵}
  end;

{ TCnEditControlWrapper }

  TCnEditControlInfo = record
  {* ༭λϢ }
    TopLine: Integer;         // к
    LinesInWindow: Integer;   // ʾ
    LineCount: Integer;       // 뻺
    CaretX: Integer;          // Xλ
    CaretY: Integer;          // Yλ
    CharXIndex: Integer;      // ַ
{$IFDEF BDS}
    LineDigit: Integer;       // ༭λ100Ϊ3, 
{$ENDIF}
  end;

  TEditorChangeType = (
    ctView,                   // ǰͼл
    ctWindow,                 // Сβб仯
    ctCurrLine,               // ǰ
    ctCurrCol,                // ǰ
    ctFont,                   // 
    ctVScroll,                // ༭ֱ
    ctHScroll,                // ༭
    ctBlock,                  // 
    ctModified,               // ༭޸
    ctTopEditorChanged,       // ǰʾϲ༭
{$IFDEF BDS}
    ctLineDigit,              // ༭λ仯99100
{$ENDIF}
    ctElided,                 // ༭۵֧
    ctUnElided,               // ༭չ֧
    ctOptionChanged           // ༭öԻ򿪹
    );

  TEditorChangeTypes = set of TEditorChangeType;

  TCnEditorContext = record
    TopRow: Integer;               // Ӿϵһек
    BottomRow: Integer;            // Ӿһек
    LeftColumn: Integer;
    CurPos: TOTAEditPos;
    LineCount: Integer;            // ¼༭
    LineText: string;
    ModTime: TDateTime;
    BlockValid: Boolean;
    BlockSize: Integer;
    BlockStartingColumn: Integer;
    BlockStartingRow: Integer;
    BlockEndingColumn: Integer;
    BlockEndingRow: Integer;
    EditView: Pointer;
{$IFDEF BDS}
    LineDigit: Integer;       // ༭λ100Ϊ3, 
{$ENDIF}
  end;

  TEditorObject = class
  private
    FLines: TList;
    FLastTop: Integer;
    FLastBottomElided: Boolean;
    FLinesChanged: Boolean;
    FTopControl: TControl;
    FContext: TCnEditorContext;
    FEditControl: TControl;
    FEditWindow: TCustomForm;
    FEditView: IOTAEditView;
    FGutterWidth: Integer;
    FGutterChanged: Boolean;
    FLastValid: Boolean;
    procedure SetEditView(AEditView: IOTAEditView);
    function GetGutterWidth: Integer;
    function GetViewLineNumber(Index: Integer): Integer;
    function GetViewLineCount: Integer;
    function GetViewBottomLine: Integer;
    function GetTopEditor: TControl;
  public
    constructor Create(AEditControl: TControl; AEditView: IOTAEditView);
    destructor Destroy; override;
    function EditorIsOnTop: Boolean;
    procedure IDEShowLineNumberChanged;
    property Context: TCnEditorContext read FContext;
    property EditControl: TControl read FEditControl;
    property EditWindow: TCustomForm read FEditWindow;
    property EditView: IOTAEditView read FEditView;
    property GutterWidth: Integer read GetGutterWidth;

    // ǰʾǰı༭ؼ
    property TopControl: TControl read FTopControl;
    // ͼЧ
    property ViewLineCount: Integer read GetViewLineCount;
    // ͼʾʵкţIndex  0 ʼ
    property ViewLineNumber[Index: Integer]: Integer read GetViewLineNumber;
    // ͼʾʵк
    property ViewBottomLine: Integer read GetViewBottomLine;
  end;

  THighlightItem = class
  {* ͬ༭Ԫصĸʾԣ}
  private
    FBold: Boolean;
    FColorBk: TColor;
    FColorFg: TColor;
    FItalic: Boolean;
    FUnderline: Boolean;
  public
    property Bold: Boolean read FBold write FBold;
    property ColorBk: TColor read FColorBk write FColorBk;
    property ColorFg: TColor read FColorFg write FColorFg;
    property Italic: Boolean read FItalic write FItalic;
    property Underline: Boolean read FUnderline write FUnderline;
  end;

  TEditorPaintLineNotifier = procedure (Editor: TEditorObject;
    LineNum, LogicLineNum: Integer) of object;
  {* EditControl ؼл֪ͨ¼ûԴ˽Զ}

  TEditorPaintNotifier = procedure (EditControl: TControl; EditView: IOTAEditView)
    of object;
  {* EditControl ؼ֪ͨ¼ûԴ˽Զ}

  TEditorNotifier = procedure (EditControl: TControl; EditWindow: TCustomForm;
    Operation: TOperation) of object;
  {* ༭ɾ֪ͨ}

  TEditorChangeNotifier = procedure (Editor: TEditorObject; ChangeType:
    TEditorChangeTypes) of object;
  {* ༭֪ͨ}

  TKeyMessageNotifier = procedure (Key, ScanCode: Word; Shift: TShiftState;
    var Handled: Boolean) of object;
  {* ¼}

  // ¼ TControl ڵĶ壬 Sender  TEditorObjectҼǷǷǿͻı־
  TEditorMouseUpNotifier = procedure(Editor: TEditorObject; Button: TMouseButton;
    Shift: TShiftState; X, Y: Integer; IsNC: Boolean) of object;
  {* ༭̧֪ͨ}

  TEditorMouseDownNotifier =  procedure(Editor: TEditorObject; Button: TMouseButton;
    Shift: TShiftState; X, Y: Integer; IsNC: Boolean) of object;
  {* ༭갴֪ͨ}

  TEditorMouseMoveNotifier = procedure(Editor: TEditorObject; Shift: TShiftState;
    X, Y: Integer; IsNC: Boolean) of object;
  {* ༭ƶ֪ͨ}

  TEditorMouseLeaveNotifier = procedure(Editor: TEditorObject; IsNC: Boolean) of object;
  {* ༭뿪֪ͨ}

  // ༭ǿͻ֪ͨڹػ
  TEditorNcPaintNotifier = procedure(Editor: TEditorObject) of object;
  {* ༭ǿͻػ֪ͨ}

  TEditorVScrollNotifier = procedure(Editor: TEditorObject) of object;
  {* ༭֪ͨ}

  TCnBreakPointClickItem = class
  private
    FBpPosY: Integer;
    FBpDeltaLine: Integer;
    FBpEditView: IOTAEditView;
    FBpEditControl: TControl;
  public
    property BpEditControl: TControl read FBpEditControl write FBpEditControl;
    property BpEditView: IOTAEditView read FBpEditView write FBpEditView;
    property BpPosY: Integer read FBpPosY write FBpPosY;
    property BpDeltaLine: Integer read FBpDeltaLine write FBpDeltaLine;
  end;

  TCnEditControlWrapper = class(TComponent)
  private
    FCorIdeModule: HMODULE;
    FAfterPaintLineNotifiers: TList;
    FBeforePaintLineNotifiers: TList;
    FEditControlNotifiers: TList;
    FEditorChangeNotifiers: TList;
    FKeyDownNotifiers: TList;
    FKeyUpNotifiers: TList;
    FCharSize: TSize;
    FHighlights: TStringList;
    FPaintNotifyAvailable: Boolean;
    FMouseNotifyAvailable: Boolean;
    FPaintLineHook: TCnMethodHook;
    FSetEditViewHook: TCnMethodHook;

    FMouseUpNotifiers: TList;
    FMouseDownNotifiers: TList;
    FMouseMoveNotifiers: TList;
    FMouseLeaveNotifiers: TList;
    FNcPaintNotifiers: TList;
    FVScrollNotifiers: TList;

    FEditorList: TObjectList;
    FEditControlList: TList;
    FOptionChanged: Boolean;
    FOptionDlgVisible: Boolean;
    FSaveFontName: string;
    FSaveFontSize: Integer;
{$IFDEF IDE_HAS_ERRORINSIGHT}
    FSaveErrorInsightIsSmoothWave: Boolean;
{$ENDIF}
    FFontArray: array[0..9] of TFont;

    FBpClickQueue: TQueue;
    FEditorBaseFont: TFont;
    procedure ScrollAndClickEditControl(Sender: TObject);

    procedure AddNotifier(List: TList; Notifier: TMethod);
    function CalcCharSize: Boolean;
    // ַߴ磬˼Ǵעøָü㣬ȡ
    procedure GetHighlightFromReg;
    procedure ClearAndFreeList(var List: TList);
    function IndexOf(List: TList; Notifier: TMethod): Integer;
    procedure InitEditControlHook;
    procedure CheckAndSetEditControlMouseHookFlag;
    procedure RemoveNotifier(List: TList; Notifier: TMethod);
    function UpdateCharSize: Boolean;
    procedure EditControlProc(EditWindow: TCustomForm; EditControl:
      TControl; Context: Pointer);
    procedure UpdateEditControlList;
    procedure CheckOptionDlg;
    function GetEditorContext(Editor: TEditorObject): TCnEditorContext;
    function CheckViewLines(Editor: TEditorObject; Context: TCnEditorContext): Boolean;
    function CheckEditorChanges(Editor: TEditorObject): TEditorChangeTypes;
    procedure OnActiveFormChange(Sender: TObject);
    procedure AfterThemeChange(Sender: TObject);
    procedure OnSourceEditorNotify(SourceEditor: IOTASourceEditor;
      NotifyType: TCnWizSourceEditorNotifyType; EditView: IOTAEditView);
    procedure ApplicationMessage(var Msg: TMsg; var Handled: Boolean);
    procedure OnCallWndProcRet(Handle: HWND; Control: TWinControl; Msg: TMessage);
    procedure OnGetMsgProc(Handle: HWND; Control: TWinControl; Msg: TMessage);
    procedure OnIdle(Sender: TObject);
    function GetEditorCount: Integer;
    function GetEditors(Index: Integer): TEditorObject;
    function GetHighlight(Index: Integer): THighlightItem;
    function GetHighlightCount: Integer;
    function GetHighlightName(Index: Integer): string;
    procedure ClearHighlights;
    procedure LoadFontFromRegistry;
    procedure ResetFontsFromBasic(ABasicFont: TFont);
    function GetFonts(Index: Integer): TFont;
    procedure SetFonts(const Index: Integer; const Value: TFont);
  protected
    procedure DoAfterPaintLine(Editor: TEditorObject; LineNum, LogicLineNum: Integer);
    procedure DoBeforePaintLine(Editor: TEditorObject; LineNum, LogicLineNum: Integer);
    procedure DoAfterElide(EditControl: TControl);   // ݲ֧
    procedure DoAfterUnElide(EditControl: TControl); // ݲ֧
    procedure DoEditControlNotify(EditControl: TControl; Operation: TOperation);
    procedure DoEditorChange(Editor: TEditorObject; ChangeType: TEditorChangeTypes);

    procedure DoMouseDown(Editor: TEditorObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer; IsNC: Boolean);
    procedure DoMouseUp(Editor: TEditorObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer; IsNC: Boolean);
    procedure DoMouseMove(Editor: TEditorObject; Shift: TShiftState;
      X, Y: Integer; IsNC: Boolean);
    procedure DoMouseLeave(Editor: TEditorObject; IsNC: Boolean);
    procedure DoNcPaint(Editor: TEditorObject);
    procedure DoVScroll(Editor: TEditorObject);

    procedure Notification(AComponent: TComponent; Operation: TOperation); override;

    procedure CheckNewEditor(EditControl: TControl; View: IOTAEditView);
    function AddEditor(EditControl: TControl; View: IOTAEditView): Integer;
    procedure DeleteEditor(EditControl: TControl);
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;

    function IndexOfEditor(EditControl: TControl): Integer; overload;
    function IndexOfEditor(EditView: IOTAEditView): Integer; overload;
    function GetEditorObject(EditControl: TControl): TEditorObject;
    property Editors[Index: Integer]: TEditorObject read GetEditors;
    property EditorCount: Integer read GetEditorCount;

    // ¼Ƿװı༭ʾĲͬԪصԣ屾Ҫ EditorBaseFont ʹ
    function IndexOfHighlight(const Name: string): Integer;
    property HighlightCount: Integer read GetHighlightCount;
    property HighlightNames[Index: Integer]: string read GetHighlightName;
    property Highlights[Index: Integer]: THighlightItem read GetHighlight;

    function GetCharHeight: Integer;
    {* ر༭и }
    function GetCharWidth: Integer;
    {* ر༭ֿ }
    function GetCharSize: TSize;
    {* ر༭иߺֿ }
    function GetEditControlInfo(EditControl: TControl): TCnEditControlInfo;
    {* ر༭ǰϢ }
    function GetEditControlCharHeight(EditControl: TControl): Integer;
    {* ر༭ڵַ߶Ҳи}
    function GetEditControlSupportsSyntaxHighlight(EditControl: TControl): Boolean;
    {* ر༭Ƿ֧﷨ }
    function GetEditControlCanvas(EditControl: TControl): TCanvas;
    {* ر༭Ļ}
    function GetEditView(EditControl: TControl): IOTAEditView;
    {* ָ༭ǰ EditView }
    function GetEditControl(EditView: IOTAEditView): TControl;
    {* ָ EditView ǰı༭ }
    function GetTopMostEditControl: TControl;
    {* صǰǰ˵ EditControl}
    function GetEditViewFromTabs(TabControl: TXTabControl; Index: Integer):
      IOTAEditView;
    {*  TabControl ָҳ EditView }
    procedure GetAttributeAtPos(EditControl: TControl; const EdPos: TOTAEditPos;
      IncludeMargin: Boolean; var Element, LineFlag: Integer);
    {* ָλõĸԣ滻 IOTAEditView ĺ߿ܻᵼ±༭⡣
       ָλڷ Unicode  CursorPos D5/6/7  Ansi λã
       2005~2007  UTF8 ֽλãһֿ 3 У
       2009 Ҫע⣬EdPos ȻҲҪ UTF8 ֽλá 2009  CursorPos  Ansi
       ֱ CursorPos Ϊ EdPos 뾭һ UTF8 ת }
    function GetLineIsElided(EditControl: TControl; LineNum: Integer): Boolean;
    {* ָǷ۵۵ͷβҲǷǷء
       ֻ BDS Ч False}

    procedure ElideLine(EditControl: TControl; LineNum: Integer);
    {* ۵ĳУкűǿ۵}
    procedure UnElideLine(EditControl: TControl; LineNum: Integer);
    {* չĳУкűǿ۵}

    function GetPointFromEdPos(EditControl: TControl; APos: TOTAEditPos): TPoint;
    {*  BDS б༭ؼĳַλôֻ꣬ BDS Ч}

    function GetLineFromPoint(Point: TPoint; EditControl: TControl;
      EditView: IOTAEditView = nil): Integer;
    {* ر༭ؼӦУнһʼ -1 ʾʧ}

    procedure MarkLinesDirty(EditControl: TControl; Line: Integer; Count: Integer);
    {* Ǳ༭ָҪػ棬ĻɼһΪ 0 }
    procedure EditorRefresh(EditControl: TControl; DirtyOnly: Boolean);
    {* ˢ±༭ }
    function GetTextAtLine(EditControl: TControl; LineNum: Integer): string;
    {* ȡָеıעúȡıǽ Tab չɿոģʹ
       ConvertPos ת EditPos ܻ⡣ֱӽ CharIndex + 1
       ֵ EditPos.Col ɡ
       ַͣAnsiString/Ansi-Utf8/UnicodeString
       ⣬LineNumΪ߼кţҲǺ۵޹صʵкţ1 ʼ }
    function IndexPosToCurPos(EditControl: TControl; Col, Line: Integer): Integer;
    {* ༭ַ༭ʾʵλ }

    procedure RepaintEditControls;
    {* ǿñ༭ؼػ}

    function GetUseTabKey: Boolean;
    {* ñ༭ѡǷʹ Tab }

    function GetTabWidth: Integer;
    {* ñ༭ѡе Tab }

    function ClickBreakpointAtActualLine(ActualLineNum: Integer; EditControl: TControl = nil): Boolean;
    {* ༭ؼָеĶϵ/ɾϵ}

    procedure AddKeyDownNotifier(Notifier: TKeyMessageNotifier);
    {* ӱ༭֪ͨ }
    procedure RemoveKeyDownNotifier(Notifier: TKeyMessageNotifier);
    {* ɾ༭֪ͨ }

    procedure AddKeyUpNotifier(Notifier: TKeyMessageNotifier);
    {* ӱ༭֪ͨ }
    procedure RemoveKeyUpNotifier(Notifier: TKeyMessageNotifier);
    {* ɾ༭֪ͨ }

    procedure AddBeforePaintLineNotifier(Notifier: TEditorPaintLineNotifier);
    {* ӱ༭ػǰ֪ͨ }
    procedure RemoveBeforePaintLineNotifier(Notifier: TEditorPaintLineNotifier);
    {* ɾ༭ػǰ֪ͨ }

    procedure AddAfterPaintLineNotifier(Notifier: TEditorPaintLineNotifier);
    {* ӱ༭ػ֪ͨ }
    procedure RemoveAfterPaintLineNotifier(Notifier: TEditorPaintLineNotifier);
    {* ɾ༭ػ֪ͨ }

    procedure AddEditControlNotifier(Notifier: TEditorNotifier);
    {* ӱ༭ɾ֪ͨ }
    procedure RemoveEditControlNotifier(Notifier: TEditorNotifier);
    {* ɾ༭ɾ֪ͨ }

    procedure AddEditorChangeNotifier(Notifier: TEditorChangeNotifier);
    {* ӱ༭֪ͨ }
    procedure RemoveEditorChangeNotifier(Notifier: TEditorChangeNotifier);
    {* ɾ༭֪ͨ }

    property PaintNotifyAvailable: Boolean read FPaintNotifyAvailable;
    {* ر༭ػ֪ͨǷ }

    procedure AddEditorMouseUpNotifier(Notifier: TEditorMouseUpNotifier);
    {* ӱ༭̧֪ͨ }
    procedure RemoveEditorMouseUpNotifier(Notifier: TEditorMouseUpNotifier);
    {* ɾ༭̧֪ͨ }

    procedure AddEditorMouseDownNotifier(Notifier: TEditorMouseDownNotifier);
    {* ӱ༭갴֪ͨ }
    procedure RemoveEditorMouseDownNotifier(Notifier: TEditorMouseDownNotifier);
    {* ɾ༭갴֪ͨ }

    procedure AddEditorMouseMoveNotifier(Notifier: TEditorMouseMoveNotifier);
    {* ӱ༭ƶ֪ͨ }
    procedure RemoveEditorMouseMoveNotifier(Notifier: TEditorMouseMoveNotifier);
    {* ɾ༭ƶ֪ͨ }

    procedure AddEditorMouseLeaveNotifier(Notifier: TEditorMouseLeaveNotifier);
    {* ӱ༭뿪֪ͨ }
    procedure RemoveEditorMouseLeaveNotifier(Notifier: TEditorMouseLeaveNotifier);
    {* ɾ༭뿪֪ͨ }

    procedure AddEditorNcPaintNotifier(Notifier: TEditorNcPaintNotifier);
    {* ӱ༭ǿͻػ֪ͨ }
    procedure RemoveEditorNcPaintNotifier(Notifier: TEditorNcPaintNotifier);
    {* ɾ༭ǿͻػ֪ͨ }

    procedure AddEditorVScrollNotifier(Notifier: TEditorVScrollNotifier);
    {* ӱ༭ǿͻػ֪ͨ }
    procedure RemoveEditorVScrollNotifier(Notifier: TEditorVScrollNotifier);
    {* ɾ༭ǿͻػ֪ͨ }

    property MouseNotifyAvailable: Boolean read FMouseNotifyAvailable;
    {* ر༭¼֪ͨǷ }
    property EditorBaseFont: TFont read FEditorBaseFont;
    {* һ TFont 󣬳б༭Ļ幩ʹ}

    // άעеı༭Ԫص壬 Highlights һصޱɫ
    property FontBasic: TFont index 0 read GetFonts write SetFonts; // ǰɫ
    property FontAssembler: TFont index 1 read GetFonts write SetFonts;
    property FontComment: TFont index 2 read GetFonts write SetFonts;
    property FontDirective: TFont index 3 read GetFonts write SetFonts;
    property FontIdentifier: TFont index 4 read GetFonts write SetFonts;
    property FontKeyWord: TFont index 5 read GetFonts write SetFonts;
    property FontNumber: TFont index 6 read GetFonts write SetFonts;
    property FontSpace: TFont index 7 read GetFonts write SetFonts;
    property FontString: TFont index 8 read GetFonts write SetFonts;
    property FontSymbol: TFont index 9 read GetFonts write SetFonts;
  end;

function CnPaletteWrapper: TCnPaletteWrapper;

function CnMessageViewWrapper: TCnMessageViewWrapper;

function EditControlWrapper: TCnEditControlWrapper;

implementation

{$WARNINGS OFF}

function IdeGetEditorSelectedLines(Lines: TStringList): Boolean;
begin
end;

function IdeGetEditorSelectedText(Lines: TStringList): Boolean;
begin
end;

function IdeGetEditorSourceLines(Lines: TStringList): Boolean;
begin
end;

function IdeSetEditorSelectedLines(Lines: TStringList): Boolean;
begin
end;

function IdeSetEditorSelectedText(Lines: TStringList): Boolean;
begin
end;

function IdeSetEditorSourceLines(Lines: TStringList): Boolean;
begin
end;

function IdeInsertTextIntoEditor(const Text: string): Boolean;
begin
end;

function IdeEditorGetEditPos(var Col, Line: Integer): Boolean;
begin
end;

function IdeEditorGotoEditPos(Col, Line: Integer; Middle: Boolean): Boolean;
begin
end;

function IdeGetBlockIndent: Integer;
begin
end;

function IdeGetSourceByFileName(const FileName: string): string;
begin
end;

function IdeSetSourceByFileName(const FileName: string; Source: TStrings;
  OpenInIde: Boolean): Boolean;
begin
end;

function IdeGetFormDesigner(FormEditor: IOTAFormEditor = nil): IDesigner;
begin
end;

function IdeGetDesignedForm(Designer: IDesigner = nil): TCustomForm;
begin
end;

function IdeGetFormSelection(Selections: TList; Designer: IDesigner = nil;
  ExcludeForm: Boolean = True): Boolean;
begin
end;

function GetIdeMainForm: TCustomForm;
begin
end;

function GetIdeEdition: string;
begin
end;

function GetComponentPaletteTabControl: TTabControl;
begin
end;

function GetNewComponentPaletteTabControl: TWinControl;
begin
end;

function GetNewComponentPaletteComponentPanel: TWinControl;
begin
end;

function GetObjectInspectorForm: TCustomForm;
begin
end;

function GetComponentPalettePopupMenu: TPopupMenu;
begin
end;

function GetComponentPaletteControlBar: TControlBar;
begin
end;

function GetMainMenuItemHeight: Integer;
begin
end;

function IsIdeEditorForm(AForm: TCustomForm): Boolean;
begin
end;

function IsIdeDesignForm(AForm: TCustomForm): Boolean;
begin
end;

procedure BringIdeEditorFormToFront;
begin
end;

function IDEIsCurrentWindow: Boolean;
begin
end;

function GetInstallDir: string;
begin
end;

function GetBDSUserDataDir: string;
begin
end;

procedure GetProjectLibPath(Paths: TStrings);
begin
end;

function GetFileNameFromModuleName(AName: string; AProject: IOTAProject = nil): string;
begin
end;

function GetFileNameSearchTypeFromModuleName(AName: string;
  var SearchType: TCnModuleSearchType; AProject: IOTAProject = nil): string;
begin
end;

function CnOtaGetVersionInfoKeys(Project: IOTAProject = nil): TStrings;
begin
end;

procedure GetLibraryPath(Paths: TStrings; IncludeProjectPath: Boolean = True);
begin
end;

function GetComponentUnitName(const ComponentName: string): string;
begin
end;

procedure GetInstalledComponents(Packages, Components: TStrings);
begin
end;

function GetEditControlFromEditorForm(AForm: TCustomForm): TControl;
begin
end;

function GetCurrentEditControl: TControl;
begin
end;

function GetStatusBarFromEditor(EditControl: TControl): TStatusBar;
begin
end;

function GetCurrentSyncButton: TControl;
begin
end;

function GetCurrentSyncButtonVisible: Boolean;
begin
end;

function GetCodeTemplateListBox: TControl;
begin
end;

function GetCodeTemplateListBoxVisible: Boolean;
begin
end;

function IsCurrentEditorInSyncMode: Boolean;
begin
end;

function IsKeyMacroRunning: Boolean;
begin
end;

function GetCurrentCompilingProject: IOTAProject;
begin
end;

function CompileProject(AProject: IOTAProject): Boolean;
begin
end;

{ TCnPaletteWrapper }

procedure TCnPaletteWrapper.BeginUpdate;
begin
end;

constructor TCnPaletteWrapper.Create;
begin
end;

procedure TCnPaletteWrapper.EndUpdate;
begin
end;

function TCnPaletteWrapper.FindTab(const ATab: string): Integer;
begin
end;

function TCnPaletteWrapper.GetActiveTab: string;
begin
end;

function TCnPaletteWrapper.GetEnabled: Boolean;
begin
end;

function TCnPaletteWrapper.GetIsMultiLine: Boolean;
begin
end;

function TCnPaletteWrapper.GetPalToolCount: Integer;
begin
end;

function TCnPaletteWrapper.GetSelectedIndex: Integer;
begin
end;

function TCnPaletteWrapper.GetSelectedToolName: string;
begin
end;

function TCnPaletteWrapper.GetSelector: TSpeedButton;
begin
end;

function TCnPaletteWrapper.GetTabCount: Integer;
begin
end;

function TCnPaletteWrapper.GetTabIndex: Integer;
begin
end;

function TCnPaletteWrapper.GetTabs(Index: Integer): string;
begin
end;

function TCnPaletteWrapper.GetVisible: Boolean;
begin
end;

function TCnPaletteWrapper.SelectComponent(const AComponent,
  ATab: string): Boolean;
begin
end;

procedure TCnPaletteWrapper.SetEnabled(const Value: Boolean);
begin
end;

procedure TCnPaletteWrapper.SetSelectedIndex(const Value: Integer);
begin
end;

procedure TCnPaletteWrapper.SetTabIndex(const Value: Integer);
begin
end;

procedure TCnPaletteWrapper.SetVisible(const Value: Boolean);
begin
end;

function CnPaletteWrapper: TCnPaletteWrapper;
begin
end;
  
{ TCnMessageViewWrapper }

constructor TCnMessageViewWrapper.Create;
begin
end;

procedure TCnMessageViewWrapper.EditMessageSource;
begin
end;

function TCnMessageViewWrapper.GetCurrentMessage: string;
begin
end;

function TCnMessageViewWrapper.GetMessageCount: Integer;
begin
end;

function TCnMessageViewWrapper.GetSelectedIndex: Integer;
begin
end;

function TCnMessageViewWrapper.GetTabCaption: string;
begin
end;

function TCnMessageViewWrapper.GetTabCount: Integer;
begin
end;

function TCnMessageViewWrapper.GetTabIndex: Integer;
begin
end;

function TCnMessageViewWrapper.GetTabSetVisible: Boolean;
begin
end;

procedure TCnMessageViewWrapper.SetSelectedIndex(const Value: Integer);
begin
end;

procedure TCnMessageViewWrapper.SetTabIndex(const Value: Integer);
begin
end;

procedure TCnMessageViewWrapper.UpdateAllItems;
begin
end;

function CnMessageViewWrapper: TCnMessageViewWrapper;
begin
end;

{ TEditorObject }

constructor TEditorObject.Create(AEditControl: TControl;
  AEditView: IOTAEditView);
begin

end;

destructor TEditorObject.Destroy;
begin
  inherited;

end;

function TEditorObject.EditorIsOnTop: Boolean;
begin

end;

function TEditorObject.GetGutterWidth: Integer;
begin

end;

function TEditorObject.GetTopEditor: TControl;
begin

end;

function TEditorObject.GetViewBottomLine: Integer;
begin

end;

function TEditorObject.GetViewLineCount: Integer;
begin

end;

function TEditorObject.GetViewLineNumber(Index: Integer): Integer;
begin

end;

procedure TEditorObject.IDEShowLineNumberChanged;
begin

end;

procedure TEditorObject.SetEditView(AEditView: IOTAEditView);
begin

end;

{ TCnEditControlWrapper }

procedure TCnEditControlWrapper.AddAfterPaintLineNotifier(
  Notifier: TEditorPaintLineNotifier);
begin

end;

procedure TCnEditControlWrapper.AddBeforePaintLineNotifier(
  Notifier: TEditorPaintLineNotifier);
begin

end;

procedure TCnEditControlWrapper.AddEditControlNotifier(
  Notifier: TEditorNotifier);
begin

end;

function TCnEditControlWrapper.AddEditor(EditControl: TControl;
  View: IOTAEditView): Integer;
begin

end;

procedure TCnEditControlWrapper.AddEditorChangeNotifier(
  Notifier: TEditorChangeNotifier);
begin

end;

procedure TCnEditControlWrapper.AddEditorMouseDownNotifier(
  Notifier: TEditorMouseDownNotifier);
begin

end;

procedure TCnEditControlWrapper.AddEditorMouseLeaveNotifier(
  Notifier: TEditorMouseLeaveNotifier);
begin

end;

procedure TCnEditControlWrapper.AddEditorMouseMoveNotifier(
  Notifier: TEditorMouseMoveNotifier);
begin

end;

procedure TCnEditControlWrapper.AddEditorMouseUpNotifier(
  Notifier: TEditorMouseUpNotifier);
begin

end;

procedure TCnEditControlWrapper.AddEditorNcPaintNotifier(
  Notifier: TEditorNcPaintNotifier);
begin

end;

procedure TCnEditControlWrapper.AddEditorVScrollNotifier(
  Notifier: TEditorVScrollNotifier);
begin

end;

procedure TCnEditControlWrapper.AddKeyDownNotifier(
  Notifier: TKeyMessageNotifier);
begin

end;

procedure TCnEditControlWrapper.AddKeyUpNotifier(
  Notifier: TKeyMessageNotifier);
begin

end;

procedure TCnEditControlWrapper.AddNotifier(List: TList;
  Notifier: TMethod);
begin

end;

procedure TCnEditControlWrapper.AfterThemeChange(Sender: TObject);
begin

end;

procedure TCnEditControlWrapper.ApplicationMessage(var Msg: TMsg;
  var Handled: Boolean);
begin

end;

function TCnEditControlWrapper.CalcCharSize: Boolean;
begin

end;

procedure TCnEditControlWrapper.CheckAndSetEditControlMouseHookFlag;
begin

end;

function TCnEditControlWrapper.CheckEditorChanges(
  Editor: TEditorObject): TEditorChangeTypes;
begin

end;

procedure TCnEditControlWrapper.CheckNewEditor(EditControl: TControl;
  View: IOTAEditView);
begin

end;

procedure TCnEditControlWrapper.CheckOptionDlg;
begin

end;

function TCnEditControlWrapper.CheckViewLines(Editor: TEditorObject;
  Context: TCnEditorContext): Boolean;
begin

end;

procedure TCnEditControlWrapper.ClearAndFreeList(var List: TList);
begin

end;

procedure TCnEditControlWrapper.ClearHighlights;
begin

end;

function TCnEditControlWrapper.ClickBreakpointAtActualLine(
  ActualLineNum: Integer; EditControl: TControl): Boolean;
begin

end;

constructor TCnEditControlWrapper.Create(AOwner: TComponent);
begin
  inherited;

end;

procedure TCnEditControlWrapper.DeleteEditor(EditControl: TControl);
begin

end;

destructor TCnEditControlWrapper.Destroy;
begin
  inherited;

end;

procedure TCnEditControlWrapper.DoAfterElide(EditControl: TControl);
begin

end;

procedure TCnEditControlWrapper.DoAfterPaintLine(Editor: TEditorObject;
  LineNum, LogicLineNum: Integer);
begin

end;

procedure TCnEditControlWrapper.DoAfterUnElide(EditControl: TControl);
begin

end;

procedure TCnEditControlWrapper.DoBeforePaintLine(Editor: TEditorObject;
  LineNum, LogicLineNum: Integer);
begin

end;

procedure TCnEditControlWrapper.DoEditControlNotify(EditControl: TControl;
  Operation: TOperation);
begin

end;

procedure TCnEditControlWrapper.DoEditorChange(Editor: TEditorObject;
  ChangeType: TEditorChangeTypes);
begin

end;

procedure TCnEditControlWrapper.DoMouseDown(Editor: TEditorObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer; IsNC: Boolean);
begin

end;

procedure TCnEditControlWrapper.DoMouseLeave(Editor: TEditorObject;
  IsNC: Boolean);
begin

end;

procedure TCnEditControlWrapper.DoMouseMove(Editor: TEditorObject;
  Shift: TShiftState; X, Y: Integer; IsNC: Boolean);
begin

end;

procedure TCnEditControlWrapper.DoMouseUp(Editor: TEditorObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer; IsNC: Boolean);
begin

end;

procedure TCnEditControlWrapper.DoNcPaint(Editor: TEditorObject);
begin

end;

procedure TCnEditControlWrapper.DoVScroll(Editor: TEditorObject);
begin

end;

procedure TCnEditControlWrapper.EditControlProc(EditWindow: TCustomForm;
  EditControl: TControl; Context: Pointer);
begin

end;

procedure TCnEditControlWrapper.EditorRefresh(EditControl: TControl;
  DirtyOnly: Boolean);
begin

end;

procedure TCnEditControlWrapper.ElideLine(EditControl: TControl;
  LineNum: Integer);
begin

end;

procedure TCnEditControlWrapper.GetAttributeAtPos(EditControl: TControl;
  const EdPos: TOTAEditPos; IncludeMargin: Boolean; var Element,
  LineFlag: Integer);
begin

end;

function TCnEditControlWrapper.GetCharHeight: Integer;
begin

end;

function TCnEditControlWrapper.GetCharSize: TSize;
begin

end;

function TCnEditControlWrapper.GetCharWidth: Integer;
begin

end;

function TCnEditControlWrapper.GetEditControl(
  EditView: IOTAEditView): TControl;
begin

end;

function TCnEditControlWrapper.GetEditControlCanvas(
  EditControl: TControl): TCanvas;
begin

end;

function TCnEditControlWrapper.GetEditControlCharHeight(
  EditControl: TControl): Integer;
begin

end;

function TCnEditControlWrapper.GetEditControlInfo(
  EditControl: TControl): TCnEditControlInfo;
begin

end;

function TCnEditControlWrapper.GetEditControlSupportsSyntaxHighlight(
  EditControl: TControl): Boolean;
begin

end;

function TCnEditControlWrapper.GetEditorContext(
  Editor: TEditorObject): TCnEditorContext;
begin

end;

function TCnEditControlWrapper.GetEditorCount: Integer;
begin

end;

function TCnEditControlWrapper.GetEditorObject(
  EditControl: TControl): TEditorObject;
begin

end;

function TCnEditControlWrapper.GetEditors(Index: Integer): TEditorObject;
begin

end;

function TCnEditControlWrapper.GetEditView(
  EditControl: TControl): IOTAEditView;
begin

end;

function TCnEditControlWrapper.GetEditViewFromTabs(
  TabControl: TXTabControl; Index: Integer): IOTAEditView;
begin

end;

function TCnEditControlWrapper.GetFonts(Index: Integer): TFont;
begin

end;

function TCnEditControlWrapper.GetHighlight(
  Index: Integer): THighlightItem;
begin

end;

function TCnEditControlWrapper.GetHighlightCount: Integer;
begin

end;

procedure TCnEditControlWrapper.GetHighlightFromReg;
begin

end;

function TCnEditControlWrapper.GetHighlightName(Index: Integer): string;
begin

end;

function TCnEditControlWrapper.GetLineFromPoint(Point: TPoint;
  EditControl: TControl; EditView: IOTAEditView): Integer;
begin

end;

function TCnEditControlWrapper.GetLineIsElided(EditControl: TControl;
  LineNum: Integer): Boolean;
begin

end;

function TCnEditControlWrapper.GetPointFromEdPos(EditControl: TControl;
  APos: TOTAEditPos): TPoint;
begin

end;

function TCnEditControlWrapper.GetTabWidth: Integer;
begin

end;

function TCnEditControlWrapper.GetTextAtLine(EditControl: TControl;
  LineNum: Integer): string;
begin

end;

function TCnEditControlWrapper.GetTopMostEditControl: TControl;
begin

end;

function TCnEditControlWrapper.GetUseTabKey: Boolean;
begin

end;

function TCnEditControlWrapper.IndexOf(List: TList;
  Notifier: TMethod): Integer;
begin

end;

function TCnEditControlWrapper.IndexOfEditor(
  EditView: IOTAEditView): Integer;
begin

end;

function TCnEditControlWrapper.IndexOfEditor(
  EditControl: TControl): Integer;
begin

end;

function TCnEditControlWrapper.IndexOfHighlight(
  const Name: string): Integer;
begin

end;

function TCnEditControlWrapper.IndexPosToCurPos(EditControl: TControl; Col,
  Line: Integer): Integer;
begin

end;

procedure TCnEditControlWrapper.InitEditControlHook;
begin

end;

procedure TCnEditControlWrapper.LoadFontFromRegistry;
begin

end;

procedure TCnEditControlWrapper.MarkLinesDirty(EditControl: TControl; Line,
  Count: Integer);
begin

end;

procedure TCnEditControlWrapper.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
  inherited;

end;

procedure TCnEditControlWrapper.OnActiveFormChange(Sender: TObject);
begin

end;

procedure TCnEditControlWrapper.OnCallWndProcRet(Handle: HWND;
  Control: TWinControl; Msg: TMessage);
begin

end;

procedure TCnEditControlWrapper.OnGetMsgProc(Handle: HWND;
  Control: TWinControl; Msg: TMessage);
begin

end;

procedure TCnEditControlWrapper.OnIdle(Sender: TObject);
begin

end;

procedure TCnEditControlWrapper.OnSourceEditorNotify(
  SourceEditor: IOTASourceEditor; NotifyType: TCnWizSourceEditorNotifyType;
  EditView: IOTAEditView);
begin

end;

procedure TCnEditControlWrapper.RemoveAfterPaintLineNotifier(
  Notifier: TEditorPaintLineNotifier);
begin

end;

procedure TCnEditControlWrapper.RemoveBeforePaintLineNotifier(
  Notifier: TEditorPaintLineNotifier);
begin

end;

procedure TCnEditControlWrapper.RemoveEditControlNotifier(
  Notifier: TEditorNotifier);
begin

end;

procedure TCnEditControlWrapper.RemoveEditorChangeNotifier(
  Notifier: TEditorChangeNotifier);
begin

end;

procedure TCnEditControlWrapper.RemoveEditorMouseDownNotifier(
  Notifier: TEditorMouseDownNotifier);
begin

end;

procedure TCnEditControlWrapper.RemoveEditorMouseLeaveNotifier(
  Notifier: TEditorMouseLeaveNotifier);
begin

end;

procedure TCnEditControlWrapper.RemoveEditorMouseMoveNotifier(
  Notifier: TEditorMouseMoveNotifier);
begin

end;

procedure TCnEditControlWrapper.RemoveEditorMouseUpNotifier(
  Notifier: TEditorMouseUpNotifier);
begin

end;

procedure TCnEditControlWrapper.RemoveEditorNcPaintNotifier(
  Notifier: TEditorNcPaintNotifier);
begin

end;

procedure TCnEditControlWrapper.RemoveEditorVScrollNotifier(
  Notifier: TEditorVScrollNotifier);
begin

end;

procedure TCnEditControlWrapper.RemoveKeyDownNotifier(
  Notifier: TKeyMessageNotifier);
begin

end;

procedure TCnEditControlWrapper.RemoveKeyUpNotifier(
  Notifier: TKeyMessageNotifier);
begin

end;

procedure TCnEditControlWrapper.RemoveNotifier(List: TList;
  Notifier: TMethod);
begin

end;

procedure TCnEditControlWrapper.RepaintEditControls;
begin

end;

procedure TCnEditControlWrapper.ResetFontsFromBasic(ABasicFont: TFont);
begin

end;

procedure TCnEditControlWrapper.ScrollAndClickEditControl(Sender: TObject);
begin

end;

procedure TCnEditControlWrapper.SetFonts(const Index: Integer;
  const Value: TFont);
begin

end;

procedure TCnEditControlWrapper.UnElideLine(EditControl: TControl;
  LineNum: Integer);
begin

end;

function TCnEditControlWrapper.UpdateCharSize: Boolean;
begin

end;

procedure TCnEditControlWrapper.UpdateEditControlList;
begin

end;

end.

