{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2025 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttp://www.cnpack.org                                   }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnWizClasses;
{* |<PRE>
================================================================================
* ƣCnPack IDE רҰ
* ԪƣCnWizards ඨ嵥Ԫ
* Ԫߣܾ (zjy@cnpack.org)
*     עõԪΪ CnWizards ܵһ֣רҵĻࡣ
*           ҪעһʵֵרңʵָרҵĵԪ initialization ڵ
*           RegisterCnWizard עһרá
*         - TCnBaseWizard
*            CnWizard ײĳࡣ
*           - TCnIconWizard
*             ͼĳࡣ
*             - TCnIDEEnhanceWizard
*               IDE չרһࡣ
*             - TCnActionWizard
*                IDE Action ĳ࣬пݼרҡ
*               - TCnMenuWizard
*                 ˵ĵĳ࣬ͨ˵õרҡ
*                 - TCnSubMenuWizard
*                   Ӳ˵ĳ࣬ͨӲ˵õרҡ
*             - TCnRepositoryWizard
*                Repository רһࡣ
*               - TCnFormWizard
*                 嵥Ԫļģ򵼻࣬ Pas Ԫ
*               - TCnProjectWizard
*                 Ӧó򹤳̵ģ򵼻ࡣ
* ƽ̨PWin2000Pro + Delphi 5.01
* ݲԣPWin9X/2000/XP + Delphi 5/6/7 + C++Builder 5/6
*   õԪеַϱػʽ
* ޸ļ¼2002.09.17 V1.0
*               Ԫʵֻ
================================================================================
|</PRE>}

interface

{$I CnWizards.inc}

uses
  Windows, Classes, Sysutils, Graphics, Menus, ActnList, IniFiles, ToolsAPI,
  Registry, ComCtrls, Forms, CnHashMap, CnWizIni,
  CnWizShortCut, CnWizMenuAction, CnIni, CnWizConsts, CnPopupMenu;

type

//==============================================================================
// רҰרҳ
//==============================================================================

{ TCnBaseWizard }

{$M+}

  TCnBaseWizard = class(TNotifierObject, IOTAWizard)
  {* CnWizard רҳ࣬רĹ }
  private
    FActive: Boolean;
    FWizardIndex: Integer;
    FDefaultsMap: TCnStrToVariantHashMap;
  protected
    procedure SetActive(Value: Boolean); virtual;
    {* Active дظ÷ Active Ա¼ }
    function GetHasConfig: Boolean; virtual;
    {* HasConfig Զظ÷Ƿڿ }
    function GetIcon: TIcon; virtual; abstract;
    {* Icon Զظ÷طרͼ꣬ûרͨԼ }
    function GetBigIcon: TIcon; virtual; abstract;
    {* ߴ Icon Զظ÷طרͼ꣬ûרͨԼ }

    // IOTAWizard methods
    function GetIDString: string;
    function GetName: string; virtual;
  public
    constructor Create; virtual;
    {* ๹ }
    destructor Destroy; override;
    {*  }
    class function WizardName: string;
    {* ȡרƣֱ֧ػַ }
    function GetAuthor: string; virtual;
    {* }
    function GetComment: string; virtual;
    {* ע}
    function GetSearchContent: string; virtual;
    {* عַ԰ǶŷָӢĹؼʣҪСд}
    procedure DebugComand(Cmds: TStrings; Results: TStrings); virtual;
    {*  Debug  Results Уڲ}

    // IOTAWizard methods
    function GetState: TWizardState; virtual;
    {* ר״̬IOTAWizard ظ÷ר״̬ }
    procedure Execute; virtual; abstract;
    {* רִ巽IOTAWizard 󷽷ʵ֡
       ûִһרʱø÷ }

    procedure Loaded; virtual;
    {* IDE ɺø÷}

    procedure LaterLoaded; virtual;
    {* IDE ɸһЩø÷ڸ߰汾 IDE д IDE ˵̫ٵĳ}

    class function IsInternalWizard: Boolean; virtual;
    {* רǷڲרңʾ }

    class procedure GetWizardInfo(var Name, Author, Email, Comment: string);
      virtual; {$IFNDEF BCB}abstract;{$ENDIF BCB}
    {* ȡרϢṩרҵ˵ͰȨϢ󷽷ʵ֡
     |<PRE>
       var AName: string      - רƣֱ֧ػַ
       var Author: string     - רߣжߣ÷ֺŷָ
       var Email: string      - ר䣬жߣ÷ֺŷָ
       var Comment: string    - ר˵ֱ֧ػзַ
     |</PRE> }
    procedure Config; virtual;
    {* ר÷רҹרýеã HasConfig ΪʱЧ }
    procedure LanguageChanged(Sender: TObject); virtual;
    {* רڶԷıʱĴش˹̴ַ }
    procedure LoadSettings(Ini: TCustomIniFile); virtual;
    {* װר÷ش˷ INI жȡרҲ
       ע˷רһбöΣҪ
       ֹظص¶ݵ⡣ }
    procedure SaveSettings(Ini: TCustomIniFile); virtual;
    {* ר÷ش˷רҲ浽 INI  }
    procedure ResetSettings(Ini: TCustomIniFile); virtual;
    {* ר÷ INI ֮ı涯Ҫش˷ }

    class function GetIDStr: string;
    {* רΨһʶʹ }
    function CreateIniFile(CompilerSection: Boolean = False): TCustomIniFile;
    {* һڴȡרò INI ûʹúԼͷ }
    procedure DoLoadSettings;
    {* װר }
    procedure DoSaveSettings;
    {* ר }
    procedure DoResetSettings;
    {* ר}

    property Active: Boolean read FActive write SetActive;
    {* ԾԣרҵǰǷ }
    property HasConfig: Boolean read GetHasConfig;
    {* ʾרǷý }
    property WizardIndex: Integer read FWizardIndex write FWizardIndex;
    {* רע IDE صţͷרʱʹã벻Ҫ޸ĸֵ }
    property Icon: TIcon read GetIcon;
    {* רͼԣС ActionWizard  16x16 IconWizard Ĭ 32x32 }
    property BigIcon: TIcon read GetBigIcon;
    {* רҴͼ꣬еĻ}
  end;

{$M-}

type
  TCnWizardClass = class of TCnBaseWizard;

//==============================================================================
// ͼԵĻ
//==============================================================================

{ TCnIconWizard }

  TCnIconWizard = class(TCnBaseWizard)
  {* IDE ͼԵĻ }
  private
    FIcon: TIcon;
  protected
    function GetIcon: TIcon; override;
    {* ظרҵͼ꣬ش˹̷ Icon 
       FIcon ʹϵͳĬϳߴ磬һ 32 * 32 }
    function GetBigIcon: TIcon; override;
    {* ظרҵĴͼ꣬32 * 32 }
    procedure InitIcon(AIcon, ASmallIcon: TIcon); virtual;
    {* ʼͼ꣬󴴽ʱãش˹´ FIcon }
    class function GetIconName: string; virtual;
    {* ͼļ }
  public
    constructor Create; override;
    {* ๹ }
    destructor Destroy; override;
    {*  }
  end;

//==============================================================================
// IDE չ
//==============================================================================

{ TCnIDEEnhanceWizard }

  TCnIDEEnhanceWizard = class(TCnIconWizard);
  {* IDE չ }

//==============================================================================
//  Action Ϳݼĳר
//==============================================================================

{ TCnActionWizard }

  TCnActionWizard = class(TCnIDEEnhanceWizard)
  {*  Action Ϳݼ CnWizard רҳ࣬ӸIcon  16x16 }
  private
    FAction: TCnWizAction;
    function GetImageIndex: Integer;
  protected
    function GetIcon: TIcon; override;
    procedure OnActionUpdate(Sender: TObject); virtual;
    function CreateAction: TCnWizAction; virtual;
    procedure Click(Sender: TObject); virtual;
    function GetCaption: string; virtual; abstract;
    {* רҵı }
    function GetHint: string; virtual;
    {* רҵ Hint ʾ }
    function GetDefShortCut: TShortCut; virtual;
    {* רҵĬϿݼʵʹʱרҵĿݼɹ趨
       ֻҪĬϵľˡ }
  public
    constructor Create; override;
    {* ๹ }
    destructor Destroy; override;
    {*  }
    function GetSearchContent: string; override;
    {* عַѱ Hint ȥ }
    property ImageIndex: Integer read GetImageIndex;
    {* רͼ IDE  ImageList е }
    property Action: TCnWizAction read FAction;
    {* ר Action  }
    function EnableShortCut: Boolean; virtual;
    {* רǷÿݼ }
    procedure RefreshAction; virtual;
    {* ¸ Action  }
  end;

//==============================================================================
// ˵ĳר
//==============================================================================

{ TCnMenuWizard }

type
  TCnMenuWizard = class(TCnActionWizard)
  {* ˵ CnWizard רҳ }
  private
    FMenuOrder: Integer;
    function GetAction: TCnWizMenuAction;
    function GetMenu: TMenuItem;
    procedure SetMenuOrder(const Value: Integer);
  protected
    function CreateAction: TCnWizAction; override;
  public
    constructor Create; override;

    function EnableShortCut: Boolean; override;
    {* רǷÿݼ }
    property Menu: TMenuItem read GetMenu;
    {* רҵĲ˵ }
    property Action: TCnWizMenuAction read GetAction;
    {* ר Action  }
    property MenuOrder: Integer read FMenuOrder write SetMenuOrder;
  end;

//==============================================================================
// Ӳ˵ĳר
//==============================================================================

{ TCnSubMenuWizard }

  TCnSubMenuWizard = class(TCnMenuWizard)
  {* Ӳ˵ CnWizard רҳ }
  private
    FList: TList;
    FPopupMenu: TPopupMenu;
    FPopupAction: TCnWizAction; // ڷõʱİťӦ Action Action ͼظ
    FExecuting: Boolean;
    FRefreshing: Boolean;
    procedure FreeSubMenus;
    procedure OnExecute(Sender: TObject);
    procedure OnUpdate(Sender: TObject);
    procedure OnPopup(Sender: TObject);
    function GetSubActions(Index: Integer): TCnWizMenuAction;
    function GetSubActionCount: Integer;
    function GetSubMenus(Index: Integer): TMenuItem;
  protected
    procedure SetActive(Value: Boolean); override;
    procedure OnActionUpdate(Sender: TObject); override;
    function CreateAction: TCnWizAction; override;
    procedure Click(Sender: TObject); override;
    function IndexOf(SubAction: TCnWizMenuAction): Integer;
    {* ָ Action бе }
    function RegisterASubAction(const ACommand, ACaption: string;
      AShortCut: TShortCut = 0; const AHint: string = '';
      const AIconName: string = ''): Integer;
    {* עһ Actionš
     |<PRE>
       ACommand: string         - Action ֣ΪһΨһֵַ
       ACaption: string         - Action ı
       AShortCut: TShortCut     - Action ĬϿݼʵʹõļֵעжȡ
       AHint: string            - Action ʾϢ
       Result: Integer          - бе
     |</PRE> }
    procedure AddSubMenuWizard(SubMenuWiz: TCnSubMenuWizard);
    {* ΪרҹҽһӲ˵ר }
    procedure AddSepMenu;
    {* һָ˵ }
    procedure DeleteSubAction(Index: Integer);
    {* ɾָ Action }

    function ShowShortCutDialog(const HelpStr: string): Boolean;
    {* ʾ Action ݼöԻ }

    procedure SubActionExecute(Index: Integer); virtual;
    {* Ӳ˵ִзΪӲ˵ţרظ÷ Action ִ¼ }
    procedure SubActionUpdate(Index: Integer); virtual;
    {* Ӳ˵·ΪӲ˵ţרظ÷ Action ״̬ }
  public
    constructor Create; override;
    {* ๹ }
    destructor Destroy; override;
    {*  }
    function GetSearchContent: string; override;
    {* عַӲ˵ı Hint ȥ }
    procedure DebugComand(Cmds: TStrings; Results: TStrings); override;
    {* ʱӡӲ˵Լ Action ȵϢ}
    procedure Execute; override;
    {* ִʲô }
    function EnableShortCut: Boolean; override;
    {* Ƿÿݼ False }
    procedure AcquireSubActions; virtual;
    {* ش˹̣ڲ RegisterASubAction Ӳ˵
        ˹ڶлʱᱻظá }
    procedure ClearSubActions; virtual;
    {* ɾе ActionӲ˵еķָ }
    procedure RefreshAction; override;
    {* صˢ Action ķ˼̳ˢ²˵⣬ˢӲ˵ Action }
    procedure RefreshSubActions; virtual;
    {*  Actionش˷ֹ Action  }
    property SubActionCount: Integer read GetSubActionCount;
    {* ר Action  }
    property SubMenus[Index: Integer]: TMenuItem read GetSubMenus;
    {* רҵӲ˵ }
    property SubActions[Index: Integer]: TCnWizMenuAction read GetSubActions;
    {* רҵ Action  }
    function ActionByCommand(const ACommand: string): TCnWizAction;
    {* ֲָ Action򷵻 nil}
  end;

//==============================================================================
//  Repository רһ
//==============================================================================

{ TCnRepositoryWizard }

  TCnRepositoryWizard = class(TCnIconWizard, IOTARepositoryWizard)
  {* CnWizard ģ򵼳 }
  protected
    FIconHandle: HICON;
    function GetName: string; override;
    {*  GetName  WizardName Ϊʾַ  }
  public
    constructor Create; override;
    {* ๹ }
    destructor Destroy; override;
    {*  }

    // IOTARepositoryWizard methods
    function GetPage: string;
    {$IFDEF COMPILER6_UP}
    function GetGlyph: Cardinal;
    {$ELSE}
    function GetGlyph: HICON;
    {$ENDIF}
  end;

//==============================================================================
// Ԫģ򵼻
//==============================================================================

{ TCnUnitWizard }

  TCnUnitWizard = class(TCnRepositoryWizard, {$IFDEF DELPHI10_UP}IOTAProjectWizard{$ELSE}IOTAFormWizard{$ENDIF});
  {* ʵ IOTAFormWizard  New Իг, BDS2006 Ҫ IOTAProjectWizard}

//==============================================================================
// ģ򵼻
//==============================================================================

{ TCnFormWizard }

  TCnFormWizard = class(TCnRepositoryWizard, IOTAFormWizard);

//==============================================================================
// ģ򵼻
//==============================================================================

{ TCnProjectWizard }

  TCnProjectWizard = class(TCnRepositoryWizard, IOTAProjectWizard);

//==============================================================================
// ༭Ҽ˵ִĿĻ࣬Ӧʵֹ
//==============================================================================

{ TCnBaseMenuExecutor }

  TCnBaseMenuExecutor = class(TObject)
  {* ༭Ҽ˵ִĿĻ࣬ɴĳһרʵ}
  private
    FTag: Integer;
    FWizard: TCnBaseWizard;
  public
    constructor Create(OwnWizard: TCnBaseWizard); virtual;
    {* ๹ }
    destructor Destroy; override;
    {*  }

    function GetActive: Boolean; virtual;
    {* ĿǷʾ˳ŵ}
    function GetCaption: string; virtual;
    {* Ŀʾı⣬˳ŵһ}
    function GetHint: string; virtual;
    {* Ŀʾ}
    function GetEnabled: Boolean; virtual;
    {* ĿǷʹܣ˳ŵ}
    procedure Prepare; virtual;
    {* PrepareItem ʱã˳ŵڶ}
    function Execute: Boolean; virtual;
    {* ĿִзĬʲô}

    property Wizard: TCnBaseWizard read FWizard;
    {*  Wizard ʵ}
    property Tag: Integer read FTag write FTag;
    {* һ Tag}
  end;

//==============================================================================
// ༭Ҽ˵ִĿһʽĻ࣬¼ִָв
//==============================================================================

{ TCnContextMenuExecutor }

  TCnContextMenuExecutor = class(TCnBaseMenuExecutor)
  {* ༭Ҽ˵ִĿһʽĻ࣬¼ִָв}
  private
    FActive: Boolean;
    FEnabled: Boolean;
    FCaption: string;
    FHint: string;
    FOnExecute: TNotifyEvent;
  protected
    procedure DoExecute; virtual;
  public
    constructor Create; reintroduce; virtual;

    function GetActive: Boolean; override;
    function GetCaption: string; override;
    function GetHint: string; override;
    function GetEnabled: Boolean; override;
    function Execute: Boolean; override;

    property Caption: string read FCaption write FCaption;
    {* Ŀʾı}
    property Hint: string read FHint write FHint;
    {* Ŀʾʾ}
    property Active: Boolean read FActive write FActive;
    {* ĿǷʾ}
    property Enabled: Boolean read FEnabled write FEnabled;
    {* ĿǷʹ}
    property OnExecute: TNotifyEvent read FOnExecute write FOnExecute;
    {* Ŀִзִʱ}
  end;

//==============================================================================
// רбع
//==============================================================================

procedure RegisterCnWizard(const AClass: TCnWizardClass);
{* עһ CnBaseWizard רãÿרʵֵԪӦڸõԪ initialization
   ڵøùער }

function GetCnWizardClass(const ClassName: string): TCnWizardClass;
{* רȡָר }

function GetCnWizardClassCount: Integer;
{* ער }

function GetCnWizardClassByIndex(const Index: Integer): TCnWizardClass;
{* ȡָר }

function GetCnWizardTypeNameFromClass(AClass: TClass): string;
{* רȡר }

function GetCnWizardTypeName(AWizard: TCnBaseWizard): string;
{* רʵȡָר }

procedure GetCnWizardInfoStrs(AWizard: TCnBaseWizard; Infos: TStrings);
{* ȡרʵַбϢ}

implementation

uses
  CnWizUtils, CnWizOptions, CnCommon, CnWizCommentFrm, CnWizSubActionShortCutFrm;

procedure RegisterCnWizard(const AClass: TCnWizardClass);
begin
end;

function GetCnWizardClass(const ClassName: string): TCnWizardClass;
begin
end;

function GetCnWizardClassCount: Integer;
begin
end;

function GetCnWizardClassByIndex(const Index: Integer): TCnWizardClass;
begin
end;

function GetCnWizardTypeNameFromClass(AClass: TClass): string;
begin
end;

function GetCnWizardTypeName(AWizard: TCnBaseWizard): string;
begin
end;

procedure GetCnWizardInfoStrs(AWizard: TCnBaseWizard; Infos: TStrings);
begin
end;

constructor TCnBaseWizard.Create;
begin
end;

destructor TCnBaseWizard.Destroy;
begin
end;

class procedure TCnBaseWizard.GetWizardInfo(var Name, Author, Email,
  Comment: string);
begin
end;

class function TCnBaseWizard.WizardName: string;
begin
end;

class function TCnBaseWizard.GetIDStr: string;
begin
end;

function TCnBaseWizard.GetAuthor: string;
begin
end;

function TCnBaseWizard.GetComment: string;
begin
end;

function TCnBaseWizard.GetSearchContent: string;
begin
end;

class function TCnBaseWizard.IsInternalWizard: Boolean;
begin
end;

procedure TCnBaseWizard.DebugComand(Cmds: TStrings; Results: TStrings);
begin
end;

function TCnBaseWizard.CreateIniFile(CompilerSection: Boolean): TCustomIniFile;
begin
end;

procedure TCnBaseWizard.DoLoadSettings;
begin
end;

procedure TCnBaseWizard.DoSaveSettings;
begin
end;

procedure TCnBaseWizard.DoResetSettings;
begin
end;

procedure TCnBaseWizard.Config;
begin
end;

procedure TCnBaseWizard.LanguageChanged(Sender: TObject);
begin
end;

procedure TCnBaseWizard.LoadSettings(Ini: TCustomIniFile);
begin
end;

procedure TCnBaseWizard.SaveSettings(Ini: TCustomIniFile);
begin
end;

procedure TCnBaseWizard.ResetSettings(Ini: TCustomIniFile);
begin
end;

procedure TCnBaseWizard.Loaded;
begin
end;

procedure TCnBaseWizard.LaterLoaded;
begin
end;

function TCnBaseWizard.GetHasConfig: Boolean;
begin
end;

procedure TCnBaseWizard.SetActive(Value: Boolean);
begin
end;

function TCnBaseWizard.GetIDString: string;
begin
end;

function TCnBaseWizard.GetName: string;
begin
end;

function TCnBaseWizard.GetState: TWizardState;
begin
end;

constructor TCnIconWizard.Create;
begin
end;

destructor TCnIconWizard.Destroy;
begin
end;

function TCnIconWizard.GetIcon: TIcon;
begin
end;

function TCnIconWizard.GetBigIcon: TIcon;
begin
end;

class function TCnIconWizard.GetIconName: string;
begin
end;

procedure TCnIconWizard.InitIcon(AIcon, ASmallIcon: TIcon);
begin
end;

constructor TCnActionWizard.Create;
begin
end;

destructor TCnActionWizard.Destroy;
begin
end;

procedure TCnActionWizard.RefreshAction;
begin
end;

procedure TCnActionWizard.Click(Sender: TObject);
begin
end;

procedure TCnActionWizard.OnActionUpdate(Sender: TObject);
begin
end;

function TCnActionWizard.CreateAction: TCnWizAction;
begin
end;

function TCnActionWizard.GetDefShortCut: TShortCut;
begin
end;

function TCnActionWizard.EnableShortCut: Boolean;
begin
end;

function TCnActionWizard.GetHint: string;
begin
end;

function TCnActionWizard.GetSearchContent: string;
begin
end;

function TCnActionWizard.GetIcon: TIcon;
begin
end;

function TCnActionWizard.GetImageIndex: Integer;
begin
end;

constructor TCnMenuWizard.Create;
begin
end;

procedure TCnMenuWizard.SetMenuOrder(const Value: Integer);
begin
end;

function TCnMenuWizard.CreateAction: TCnWizAction;
begin
end;

function TCnMenuWizard.GetAction: TCnWizMenuAction;
begin
end;

function TCnMenuWizard.GetMenu: TMenuItem;
begin
end;

function TCnMenuWizard.EnableShortCut: Boolean;
begin
end;

constructor TCnSubMenuWizard.Create;
begin
end;

destructor TCnSubMenuWizard.Destroy;
begin
end;

function TCnSubMenuWizard.GetSearchContent: string;
begin
end;

procedure TCnSubMenuWizard.DebugComand(Cmds: TStrings; Results: TStrings);
begin
end;

procedure TCnSubMenuWizard.AcquireSubActions;
begin
end;

function TCnSubMenuWizard.CreateAction: TCnWizAction;
begin
end;

procedure TCnSubMenuWizard.Execute;
begin
end;

function TCnSubMenuWizard.EnableShortCut: Boolean;
begin
end;

procedure TCnSubMenuWizard.RefreshAction;
begin
end;

procedure TCnSubMenuWizard.RefreshSubActions;
begin
end;

function TCnSubMenuWizard.RegisterASubAction(const ACommand, ACaption: string;
  AShortCut: TShortCut; const AHint: string; const AIconName: string): Integer;
begin
end;

procedure TCnSubMenuWizard.AddSubMenuWizard(SubMenuWiz: TCnSubMenuWizard);
begin
end;

procedure TCnSubMenuWizard.AddSepMenu;
begin
end;

procedure TCnSubMenuWizard.ClearSubActions;
begin
end;

procedure TCnSubMenuWizard.DeleteSubAction(Index: Integer);
begin
end;

procedure TCnSubMenuWizard.FreeSubMenus;
begin
end;

function TCnSubMenuWizard.IndexOf(SubAction: TCnWizMenuAction): Integer;
begin
end;

function TCnSubMenuWizard.ActionByCommand(const ACommand: string): TCnWizAction;
begin
end;

procedure TCnSubMenuWizard.Click(Sender: TObject);
begin
end;

procedure TCnSubMenuWizard.OnExecute(Sender: TObject);
begin
end;

procedure TCnSubMenuWizard.OnUpdate(Sender: TObject);
begin
end;

function TCnSubMenuWizard.ShowShortCutDialog(const HelpStr: string): Boolean;
begin
end;

procedure TCnSubMenuWizard.SetActive(Value: Boolean);
begin
end;

procedure TCnSubMenuWizard.OnActionUpdate(Sender: TObject);
begin
end;

procedure TCnSubMenuWizard.OnPopup(Sender: TObject);
begin
end;

procedure TCnSubMenuWizard.SubActionExecute(Index: Integer);
begin
end;

procedure TCnSubMenuWizard.SubActionUpdate(Index: Integer);
begin
end;

function TCnSubMenuWizard.GetSubActionCount: Integer;
begin
end;

function TCnSubMenuWizard.GetSubActions(Index: Integer): TCnWizMenuAction;
begin
end;

function TCnSubMenuWizard.GetSubMenus(Index: Integer): TMenuItem;
begin
end;

constructor TCnRepositoryWizard.Create;
begin
end;

destructor TCnRepositoryWizard.Destroy;
begin
end;

function TCnRepositoryWizard.GetName: string;
begin
end;

function TCnRepositoryWizard.GetGlyph: Cardinal;
begin
end;

function TCnRepositoryWizard.GetPage: string;
begin
end;

constructor TCnBaseMenuExecutor.Create(OwnWizard: TCnBaseWizard);
begin
end;

destructor TCnBaseMenuExecutor.Destroy;
begin
end;

procedure TCnBaseMenuExecutor.Prepare;
begin
end;

function TCnBaseMenuExecutor.Execute: Boolean;
begin
end;

function TCnBaseMenuExecutor.GetActive: Boolean;
begin
end;

function TCnBaseMenuExecutor.GetCaption: string;
begin
end;

function TCnBaseMenuExecutor.GetEnabled: Boolean;
begin
end;

function TCnBaseMenuExecutor.GetHint: string;
begin
end;

constructor TCnContextMenuExecutor.Create;
begin
end;

procedure TCnContextMenuExecutor.DoExecute;
begin
end;

function TCnContextMenuExecutor.Execute: Boolean;
begin
end;

function TCnContextMenuExecutor.GetActive: Boolean;
begin
end;

function TCnContextMenuExecutor.GetCaption: string;
begin
end;

function TCnContextMenuExecutor.GetEnabled: Boolean;
begin
end;

function TCnContextMenuExecutor.GetHint: string;
begin
end;

end.
