# 前向纠错 (FEC, Forward Error Correction) 使用说明

自 20231126 版起，KCPTube 提供了 FEC 功能，进一步缓解丢包造成的抖动。

没错，就是 Reed-Solomon 编码。

## 格式

格式为 `fec=D:R`，其中 D 表示原始数据量，R 表示冗余数据量。D + R 的总数最大值为 255，不能超过这个数。至于 D 及 R 谁大谁小，都可以。

冒号两侧任意一个值为 0 表示不使用 FEC。

例如可以填入 `fec=20:4`，表示每发送 20 个数据包，就生成并发送 4 个冗余包。

## 注意事项

收发双方的 FEC 设置**必须**完全一致，否则会导致 FEC 无效。

## 数值调整

- 原始数据量（D 值）不应该太少，数值过少等于几乎没有效果。该值最好大于 15。
    - 当然了，并不是越大越好，因为在低流量时会导致很长时间才会生成冗余数据量。
    - **游戏数据传输是特例**，该值越低越好，最好**设为 1**。游戏流量本身并不高，如果游戏程序的发包间隔大于线路延迟，那么 FEC 就不会有任何效果。但因为对延时敏感，所以可以设为 1。
        - 对于游戏应用，请尽量设置单独的专用通道（例如专门的 VPN 通道），不要与其它应用混合使用。

- 冗余数据量（R 值）并非越多越好，过多的冗余数据量会造成不必要的浪费。

所以需要根据自己的流量需求以及线路丢包率来调整 D 值与 R 值。一般来说，应当 D + R > 19。

## 与 KCP 快速重传机制的相互影响

KCP 本身有快速重传机制，既可以使用预先设置好的配置，也可以在 KCPTube 中可以在手动模式下自行指定输入 kcp_resend 数值（对应 KCP 内部的 fastresend）。

若丢包跨越达到给定次数后，就会触发自动重传。

很显然，如果 `fec=D:R` 的 D 值过高，恰好当前链路丢包率较高，而 fastresend 值数值较低（比如只有2、3，也就是 fast1 ~ fast4 模式），可能会在冗余数据仍未生成的情况下就触发自动重传，产生大量流量。

对于 fast 模式，建议 D 值不要大于 30。

### kcp_nodelay = 1 或 kcp_nodelay = 2 （启用快速重传）
（fast 模式以及 regular1~2）

- 丢包率不高的时候（**5%** 以内），**无须使用 FEC。** 单独使用 `blast=1` 效果更好。

- 丢包率在 5% ~ 10% 的时候，单独使用 `blast=1` 的效果仍然比 FEC 更好。

- 丢包率高于 10% 的时候，叠加使用 FEC 可以使抖动更为平滑。
    - 但可能会造成严重的带宽浪费，有效流量仅占总流量的三分之一到五分之一。

### kcp_nodelay = 0 （关闭快速重传）
（regular3~5）

- 丢包率不高的时候（**2%** 以内），**无须使用 FEC。** 单独使用 `blast=1` 效果更好。
    - 此时 regular3 的优点是，浪费的流量没那么多。可能是最佳选择。
    - 这时候 regular4-5 类似于 regular3，只不过稍微慢一点。

- 丢包率在 2% ~ 5% 的时候，单独使用 `blast=1` 的效果仍然比 FEC 更好。

- 丢包率高于 6% 的时候，就有必要叠加使用 FEC 了。
    - 浪费的流量暴增，与 fast 模式相似。

## 参考设置

fast1 ~ fast6, regular1, regular2 :
- `fec=15:3`
- `fec=16:5`
- `fec=20:4`
- `fec=25:5`

regular3:
- `fec=20:4`
- `fec=25:5`
- `fec=26:6`

regular4, regular5:
- `fec=20:4`
- `fec=20:5`
- `fec=25:5`
- `fec=30:6`
- `fec=20:8`


若想设置较高的 D 值、不介意高延迟，请使用手动配置模式，自行指定较高的 kcp_resend 数值。

如果设置较高 D 值的原因是想要为 OpenVPN 或 WireGuard 之类的 VPN 套一层隧道，请考虑使用 [UDP Hop](https://github.com/cnbatch/udphop)。

## FEC 源码库
KCPTube 使用的 FEC 来自于 [fecpp](https://github.com/randombit/fecpp)，并作了些许修改。
