:- module(_,
    [debug_write/1,debug_write_nl/1,
     debug_write_atom/1,debug_write_atom_nl/1],[]).

:- use_package(assertions).

:- doc(author, "Germ@'{a}n Puebla").

:- doc(module," This module provides a hook for writing in a 
    human readable way the clauses generated by partial evaluation
    in those cases where the residual program contains very large 
    terms as arguments. Note that these clauses are only shown 
    when the verbosity level is high or very high.").


:- use_module(ciaopp(preprocess_flags)).

:- use_module(library(lists), [member/2]).
:- use_module(library(streams)).
:- use_module(library(write)).

debug_write(_Text):-
    current_pp_flag(verbosity,V),
    member(V,[none,low]),!.
debug_write(Text):-
    write(Text).

debug_write_nl(_Text):-
    current_pp_flag(verbosity,V),
    member(V,[none,low]),!.
debug_write_nl(Text):-
    write(Text), nl.

debug_write_atom(_Atom):-
    current_pp_flag(verbosity,V),
    member(V,[none,low]),!.
debug_write_atom(Atom):-
    write_atom(Atom).

debug_write_atom_nl(_Atom):-
    current_pp_flag(verbosity,V),
    member(V,[none,low]),!.
debug_write_atom_nl(Atom):-
    write_atom(Atom), nl.

write_atom(Atom):-
    write(Atom).

% Example definition for debugging of JVM Specialization
%
%% write_atom(Atom):-
%%      debug_filter_atom(Atom,NAtom),
%%      write_canonical(NAtom).
%% 
%% debug_filter_atom(Atom,NAtom):-
%%      functor(Atom,F,A),
%%      atom_concat('pe:execute',_,F),!,
%%      A1 is A - 1,
%%      functor(NAtom,F,A1),
%%      copy_shifted_args(A,Atom,NAtom).
%% debug_filter_atom(Atom,Atom).
%% 
%% copy_shifted_args(1,_Atom,_NAtom):-!.
%% copy_shifted_args(Pos,Atom,NAtom):-
%%      arg(Pos,Atom,Arg),
%%      Pos1 is Pos - 1,
%%      arg(Pos1,NAtom,Arg),
%%      copy_shifted_args(Pos1,Atom,NAtom).

