# The CiaoPP Program Processor

CiaoPP is a program processor framework for
[Ciao](https://github.com/ciao-lang/ciao). CiaoPP performs a number of
program debugging, analysis, and source-to-source transformation
tasks:

 - **Inference of properties** of the predicates and literals of the
   program (*types*, *modes* and other *variable instantiation*
   properties, *non-failure*, *determinacy*, bounds on *computational
   cost*, bounds on *sizes of terms* in the program, etc.).

 - Certain kinds of **static debugging** and **verification**, finding
   errors before running the program. This includes checking how
   programs call system library predicates and also *checking the
   assertions* present in the program or in other modules used by the
   program. Such assertions represent essentially partial
   *specifications* of the program.

 - Several kinds of source to source **program transformations** such
   as *program specialization*, *slicing*, *partial evaluation*,
   *program parallelization* (taking *granularity control* into
   account), inclusion of *run-time tests* for assertions which cannot
   be checked completely at compile-time, etc.

The information generated by analysis and the assertions in the
specifications are all written in the same *assertion language*, which
is in turn also used by the Ciao system documentation generator,
`lpdoc`.

This repository contains the generic preprocessor framework together
with some basic analyses, transformations, and language support. Other
features (including support for a variety of programming languages)
are distributed as separate bundles. 

CiaoPP is distributed under the GNU general public license.

## Installation

By default, Ciao will detect and build CiaoPP during system
compilation. In order to customize the default configuration options,
please refer to the Ciao installation instructions.

It is possible to do a separate build and install of CiaoPP with the
following command:

```
$ ciao get ciaopp
```
