# SOM constraints file.

# lock down pin locations:
set_property PACKAGE_PIN Y14 [get_ports dac1_clk]
set_property PACKAGE_PIN T12 [get_ports {dac1_d[0]}]
set_property PACKAGE_PIN T14 [get_ports {dac1_d[1]}]
set_property PACKAGE_PIN T10 [get_ports {dac1_d[2]}]
set_property PACKAGE_PIN T11 [get_ports {dac1_d[3]}]
set_property PACKAGE_PIN F19 [get_ports {dac1_d[4]}]
set_property PACKAGE_PIN J18 [get_ports {dac1_d[5]}]
set_property PACKAGE_PIN H18 [get_ports {dac1_d[6]}]
set_property PACKAGE_PIN H17 [get_ports {dac1_d[7]}]
set_property PACKAGE_PIN G19 [get_ports dac12_vref_cs_n]
set_property PACKAGE_PIN G20 [get_ports amp12_vref_cs_n]
set_property PACKAGE_PIN J20 [get_ports flash_dac_sck]
set_property PACKAGE_PIN H20 [get_ports flash_dac_din]
set_property PACKAGE_PIN H15 [get_ports sync_encoder]
set_property PACKAGE_PIN G15 [get_ports sync_rx]
set_property PACKAGE_PIN K14 [get_ports sync_tx]
set_property PACKAGE_PIN J14 [get_ports sync_master]
set_property PACKAGE_PIN J16 [get_ports blue_LED]
set_property PACKAGE_PIN J15 [get_ports yellow_LED]
set_property PACKAGE_PIN W16 [get_ports frnt_clk]
set_property PACKAGE_PIN P14 [get_ports frnt_latch]
set_property PACKAGE_PIN P16 [get_ports frnt_allon]
set_property PACKAGE_PIN M20 [get_ports {frnt_din[0]}]
set_property PACKAGE_PIN L19 [get_ports {frnt_din[1]}]
set_property PACKAGE_PIN M18 [get_ports {frnt_din[2]}]
set_property PACKAGE_PIN W19 [get_ports {frnt_din[3]}]
set_property PACKAGE_PIN M17 [get_ports {frnt_din[4]}]
set_property PACKAGE_PIN P19 [get_ports {frnt_din[5]}]
set_property PACKAGE_PIN N17 [get_ports {frnt_din[6]}]
set_property PACKAGE_PIN R19 [get_ports {frnt_din[7]}]
set_property PACKAGE_PIN T17 [get_ports {frnt_din[8]}]
set_property PACKAGE_PIN U17 [get_ports {frnt_din[9]}]
set_property PACKAGE_PIN V17 [get_ports {frnt_din[10]}]
set_property PACKAGE_PIN U19 [get_ports {frnt_din[11]}]
set_property PACKAGE_PIN T16 [get_ports {frnt_din[12]}]
set_property PACKAGE_PIN U15 [get_ports {frnt_din[13]}]
set_property PACKAGE_PIN V15 [get_ports {frnt_din[14]}]
set_property PACKAGE_PIN R14 [get_ports {frnt_din[15]}]
set_property PACKAGE_PIN W15 [get_ports back_clk]
set_property PACKAGE_PIN R17 [get_ports back_latch]
set_property PACKAGE_PIN P15 [get_ports back_allon]
set_property PACKAGE_PIN L15 [get_ports {back_din[0]}]
set_property PACKAGE_PIN M14 [get_ports {back_din[1]}]
set_property PACKAGE_PIN L17 [get_ports {back_din[2]}]
set_property PACKAGE_PIN T19 [get_ports {back_din[3]}]
set_property PACKAGE_PIN N18 [get_ports {back_din[4]}]
set_property PACKAGE_PIN V20 [get_ports {back_din[5]}]
set_property PACKAGE_PIN P18 [get_ports {back_din[6]}]
set_property PACKAGE_PIN R18 [get_ports {back_din[7]}]
set_property PACKAGE_PIN U18 [get_ports {back_din[8]}]
set_property PACKAGE_PIN V18 [get_ports {back_din[9]}]
set_property PACKAGE_PIN W18 [get_ports {back_din[10]}]
set_property PACKAGE_PIN T20 [get_ports {back_din[11]}]
set_property PACKAGE_PIN T15 [get_ports {back_din[12]}]
set_property PACKAGE_PIN V16 [get_ports {back_din[13]}]
set_property PACKAGE_PIN R16 [get_ports {back_din[14]}]
set_property PACKAGE_PIN U20 [get_ports {back_din[15]}]
set_property PACKAGE_PIN U12 [get_ports flex_scl_io]
set_property PACKAGE_PIN V12 [get_ports flex_sda_io]
set_property PACKAGE_PIN Y16 [get_ports adc_miso]
set_property PACKAGE_PIN Y17 [get_ports adc_sclk]
set_property PACKAGE_PIN W14 [get_ports adc_cs_n]
set_property PACKAGE_PIN U14 [get_ports wave_clk]
set_property PACKAGE_PIN P20 [get_ports spare_diff_1_n]
set_property PACKAGE_PIN N20 [get_ports spare_diff_1_p]
set_property PACKAGE_PIN M15 [get_ports spare03]
set_property PACKAGE_PIN K17 [get_ports spare04]
set_property PACKAGE_PIN G17 [get_ports spare05]
set_property PACKAGE_PIN L14 [get_ports spare06]
set_property PACKAGE_PIN W13 [get_ports rs485_ro]
# note: rs485_ro is spare01 on schematic.
set_property PACKAGE_PIN V13 [get_ports rs485_di]
# note: rs485_di is spare07 on schematic.
set_property PACKAGE_PIN W20 [get_ports rs485_de]
# note: rs485_de is spare02 on schematic.
set_property PACKAGE_PIN Y18 [get_ports spare_diff_4_p]
set_property PACKAGE_PIN Y19 [get_ports spare_diff_4_n]
set_property PACKAGE_PIN G14 [get_ports eth_tx_clk]
set_property PACKAGE_PIN C20 [get_ports {eth_txd[0]}]
set_property PACKAGE_PIN B20 [get_ports {eth_txd[1]}]
set_property PACKAGE_PIN B19 [get_ports {eth_txd[2]}]
set_property PACKAGE_PIN A20 [get_ports {eth_txd[3]}]
set_property PACKAGE_PIN E17 [get_ports eth_tx_ctrl]
set_property PACKAGE_PIN L16 [get_ports eth_rx_clk]
set_property PACKAGE_PIN D18 [get_ports {eth_rxd[0]}]
set_property PACKAGE_PIN D19 [get_ports {eth_rxd[1]}]
set_property PACKAGE_PIN D20 [get_ports {eth_rxd[2]}]
set_property PACKAGE_PIN E18 [get_ports {eth_rxd[3]}]
set_property PACKAGE_PIN E19 [get_ports eth_rx_ctrl]
set_property PACKAGE_PIN F16 [get_ports eth_mdio_mdio_io]
set_property PACKAGE_PIN F17 [get_ports eth_mdio_mdc]
set_property PACKAGE_PIN M19 [get_ports eth_rst_n]
set_property PACKAGE_PIN H16 [get_ports eth_gtx_clk]
set_property PACKAGE_PIN K16 [get_ports strobe_dly]
set_property PACKAGE_PIN L20 [get_ports {adc_mux_s[0]}]
set_property PACKAGE_PIN K19 [get_ports {adc_mux_s[1]}]
set_property PACKAGE_PIN J19 [get_ports {adc_mux_s[2]}]
set_property PACKAGE_PIN N16 [get_ports amp_over_crt_n]
set_property PACKAGE_PIN N15 [get_ports ph_pzt_err_n]
set_property PACKAGE_PIN K18 [get_ports adc_mux_en]
set_property PACKAGE_PIN F20 [get_ports oc_cuk1]
set_property PACKAGE_PIN G18 [get_ports en_ph_pwr]

# Set IO type. All but the spare diff pins are LVCMOS 2.5V:

set_property IOSTANDARD LVCMOS25 [get_ports {DDR_addr[0]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_addr[10]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_addr[11]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_addr[12]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_addr[13]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_addr[14]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_addr[1]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_addr[2]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_addr[3]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_addr[4]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_addr[5]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_addr[6]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_addr[7]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_addr[8]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_addr[9]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_ba[0]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_ba[1]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_ba[2]}]
set_property IOSTANDARD LVCMOS25 [get_ports DDR_cas_n]
set_property IOSTANDARD LVCMOS25 [get_ports DDR_ck_n]
set_property IOSTANDARD LVCMOS25 [get_ports DDR_ck_p]
set_property IOSTANDARD LVCMOS25 [get_ports DDR_cke]
set_property IOSTANDARD LVCMOS25 [get_ports DDR_cs_n]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_dm[0]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_dm[1]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_dm[2]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_dm[3]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_dq[0]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_dq[10]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_dq[11]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_dq[12]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_dq[13]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_dq[14]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_dq[15]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_dq[16]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_dq[17]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_dq[18]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_dq[19]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_dq[1]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_dq[20]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_dq[21]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_dq[22]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_dq[23]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_dq[24]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_dq[25]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_dq[26]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_dq[27]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_dq[28]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_dq[29]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_dq[2]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_dq[30]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_dq[31]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_dq[3]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_dq[4]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_dq[5]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_dq[6]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_dq[7]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_dq[8]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_dq[9]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_dqs_n[0]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_dqs_n[1]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_dqs_n[2]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_dqs_n[3]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_dqs_p[0]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_dqs_p[1]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_dqs_p[2]}]
set_property IOSTANDARD LVCMOS25 [get_ports {DDR_dqs_p[3]}]
set_property IOSTANDARD LVCMOS25 [get_ports DDR_odt]
set_property IOSTANDARD LVCMOS25 [get_ports DDR_ras_n]
set_property IOSTANDARD LVCMOS25 [get_ports DDR_reset_n]
set_property IOSTANDARD LVCMOS25 [get_ports DDR_we_n]
set_property IOSTANDARD LVCMOS25 [get_ports FIXED_IO_ddr_vrn]
set_property IOSTANDARD LVCMOS25 [get_ports FIXED_IO_ddr_vrp]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[0]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[10]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[11]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[12]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[13]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[14]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[15]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[16]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[17]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[18]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[19]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[1]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[20]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[21]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[22]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[23]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[24]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[25]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[26]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[27]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[28]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[29]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[2]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[30]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[31]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[32]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[33]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[34]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[35]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[36]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[37]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[38]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[39]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[3]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[40]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[41]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[42]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[43]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[44]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[45]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[46]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[47]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[48]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[49]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[4]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[50]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[51]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[52]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[53]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[5]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[6]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[7]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[8]}]
set_property IOSTANDARD LVCMOS25 [get_ports {FIXED_IO_mio[9]}]
set_property IOSTANDARD LVCMOS25 [get_ports FIXED_IO_ps_clk]
set_property IOSTANDARD LVCMOS25 [get_ports FIXED_IO_ps_porb]
set_property IOSTANDARD LVCMOS25 [get_ports FIXED_IO_ps_srstb]
set_property IOSTANDARD LVCMOS25 [get_ports Vp_Vn_v_n]
set_property IOSTANDARD LVCMOS25 [get_ports Vp_Vn_v_p]
set_property IOSTANDARD LVCMOS25 [get_ports adc_cs_n]
set_property IOSTANDARD LVCMOS25 [get_ports adc_miso]
set_property IOSTANDARD LVCMOS25 [get_ports adc_mux_en]
set_property IOSTANDARD LVCMOS25 [get_ports {adc_mux_s[0]}]
set_property IOSTANDARD LVCMOS25 [get_ports {adc_mux_s[1]}]
set_property IOSTANDARD LVCMOS25 [get_ports {adc_mux_s[2]}]
set_property IOSTANDARD LVCMOS25 [get_ports adc_sclk]
set_property IOSTANDARD LVCMOS25 [get_ports amp12_vref_cs_n]
set_property IOSTANDARD LVCMOS25 [get_ports amp_over_crt_n]
set_property IOSTANDARD LVCMOS25 [get_ports back_allon]
set_property IOSTANDARD LVCMOS25 [get_ports back_clk]
set_property IOSTANDARD LVCMOS25 [get_ports {back_din[0]}]
set_property IOSTANDARD LVCMOS25 [get_ports {back_din[10]}]
set_property IOSTANDARD LVCMOS25 [get_ports {back_din[11]}]
set_property IOSTANDARD LVCMOS25 [get_ports {back_din[12]}]
set_property IOSTANDARD LVCMOS25 [get_ports {back_din[13]}]
set_property IOSTANDARD LVCMOS25 [get_ports {back_din[14]}]
set_property IOSTANDARD LVCMOS25 [get_ports {back_din[15]}]
set_property IOSTANDARD LVCMOS25 [get_ports {back_din[1]}]
set_property IOSTANDARD LVCMOS25 [get_ports {back_din[2]}]
set_property IOSTANDARD LVCMOS25 [get_ports {back_din[3]}]
set_property IOSTANDARD LVCMOS25 [get_ports {back_din[4]}]
set_property IOSTANDARD LVCMOS25 [get_ports {back_din[5]}]
set_property IOSTANDARD LVCMOS25 [get_ports {back_din[6]}]
set_property IOSTANDARD LVCMOS25 [get_ports {back_din[7]}]
set_property IOSTANDARD LVCMOS25 [get_ports {back_din[8]}]
set_property IOSTANDARD LVCMOS25 [get_ports {back_din[9]}]
set_property IOSTANDARD LVCMOS25 [get_ports back_latch]
set_property IOSTANDARD LVCMOS25 [get_ports blue_LED]
set_property IOSTANDARD LVCMOS25 [get_ports dac12_vref_cs_n]
set_property IOSTANDARD LVCMOS25 [get_ports dac1_clk]
set_property IOSTANDARD LVCMOS25 [get_ports {dac1_d[0]}]
set_property IOSTANDARD LVCMOS25 [get_ports {dac1_d[1]}]
set_property IOSTANDARD LVCMOS25 [get_ports {dac1_d[2]}]
set_property IOSTANDARD LVCMOS25 [get_ports {dac1_d[3]}]
set_property IOSTANDARD LVCMOS25 [get_ports {dac1_d[4]}]
set_property IOSTANDARD LVCMOS25 [get_ports {dac1_d[5]}]
set_property IOSTANDARD LVCMOS25 [get_ports {dac1_d[6]}]
set_property IOSTANDARD LVCMOS25 [get_ports {dac1_d[7]}]
set_property IOSTANDARD LVCMOS25 [get_ports en_ph_pwr]
set_property IOSTANDARD LVCMOS25 [get_ports eth_gtx_clk]
set_property IOSTANDARD LVCMOS25 [get_ports eth_mdio_mdc]
set_property IOSTANDARD LVCMOS25 [get_ports eth_mdio_mdio_io]
set_property IOSTANDARD LVCMOS25 [get_ports eth_rst_n]
set_property IOSTANDARD LVCMOS25 [get_ports eth_rx_clk]
set_property IOSTANDARD LVCMOS25 [get_ports eth_rx_ctrl]
set_property IOSTANDARD LVCMOS25 [get_ports {eth_rxd[0]}]
set_property IOSTANDARD LVCMOS25 [get_ports {eth_rxd[1]}]
set_property IOSTANDARD LVCMOS25 [get_ports {eth_rxd[2]}]
set_property IOSTANDARD LVCMOS25 [get_ports {eth_rxd[3]}]
set_property IOSTANDARD LVCMOS25 [get_ports eth_tx_clk]
set_property IOSTANDARD LVCMOS25 [get_ports eth_tx_ctrl]
set_property IOSTANDARD LVCMOS25 [get_ports {eth_txd[0]}]
set_property IOSTANDARD LVCMOS25 [get_ports {eth_txd[1]}]
set_property IOSTANDARD LVCMOS25 [get_ports {eth_txd[2]}]
set_property IOSTANDARD LVCMOS25 [get_ports {eth_txd[3]}]
set_property IOSTANDARD LVCMOS25 [get_ports flash_dac_din]
set_property IOSTANDARD LVCMOS25 [get_ports flash_dac_sck]
set_property IOSTANDARD LVCMOS25 [get_ports flex_scl_io]
set_property IOSTANDARD LVCMOS25 [get_ports flex_sda_io]
set_property IOSTANDARD LVCMOS25 [get_ports frnt_allon]
set_property IOSTANDARD LVCMOS25 [get_ports frnt_clk]
set_property IOSTANDARD LVCMOS25 [get_ports {frnt_din[0]}]
set_property IOSTANDARD LVCMOS25 [get_ports {frnt_din[10]}]
set_property IOSTANDARD LVCMOS25 [get_ports {frnt_din[11]}]
set_property IOSTANDARD LVCMOS25 [get_ports {frnt_din[12]}]
set_property IOSTANDARD LVCMOS25 [get_ports {frnt_din[13]}]
set_property IOSTANDARD LVCMOS25 [get_ports {frnt_din[14]}]
set_property IOSTANDARD LVCMOS25 [get_ports {frnt_din[15]}]
set_property IOSTANDARD LVCMOS25 [get_ports {frnt_din[1]}]
set_property IOSTANDARD LVCMOS25 [get_ports {frnt_din[2]}]
set_property IOSTANDARD LVCMOS25 [get_ports {frnt_din[3]}]
set_property IOSTANDARD LVCMOS25 [get_ports {frnt_din[4]}]
set_property IOSTANDARD LVCMOS25 [get_ports {frnt_din[5]}]
set_property IOSTANDARD LVCMOS25 [get_ports {frnt_din[6]}]
set_property IOSTANDARD LVCMOS25 [get_ports {frnt_din[7]}]
set_property IOSTANDARD LVCMOS25 [get_ports {frnt_din[8]}]
set_property IOSTANDARD LVCMOS25 [get_ports {frnt_din[9]}]
set_property IOSTANDARD LVCMOS25 [get_ports frnt_latch]
set_property IOSTANDARD LVCMOS25 [get_ports oc_cuk1]
set_property IOSTANDARD LVCMOS25 [get_ports ph_pzt_err_n]
set_property IOSTANDARD LVCMOS25 [get_ports rs485_de]
set_property IOSTANDARD LVCMOS25 [get_ports rs485_di]
set_property IOSTANDARD LVCMOS25 [get_ports rs485_ro]
set_property IOSTANDARD LVCMOS25 [get_ports spare03]
set_property IOSTANDARD LVCMOS25 [get_ports spare04]
set_property IOSTANDARD LVCMOS25 [get_ports spare05]
set_property IOSTANDARD LVCMOS25 [get_ports spare06]
set_property IOSTANDARD LVCMOS25 [get_ports strobe_dly]
set_property IOSTANDARD LVCMOS25 [get_ports sync_encoder]
set_property IOSTANDARD LVCMOS25 [get_ports sync_master]
set_property IOSTANDARD LVCMOS25 [get_ports sync_rx]
set_property IOSTANDARD LVCMOS25 [get_ports sync_tx]
set_property IOSTANDARD LVCMOS25 [get_ports wave_clk]
set_property IOSTANDARD LVCMOS25 [get_ports yellow_LED]
set_property IOSTANDARD LVDS_25 [get_ports spare_diff*]
#set_property IOSTANDARD LVCMOS25 [get_ports spare[*]]
#set_property IOSTANDARD LVCMOS25 [get_ports strobe_dly]
#set_property IOSTANDARD LVCMOS25 [get_ports sync_*]
#set_property IOSTANDARD LVCMOS25 [get_ports dac1*]
#set_property IOSTANDARD LVCMOS25 [get_ports a*]
#set_property IOSTANDARD LVCMOS25 [get_ports f*]
#set_property IOSTANDARD LVCMOS25 [get_ports sync*]
#set_property IOSTANDARD LVCMOS25 [get_ports *_LED]
#set_property IOSTANDARD LVCMOS25 [get_ports frnt*]
#set_property IOSTANDARD LVCMOS25 [get_ports back*]
#set_property IOSTANDARD LVCMOS25 [get_ports eth*]
#set_property IOSTANDARD LVCMOS25 [get_ports ph*]
#set_property IOSTANDARD LVCMOS25 [get_ports oc*]
#set_property IOSTANDARD LVCMOS25 [get_ports en*]

# Set drive strength:

set_property DRIVE 4 [get_ports *_LED]
set_property DRIVE 4 [get_ports sync_master]
set_property DRIVE 4 [get_ports sync_tx]
set_property DRIVE 4 [get_ports dac*]
set_property DRIVE 4 [get_ports flash_dac_sck]
set_property DRIVE 4 [get_ports *12_vref_cs_n]
set_property DRIVE 4 [get_ports flash_dac_din]
set_property DRIVE 4 [get_ports spare0*]
set_property DRIVE 4 [get_ports rs485_de]
set_property DRIVE 4 [get_ports rs485_di]
set_property DRIVE 4 [get_ports en_ph_pwr]

# enable pullups on some inputs:

set_property PULLUP true [get_ports sync_rx]
set_property PULLUP true [get_ports amp12_vref_cs_n]
set_property PULLUP true [get_ports dac12_vref_cs_n]
set_property PULLUP true [get_ports flex_scl_io]
set_property PULLUP true [get_ports flex_sda_io]
set_property PULLUP true [get_ports spare03]
set_property PULLUP true [get_ports spare04]
set_property PULLUP true [get_ports spare05]
set_property PULLUP true [get_ports spare06]
set_property PULLUP true [get_ports rs485_ro]
set_property PULLUP true [get_ports amp_over_crt_n]
set_property PULLUP true [get_ports ph_pzt_err_n]
set_property PULLUP true [get_ports oc_cuk1]

## enable pulldowns on current limit inputs to avoid false trips when running
## in a lab testbench setting without waveform boards attached.
#
#set_property PULLDOWN true [get_ports {ilimit[4]}]
#set_property PULLDOWN true [get_ports {ilimit[3]}]
#set_property PULLDOWN true [get_ports {ilimit[2]}]
#set_property PULLDOWN true [get_ports {ilimit[1]}]

# define false paths between 62.5Mhz and related domains and the 100 Mhz fabric clock from PS.
# In addition, ASYNC_REG attribute is set in source on deglitcher flops.

create_clock -period 16.000 -name wave_clk [get_ports wave_clk]
# The 130 MHz, 62.5 MHz and 100 MHz clocks are asynchronous to one other
set_false_path -from [get_clocks clk_fpga_0] -to [get_clocks wave_clk]
set_false_path -from [get_clocks wave_clk] -to [get_clocks clk_fpga_0]

set_false_path -from [get_clocks wave_clk] -to [get_clocks clk_out1_system_clk_wiz_1_0]
set_false_path -from [get_clocks clk_out1_system_clk_wiz_1_0] -to [get_clocks wave_clk]

set_false_path -from [get_clocks clk_fpga_0] -to [get_clocks clk_out1_system_clk_wiz_1_0]
set_false_path -from [get_clocks clk_out1_system_clk_wiz_1_0] -to [get_clocks clk_fpga_0]

# AXI Ethernet GTX 125MHz clock
create_clock -period 8.000 -name gtx_clk [get_ports eth_gtx_clk]

########################


create_debug_core u_ila_0 ila
set_property ALL_PROBE_SAME_MU true [get_debug_cores u_ila_0]
set_property ALL_PROBE_SAME_MU_CNT 2 [get_debug_cores u_ila_0]
set_property C_ADV_TRIGGER false [get_debug_cores u_ila_0]
set_property C_DATA_DEPTH 8192 [get_debug_cores u_ila_0]
set_property C_EN_STRG_QUAL true [get_debug_cores u_ila_0]
set_property C_INPUT_PIPE_STAGES 4 [get_debug_cores u_ila_0]
set_property C_TRIGIN_EN false [get_debug_cores u_ila_0]
set_property C_TRIGOUT_EN false [get_debug_cores u_ila_0]
set_property port_width 1 [get_debug_ports u_ila_0/clk]
connect_debug_port u_ila_0/clk [get_nets [list system_i/processing_system7_0/inst/FCLK_CLK0]]
set_property PROBE_TYPE DATA_AND_TRIGGER [get_debug_ports u_ila_0/probe0]
set_property port_width 15 [get_debug_ports u_ila_0/probe0]
connect_debug_port u_ila_0/probe0 [get_nets [list {system_i/swathCore_0/U0/s/be/zsync_rx_data[0]} {system_i/swathCore_0/U0/s/be/zsync_rx_data[1]} {system_i/swathCore_0/U0/s/be/zsync_rx_data[2]} {system_i/swathCore_0/U0/s/be/zsync_rx_data[3]} {system_i/swathCore_0/U0/s/be/zsync_rx_data[4]} {system_i/swathCore_0/U0/s/be/zsync_rx_data[5]} {system_i/swathCore_0/U0/s/be/zsync_rx_data[6]} {system_i/swathCore_0/U0/s/be/zsync_rx_data[7]} {system_i/swathCore_0/U0/s/be/zsync_rx_data[8]} {system_i/swathCore_0/U0/s/be/zsync_rx_data[9]} {system_i/swathCore_0/U0/s/be/zsync_rx_data[10]} {system_i/swathCore_0/U0/s/be/zsync_rx_data[11]} {system_i/swathCore_0/U0/s/be/zsync_rx_data[12]} {system_i/swathCore_0/U0/s/be/zsync_rx_data[13]} {system_i/swathCore_0/U0/s/be/zsync_rx_data[14]}]]
create_debug_port u_ila_0 probe
set_property PROBE_TYPE DATA_AND_TRIGGER [get_debug_ports u_ila_0/probe1]
set_property port_width 3 [get_debug_ports u_ila_0/probe1]
connect_debug_port u_ila_0/probe1 [get_nets [list {system_i/swathCore_0/U0/s/fe/gtl[1].tl/cstate[0]} {system_i/swathCore_0/U0/s/fe/gtl[1].tl/cstate[1]} {system_i/swathCore_0/U0/s/fe/gtl[1].tl/cstate[2]}]]
create_debug_port u_ila_0 probe
set_property PROBE_TYPE DATA_AND_TRIGGER [get_debug_ports u_ila_0/probe2]
set_property port_width 2 [get_debug_ports u_ila_0/probe2]
connect_debug_port u_ila_0/probe2 [get_nets [list {system_i/swathCore_0/U0/s/fe/gtl[1].tl/triggerMode[0]} {system_i/swathCore_0/U0/s/fe/gtl[1].tl/triggerMode[1]}]]
create_debug_port u_ila_0 probe
set_property PROBE_TYPE DATA_AND_TRIGGER [get_debug_ports u_ila_0/probe3]
set_property port_width 3 [get_debug_ports u_ila_0/probe3]
connect_debug_port u_ila_0/probe3 [get_nets [list {system_i/swathCore_0/U0/s/fe/gtl[0].tl/cstate[0]} {system_i/swathCore_0/U0/s/fe/gtl[0].tl/cstate[1]} {system_i/swathCore_0/U0/s/fe/gtl[0].tl/cstate[2]}]]
create_debug_port u_ila_0 probe
set_property PROBE_TYPE DATA_AND_TRIGGER [get_debug_ports u_ila_0/probe4]
set_property port_width 2 [get_debug_ports u_ila_0/probe4]
connect_debug_port u_ila_0/probe4 [get_nets [list {system_i/swathCore_0/U0/s/fe/gtl[0].tl/triggerMode[0]} {system_i/swathCore_0/U0/s/fe/gtl[0].tl/triggerMode[1]}]]
create_debug_port u_ila_0 probe
set_property PROBE_TYPE DATA_AND_TRIGGER [get_debug_ports u_ila_0/probe5]
set_property port_width 26 [get_debug_ports u_ila_0/probe5]
connect_debug_port u_ila_0/probe5 [get_nets [list {system_i/swathCore_0/U0/s/fe/creg_data[0]} {system_i/swathCore_0/U0/s/fe/creg_data[1]} {system_i/swathCore_0/U0/s/fe/creg_data[2]} {system_i/swathCore_0/U0/s/fe/creg_data[3]} {system_i/swathCore_0/U0/s/fe/creg_data[4]} {system_i/swathCore_0/U0/s/fe/creg_data[5]} {system_i/swathCore_0/U0/s/fe/creg_data[6]} {system_i/swathCore_0/U0/s/fe/creg_data[7]} {system_i/swathCore_0/U0/s/fe/creg_data[8]} {system_i/swathCore_0/U0/s/fe/creg_data[9]} {system_i/swathCore_0/U0/s/fe/creg_data[10]} {system_i/swathCore_0/U0/s/fe/creg_data[11]} {system_i/swathCore_0/U0/s/fe/creg_data[12]} {system_i/swathCore_0/U0/s/fe/creg_data[13]} {system_i/swathCore_0/U0/s/fe/creg_data[14]} {system_i/swathCore_0/U0/s/fe/creg_data[15]} {system_i/swathCore_0/U0/s/fe/creg_data[16]} {system_i/swathCore_0/U0/s/fe/creg_data[17]} {system_i/swathCore_0/U0/s/fe/creg_data[18]} {system_i/swathCore_0/U0/s/fe/creg_data[19]} {system_i/swathCore_0/U0/s/fe/creg_data[20]} {system_i/swathCore_0/U0/s/fe/creg_data[21]} {system_i/swathCore_0/U0/s/fe/creg_data[22]} {system_i/swathCore_0/U0/s/fe/creg_data[23]} {system_i/swathCore_0/U0/s/fe/creg_data[24]} {system_i/swathCore_0/U0/s/fe/creg_data[25]}]]
create_debug_port u_ila_0 probe
set_property PROBE_TYPE DATA_AND_TRIGGER [get_debug_ports u_ila_0/probe6]
set_property port_width 10 [get_debug_ports u_ila_0/probe6]
connect_debug_port u_ila_0/probe6 [get_nets [list {system_i/swathCore_0/U0/s/fe/pending_trigger_count[0]__0[0]} {system_i/swathCore_0/U0/s/fe/pending_trigger_count[0]__0[1]} {system_i/swathCore_0/U0/s/fe/pending_trigger_count[0]__0[2]} {system_i/swathCore_0/U0/s/fe/pending_trigger_count[0]__0[3]} {system_i/swathCore_0/U0/s/fe/pending_trigger_count[0]__0[4]} {system_i/swathCore_0/U0/s/fe/pending_trigger_count[0]__0[5]} {system_i/swathCore_0/U0/s/fe/pending_trigger_count[0]__0[6]} {system_i/swathCore_0/U0/s/fe/pending_trigger_count[0]__0[7]} {system_i/swathCore_0/U0/s/fe/pending_trigger_count[0]__0[8]} {system_i/swathCore_0/U0/s/fe/pending_trigger_count[0]__0[9]}]]
create_debug_port u_ila_0 probe
set_property PROBE_TYPE DATA_AND_TRIGGER [get_debug_ports u_ila_0/probe7]
set_property port_width 10 [get_debug_ports u_ila_0/probe7]
connect_debug_port u_ila_0/probe7 [get_nets [list {system_i/swathCore_0/U0/s/fe/pending_trigger_count[1]__0[0]} {system_i/swathCore_0/U0/s/fe/pending_trigger_count[1]__0[1]} {system_i/swathCore_0/U0/s/fe/pending_trigger_count[1]__0[2]} {system_i/swathCore_0/U0/s/fe/pending_trigger_count[1]__0[3]} {system_i/swathCore_0/U0/s/fe/pending_trigger_count[1]__0[4]} {system_i/swathCore_0/U0/s/fe/pending_trigger_count[1]__0[5]} {system_i/swathCore_0/U0/s/fe/pending_trigger_count[1]__0[6]} {system_i/swathCore_0/U0/s/fe/pending_trigger_count[1]__0[7]} {system_i/swathCore_0/U0/s/fe/pending_trigger_count[1]__0[8]} {system_i/swathCore_0/U0/s/fe/pending_trigger_count[1]__0[9]}]]
create_debug_port u_ila_0 probe
set_property PROBE_TYPE DATA_AND_TRIGGER [get_debug_ports u_ila_0/probe8]
set_property port_width 2 [get_debug_ports u_ila_0/probe8]
connect_debug_port u_ila_0/probe8 [get_nets [list {system_i/swathCore_0/U0/s/fe/trigger_ack[0]} {system_i/swathCore_0/U0/s/fe/trigger_ack[1]}]]
create_debug_port u_ila_0 probe
set_property PROBE_TYPE DATA_AND_TRIGGER [get_debug_ports u_ila_0/probe9]
set_property port_width 2 [get_debug_ports u_ila_0/probe9]
connect_debug_port u_ila_0/probe9 [get_nets [list {system_i/swathCore_0/U0/s/fe/trigger_req[0]} {system_i/swathCore_0/U0/s/fe/trigger_req[1]}]]
create_debug_port u_ila_0 probe
set_property PROBE_TYPE DATA_AND_TRIGGER [get_debug_ports u_ila_0/probe10]
set_property port_width 2 [get_debug_ports u_ila_0/probe10]
connect_debug_port u_ila_0/probe10 [get_nets [list {system_i/swathCore_0/U0/s/fe/trigger_tbfe[0]} {system_i/swathCore_0/U0/s/fe/trigger_tbfe[1]}]]
create_debug_port u_ila_0 probe
set_property PROBE_TYPE DATA_AND_TRIGGER [get_debug_ports u_ila_0/probe11]
set_property port_width 15 [get_debug_ports u_ila_0/probe11]
connect_debug_port u_ila_0/probe11 [get_nets [list {system_i/swathCore_0/U0/s/fe/zsync_rx_data[0]} {system_i/swathCore_0/U0/s/fe/zsync_rx_data[1]} {system_i/swathCore_0/U0/s/fe/zsync_rx_data[2]} {system_i/swathCore_0/U0/s/fe/zsync_rx_data[3]} {system_i/swathCore_0/U0/s/fe/zsync_rx_data[4]} {system_i/swathCore_0/U0/s/fe/zsync_rx_data[5]} {system_i/swathCore_0/U0/s/fe/zsync_rx_data[6]} {system_i/swathCore_0/U0/s/fe/zsync_rx_data[7]} {system_i/swathCore_0/U0/s/fe/zsync_rx_data[8]} {system_i/swathCore_0/U0/s/fe/zsync_rx_data[9]} {system_i/swathCore_0/U0/s/fe/zsync_rx_data[10]} {system_i/swathCore_0/U0/s/fe/zsync_rx_data[11]} {system_i/swathCore_0/U0/s/fe/zsync_rx_data[12]} {system_i/swathCore_0/U0/s/fe/zsync_rx_data[13]} {system_i/swathCore_0/U0/s/fe/zsync_rx_data[14]}]]
create_debug_port u_ila_0 probe
set_property PROBE_TYPE DATA_AND_TRIGGER [get_debug_ports u_ila_0/probe12]
set_property port_width 15 [get_debug_ports u_ila_0/probe12]
connect_debug_port u_ila_0/probe12 [get_nets [list {system_i/swathCore_0/U0/s/fe/zsync_tx_data[0]} {system_i/swathCore_0/U0/s/fe/zsync_tx_data[1]} {system_i/swathCore_0/U0/s/fe/zsync_tx_data[2]} {system_i/swathCore_0/U0/s/fe/zsync_tx_data[3]} {system_i/swathCore_0/U0/s/fe/zsync_tx_data[4]} {system_i/swathCore_0/U0/s/fe/zsync_tx_data[5]} {system_i/swathCore_0/U0/s/fe/zsync_tx_data[6]} {system_i/swathCore_0/U0/s/fe/zsync_tx_data[7]} {system_i/swathCore_0/U0/s/fe/zsync_tx_data[8]} {system_i/swathCore_0/U0/s/fe/zsync_tx_data[9]} {system_i/swathCore_0/U0/s/fe/zsync_tx_data[10]} {system_i/swathCore_0/U0/s/fe/zsync_tx_data[11]} {system_i/swathCore_0/U0/s/fe/zsync_tx_data[12]} {system_i/swathCore_0/U0/s/fe/zsync_tx_data[13]} {system_i/swathCore_0/U0/s/fe/zsync_tx_data[14]}]]
create_debug_port u_ila_0 probe
set_property PROBE_TYPE DATA_AND_TRIGGER [get_debug_ports u_ila_0/probe13]
set_property port_width 8 [get_debug_ports u_ila_0/probe13]
connect_debug_port u_ila_0/probe13 [get_nets [list {system_i/swathCore_0/U0/s/testpoint_creg7_0[0]} {system_i/swathCore_0/U0/s/testpoint_creg7_0[1]} {system_i/swathCore_0/U0/s/testpoint_creg7_0[2]} {system_i/swathCore_0/U0/s/testpoint_creg7_0[3]} {system_i/swathCore_0/U0/s/testpoint_creg7_0[4]} {system_i/swathCore_0/U0/s/testpoint_creg7_0[5]} {system_i/swathCore_0/U0/s/testpoint_creg7_0[6]} {system_i/swathCore_0/U0/s/testpoint_creg7_0[7]}]]
create_debug_port u_ila_0 probe
set_property PROBE_TYPE DATA_AND_TRIGGER [get_debug_ports u_ila_0/probe14]
set_property port_width 1 [get_debug_ports u_ila_0/probe14]
connect_debug_port u_ila_0/probe14 [get_nets [list {system_i/swathCore_0/U0/s/fe/gtl[0].tl/enable}]]
create_debug_port u_ila_0 probe
set_property PROBE_TYPE DATA_AND_TRIGGER [get_debug_ports u_ila_0/probe15]
set_property port_width 1 [get_debug_ports u_ila_0/probe15]
connect_debug_port u_ila_0/probe15 [get_nets [list {system_i/swathCore_0/U0/s/fe/gtl[1].tl/enable}]]
create_debug_port u_ila_0 probe
set_property PROBE_TYPE DATA_AND_TRIGGER [get_debug_ports u_ila_0/probe16]
set_property port_width 1 [get_debug_ports u_ila_0/probe16]
connect_debug_port u_ila_0/probe16 [get_nets [list system_i/swathCore_0/U0/s/fe/encoder_enable]]
create_debug_port u_ila_0 probe
set_property PROBE_TYPE DATA_AND_TRIGGER [get_debug_ports u_ila_0/probe17]
set_property port_width 1 [get_debug_ports u_ila_0/probe17]
connect_debug_port u_ila_0/probe17 [get_nets [list system_i/swathCore_0/U0/s/fe/ETIB_pixel]]
create_debug_port u_ila_0 probe
set_property PROBE_TYPE DATA_AND_TRIGGER [get_debug_ports u_ila_0/probe18]
set_property port_width 1 [get_debug_ports u_ila_0/probe18]
connect_debug_port u_ila_0/probe18 [get_nets [list {system_i/swathCore_0/U0/s/fe/gtl[0].tl/infinite}]]
create_debug_port u_ila_0 probe
set_property PROBE_TYPE DATA_AND_TRIGGER [get_debug_ports u_ila_0/probe19]
set_property port_width 1 [get_debug_ports u_ila_0/probe19]
connect_debug_port u_ila_0/probe19 [get_nets [list {system_i/swathCore_0/U0/s/fe/gtl[1].tl/infinite}]]
create_debug_port u_ila_0 probe
set_property PROBE_TYPE DATA_AND_TRIGGER [get_debug_ports u_ila_0/probe20]
set_property port_width 1 [get_debug_ports u_ila_0/probe20]
connect_debug_port u_ila_0/probe20 [get_nets [list system_i/swathCore_0/U0/s/microsecond_pulse]]
create_debug_port u_ila_0 probe
set_property PROBE_TYPE DATA_AND_TRIGGER [get_debug_ports u_ila_0/probe21]
set_property port_width 1 [get_debug_ports u_ila_0/probe21]
connect_debug_port u_ila_0/probe21 [get_nets [list system_i/swathCore_0/U0/s/millisecond_pulse]]
create_debug_port u_ila_0 probe
set_property PROBE_TYPE DATA_AND_TRIGGER [get_debug_ports u_ila_0/probe22]
set_property port_width 1 [get_debug_ports u_ila_0/probe22]
connect_debug_port u_ila_0/probe22 [get_nets [list {system_i/swathCore_0/U0/s/fe/gtl[1].tl/pending_trigger_enable}]]
create_debug_port u_ila_0 probe
set_property PROBE_TYPE DATA_AND_TRIGGER [get_debug_ports u_ila_0/probe23]
set_property port_width 1 [get_debug_ports u_ila_0/probe23]
connect_debug_port u_ila_0/probe23 [get_nets [list {system_i/swathCore_0/U0/s/fe/gtl[0].tl/pending_trigger_enable}]]
create_debug_port u_ila_0 probe
set_property PROBE_TYPE DATA_AND_TRIGGER [get_debug_ports u_ila_0/probe24]
set_property port_width 1 [get_debug_ports u_ila_0/probe24]
connect_debug_port u_ila_0/probe24 [get_nets [list system_i/swathCore_0/U0/s/fe/pixel]]
create_debug_port u_ila_0 probe
set_property PROBE_TYPE DATA_AND_TRIGGER [get_debug_ports u_ila_0/probe25]
set_property port_width 1 [get_debug_ports u_ila_0/probe25]
connect_debug_port u_ila_0/probe25 [get_nets [list system_i/swathCore_0/U0/s/resync]]
create_debug_port u_ila_0 probe
set_property PROBE_TYPE DATA_AND_TRIGGER [get_debug_ports u_ila_0/probe26]
set_property port_width 1 [get_debug_ports u_ila_0/probe26]
connect_debug_port u_ila_0/probe26 [get_nets [list system_i/swathCore_0/U0/s/fe/rxFIFO_empty]]
create_debug_port u_ila_0 probe
set_property PROBE_TYPE DATA_AND_TRIGGER [get_debug_ports u_ila_0/probe27]
set_property port_width 1 [get_debug_ports u_ila_0/probe27]
connect_debug_port u_ila_0/probe27 [get_nets [list system_i/swathCore_0/U0/s/fe/rxFIFO_full]]
create_debug_port u_ila_0 probe
set_property PROBE_TYPE DATA_AND_TRIGGER [get_debug_ports u_ila_0/probe28]
set_property port_width 1 [get_debug_ports u_ila_0/probe28]
connect_debug_port u_ila_0/probe28 [get_nets [list system_i/swathCore_0/U0/s/fe/rxFIFO_reset_reg]]
create_debug_port u_ila_0 probe
set_property PROBE_TYPE DATA_AND_TRIGGER [get_debug_ports u_ila_0/probe29]
set_property port_width 1 [get_debug_ports u_ila_0/probe29]
connect_debug_port u_ila_0/probe29 [get_nets [list {system_i/swathCore_0/U0/s/fe/gtl[1].tl/trigger}]]
create_debug_port u_ila_0 probe
set_property PROBE_TYPE DATA_AND_TRIGGER [get_debug_ports u_ila_0/probe30]
set_property port_width 1 [get_debug_ports u_ila_0/probe30]
connect_debug_port u_ila_0/probe30 [get_nets [list {system_i/swathCore_0/U0/s/fe/gtl[0].tl/trigger}]]
create_debug_port u_ila_0 probe
set_property PROBE_TYPE DATA_AND_TRIGGER [get_debug_ports u_ila_0/probe31]
set_property port_width 1 [get_debug_ports u_ila_0/probe31]
connect_debug_port u_ila_0/probe31 [get_nets [list system_i/swathCore_0/U0/s/be/tcf/trigger_alarm]]
create_debug_port u_ila_0 probe
set_property PROBE_TYPE DATA_AND_TRIGGER [get_debug_ports u_ila_0/probe32]
set_property port_width 1 [get_debug_ports u_ila_0/probe32]
connect_debug_port u_ila_0/probe32 [get_nets [list {system_i/swathCore_0/U0/s/fe/gtl[1].tl/trigger_out_d}]]
create_debug_port u_ila_0 probe
set_property PROBE_TYPE DATA_AND_TRIGGER [get_debug_ports u_ila_0/probe33]
set_property port_width 1 [get_debug_ports u_ila_0/probe33]
connect_debug_port u_ila_0/probe33 [get_nets [list {system_i/swathCore_0/U0/s/fe/gtl[0].tl/trigger_out_d}]]
create_debug_port u_ila_0 probe
set_property PROBE_TYPE DATA_AND_TRIGGER [get_debug_ports u_ila_0/probe34]
set_property port_width 1 [get_debug_ports u_ila_0/probe34]
connect_debug_port u_ila_0/probe34 [get_nets [list {system_i/swathCore_0/U0/s/fe/gtl[0].tl/trigger_out_d_dly}]]
create_debug_port u_ila_0 probe
set_property PROBE_TYPE DATA_AND_TRIGGER [get_debug_ports u_ila_0/probe35]
set_property port_width 1 [get_debug_ports u_ila_0/probe35]
connect_debug_port u_ila_0/probe35 [get_nets [list {system_i/swathCore_0/U0/s/fe/gtl[1].tl/trigger_out_d_dly}]]
create_debug_port u_ila_0 probe
set_property PROBE_TYPE DATA_AND_TRIGGER [get_debug_ports u_ila_0/probe36]
set_property port_width 1 [get_debug_ports u_ila_0/probe36]
connect_debug_port u_ila_0/probe36 [get_nets [list system_i/swathCore_0/U0/s/fe/txFIFO_empty]]
create_debug_port u_ila_0 probe
set_property PROBE_TYPE DATA_AND_TRIGGER [get_debug_ports u_ila_0/probe37]
set_property port_width 1 [get_debug_ports u_ila_0/probe37]
connect_debug_port u_ila_0/probe37 [get_nets [list system_i/swathCore_0/U0/s/fe/txFIFO_full]]
create_debug_port u_ila_0 probe
set_property PROBE_TYPE DATA_AND_TRIGGER [get_debug_ports u_ila_0/probe38]
set_property port_width 1 [get_debug_ports u_ila_0/probe38]
connect_debug_port u_ila_0/probe38 [get_nets [list system_i/swathCore_0/U0/s/fe/txFIFO_reset_reg]]
create_debug_port u_ila_0 probe
set_property PROBE_TYPE DATA_AND_TRIGGER [get_debug_ports u_ila_0/probe39]
set_property port_width 1 [get_debug_ports u_ila_0/probe39]
connect_debug_port u_ila_0/probe39 [get_nets [list system_i/swathCore_0/U0/s/usec_10]]
create_debug_port u_ila_0 probe
set_property PROBE_TYPE DATA_AND_TRIGGER [get_debug_ports u_ila_0/probe40]
set_property port_width 1 [get_debug_ports u_ila_0/probe40]
connect_debug_port u_ila_0/probe40 [get_nets [list system_i/swathCore_0/U0/s/usec_100]]
create_debug_port u_ila_0 probe
set_property PROBE_TYPE DATA_AND_TRIGGER [get_debug_ports u_ila_0/probe41]
set_property port_width 1 [get_debug_ports u_ila_0/probe41]
connect_debug_port u_ila_0/probe41 [get_nets [list system_i/swathCore_0/U0/s/fe/zsync_rx_error_bit]]
create_debug_port u_ila_0 probe
set_property PROBE_TYPE DATA_AND_TRIGGER [get_debug_ports u_ila_0/probe42]
set_property port_width 1 [get_debug_ports u_ila_0/probe42]
connect_debug_port u_ila_0/probe42 [get_nets [list system_i/swathCore_0/U0/s/be/zsync_rx_pixel]]
create_debug_port u_ila_0 probe
set_property PROBE_TYPE DATA_AND_TRIGGER [get_debug_ports u_ila_0/probe43]
set_property port_width 1 [get_debug_ports u_ila_0/probe43]
connect_debug_port u_ila_0/probe43 [get_nets [list system_i/swathCore_0/U0/s/fe/zsync_rx_pulse]]
create_debug_port u_ila_0 probe
set_property PROBE_TYPE DATA_AND_TRIGGER [get_debug_ports u_ila_0/probe44]
set_property port_width 1 [get_debug_ports u_ila_0/probe44]
connect_debug_port u_ila_0/probe44 [get_nets [list system_i/swathCore_0/U0/s/fe/zsync_tx_pulse]]
set_property C_CLK_INPUT_FREQ_HZ 300000000 [get_debug_cores dbg_hub]
set_property C_ENABLE_CLK_DIVIDER false [get_debug_cores dbg_hub]
set_property C_USER_SCAN_CHAIN 1 [get_debug_cores dbg_hub]
connect_debug_port dbg_hub/clk [get_nets u_ila_0_FCLK_CLK0]
