#------------------------------------------------------------------------------
# Automatically generated by the Fast Binary Encoding compiler, do not modify!
# https://github.com/chronoxor/FastBinaryEncoding
# Source: protoex.fbe
# FBE version: 1.14.5.0
#------------------------------------------------------------------------------

# rubocop:disable Lint/MissingCopEnableDirective
# rubocop:disable Lint/UnneededCopDisableDirective
# rubocop:disable Metrics/AbcSize
# rubocop:disable Metrics/ClassLength
# rubocop:disable Metrics/CyclomaticComplexity
# rubocop:disable Metrics/LineLength
# rubocop:disable Metrics/MethodLength
# rubocop:disable Metrics/PerceivedComplexity

require 'base64'
require 'bigdecimal'
require 'json'
require 'set'
require 'uuidtools'

require_relative 'fbe'
require_relative 'proto'

module Protoex

  module OrderSide
    class Enum
      include FBE::Enum

      define :buy, 0 + 0
      define :sell, 0 + 1
      define :tell, 0 + 2

      def initialize(value = 0)
        @value = value.is_a?(Enum) ? value.value : value
      end

      # Enum compare operators
      def ==(value) @value == value.value end
      def !=(value) @value != value.value end

      # Enum equals
      def eql?(other)
        self == other
      end

      # Enum hash code
      def hash
        @value.hash
      end

      # Get enum integer value
      def to_i
        @value
      end

      # Get enum string value
      def to_s
        if @value == Enum.buy
          return 'buy'
        end
        if @value == Enum.sell
          return 'sell'
        end
        if @value == Enum.tell
          return 'tell'
        end
        '<unknown>'
      end

      # Get enum JSON value
      def __to_json_map__
        @value
      end
    end

    class << self
      attr_accessor :buy
      attr_accessor :sell
      attr_accessor :tell
    end

    self.buy = Enum.new(Enum.buy)
    self.sell = Enum.new(Enum.sell)
    self.tell = Enum.new(Enum.tell)

    def self.new(value = 0)
      Enum.new(value)
    end

    # Get enum value from JSON
    def self.__from_json_map__(json)
      Enum.new(json)
    end
  end

  OrderSide.freeze

  # Fast Binary Encoding OrderSide field model
  class FieldModelOrderSide < FBE::FieldModel
    def initialize(buffer, offset)
        super(buffer, offset)
    end

    # Get the field size
    def fbe_size
      1
    end

    # Get the value
    def get(defaults = OrderSide.new)
      if (@_buffer.offset + fbe_offset + fbe_size) > @_buffer.size
        return defaults
      end

      OrderSide.new(read_byte(fbe_offset))
    end

    # Set the value
    def set(value)
      if (@_buffer.offset + fbe_offset + fbe_size) > @_buffer.size
        return
      end

      write_byte(fbe_offset, value.value)
    end
  end

  # Fast Binary Encoding OrderSide final model
  class FinalModelOrderSide < FBE::FinalModel
    def initialize(buffer, offset)
      super(buffer, offset)
    end

    # Get the allocation size
    # noinspection RubyUnusedLocalVariable
    def fbe_allocation_size(value)
      fbe_size
    end

    # Get the final size
    def fbe_size
      1
    end

    # Is the enum value valid?
    def valid?
      verify
    end

    # Check if the value is valid
    def verify
      if (@_buffer.offset + fbe_offset + fbe_size) > @_buffer.size
        return FBE::Integer::MAX
      end

      fbe_size
    end

    # Get the value
    def get
      if (@_buffer.offset + fbe_offset + fbe_size) > @_buffer.size
        return [OrderSide.new, 0]
      end

      [OrderSide.new(read_byte(fbe_offset)), fbe_size]
    end

    # Set the value
    def set(value)
      if (@_buffer.offset + fbe_offset + fbe_size) > @_buffer.size
        return 0
      end

      write_byte(fbe_offset, value.value)
      fbe_size
    end
  end

  module OrderType
    class Enum
      include FBE::Enum

      define :market, 0 + 0
      define :limit, 0 + 1
      define :stop, 0 + 2
      define :stoplimit, 0 + 3

      def initialize(value = 0)
        @value = value.is_a?(Enum) ? value.value : value
      end

      # Enum compare operators
      def ==(value) @value == value.value end
      def !=(value) @value != value.value end

      # Enum equals
      def eql?(other)
        self == other
      end

      # Enum hash code
      def hash
        @value.hash
      end

      # Get enum integer value
      def to_i
        @value
      end

      # Get enum string value
      def to_s
        if @value == Enum.market
          return 'market'
        end
        if @value == Enum.limit
          return 'limit'
        end
        if @value == Enum.stop
          return 'stop'
        end
        if @value == Enum.stoplimit
          return 'stoplimit'
        end
        '<unknown>'
      end

      # Get enum JSON value
      def __to_json_map__
        @value
      end
    end

    class << self
      attr_accessor :market
      attr_accessor :limit
      attr_accessor :stop
      attr_accessor :stoplimit
    end

    self.market = Enum.new(Enum.market)
    self.limit = Enum.new(Enum.limit)
    self.stop = Enum.new(Enum.stop)
    self.stoplimit = Enum.new(Enum.stoplimit)

    def self.new(value = 0)
      Enum.new(value)
    end

    # Get enum value from JSON
    def self.__from_json_map__(json)
      Enum.new(json)
    end
  end

  OrderType.freeze

  # Fast Binary Encoding OrderType field model
  class FieldModelOrderType < FBE::FieldModel
    def initialize(buffer, offset)
        super(buffer, offset)
    end

    # Get the field size
    def fbe_size
      1
    end

    # Get the value
    def get(defaults = OrderType.new)
      if (@_buffer.offset + fbe_offset + fbe_size) > @_buffer.size
        return defaults
      end

      OrderType.new(read_byte(fbe_offset))
    end

    # Set the value
    def set(value)
      if (@_buffer.offset + fbe_offset + fbe_size) > @_buffer.size
        return
      end

      write_byte(fbe_offset, value.value)
    end
  end

  # Fast Binary Encoding OrderType final model
  class FinalModelOrderType < FBE::FinalModel
    def initialize(buffer, offset)
      super(buffer, offset)
    end

    # Get the allocation size
    # noinspection RubyUnusedLocalVariable
    def fbe_allocation_size(value)
      fbe_size
    end

    # Get the final size
    def fbe_size
      1
    end

    # Is the enum value valid?
    def valid?
      verify
    end

    # Check if the value is valid
    def verify
      if (@_buffer.offset + fbe_offset + fbe_size) > @_buffer.size
        return FBE::Integer::MAX
      end

      fbe_size
    end

    # Get the value
    def get
      if (@_buffer.offset + fbe_offset + fbe_size) > @_buffer.size
        return [OrderType.new, 0]
      end

      [OrderType.new(read_byte(fbe_offset)), fbe_size]
    end

    # Set the value
    def set(value)
      if (@_buffer.offset + fbe_offset + fbe_size) > @_buffer.size
        return 0
      end

      write_byte(fbe_offset, value.value)
      fbe_size
    end
  end

  module StateEx
    class Flags
      include FBE::Flags

      define :unknown, 0x00
      define :invalid, 0x01
      define :initialized, 0x02
      define :calculated, 0x04
      define :broken, 0x08
      define :happy, 0x10
      define :sad, 0x20
      define :good, Flags.value(:initialized)|Flags.value(:calculated)
      define :bad, Flags.value(:unknown)|Flags.value(:invalid)|Flags.value(:broken)

      def initialize(value = 0)
        @value = value.is_a?(Flags) ? value.value : value
      end

      # Flags compare operators
      def ==(flags) @value == flags.value end
      def !=(flags) @value != flags.value end

      # Flags bit operators
      def ~
        Flags.new(~@value)
      end
      def &(flags) Flags.new(@value & flags.value) end
      def |(flags) Flags.new(@value | flags.value) end
      def ^(flags) Flags.new(@value ^ flags.value) end

      # Flags equals
      def eql?(other)
        self == other
      end

      # Flags hash code
      def hash
        @value.hash
      end

      # Is flags set?
      def has_flags(flags)
        ((@value & flags.value) != 0) && ((@value & flags.value) == flags.value)
      end

      # Set flags
      def set_flags(flags)
        @value |= flags.value
        self
      end

      # Remove flags
      def remove_flags(flags)
        @value &= ~flags.value
        self
      end

      # Get flags integer value
      def to_i
        @value
      end

      # Get flags string value
      def to_s
        result = ''
        first = true
        if ((@value & Flags.unknown) != 0) && ((@value & Flags.unknown) == Flags.unknown)
          if first
            # noinspection RubyUnusedLocalVariable
            first = false
          else
            result << '|'
          end
          result << 'unknown'
        end
        if ((@value & Flags.invalid) != 0) && ((@value & Flags.invalid) == Flags.invalid)
          if first
            # noinspection RubyUnusedLocalVariable
            first = false
          else
            result << '|'
          end
          result << 'invalid'
        end
        if ((@value & Flags.initialized) != 0) && ((@value & Flags.initialized) == Flags.initialized)
          if first
            # noinspection RubyUnusedLocalVariable
            first = false
          else
            result << '|'
          end
          result << 'initialized'
        end
        if ((@value & Flags.calculated) != 0) && ((@value & Flags.calculated) == Flags.calculated)
          if first
            # noinspection RubyUnusedLocalVariable
            first = false
          else
            result << '|'
          end
          result << 'calculated'
        end
        if ((@value & Flags.broken) != 0) && ((@value & Flags.broken) == Flags.broken)
          if first
            # noinspection RubyUnusedLocalVariable
            first = false
          else
            result << '|'
          end
          result << 'broken'
        end
        if ((@value & Flags.happy) != 0) && ((@value & Flags.happy) == Flags.happy)
          if first
            # noinspection RubyUnusedLocalVariable
            first = false
          else
            result << '|'
          end
          result << 'happy'
        end
        if ((@value & Flags.sad) != 0) && ((@value & Flags.sad) == Flags.sad)
          if first
            # noinspection RubyUnusedLocalVariable
            first = false
          else
            result << '|'
          end
          result << 'sad'
        end
        if ((@value & Flags.good) != 0) && ((@value & Flags.good) == Flags.good)
          if first
            # noinspection RubyUnusedLocalVariable
            first = false
          else
            result << '|'
          end
          result << 'good'
        end
        if ((@value & Flags.bad) != 0) && ((@value & Flags.bad) == Flags.bad)
          if first
            # noinspection RubyUnusedLocalVariable
            first = false
          else
            result << '|'
          end
          result << 'bad'
        end
        result
      end

      # Get flags JSON value
      def __to_json_map__
        @value
      end
    end

    class << self
      attr_accessor :unknown
      attr_accessor :invalid
      attr_accessor :initialized
      attr_accessor :calculated
      attr_accessor :broken
      attr_accessor :happy
      attr_accessor :sad
      attr_accessor :good
      attr_accessor :bad
    end

    self.unknown = Flags.new(Flags.unknown)
    self.invalid = Flags.new(Flags.invalid)
    self.initialized = Flags.new(Flags.initialized)
    self.calculated = Flags.new(Flags.calculated)
    self.broken = Flags.new(Flags.broken)
    self.happy = Flags.new(Flags.happy)
    self.sad = Flags.new(Flags.sad)
    self.good = Flags.new(Flags.good)
    self.bad = Flags.new(Flags.bad)

    def self.new(value = 0)
      Flags.new(value)
    end

    # Get flags value from JSON
    def self.__from_json_map__(json)
      Flags.new(json)
    end
  end

  StateEx.freeze

  # Fast Binary Encoding StateEx field model
  class FieldModelStateEx < FBE::FieldModel
    def initialize(buffer, offset)
        super(buffer, offset)
    end

    # Get the field size
    def fbe_size
      1
    end

    # Get the value
    def get(defaults = StateEx.new)
      if (@_buffer.offset + fbe_offset + fbe_size) > @_buffer.size
        return defaults
      end

      StateEx.new(read_byte(fbe_offset))
    end

    # Set the value
    def set(value)
      if (@_buffer.offset + fbe_offset + fbe_size) > @_buffer.size
        return
      end

      write_byte(fbe_offset, value.value)
    end
  end

  # Fast Binary Encoding StateEx final model
  class FinalModelStateEx < FBE::FinalModel
    def initialize(buffer, offset)
      super(buffer, offset)
    end

    # Get the allocation size
    # noinspection RubyUnusedLocalVariable
    def fbe_allocation_size(value)
      fbe_size
    end

    # Get the final size
    def fbe_size
      1
    end

    # Is the flags value valid?
    def valid?
      verify
    end

    # Check if the value is valid
    def verify
      if (@_buffer.offset + fbe_offset + fbe_size) > @_buffer.size
        return FBE::Integer::MAX
      end

      fbe_size
    end

    # Get the value
    def get
      if (@_buffer.offset + fbe_offset + fbe_size) > @_buffer.size
        return [StateEx.new, 0]
      end

      [StateEx.new(read_byte(fbe_offset)), fbe_size]
    end

    # Set the value
    def set(value)
      if (@_buffer.offset + fbe_offset + fbe_size) > @_buffer.size
        return 0
      end

      write_byte(fbe_offset, value.value)
      fbe_size
    end
  end

  # noinspection RubyResolve, RubyScope, RubyTooManyInstanceVariablesInspection, RubyTooManyMethodsInspection
  class Order
    include Comparable

    attr_accessor :id
    attr_accessor :symbol
    attr_accessor :side
    attr_accessor :type
    attr_accessor :price
    attr_accessor :volume
    attr_accessor :tp
    attr_accessor :sl

    def initialize(id = 0, symbol = '', side = OrderSide.new, type = OrderType.new, price = 0.0, volume = 0.0, tp = 10.0, sl = -10.0)
      @id = id
      @symbol = symbol
      @side = side
      @type = type
      @price = price
      @volume = volume
      @tp = tp
      @sl = sl
    end

    def initialize_copy(other)
      @id = other.id
      @symbol = other.symbol
      @side = other.side
      @type = other.type
      @price = other.price
      @volume = other.volume
      @tp = other.tp
      @sl = other.sl
    end

    # Struct shallow copy
    def copy(other)
      initialize_copy(other)
      self
    end

    # Struct deep clone
    def clone
      data = Marshal.dump(self)
      clone = Marshal.load(data)
      clone.freeze if frozen?
      clone
    end

    # Struct compare operators
    def <=>(other)
      return nil unless other.is_a?(Order)

      # noinspection RubyUnusedLocalVariable
      result = 0
      result = @id <=> other.id
      if result != 0
        return false
      end
      # noinspection RubyUnnecessaryReturnValue
      result
    end

    # Struct equals
    def eql?(other)
      self == other
    end

    # Struct keys
    def key
      result = []
      result.push(@id)
      # noinspection RubyUnnecessaryReturnValue
      result
    end

    # Struct hash code
    def hash
      key.hash
    end

    # Get struct string value
    def to_s
      result = ''
      result << 'Order('
      result << 'id='
      if !@id.nil?
        result << @id.to_s
      else
        result << 'null'
      end
      result << ',symbol='
      if !@symbol.nil?
        result << '"' << @symbol.to_s << '"'
      else
        result << 'null'
      end
      result << ',side='
      if !@side.nil?
        result << @side.to_s
      else
        result << 'null'
      end
      result << ',type='
      if !@type.nil?
        result << @type.to_s
      else
        result << 'null'
      end
      result << ',price='
      if !@price.nil?
        result << @price.to_s
      else
        result << 'null'
      end
      result << ',volume='
      if !@volume.nil?
        result << @volume.to_s
      else
        result << 'null'
      end
      result << ',tp='
      if !@tp.nil?
        result << @tp.to_s
      else
        result << 'null'
      end
      result << ',sl='
      if !@sl.nil?
        result << @sl.to_s
      else
        result << 'null'
      end
      result << ')'
      result
    end

    # Dump the struct
    def marshal_dump
      # Serialize the struct to the FBE stream
      writer = OrderModel.new(FBE::WriteBuffer.new)
      writer.serialize(self)
      writer.buffer
    end

    # Load the struct
    def marshal_load(data)
      # Deserialize the struct from the FBE stream
      reader = OrderModel.new(FBE::ReadBuffer.new)
      reader.attach_buffer(data)
      initialize_copy(reader.deserialize[0])
    end

    # Get struct JSON value
    def to_json
      JSON.generate(__to_json_map__)
    end

    # Get struct JSON map (internal method)
    def __to_json_map__
      result = {}
      key = 'id'
      value = (id.nil? ? nil : id)
      result.store(key, value)
      key = 'symbol'
      value = (symbol.nil? ? nil : symbol)
      result.store(key, value)
      key = 'side'
      value = (side.nil? ? nil : side.__to_json_map__)
      result.store(key, value)
      key = 'type'
      value = (type.nil? ? nil : type.__to_json_map__)
      result.store(key, value)
      key = 'price'
      value = (price.nil? ? nil : price)
      result.store(key, value)
      key = 'volume'
      value = (volume.nil? ? nil : volume)
      result.store(key, value)
      key = 'tp'
      value = (tp.nil? ? nil : tp)
      result.store(key, value)
      key = 'sl'
      value = (sl.nil? ? nil : sl)
      result.store(key, value)
      result
    end

    # Get struct from JSON
    def self.from_json(json)
      __from_json_map__(JSON.parse(json))
    end

    # Get struct map from JSON (internal method)
    def self.__from_json_map__(json)
      result = Order.new
      value = json.fetch('id', nil)
      result.id = (value.nil? ? nil : value)
      value = json.fetch('symbol', nil)
      result.symbol = (value.nil? ? nil : value)
      value = json.fetch('side', nil)
      result.side = (value.nil? ? nil : OrderSide.__from_json_map__(value))
      value = json.fetch('type', nil)
      result.type = (value.nil? ? nil : OrderType.__from_json_map__(value))
      value = json.fetch('price', nil)
      result.price = (value.nil? ? nil : value)
      value = json.fetch('volume', nil)
      result.volume = (value.nil? ? nil : value)
      value = json.fetch('tp', nil)
      result.tp = (value.nil? ? nil : value)
      value = json.fetch('sl', nil)
      result.sl = (value.nil? ? nil : value)
      result
    end

    # Get the FBE type
    def fbe_type
      TYPE
    end

    TYPE = 1
  end

  # noinspection RubyResolve, RubyScope, RubyTooManyInstanceVariablesInspection, RubyTooManyMethodsInspection
  class FieldModelOrder < FBE::FieldModel
    def initialize(buffer, offset)
      super(buffer, offset)
      @_id = FBE::FieldModelInt32.new(self.buffer, 4 + 4)
      @_symbol = FBE::FieldModelString.new(self.buffer, @_id.fbe_offset + @_id.fbe_size)
      @_side = FieldModelOrderSide.new(self.buffer, @_symbol.fbe_offset + @_symbol.fbe_size)
      @_type = FieldModelOrderType.new(self.buffer, @_side.fbe_offset + @_side.fbe_size)
      @_price = FBE::FieldModelDouble.new(self.buffer, @_type.fbe_offset + @_type.fbe_size)
      @_volume = FBE::FieldModelDouble.new(self.buffer, @_price.fbe_offset + @_price.fbe_size)
      @_tp = FBE::FieldModelDouble.new(self.buffer, @_volume.fbe_offset + @_volume.fbe_size)
      @_sl = FBE::FieldModelDouble.new(self.buffer, @_tp.fbe_offset + @_tp.fbe_size)
    end

    def id
      @_id
    end

    def symbol
      @_symbol
    end

    def side
      @_side
    end

    def type
      @_type
    end

    def price
      @_price
    end

    def volume
      @_volume
    end

    def tp
      @_tp
    end

    def sl
      @_sl
    end

    # Get the field size
    def fbe_size
      4
    end

    # Get the field body size
    def fbe_body
      4 + 4 \
        + id.fbe_size \
        + symbol.fbe_size \
        + side.fbe_size \
        + type.fbe_size \
        + price.fbe_size \
        + volume.fbe_size \
        + tp.fbe_size \
        + sl.fbe_size \
    end

    # Get the field extra size
    def fbe_extra
      if (@_buffer.offset + fbe_offset + fbe_size) > @_buffer.size
        return 0
      end

      fbe_struct_offset = read_uint32(fbe_offset)
      if (fbe_struct_offset == 0) || ((@_buffer.offset + fbe_struct_offset + 4) > @_buffer.size)
        return 0
      end

      @_buffer.shift(fbe_struct_offset)

      fbe_result = fbe_body \
        + id.fbe_extra \
        + symbol.fbe_extra \
        + side.fbe_extra \
        + type.fbe_extra \
        + price.fbe_extra \
        + volume.fbe_extra \
        + tp.fbe_extra \
        + sl.fbe_extra \

      @_buffer.unshift(fbe_struct_offset)

      fbe_result
    end

    # Get the field type
    def fbe_type
      TYPE
    end

    TYPE = 1

    # Is the struct value valid?
    def valid?
      verify
    end

    # Check if the struct value is valid
    def verify(fbe_verify_type = true)
      if (@_buffer.offset + fbe_offset + fbe_size) > @_buffer.size
        return true
      end

      fbe_struct_offset = read_uint32(fbe_offset)
      if (fbe_struct_offset == 0) || ((@_buffer.offset + fbe_struct_offset + 4 + 4) > @_buffer.size)
        return false
      end

      fbe_struct_size = read_uint32(fbe_struct_offset)
      if fbe_struct_size < (4 + 4)
        return false
      end

      fbe_struct_type = read_uint32(fbe_struct_offset + 4)
      if fbe_verify_type && (fbe_struct_type != fbe_type)
        return false
      end

      @_buffer.shift(fbe_struct_offset)
      fbe_result = verify_fields(fbe_struct_size)
      @_buffer.unshift(fbe_struct_offset)
      fbe_result
    end

    # Check if the struct fields are valid
    def verify_fields(fbe_struct_size)
      fbe_current_size = 4 + 4

      if (fbe_current_size + id.fbe_size) > fbe_struct_size
        return true
      end
      unless id.verify
        return false
      end
      # noinspection RubyUnusedLocalVariable
      fbe_current_size += id.fbe_size

      if (fbe_current_size + symbol.fbe_size) > fbe_struct_size
        return true
      end
      unless symbol.verify
        return false
      end
      # noinspection RubyUnusedLocalVariable
      fbe_current_size += symbol.fbe_size

      if (fbe_current_size + side.fbe_size) > fbe_struct_size
        return true
      end
      unless side.verify
        return false
      end
      # noinspection RubyUnusedLocalVariable
      fbe_current_size += side.fbe_size

      if (fbe_current_size + type.fbe_size) > fbe_struct_size
        return true
      end
      unless type.verify
        return false
      end
      # noinspection RubyUnusedLocalVariable
      fbe_current_size += type.fbe_size

      if (fbe_current_size + price.fbe_size) > fbe_struct_size
        return true
      end
      unless price.verify
        return false
      end
      # noinspection RubyUnusedLocalVariable
      fbe_current_size += price.fbe_size

      if (fbe_current_size + volume.fbe_size) > fbe_struct_size
        return true
      end
      unless volume.verify
        return false
      end
      # noinspection RubyUnusedLocalVariable
      fbe_current_size += volume.fbe_size

      if (fbe_current_size + tp.fbe_size) > fbe_struct_size
        return true
      end
      unless tp.verify
        return false
      end
      # noinspection RubyUnusedLocalVariable
      fbe_current_size += tp.fbe_size

      if (fbe_current_size + sl.fbe_size) > fbe_struct_size
        return true
      end
      unless sl.verify
        return false
      end
      # noinspection RubyUnusedLocalVariable
      fbe_current_size += sl.fbe_size

      true
    end

    # Get the struct value (begin phase)
    def get_begin
      if (@_buffer.offset + fbe_offset + fbe_size) > @_buffer.size
        return 0
      end

      fbe_struct_offset = read_uint32(fbe_offset)
      if (fbe_struct_offset == 0) || ((@_buffer.offset + fbe_struct_offset + 4 + 4) > @_buffer.size)
        return 0
      end

      fbe_struct_size = read_uint32(fbe_struct_offset)
      if fbe_struct_size < (4 + 4)
        return 0
      end

      @_buffer.shift(fbe_struct_offset)
      fbe_struct_offset
    end

    # Get the struct value (end phase)
    def get_end(fbe_begin)
      @_buffer.unshift(fbe_begin)
    end

    # Get the struct value
    def get(fbe_value = Order.new)
      fbe_begin = get_begin
      if fbe_begin == 0
        return fbe_value
      end

      fbe_struct_size = read_uint32(0)
      get_fields(fbe_value, fbe_struct_size)
      get_end(fbe_begin)
      fbe_value
    end

    # Get the struct fields values
    def get_fields(fbe_value, fbe_struct_size)
      fbe_current_size = 4 + 4

      if (fbe_current_size + id.fbe_size) <= fbe_struct_size
        fbe_value.id = id.get
      else
        fbe_value.id = 0
      end
      # noinspection RubyUnusedLocalVariable
      fbe_current_size += id.fbe_size

      if (fbe_current_size + symbol.fbe_size) <= fbe_struct_size
        fbe_value.symbol = symbol.get
      else
        fbe_value.symbol = ''
      end
      # noinspection RubyUnusedLocalVariable
      fbe_current_size += symbol.fbe_size

      if (fbe_current_size + side.fbe_size) <= fbe_struct_size
        fbe_value.side = side.get
      else
        fbe_value.side = OrderSide.new
      end
      # noinspection RubyUnusedLocalVariable
      fbe_current_size += side.fbe_size

      if (fbe_current_size + type.fbe_size) <= fbe_struct_size
        fbe_value.type = type.get
      else
        fbe_value.type = OrderType.new
      end
      # noinspection RubyUnusedLocalVariable
      fbe_current_size += type.fbe_size

      if (fbe_current_size + price.fbe_size) <= fbe_struct_size
        fbe_value.price = price.get(0.0)
      else
        fbe_value.price = 0.0
      end
      # noinspection RubyUnusedLocalVariable
      fbe_current_size += price.fbe_size

      if (fbe_current_size + volume.fbe_size) <= fbe_struct_size
        fbe_value.volume = volume.get(0.0)
      else
        fbe_value.volume = 0.0
      end
      # noinspection RubyUnusedLocalVariable
      fbe_current_size += volume.fbe_size

      if (fbe_current_size + tp.fbe_size) <= fbe_struct_size
        fbe_value.tp = tp.get(10.0)
      else
        fbe_value.tp = 10.0
      end
      # noinspection RubyUnusedLocalVariable
      fbe_current_size += tp.fbe_size

      if (fbe_current_size + sl.fbe_size) <= fbe_struct_size
        fbe_value.sl = sl.get(-10.0)
      else
        fbe_value.sl = -10.0
      end
      # noinspection RubyUnusedLocalVariable
      fbe_current_size += sl.fbe_size
    end

    # Set the struct value (begin phase)
    def set_begin
      if (@_buffer.offset + fbe_offset + fbe_size) > @_buffer.size
        return 0
      end

      fbe_struct_size = fbe_body
      fbe_struct_offset = @_buffer.allocate(fbe_struct_size) - @_buffer.offset
      if (fbe_struct_offset <= 0) || ((@_buffer.offset + fbe_struct_offset + fbe_struct_size) > @_buffer.size)
        return 0
      end

      write_uint32(fbe_offset, fbe_struct_offset)
      write_uint32(fbe_struct_offset, fbe_struct_size)
      write_uint32(fbe_struct_offset + 4, fbe_type)

      @_buffer.shift(fbe_struct_offset)
      fbe_struct_offset
    end

    # Set the struct value (end phase)
    def set_end(fbe_begin)
      @_buffer.unshift(fbe_begin)
    end

    # Set the struct value
    def set(fbe_value)
      fbe_begin = set_begin
      if fbe_begin == 0
        return
      end

      set_fields(fbe_value)
      set_end(fbe_begin)
    end

    # Set the struct fields values
    def set_fields(fbe_value)
      id.set(fbe_value.id)
      symbol.set(fbe_value.symbol)
      side.set(fbe_value.side)
      type.set(fbe_value.type)
      price.set(fbe_value.price)
      volume.set(fbe_value.volume)
      tp.set(fbe_value.tp)
      sl.set(fbe_value.sl)
    end
  end

  # Fast Binary Encoding Order model
  class OrderModel < FBE::Model
    def initialize(buffer = FBE::WriteBuffer.new)
      super(buffer)
      @_model = FieldModelOrder.new(self.buffer, 4)
    end

    def model
      @_model
    end

    # Get the model size
    def fbe_size
      @_model.fbe_size + @_model.fbe_extra
    end

    # Get the model type
    def fbe_type
      TYPE
    end

    TYPE = FieldModelOrder::TYPE

    # Is the struct value valid?
    def valid?
      verify
    end

    # Check if the struct value is valid
    def verify
      if (buffer.offset + @_model.fbe_offset - 4) > buffer.size
        return false
      end

      fbe_full_size = read_uint32(@_model.fbe_offset - 4)
      if fbe_full_size < @_model.fbe_size
        return false
      end

      @_model.verify
    end

    # Create a new model (begin phase)
    def create_begin
      buffer.allocate(4 + @_model.fbe_size)
    end

    # Create a new model (end phase)
    def create_end(fbe_begin)
      fbe_end = buffer.size
      fbe_full_size = fbe_end - fbe_begin
      write_uint32(@_model.fbe_offset - 4, fbe_full_size)
      fbe_full_size
    end

    # Serialize the struct value
    def serialize(value)
      fbe_begin = create_begin
      @_model.set(value)
      create_end(fbe_begin)
    end

    # Deserialize the struct value
    def deserialize(value = Order.new)
      if (buffer.offset + @_model.fbe_offset - 4) > buffer.size
        [Order.new, 0]
      end

      fbe_full_size = read_uint32(@_model.fbe_offset - 4)
      if fbe_full_size < @_model.fbe_size
        [Order.new, 0]
      end

      @_model.get(value)
      [value, fbe_full_size]
    end

    # Move to the next struct value
    def next(prev)
      @_model.fbe_shift(prev)
    end
  end

  # noinspection RubyResolve, RubyScope, RubyTooManyInstanceVariablesInspection, RubyTooManyMethodsInspection
  class FinalModelOrder < FBE::FinalModel
    def initialize(buffer, offset)
      super(buffer, offset)
      @_id = FBE::FinalModelInt32.new(self.buffer, 0)
      @_symbol = FBE::FinalModelString.new(self.buffer, 0)
      @_side = FinalModelOrderSide.new(self.buffer, 0)
      @_type = FinalModelOrderType.new(self.buffer, 0)
      @_price = FBE::FinalModelDouble.new(self.buffer, 0)
      @_volume = FBE::FinalModelDouble.new(self.buffer, 0)
      @_tp = FBE::FinalModelDouble.new(self.buffer, 0)
      @_sl = FBE::FinalModelDouble.new(self.buffer, 0)
    end

    def id
      @_id
    end

    def symbol
      @_symbol
    end

    def side
      @_side
    end

    def type
      @_type
    end

    def price
      @_price
    end

    def volume
      @_volume
    end

    def tp
      @_tp
    end

    def sl
      @_sl
    end

    # Get the allocation size
    def fbe_allocation_size(fbe_value)
      0 \
        + id.fbe_allocation_size(fbe_value.id) \
        + symbol.fbe_allocation_size(fbe_value.symbol) \
        + side.fbe_allocation_size(fbe_value.side) \
        + type.fbe_allocation_size(fbe_value.type) \
        + price.fbe_allocation_size(fbe_value.price) \
        + volume.fbe_allocation_size(fbe_value.volume) \
        + tp.fbe_allocation_size(fbe_value.tp) \
        + sl.fbe_allocation_size(fbe_value.sl) \
    end

    # Get the final type
    def fbe_type
      TYPE
    end

    TYPE = 1

    # Is the struct value valid?
    def valid?
      verify
    end

    # Check if the struct value is valid
    def verify
      @_buffer.shift(fbe_offset)
      fbe_result = verify_fields
      @_buffer.unshift(fbe_offset)
      fbe_result
    end

    # Check if the struct fields are valid
    def verify_fields
      fbe_current_offset = 0

      id.fbe_offset = fbe_current_offset
      fbe_field_size = id.verify
      if fbe_field_size == FBE::Integer::MAX
        return FBE::Integer::MAX
      end
      fbe_current_offset += fbe_field_size

      symbol.fbe_offset = fbe_current_offset
      fbe_field_size = symbol.verify
      if fbe_field_size == FBE::Integer::MAX
        return FBE::Integer::MAX
      end
      fbe_current_offset += fbe_field_size

      side.fbe_offset = fbe_current_offset
      fbe_field_size = side.verify
      if fbe_field_size == FBE::Integer::MAX
        return FBE::Integer::MAX
      end
      fbe_current_offset += fbe_field_size

      type.fbe_offset = fbe_current_offset
      fbe_field_size = type.verify
      if fbe_field_size == FBE::Integer::MAX
        return FBE::Integer::MAX
      end
      fbe_current_offset += fbe_field_size

      price.fbe_offset = fbe_current_offset
      fbe_field_size = price.verify
      if fbe_field_size == FBE::Integer::MAX
        return FBE::Integer::MAX
      end
      fbe_current_offset += fbe_field_size

      volume.fbe_offset = fbe_current_offset
      fbe_field_size = volume.verify
      if fbe_field_size == FBE::Integer::MAX
        return FBE::Integer::MAX
      end
      fbe_current_offset += fbe_field_size

      tp.fbe_offset = fbe_current_offset
      fbe_field_size = tp.verify
      if fbe_field_size == FBE::Integer::MAX
        return FBE::Integer::MAX
      end
      fbe_current_offset += fbe_field_size

      sl.fbe_offset = fbe_current_offset
      fbe_field_size = sl.verify
      if fbe_field_size == FBE::Integer::MAX
        return FBE::Integer::MAX
      end
      fbe_current_offset += fbe_field_size

      # noinspection RubyUnnecessaryReturnValue
      fbe_current_offset
    end

    # Get the struct value
    def get(fbe_value = Order.new)
      @_buffer.shift(fbe_offset)
      fbe_size = get_fields(fbe_value)
      @_buffer.unshift(fbe_offset)
      [fbe_value, fbe_size]
    end

    # Get the struct fields values
    def get_fields(fbe_value)
      fbe_current_offset = 0
      fbe_current_size = 0

      id.fbe_offset = fbe_current_offset
      fbe_result = id.get
      fbe_value.id = fbe_result[0]
      # noinspection RubyUnusedLocalVariable
      fbe_current_offset += fbe_result[1]
      fbe_current_size += fbe_result[1]

      symbol.fbe_offset = fbe_current_offset
      fbe_result = symbol.get
      fbe_value.symbol = fbe_result[0]
      # noinspection RubyUnusedLocalVariable
      fbe_current_offset += fbe_result[1]
      fbe_current_size += fbe_result[1]

      side.fbe_offset = fbe_current_offset
      fbe_result = side.get
      fbe_value.side = fbe_result[0]
      # noinspection RubyUnusedLocalVariable
      fbe_current_offset += fbe_result[1]
      fbe_current_size += fbe_result[1]

      type.fbe_offset = fbe_current_offset
      fbe_result = type.get
      fbe_value.type = fbe_result[0]
      # noinspection RubyUnusedLocalVariable
      fbe_current_offset += fbe_result[1]
      fbe_current_size += fbe_result[1]

      price.fbe_offset = fbe_current_offset
      fbe_result = price.get
      fbe_value.price = fbe_result[0]
      # noinspection RubyUnusedLocalVariable
      fbe_current_offset += fbe_result[1]
      fbe_current_size += fbe_result[1]

      volume.fbe_offset = fbe_current_offset
      fbe_result = volume.get
      fbe_value.volume = fbe_result[0]
      # noinspection RubyUnusedLocalVariable
      fbe_current_offset += fbe_result[1]
      fbe_current_size += fbe_result[1]

      tp.fbe_offset = fbe_current_offset
      fbe_result = tp.get
      fbe_value.tp = fbe_result[0]
      # noinspection RubyUnusedLocalVariable
      fbe_current_offset += fbe_result[1]
      fbe_current_size += fbe_result[1]

      sl.fbe_offset = fbe_current_offset
      fbe_result = sl.get
      fbe_value.sl = fbe_result[0]
      # noinspection RubyUnusedLocalVariable
      fbe_current_offset += fbe_result[1]
      fbe_current_size += fbe_result[1]

      # noinspection RubyUnnecessaryReturnValue
      fbe_current_size
    end

    # Set the struct value
    def set(fbe_value)
      @_buffer.shift(fbe_offset)
      fbe_size = set_fields(fbe_value)
      @_buffer.unshift(fbe_offset)
      fbe_size
    end

    # Set the struct fields values
    def set_fields(fbe_value)
      fbe_current_offset = 0
      fbe_current_size = 0

      id.fbe_offset = fbe_current_offset
      fbe_field_size = id.set(fbe_value.id)
      # noinspection RubyUnusedLocalVariable
      fbe_current_offset += fbe_field_size
      fbe_current_size += fbe_field_size

      symbol.fbe_offset = fbe_current_offset
      fbe_field_size = symbol.set(fbe_value.symbol)
      # noinspection RubyUnusedLocalVariable
      fbe_current_offset += fbe_field_size
      fbe_current_size += fbe_field_size

      side.fbe_offset = fbe_current_offset
      fbe_field_size = side.set(fbe_value.side)
      # noinspection RubyUnusedLocalVariable
      fbe_current_offset += fbe_field_size
      fbe_current_size += fbe_field_size

      type.fbe_offset = fbe_current_offset
      fbe_field_size = type.set(fbe_value.type)
      # noinspection RubyUnusedLocalVariable
      fbe_current_offset += fbe_field_size
      fbe_current_size += fbe_field_size

      price.fbe_offset = fbe_current_offset
      fbe_field_size = price.set(fbe_value.price)
      # noinspection RubyUnusedLocalVariable
      fbe_current_offset += fbe_field_size
      fbe_current_size += fbe_field_size

      volume.fbe_offset = fbe_current_offset
      fbe_field_size = volume.set(fbe_value.volume)
      # noinspection RubyUnusedLocalVariable
      fbe_current_offset += fbe_field_size
      fbe_current_size += fbe_field_size

      tp.fbe_offset = fbe_current_offset
      fbe_field_size = tp.set(fbe_value.tp)
      # noinspection RubyUnusedLocalVariable
      fbe_current_offset += fbe_field_size
      fbe_current_size += fbe_field_size

      sl.fbe_offset = fbe_current_offset
      fbe_field_size = sl.set(fbe_value.sl)
      # noinspection RubyUnusedLocalVariable
      fbe_current_offset += fbe_field_size
      fbe_current_size += fbe_field_size

      # noinspection RubyUnnecessaryReturnValue
      fbe_current_size
    end
  end

  # Fast Binary Encoding Order final model
  class OrderFinalModel < FBE::Model
    def initialize(buffer = FBE::WriteBuffer.new)
      super(buffer)
      @_model = FinalModelOrder.new(self.buffer, 8)
    end

    # Get the model type
    def fbe_type
      TYPE
    end

    TYPE = FinalModelOrder::TYPE

    # Is the struct value valid?
    def valid?
      verify
    end

    # Check if the struct value is valid
    def verify
      if (buffer.offset + @_model.fbe_offset) > buffer.size
        return false
      end

      fbe_struct_size = read_uint32(@_model.fbe_offset - 8)
      fbe_struct_type = read_uint32(@_model.fbe_offset - 4)
      if (fbe_struct_size <= 0) or (fbe_struct_type != fbe_type)
        return false
      end

      (8 + @_model.verify) == fbe_struct_size
    end

    # Serialize the struct value
    def serialize(value)
      fbe_initial_size = buffer.size

      fbe_struct_type = fbe_type
      fbe_struct_size = 8 + @_model.fbe_allocation_size(value)
      fbe_struct_offset = buffer.allocate(fbe_struct_size) - buffer.offset
      if (buffer.offset + fbe_struct_offset + fbe_struct_size) > buffer.size
        return 0
      end

      fbe_struct_size = 8 + @_model.set(value)
      buffer.resize(fbe_initial_size + fbe_struct_size)

      write_uint32(@_model.fbe_offset - 8, fbe_struct_size)
      write_uint32(@_model.fbe_offset - 4, fbe_struct_type)

      fbe_struct_size
    end

    # Deserialize the struct value
    def deserialize(value = Order.new)
      if (buffer.offset + @_model.fbe_offset) > buffer.size
        [Order.new, 0]
      end

      fbe_struct_size = read_uint32(@_model.fbe_offset - 8)
      fbe_struct_type = read_uint32(@_model.fbe_offset - 4)
      if (fbe_struct_size <= 0) || (fbe_struct_type != fbe_type)
        [Order.new, 8]
      end

      fbe_result = @_model.get(value)
      [fbe_result[0], (8 + fbe_result[1])]
    end

    # Move to the next struct value
    def next(prev)
      @_model.fbe_shift(prev)
    end
  end

  # noinspection RubyResolve, RubyScope, RubyTooManyInstanceVariablesInspection, RubyTooManyMethodsInspection
  class Balance < Proto::Balance
    include Comparable

    attr_accessor :locked

    def initialize(parent = Proto::Balance.new, locked = 0.0)
      method(:initialize_copy).super_method.call(parent)
      @locked = locked
    end

    def initialize_copy(other)
      super(other)
      @locked = other.locked
    end

    # Struct shallow copy
    def copy(other)
      initialize_copy(other)
      self
    end

    # Struct deep clone
    def clone
      data = Marshal.dump(self)
      clone = Marshal.load(data)
      clone.freeze if frozen?
      clone
    end

    # Struct compare operators
    def <=>(other)
      return nil unless other.is_a?(Balance)

      # noinspection RubyUnusedLocalVariable
      result = 0
      result = super
      if result != 0
        return result
      end
      # noinspection RubyUnnecessaryReturnValue
      result
    end

    # Struct equals
    def eql?(other)
      self == other
    end

    # Struct keys
    def key
      result = []
      result.push(super)
      # noinspection RubyUnnecessaryReturnValue
      result
    end

    # Struct hash code
    def hash
      key.hash
    end

    # Get struct string value
    def to_s
      result = ''
      result << 'Balance('
      result << super
      result << ',locked='
      if !@locked.nil?
        result << @locked.to_s
      else
        result << 'null'
      end
      result << ')'
      result
    end

    # Dump the struct
    def marshal_dump
      # Serialize the struct to the FBE stream
      writer = BalanceModel.new(FBE::WriteBuffer.new)
      writer.serialize(self)
      writer.buffer
    end

    # Load the struct
    def marshal_load(data)
      # Deserialize the struct from the FBE stream
      reader = BalanceModel.new(FBE::ReadBuffer.new)
      reader.attach_buffer(data)
      initialize_copy(reader.deserialize[0])
    end

    # Get struct JSON value
    def to_json
      JSON.generate(__to_json_map__)
    end

    # Get struct JSON map (internal method)
    def __to_json_map__
      result = {}
      result.update(super)
      key = 'locked'
      value = (locked.nil? ? nil : locked)
      result.store(key, value)
      result
    end

    # Get struct from JSON
    def self.from_json(json)
      __from_json_map__(JSON.parse(json))
    end

    # Get struct map from JSON (internal method)
    def self.__from_json_map__(json)
      result = Balance.new
      result.method(:initialize_copy).super_method.call(Balance.method(:__from_json_map__).super_method.call(json))
      value = json.fetch('locked', nil)
      result.locked = (value.nil? ? nil : value)
      result
    end

    # Get the FBE type
    def fbe_type
      TYPE
    end

    TYPE = Proto::Balance::TYPE
  end

  # noinspection RubyResolve, RubyScope, RubyTooManyInstanceVariablesInspection, RubyTooManyMethodsInspection
  class FieldModelBalance < FBE::FieldModel
    def initialize(buffer, offset)
      super(buffer, offset)
      @_parent = Proto::FieldModelBalance.new(self.buffer, 4 + 4)
      @_locked = FBE::FieldModelDouble.new(self.buffer, @_parent.fbe_offset + @_parent.fbe_body - 4 - 4)
    end

    def parent
      @_parent
    end

    def locked
      @_locked
    end

    # Get the field size
    def fbe_size
      4
    end

    # Get the field body size
    def fbe_body
      4 + 4 \
        + parent.fbe_body - 4 - 4 \
        + locked.fbe_size \
    end

    # Get the field extra size
    def fbe_extra
      if (@_buffer.offset + fbe_offset + fbe_size) > @_buffer.size
        return 0
      end

      fbe_struct_offset = read_uint32(fbe_offset)
      if (fbe_struct_offset == 0) || ((@_buffer.offset + fbe_struct_offset + 4) > @_buffer.size)
        return 0
      end

      @_buffer.shift(fbe_struct_offset)

      fbe_result = fbe_body \
        + parent.fbe_extra \
        + locked.fbe_extra \

      @_buffer.unshift(fbe_struct_offset)

      fbe_result
    end

    # Get the field type
    def fbe_type
      TYPE
    end

    TYPE = Proto::FieldModelBalance::TYPE

    # Is the struct value valid?
    def valid?
      verify
    end

    # Check if the struct value is valid
    def verify(fbe_verify_type = true)
      if (@_buffer.offset + fbe_offset + fbe_size) > @_buffer.size
        return true
      end

      fbe_struct_offset = read_uint32(fbe_offset)
      if (fbe_struct_offset == 0) || ((@_buffer.offset + fbe_struct_offset + 4 + 4) > @_buffer.size)
        return false
      end

      fbe_struct_size = read_uint32(fbe_struct_offset)
      if fbe_struct_size < (4 + 4)
        return false
      end

      fbe_struct_type = read_uint32(fbe_struct_offset + 4)
      if fbe_verify_type && (fbe_struct_type != fbe_type)
        return false
      end

      @_buffer.shift(fbe_struct_offset)
      fbe_result = verify_fields(fbe_struct_size)
      @_buffer.unshift(fbe_struct_offset)
      fbe_result
    end

    # Check if the struct fields are valid
    def verify_fields(fbe_struct_size)
      fbe_current_size = 4 + 4

      if (fbe_current_size + parent.fbe_body - 4 - 4) > fbe_struct_size
        return true
      end
      unless parent.verify_fields(fbe_struct_size)
        return false
      end
      # noinspection RubyUnusedLocalVariable
      fbe_current_size += parent.fbe_body - 4 - 4

      if (fbe_current_size + locked.fbe_size) > fbe_struct_size
        return true
      end
      unless locked.verify
        return false
      end
      # noinspection RubyUnusedLocalVariable
      fbe_current_size += locked.fbe_size

      true
    end

    # Get the struct value (begin phase)
    def get_begin
      if (@_buffer.offset + fbe_offset + fbe_size) > @_buffer.size
        return 0
      end

      fbe_struct_offset = read_uint32(fbe_offset)
      if (fbe_struct_offset == 0) || ((@_buffer.offset + fbe_struct_offset + 4 + 4) > @_buffer.size)
        return 0
      end

      fbe_struct_size = read_uint32(fbe_struct_offset)
      if fbe_struct_size < (4 + 4)
        return 0
      end

      @_buffer.shift(fbe_struct_offset)
      fbe_struct_offset
    end

    # Get the struct value (end phase)
    def get_end(fbe_begin)
      @_buffer.unshift(fbe_begin)
    end

    # Get the struct value
    def get(fbe_value = Balance.new)
      fbe_begin = get_begin
      if fbe_begin == 0
        return fbe_value
      end

      fbe_struct_size = read_uint32(0)
      get_fields(fbe_value, fbe_struct_size)
      get_end(fbe_begin)
      fbe_value
    end

    # Get the struct fields values
    def get_fields(fbe_value, fbe_struct_size)
      fbe_current_size = 4 + 4

      if (fbe_current_size + parent.fbe_body - 4 - 4) <= fbe_struct_size
        parent.get_fields(fbe_value, fbe_struct_size)
      end
      # noinspection RubyUnusedLocalVariable
      fbe_current_size += parent.fbe_body - 4 - 4

      if (fbe_current_size + locked.fbe_size) <= fbe_struct_size
        fbe_value.locked = locked.get(0.0)
      else
        fbe_value.locked = 0.0
      end
      # noinspection RubyUnusedLocalVariable
      fbe_current_size += locked.fbe_size
    end

    # Set the struct value (begin phase)
    def set_begin
      if (@_buffer.offset + fbe_offset + fbe_size) > @_buffer.size
        return 0
      end

      fbe_struct_size = fbe_body
      fbe_struct_offset = @_buffer.allocate(fbe_struct_size) - @_buffer.offset
      if (fbe_struct_offset <= 0) || ((@_buffer.offset + fbe_struct_offset + fbe_struct_size) > @_buffer.size)
        return 0
      end

      write_uint32(fbe_offset, fbe_struct_offset)
      write_uint32(fbe_struct_offset, fbe_struct_size)
      write_uint32(fbe_struct_offset + 4, fbe_type)

      @_buffer.shift(fbe_struct_offset)
      fbe_struct_offset
    end

    # Set the struct value (end phase)
    def set_end(fbe_begin)
      @_buffer.unshift(fbe_begin)
    end

    # Set the struct value
    def set(fbe_value)
      fbe_begin = set_begin
      if fbe_begin == 0
        return
      end

      set_fields(fbe_value)
      set_end(fbe_begin)
    end

    # Set the struct fields values
    def set_fields(fbe_value)
      parent.set_fields(fbe_value)
      locked.set(fbe_value.locked)
    end
  end

  # Fast Binary Encoding Balance model
  class BalanceModel < FBE::Model
    def initialize(buffer = FBE::WriteBuffer.new)
      super(buffer)
      @_model = FieldModelBalance.new(self.buffer, 4)
    end

    def model
      @_model
    end

    # Get the model size
    def fbe_size
      @_model.fbe_size + @_model.fbe_extra
    end

    # Get the model type
    def fbe_type
      TYPE
    end

    TYPE = FieldModelBalance::TYPE

    # Is the struct value valid?
    def valid?
      verify
    end

    # Check if the struct value is valid
    def verify
      if (buffer.offset + @_model.fbe_offset - 4) > buffer.size
        return false
      end

      fbe_full_size = read_uint32(@_model.fbe_offset - 4)
      if fbe_full_size < @_model.fbe_size
        return false
      end

      @_model.verify
    end

    # Create a new model (begin phase)
    def create_begin
      buffer.allocate(4 + @_model.fbe_size)
    end

    # Create a new model (end phase)
    def create_end(fbe_begin)
      fbe_end = buffer.size
      fbe_full_size = fbe_end - fbe_begin
      write_uint32(@_model.fbe_offset - 4, fbe_full_size)
      fbe_full_size
    end

    # Serialize the struct value
    def serialize(value)
      fbe_begin = create_begin
      @_model.set(value)
      create_end(fbe_begin)
    end

    # Deserialize the struct value
    def deserialize(value = Balance.new)
      if (buffer.offset + @_model.fbe_offset - 4) > buffer.size
        [Balance.new, 0]
      end

      fbe_full_size = read_uint32(@_model.fbe_offset - 4)
      if fbe_full_size < @_model.fbe_size
        [Balance.new, 0]
      end

      @_model.get(value)
      [value, fbe_full_size]
    end

    # Move to the next struct value
    def next(prev)
      @_model.fbe_shift(prev)
    end
  end

  # noinspection RubyResolve, RubyScope, RubyTooManyInstanceVariablesInspection, RubyTooManyMethodsInspection
  class FinalModelBalance < FBE::FinalModel
    def initialize(buffer, offset)
      super(buffer, offset)
      @_parent = Proto::FinalModelBalance.new(self.buffer, 0)
      @_locked = FBE::FinalModelDouble.new(self.buffer, 0)
    end

    def parent
      @_parent
    end

    def locked
      @_locked
    end

    # Get the allocation size
    def fbe_allocation_size(fbe_value)
      0 \
        + parent.fbe_allocation_size(fbe_value) \
        + locked.fbe_allocation_size(fbe_value.locked) \
    end

    # Get the final type
    def fbe_type
      TYPE
    end

    TYPE = Proto::FinalModelBalance::TYPE

    # Is the struct value valid?
    def valid?
      verify
    end

    # Check if the struct value is valid
    def verify
      @_buffer.shift(fbe_offset)
      fbe_result = verify_fields
      @_buffer.unshift(fbe_offset)
      fbe_result
    end

    # Check if the struct fields are valid
    def verify_fields
      fbe_current_offset = 0

      parent.fbe_offset = fbe_current_offset
      fbe_field_size = parent.verify_fields
      if fbe_field_size == FBE::Integer::MAX
        return FBE::Integer::MAX
      end
      fbe_current_offset += fbe_field_size

      locked.fbe_offset = fbe_current_offset
      fbe_field_size = locked.verify
      if fbe_field_size == FBE::Integer::MAX
        return FBE::Integer::MAX
      end
      fbe_current_offset += fbe_field_size

      # noinspection RubyUnnecessaryReturnValue
      fbe_current_offset
    end

    # Get the struct value
    def get(fbe_value = Balance.new)
      @_buffer.shift(fbe_offset)
      fbe_size = get_fields(fbe_value)
      @_buffer.unshift(fbe_offset)
      [fbe_value, fbe_size]
    end

    # Get the struct fields values
    def get_fields(fbe_value)
      fbe_current_offset = 0
      fbe_current_size = 0

      parent.fbe_offset = fbe_current_offset
      fbe_result = parent.get_fields(fbe_value)
      # noinspection RubyUnusedLocalVariable
      fbe_current_offset += fbe_result
      fbe_current_size += fbe_result

      locked.fbe_offset = fbe_current_offset
      fbe_result = locked.get
      fbe_value.locked = fbe_result[0]
      # noinspection RubyUnusedLocalVariable
      fbe_current_offset += fbe_result[1]
      fbe_current_size += fbe_result[1]

      # noinspection RubyUnnecessaryReturnValue
      fbe_current_size
    end

    # Set the struct value
    def set(fbe_value)
      @_buffer.shift(fbe_offset)
      fbe_size = set_fields(fbe_value)
      @_buffer.unshift(fbe_offset)
      fbe_size
    end

    # Set the struct fields values
    def set_fields(fbe_value)
      fbe_current_offset = 0
      fbe_current_size = 0

      parent.fbe_offset = fbe_current_offset
      fbe_field_size = parent.set_fields(fbe_value)
      # noinspection RubyUnusedLocalVariable
      fbe_current_offset += fbe_field_size
      fbe_current_size += fbe_field_size

      locked.fbe_offset = fbe_current_offset
      fbe_field_size = locked.set(fbe_value.locked)
      # noinspection RubyUnusedLocalVariable
      fbe_current_offset += fbe_field_size
      fbe_current_size += fbe_field_size

      # noinspection RubyUnnecessaryReturnValue
      fbe_current_size
    end
  end

  # Fast Binary Encoding Balance final model
  class BalanceFinalModel < FBE::Model
    def initialize(buffer = FBE::WriteBuffer.new)
      super(buffer)
      @_model = FinalModelBalance.new(self.buffer, 8)
    end

    # Get the model type
    def fbe_type
      TYPE
    end

    TYPE = FinalModelBalance::TYPE

    # Is the struct value valid?
    def valid?
      verify
    end

    # Check if the struct value is valid
    def verify
      if (buffer.offset + @_model.fbe_offset) > buffer.size
        return false
      end

      fbe_struct_size = read_uint32(@_model.fbe_offset - 8)
      fbe_struct_type = read_uint32(@_model.fbe_offset - 4)
      if (fbe_struct_size <= 0) or (fbe_struct_type != fbe_type)
        return false
      end

      (8 + @_model.verify) == fbe_struct_size
    end

    # Serialize the struct value
    def serialize(value)
      fbe_initial_size = buffer.size

      fbe_struct_type = fbe_type
      fbe_struct_size = 8 + @_model.fbe_allocation_size(value)
      fbe_struct_offset = buffer.allocate(fbe_struct_size) - buffer.offset
      if (buffer.offset + fbe_struct_offset + fbe_struct_size) > buffer.size
        return 0
      end

      fbe_struct_size = 8 + @_model.set(value)
      buffer.resize(fbe_initial_size + fbe_struct_size)

      write_uint32(@_model.fbe_offset - 8, fbe_struct_size)
      write_uint32(@_model.fbe_offset - 4, fbe_struct_type)

      fbe_struct_size
    end

    # Deserialize the struct value
    def deserialize(value = Balance.new)
      if (buffer.offset + @_model.fbe_offset) > buffer.size
        [Balance.new, 0]
      end

      fbe_struct_size = read_uint32(@_model.fbe_offset - 8)
      fbe_struct_type = read_uint32(@_model.fbe_offset - 4)
      if (fbe_struct_size <= 0) || (fbe_struct_type != fbe_type)
        [Balance.new, 8]
      end

      fbe_result = @_model.get(value)
      [fbe_result[0], (8 + fbe_result[1])]
    end

    # Move to the next struct value
    def next(prev)
      @_model.fbe_shift(prev)
    end
  end

  # noinspection RubyResolve, RubyScope, RubyTooManyInstanceVariablesInspection, RubyTooManyMethodsInspection
  class Account
    include Comparable

    attr_accessor :id
    attr_accessor :name
    attr_accessor :state
    attr_accessor :wallet
    attr_accessor :asset
    attr_accessor :orders

    def initialize(id = 0, name = '', state = StateEx.initialized | StateEx.bad | StateEx.sad, wallet = Balance.new, asset = nil, orders = Array.new)
      @id = id
      @name = name
      @state = state
      @wallet = wallet
      @asset = asset
      @orders = orders
    end

    def initialize_copy(other)
      @id = other.id
      @name = other.name
      @state = other.state
      @wallet = other.wallet
      @asset = other.asset
      @orders = other.orders
    end

    # Struct shallow copy
    def copy(other)
      initialize_copy(other)
      self
    end

    # Struct deep clone
    def clone
      data = Marshal.dump(self)
      clone = Marshal.load(data)
      clone.freeze if frozen?
      clone
    end

    # Struct compare operators
    def <=>(other)
      return nil unless other.is_a?(Account)

      # noinspection RubyUnusedLocalVariable
      result = 0
      result = @id <=> other.id
      if result != 0
        return false
      end
      # noinspection RubyUnnecessaryReturnValue
      result
    end

    # Struct equals
    def eql?(other)
      self == other
    end

    # Struct keys
    def key
      result = []
      result.push(@id)
      # noinspection RubyUnnecessaryReturnValue
      result
    end

    # Struct hash code
    def hash
      key.hash
    end

    # Get struct string value
    def to_s
      result = ''
      result << 'Account('
      result << 'id='
      if !@id.nil?
        result << @id.to_s
      else
        result << 'null'
      end
      result << ',name='
      if !@name.nil?
        result << '"' << @name.to_s << '"'
      else
        result << 'null'
      end
      result << ',state='
      if !@state.nil?
        result << @state.to_s
      else
        result << 'null'
      end
      result << ',wallet='
      if !@wallet.nil?
        result << @wallet.to_s
      else
        result << 'null'
      end
      result << ',asset='
      if !@asset.nil?
        result << @asset.to_s
      else
        result << 'null'
      end
      result << ',orders='
      if @orders.nil?
        result << '[0][]'
      else
        first = true
        result << '[' << @orders.length.to_s << ']['
        @orders.each do |item|
          if !item.nil?
            result << (first ? '' : ',')
            result << item.to_s
          else
            result << (first ? '' : ',')
            result << 'null'
          end
          first = false
        end
        result << ']'
      end
      result << ')'
      result
    end

    # Dump the struct
    def marshal_dump
      # Serialize the struct to the FBE stream
      writer = AccountModel.new(FBE::WriteBuffer.new)
      writer.serialize(self)
      writer.buffer
    end

    # Load the struct
    def marshal_load(data)
      # Deserialize the struct from the FBE stream
      reader = AccountModel.new(FBE::ReadBuffer.new)
      reader.attach_buffer(data)
      initialize_copy(reader.deserialize[0])
    end

    # Get struct JSON value
    def to_json
      JSON.generate(__to_json_map__)
    end

    # Get struct JSON map (internal method)
    def __to_json_map__
      result = {}
      key = 'id'
      value = (id.nil? ? nil : id)
      result.store(key, value)
      key = 'name'
      value = (name.nil? ? nil : name)
      result.store(key, value)
      key = 'state'
      value = (state.nil? ? nil : state.__to_json_map__)
      result.store(key, value)
      key = 'wallet'
      value = (wallet.nil? ? nil : wallet.__to_json_map__)
      result.store(key, value)
      key = 'asset'
      value = (asset.nil? ? nil : asset.__to_json_map__)
      result.store(key, value)
      key = 'orders'
      value = orders.map { |item| (item.nil? ? nil : item.__to_json_map__) }
      result.store(key, value)
      result
    end

    # Get struct from JSON
    def self.from_json(json)
      __from_json_map__(JSON.parse(json))
    end

    # Get struct map from JSON (internal method)
    def self.__from_json_map__(json)
      result = Account.new
      value = json.fetch('id', nil)
      result.id = (value.nil? ? nil : value)
      value = json.fetch('name', nil)
      result.name = (value.nil? ? nil : value)
      value = json.fetch('state', nil)
      result.state = (value.nil? ? nil : StateEx.__from_json_map__(value))
      value = json.fetch('wallet', nil)
      result.wallet = (value.nil? ? nil : Balance.__from_json_map__(value))
      value = json.fetch('asset', nil)
      result.asset = (value.nil? ? nil : Balance.__from_json_map__(value))
      value = json.fetch('orders', nil)
      result.orders = value.map { |item| (item.nil? ? nil : Order.__from_json_map__(item)) }
      result
    end

    # Get the FBE type
    def fbe_type
      TYPE
    end

    TYPE = 3
  end

  # noinspection RubyResolve, RubyScope, RubyTooManyInstanceVariablesInspection, RubyTooManyMethodsInspection
  class FieldModelAccount < FBE::FieldModel
    def initialize(buffer, offset)
      super(buffer, offset)
      @_id = FBE::FieldModelInt32.new(self.buffer, 4 + 4)
      @_name = FBE::FieldModelString.new(self.buffer, @_id.fbe_offset + @_id.fbe_size)
      @_state = FieldModelStateEx.new(self.buffer, @_name.fbe_offset + @_name.fbe_size)
      @_wallet = FieldModelBalance.new(self.buffer, @_state.fbe_offset + @_state.fbe_size)
      @_asset = FBE::FieldModelOptional.new(FieldModelBalance.new(self.buffer, @_wallet.fbe_offset + @_wallet.fbe_size), self.buffer, @_wallet.fbe_offset + @_wallet.fbe_size)
      @_orders = FBE::FieldModelVector.new(FieldModelOrder.new(self.buffer, @_asset.fbe_offset + @_asset.fbe_size), self.buffer, @_asset.fbe_offset + @_asset.fbe_size)
    end

    def id
      @_id
    end

    def name
      @_name
    end

    def state
      @_state
    end

    def wallet
      @_wallet
    end

    def asset
      @_asset
    end

    def orders
      @_orders
    end

    # Get the field size
    def fbe_size
      4
    end

    # Get the field body size
    def fbe_body
      4 + 4 \
        + id.fbe_size \
        + name.fbe_size \
        + state.fbe_size \
        + wallet.fbe_size \
        + asset.fbe_size \
        + orders.fbe_size \
    end

    # Get the field extra size
    def fbe_extra
      if (@_buffer.offset + fbe_offset + fbe_size) > @_buffer.size
        return 0
      end

      fbe_struct_offset = read_uint32(fbe_offset)
      if (fbe_struct_offset == 0) || ((@_buffer.offset + fbe_struct_offset + 4) > @_buffer.size)
        return 0
      end

      @_buffer.shift(fbe_struct_offset)

      fbe_result = fbe_body \
        + id.fbe_extra \
        + name.fbe_extra \
        + state.fbe_extra \
        + wallet.fbe_extra \
        + asset.fbe_extra \
        + orders.fbe_extra \

      @_buffer.unshift(fbe_struct_offset)

      fbe_result
    end

    # Get the field type
    def fbe_type
      TYPE
    end

    TYPE = 3

    # Is the struct value valid?
    def valid?
      verify
    end

    # Check if the struct value is valid
    def verify(fbe_verify_type = true)
      if (@_buffer.offset + fbe_offset + fbe_size) > @_buffer.size
        return true
      end

      fbe_struct_offset = read_uint32(fbe_offset)
      if (fbe_struct_offset == 0) || ((@_buffer.offset + fbe_struct_offset + 4 + 4) > @_buffer.size)
        return false
      end

      fbe_struct_size = read_uint32(fbe_struct_offset)
      if fbe_struct_size < (4 + 4)
        return false
      end

      fbe_struct_type = read_uint32(fbe_struct_offset + 4)
      if fbe_verify_type && (fbe_struct_type != fbe_type)
        return false
      end

      @_buffer.shift(fbe_struct_offset)
      fbe_result = verify_fields(fbe_struct_size)
      @_buffer.unshift(fbe_struct_offset)
      fbe_result
    end

    # Check if the struct fields are valid
    def verify_fields(fbe_struct_size)
      fbe_current_size = 4 + 4

      if (fbe_current_size + id.fbe_size) > fbe_struct_size
        return true
      end
      unless id.verify
        return false
      end
      # noinspection RubyUnusedLocalVariable
      fbe_current_size += id.fbe_size

      if (fbe_current_size + name.fbe_size) > fbe_struct_size
        return true
      end
      unless name.verify
        return false
      end
      # noinspection RubyUnusedLocalVariable
      fbe_current_size += name.fbe_size

      if (fbe_current_size + state.fbe_size) > fbe_struct_size
        return true
      end
      unless state.verify
        return false
      end
      # noinspection RubyUnusedLocalVariable
      fbe_current_size += state.fbe_size

      if (fbe_current_size + wallet.fbe_size) > fbe_struct_size
        return true
      end
      unless wallet.verify
        return false
      end
      # noinspection RubyUnusedLocalVariable
      fbe_current_size += wallet.fbe_size

      if (fbe_current_size + asset.fbe_size) > fbe_struct_size
        return true
      end
      unless asset.verify
        return false
      end
      # noinspection RubyUnusedLocalVariable
      fbe_current_size += asset.fbe_size

      if (fbe_current_size + orders.fbe_size) > fbe_struct_size
        return true
      end
      unless orders.verify
        return false
      end
      # noinspection RubyUnusedLocalVariable
      fbe_current_size += orders.fbe_size

      true
    end

    # Get the struct value (begin phase)
    def get_begin
      if (@_buffer.offset + fbe_offset + fbe_size) > @_buffer.size
        return 0
      end

      fbe_struct_offset = read_uint32(fbe_offset)
      if (fbe_struct_offset == 0) || ((@_buffer.offset + fbe_struct_offset + 4 + 4) > @_buffer.size)
        return 0
      end

      fbe_struct_size = read_uint32(fbe_struct_offset)
      if fbe_struct_size < (4 + 4)
        return 0
      end

      @_buffer.shift(fbe_struct_offset)
      fbe_struct_offset
    end

    # Get the struct value (end phase)
    def get_end(fbe_begin)
      @_buffer.unshift(fbe_begin)
    end

    # Get the struct value
    def get(fbe_value = Account.new)
      fbe_begin = get_begin
      if fbe_begin == 0
        return fbe_value
      end

      fbe_struct_size = read_uint32(0)
      get_fields(fbe_value, fbe_struct_size)
      get_end(fbe_begin)
      fbe_value
    end

    # Get the struct fields values
    def get_fields(fbe_value, fbe_struct_size)
      fbe_current_size = 4 + 4

      if (fbe_current_size + id.fbe_size) <= fbe_struct_size
        fbe_value.id = id.get
      else
        fbe_value.id = 0
      end
      # noinspection RubyUnusedLocalVariable
      fbe_current_size += id.fbe_size

      if (fbe_current_size + name.fbe_size) <= fbe_struct_size
        fbe_value.name = name.get
      else
        fbe_value.name = ''
      end
      # noinspection RubyUnusedLocalVariable
      fbe_current_size += name.fbe_size

      if (fbe_current_size + state.fbe_size) <= fbe_struct_size
        fbe_value.state = state.get(StateEx.initialized | StateEx.bad | StateEx.sad)
      else
        fbe_value.state = StateEx.initialized | StateEx.bad | StateEx.sad
      end
      # noinspection RubyUnusedLocalVariable
      fbe_current_size += state.fbe_size

      if (fbe_current_size + wallet.fbe_size) <= fbe_struct_size
        fbe_value.wallet = wallet.get
      else
        fbe_value.wallet = Balance.new
      end
      # noinspection RubyUnusedLocalVariable
      fbe_current_size += wallet.fbe_size

      if (fbe_current_size + asset.fbe_size) <= fbe_struct_size
        fbe_value.asset = asset.get
      else
        fbe_value.asset = nil
      end
      # noinspection RubyUnusedLocalVariable
      fbe_current_size += asset.fbe_size

      if (fbe_current_size + orders.fbe_size) <= fbe_struct_size
        orders.get(fbe_value.orders)
      else
        fbe_value.orders.clear
      end
      # noinspection RubyUnusedLocalVariable
      fbe_current_size += orders.fbe_size
    end

    # Set the struct value (begin phase)
    def set_begin
      if (@_buffer.offset + fbe_offset + fbe_size) > @_buffer.size
        return 0
      end

      fbe_struct_size = fbe_body
      fbe_struct_offset = @_buffer.allocate(fbe_struct_size) - @_buffer.offset
      if (fbe_struct_offset <= 0) || ((@_buffer.offset + fbe_struct_offset + fbe_struct_size) > @_buffer.size)
        return 0
      end

      write_uint32(fbe_offset, fbe_struct_offset)
      write_uint32(fbe_struct_offset, fbe_struct_size)
      write_uint32(fbe_struct_offset + 4, fbe_type)

      @_buffer.shift(fbe_struct_offset)
      fbe_struct_offset
    end

    # Set the struct value (end phase)
    def set_end(fbe_begin)
      @_buffer.unshift(fbe_begin)
    end

    # Set the struct value
    def set(fbe_value)
      fbe_begin = set_begin
      if fbe_begin == 0
        return
      end

      set_fields(fbe_value)
      set_end(fbe_begin)
    end

    # Set the struct fields values
    def set_fields(fbe_value)
      id.set(fbe_value.id)
      name.set(fbe_value.name)
      state.set(fbe_value.state)
      wallet.set(fbe_value.wallet)
      asset.set(fbe_value.asset)
      orders.set(fbe_value.orders)
    end
  end

  # Fast Binary Encoding Account model
  class AccountModel < FBE::Model
    def initialize(buffer = FBE::WriteBuffer.new)
      super(buffer)
      @_model = FieldModelAccount.new(self.buffer, 4)
    end

    def model
      @_model
    end

    # Get the model size
    def fbe_size
      @_model.fbe_size + @_model.fbe_extra
    end

    # Get the model type
    def fbe_type
      TYPE
    end

    TYPE = FieldModelAccount::TYPE

    # Is the struct value valid?
    def valid?
      verify
    end

    # Check if the struct value is valid
    def verify
      if (buffer.offset + @_model.fbe_offset - 4) > buffer.size
        return false
      end

      fbe_full_size = read_uint32(@_model.fbe_offset - 4)
      if fbe_full_size < @_model.fbe_size
        return false
      end

      @_model.verify
    end

    # Create a new model (begin phase)
    def create_begin
      buffer.allocate(4 + @_model.fbe_size)
    end

    # Create a new model (end phase)
    def create_end(fbe_begin)
      fbe_end = buffer.size
      fbe_full_size = fbe_end - fbe_begin
      write_uint32(@_model.fbe_offset - 4, fbe_full_size)
      fbe_full_size
    end

    # Serialize the struct value
    def serialize(value)
      fbe_begin = create_begin
      @_model.set(value)
      create_end(fbe_begin)
    end

    # Deserialize the struct value
    def deserialize(value = Account.new)
      if (buffer.offset + @_model.fbe_offset - 4) > buffer.size
        [Account.new, 0]
      end

      fbe_full_size = read_uint32(@_model.fbe_offset - 4)
      if fbe_full_size < @_model.fbe_size
        [Account.new, 0]
      end

      @_model.get(value)
      [value, fbe_full_size]
    end

    # Move to the next struct value
    def next(prev)
      @_model.fbe_shift(prev)
    end
  end

  # noinspection RubyResolve, RubyScope, RubyTooManyInstanceVariablesInspection, RubyTooManyMethodsInspection
  class FinalModelAccount < FBE::FinalModel
    def initialize(buffer, offset)
      super(buffer, offset)
      @_id = FBE::FinalModelInt32.new(self.buffer, 0)
      @_name = FBE::FinalModelString.new(self.buffer, 0)
      @_state = FinalModelStateEx.new(self.buffer, 0)
      @_wallet = FinalModelBalance.new(self.buffer, 0)
      @_asset = FBE::FinalModelOptional.new(FinalModelBalance.new(self.buffer, 0), self.buffer, 0)
      @_orders = FBE::FinalModelVector.new(FinalModelOrder.new(self.buffer, 0), self.buffer, 0)
    end

    def id
      @_id
    end

    def name
      @_name
    end

    def state
      @_state
    end

    def wallet
      @_wallet
    end

    def asset
      @_asset
    end

    def orders
      @_orders
    end

    # Get the allocation size
    def fbe_allocation_size(fbe_value)
      0 \
        + id.fbe_allocation_size(fbe_value.id) \
        + name.fbe_allocation_size(fbe_value.name) \
        + state.fbe_allocation_size(fbe_value.state) \
        + wallet.fbe_allocation_size(fbe_value.wallet) \
        + asset.fbe_allocation_size(fbe_value.asset) \
        + orders.fbe_allocation_size(fbe_value.orders) \
    end

    # Get the final type
    def fbe_type
      TYPE
    end

    TYPE = 3

    # Is the struct value valid?
    def valid?
      verify
    end

    # Check if the struct value is valid
    def verify
      @_buffer.shift(fbe_offset)
      fbe_result = verify_fields
      @_buffer.unshift(fbe_offset)
      fbe_result
    end

    # Check if the struct fields are valid
    def verify_fields
      fbe_current_offset = 0

      id.fbe_offset = fbe_current_offset
      fbe_field_size = id.verify
      if fbe_field_size == FBE::Integer::MAX
        return FBE::Integer::MAX
      end
      fbe_current_offset += fbe_field_size

      name.fbe_offset = fbe_current_offset
      fbe_field_size = name.verify
      if fbe_field_size == FBE::Integer::MAX
        return FBE::Integer::MAX
      end
      fbe_current_offset += fbe_field_size

      state.fbe_offset = fbe_current_offset
      fbe_field_size = state.verify
      if fbe_field_size == FBE::Integer::MAX
        return FBE::Integer::MAX
      end
      fbe_current_offset += fbe_field_size

      wallet.fbe_offset = fbe_current_offset
      fbe_field_size = wallet.verify
      if fbe_field_size == FBE::Integer::MAX
        return FBE::Integer::MAX
      end
      fbe_current_offset += fbe_field_size

      asset.fbe_offset = fbe_current_offset
      fbe_field_size = asset.verify
      if fbe_field_size == FBE::Integer::MAX
        return FBE::Integer::MAX
      end
      fbe_current_offset += fbe_field_size

      orders.fbe_offset = fbe_current_offset
      fbe_field_size = orders.verify
      if fbe_field_size == FBE::Integer::MAX
        return FBE::Integer::MAX
      end
      fbe_current_offset += fbe_field_size

      # noinspection RubyUnnecessaryReturnValue
      fbe_current_offset
    end

    # Get the struct value
    def get(fbe_value = Account.new)
      @_buffer.shift(fbe_offset)
      fbe_size = get_fields(fbe_value)
      @_buffer.unshift(fbe_offset)
      [fbe_value, fbe_size]
    end

    # Get the struct fields values
    def get_fields(fbe_value)
      fbe_current_offset = 0
      fbe_current_size = 0

      id.fbe_offset = fbe_current_offset
      fbe_result = id.get
      fbe_value.id = fbe_result[0]
      # noinspection RubyUnusedLocalVariable
      fbe_current_offset += fbe_result[1]
      fbe_current_size += fbe_result[1]

      name.fbe_offset = fbe_current_offset
      fbe_result = name.get
      fbe_value.name = fbe_result[0]
      # noinspection RubyUnusedLocalVariable
      fbe_current_offset += fbe_result[1]
      fbe_current_size += fbe_result[1]

      state.fbe_offset = fbe_current_offset
      fbe_result = state.get
      fbe_value.state = fbe_result[0]
      # noinspection RubyUnusedLocalVariable
      fbe_current_offset += fbe_result[1]
      fbe_current_size += fbe_result[1]

      wallet.fbe_offset = fbe_current_offset
      fbe_result = wallet.get
      fbe_value.wallet = fbe_result[0]
      # noinspection RubyUnusedLocalVariable
      fbe_current_offset += fbe_result[1]
      fbe_current_size += fbe_result[1]

      asset.fbe_offset = fbe_current_offset
      fbe_result = asset.get
      fbe_value.asset = fbe_result[0]
      # noinspection RubyUnusedLocalVariable
      fbe_current_offset += fbe_result[1]
      fbe_current_size += fbe_result[1]

      orders.fbe_offset = fbe_current_offset
      fbe_result = orders.get(fbe_value.orders)
      # noinspection RubyUnusedLocalVariable
      fbe_current_offset += fbe_result[1]
      fbe_current_size += fbe_result[1]

      # noinspection RubyUnnecessaryReturnValue
      fbe_current_size
    end

    # Set the struct value
    def set(fbe_value)
      @_buffer.shift(fbe_offset)
      fbe_size = set_fields(fbe_value)
      @_buffer.unshift(fbe_offset)
      fbe_size
    end

    # Set the struct fields values
    def set_fields(fbe_value)
      fbe_current_offset = 0
      fbe_current_size = 0

      id.fbe_offset = fbe_current_offset
      fbe_field_size = id.set(fbe_value.id)
      # noinspection RubyUnusedLocalVariable
      fbe_current_offset += fbe_field_size
      fbe_current_size += fbe_field_size

      name.fbe_offset = fbe_current_offset
      fbe_field_size = name.set(fbe_value.name)
      # noinspection RubyUnusedLocalVariable
      fbe_current_offset += fbe_field_size
      fbe_current_size += fbe_field_size

      state.fbe_offset = fbe_current_offset
      fbe_field_size = state.set(fbe_value.state)
      # noinspection RubyUnusedLocalVariable
      fbe_current_offset += fbe_field_size
      fbe_current_size += fbe_field_size

      wallet.fbe_offset = fbe_current_offset
      fbe_field_size = wallet.set(fbe_value.wallet)
      # noinspection RubyUnusedLocalVariable
      fbe_current_offset += fbe_field_size
      fbe_current_size += fbe_field_size

      asset.fbe_offset = fbe_current_offset
      fbe_field_size = asset.set(fbe_value.asset)
      # noinspection RubyUnusedLocalVariable
      fbe_current_offset += fbe_field_size
      fbe_current_size += fbe_field_size

      orders.fbe_offset = fbe_current_offset
      fbe_field_size = orders.set(fbe_value.orders)
      # noinspection RubyUnusedLocalVariable
      fbe_current_offset += fbe_field_size
      fbe_current_size += fbe_field_size

      # noinspection RubyUnnecessaryReturnValue
      fbe_current_size
    end
  end

  # Fast Binary Encoding Account final model
  class AccountFinalModel < FBE::Model
    def initialize(buffer = FBE::WriteBuffer.new)
      super(buffer)
      @_model = FinalModelAccount.new(self.buffer, 8)
    end

    # Get the model type
    def fbe_type
      TYPE
    end

    TYPE = FinalModelAccount::TYPE

    # Is the struct value valid?
    def valid?
      verify
    end

    # Check if the struct value is valid
    def verify
      if (buffer.offset + @_model.fbe_offset) > buffer.size
        return false
      end

      fbe_struct_size = read_uint32(@_model.fbe_offset - 8)
      fbe_struct_type = read_uint32(@_model.fbe_offset - 4)
      if (fbe_struct_size <= 0) or (fbe_struct_type != fbe_type)
        return false
      end

      (8 + @_model.verify) == fbe_struct_size
    end

    # Serialize the struct value
    def serialize(value)
      fbe_initial_size = buffer.size

      fbe_struct_type = fbe_type
      fbe_struct_size = 8 + @_model.fbe_allocation_size(value)
      fbe_struct_offset = buffer.allocate(fbe_struct_size) - buffer.offset
      if (buffer.offset + fbe_struct_offset + fbe_struct_size) > buffer.size
        return 0
      end

      fbe_struct_size = 8 + @_model.set(value)
      buffer.resize(fbe_initial_size + fbe_struct_size)

      write_uint32(@_model.fbe_offset - 8, fbe_struct_size)
      write_uint32(@_model.fbe_offset - 4, fbe_struct_type)

      fbe_struct_size
    end

    # Deserialize the struct value
    def deserialize(value = Account.new)
      if (buffer.offset + @_model.fbe_offset) > buffer.size
        [Account.new, 0]
      end

      fbe_struct_size = read_uint32(@_model.fbe_offset - 8)
      fbe_struct_type = read_uint32(@_model.fbe_offset - 4)
      if (fbe_struct_size <= 0) || (fbe_struct_type != fbe_type)
        [Account.new, 8]
      end

      fbe_result = @_model.get(value)
      [fbe_result[0], (8 + fbe_result[1])]
    end

    # Move to the next struct value
    def next(prev)
      @_model.fbe_shift(prev)
    end
  end

  # noinspection RubyResolve, RubyScope, RubyTooManyInstanceVariablesInspection, RubyTooManyMethodsInspection
  class OrderMessage
    include Comparable

    attr_accessor :body

    def initialize(body = Order.new)
      @body = body
    end

    def initialize_copy(other)
      @body = other.body
    end

    # Struct shallow copy
    def copy(other)
      initialize_copy(other)
      self
    end

    # Struct deep clone
    def clone
      data = Marshal.dump(self)
      clone = Marshal.load(data)
      clone.freeze if frozen?
      clone
    end

    # Struct compare operators
    def <=>(other)
      return nil unless other.is_a?(OrderMessage)

      # noinspection RubyUnusedLocalVariable
      result = 0
      # noinspection RubyUnnecessaryReturnValue
      result
    end

    # Struct equals
    def eql?(other)
      self == other
    end

    # Struct keys
    def key
      result = []
      # noinspection RubyUnnecessaryReturnValue
      result
    end

    # Struct hash code
    def hash
      key.hash
    end

    # Get struct string value
    def to_s
      result = ''
      result << 'OrderMessage('
      result << 'body='
      if !@body.nil?
        result << @body.to_s
      else
        result << 'null'
      end
      result << ')'
      result
    end

    # Dump the struct
    def marshal_dump
      # Serialize the struct to the FBE stream
      writer = OrderMessageModel.new(FBE::WriteBuffer.new)
      writer.serialize(self)
      writer.buffer
    end

    # Load the struct
    def marshal_load(data)
      # Deserialize the struct from the FBE stream
      reader = OrderMessageModel.new(FBE::ReadBuffer.new)
      reader.attach_buffer(data)
      initialize_copy(reader.deserialize[0])
    end

    # Get struct JSON value
    def to_json
      JSON.generate(__to_json_map__)
    end

    # Get struct JSON map (internal method)
    def __to_json_map__
      result = {}
      key = 'body'
      value = (body.nil? ? nil : body.__to_json_map__)
      result.store(key, value)
      result
    end

    # Get struct from JSON
    def self.from_json(json)
      __from_json_map__(JSON.parse(json))
    end

    # Get struct map from JSON (internal method)
    def self.__from_json_map__(json)
      result = OrderMessage.new
      value = json.fetch('body', nil)
      result.body = (value.nil? ? nil : Order.__from_json_map__(value))
      result
    end

    # Get the FBE type
    def fbe_type
      TYPE
    end

    TYPE = 11
  end

  # noinspection RubyResolve, RubyScope, RubyTooManyInstanceVariablesInspection, RubyTooManyMethodsInspection
  class FieldModelOrderMessage < FBE::FieldModel
    def initialize(buffer, offset)
      super(buffer, offset)
      @_body = FieldModelOrder.new(self.buffer, 4 + 4)
    end

    def body
      @_body
    end

    # Get the field size
    def fbe_size
      4
    end

    # Get the field body size
    def fbe_body
      4 + 4 \
        + body.fbe_size \
    end

    # Get the field extra size
    def fbe_extra
      if (@_buffer.offset + fbe_offset + fbe_size) > @_buffer.size
        return 0
      end

      fbe_struct_offset = read_uint32(fbe_offset)
      if (fbe_struct_offset == 0) || ((@_buffer.offset + fbe_struct_offset + 4) > @_buffer.size)
        return 0
      end

      @_buffer.shift(fbe_struct_offset)

      fbe_result = fbe_body \
        + body.fbe_extra \

      @_buffer.unshift(fbe_struct_offset)

      fbe_result
    end

    # Get the field type
    def fbe_type
      TYPE
    end

    TYPE = 11

    # Is the struct value valid?
    def valid?
      verify
    end

    # Check if the struct value is valid
    def verify(fbe_verify_type = true)
      if (@_buffer.offset + fbe_offset + fbe_size) > @_buffer.size
        return true
      end

      fbe_struct_offset = read_uint32(fbe_offset)
      if (fbe_struct_offset == 0) || ((@_buffer.offset + fbe_struct_offset + 4 + 4) > @_buffer.size)
        return false
      end

      fbe_struct_size = read_uint32(fbe_struct_offset)
      if fbe_struct_size < (4 + 4)
        return false
      end

      fbe_struct_type = read_uint32(fbe_struct_offset + 4)
      if fbe_verify_type && (fbe_struct_type != fbe_type)
        return false
      end

      @_buffer.shift(fbe_struct_offset)
      fbe_result = verify_fields(fbe_struct_size)
      @_buffer.unshift(fbe_struct_offset)
      fbe_result
    end

    # Check if the struct fields are valid
    def verify_fields(fbe_struct_size)
      fbe_current_size = 4 + 4

      if (fbe_current_size + body.fbe_size) > fbe_struct_size
        return true
      end
      unless body.verify
        return false
      end
      # noinspection RubyUnusedLocalVariable
      fbe_current_size += body.fbe_size

      true
    end

    # Get the struct value (begin phase)
    def get_begin
      if (@_buffer.offset + fbe_offset + fbe_size) > @_buffer.size
        return 0
      end

      fbe_struct_offset = read_uint32(fbe_offset)
      if (fbe_struct_offset == 0) || ((@_buffer.offset + fbe_struct_offset + 4 + 4) > @_buffer.size)
        return 0
      end

      fbe_struct_size = read_uint32(fbe_struct_offset)
      if fbe_struct_size < (4 + 4)
        return 0
      end

      @_buffer.shift(fbe_struct_offset)
      fbe_struct_offset
    end

    # Get the struct value (end phase)
    def get_end(fbe_begin)
      @_buffer.unshift(fbe_begin)
    end

    # Get the struct value
    def get(fbe_value = OrderMessage.new)
      fbe_begin = get_begin
      if fbe_begin == 0
        return fbe_value
      end

      fbe_struct_size = read_uint32(0)
      get_fields(fbe_value, fbe_struct_size)
      get_end(fbe_begin)
      fbe_value
    end

    # Get the struct fields values
    def get_fields(fbe_value, fbe_struct_size)
      fbe_current_size = 4 + 4

      if (fbe_current_size + body.fbe_size) <= fbe_struct_size
        fbe_value.body = body.get
      else
        fbe_value.body = Order.new
      end
      # noinspection RubyUnusedLocalVariable
      fbe_current_size += body.fbe_size
    end

    # Set the struct value (begin phase)
    def set_begin
      if (@_buffer.offset + fbe_offset + fbe_size) > @_buffer.size
        return 0
      end

      fbe_struct_size = fbe_body
      fbe_struct_offset = @_buffer.allocate(fbe_struct_size) - @_buffer.offset
      if (fbe_struct_offset <= 0) || ((@_buffer.offset + fbe_struct_offset + fbe_struct_size) > @_buffer.size)
        return 0
      end

      write_uint32(fbe_offset, fbe_struct_offset)
      write_uint32(fbe_struct_offset, fbe_struct_size)
      write_uint32(fbe_struct_offset + 4, fbe_type)

      @_buffer.shift(fbe_struct_offset)
      fbe_struct_offset
    end

    # Set the struct value (end phase)
    def set_end(fbe_begin)
      @_buffer.unshift(fbe_begin)
    end

    # Set the struct value
    def set(fbe_value)
      fbe_begin = set_begin
      if fbe_begin == 0
        return
      end

      set_fields(fbe_value)
      set_end(fbe_begin)
    end

    # Set the struct fields values
    def set_fields(fbe_value)
      body.set(fbe_value.body)
    end
  end

  # Fast Binary Encoding OrderMessage model
  class OrderMessageModel < FBE::Model
    def initialize(buffer = FBE::WriteBuffer.new)
      super(buffer)
      @_model = FieldModelOrderMessage.new(self.buffer, 4)
    end

    def model
      @_model
    end

    # Get the model size
    def fbe_size
      @_model.fbe_size + @_model.fbe_extra
    end

    # Get the model type
    def fbe_type
      TYPE
    end

    TYPE = FieldModelOrderMessage::TYPE

    # Is the struct value valid?
    def valid?
      verify
    end

    # Check if the struct value is valid
    def verify
      if (buffer.offset + @_model.fbe_offset - 4) > buffer.size
        return false
      end

      fbe_full_size = read_uint32(@_model.fbe_offset - 4)
      if fbe_full_size < @_model.fbe_size
        return false
      end

      @_model.verify
    end

    # Create a new model (begin phase)
    def create_begin
      buffer.allocate(4 + @_model.fbe_size)
    end

    # Create a new model (end phase)
    def create_end(fbe_begin)
      fbe_end = buffer.size
      fbe_full_size = fbe_end - fbe_begin
      write_uint32(@_model.fbe_offset - 4, fbe_full_size)
      fbe_full_size
    end

    # Serialize the struct value
    def serialize(value)
      fbe_begin = create_begin
      @_model.set(value)
      create_end(fbe_begin)
    end

    # Deserialize the struct value
    def deserialize(value = OrderMessage.new)
      if (buffer.offset + @_model.fbe_offset - 4) > buffer.size
        [OrderMessage.new, 0]
      end

      fbe_full_size = read_uint32(@_model.fbe_offset - 4)
      if fbe_full_size < @_model.fbe_size
        [OrderMessage.new, 0]
      end

      @_model.get(value)
      [value, fbe_full_size]
    end

    # Move to the next struct value
    def next(prev)
      @_model.fbe_shift(prev)
    end
  end

  # noinspection RubyResolve, RubyScope, RubyTooManyInstanceVariablesInspection, RubyTooManyMethodsInspection
  class FinalModelOrderMessage < FBE::FinalModel
    def initialize(buffer, offset)
      super(buffer, offset)
      @_body = FinalModelOrder.new(self.buffer, 0)
    end

    def body
      @_body
    end

    # Get the allocation size
    def fbe_allocation_size(fbe_value)
      0 \
        + body.fbe_allocation_size(fbe_value.body) \
    end

    # Get the final type
    def fbe_type
      TYPE
    end

    TYPE = 11

    # Is the struct value valid?
    def valid?
      verify
    end

    # Check if the struct value is valid
    def verify
      @_buffer.shift(fbe_offset)
      fbe_result = verify_fields
      @_buffer.unshift(fbe_offset)
      fbe_result
    end

    # Check if the struct fields are valid
    def verify_fields
      fbe_current_offset = 0

      body.fbe_offset = fbe_current_offset
      fbe_field_size = body.verify
      if fbe_field_size == FBE::Integer::MAX
        return FBE::Integer::MAX
      end
      fbe_current_offset += fbe_field_size

      # noinspection RubyUnnecessaryReturnValue
      fbe_current_offset
    end

    # Get the struct value
    def get(fbe_value = OrderMessage.new)
      @_buffer.shift(fbe_offset)
      fbe_size = get_fields(fbe_value)
      @_buffer.unshift(fbe_offset)
      [fbe_value, fbe_size]
    end

    # Get the struct fields values
    def get_fields(fbe_value)
      fbe_current_offset = 0
      fbe_current_size = 0

      body.fbe_offset = fbe_current_offset
      fbe_result = body.get
      fbe_value.body = fbe_result[0]
      # noinspection RubyUnusedLocalVariable
      fbe_current_offset += fbe_result[1]
      fbe_current_size += fbe_result[1]

      # noinspection RubyUnnecessaryReturnValue
      fbe_current_size
    end

    # Set the struct value
    def set(fbe_value)
      @_buffer.shift(fbe_offset)
      fbe_size = set_fields(fbe_value)
      @_buffer.unshift(fbe_offset)
      fbe_size
    end

    # Set the struct fields values
    def set_fields(fbe_value)
      fbe_current_offset = 0
      fbe_current_size = 0

      body.fbe_offset = fbe_current_offset
      fbe_field_size = body.set(fbe_value.body)
      # noinspection RubyUnusedLocalVariable
      fbe_current_offset += fbe_field_size
      fbe_current_size += fbe_field_size

      # noinspection RubyUnnecessaryReturnValue
      fbe_current_size
    end
  end

  # Fast Binary Encoding OrderMessage final model
  class OrderMessageFinalModel < FBE::Model
    def initialize(buffer = FBE::WriteBuffer.new)
      super(buffer)
      @_model = FinalModelOrderMessage.new(self.buffer, 8)
    end

    # Get the model type
    def fbe_type
      TYPE
    end

    TYPE = FinalModelOrderMessage::TYPE

    # Is the struct value valid?
    def valid?
      verify
    end

    # Check if the struct value is valid
    def verify
      if (buffer.offset + @_model.fbe_offset) > buffer.size
        return false
      end

      fbe_struct_size = read_uint32(@_model.fbe_offset - 8)
      fbe_struct_type = read_uint32(@_model.fbe_offset - 4)
      if (fbe_struct_size <= 0) or (fbe_struct_type != fbe_type)
        return false
      end

      (8 + @_model.verify) == fbe_struct_size
    end

    # Serialize the struct value
    def serialize(value)
      fbe_initial_size = buffer.size

      fbe_struct_type = fbe_type
      fbe_struct_size = 8 + @_model.fbe_allocation_size(value)
      fbe_struct_offset = buffer.allocate(fbe_struct_size) - buffer.offset
      if (buffer.offset + fbe_struct_offset + fbe_struct_size) > buffer.size
        return 0
      end

      fbe_struct_size = 8 + @_model.set(value)
      buffer.resize(fbe_initial_size + fbe_struct_size)

      write_uint32(@_model.fbe_offset - 8, fbe_struct_size)
      write_uint32(@_model.fbe_offset - 4, fbe_struct_type)

      fbe_struct_size
    end

    # Deserialize the struct value
    def deserialize(value = OrderMessage.new)
      if (buffer.offset + @_model.fbe_offset) > buffer.size
        [OrderMessage.new, 0]
      end

      fbe_struct_size = read_uint32(@_model.fbe_offset - 8)
      fbe_struct_type = read_uint32(@_model.fbe_offset - 4)
      if (fbe_struct_size <= 0) || (fbe_struct_type != fbe_type)
        [OrderMessage.new, 8]
      end

      fbe_result = @_model.get(value)
      [fbe_result[0], (8 + fbe_result[1])]
    end

    # Move to the next struct value
    def next(prev)
      @_model.fbe_shift(prev)
    end
  end

  # noinspection RubyResolve, RubyScope, RubyTooManyInstanceVariablesInspection, RubyTooManyMethodsInspection
  class BalanceMessage
    include Comparable

    attr_accessor :body

    def initialize(body = Balance.new)
      @body = body
    end

    def initialize_copy(other)
      @body = other.body
    end

    # Struct shallow copy
    def copy(other)
      initialize_copy(other)
      self
    end

    # Struct deep clone
    def clone
      data = Marshal.dump(self)
      clone = Marshal.load(data)
      clone.freeze if frozen?
      clone
    end

    # Struct compare operators
    def <=>(other)
      return nil unless other.is_a?(BalanceMessage)

      # noinspection RubyUnusedLocalVariable
      result = 0
      # noinspection RubyUnnecessaryReturnValue
      result
    end

    # Struct equals
    def eql?(other)
      self == other
    end

    # Struct keys
    def key
      result = []
      # noinspection RubyUnnecessaryReturnValue
      result
    end

    # Struct hash code
    def hash
      key.hash
    end

    # Get struct string value
    def to_s
      result = ''
      result << 'BalanceMessage('
      result << 'body='
      if !@body.nil?
        result << @body.to_s
      else
        result << 'null'
      end
      result << ')'
      result
    end

    # Dump the struct
    def marshal_dump
      # Serialize the struct to the FBE stream
      writer = BalanceMessageModel.new(FBE::WriteBuffer.new)
      writer.serialize(self)
      writer.buffer
    end

    # Load the struct
    def marshal_load(data)
      # Deserialize the struct from the FBE stream
      reader = BalanceMessageModel.new(FBE::ReadBuffer.new)
      reader.attach_buffer(data)
      initialize_copy(reader.deserialize[0])
    end

    # Get struct JSON value
    def to_json
      JSON.generate(__to_json_map__)
    end

    # Get struct JSON map (internal method)
    def __to_json_map__
      result = {}
      key = 'body'
      value = (body.nil? ? nil : body.__to_json_map__)
      result.store(key, value)
      result
    end

    # Get struct from JSON
    def self.from_json(json)
      __from_json_map__(JSON.parse(json))
    end

    # Get struct map from JSON (internal method)
    def self.__from_json_map__(json)
      result = BalanceMessage.new
      value = json.fetch('body', nil)
      result.body = (value.nil? ? nil : Balance.__from_json_map__(value))
      result
    end

    # Get the FBE type
    def fbe_type
      TYPE
    end

    TYPE = 12
  end

  # noinspection RubyResolve, RubyScope, RubyTooManyInstanceVariablesInspection, RubyTooManyMethodsInspection
  class FieldModelBalanceMessage < FBE::FieldModel
    def initialize(buffer, offset)
      super(buffer, offset)
      @_body = FieldModelBalance.new(self.buffer, 4 + 4)
    end

    def body
      @_body
    end

    # Get the field size
    def fbe_size
      4
    end

    # Get the field body size
    def fbe_body
      4 + 4 \
        + body.fbe_size \
    end

    # Get the field extra size
    def fbe_extra
      if (@_buffer.offset + fbe_offset + fbe_size) > @_buffer.size
        return 0
      end

      fbe_struct_offset = read_uint32(fbe_offset)
      if (fbe_struct_offset == 0) || ((@_buffer.offset + fbe_struct_offset + 4) > @_buffer.size)
        return 0
      end

      @_buffer.shift(fbe_struct_offset)

      fbe_result = fbe_body \
        + body.fbe_extra \

      @_buffer.unshift(fbe_struct_offset)

      fbe_result
    end

    # Get the field type
    def fbe_type
      TYPE
    end

    TYPE = 12

    # Is the struct value valid?
    def valid?
      verify
    end

    # Check if the struct value is valid
    def verify(fbe_verify_type = true)
      if (@_buffer.offset + fbe_offset + fbe_size) > @_buffer.size
        return true
      end

      fbe_struct_offset = read_uint32(fbe_offset)
      if (fbe_struct_offset == 0) || ((@_buffer.offset + fbe_struct_offset + 4 + 4) > @_buffer.size)
        return false
      end

      fbe_struct_size = read_uint32(fbe_struct_offset)
      if fbe_struct_size < (4 + 4)
        return false
      end

      fbe_struct_type = read_uint32(fbe_struct_offset + 4)
      if fbe_verify_type && (fbe_struct_type != fbe_type)
        return false
      end

      @_buffer.shift(fbe_struct_offset)
      fbe_result = verify_fields(fbe_struct_size)
      @_buffer.unshift(fbe_struct_offset)
      fbe_result
    end

    # Check if the struct fields are valid
    def verify_fields(fbe_struct_size)
      fbe_current_size = 4 + 4

      if (fbe_current_size + body.fbe_size) > fbe_struct_size
        return true
      end
      unless body.verify
        return false
      end
      # noinspection RubyUnusedLocalVariable
      fbe_current_size += body.fbe_size

      true
    end

    # Get the struct value (begin phase)
    def get_begin
      if (@_buffer.offset + fbe_offset + fbe_size) > @_buffer.size
        return 0
      end

      fbe_struct_offset = read_uint32(fbe_offset)
      if (fbe_struct_offset == 0) || ((@_buffer.offset + fbe_struct_offset + 4 + 4) > @_buffer.size)
        return 0
      end

      fbe_struct_size = read_uint32(fbe_struct_offset)
      if fbe_struct_size < (4 + 4)
        return 0
      end

      @_buffer.shift(fbe_struct_offset)
      fbe_struct_offset
    end

    # Get the struct value (end phase)
    def get_end(fbe_begin)
      @_buffer.unshift(fbe_begin)
    end

    # Get the struct value
    def get(fbe_value = BalanceMessage.new)
      fbe_begin = get_begin
      if fbe_begin == 0
        return fbe_value
      end

      fbe_struct_size = read_uint32(0)
      get_fields(fbe_value, fbe_struct_size)
      get_end(fbe_begin)
      fbe_value
    end

    # Get the struct fields values
    def get_fields(fbe_value, fbe_struct_size)
      fbe_current_size = 4 + 4

      if (fbe_current_size + body.fbe_size) <= fbe_struct_size
        fbe_value.body = body.get
      else
        fbe_value.body = Balance.new
      end
      # noinspection RubyUnusedLocalVariable
      fbe_current_size += body.fbe_size
    end

    # Set the struct value (begin phase)
    def set_begin
      if (@_buffer.offset + fbe_offset + fbe_size) > @_buffer.size
        return 0
      end

      fbe_struct_size = fbe_body
      fbe_struct_offset = @_buffer.allocate(fbe_struct_size) - @_buffer.offset
      if (fbe_struct_offset <= 0) || ((@_buffer.offset + fbe_struct_offset + fbe_struct_size) > @_buffer.size)
        return 0
      end

      write_uint32(fbe_offset, fbe_struct_offset)
      write_uint32(fbe_struct_offset, fbe_struct_size)
      write_uint32(fbe_struct_offset + 4, fbe_type)

      @_buffer.shift(fbe_struct_offset)
      fbe_struct_offset
    end

    # Set the struct value (end phase)
    def set_end(fbe_begin)
      @_buffer.unshift(fbe_begin)
    end

    # Set the struct value
    def set(fbe_value)
      fbe_begin = set_begin
      if fbe_begin == 0
        return
      end

      set_fields(fbe_value)
      set_end(fbe_begin)
    end

    # Set the struct fields values
    def set_fields(fbe_value)
      body.set(fbe_value.body)
    end
  end

  # Fast Binary Encoding BalanceMessage model
  class BalanceMessageModel < FBE::Model
    def initialize(buffer = FBE::WriteBuffer.new)
      super(buffer)
      @_model = FieldModelBalanceMessage.new(self.buffer, 4)
    end

    def model
      @_model
    end

    # Get the model size
    def fbe_size
      @_model.fbe_size + @_model.fbe_extra
    end

    # Get the model type
    def fbe_type
      TYPE
    end

    TYPE = FieldModelBalanceMessage::TYPE

    # Is the struct value valid?
    def valid?
      verify
    end

    # Check if the struct value is valid
    def verify
      if (buffer.offset + @_model.fbe_offset - 4) > buffer.size
        return false
      end

      fbe_full_size = read_uint32(@_model.fbe_offset - 4)
      if fbe_full_size < @_model.fbe_size
        return false
      end

      @_model.verify
    end

    # Create a new model (begin phase)
    def create_begin
      buffer.allocate(4 + @_model.fbe_size)
    end

    # Create a new model (end phase)
    def create_end(fbe_begin)
      fbe_end = buffer.size
      fbe_full_size = fbe_end - fbe_begin
      write_uint32(@_model.fbe_offset - 4, fbe_full_size)
      fbe_full_size
    end

    # Serialize the struct value
    def serialize(value)
      fbe_begin = create_begin
      @_model.set(value)
      create_end(fbe_begin)
    end

    # Deserialize the struct value
    def deserialize(value = BalanceMessage.new)
      if (buffer.offset + @_model.fbe_offset - 4) > buffer.size
        [BalanceMessage.new, 0]
      end

      fbe_full_size = read_uint32(@_model.fbe_offset - 4)
      if fbe_full_size < @_model.fbe_size
        [BalanceMessage.new, 0]
      end

      @_model.get(value)
      [value, fbe_full_size]
    end

    # Move to the next struct value
    def next(prev)
      @_model.fbe_shift(prev)
    end
  end

  # noinspection RubyResolve, RubyScope, RubyTooManyInstanceVariablesInspection, RubyTooManyMethodsInspection
  class FinalModelBalanceMessage < FBE::FinalModel
    def initialize(buffer, offset)
      super(buffer, offset)
      @_body = FinalModelBalance.new(self.buffer, 0)
    end

    def body
      @_body
    end

    # Get the allocation size
    def fbe_allocation_size(fbe_value)
      0 \
        + body.fbe_allocation_size(fbe_value.body) \
    end

    # Get the final type
    def fbe_type
      TYPE
    end

    TYPE = 12

    # Is the struct value valid?
    def valid?
      verify
    end

    # Check if the struct value is valid
    def verify
      @_buffer.shift(fbe_offset)
      fbe_result = verify_fields
      @_buffer.unshift(fbe_offset)
      fbe_result
    end

    # Check if the struct fields are valid
    def verify_fields
      fbe_current_offset = 0

      body.fbe_offset = fbe_current_offset
      fbe_field_size = body.verify
      if fbe_field_size == FBE::Integer::MAX
        return FBE::Integer::MAX
      end
      fbe_current_offset += fbe_field_size

      # noinspection RubyUnnecessaryReturnValue
      fbe_current_offset
    end

    # Get the struct value
    def get(fbe_value = BalanceMessage.new)
      @_buffer.shift(fbe_offset)
      fbe_size = get_fields(fbe_value)
      @_buffer.unshift(fbe_offset)
      [fbe_value, fbe_size]
    end

    # Get the struct fields values
    def get_fields(fbe_value)
      fbe_current_offset = 0
      fbe_current_size = 0

      body.fbe_offset = fbe_current_offset
      fbe_result = body.get
      fbe_value.body = fbe_result[0]
      # noinspection RubyUnusedLocalVariable
      fbe_current_offset += fbe_result[1]
      fbe_current_size += fbe_result[1]

      # noinspection RubyUnnecessaryReturnValue
      fbe_current_size
    end

    # Set the struct value
    def set(fbe_value)
      @_buffer.shift(fbe_offset)
      fbe_size = set_fields(fbe_value)
      @_buffer.unshift(fbe_offset)
      fbe_size
    end

    # Set the struct fields values
    def set_fields(fbe_value)
      fbe_current_offset = 0
      fbe_current_size = 0

      body.fbe_offset = fbe_current_offset
      fbe_field_size = body.set(fbe_value.body)
      # noinspection RubyUnusedLocalVariable
      fbe_current_offset += fbe_field_size
      fbe_current_size += fbe_field_size

      # noinspection RubyUnnecessaryReturnValue
      fbe_current_size
    end
  end

  # Fast Binary Encoding BalanceMessage final model
  class BalanceMessageFinalModel < FBE::Model
    def initialize(buffer = FBE::WriteBuffer.new)
      super(buffer)
      @_model = FinalModelBalanceMessage.new(self.buffer, 8)
    end

    # Get the model type
    def fbe_type
      TYPE
    end

    TYPE = FinalModelBalanceMessage::TYPE

    # Is the struct value valid?
    def valid?
      verify
    end

    # Check if the struct value is valid
    def verify
      if (buffer.offset + @_model.fbe_offset) > buffer.size
        return false
      end

      fbe_struct_size = read_uint32(@_model.fbe_offset - 8)
      fbe_struct_type = read_uint32(@_model.fbe_offset - 4)
      if (fbe_struct_size <= 0) or (fbe_struct_type != fbe_type)
        return false
      end

      (8 + @_model.verify) == fbe_struct_size
    end

    # Serialize the struct value
    def serialize(value)
      fbe_initial_size = buffer.size

      fbe_struct_type = fbe_type
      fbe_struct_size = 8 + @_model.fbe_allocation_size(value)
      fbe_struct_offset = buffer.allocate(fbe_struct_size) - buffer.offset
      if (buffer.offset + fbe_struct_offset + fbe_struct_size) > buffer.size
        return 0
      end

      fbe_struct_size = 8 + @_model.set(value)
      buffer.resize(fbe_initial_size + fbe_struct_size)

      write_uint32(@_model.fbe_offset - 8, fbe_struct_size)
      write_uint32(@_model.fbe_offset - 4, fbe_struct_type)

      fbe_struct_size
    end

    # Deserialize the struct value
    def deserialize(value = BalanceMessage.new)
      if (buffer.offset + @_model.fbe_offset) > buffer.size
        [BalanceMessage.new, 0]
      end

      fbe_struct_size = read_uint32(@_model.fbe_offset - 8)
      fbe_struct_type = read_uint32(@_model.fbe_offset - 4)
      if (fbe_struct_size <= 0) || (fbe_struct_type != fbe_type)
        [BalanceMessage.new, 8]
      end

      fbe_result = @_model.get(value)
      [fbe_result[0], (8 + fbe_result[1])]
    end

    # Move to the next struct value
    def next(prev)
      @_model.fbe_shift(prev)
    end
  end

  # noinspection RubyResolve, RubyScope, RubyTooManyInstanceVariablesInspection, RubyTooManyMethodsInspection
  class AccountMessage
    include Comparable

    attr_accessor :body

    def initialize(body = Account.new)
      @body = body
    end

    def initialize_copy(other)
      @body = other.body
    end

    # Struct shallow copy
    def copy(other)
      initialize_copy(other)
      self
    end

    # Struct deep clone
    def clone
      data = Marshal.dump(self)
      clone = Marshal.load(data)
      clone.freeze if frozen?
      clone
    end

    # Struct compare operators
    def <=>(other)
      return nil unless other.is_a?(AccountMessage)

      # noinspection RubyUnusedLocalVariable
      result = 0
      # noinspection RubyUnnecessaryReturnValue
      result
    end

    # Struct equals
    def eql?(other)
      self == other
    end

    # Struct keys
    def key
      result = []
      # noinspection RubyUnnecessaryReturnValue
      result
    end

    # Struct hash code
    def hash
      key.hash
    end

    # Get struct string value
    def to_s
      result = ''
      result << 'AccountMessage('
      result << 'body='
      if !@body.nil?
        result << @body.to_s
      else
        result << 'null'
      end
      result << ')'
      result
    end

    # Dump the struct
    def marshal_dump
      # Serialize the struct to the FBE stream
      writer = AccountMessageModel.new(FBE::WriteBuffer.new)
      writer.serialize(self)
      writer.buffer
    end

    # Load the struct
    def marshal_load(data)
      # Deserialize the struct from the FBE stream
      reader = AccountMessageModel.new(FBE::ReadBuffer.new)
      reader.attach_buffer(data)
      initialize_copy(reader.deserialize[0])
    end

    # Get struct JSON value
    def to_json
      JSON.generate(__to_json_map__)
    end

    # Get struct JSON map (internal method)
    def __to_json_map__
      result = {}
      key = 'body'
      value = (body.nil? ? nil : body.__to_json_map__)
      result.store(key, value)
      result
    end

    # Get struct from JSON
    def self.from_json(json)
      __from_json_map__(JSON.parse(json))
    end

    # Get struct map from JSON (internal method)
    def self.__from_json_map__(json)
      result = AccountMessage.new
      value = json.fetch('body', nil)
      result.body = (value.nil? ? nil : Account.__from_json_map__(value))
      result
    end

    # Get the FBE type
    def fbe_type
      TYPE
    end

    TYPE = 13
  end

  # noinspection RubyResolve, RubyScope, RubyTooManyInstanceVariablesInspection, RubyTooManyMethodsInspection
  class FieldModelAccountMessage < FBE::FieldModel
    def initialize(buffer, offset)
      super(buffer, offset)
      @_body = FieldModelAccount.new(self.buffer, 4 + 4)
    end

    def body
      @_body
    end

    # Get the field size
    def fbe_size
      4
    end

    # Get the field body size
    def fbe_body
      4 + 4 \
        + body.fbe_size \
    end

    # Get the field extra size
    def fbe_extra
      if (@_buffer.offset + fbe_offset + fbe_size) > @_buffer.size
        return 0
      end

      fbe_struct_offset = read_uint32(fbe_offset)
      if (fbe_struct_offset == 0) || ((@_buffer.offset + fbe_struct_offset + 4) > @_buffer.size)
        return 0
      end

      @_buffer.shift(fbe_struct_offset)

      fbe_result = fbe_body \
        + body.fbe_extra \

      @_buffer.unshift(fbe_struct_offset)

      fbe_result
    end

    # Get the field type
    def fbe_type
      TYPE
    end

    TYPE = 13

    # Is the struct value valid?
    def valid?
      verify
    end

    # Check if the struct value is valid
    def verify(fbe_verify_type = true)
      if (@_buffer.offset + fbe_offset + fbe_size) > @_buffer.size
        return true
      end

      fbe_struct_offset = read_uint32(fbe_offset)
      if (fbe_struct_offset == 0) || ((@_buffer.offset + fbe_struct_offset + 4 + 4) > @_buffer.size)
        return false
      end

      fbe_struct_size = read_uint32(fbe_struct_offset)
      if fbe_struct_size < (4 + 4)
        return false
      end

      fbe_struct_type = read_uint32(fbe_struct_offset + 4)
      if fbe_verify_type && (fbe_struct_type != fbe_type)
        return false
      end

      @_buffer.shift(fbe_struct_offset)
      fbe_result = verify_fields(fbe_struct_size)
      @_buffer.unshift(fbe_struct_offset)
      fbe_result
    end

    # Check if the struct fields are valid
    def verify_fields(fbe_struct_size)
      fbe_current_size = 4 + 4

      if (fbe_current_size + body.fbe_size) > fbe_struct_size
        return true
      end
      unless body.verify
        return false
      end
      # noinspection RubyUnusedLocalVariable
      fbe_current_size += body.fbe_size

      true
    end

    # Get the struct value (begin phase)
    def get_begin
      if (@_buffer.offset + fbe_offset + fbe_size) > @_buffer.size
        return 0
      end

      fbe_struct_offset = read_uint32(fbe_offset)
      if (fbe_struct_offset == 0) || ((@_buffer.offset + fbe_struct_offset + 4 + 4) > @_buffer.size)
        return 0
      end

      fbe_struct_size = read_uint32(fbe_struct_offset)
      if fbe_struct_size < (4 + 4)
        return 0
      end

      @_buffer.shift(fbe_struct_offset)
      fbe_struct_offset
    end

    # Get the struct value (end phase)
    def get_end(fbe_begin)
      @_buffer.unshift(fbe_begin)
    end

    # Get the struct value
    def get(fbe_value = AccountMessage.new)
      fbe_begin = get_begin
      if fbe_begin == 0
        return fbe_value
      end

      fbe_struct_size = read_uint32(0)
      get_fields(fbe_value, fbe_struct_size)
      get_end(fbe_begin)
      fbe_value
    end

    # Get the struct fields values
    def get_fields(fbe_value, fbe_struct_size)
      fbe_current_size = 4 + 4

      if (fbe_current_size + body.fbe_size) <= fbe_struct_size
        fbe_value.body = body.get
      else
        fbe_value.body = Account.new
      end
      # noinspection RubyUnusedLocalVariable
      fbe_current_size += body.fbe_size
    end

    # Set the struct value (begin phase)
    def set_begin
      if (@_buffer.offset + fbe_offset + fbe_size) > @_buffer.size
        return 0
      end

      fbe_struct_size = fbe_body
      fbe_struct_offset = @_buffer.allocate(fbe_struct_size) - @_buffer.offset
      if (fbe_struct_offset <= 0) || ((@_buffer.offset + fbe_struct_offset + fbe_struct_size) > @_buffer.size)
        return 0
      end

      write_uint32(fbe_offset, fbe_struct_offset)
      write_uint32(fbe_struct_offset, fbe_struct_size)
      write_uint32(fbe_struct_offset + 4, fbe_type)

      @_buffer.shift(fbe_struct_offset)
      fbe_struct_offset
    end

    # Set the struct value (end phase)
    def set_end(fbe_begin)
      @_buffer.unshift(fbe_begin)
    end

    # Set the struct value
    def set(fbe_value)
      fbe_begin = set_begin
      if fbe_begin == 0
        return
      end

      set_fields(fbe_value)
      set_end(fbe_begin)
    end

    # Set the struct fields values
    def set_fields(fbe_value)
      body.set(fbe_value.body)
    end
  end

  # Fast Binary Encoding AccountMessage model
  class AccountMessageModel < FBE::Model
    def initialize(buffer = FBE::WriteBuffer.new)
      super(buffer)
      @_model = FieldModelAccountMessage.new(self.buffer, 4)
    end

    def model
      @_model
    end

    # Get the model size
    def fbe_size
      @_model.fbe_size + @_model.fbe_extra
    end

    # Get the model type
    def fbe_type
      TYPE
    end

    TYPE = FieldModelAccountMessage::TYPE

    # Is the struct value valid?
    def valid?
      verify
    end

    # Check if the struct value is valid
    def verify
      if (buffer.offset + @_model.fbe_offset - 4) > buffer.size
        return false
      end

      fbe_full_size = read_uint32(@_model.fbe_offset - 4)
      if fbe_full_size < @_model.fbe_size
        return false
      end

      @_model.verify
    end

    # Create a new model (begin phase)
    def create_begin
      buffer.allocate(4 + @_model.fbe_size)
    end

    # Create a new model (end phase)
    def create_end(fbe_begin)
      fbe_end = buffer.size
      fbe_full_size = fbe_end - fbe_begin
      write_uint32(@_model.fbe_offset - 4, fbe_full_size)
      fbe_full_size
    end

    # Serialize the struct value
    def serialize(value)
      fbe_begin = create_begin
      @_model.set(value)
      create_end(fbe_begin)
    end

    # Deserialize the struct value
    def deserialize(value = AccountMessage.new)
      if (buffer.offset + @_model.fbe_offset - 4) > buffer.size
        [AccountMessage.new, 0]
      end

      fbe_full_size = read_uint32(@_model.fbe_offset - 4)
      if fbe_full_size < @_model.fbe_size
        [AccountMessage.new, 0]
      end

      @_model.get(value)
      [value, fbe_full_size]
    end

    # Move to the next struct value
    def next(prev)
      @_model.fbe_shift(prev)
    end
  end

  # noinspection RubyResolve, RubyScope, RubyTooManyInstanceVariablesInspection, RubyTooManyMethodsInspection
  class FinalModelAccountMessage < FBE::FinalModel
    def initialize(buffer, offset)
      super(buffer, offset)
      @_body = FinalModelAccount.new(self.buffer, 0)
    end

    def body
      @_body
    end

    # Get the allocation size
    def fbe_allocation_size(fbe_value)
      0 \
        + body.fbe_allocation_size(fbe_value.body) \
    end

    # Get the final type
    def fbe_type
      TYPE
    end

    TYPE = 13

    # Is the struct value valid?
    def valid?
      verify
    end

    # Check if the struct value is valid
    def verify
      @_buffer.shift(fbe_offset)
      fbe_result = verify_fields
      @_buffer.unshift(fbe_offset)
      fbe_result
    end

    # Check if the struct fields are valid
    def verify_fields
      fbe_current_offset = 0

      body.fbe_offset = fbe_current_offset
      fbe_field_size = body.verify
      if fbe_field_size == FBE::Integer::MAX
        return FBE::Integer::MAX
      end
      fbe_current_offset += fbe_field_size

      # noinspection RubyUnnecessaryReturnValue
      fbe_current_offset
    end

    # Get the struct value
    def get(fbe_value = AccountMessage.new)
      @_buffer.shift(fbe_offset)
      fbe_size = get_fields(fbe_value)
      @_buffer.unshift(fbe_offset)
      [fbe_value, fbe_size]
    end

    # Get the struct fields values
    def get_fields(fbe_value)
      fbe_current_offset = 0
      fbe_current_size = 0

      body.fbe_offset = fbe_current_offset
      fbe_result = body.get
      fbe_value.body = fbe_result[0]
      # noinspection RubyUnusedLocalVariable
      fbe_current_offset += fbe_result[1]
      fbe_current_size += fbe_result[1]

      # noinspection RubyUnnecessaryReturnValue
      fbe_current_size
    end

    # Set the struct value
    def set(fbe_value)
      @_buffer.shift(fbe_offset)
      fbe_size = set_fields(fbe_value)
      @_buffer.unshift(fbe_offset)
      fbe_size
    end

    # Set the struct fields values
    def set_fields(fbe_value)
      fbe_current_offset = 0
      fbe_current_size = 0

      body.fbe_offset = fbe_current_offset
      fbe_field_size = body.set(fbe_value.body)
      # noinspection RubyUnusedLocalVariable
      fbe_current_offset += fbe_field_size
      fbe_current_size += fbe_field_size

      # noinspection RubyUnnecessaryReturnValue
      fbe_current_size
    end
  end

  # Fast Binary Encoding AccountMessage final model
  class AccountMessageFinalModel < FBE::Model
    def initialize(buffer = FBE::WriteBuffer.new)
      super(buffer)
      @_model = FinalModelAccountMessage.new(self.buffer, 8)
    end

    # Get the model type
    def fbe_type
      TYPE
    end

    TYPE = FinalModelAccountMessage::TYPE

    # Is the struct value valid?
    def valid?
      verify
    end

    # Check if the struct value is valid
    def verify
      if (buffer.offset + @_model.fbe_offset) > buffer.size
        return false
      end

      fbe_struct_size = read_uint32(@_model.fbe_offset - 8)
      fbe_struct_type = read_uint32(@_model.fbe_offset - 4)
      if (fbe_struct_size <= 0) or (fbe_struct_type != fbe_type)
        return false
      end

      (8 + @_model.verify) == fbe_struct_size
    end

    # Serialize the struct value
    def serialize(value)
      fbe_initial_size = buffer.size

      fbe_struct_type = fbe_type
      fbe_struct_size = 8 + @_model.fbe_allocation_size(value)
      fbe_struct_offset = buffer.allocate(fbe_struct_size) - buffer.offset
      if (buffer.offset + fbe_struct_offset + fbe_struct_size) > buffer.size
        return 0
      end

      fbe_struct_size = 8 + @_model.set(value)
      buffer.resize(fbe_initial_size + fbe_struct_size)

      write_uint32(@_model.fbe_offset - 8, fbe_struct_size)
      write_uint32(@_model.fbe_offset - 4, fbe_struct_type)

      fbe_struct_size
    end

    # Deserialize the struct value
    def deserialize(value = AccountMessage.new)
      if (buffer.offset + @_model.fbe_offset) > buffer.size
        [AccountMessage.new, 0]
      end

      fbe_struct_size = read_uint32(@_model.fbe_offset - 8)
      fbe_struct_type = read_uint32(@_model.fbe_offset - 4)
      if (fbe_struct_size <= 0) || (fbe_struct_type != fbe_type)
        [AccountMessage.new, 8]
      end

      fbe_result = @_model.get(value)
      [fbe_result[0], (8 + fbe_result[1])]
    end

    # Move to the next struct value
    def next(prev)
      @_model.fbe_shift(prev)
    end
  end

  # Fast Binary Encoding Protoex protocol version
  class ProtocolVersion
    # Protocol major version
    MAJOR = 1
    # Protocol minor version
    MINOR = 0
  end

  # Fast Binary Encoding Protoex sender
  # noinspection RubyResolve, RubyScope, RubyTooManyInstanceVariablesInspection, RubyTooManyMethodsInspection
  class Sender < FBE::Sender
    def initialize(buffer = FBE::WriteBuffer.new)
      super(buffer, false)
      @_proto_sender = Proto::Sender.new(self.buffer)
      @_ordermessage_model = OrderMessageModel.new(self.buffer)
      @_balancemessage_model = BalanceMessageModel.new(self.buffer)
      @_accountmessage_model = AccountMessageModel.new(self.buffer)
    end

    # Imported senders

    def proto_sender
      @_proto_sender
    end

    # Sender models accessors

    def ordermessage_model
      @_ordermessage_model
    end

    def balancemessage_model
      @_balancemessage_model
    end

    def accountmessage_model
      @_accountmessage_model
    end

    # Send methods

    def send(value)
      if value.is_a?(OrderMessage) && (value.fbe_type == ordermessage_model.fbe_type)
        return send_ordermessage(value)
      end
      if value.is_a?(BalanceMessage) && (value.fbe_type == balancemessage_model.fbe_type)
        return send_balancemessage(value)
      end
      if value.is_a?(AccountMessage) && (value.fbe_type == accountmessage_model.fbe_type)
        return send_accountmessage(value)
      end
      result = @_proto_sender.send(value)
      if result > 0
        return result
      end
      0
    end

    def send_ordermessage(value)
      # Serialize the value into the FBE stream
      serialized = ordermessage_model.serialize(value)
      raise RuntimeError, "Protoex.OrderMessage serialization failed!" if serialized <= 0
      raise RuntimeError, "Protoex.OrderMessage validation failed!" unless ordermessage_model.verify

      # Log the value
      if logging?
        message = value.to_s
        on_send_log(message)
      end

      # Send the serialized value
      send_serialized(serialized)
    end

    def send_balancemessage(value)
      # Serialize the value into the FBE stream
      serialized = balancemessage_model.serialize(value)
      raise RuntimeError, "Protoex.BalanceMessage serialization failed!" if serialized <= 0
      raise RuntimeError, "Protoex.BalanceMessage validation failed!" unless balancemessage_model.verify

      # Log the value
      if logging?
        message = value.to_s
        on_send_log(message)
      end

      # Send the serialized value
      send_serialized(serialized)
    end

    def send_accountmessage(value)
      # Serialize the value into the FBE stream
      serialized = accountmessage_model.serialize(value)
      raise RuntimeError, "Protoex.AccountMessage serialization failed!" if serialized <= 0
      raise RuntimeError, "Protoex.AccountMessage validation failed!" unless accountmessage_model.verify

      # Log the value
      if logging?
        message = value.to_s
        on_send_log(message)
      end

      # Send the serialized value
      send_serialized(serialized)
    end

    protected

    # Send message handler
    def on_send(buffer, offset, size)
      raise NotImplementedError, "Protoex.Sender.on_send() not implemented!"
    end
  end

  # Fast Binary Encoding Protoex receiver
  # noinspection RubyResolve, RubyScope, RubyTooManyInstanceVariablesInspection, RubyTooManyMethodsInspection
  class Receiver < FBE::Receiver
    def initialize(buffer = FBE::WriteBuffer.new)
      super(buffer, false)
      @_proto_receiver = Proto::Receiver.new(self.buffer)
      @_ordermessage_value = OrderMessage.new
      @_ordermessage_model = OrderMessageModel.new
      @_balancemessage_value = BalanceMessage.new
      @_balancemessage_model = BalanceMessageModel.new
      @_accountmessage_value = AccountMessage.new
      @_accountmessage_model = AccountMessageModel.new
    end

    # Imported receivers

    def proto_receiver
      @_proto_receiver
    end

    def proto_receiver=(receiver)
      @_proto_receiver = receiver
    end

    protected

    # Receive handlers

    # noinspection RubyUnusedLocalVariable
    def on_receive_ordermessage(value)
    end

    # noinspection RubyUnusedLocalVariable
    def on_receive_balancemessage(value)
    end

    # noinspection RubyUnusedLocalVariable
    def on_receive_accountmessage(value)
    end

    public

    def on_receive(type, buffer, offset, size)
      case type
      when OrderMessageModel::TYPE
        # Deserialize the value from the FBE stream
        @_ordermessage_model.attach_buffer(buffer, offset)
        unless @_ordermessage_model.verify
          return false
        end
        _, deserialized = @_ordermessage_model.deserialize(@_ordermessage_value)
        if deserialized <= 0
          return false
        end

        # Log the value
        if logging?
          message = @_ordermessage_value.to_s
          on_receive_log(message)
        end

        # Call receive handler with deserialized value
        on_receive_ordermessage(@_ordermessage_value)
        true
      when BalanceMessageModel::TYPE
        # Deserialize the value from the FBE stream
        @_balancemessage_model.attach_buffer(buffer, offset)
        unless @_balancemessage_model.verify
          return false
        end
        _, deserialized = @_balancemessage_model.deserialize(@_balancemessage_value)
        if deserialized <= 0
          return false
        end

        # Log the value
        if logging?
          message = @_balancemessage_value.to_s
          on_receive_log(message)
        end

        # Call receive handler with deserialized value
        on_receive_balancemessage(@_balancemessage_value)
        true
      when AccountMessageModel::TYPE
        # Deserialize the value from the FBE stream
        @_accountmessage_model.attach_buffer(buffer, offset)
        unless @_accountmessage_model.verify
          return false
        end
        _, deserialized = @_accountmessage_model.deserialize(@_accountmessage_value)
        if deserialized <= 0
          return false
        end

        # Log the value
        if logging?
          message = @_accountmessage_value.to_s
          on_receive_log(message)
        end

        # Call receive handler with deserialized value
        on_receive_accountmessage(@_accountmessage_value)
        true
      else
        # Do nothing here...
      end

      if !proto_receiver.nil? && proto_receiver.on_receive(type, buffer, offset, size)
        return true
      end

      false
    end
  end

  # Fast Binary Encoding Protoex proxy
  # noinspection RubyResolve, RubyScope, RubyTooManyInstanceVariablesInspection, RubyTooManyMethodsInspection
  class Proxy < FBE::Receiver
    def initialize(buffer = FBE::WriteBuffer.new)
      super(buffer, false)
      @_proto_proxy = Proto::Proxy.new(self.buffer)
      @_ordermessage_model = OrderMessageModel.new
      @_balancemessage_model = BalanceMessageModel.new
      @_accountmessage_model = AccountMessageModel.new
    end

    # Imported proxy

    def proto_proxy
      @_proto_proxy
    end

    def proto_proxy=(proxy)
      @_proto_proxy = proxy
    end

    protected

    # Receive handlers

    # noinspection RubyUnusedLocalVariable
    def on_proxy_ordermessage(model, type, buffer, offset, size)
    end

    # noinspection RubyUnusedLocalVariable
    def on_proxy_balancemessage(model, type, buffer, offset, size)
    end

    # noinspection RubyUnusedLocalVariable
    def on_proxy_accountmessage(model, type, buffer, offset, size)
    end

    public

    def on_receive(type, buffer, offset, size)
      case type
      when OrderMessageModel::TYPE
        # Attach the FBE stream to the proxy model
        @_ordermessage_model.attach_buffer(buffer, offset)
        unless @_ordermessage_model.verify
          return false
        end

        fbe_begin = @_ordermessage_model.model.get_begin
        if fbe_begin == 0
          return false
        end
        # Call proxy handler
        on_proxy_ordermessage(@_ordermessage_model, type, buffer, offset, size)
        @_ordermessage_model.model.get_end(fbe_begin)
        true
      when BalanceMessageModel::TYPE
        # Attach the FBE stream to the proxy model
        @_balancemessage_model.attach_buffer(buffer, offset)
        unless @_balancemessage_model.verify
          return false
        end

        fbe_begin = @_balancemessage_model.model.get_begin
        if fbe_begin == 0
          return false
        end
        # Call proxy handler
        on_proxy_balancemessage(@_balancemessage_model, type, buffer, offset, size)
        @_balancemessage_model.model.get_end(fbe_begin)
        true
      when AccountMessageModel::TYPE
        # Attach the FBE stream to the proxy model
        @_accountmessage_model.attach_buffer(buffer, offset)
        unless @_accountmessage_model.verify
          return false
        end

        fbe_begin = @_accountmessage_model.model.get_begin
        if fbe_begin == 0
          return false
        end
        # Call proxy handler
        on_proxy_accountmessage(@_accountmessage_model, type, buffer, offset, size)
        @_accountmessage_model.model.get_end(fbe_begin)
        true
      else
        # Do nothing here...
      end

      if !proto_proxy.nil? && proto_proxy.on_receive(type, buffer, offset, size)
        return true
      end

      false
    end
  end

  # Fast Binary Encoding Protoex final sender
  # noinspection RubyResolve, RubyScope, RubyTooManyInstanceVariablesInspection, RubyTooManyMethodsInspection
  class FinalSender < FBE::Sender
    def initialize(buffer = FBE::WriteBuffer.new)
      super(buffer, true)
      @_proto_sender = Proto::FinalSender.new(self.buffer)
      @_ordermessage_model = OrderMessageFinalModel.new(self.buffer)
      @_balancemessage_model = BalanceMessageFinalModel.new(self.buffer)
      @_accountmessage_model = AccountMessageFinalModel.new(self.buffer)
    end

    # Imported senders

    def proto_sender
      @_proto_sender
    end

    # Sender models accessors

    def ordermessage_model
      @_ordermessage_model
    end

    def balancemessage_model
      @_balancemessage_model
    end

    def accountmessage_model
      @_accountmessage_model
    end

    # Send methods

    def send(value)
      if value.is_a?(OrderMessage) && (value.fbe_type == ordermessage_model.fbe_type)
        return send_ordermessage(value)
      end
      if value.is_a?(BalanceMessage) && (value.fbe_type == balancemessage_model.fbe_type)
        return send_balancemessage(value)
      end
      if value.is_a?(AccountMessage) && (value.fbe_type == accountmessage_model.fbe_type)
        return send_accountmessage(value)
      end
      result = @_proto_sender.send(value)
      if result > 0
        return result
      end
      0
    end

    def send_ordermessage(value)
      # Serialize the value into the FBE stream
      serialized = ordermessage_model.serialize(value)
      raise RuntimeError, "Protoex.OrderMessage serialization failed!" if serialized <= 0
      raise RuntimeError, "Protoex.OrderMessage validation failed!" unless ordermessage_model.verify

      # Log the value
      if logging?
        message = value.to_s
        on_send_log(message)
      end

      # Send the serialized value
      send_serialized(serialized)
    end

    def send_balancemessage(value)
      # Serialize the value into the FBE stream
      serialized = balancemessage_model.serialize(value)
      raise RuntimeError, "Protoex.BalanceMessage serialization failed!" if serialized <= 0
      raise RuntimeError, "Protoex.BalanceMessage validation failed!" unless balancemessage_model.verify

      # Log the value
      if logging?
        message = value.to_s
        on_send_log(message)
      end

      # Send the serialized value
      send_serialized(serialized)
    end

    def send_accountmessage(value)
      # Serialize the value into the FBE stream
      serialized = accountmessage_model.serialize(value)
      raise RuntimeError, "Protoex.AccountMessage serialization failed!" if serialized <= 0
      raise RuntimeError, "Protoex.AccountMessage validation failed!" unless accountmessage_model.verify

      # Log the value
      if logging?
        message = value.to_s
        on_send_log(message)
      end

      # Send the serialized value
      send_serialized(serialized)
    end

    protected

    # Send message handler
    def on_send(buffer, offset, size)
      raise NotImplementedError, "Protoex.Sender.on_send() not implemented!"
    end
  end

  # Fast Binary Encoding Protoex final receiver
  # noinspection RubyResolve, RubyScope, RubyTooManyInstanceVariablesInspection, RubyTooManyMethodsInspection
  class FinalReceiver < FBE::Receiver
    def initialize(buffer = FBE::WriteBuffer.new)
      super(buffer, true)
      @_proto_receiver = Proto::FinalReceiver.new(self.buffer)
      @_ordermessage_value = OrderMessage.new
      @_ordermessage_model = OrderMessageFinalModel.new
      @_balancemessage_value = BalanceMessage.new
      @_balancemessage_model = BalanceMessageFinalModel.new
      @_accountmessage_value = AccountMessage.new
      @_accountmessage_model = AccountMessageFinalModel.new
    end

    # Imported receivers

    def proto_receiver
      @_proto_receiver
    end

    def proto_receiver=(receiver)
      @_proto_receiver = receiver
    end

    protected

    # Receive handlers

    # noinspection RubyUnusedLocalVariable
    def on_receive_ordermessage(value)
    end

    # noinspection RubyUnusedLocalVariable
    def on_receive_balancemessage(value)
    end

    # noinspection RubyUnusedLocalVariable
    def on_receive_accountmessage(value)
    end

    public

    def on_receive(type, buffer, offset, size)
      case type
      when OrderMessageFinalModel::TYPE
        # Deserialize the value from the FBE stream
        @_ordermessage_model.attach_buffer(buffer, offset)
        unless @_ordermessage_model.verify
          return false
        end
        _, deserialized = @_ordermessage_model.deserialize(@_ordermessage_value)
        if deserialized <= 0
          return false
        end

        # Log the value
        if logging?
          message = @_ordermessage_value.to_s
          on_receive_log(message)
        end

        # Call receive handler with deserialized value
        on_receive_ordermessage(@_ordermessage_value)
        true
      when BalanceMessageFinalModel::TYPE
        # Deserialize the value from the FBE stream
        @_balancemessage_model.attach_buffer(buffer, offset)
        unless @_balancemessage_model.verify
          return false
        end
        _, deserialized = @_balancemessage_model.deserialize(@_balancemessage_value)
        if deserialized <= 0
          return false
        end

        # Log the value
        if logging?
          message = @_balancemessage_value.to_s
          on_receive_log(message)
        end

        # Call receive handler with deserialized value
        on_receive_balancemessage(@_balancemessage_value)
        true
      when AccountMessageFinalModel::TYPE
        # Deserialize the value from the FBE stream
        @_accountmessage_model.attach_buffer(buffer, offset)
        unless @_accountmessage_model.verify
          return false
        end
        _, deserialized = @_accountmessage_model.deserialize(@_accountmessage_value)
        if deserialized <= 0
          return false
        end

        # Log the value
        if logging?
          message = @_accountmessage_value.to_s
          on_receive_log(message)
        end

        # Call receive handler with deserialized value
        on_receive_accountmessage(@_accountmessage_value)
        true
      else
        # Do nothing here...
      end

      if !proto_receiver.nil? && proto_receiver.on_receive(type, buffer, offset, size)
        return true
      end

      false
    end
  end

end

# rubocop:enable all
