#------------------------------------------------------------------------------
# Automatically generated by the Fast Binary Encoding compiler, do not modify!
# https://github.com/chronoxor/FastBinaryEncoding
# Source: proto.fbe
# FBE version: 1.14.5.0
#------------------------------------------------------------------------------

import base64
import decimal
import enum
import functools
import json
import sys
import uuid

import fbe


class OrderSide(enum.IntEnum, metaclass=fbe.DefaultEnumMeta):
    buy = int(0) + 0
    sell = int(0) + 1
    unknown = ~0

    __slots__ = ()

    def __format__(self, format_spec):
        return self.__str__()

    def __str__(self):
        if self.value == OrderSide.buy:
            return "buy"
        if self.value == OrderSide.sell:
            return "sell"
        return "<unknown>"

    @classmethod
    def _missing_(cls, value):
        return OrderSide.unknown

    @staticmethod
    def __from_json__(value):
        if value is None:
            return None
        return OrderSide(value)


# Fast Binary Encoding OrderSide field model
class FieldModelOrderSide(fbe.FieldModel):
    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)

    # Get the field size
    @property
    def fbe_size(self):
        return 1

    # Get the value
    def get(self, defaults=None):
        if defaults is None:
            defaults = OrderSide()

        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return defaults

        return OrderSide(self.read_byte(self.fbe_offset))

    # Set the value
    def set(self, value):
        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return

        self.write_byte(self.fbe_offset, value)


# Fast Binary Encoding OrderSide final model
class FinalModelOrderSide(fbe.FinalModel):
    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)

    # Get the allocation size
    # noinspection PyUnusedLocal
    def fbe_allocation_size(self, value):
        return self.fbe_size

    # Get the final size
    @property
    def fbe_size(self):
        return 1

    # Check if the value is valid
    def verify(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return sys.maxsize

        return self.fbe_size

    # Get the value
    def get(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return OrderSide(), 0

        return OrderSide(self.read_byte(self.fbe_offset)), self.fbe_size

    # Set the value
    def set(self, value):
        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        self.write_byte(self.fbe_offset, value)
        return self.fbe_size


class OrderType(enum.IntEnum, metaclass=fbe.DefaultEnumMeta):
    market = int(0) + 0
    limit = int(0) + 1
    stop = int(0) + 2
    unknown = ~0

    __slots__ = ()

    def __format__(self, format_spec):
        return self.__str__()

    def __str__(self):
        if self.value == OrderType.market:
            return "market"
        if self.value == OrderType.limit:
            return "limit"
        if self.value == OrderType.stop:
            return "stop"
        return "<unknown>"

    @classmethod
    def _missing_(cls, value):
        return OrderType.unknown

    @staticmethod
    def __from_json__(value):
        if value is None:
            return None
        return OrderType(value)


# Fast Binary Encoding OrderType field model
class FieldModelOrderType(fbe.FieldModel):
    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)

    # Get the field size
    @property
    def fbe_size(self):
        return 1

    # Get the value
    def get(self, defaults=None):
        if defaults is None:
            defaults = OrderType()

        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return defaults

        return OrderType(self.read_byte(self.fbe_offset))

    # Set the value
    def set(self, value):
        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return

        self.write_byte(self.fbe_offset, value)


# Fast Binary Encoding OrderType final model
class FinalModelOrderType(fbe.FinalModel):
    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)

    # Get the allocation size
    # noinspection PyUnusedLocal
    def fbe_allocation_size(self, value):
        return self.fbe_size

    # Get the final size
    @property
    def fbe_size(self):
        return 1

    # Check if the value is valid
    def verify(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return sys.maxsize

        return self.fbe_size

    # Get the value
    def get(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return OrderType(), 0

        return OrderType(self.read_byte(self.fbe_offset)), self.fbe_size

    # Set the value
    def set(self, value):
        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        self.write_byte(self.fbe_offset, value)
        return self.fbe_size


class State(enum.IntFlag, metaclass=fbe.DefaultEnumMeta):
    unknown = int(0x00)
    invalid = int(0x01)
    initialized = int(0x02)
    calculated = int(0x04)
    broken = int(0x08)
    good = initialized | calculated
    bad = unknown | invalid | broken

    __slots__ = ()

    # Is flags set?
    def has_flags(self, flags):
        return ((self.value & flags.value) != 0) and ((self.value & flags.value) == flags.value)

    # Set flags
    def set_flags(self, flags):
        self.value |= flags.value
        return self

    # Remove flags
    def remove_flags(self, flags):
        self.value &= ~flags.value
        return self

    def __format__(self, format_spec):
        return self.__str__()

    def __str__(self):
        sb = list()
        first = True
        if (self.value & State.unknown.value) and ((self.value & State.unknown.value) == State.unknown.value):
            if first:
                # noinspection PyUnusedLocal
                first = False
            else:
                sb.append("|")
            sb.append("unknown")
        if (self.value & State.invalid.value) and ((self.value & State.invalid.value) == State.invalid.value):
            if first:
                # noinspection PyUnusedLocal
                first = False
            else:
                sb.append("|")
            sb.append("invalid")
        if (self.value & State.initialized.value) and ((self.value & State.initialized.value) == State.initialized.value):
            if first:
                # noinspection PyUnusedLocal
                first = False
            else:
                sb.append("|")
            sb.append("initialized")
        if (self.value & State.calculated.value) and ((self.value & State.calculated.value) == State.calculated.value):
            if first:
                # noinspection PyUnusedLocal
                first = False
            else:
                sb.append("|")
            sb.append("calculated")
        if (self.value & State.broken.value) and ((self.value & State.broken.value) == State.broken.value):
            if first:
                # noinspection PyUnusedLocal
                first = False
            else:
                sb.append("|")
            sb.append("broken")
        if (self.value & State.good.value) and ((self.value & State.good.value) == State.good.value):
            if first:
                # noinspection PyUnusedLocal
                first = False
            else:
                sb.append("|")
            sb.append("good")
        if (self.value & State.bad.value) and ((self.value & State.bad.value) == State.bad.value):
            if first:
                # noinspection PyUnusedLocal
                first = False
            else:
                sb.append("|")
            sb.append("bad")
        return "".join(sb)

    @staticmethod
    def __from_json__(value):
        if value is None:
            return None
        return State(value)


# Fast Binary Encoding State field model
class FieldModelState(fbe.FieldModel):
    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)

    # Get the field size
    @property
    def fbe_size(self):
        return 1

    # Get the value
    def get(self, defaults=None):
        if defaults is None:
            defaults = State()

        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return defaults

        return State(self.read_byte(self.fbe_offset))

    # Set the value
    def set(self, value):
        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return

        self.write_byte(self.fbe_offset, value)


# Fast Binary Encoding State final model
class FinalModelState(fbe.FinalModel):
    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)

    # Get the allocation size
    # noinspection PyUnusedLocal
    def fbe_allocation_size(self, value):
        return self.fbe_size

    # Get the final size
    @property
    def fbe_size(self):
        return 1

    # Check if the value is valid
    def verify(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return sys.maxsize

        return self.fbe_size

    # Get the value
    def get(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return State(), 0

        return State(self.read_byte(self.fbe_offset)), self.fbe_size

    # Set the value
    def set(self, value):
        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        self.write_byte(self.fbe_offset, value)
        return self.fbe_size


@functools.total_ordering
class Order(object):
    __slots__ = "id", "symbol", "side", "type", "price", "volume", 

    def __init__(self, id=0, symbol="", side=None, type=None, price=float(0.0), volume=float(0.0)):
        if side is None:
            side = OrderSide()
        if type is None:
            type = OrderType()
        self.id = id
        self.symbol = symbol
        self.side = side
        self.type = type
        self.price = price
        self.volume = volume

    # Struct shallow copy
    def copy(self, other):
        self.id = other.id
        self.symbol = other.symbol
        self.side = other.side
        self.type = other.type
        self.price = other.price
        self.volume = other.volume
        return self

    # Struct deep clone
    def clone(self):
        # Serialize the struct to the FBE stream
        writer = OrderModel(fbe.WriteBuffer())
        writer.serialize(self)

        # Deserialize the struct from the FBE stream
        reader = OrderModel(fbe.ReadBuffer())
        reader.attach_buffer(writer.buffer)
        return reader.deserialize()[0]

    def __eq__(self, other):
        if not isinstance(self, other.__class__):
            return NotImplemented
        if not self.id == other.id:
            return False
        return True

    def __lt__(self, other):
        if not isinstance(self, other.__class__):
            return NotImplemented
        if self.id < other.id:
            return True
        if self.id == other.id:
            return False
        return False

    @property
    def __key__(self):
        return self.id, 

    def __hash__(self):
        return hash(self.__key__)

    def __format__(self, format_spec):
        return self.__str__()

    def __str__(self):
        sb = list()
        sb.append("Order(")
        sb.append("id=")
        sb.append(str(self.id))
        sb.append(",symbol=")
        if self.symbol is not None:
            sb.append("\"" + str(self.symbol) + "\"")
        else:
            sb.append("null")
        sb.append(",side=")
        sb.append(str(self.side))
        sb.append(",type=")
        sb.append(str(self.type))
        sb.append(",price=")
        sb.append(str(self.price))
        sb.append(",volume=")
        sb.append(str(self.volume))
        sb.append(")")
        return "".join(sb)

    # Get struct JSON value
    def to_json(self):
        return json.dumps(self.__to_json__(), cls=fbe.JSONEncoder, separators=(',', ':'))

    def __to_json__(self):
        result = dict()
        result.update(dict(
            id=self.id, 
            symbol=self.symbol, 
            side=self.side, 
            type=self.type, 
            price=self.price, 
            volume=self.volume, 
        ))
        return result

    # Create struct from JSON value
    @staticmethod
    def from_json(document):
        return Order.__from_json__(json.loads(document))

    @staticmethod
    def __from_json__(fields):
        if fields is None:
            return None
        return Order(
            None if "id" not in fields else fields["id"],
            None if "symbol" not in fields else fields["symbol"],
            None if "side" not in fields else OrderSide.__from_json__(fields["side"]),
            None if "type" not in fields else OrderType.__from_json__(fields["type"]),
            None if "price" not in fields else fields["price"],
            None if "volume" not in fields else fields["volume"],
        )

    # Get the FBE type
    @property
    def fbe_type(self):
        return self.TYPE

    TYPE = 1


class FieldModelOrder(fbe.FieldModel):
    __slots__ = "_id", "_symbol", "_side", "_type", "_price", "_volume", 

    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)
        self._id = fbe.FieldModelInt32(buffer, 4 + 4)
        self._symbol = fbe.FieldModelString(buffer, self._id.fbe_offset + self._id.fbe_size)
        self._side = FieldModelOrderSide(buffer, self._symbol.fbe_offset + self._symbol.fbe_size)
        self._type = FieldModelOrderType(buffer, self._side.fbe_offset + self._side.fbe_size)
        self._price = fbe.FieldModelDouble(buffer, self._type.fbe_offset + self._type.fbe_size)
        self._volume = fbe.FieldModelDouble(buffer, self._price.fbe_offset + self._price.fbe_size)

    @property
    def id(self):
        return self._id

    @property
    def symbol(self):
        return self._symbol

    @property
    def side(self):
        return self._side

    @property
    def type(self):
        return self._type

    @property
    def price(self):
        return self._price

    @property
    def volume(self):
        return self._volume

    # Get the field size
    @property
    def fbe_size(self):
        return 4

    # Get the field body size
    @property
    def fbe_body(self):
        fbe_result = 4 + 4 \
            + self.id.fbe_size \
            + self.symbol.fbe_size \
            + self.side.fbe_size \
            + self.type.fbe_size \
            + self.price.fbe_size \
            + self.volume.fbe_size \

        return fbe_result

    # Get the field extra size
    @property
    def fbe_extra(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        fbe_struct_offset = self.read_uint32(self.fbe_offset)
        if (fbe_struct_offset == 0) or ((self._buffer.offset + fbe_struct_offset + 4) > self._buffer.size):
            return 0

        self._buffer.shift(fbe_struct_offset)

        fbe_result = self.fbe_body \
            + self.id.fbe_extra \
            + self.symbol.fbe_extra \
            + self.side.fbe_extra \
            + self.type.fbe_extra \
            + self.price.fbe_extra \
            + self.volume.fbe_extra \

        self._buffer.unshift(fbe_struct_offset)

        return fbe_result

    # Get the field type
    @property
    def fbe_type(self):
        return self.TYPE

    TYPE = 1

    # Check if the struct value is valid
    def verify(self, fbe_verify_type=True):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return True

        fbe_struct_offset = self.read_uint32(self.fbe_offset)
        if (fbe_struct_offset == 0) or ((self._buffer.offset + fbe_struct_offset + 4 + 4) > self._buffer.size):
            return False

        fbe_struct_size = self.read_uint32(fbe_struct_offset)
        if fbe_struct_size < (4 + 4):
            return False

        fbe_struct_type = self.read_uint32(fbe_struct_offset + 4)
        if fbe_verify_type and (fbe_struct_type != self.fbe_type):
            return False

        self._buffer.shift(fbe_struct_offset)
        fbe_result = self.verify_fields(fbe_struct_size)
        self._buffer.unshift(fbe_struct_offset)
        return fbe_result

    # Check if the struct fields are valid
    def verify_fields(self, fbe_struct_size):
        fbe_current_size = 4 + 4

        if (fbe_current_size + self.id.fbe_size) > fbe_struct_size:
            return True
        if not self.id.verify():
            return False
        fbe_current_size += self.id.fbe_size

        if (fbe_current_size + self.symbol.fbe_size) > fbe_struct_size:
            return True
        if not self.symbol.verify():
            return False
        fbe_current_size += self.symbol.fbe_size

        if (fbe_current_size + self.side.fbe_size) > fbe_struct_size:
            return True
        if not self.side.verify():
            return False
        fbe_current_size += self.side.fbe_size

        if (fbe_current_size + self.type.fbe_size) > fbe_struct_size:
            return True
        if not self.type.verify():
            return False
        fbe_current_size += self.type.fbe_size

        if (fbe_current_size + self.price.fbe_size) > fbe_struct_size:
            return True
        if not self.price.verify():
            return False
        fbe_current_size += self.price.fbe_size

        if (fbe_current_size + self.volume.fbe_size) > fbe_struct_size:
            return True
        if not self.volume.verify():
            return False
        fbe_current_size += self.volume.fbe_size

        return True

    # Get the struct value (begin phase)
    def get_begin(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        fbe_struct_offset = self.read_uint32(self.fbe_offset)
        assert (fbe_struct_offset > 0) and ((self._buffer.offset + fbe_struct_offset + 4 + 4) <= self._buffer.size), "Model is broken!"
        if (fbe_struct_offset == 0) or ((self._buffer.offset + fbe_struct_offset + 4 + 4) > self._buffer.size):
            return 0

        fbe_struct_size = self.read_uint32(fbe_struct_offset)
        assert (fbe_struct_size >= (4 + 4)), "Model is broken!"
        if fbe_struct_size < (4 + 4):
            return 0

        self._buffer.shift(fbe_struct_offset)
        return fbe_struct_offset

    # Get the struct value (end phase)
    def get_end(self, fbe_begin):
        self._buffer.unshift(fbe_begin)

    # Get the struct value
    def get(self, fbe_value=None):
        if fbe_value is None:
            fbe_value = Order()

        fbe_begin = self.get_begin()
        if fbe_begin == 0:
            return fbe_value

        fbe_struct_size = self.read_uint32(0)
        self.get_fields(fbe_value, fbe_struct_size)
        self.get_end(fbe_begin)
        return fbe_value

    # Get the struct fields values
    def get_fields(self, fbe_value, fbe_struct_size):
        fbe_current_size = 4 + 4

        if (fbe_current_size + self.id.fbe_size) <= fbe_struct_size:
            fbe_value.id = self.id.get()
        else:
            fbe_value.id = 0
        fbe_current_size += self.id.fbe_size

        if (fbe_current_size + self.symbol.fbe_size) <= fbe_struct_size:
            fbe_value.symbol = self.symbol.get()
        else:
            fbe_value.symbol = ""
        fbe_current_size += self.symbol.fbe_size

        if (fbe_current_size + self.side.fbe_size) <= fbe_struct_size:
            fbe_value.side = self.side.get()
        else:
            fbe_value.side = OrderSide()
        fbe_current_size += self.side.fbe_size

        if (fbe_current_size + self.type.fbe_size) <= fbe_struct_size:
            fbe_value.type = self.type.get()
        else:
            fbe_value.type = OrderType()
        fbe_current_size += self.type.fbe_size

        if (fbe_current_size + self.price.fbe_size) <= fbe_struct_size:
            fbe_value.price = self.price.get(float(0.0))
        else:
            fbe_value.price = float(0.0)
        fbe_current_size += self.price.fbe_size

        if (fbe_current_size + self.volume.fbe_size) <= fbe_struct_size:
            fbe_value.volume = self.volume.get(float(0.0))
        else:
            fbe_value.volume = float(0.0)
        fbe_current_size += self.volume.fbe_size

    # Set the struct value (begin phase)
    def set_begin(self):
        assert (self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size, "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        fbe_struct_size = self.fbe_body
        fbe_struct_offset = self._buffer.allocate(fbe_struct_size) - self._buffer.offset
        assert (fbe_struct_offset > 0) and ((self._buffer.offset + fbe_struct_offset + fbe_struct_size) <= self._buffer.size), "Model is broken!"
        if (fbe_struct_offset <= 0) or ((self._buffer.offset + fbe_struct_offset + fbe_struct_size) > self._buffer.size):
            return 0

        self.write_uint32(self.fbe_offset, fbe_struct_offset)
        self.write_uint32(fbe_struct_offset, fbe_struct_size)
        self.write_uint32(fbe_struct_offset + 4, self.fbe_type)

        self._buffer.shift(fbe_struct_offset)
        return fbe_struct_offset

    # Set the struct value (end phase)
    def set_end(self, fbe_begin):
        self._buffer.unshift(fbe_begin)

    # Set the struct value
    def set(self, fbe_value):
        fbe_begin = self.set_begin()
        if fbe_begin == 0:
            return

        self.set_fields(fbe_value)
        self.set_end(fbe_begin)

    # Set the struct fields values
    def set_fields(self, fbe_value):
        self.id.set(fbe_value.id)
        self.symbol.set(fbe_value.symbol)
        self.side.set(fbe_value.side)
        self.type.set(fbe_value.type)
        self.price.set(fbe_value.price)
        self.volume.set(fbe_value.volume)


# Fast Binary Encoding Order model
class OrderModel(fbe.Model):
    __slots__ = "_model",

    def __init__(self, buffer=None):
        super().__init__(buffer)
        self._model = FieldModelOrder(self.buffer, 4)

    @property
    def model(self):
        return self._model

    # Get the model size
    @property
    def fbe_size(self):
        return self._model.fbe_size + self._model.fbe_extra

    # Get the model type
    @property
    def fbe_type(self):
        return self.TYPE

    TYPE = FieldModelOrder.TYPE

    # Check if the struct value is valid
    def verify(self):
        if (self.buffer.offset + self._model.fbe_offset - 4) > self.buffer.size:
            return False

        fbe_full_size = self.read_uint32(self._model.fbe_offset - 4)
        if fbe_full_size < self._model.fbe_size:
            return False

        return self._model.verify()

    # Create a new model (begin phase)
    def create_begin(self):
        fbe_begin = self.buffer.allocate(4 + self._model.fbe_size)
        return fbe_begin

    # Create a new model (end phase)
    def create_end(self, fbe_begin):
        fbe_end = self.buffer.size
        fbe_full_size = fbe_end - fbe_begin
        self.write_uint32(self._model.fbe_offset - 4, fbe_full_size)
        return fbe_full_size

    # Serialize the struct value
    def serialize(self, value):
        fbe_begin = self.create_begin()
        self._model.set(value)
        fbe_full_size = self.create_end(fbe_begin)
        return fbe_full_size

    # Deserialize the struct value
    def deserialize(self, value=None):
        if value is None:
            value = Order()

        if (self.buffer.offset + self._model.fbe_offset - 4) > self.buffer.size:
            value = Order()
            return value, 0

        fbe_full_size = self.read_uint32(self._model.fbe_offset - 4)
        assert (fbe_full_size >= self._model.fbe_size), "Model is broken!"
        if fbe_full_size < self._model.fbe_size:
            value = Order()
            return value, 0

        self._model.get(value)
        return value, fbe_full_size

    # Move to the next struct value
    def next(self, prev):
        self._model.fbe_shift(prev)


class FinalModelOrder(fbe.FinalModel):
    __slots__ = "_id", "_symbol", "_side", "_type", "_price", "_volume", 

    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)
        self._id = fbe.FinalModelInt32(buffer, 0)
        self._symbol = fbe.FinalModelString(buffer, 0)
        self._side = FinalModelOrderSide(buffer, 0)
        self._type = FinalModelOrderType(buffer, 0)
        self._price = fbe.FinalModelDouble(buffer, 0)
        self._volume = fbe.FinalModelDouble(buffer, 0)

    @property
    def id(self):
        return self._id

    @property
    def symbol(self):
        return self._symbol

    @property
    def side(self):
        return self._side

    @property
    def type(self):
        return self._type

    @property
    def price(self):
        return self._price

    @property
    def volume(self):
        return self._volume

    # Get the allocation size
    def fbe_allocation_size(self, fbe_value):
        fbe_result = 0 \
            + self.id.fbe_allocation_size(fbe_value.id) \
            + self.symbol.fbe_allocation_size(fbe_value.symbol) \
            + self.side.fbe_allocation_size(fbe_value.side) \
            + self.type.fbe_allocation_size(fbe_value.type) \
            + self.price.fbe_allocation_size(fbe_value.price) \
            + self.volume.fbe_allocation_size(fbe_value.volume) \

        return fbe_result

    # Get the final type
    @property
    def fbe_type(self):
        return self.TYPE

    TYPE = 1

    # Check if the struct value is valid
    def verify(self):
        self._buffer.shift(self.fbe_offset)
        fbe_result = self.verify_fields()
        self._buffer.unshift(self.fbe_offset)
        return fbe_result

    # Check if the struct fields are valid
    def verify_fields(self):
        fbe_current_offset = 0

        self.id.fbe_offset = fbe_current_offset
        fbe_field_size = self.id.verify()
        if fbe_field_size == sys.maxsize:
            return sys.maxsize
        fbe_current_offset += fbe_field_size

        self.symbol.fbe_offset = fbe_current_offset
        fbe_field_size = self.symbol.verify()
        if fbe_field_size == sys.maxsize:
            return sys.maxsize
        fbe_current_offset += fbe_field_size

        self.side.fbe_offset = fbe_current_offset
        fbe_field_size = self.side.verify()
        if fbe_field_size == sys.maxsize:
            return sys.maxsize
        fbe_current_offset += fbe_field_size

        self.type.fbe_offset = fbe_current_offset
        fbe_field_size = self.type.verify()
        if fbe_field_size == sys.maxsize:
            return sys.maxsize
        fbe_current_offset += fbe_field_size

        self.price.fbe_offset = fbe_current_offset
        fbe_field_size = self.price.verify()
        if fbe_field_size == sys.maxsize:
            return sys.maxsize
        fbe_current_offset += fbe_field_size

        self.volume.fbe_offset = fbe_current_offset
        fbe_field_size = self.volume.verify()
        if fbe_field_size == sys.maxsize:
            return sys.maxsize
        fbe_current_offset += fbe_field_size

        return fbe_current_offset

    # Get the struct value
    def get(self, fbe_value=None):
        if fbe_value is None:
            fbe_value = Order()

        self._buffer.shift(self.fbe_offset)
        fbe_size = self.get_fields(fbe_value)
        self._buffer.unshift(self.fbe_offset)
        return fbe_value, fbe_size

    # Get the struct fields values
    def get_fields(self, fbe_value):
        fbe_current_offset = 0
        fbe_current_size = 0

        self.id.fbe_offset = fbe_current_offset
        fbe_result = self.id.get()
        fbe_value.id = fbe_result[0]
        fbe_current_offset += fbe_result[1]
        fbe_current_size += fbe_result[1]

        self.symbol.fbe_offset = fbe_current_offset
        fbe_result = self.symbol.get()
        fbe_value.symbol = fbe_result[0]
        fbe_current_offset += fbe_result[1]
        fbe_current_size += fbe_result[1]

        self.side.fbe_offset = fbe_current_offset
        fbe_result = self.side.get()
        fbe_value.side = fbe_result[0]
        fbe_current_offset += fbe_result[1]
        fbe_current_size += fbe_result[1]

        self.type.fbe_offset = fbe_current_offset
        fbe_result = self.type.get()
        fbe_value.type = fbe_result[0]
        fbe_current_offset += fbe_result[1]
        fbe_current_size += fbe_result[1]

        self.price.fbe_offset = fbe_current_offset
        fbe_result = self.price.get()
        fbe_value.price = fbe_result[0]
        fbe_current_offset += fbe_result[1]
        fbe_current_size += fbe_result[1]

        self.volume.fbe_offset = fbe_current_offset
        fbe_result = self.volume.get()
        fbe_value.volume = fbe_result[0]
        fbe_current_offset += fbe_result[1]
        fbe_current_size += fbe_result[1]

        return fbe_current_size

    # Set the struct value
    def set(self, fbe_value):
        self._buffer.shift(self.fbe_offset)
        fbe_size = self.set_fields(fbe_value)
        self._buffer.unshift(self.fbe_offset)
        return fbe_size

    # Set the struct fields values
    def set_fields(self, fbe_value):
        fbe_current_offset = 0
        fbe_current_size = 0

        self.id.fbe_offset = fbe_current_offset
        fbe_field_size = self.id.set(fbe_value.id)
        fbe_current_offset += fbe_field_size
        fbe_current_size += fbe_field_size

        self.symbol.fbe_offset = fbe_current_offset
        fbe_field_size = self.symbol.set(fbe_value.symbol)
        fbe_current_offset += fbe_field_size
        fbe_current_size += fbe_field_size

        self.side.fbe_offset = fbe_current_offset
        fbe_field_size = self.side.set(fbe_value.side)
        fbe_current_offset += fbe_field_size
        fbe_current_size += fbe_field_size

        self.type.fbe_offset = fbe_current_offset
        fbe_field_size = self.type.set(fbe_value.type)
        fbe_current_offset += fbe_field_size
        fbe_current_size += fbe_field_size

        self.price.fbe_offset = fbe_current_offset
        fbe_field_size = self.price.set(fbe_value.price)
        fbe_current_offset += fbe_field_size
        fbe_current_size += fbe_field_size

        self.volume.fbe_offset = fbe_current_offset
        fbe_field_size = self.volume.set(fbe_value.volume)
        fbe_current_offset += fbe_field_size
        fbe_current_size += fbe_field_size

        return fbe_current_size


# Fast Binary Encoding Order final model
class OrderFinalModel(fbe.Model):
    __slots__ = "_model",

    def __init__(self, buffer=None):
        super().__init__(buffer)
        self._model = FinalModelOrder(self.buffer, 8)

    # Get the model type
    @property
    def fbe_type(self):
        return self.TYPE

    TYPE = FinalModelOrder.TYPE

    # Check if the struct value is valid
    def verify(self):
        if (self.buffer.offset + self._model.fbe_offset) > self.buffer.size:
            return False

        fbe_struct_size = self.read_uint32(self._model.fbe_offset - 8)
        fbe_struct_type = self.read_uint32(self._model.fbe_offset - 4)
        if (fbe_struct_size <= 0) or (fbe_struct_type != self.fbe_type):
            return False

        return (8 + self._model.verify()) == fbe_struct_size

    # Serialize the struct value
    def serialize(self, value):
        fbe_initial_size = self.buffer.size

        fbe_struct_type = self.fbe_type
        fbe_struct_size = 8 + self._model.fbe_allocation_size(value)
        fbe_struct_offset = self.buffer.allocate(fbe_struct_size) - self.buffer.offset
        assert ((self.buffer.offset + fbe_struct_offset + fbe_struct_size) <= self.buffer.size), "Model is broken!"
        if (self.buffer.offset + fbe_struct_offset + fbe_struct_size) > self.buffer.size:
            return 0

        fbe_struct_size = 8 + self._model.set(value)
        self.buffer.resize(fbe_initial_size + fbe_struct_size)

        self.write_uint32(self._model.fbe_offset - 8, fbe_struct_size)
        self.write_uint32(self._model.fbe_offset - 4, fbe_struct_type)

        return fbe_struct_size

    # Deserialize the struct value
    def deserialize(self, value=None):
        if value is None:
            value = Order()

        assert ((self.buffer.offset + self._model.fbe_offset) <= self.buffer.size), "Model is broken!"
        if (self.buffer.offset + self._model.fbe_offset) > self.buffer.size:
            return Order(), 0

        fbe_struct_size = self.read_uint32(self._model.fbe_offset - 8)
        fbe_struct_type = self.read_uint32(self._model.fbe_offset - 4)
        assert ((fbe_struct_size > 0) and (fbe_struct_type == self.fbe_type)), "Model is broken!"
        if (fbe_struct_size <= 0) or (fbe_struct_type != self.fbe_type):
            return Order(), 8

        fbe_result = self._model.get(value)
        return fbe_result[0], (8 + fbe_result[1])

    # Move to the next struct value
    def next(self, prev):
        self._model.fbe_shift(prev)


@functools.total_ordering
class Balance(object):
    __slots__ = "currency", "amount", 

    def __init__(self, currency="", amount=float(0.0)):
        self.currency = currency
        self.amount = amount

    # Struct shallow copy
    def copy(self, other):
        self.currency = other.currency
        self.amount = other.amount
        return self

    # Struct deep clone
    def clone(self):
        # Serialize the struct to the FBE stream
        writer = BalanceModel(fbe.WriteBuffer())
        writer.serialize(self)

        # Deserialize the struct from the FBE stream
        reader = BalanceModel(fbe.ReadBuffer())
        reader.attach_buffer(writer.buffer)
        return reader.deserialize()[0]

    def __eq__(self, other):
        if not isinstance(self, other.__class__):
            return NotImplemented
        if not self.currency == other.currency:
            return False
        return True

    def __lt__(self, other):
        if not isinstance(self, other.__class__):
            return NotImplemented
        if self.currency < other.currency:
            return True
        if self.currency == other.currency:
            return False
        return False

    @property
    def __key__(self):
        return self.currency, 

    def __hash__(self):
        return hash(self.__key__)

    def __format__(self, format_spec):
        return self.__str__()

    def __str__(self):
        sb = list()
        sb.append("Balance(")
        sb.append("currency=")
        if self.currency is not None:
            sb.append("\"" + str(self.currency) + "\"")
        else:
            sb.append("null")
        sb.append(",amount=")
        sb.append(str(self.amount))
        sb.append(")")
        return "".join(sb)

    # Get struct JSON value
    def to_json(self):
        return json.dumps(self.__to_json__(), cls=fbe.JSONEncoder, separators=(',', ':'))

    def __to_json__(self):
        result = dict()
        result.update(dict(
            currency=self.currency, 
            amount=self.amount, 
        ))
        return result

    # Create struct from JSON value
    @staticmethod
    def from_json(document):
        return Balance.__from_json__(json.loads(document))

    @staticmethod
    def __from_json__(fields):
        if fields is None:
            return None
        return Balance(
            None if "currency" not in fields else fields["currency"],
            None if "amount" not in fields else fields["amount"],
        )

    # Get the FBE type
    @property
    def fbe_type(self):
        return self.TYPE

    TYPE = 2


class FieldModelBalance(fbe.FieldModel):
    __slots__ = "_currency", "_amount", 

    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)
        self._currency = fbe.FieldModelString(buffer, 4 + 4)
        self._amount = fbe.FieldModelDouble(buffer, self._currency.fbe_offset + self._currency.fbe_size)

    @property
    def currency(self):
        return self._currency

    @property
    def amount(self):
        return self._amount

    # Get the field size
    @property
    def fbe_size(self):
        return 4

    # Get the field body size
    @property
    def fbe_body(self):
        fbe_result = 4 + 4 \
            + self.currency.fbe_size \
            + self.amount.fbe_size \

        return fbe_result

    # Get the field extra size
    @property
    def fbe_extra(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        fbe_struct_offset = self.read_uint32(self.fbe_offset)
        if (fbe_struct_offset == 0) or ((self._buffer.offset + fbe_struct_offset + 4) > self._buffer.size):
            return 0

        self._buffer.shift(fbe_struct_offset)

        fbe_result = self.fbe_body \
            + self.currency.fbe_extra \
            + self.amount.fbe_extra \

        self._buffer.unshift(fbe_struct_offset)

        return fbe_result

    # Get the field type
    @property
    def fbe_type(self):
        return self.TYPE

    TYPE = 2

    # Check if the struct value is valid
    def verify(self, fbe_verify_type=True):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return True

        fbe_struct_offset = self.read_uint32(self.fbe_offset)
        if (fbe_struct_offset == 0) or ((self._buffer.offset + fbe_struct_offset + 4 + 4) > self._buffer.size):
            return False

        fbe_struct_size = self.read_uint32(fbe_struct_offset)
        if fbe_struct_size < (4 + 4):
            return False

        fbe_struct_type = self.read_uint32(fbe_struct_offset + 4)
        if fbe_verify_type and (fbe_struct_type != self.fbe_type):
            return False

        self._buffer.shift(fbe_struct_offset)
        fbe_result = self.verify_fields(fbe_struct_size)
        self._buffer.unshift(fbe_struct_offset)
        return fbe_result

    # Check if the struct fields are valid
    def verify_fields(self, fbe_struct_size):
        fbe_current_size = 4 + 4

        if (fbe_current_size + self.currency.fbe_size) > fbe_struct_size:
            return True
        if not self.currency.verify():
            return False
        fbe_current_size += self.currency.fbe_size

        if (fbe_current_size + self.amount.fbe_size) > fbe_struct_size:
            return True
        if not self.amount.verify():
            return False
        fbe_current_size += self.amount.fbe_size

        return True

    # Get the struct value (begin phase)
    def get_begin(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        fbe_struct_offset = self.read_uint32(self.fbe_offset)
        assert (fbe_struct_offset > 0) and ((self._buffer.offset + fbe_struct_offset + 4 + 4) <= self._buffer.size), "Model is broken!"
        if (fbe_struct_offset == 0) or ((self._buffer.offset + fbe_struct_offset + 4 + 4) > self._buffer.size):
            return 0

        fbe_struct_size = self.read_uint32(fbe_struct_offset)
        assert (fbe_struct_size >= (4 + 4)), "Model is broken!"
        if fbe_struct_size < (4 + 4):
            return 0

        self._buffer.shift(fbe_struct_offset)
        return fbe_struct_offset

    # Get the struct value (end phase)
    def get_end(self, fbe_begin):
        self._buffer.unshift(fbe_begin)

    # Get the struct value
    def get(self, fbe_value=None):
        if fbe_value is None:
            fbe_value = Balance()

        fbe_begin = self.get_begin()
        if fbe_begin == 0:
            return fbe_value

        fbe_struct_size = self.read_uint32(0)
        self.get_fields(fbe_value, fbe_struct_size)
        self.get_end(fbe_begin)
        return fbe_value

    # Get the struct fields values
    def get_fields(self, fbe_value, fbe_struct_size):
        fbe_current_size = 4 + 4

        if (fbe_current_size + self.currency.fbe_size) <= fbe_struct_size:
            fbe_value.currency = self.currency.get()
        else:
            fbe_value.currency = ""
        fbe_current_size += self.currency.fbe_size

        if (fbe_current_size + self.amount.fbe_size) <= fbe_struct_size:
            fbe_value.amount = self.amount.get(float(0.0))
        else:
            fbe_value.amount = float(0.0)
        fbe_current_size += self.amount.fbe_size

    # Set the struct value (begin phase)
    def set_begin(self):
        assert (self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size, "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        fbe_struct_size = self.fbe_body
        fbe_struct_offset = self._buffer.allocate(fbe_struct_size) - self._buffer.offset
        assert (fbe_struct_offset > 0) and ((self._buffer.offset + fbe_struct_offset + fbe_struct_size) <= self._buffer.size), "Model is broken!"
        if (fbe_struct_offset <= 0) or ((self._buffer.offset + fbe_struct_offset + fbe_struct_size) > self._buffer.size):
            return 0

        self.write_uint32(self.fbe_offset, fbe_struct_offset)
        self.write_uint32(fbe_struct_offset, fbe_struct_size)
        self.write_uint32(fbe_struct_offset + 4, self.fbe_type)

        self._buffer.shift(fbe_struct_offset)
        return fbe_struct_offset

    # Set the struct value (end phase)
    def set_end(self, fbe_begin):
        self._buffer.unshift(fbe_begin)

    # Set the struct value
    def set(self, fbe_value):
        fbe_begin = self.set_begin()
        if fbe_begin == 0:
            return

        self.set_fields(fbe_value)
        self.set_end(fbe_begin)

    # Set the struct fields values
    def set_fields(self, fbe_value):
        self.currency.set(fbe_value.currency)
        self.amount.set(fbe_value.amount)


# Fast Binary Encoding Balance model
class BalanceModel(fbe.Model):
    __slots__ = "_model",

    def __init__(self, buffer=None):
        super().__init__(buffer)
        self._model = FieldModelBalance(self.buffer, 4)

    @property
    def model(self):
        return self._model

    # Get the model size
    @property
    def fbe_size(self):
        return self._model.fbe_size + self._model.fbe_extra

    # Get the model type
    @property
    def fbe_type(self):
        return self.TYPE

    TYPE = FieldModelBalance.TYPE

    # Check if the struct value is valid
    def verify(self):
        if (self.buffer.offset + self._model.fbe_offset - 4) > self.buffer.size:
            return False

        fbe_full_size = self.read_uint32(self._model.fbe_offset - 4)
        if fbe_full_size < self._model.fbe_size:
            return False

        return self._model.verify()

    # Create a new model (begin phase)
    def create_begin(self):
        fbe_begin = self.buffer.allocate(4 + self._model.fbe_size)
        return fbe_begin

    # Create a new model (end phase)
    def create_end(self, fbe_begin):
        fbe_end = self.buffer.size
        fbe_full_size = fbe_end - fbe_begin
        self.write_uint32(self._model.fbe_offset - 4, fbe_full_size)
        return fbe_full_size

    # Serialize the struct value
    def serialize(self, value):
        fbe_begin = self.create_begin()
        self._model.set(value)
        fbe_full_size = self.create_end(fbe_begin)
        return fbe_full_size

    # Deserialize the struct value
    def deserialize(self, value=None):
        if value is None:
            value = Balance()

        if (self.buffer.offset + self._model.fbe_offset - 4) > self.buffer.size:
            value = Balance()
            return value, 0

        fbe_full_size = self.read_uint32(self._model.fbe_offset - 4)
        assert (fbe_full_size >= self._model.fbe_size), "Model is broken!"
        if fbe_full_size < self._model.fbe_size:
            value = Balance()
            return value, 0

        self._model.get(value)
        return value, fbe_full_size

    # Move to the next struct value
    def next(self, prev):
        self._model.fbe_shift(prev)


class FinalModelBalance(fbe.FinalModel):
    __slots__ = "_currency", "_amount", 

    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)
        self._currency = fbe.FinalModelString(buffer, 0)
        self._amount = fbe.FinalModelDouble(buffer, 0)

    @property
    def currency(self):
        return self._currency

    @property
    def amount(self):
        return self._amount

    # Get the allocation size
    def fbe_allocation_size(self, fbe_value):
        fbe_result = 0 \
            + self.currency.fbe_allocation_size(fbe_value.currency) \
            + self.amount.fbe_allocation_size(fbe_value.amount) \

        return fbe_result

    # Get the final type
    @property
    def fbe_type(self):
        return self.TYPE

    TYPE = 2

    # Check if the struct value is valid
    def verify(self):
        self._buffer.shift(self.fbe_offset)
        fbe_result = self.verify_fields()
        self._buffer.unshift(self.fbe_offset)
        return fbe_result

    # Check if the struct fields are valid
    def verify_fields(self):
        fbe_current_offset = 0

        self.currency.fbe_offset = fbe_current_offset
        fbe_field_size = self.currency.verify()
        if fbe_field_size == sys.maxsize:
            return sys.maxsize
        fbe_current_offset += fbe_field_size

        self.amount.fbe_offset = fbe_current_offset
        fbe_field_size = self.amount.verify()
        if fbe_field_size == sys.maxsize:
            return sys.maxsize
        fbe_current_offset += fbe_field_size

        return fbe_current_offset

    # Get the struct value
    def get(self, fbe_value=None):
        if fbe_value is None:
            fbe_value = Balance()

        self._buffer.shift(self.fbe_offset)
        fbe_size = self.get_fields(fbe_value)
        self._buffer.unshift(self.fbe_offset)
        return fbe_value, fbe_size

    # Get the struct fields values
    def get_fields(self, fbe_value):
        fbe_current_offset = 0
        fbe_current_size = 0

        self.currency.fbe_offset = fbe_current_offset
        fbe_result = self.currency.get()
        fbe_value.currency = fbe_result[0]
        fbe_current_offset += fbe_result[1]
        fbe_current_size += fbe_result[1]

        self.amount.fbe_offset = fbe_current_offset
        fbe_result = self.amount.get()
        fbe_value.amount = fbe_result[0]
        fbe_current_offset += fbe_result[1]
        fbe_current_size += fbe_result[1]

        return fbe_current_size

    # Set the struct value
    def set(self, fbe_value):
        self._buffer.shift(self.fbe_offset)
        fbe_size = self.set_fields(fbe_value)
        self._buffer.unshift(self.fbe_offset)
        return fbe_size

    # Set the struct fields values
    def set_fields(self, fbe_value):
        fbe_current_offset = 0
        fbe_current_size = 0

        self.currency.fbe_offset = fbe_current_offset
        fbe_field_size = self.currency.set(fbe_value.currency)
        fbe_current_offset += fbe_field_size
        fbe_current_size += fbe_field_size

        self.amount.fbe_offset = fbe_current_offset
        fbe_field_size = self.amount.set(fbe_value.amount)
        fbe_current_offset += fbe_field_size
        fbe_current_size += fbe_field_size

        return fbe_current_size


# Fast Binary Encoding Balance final model
class BalanceFinalModel(fbe.Model):
    __slots__ = "_model",

    def __init__(self, buffer=None):
        super().__init__(buffer)
        self._model = FinalModelBalance(self.buffer, 8)

    # Get the model type
    @property
    def fbe_type(self):
        return self.TYPE

    TYPE = FinalModelBalance.TYPE

    # Check if the struct value is valid
    def verify(self):
        if (self.buffer.offset + self._model.fbe_offset) > self.buffer.size:
            return False

        fbe_struct_size = self.read_uint32(self._model.fbe_offset - 8)
        fbe_struct_type = self.read_uint32(self._model.fbe_offset - 4)
        if (fbe_struct_size <= 0) or (fbe_struct_type != self.fbe_type):
            return False

        return (8 + self._model.verify()) == fbe_struct_size

    # Serialize the struct value
    def serialize(self, value):
        fbe_initial_size = self.buffer.size

        fbe_struct_type = self.fbe_type
        fbe_struct_size = 8 + self._model.fbe_allocation_size(value)
        fbe_struct_offset = self.buffer.allocate(fbe_struct_size) - self.buffer.offset
        assert ((self.buffer.offset + fbe_struct_offset + fbe_struct_size) <= self.buffer.size), "Model is broken!"
        if (self.buffer.offset + fbe_struct_offset + fbe_struct_size) > self.buffer.size:
            return 0

        fbe_struct_size = 8 + self._model.set(value)
        self.buffer.resize(fbe_initial_size + fbe_struct_size)

        self.write_uint32(self._model.fbe_offset - 8, fbe_struct_size)
        self.write_uint32(self._model.fbe_offset - 4, fbe_struct_type)

        return fbe_struct_size

    # Deserialize the struct value
    def deserialize(self, value=None):
        if value is None:
            value = Balance()

        assert ((self.buffer.offset + self._model.fbe_offset) <= self.buffer.size), "Model is broken!"
        if (self.buffer.offset + self._model.fbe_offset) > self.buffer.size:
            return Balance(), 0

        fbe_struct_size = self.read_uint32(self._model.fbe_offset - 8)
        fbe_struct_type = self.read_uint32(self._model.fbe_offset - 4)
        assert ((fbe_struct_size > 0) and (fbe_struct_type == self.fbe_type)), "Model is broken!"
        if (fbe_struct_size <= 0) or (fbe_struct_type != self.fbe_type):
            return Balance(), 8

        fbe_result = self._model.get(value)
        return fbe_result[0], (8 + fbe_result[1])

    # Move to the next struct value
    def next(self, prev):
        self._model.fbe_shift(prev)


@functools.total_ordering
class Account(object):
    __slots__ = "id", "name", "state", "wallet", "asset", "orders", 

    def __init__(self, id=0, name="", state=State.initialized | State.bad, wallet=None, asset=None, orders=None):
        if wallet is None:
            wallet = Balance()
        if orders is None:
            orders = list()
        self.id = id
        self.name = name
        self.state = state
        self.wallet = wallet
        self.asset = asset
        self.orders = orders

    # Struct shallow copy
    def copy(self, other):
        self.id = other.id
        self.name = other.name
        self.state = other.state
        self.wallet = other.wallet
        self.asset = other.asset
        self.orders = other.orders
        return self

    # Struct deep clone
    def clone(self):
        # Serialize the struct to the FBE stream
        writer = AccountModel(fbe.WriteBuffer())
        writer.serialize(self)

        # Deserialize the struct from the FBE stream
        reader = AccountModel(fbe.ReadBuffer())
        reader.attach_buffer(writer.buffer)
        return reader.deserialize()[0]

    def __eq__(self, other):
        if not isinstance(self, other.__class__):
            return NotImplemented
        if not self.id == other.id:
            return False
        return True

    def __lt__(self, other):
        if not isinstance(self, other.__class__):
            return NotImplemented
        if self.id < other.id:
            return True
        if self.id == other.id:
            return False
        return False

    @property
    def __key__(self):
        return self.id, 

    def __hash__(self):
        return hash(self.__key__)

    def __format__(self, format_spec):
        return self.__str__()

    def __str__(self):
        sb = list()
        sb.append("Account(")
        sb.append("id=")
        sb.append(str(self.id))
        sb.append(",name=")
        if self.name is not None:
            sb.append("\"" + str(self.name) + "\"")
        else:
            sb.append("null")
        sb.append(",state=")
        sb.append(str(self.state))
        sb.append(",wallet=")
        sb.append(str(self.wallet))
        sb.append(",asset=")
        if self.asset is not None:
            sb.append(str(self.asset))
        else:
            sb.append("null")
        sb.append(",orders=")
        if self.orders is not None:
            first = True
            sb.append("[" + str(len(self.orders)) + "][")
            for item in self.orders:
                sb.append("" if first else ",")
                sb.append(str(item))
                first = False
            sb.append("]")
        else:
            sb.append("[0][]")
        sb.append(")")
        return "".join(sb)

    # Get struct JSON value
    def to_json(self):
        return json.dumps(self.__to_json__(), cls=fbe.JSONEncoder, separators=(',', ':'))

    def __to_json__(self):
        result = dict()
        result.update(dict(
            id=self.id, 
            name=self.name, 
            state=self.state, 
            wallet=self.wallet, 
            asset=self.asset, 
            orders=self.orders, 
        ))
        return result

    # Create struct from JSON value
    @staticmethod
    def from_json(document):
        return Account.__from_json__(json.loads(document))

    @staticmethod
    def __from_json__(fields):
        if fields is None:
            return None
        return Account(
            None if "id" not in fields else fields["id"],
            None if "name" not in fields else fields["name"],
            None if "state" not in fields else State.__from_json__(fields["state"]),
            None if "wallet" not in fields else Balance.__from_json__(fields["wallet"]),
            None if "asset" not in fields else Balance.__from_json__(fields["asset"]),
            None if "orders" not in fields else [Order.__from_json__(value) for value in fields["orders"]],
        )

    # Get the FBE type
    @property
    def fbe_type(self):
        return self.TYPE

    TYPE = 3


class FieldModelAccount(fbe.FieldModel):
    __slots__ = "_id", "_name", "_state", "_wallet", "_asset", "_orders", 

    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)
        self._id = fbe.FieldModelInt32(buffer, 4 + 4)
        self._name = fbe.FieldModelString(buffer, self._id.fbe_offset + self._id.fbe_size)
        self._state = FieldModelState(buffer, self._name.fbe_offset + self._name.fbe_size)
        self._wallet = FieldModelBalance(buffer, self._state.fbe_offset + self._state.fbe_size)
        self._asset = fbe.FieldModelOptional(FieldModelBalance(buffer, self._wallet.fbe_offset + self._wallet.fbe_size), buffer, self._wallet.fbe_offset + self._wallet.fbe_size)
        self._orders = fbe.FieldModelVector(FieldModelOrder(buffer, self._asset.fbe_offset + self._asset.fbe_size), buffer, self._asset.fbe_offset + self._asset.fbe_size)

    @property
    def id(self):
        return self._id

    @property
    def name(self):
        return self._name

    @property
    def state(self):
        return self._state

    @property
    def wallet(self):
        return self._wallet

    @property
    def asset(self):
        return self._asset

    @property
    def orders(self):
        return self._orders

    # Get the field size
    @property
    def fbe_size(self):
        return 4

    # Get the field body size
    @property
    def fbe_body(self):
        fbe_result = 4 + 4 \
            + self.id.fbe_size \
            + self.name.fbe_size \
            + self.state.fbe_size \
            + self.wallet.fbe_size \
            + self.asset.fbe_size \
            + self.orders.fbe_size \

        return fbe_result

    # Get the field extra size
    @property
    def fbe_extra(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        fbe_struct_offset = self.read_uint32(self.fbe_offset)
        if (fbe_struct_offset == 0) or ((self._buffer.offset + fbe_struct_offset + 4) > self._buffer.size):
            return 0

        self._buffer.shift(fbe_struct_offset)

        fbe_result = self.fbe_body \
            + self.id.fbe_extra \
            + self.name.fbe_extra \
            + self.state.fbe_extra \
            + self.wallet.fbe_extra \
            + self.asset.fbe_extra \
            + self.orders.fbe_extra \

        self._buffer.unshift(fbe_struct_offset)

        return fbe_result

    # Get the field type
    @property
    def fbe_type(self):
        return self.TYPE

    TYPE = 3

    # Check if the struct value is valid
    def verify(self, fbe_verify_type=True):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return True

        fbe_struct_offset = self.read_uint32(self.fbe_offset)
        if (fbe_struct_offset == 0) or ((self._buffer.offset + fbe_struct_offset + 4 + 4) > self._buffer.size):
            return False

        fbe_struct_size = self.read_uint32(fbe_struct_offset)
        if fbe_struct_size < (4 + 4):
            return False

        fbe_struct_type = self.read_uint32(fbe_struct_offset + 4)
        if fbe_verify_type and (fbe_struct_type != self.fbe_type):
            return False

        self._buffer.shift(fbe_struct_offset)
        fbe_result = self.verify_fields(fbe_struct_size)
        self._buffer.unshift(fbe_struct_offset)
        return fbe_result

    # Check if the struct fields are valid
    def verify_fields(self, fbe_struct_size):
        fbe_current_size = 4 + 4

        if (fbe_current_size + self.id.fbe_size) > fbe_struct_size:
            return True
        if not self.id.verify():
            return False
        fbe_current_size += self.id.fbe_size

        if (fbe_current_size + self.name.fbe_size) > fbe_struct_size:
            return True
        if not self.name.verify():
            return False
        fbe_current_size += self.name.fbe_size

        if (fbe_current_size + self.state.fbe_size) > fbe_struct_size:
            return True
        if not self.state.verify():
            return False
        fbe_current_size += self.state.fbe_size

        if (fbe_current_size + self.wallet.fbe_size) > fbe_struct_size:
            return True
        if not self.wallet.verify():
            return False
        fbe_current_size += self.wallet.fbe_size

        if (fbe_current_size + self.asset.fbe_size) > fbe_struct_size:
            return True
        if not self.asset.verify():
            return False
        fbe_current_size += self.asset.fbe_size

        if (fbe_current_size + self.orders.fbe_size) > fbe_struct_size:
            return True
        if not self.orders.verify():
            return False
        fbe_current_size += self.orders.fbe_size

        return True

    # Get the struct value (begin phase)
    def get_begin(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        fbe_struct_offset = self.read_uint32(self.fbe_offset)
        assert (fbe_struct_offset > 0) and ((self._buffer.offset + fbe_struct_offset + 4 + 4) <= self._buffer.size), "Model is broken!"
        if (fbe_struct_offset == 0) or ((self._buffer.offset + fbe_struct_offset + 4 + 4) > self._buffer.size):
            return 0

        fbe_struct_size = self.read_uint32(fbe_struct_offset)
        assert (fbe_struct_size >= (4 + 4)), "Model is broken!"
        if fbe_struct_size < (4 + 4):
            return 0

        self._buffer.shift(fbe_struct_offset)
        return fbe_struct_offset

    # Get the struct value (end phase)
    def get_end(self, fbe_begin):
        self._buffer.unshift(fbe_begin)

    # Get the struct value
    def get(self, fbe_value=None):
        if fbe_value is None:
            fbe_value = Account()

        fbe_begin = self.get_begin()
        if fbe_begin == 0:
            return fbe_value

        fbe_struct_size = self.read_uint32(0)
        self.get_fields(fbe_value, fbe_struct_size)
        self.get_end(fbe_begin)
        return fbe_value

    # Get the struct fields values
    def get_fields(self, fbe_value, fbe_struct_size):
        fbe_current_size = 4 + 4

        if (fbe_current_size + self.id.fbe_size) <= fbe_struct_size:
            fbe_value.id = self.id.get()
        else:
            fbe_value.id = 0
        fbe_current_size += self.id.fbe_size

        if (fbe_current_size + self.name.fbe_size) <= fbe_struct_size:
            fbe_value.name = self.name.get()
        else:
            fbe_value.name = ""
        fbe_current_size += self.name.fbe_size

        if (fbe_current_size + self.state.fbe_size) <= fbe_struct_size:
            fbe_value.state = self.state.get(State.initialized | State.bad)
        else:
            fbe_value.state = State.initialized | State.bad
        fbe_current_size += self.state.fbe_size

        if (fbe_current_size + self.wallet.fbe_size) <= fbe_struct_size:
            fbe_value.wallet = self.wallet.get()
        else:
            fbe_value.wallet = Balance()
        fbe_current_size += self.wallet.fbe_size

        if (fbe_current_size + self.asset.fbe_size) <= fbe_struct_size:
            fbe_value.asset = self.asset.get()
        else:
            fbe_value.asset = None
        fbe_current_size += self.asset.fbe_size

        if (fbe_current_size + self.orders.fbe_size) <= fbe_struct_size:
            self.orders.get(fbe_value.orders)
        else:
            fbe_value.orders.clear()
        fbe_current_size += self.orders.fbe_size

    # Set the struct value (begin phase)
    def set_begin(self):
        assert (self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size, "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        fbe_struct_size = self.fbe_body
        fbe_struct_offset = self._buffer.allocate(fbe_struct_size) - self._buffer.offset
        assert (fbe_struct_offset > 0) and ((self._buffer.offset + fbe_struct_offset + fbe_struct_size) <= self._buffer.size), "Model is broken!"
        if (fbe_struct_offset <= 0) or ((self._buffer.offset + fbe_struct_offset + fbe_struct_size) > self._buffer.size):
            return 0

        self.write_uint32(self.fbe_offset, fbe_struct_offset)
        self.write_uint32(fbe_struct_offset, fbe_struct_size)
        self.write_uint32(fbe_struct_offset + 4, self.fbe_type)

        self._buffer.shift(fbe_struct_offset)
        return fbe_struct_offset

    # Set the struct value (end phase)
    def set_end(self, fbe_begin):
        self._buffer.unshift(fbe_begin)

    # Set the struct value
    def set(self, fbe_value):
        fbe_begin = self.set_begin()
        if fbe_begin == 0:
            return

        self.set_fields(fbe_value)
        self.set_end(fbe_begin)

    # Set the struct fields values
    def set_fields(self, fbe_value):
        self.id.set(fbe_value.id)
        self.name.set(fbe_value.name)
        self.state.set(fbe_value.state)
        self.wallet.set(fbe_value.wallet)
        self.asset.set(fbe_value.asset)
        self.orders.set(fbe_value.orders)


# Fast Binary Encoding Account model
class AccountModel(fbe.Model):
    __slots__ = "_model",

    def __init__(self, buffer=None):
        super().__init__(buffer)
        self._model = FieldModelAccount(self.buffer, 4)

    @property
    def model(self):
        return self._model

    # Get the model size
    @property
    def fbe_size(self):
        return self._model.fbe_size + self._model.fbe_extra

    # Get the model type
    @property
    def fbe_type(self):
        return self.TYPE

    TYPE = FieldModelAccount.TYPE

    # Check if the struct value is valid
    def verify(self):
        if (self.buffer.offset + self._model.fbe_offset - 4) > self.buffer.size:
            return False

        fbe_full_size = self.read_uint32(self._model.fbe_offset - 4)
        if fbe_full_size < self._model.fbe_size:
            return False

        return self._model.verify()

    # Create a new model (begin phase)
    def create_begin(self):
        fbe_begin = self.buffer.allocate(4 + self._model.fbe_size)
        return fbe_begin

    # Create a new model (end phase)
    def create_end(self, fbe_begin):
        fbe_end = self.buffer.size
        fbe_full_size = fbe_end - fbe_begin
        self.write_uint32(self._model.fbe_offset - 4, fbe_full_size)
        return fbe_full_size

    # Serialize the struct value
    def serialize(self, value):
        fbe_begin = self.create_begin()
        self._model.set(value)
        fbe_full_size = self.create_end(fbe_begin)
        return fbe_full_size

    # Deserialize the struct value
    def deserialize(self, value=None):
        if value is None:
            value = Account()

        if (self.buffer.offset + self._model.fbe_offset - 4) > self.buffer.size:
            value = Account()
            return value, 0

        fbe_full_size = self.read_uint32(self._model.fbe_offset - 4)
        assert (fbe_full_size >= self._model.fbe_size), "Model is broken!"
        if fbe_full_size < self._model.fbe_size:
            value = Account()
            return value, 0

        self._model.get(value)
        return value, fbe_full_size

    # Move to the next struct value
    def next(self, prev):
        self._model.fbe_shift(prev)


class FinalModelAccount(fbe.FinalModel):
    __slots__ = "_id", "_name", "_state", "_wallet", "_asset", "_orders", 

    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)
        self._id = fbe.FinalModelInt32(buffer, 0)
        self._name = fbe.FinalModelString(buffer, 0)
        self._state = FinalModelState(buffer, 0)
        self._wallet = FinalModelBalance(buffer, 0)
        self._asset = fbe.FinalModelOptional(FinalModelBalance(buffer, 0), buffer, 0)
        self._orders = fbe.FinalModelVector(FinalModelOrder(buffer, 0), buffer, 0)

    @property
    def id(self):
        return self._id

    @property
    def name(self):
        return self._name

    @property
    def state(self):
        return self._state

    @property
    def wallet(self):
        return self._wallet

    @property
    def asset(self):
        return self._asset

    @property
    def orders(self):
        return self._orders

    # Get the allocation size
    def fbe_allocation_size(self, fbe_value):
        fbe_result = 0 \
            + self.id.fbe_allocation_size(fbe_value.id) \
            + self.name.fbe_allocation_size(fbe_value.name) \
            + self.state.fbe_allocation_size(fbe_value.state) \
            + self.wallet.fbe_allocation_size(fbe_value.wallet) \
            + self.asset.fbe_allocation_size(fbe_value.asset) \
            + self.orders.fbe_allocation_size(fbe_value.orders) \

        return fbe_result

    # Get the final type
    @property
    def fbe_type(self):
        return self.TYPE

    TYPE = 3

    # Check if the struct value is valid
    def verify(self):
        self._buffer.shift(self.fbe_offset)
        fbe_result = self.verify_fields()
        self._buffer.unshift(self.fbe_offset)
        return fbe_result

    # Check if the struct fields are valid
    def verify_fields(self):
        fbe_current_offset = 0

        self.id.fbe_offset = fbe_current_offset
        fbe_field_size = self.id.verify()
        if fbe_field_size == sys.maxsize:
            return sys.maxsize
        fbe_current_offset += fbe_field_size

        self.name.fbe_offset = fbe_current_offset
        fbe_field_size = self.name.verify()
        if fbe_field_size == sys.maxsize:
            return sys.maxsize
        fbe_current_offset += fbe_field_size

        self.state.fbe_offset = fbe_current_offset
        fbe_field_size = self.state.verify()
        if fbe_field_size == sys.maxsize:
            return sys.maxsize
        fbe_current_offset += fbe_field_size

        self.wallet.fbe_offset = fbe_current_offset
        fbe_field_size = self.wallet.verify()
        if fbe_field_size == sys.maxsize:
            return sys.maxsize
        fbe_current_offset += fbe_field_size

        self.asset.fbe_offset = fbe_current_offset
        fbe_field_size = self.asset.verify()
        if fbe_field_size == sys.maxsize:
            return sys.maxsize
        fbe_current_offset += fbe_field_size

        self.orders.fbe_offset = fbe_current_offset
        fbe_field_size = self.orders.verify()
        if fbe_field_size == sys.maxsize:
            return sys.maxsize
        fbe_current_offset += fbe_field_size

        return fbe_current_offset

    # Get the struct value
    def get(self, fbe_value=None):
        if fbe_value is None:
            fbe_value = Account()

        self._buffer.shift(self.fbe_offset)
        fbe_size = self.get_fields(fbe_value)
        self._buffer.unshift(self.fbe_offset)
        return fbe_value, fbe_size

    # Get the struct fields values
    def get_fields(self, fbe_value):
        fbe_current_offset = 0
        fbe_current_size = 0

        self.id.fbe_offset = fbe_current_offset
        fbe_result = self.id.get()
        fbe_value.id = fbe_result[0]
        fbe_current_offset += fbe_result[1]
        fbe_current_size += fbe_result[1]

        self.name.fbe_offset = fbe_current_offset
        fbe_result = self.name.get()
        fbe_value.name = fbe_result[0]
        fbe_current_offset += fbe_result[1]
        fbe_current_size += fbe_result[1]

        self.state.fbe_offset = fbe_current_offset
        fbe_result = self.state.get()
        fbe_value.state = fbe_result[0]
        fbe_current_offset += fbe_result[1]
        fbe_current_size += fbe_result[1]

        self.wallet.fbe_offset = fbe_current_offset
        fbe_result = self.wallet.get()
        fbe_value.wallet = fbe_result[0]
        fbe_current_offset += fbe_result[1]
        fbe_current_size += fbe_result[1]

        self.asset.fbe_offset = fbe_current_offset
        fbe_result = self.asset.get()
        fbe_value.asset = fbe_result[0]
        fbe_current_offset += fbe_result[1]
        fbe_current_size += fbe_result[1]

        self.orders.fbe_offset = fbe_current_offset
        fbe_result = self.orders.get(fbe_value.orders)
        fbe_current_offset += fbe_result[1]
        fbe_current_size += fbe_result[1]

        return fbe_current_size

    # Set the struct value
    def set(self, fbe_value):
        self._buffer.shift(self.fbe_offset)
        fbe_size = self.set_fields(fbe_value)
        self._buffer.unshift(self.fbe_offset)
        return fbe_size

    # Set the struct fields values
    def set_fields(self, fbe_value):
        fbe_current_offset = 0
        fbe_current_size = 0

        self.id.fbe_offset = fbe_current_offset
        fbe_field_size = self.id.set(fbe_value.id)
        fbe_current_offset += fbe_field_size
        fbe_current_size += fbe_field_size

        self.name.fbe_offset = fbe_current_offset
        fbe_field_size = self.name.set(fbe_value.name)
        fbe_current_offset += fbe_field_size
        fbe_current_size += fbe_field_size

        self.state.fbe_offset = fbe_current_offset
        fbe_field_size = self.state.set(fbe_value.state)
        fbe_current_offset += fbe_field_size
        fbe_current_size += fbe_field_size

        self.wallet.fbe_offset = fbe_current_offset
        fbe_field_size = self.wallet.set(fbe_value.wallet)
        fbe_current_offset += fbe_field_size
        fbe_current_size += fbe_field_size

        self.asset.fbe_offset = fbe_current_offset
        fbe_field_size = self.asset.set(fbe_value.asset)
        fbe_current_offset += fbe_field_size
        fbe_current_size += fbe_field_size

        self.orders.fbe_offset = fbe_current_offset
        fbe_field_size = self.orders.set(fbe_value.orders)
        fbe_current_offset += fbe_field_size
        fbe_current_size += fbe_field_size

        return fbe_current_size


# Fast Binary Encoding Account final model
class AccountFinalModel(fbe.Model):
    __slots__ = "_model",

    def __init__(self, buffer=None):
        super().__init__(buffer)
        self._model = FinalModelAccount(self.buffer, 8)

    # Get the model type
    @property
    def fbe_type(self):
        return self.TYPE

    TYPE = FinalModelAccount.TYPE

    # Check if the struct value is valid
    def verify(self):
        if (self.buffer.offset + self._model.fbe_offset) > self.buffer.size:
            return False

        fbe_struct_size = self.read_uint32(self._model.fbe_offset - 8)
        fbe_struct_type = self.read_uint32(self._model.fbe_offset - 4)
        if (fbe_struct_size <= 0) or (fbe_struct_type != self.fbe_type):
            return False

        return (8 + self._model.verify()) == fbe_struct_size

    # Serialize the struct value
    def serialize(self, value):
        fbe_initial_size = self.buffer.size

        fbe_struct_type = self.fbe_type
        fbe_struct_size = 8 + self._model.fbe_allocation_size(value)
        fbe_struct_offset = self.buffer.allocate(fbe_struct_size) - self.buffer.offset
        assert ((self.buffer.offset + fbe_struct_offset + fbe_struct_size) <= self.buffer.size), "Model is broken!"
        if (self.buffer.offset + fbe_struct_offset + fbe_struct_size) > self.buffer.size:
            return 0

        fbe_struct_size = 8 + self._model.set(value)
        self.buffer.resize(fbe_initial_size + fbe_struct_size)

        self.write_uint32(self._model.fbe_offset - 8, fbe_struct_size)
        self.write_uint32(self._model.fbe_offset - 4, fbe_struct_type)

        return fbe_struct_size

    # Deserialize the struct value
    def deserialize(self, value=None):
        if value is None:
            value = Account()

        assert ((self.buffer.offset + self._model.fbe_offset) <= self.buffer.size), "Model is broken!"
        if (self.buffer.offset + self._model.fbe_offset) > self.buffer.size:
            return Account(), 0

        fbe_struct_size = self.read_uint32(self._model.fbe_offset - 8)
        fbe_struct_type = self.read_uint32(self._model.fbe_offset - 4)
        assert ((fbe_struct_size > 0) and (fbe_struct_type == self.fbe_type)), "Model is broken!"
        if (fbe_struct_size <= 0) or (fbe_struct_type != self.fbe_type):
            return Account(), 8

        fbe_result = self._model.get(value)
        return fbe_result[0], (8 + fbe_result[1])

    # Move to the next struct value
    def next(self, prev):
        self._model.fbe_shift(prev)


@functools.total_ordering
class OrderMessage(object):
    __slots__ = "body", 

    def __init__(self, body=None):
        if body is None:
            body = Order()
        self.body = body

    # Struct shallow copy
    def copy(self, other):
        self.body = other.body
        return self

    # Struct deep clone
    def clone(self):
        # Serialize the struct to the FBE stream
        writer = OrderMessageModel(fbe.WriteBuffer())
        writer.serialize(self)

        # Deserialize the struct from the FBE stream
        reader = OrderMessageModel(fbe.ReadBuffer())
        reader.attach_buffer(writer.buffer)
        return reader.deserialize()[0]

    def __eq__(self, other):
        if not isinstance(self, other.__class__):
            return NotImplemented
        return True

    def __lt__(self, other):
        if not isinstance(self, other.__class__):
            return NotImplemented
        return False

    @property
    def __key__(self):
        return ()

    def __hash__(self):
        return hash(self.__key__)

    def __format__(self, format_spec):
        return self.__str__()

    def __str__(self):
        sb = list()
        sb.append("OrderMessage(")
        sb.append("body=")
        sb.append(str(self.body))
        sb.append(")")
        return "".join(sb)

    # Get struct JSON value
    def to_json(self):
        return json.dumps(self.__to_json__(), cls=fbe.JSONEncoder, separators=(',', ':'))

    def __to_json__(self):
        result = dict()
        result.update(dict(
            body=self.body, 
        ))
        return result

    # Create struct from JSON value
    @staticmethod
    def from_json(document):
        return OrderMessage.__from_json__(json.loads(document))

    @staticmethod
    def __from_json__(fields):
        if fields is None:
            return None
        return OrderMessage(
            None if "body" not in fields else Order.__from_json__(fields["body"]),
        )

    # Get the FBE type
    @property
    def fbe_type(self):
        return self.TYPE

    TYPE = 1


class FieldModelOrderMessage(fbe.FieldModel):
    __slots__ = "_body", 

    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)
        self._body = FieldModelOrder(buffer, 4 + 4)

    @property
    def body(self):
        return self._body

    # Get the field size
    @property
    def fbe_size(self):
        return 4

    # Get the field body size
    @property
    def fbe_body(self):
        fbe_result = 4 + 4 \
            + self.body.fbe_size \

        return fbe_result

    # Get the field extra size
    @property
    def fbe_extra(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        fbe_struct_offset = self.read_uint32(self.fbe_offset)
        if (fbe_struct_offset == 0) or ((self._buffer.offset + fbe_struct_offset + 4) > self._buffer.size):
            return 0

        self._buffer.shift(fbe_struct_offset)

        fbe_result = self.fbe_body \
            + self.body.fbe_extra \

        self._buffer.unshift(fbe_struct_offset)

        return fbe_result

    # Get the field type
    @property
    def fbe_type(self):
        return self.TYPE

    TYPE = 1

    # Check if the struct value is valid
    def verify(self, fbe_verify_type=True):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return True

        fbe_struct_offset = self.read_uint32(self.fbe_offset)
        if (fbe_struct_offset == 0) or ((self._buffer.offset + fbe_struct_offset + 4 + 4) > self._buffer.size):
            return False

        fbe_struct_size = self.read_uint32(fbe_struct_offset)
        if fbe_struct_size < (4 + 4):
            return False

        fbe_struct_type = self.read_uint32(fbe_struct_offset + 4)
        if fbe_verify_type and (fbe_struct_type != self.fbe_type):
            return False

        self._buffer.shift(fbe_struct_offset)
        fbe_result = self.verify_fields(fbe_struct_size)
        self._buffer.unshift(fbe_struct_offset)
        return fbe_result

    # Check if the struct fields are valid
    def verify_fields(self, fbe_struct_size):
        fbe_current_size = 4 + 4

        if (fbe_current_size + self.body.fbe_size) > fbe_struct_size:
            return True
        if not self.body.verify():
            return False
        fbe_current_size += self.body.fbe_size

        return True

    # Get the struct value (begin phase)
    def get_begin(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        fbe_struct_offset = self.read_uint32(self.fbe_offset)
        assert (fbe_struct_offset > 0) and ((self._buffer.offset + fbe_struct_offset + 4 + 4) <= self._buffer.size), "Model is broken!"
        if (fbe_struct_offset == 0) or ((self._buffer.offset + fbe_struct_offset + 4 + 4) > self._buffer.size):
            return 0

        fbe_struct_size = self.read_uint32(fbe_struct_offset)
        assert (fbe_struct_size >= (4 + 4)), "Model is broken!"
        if fbe_struct_size < (4 + 4):
            return 0

        self._buffer.shift(fbe_struct_offset)
        return fbe_struct_offset

    # Get the struct value (end phase)
    def get_end(self, fbe_begin):
        self._buffer.unshift(fbe_begin)

    # Get the struct value
    def get(self, fbe_value=None):
        if fbe_value is None:
            fbe_value = OrderMessage()

        fbe_begin = self.get_begin()
        if fbe_begin == 0:
            return fbe_value

        fbe_struct_size = self.read_uint32(0)
        self.get_fields(fbe_value, fbe_struct_size)
        self.get_end(fbe_begin)
        return fbe_value

    # Get the struct fields values
    def get_fields(self, fbe_value, fbe_struct_size):
        fbe_current_size = 4 + 4

        if (fbe_current_size + self.body.fbe_size) <= fbe_struct_size:
            fbe_value.body = self.body.get()
        else:
            fbe_value.body = Order()
        fbe_current_size += self.body.fbe_size

    # Set the struct value (begin phase)
    def set_begin(self):
        assert (self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size, "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        fbe_struct_size = self.fbe_body
        fbe_struct_offset = self._buffer.allocate(fbe_struct_size) - self._buffer.offset
        assert (fbe_struct_offset > 0) and ((self._buffer.offset + fbe_struct_offset + fbe_struct_size) <= self._buffer.size), "Model is broken!"
        if (fbe_struct_offset <= 0) or ((self._buffer.offset + fbe_struct_offset + fbe_struct_size) > self._buffer.size):
            return 0

        self.write_uint32(self.fbe_offset, fbe_struct_offset)
        self.write_uint32(fbe_struct_offset, fbe_struct_size)
        self.write_uint32(fbe_struct_offset + 4, self.fbe_type)

        self._buffer.shift(fbe_struct_offset)
        return fbe_struct_offset

    # Set the struct value (end phase)
    def set_end(self, fbe_begin):
        self._buffer.unshift(fbe_begin)

    # Set the struct value
    def set(self, fbe_value):
        fbe_begin = self.set_begin()
        if fbe_begin == 0:
            return

        self.set_fields(fbe_value)
        self.set_end(fbe_begin)

    # Set the struct fields values
    def set_fields(self, fbe_value):
        self.body.set(fbe_value.body)


# Fast Binary Encoding OrderMessage model
class OrderMessageModel(fbe.Model):
    __slots__ = "_model",

    def __init__(self, buffer=None):
        super().__init__(buffer)
        self._model = FieldModelOrderMessage(self.buffer, 4)

    @property
    def model(self):
        return self._model

    # Get the model size
    @property
    def fbe_size(self):
        return self._model.fbe_size + self._model.fbe_extra

    # Get the model type
    @property
    def fbe_type(self):
        return self.TYPE

    TYPE = FieldModelOrderMessage.TYPE

    # Check if the struct value is valid
    def verify(self):
        if (self.buffer.offset + self._model.fbe_offset - 4) > self.buffer.size:
            return False

        fbe_full_size = self.read_uint32(self._model.fbe_offset - 4)
        if fbe_full_size < self._model.fbe_size:
            return False

        return self._model.verify()

    # Create a new model (begin phase)
    def create_begin(self):
        fbe_begin = self.buffer.allocate(4 + self._model.fbe_size)
        return fbe_begin

    # Create a new model (end phase)
    def create_end(self, fbe_begin):
        fbe_end = self.buffer.size
        fbe_full_size = fbe_end - fbe_begin
        self.write_uint32(self._model.fbe_offset - 4, fbe_full_size)
        return fbe_full_size

    # Serialize the struct value
    def serialize(self, value):
        fbe_begin = self.create_begin()
        self._model.set(value)
        fbe_full_size = self.create_end(fbe_begin)
        return fbe_full_size

    # Deserialize the struct value
    def deserialize(self, value=None):
        if value is None:
            value = OrderMessage()

        if (self.buffer.offset + self._model.fbe_offset - 4) > self.buffer.size:
            value = OrderMessage()
            return value, 0

        fbe_full_size = self.read_uint32(self._model.fbe_offset - 4)
        assert (fbe_full_size >= self._model.fbe_size), "Model is broken!"
        if fbe_full_size < self._model.fbe_size:
            value = OrderMessage()
            return value, 0

        self._model.get(value)
        return value, fbe_full_size

    # Move to the next struct value
    def next(self, prev):
        self._model.fbe_shift(prev)


class FinalModelOrderMessage(fbe.FinalModel):
    __slots__ = "_body", 

    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)
        self._body = FinalModelOrder(buffer, 0)

    @property
    def body(self):
        return self._body

    # Get the allocation size
    def fbe_allocation_size(self, fbe_value):
        fbe_result = 0 \
            + self.body.fbe_allocation_size(fbe_value.body) \

        return fbe_result

    # Get the final type
    @property
    def fbe_type(self):
        return self.TYPE

    TYPE = 1

    # Check if the struct value is valid
    def verify(self):
        self._buffer.shift(self.fbe_offset)
        fbe_result = self.verify_fields()
        self._buffer.unshift(self.fbe_offset)
        return fbe_result

    # Check if the struct fields are valid
    def verify_fields(self):
        fbe_current_offset = 0

        self.body.fbe_offset = fbe_current_offset
        fbe_field_size = self.body.verify()
        if fbe_field_size == sys.maxsize:
            return sys.maxsize
        fbe_current_offset += fbe_field_size

        return fbe_current_offset

    # Get the struct value
    def get(self, fbe_value=None):
        if fbe_value is None:
            fbe_value = OrderMessage()

        self._buffer.shift(self.fbe_offset)
        fbe_size = self.get_fields(fbe_value)
        self._buffer.unshift(self.fbe_offset)
        return fbe_value, fbe_size

    # Get the struct fields values
    def get_fields(self, fbe_value):
        fbe_current_offset = 0
        fbe_current_size = 0

        self.body.fbe_offset = fbe_current_offset
        fbe_result = self.body.get()
        fbe_value.body = fbe_result[0]
        fbe_current_offset += fbe_result[1]
        fbe_current_size += fbe_result[1]

        return fbe_current_size

    # Set the struct value
    def set(self, fbe_value):
        self._buffer.shift(self.fbe_offset)
        fbe_size = self.set_fields(fbe_value)
        self._buffer.unshift(self.fbe_offset)
        return fbe_size

    # Set the struct fields values
    def set_fields(self, fbe_value):
        fbe_current_offset = 0
        fbe_current_size = 0

        self.body.fbe_offset = fbe_current_offset
        fbe_field_size = self.body.set(fbe_value.body)
        fbe_current_offset += fbe_field_size
        fbe_current_size += fbe_field_size

        return fbe_current_size


# Fast Binary Encoding OrderMessage final model
class OrderMessageFinalModel(fbe.Model):
    __slots__ = "_model",

    def __init__(self, buffer=None):
        super().__init__(buffer)
        self._model = FinalModelOrderMessage(self.buffer, 8)

    # Get the model type
    @property
    def fbe_type(self):
        return self.TYPE

    TYPE = FinalModelOrderMessage.TYPE

    # Check if the struct value is valid
    def verify(self):
        if (self.buffer.offset + self._model.fbe_offset) > self.buffer.size:
            return False

        fbe_struct_size = self.read_uint32(self._model.fbe_offset - 8)
        fbe_struct_type = self.read_uint32(self._model.fbe_offset - 4)
        if (fbe_struct_size <= 0) or (fbe_struct_type != self.fbe_type):
            return False

        return (8 + self._model.verify()) == fbe_struct_size

    # Serialize the struct value
    def serialize(self, value):
        fbe_initial_size = self.buffer.size

        fbe_struct_type = self.fbe_type
        fbe_struct_size = 8 + self._model.fbe_allocation_size(value)
        fbe_struct_offset = self.buffer.allocate(fbe_struct_size) - self.buffer.offset
        assert ((self.buffer.offset + fbe_struct_offset + fbe_struct_size) <= self.buffer.size), "Model is broken!"
        if (self.buffer.offset + fbe_struct_offset + fbe_struct_size) > self.buffer.size:
            return 0

        fbe_struct_size = 8 + self._model.set(value)
        self.buffer.resize(fbe_initial_size + fbe_struct_size)

        self.write_uint32(self._model.fbe_offset - 8, fbe_struct_size)
        self.write_uint32(self._model.fbe_offset - 4, fbe_struct_type)

        return fbe_struct_size

    # Deserialize the struct value
    def deserialize(self, value=None):
        if value is None:
            value = OrderMessage()

        assert ((self.buffer.offset + self._model.fbe_offset) <= self.buffer.size), "Model is broken!"
        if (self.buffer.offset + self._model.fbe_offset) > self.buffer.size:
            return OrderMessage(), 0

        fbe_struct_size = self.read_uint32(self._model.fbe_offset - 8)
        fbe_struct_type = self.read_uint32(self._model.fbe_offset - 4)
        assert ((fbe_struct_size > 0) and (fbe_struct_type == self.fbe_type)), "Model is broken!"
        if (fbe_struct_size <= 0) or (fbe_struct_type != self.fbe_type):
            return OrderMessage(), 8

        fbe_result = self._model.get(value)
        return fbe_result[0], (8 + fbe_result[1])

    # Move to the next struct value
    def next(self, prev):
        self._model.fbe_shift(prev)


@functools.total_ordering
class BalanceMessage(object):
    __slots__ = "body", 

    def __init__(self, body=None):
        if body is None:
            body = Balance()
        self.body = body

    # Struct shallow copy
    def copy(self, other):
        self.body = other.body
        return self

    # Struct deep clone
    def clone(self):
        # Serialize the struct to the FBE stream
        writer = BalanceMessageModel(fbe.WriteBuffer())
        writer.serialize(self)

        # Deserialize the struct from the FBE stream
        reader = BalanceMessageModel(fbe.ReadBuffer())
        reader.attach_buffer(writer.buffer)
        return reader.deserialize()[0]

    def __eq__(self, other):
        if not isinstance(self, other.__class__):
            return NotImplemented
        return True

    def __lt__(self, other):
        if not isinstance(self, other.__class__):
            return NotImplemented
        return False

    @property
    def __key__(self):
        return ()

    def __hash__(self):
        return hash(self.__key__)

    def __format__(self, format_spec):
        return self.__str__()

    def __str__(self):
        sb = list()
        sb.append("BalanceMessage(")
        sb.append("body=")
        sb.append(str(self.body))
        sb.append(")")
        return "".join(sb)

    # Get struct JSON value
    def to_json(self):
        return json.dumps(self.__to_json__(), cls=fbe.JSONEncoder, separators=(',', ':'))

    def __to_json__(self):
        result = dict()
        result.update(dict(
            body=self.body, 
        ))
        return result

    # Create struct from JSON value
    @staticmethod
    def from_json(document):
        return BalanceMessage.__from_json__(json.loads(document))

    @staticmethod
    def __from_json__(fields):
        if fields is None:
            return None
        return BalanceMessage(
            None if "body" not in fields else Balance.__from_json__(fields["body"]),
        )

    # Get the FBE type
    @property
    def fbe_type(self):
        return self.TYPE

    TYPE = 2


class FieldModelBalanceMessage(fbe.FieldModel):
    __slots__ = "_body", 

    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)
        self._body = FieldModelBalance(buffer, 4 + 4)

    @property
    def body(self):
        return self._body

    # Get the field size
    @property
    def fbe_size(self):
        return 4

    # Get the field body size
    @property
    def fbe_body(self):
        fbe_result = 4 + 4 \
            + self.body.fbe_size \

        return fbe_result

    # Get the field extra size
    @property
    def fbe_extra(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        fbe_struct_offset = self.read_uint32(self.fbe_offset)
        if (fbe_struct_offset == 0) or ((self._buffer.offset + fbe_struct_offset + 4) > self._buffer.size):
            return 0

        self._buffer.shift(fbe_struct_offset)

        fbe_result = self.fbe_body \
            + self.body.fbe_extra \

        self._buffer.unshift(fbe_struct_offset)

        return fbe_result

    # Get the field type
    @property
    def fbe_type(self):
        return self.TYPE

    TYPE = 2

    # Check if the struct value is valid
    def verify(self, fbe_verify_type=True):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return True

        fbe_struct_offset = self.read_uint32(self.fbe_offset)
        if (fbe_struct_offset == 0) or ((self._buffer.offset + fbe_struct_offset + 4 + 4) > self._buffer.size):
            return False

        fbe_struct_size = self.read_uint32(fbe_struct_offset)
        if fbe_struct_size < (4 + 4):
            return False

        fbe_struct_type = self.read_uint32(fbe_struct_offset + 4)
        if fbe_verify_type and (fbe_struct_type != self.fbe_type):
            return False

        self._buffer.shift(fbe_struct_offset)
        fbe_result = self.verify_fields(fbe_struct_size)
        self._buffer.unshift(fbe_struct_offset)
        return fbe_result

    # Check if the struct fields are valid
    def verify_fields(self, fbe_struct_size):
        fbe_current_size = 4 + 4

        if (fbe_current_size + self.body.fbe_size) > fbe_struct_size:
            return True
        if not self.body.verify():
            return False
        fbe_current_size += self.body.fbe_size

        return True

    # Get the struct value (begin phase)
    def get_begin(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        fbe_struct_offset = self.read_uint32(self.fbe_offset)
        assert (fbe_struct_offset > 0) and ((self._buffer.offset + fbe_struct_offset + 4 + 4) <= self._buffer.size), "Model is broken!"
        if (fbe_struct_offset == 0) or ((self._buffer.offset + fbe_struct_offset + 4 + 4) > self._buffer.size):
            return 0

        fbe_struct_size = self.read_uint32(fbe_struct_offset)
        assert (fbe_struct_size >= (4 + 4)), "Model is broken!"
        if fbe_struct_size < (4 + 4):
            return 0

        self._buffer.shift(fbe_struct_offset)
        return fbe_struct_offset

    # Get the struct value (end phase)
    def get_end(self, fbe_begin):
        self._buffer.unshift(fbe_begin)

    # Get the struct value
    def get(self, fbe_value=None):
        if fbe_value is None:
            fbe_value = BalanceMessage()

        fbe_begin = self.get_begin()
        if fbe_begin == 0:
            return fbe_value

        fbe_struct_size = self.read_uint32(0)
        self.get_fields(fbe_value, fbe_struct_size)
        self.get_end(fbe_begin)
        return fbe_value

    # Get the struct fields values
    def get_fields(self, fbe_value, fbe_struct_size):
        fbe_current_size = 4 + 4

        if (fbe_current_size + self.body.fbe_size) <= fbe_struct_size:
            fbe_value.body = self.body.get()
        else:
            fbe_value.body = Balance()
        fbe_current_size += self.body.fbe_size

    # Set the struct value (begin phase)
    def set_begin(self):
        assert (self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size, "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        fbe_struct_size = self.fbe_body
        fbe_struct_offset = self._buffer.allocate(fbe_struct_size) - self._buffer.offset
        assert (fbe_struct_offset > 0) and ((self._buffer.offset + fbe_struct_offset + fbe_struct_size) <= self._buffer.size), "Model is broken!"
        if (fbe_struct_offset <= 0) or ((self._buffer.offset + fbe_struct_offset + fbe_struct_size) > self._buffer.size):
            return 0

        self.write_uint32(self.fbe_offset, fbe_struct_offset)
        self.write_uint32(fbe_struct_offset, fbe_struct_size)
        self.write_uint32(fbe_struct_offset + 4, self.fbe_type)

        self._buffer.shift(fbe_struct_offset)
        return fbe_struct_offset

    # Set the struct value (end phase)
    def set_end(self, fbe_begin):
        self._buffer.unshift(fbe_begin)

    # Set the struct value
    def set(self, fbe_value):
        fbe_begin = self.set_begin()
        if fbe_begin == 0:
            return

        self.set_fields(fbe_value)
        self.set_end(fbe_begin)

    # Set the struct fields values
    def set_fields(self, fbe_value):
        self.body.set(fbe_value.body)


# Fast Binary Encoding BalanceMessage model
class BalanceMessageModel(fbe.Model):
    __slots__ = "_model",

    def __init__(self, buffer=None):
        super().__init__(buffer)
        self._model = FieldModelBalanceMessage(self.buffer, 4)

    @property
    def model(self):
        return self._model

    # Get the model size
    @property
    def fbe_size(self):
        return self._model.fbe_size + self._model.fbe_extra

    # Get the model type
    @property
    def fbe_type(self):
        return self.TYPE

    TYPE = FieldModelBalanceMessage.TYPE

    # Check if the struct value is valid
    def verify(self):
        if (self.buffer.offset + self._model.fbe_offset - 4) > self.buffer.size:
            return False

        fbe_full_size = self.read_uint32(self._model.fbe_offset - 4)
        if fbe_full_size < self._model.fbe_size:
            return False

        return self._model.verify()

    # Create a new model (begin phase)
    def create_begin(self):
        fbe_begin = self.buffer.allocate(4 + self._model.fbe_size)
        return fbe_begin

    # Create a new model (end phase)
    def create_end(self, fbe_begin):
        fbe_end = self.buffer.size
        fbe_full_size = fbe_end - fbe_begin
        self.write_uint32(self._model.fbe_offset - 4, fbe_full_size)
        return fbe_full_size

    # Serialize the struct value
    def serialize(self, value):
        fbe_begin = self.create_begin()
        self._model.set(value)
        fbe_full_size = self.create_end(fbe_begin)
        return fbe_full_size

    # Deserialize the struct value
    def deserialize(self, value=None):
        if value is None:
            value = BalanceMessage()

        if (self.buffer.offset + self._model.fbe_offset - 4) > self.buffer.size:
            value = BalanceMessage()
            return value, 0

        fbe_full_size = self.read_uint32(self._model.fbe_offset - 4)
        assert (fbe_full_size >= self._model.fbe_size), "Model is broken!"
        if fbe_full_size < self._model.fbe_size:
            value = BalanceMessage()
            return value, 0

        self._model.get(value)
        return value, fbe_full_size

    # Move to the next struct value
    def next(self, prev):
        self._model.fbe_shift(prev)


class FinalModelBalanceMessage(fbe.FinalModel):
    __slots__ = "_body", 

    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)
        self._body = FinalModelBalance(buffer, 0)

    @property
    def body(self):
        return self._body

    # Get the allocation size
    def fbe_allocation_size(self, fbe_value):
        fbe_result = 0 \
            + self.body.fbe_allocation_size(fbe_value.body) \

        return fbe_result

    # Get the final type
    @property
    def fbe_type(self):
        return self.TYPE

    TYPE = 2

    # Check if the struct value is valid
    def verify(self):
        self._buffer.shift(self.fbe_offset)
        fbe_result = self.verify_fields()
        self._buffer.unshift(self.fbe_offset)
        return fbe_result

    # Check if the struct fields are valid
    def verify_fields(self):
        fbe_current_offset = 0

        self.body.fbe_offset = fbe_current_offset
        fbe_field_size = self.body.verify()
        if fbe_field_size == sys.maxsize:
            return sys.maxsize
        fbe_current_offset += fbe_field_size

        return fbe_current_offset

    # Get the struct value
    def get(self, fbe_value=None):
        if fbe_value is None:
            fbe_value = BalanceMessage()

        self._buffer.shift(self.fbe_offset)
        fbe_size = self.get_fields(fbe_value)
        self._buffer.unshift(self.fbe_offset)
        return fbe_value, fbe_size

    # Get the struct fields values
    def get_fields(self, fbe_value):
        fbe_current_offset = 0
        fbe_current_size = 0

        self.body.fbe_offset = fbe_current_offset
        fbe_result = self.body.get()
        fbe_value.body = fbe_result[0]
        fbe_current_offset += fbe_result[1]
        fbe_current_size += fbe_result[1]

        return fbe_current_size

    # Set the struct value
    def set(self, fbe_value):
        self._buffer.shift(self.fbe_offset)
        fbe_size = self.set_fields(fbe_value)
        self._buffer.unshift(self.fbe_offset)
        return fbe_size

    # Set the struct fields values
    def set_fields(self, fbe_value):
        fbe_current_offset = 0
        fbe_current_size = 0

        self.body.fbe_offset = fbe_current_offset
        fbe_field_size = self.body.set(fbe_value.body)
        fbe_current_offset += fbe_field_size
        fbe_current_size += fbe_field_size

        return fbe_current_size


# Fast Binary Encoding BalanceMessage final model
class BalanceMessageFinalModel(fbe.Model):
    __slots__ = "_model",

    def __init__(self, buffer=None):
        super().__init__(buffer)
        self._model = FinalModelBalanceMessage(self.buffer, 8)

    # Get the model type
    @property
    def fbe_type(self):
        return self.TYPE

    TYPE = FinalModelBalanceMessage.TYPE

    # Check if the struct value is valid
    def verify(self):
        if (self.buffer.offset + self._model.fbe_offset) > self.buffer.size:
            return False

        fbe_struct_size = self.read_uint32(self._model.fbe_offset - 8)
        fbe_struct_type = self.read_uint32(self._model.fbe_offset - 4)
        if (fbe_struct_size <= 0) or (fbe_struct_type != self.fbe_type):
            return False

        return (8 + self._model.verify()) == fbe_struct_size

    # Serialize the struct value
    def serialize(self, value):
        fbe_initial_size = self.buffer.size

        fbe_struct_type = self.fbe_type
        fbe_struct_size = 8 + self._model.fbe_allocation_size(value)
        fbe_struct_offset = self.buffer.allocate(fbe_struct_size) - self.buffer.offset
        assert ((self.buffer.offset + fbe_struct_offset + fbe_struct_size) <= self.buffer.size), "Model is broken!"
        if (self.buffer.offset + fbe_struct_offset + fbe_struct_size) > self.buffer.size:
            return 0

        fbe_struct_size = 8 + self._model.set(value)
        self.buffer.resize(fbe_initial_size + fbe_struct_size)

        self.write_uint32(self._model.fbe_offset - 8, fbe_struct_size)
        self.write_uint32(self._model.fbe_offset - 4, fbe_struct_type)

        return fbe_struct_size

    # Deserialize the struct value
    def deserialize(self, value=None):
        if value is None:
            value = BalanceMessage()

        assert ((self.buffer.offset + self._model.fbe_offset) <= self.buffer.size), "Model is broken!"
        if (self.buffer.offset + self._model.fbe_offset) > self.buffer.size:
            return BalanceMessage(), 0

        fbe_struct_size = self.read_uint32(self._model.fbe_offset - 8)
        fbe_struct_type = self.read_uint32(self._model.fbe_offset - 4)
        assert ((fbe_struct_size > 0) and (fbe_struct_type == self.fbe_type)), "Model is broken!"
        if (fbe_struct_size <= 0) or (fbe_struct_type != self.fbe_type):
            return BalanceMessage(), 8

        fbe_result = self._model.get(value)
        return fbe_result[0], (8 + fbe_result[1])

    # Move to the next struct value
    def next(self, prev):
        self._model.fbe_shift(prev)


@functools.total_ordering
class AccountMessage(object):
    __slots__ = "body", 

    def __init__(self, body=None):
        if body is None:
            body = Account()
        self.body = body

    # Struct shallow copy
    def copy(self, other):
        self.body = other.body
        return self

    # Struct deep clone
    def clone(self):
        # Serialize the struct to the FBE stream
        writer = AccountMessageModel(fbe.WriteBuffer())
        writer.serialize(self)

        # Deserialize the struct from the FBE stream
        reader = AccountMessageModel(fbe.ReadBuffer())
        reader.attach_buffer(writer.buffer)
        return reader.deserialize()[0]

    def __eq__(self, other):
        if not isinstance(self, other.__class__):
            return NotImplemented
        return True

    def __lt__(self, other):
        if not isinstance(self, other.__class__):
            return NotImplemented
        return False

    @property
    def __key__(self):
        return ()

    def __hash__(self):
        return hash(self.__key__)

    def __format__(self, format_spec):
        return self.__str__()

    def __str__(self):
        sb = list()
        sb.append("AccountMessage(")
        sb.append("body=")
        sb.append(str(self.body))
        sb.append(")")
        return "".join(sb)

    # Get struct JSON value
    def to_json(self):
        return json.dumps(self.__to_json__(), cls=fbe.JSONEncoder, separators=(',', ':'))

    def __to_json__(self):
        result = dict()
        result.update(dict(
            body=self.body, 
        ))
        return result

    # Create struct from JSON value
    @staticmethod
    def from_json(document):
        return AccountMessage.__from_json__(json.loads(document))

    @staticmethod
    def __from_json__(fields):
        if fields is None:
            return None
        return AccountMessage(
            None if "body" not in fields else Account.__from_json__(fields["body"]),
        )

    # Get the FBE type
    @property
    def fbe_type(self):
        return self.TYPE

    TYPE = 3


class FieldModelAccountMessage(fbe.FieldModel):
    __slots__ = "_body", 

    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)
        self._body = FieldModelAccount(buffer, 4 + 4)

    @property
    def body(self):
        return self._body

    # Get the field size
    @property
    def fbe_size(self):
        return 4

    # Get the field body size
    @property
    def fbe_body(self):
        fbe_result = 4 + 4 \
            + self.body.fbe_size \

        return fbe_result

    # Get the field extra size
    @property
    def fbe_extra(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        fbe_struct_offset = self.read_uint32(self.fbe_offset)
        if (fbe_struct_offset == 0) or ((self._buffer.offset + fbe_struct_offset + 4) > self._buffer.size):
            return 0

        self._buffer.shift(fbe_struct_offset)

        fbe_result = self.fbe_body \
            + self.body.fbe_extra \

        self._buffer.unshift(fbe_struct_offset)

        return fbe_result

    # Get the field type
    @property
    def fbe_type(self):
        return self.TYPE

    TYPE = 3

    # Check if the struct value is valid
    def verify(self, fbe_verify_type=True):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return True

        fbe_struct_offset = self.read_uint32(self.fbe_offset)
        if (fbe_struct_offset == 0) or ((self._buffer.offset + fbe_struct_offset + 4 + 4) > self._buffer.size):
            return False

        fbe_struct_size = self.read_uint32(fbe_struct_offset)
        if fbe_struct_size < (4 + 4):
            return False

        fbe_struct_type = self.read_uint32(fbe_struct_offset + 4)
        if fbe_verify_type and (fbe_struct_type != self.fbe_type):
            return False

        self._buffer.shift(fbe_struct_offset)
        fbe_result = self.verify_fields(fbe_struct_size)
        self._buffer.unshift(fbe_struct_offset)
        return fbe_result

    # Check if the struct fields are valid
    def verify_fields(self, fbe_struct_size):
        fbe_current_size = 4 + 4

        if (fbe_current_size + self.body.fbe_size) > fbe_struct_size:
            return True
        if not self.body.verify():
            return False
        fbe_current_size += self.body.fbe_size

        return True

    # Get the struct value (begin phase)
    def get_begin(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        fbe_struct_offset = self.read_uint32(self.fbe_offset)
        assert (fbe_struct_offset > 0) and ((self._buffer.offset + fbe_struct_offset + 4 + 4) <= self._buffer.size), "Model is broken!"
        if (fbe_struct_offset == 0) or ((self._buffer.offset + fbe_struct_offset + 4 + 4) > self._buffer.size):
            return 0

        fbe_struct_size = self.read_uint32(fbe_struct_offset)
        assert (fbe_struct_size >= (4 + 4)), "Model is broken!"
        if fbe_struct_size < (4 + 4):
            return 0

        self._buffer.shift(fbe_struct_offset)
        return fbe_struct_offset

    # Get the struct value (end phase)
    def get_end(self, fbe_begin):
        self._buffer.unshift(fbe_begin)

    # Get the struct value
    def get(self, fbe_value=None):
        if fbe_value is None:
            fbe_value = AccountMessage()

        fbe_begin = self.get_begin()
        if fbe_begin == 0:
            return fbe_value

        fbe_struct_size = self.read_uint32(0)
        self.get_fields(fbe_value, fbe_struct_size)
        self.get_end(fbe_begin)
        return fbe_value

    # Get the struct fields values
    def get_fields(self, fbe_value, fbe_struct_size):
        fbe_current_size = 4 + 4

        if (fbe_current_size + self.body.fbe_size) <= fbe_struct_size:
            fbe_value.body = self.body.get()
        else:
            fbe_value.body = Account()
        fbe_current_size += self.body.fbe_size

    # Set the struct value (begin phase)
    def set_begin(self):
        assert (self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size, "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        fbe_struct_size = self.fbe_body
        fbe_struct_offset = self._buffer.allocate(fbe_struct_size) - self._buffer.offset
        assert (fbe_struct_offset > 0) and ((self._buffer.offset + fbe_struct_offset + fbe_struct_size) <= self._buffer.size), "Model is broken!"
        if (fbe_struct_offset <= 0) or ((self._buffer.offset + fbe_struct_offset + fbe_struct_size) > self._buffer.size):
            return 0

        self.write_uint32(self.fbe_offset, fbe_struct_offset)
        self.write_uint32(fbe_struct_offset, fbe_struct_size)
        self.write_uint32(fbe_struct_offset + 4, self.fbe_type)

        self._buffer.shift(fbe_struct_offset)
        return fbe_struct_offset

    # Set the struct value (end phase)
    def set_end(self, fbe_begin):
        self._buffer.unshift(fbe_begin)

    # Set the struct value
    def set(self, fbe_value):
        fbe_begin = self.set_begin()
        if fbe_begin == 0:
            return

        self.set_fields(fbe_value)
        self.set_end(fbe_begin)

    # Set the struct fields values
    def set_fields(self, fbe_value):
        self.body.set(fbe_value.body)


# Fast Binary Encoding AccountMessage model
class AccountMessageModel(fbe.Model):
    __slots__ = "_model",

    def __init__(self, buffer=None):
        super().__init__(buffer)
        self._model = FieldModelAccountMessage(self.buffer, 4)

    @property
    def model(self):
        return self._model

    # Get the model size
    @property
    def fbe_size(self):
        return self._model.fbe_size + self._model.fbe_extra

    # Get the model type
    @property
    def fbe_type(self):
        return self.TYPE

    TYPE = FieldModelAccountMessage.TYPE

    # Check if the struct value is valid
    def verify(self):
        if (self.buffer.offset + self._model.fbe_offset - 4) > self.buffer.size:
            return False

        fbe_full_size = self.read_uint32(self._model.fbe_offset - 4)
        if fbe_full_size < self._model.fbe_size:
            return False

        return self._model.verify()

    # Create a new model (begin phase)
    def create_begin(self):
        fbe_begin = self.buffer.allocate(4 + self._model.fbe_size)
        return fbe_begin

    # Create a new model (end phase)
    def create_end(self, fbe_begin):
        fbe_end = self.buffer.size
        fbe_full_size = fbe_end - fbe_begin
        self.write_uint32(self._model.fbe_offset - 4, fbe_full_size)
        return fbe_full_size

    # Serialize the struct value
    def serialize(self, value):
        fbe_begin = self.create_begin()
        self._model.set(value)
        fbe_full_size = self.create_end(fbe_begin)
        return fbe_full_size

    # Deserialize the struct value
    def deserialize(self, value=None):
        if value is None:
            value = AccountMessage()

        if (self.buffer.offset + self._model.fbe_offset - 4) > self.buffer.size:
            value = AccountMessage()
            return value, 0

        fbe_full_size = self.read_uint32(self._model.fbe_offset - 4)
        assert (fbe_full_size >= self._model.fbe_size), "Model is broken!"
        if fbe_full_size < self._model.fbe_size:
            value = AccountMessage()
            return value, 0

        self._model.get(value)
        return value, fbe_full_size

    # Move to the next struct value
    def next(self, prev):
        self._model.fbe_shift(prev)


class FinalModelAccountMessage(fbe.FinalModel):
    __slots__ = "_body", 

    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)
        self._body = FinalModelAccount(buffer, 0)

    @property
    def body(self):
        return self._body

    # Get the allocation size
    def fbe_allocation_size(self, fbe_value):
        fbe_result = 0 \
            + self.body.fbe_allocation_size(fbe_value.body) \

        return fbe_result

    # Get the final type
    @property
    def fbe_type(self):
        return self.TYPE

    TYPE = 3

    # Check if the struct value is valid
    def verify(self):
        self._buffer.shift(self.fbe_offset)
        fbe_result = self.verify_fields()
        self._buffer.unshift(self.fbe_offset)
        return fbe_result

    # Check if the struct fields are valid
    def verify_fields(self):
        fbe_current_offset = 0

        self.body.fbe_offset = fbe_current_offset
        fbe_field_size = self.body.verify()
        if fbe_field_size == sys.maxsize:
            return sys.maxsize
        fbe_current_offset += fbe_field_size

        return fbe_current_offset

    # Get the struct value
    def get(self, fbe_value=None):
        if fbe_value is None:
            fbe_value = AccountMessage()

        self._buffer.shift(self.fbe_offset)
        fbe_size = self.get_fields(fbe_value)
        self._buffer.unshift(self.fbe_offset)
        return fbe_value, fbe_size

    # Get the struct fields values
    def get_fields(self, fbe_value):
        fbe_current_offset = 0
        fbe_current_size = 0

        self.body.fbe_offset = fbe_current_offset
        fbe_result = self.body.get()
        fbe_value.body = fbe_result[0]
        fbe_current_offset += fbe_result[1]
        fbe_current_size += fbe_result[1]

        return fbe_current_size

    # Set the struct value
    def set(self, fbe_value):
        self._buffer.shift(self.fbe_offset)
        fbe_size = self.set_fields(fbe_value)
        self._buffer.unshift(self.fbe_offset)
        return fbe_size

    # Set the struct fields values
    def set_fields(self, fbe_value):
        fbe_current_offset = 0
        fbe_current_size = 0

        self.body.fbe_offset = fbe_current_offset
        fbe_field_size = self.body.set(fbe_value.body)
        fbe_current_offset += fbe_field_size
        fbe_current_size += fbe_field_size

        return fbe_current_size


# Fast Binary Encoding AccountMessage final model
class AccountMessageFinalModel(fbe.Model):
    __slots__ = "_model",

    def __init__(self, buffer=None):
        super().__init__(buffer)
        self._model = FinalModelAccountMessage(self.buffer, 8)

    # Get the model type
    @property
    def fbe_type(self):
        return self.TYPE

    TYPE = FinalModelAccountMessage.TYPE

    # Check if the struct value is valid
    def verify(self):
        if (self.buffer.offset + self._model.fbe_offset) > self.buffer.size:
            return False

        fbe_struct_size = self.read_uint32(self._model.fbe_offset - 8)
        fbe_struct_type = self.read_uint32(self._model.fbe_offset - 4)
        if (fbe_struct_size <= 0) or (fbe_struct_type != self.fbe_type):
            return False

        return (8 + self._model.verify()) == fbe_struct_size

    # Serialize the struct value
    def serialize(self, value):
        fbe_initial_size = self.buffer.size

        fbe_struct_type = self.fbe_type
        fbe_struct_size = 8 + self._model.fbe_allocation_size(value)
        fbe_struct_offset = self.buffer.allocate(fbe_struct_size) - self.buffer.offset
        assert ((self.buffer.offset + fbe_struct_offset + fbe_struct_size) <= self.buffer.size), "Model is broken!"
        if (self.buffer.offset + fbe_struct_offset + fbe_struct_size) > self.buffer.size:
            return 0

        fbe_struct_size = 8 + self._model.set(value)
        self.buffer.resize(fbe_initial_size + fbe_struct_size)

        self.write_uint32(self._model.fbe_offset - 8, fbe_struct_size)
        self.write_uint32(self._model.fbe_offset - 4, fbe_struct_type)

        return fbe_struct_size

    # Deserialize the struct value
    def deserialize(self, value=None):
        if value is None:
            value = AccountMessage()

        assert ((self.buffer.offset + self._model.fbe_offset) <= self.buffer.size), "Model is broken!"
        if (self.buffer.offset + self._model.fbe_offset) > self.buffer.size:
            return AccountMessage(), 0

        fbe_struct_size = self.read_uint32(self._model.fbe_offset - 8)
        fbe_struct_type = self.read_uint32(self._model.fbe_offset - 4)
        assert ((fbe_struct_size > 0) and (fbe_struct_type == self.fbe_type)), "Model is broken!"
        if (fbe_struct_size <= 0) or (fbe_struct_type != self.fbe_type):
            return AccountMessage(), 8

        fbe_result = self._model.get(value)
        return fbe_result[0], (8 + fbe_result[1])

    # Move to the next struct value
    def next(self, prev):
        self._model.fbe_shift(prev)


# Fast Binary Encoding proto protocol version
class ProtocolVersion(object):
    # Protocol major version
    Major = 1
    # Protocol minor version
    Minor = 0


# Fast Binary Encoding proto sender
class Sender(fbe.Sender):
    __slots__ = "_ordermessage_model", "_balancemessage_model", "_accountmessage_model", 

    def __init__(self, buffer=None):
        super().__init__(buffer, False)
        self._ordermessage_model = OrderMessageModel(self.buffer)
        self._balancemessage_model = BalanceMessageModel(self.buffer)
        self._accountmessage_model = AccountMessageModel(self.buffer)

    # Sender models accessors

    @property
    def ordermessage_model(self):
        return self._ordermessage_model

    @property
    def balancemessage_model(self):
        return self._balancemessage_model

    @property
    def accountmessage_model(self):
        return self._accountmessage_model

    # Send methods

    def send(self, value):
        if isinstance(value, OrderMessage) and (value.fbe_type == self.ordermessage_model.fbe_type):
            return self.send_ordermessage(value)
        if isinstance(value, BalanceMessage) and (value.fbe_type == self.balancemessage_model.fbe_type):
            return self.send_balancemessage(value)
        if isinstance(value, AccountMessage) and (value.fbe_type == self.accountmessage_model.fbe_type):
            return self.send_accountmessage(value)
        return 0

    def send_ordermessage(self, value):
        # Serialize the value into the FBE stream
        serialized = self.ordermessage_model.serialize(value)
        assert (serialized > 0), "proto.OrderMessage serialization failed!"
        assert self.ordermessage_model.verify(), "proto.OrderMessage validation failed!"

        # Log the value
        if self.logging:
            message = str(value)
            self.on_send_log(message)

        # Send the serialized value
        return self.send_serialized(serialized)

    def send_balancemessage(self, value):
        # Serialize the value into the FBE stream
        serialized = self.balancemessage_model.serialize(value)
        assert (serialized > 0), "proto.BalanceMessage serialization failed!"
        assert self.balancemessage_model.verify(), "proto.BalanceMessage validation failed!"

        # Log the value
        if self.logging:
            message = str(value)
            self.on_send_log(message)

        # Send the serialized value
        return self.send_serialized(serialized)

    def send_accountmessage(self, value):
        # Serialize the value into the FBE stream
        serialized = self.accountmessage_model.serialize(value)
        assert (serialized > 0), "proto.AccountMessage serialization failed!"
        assert self.accountmessage_model.verify(), "proto.AccountMessage validation failed!"

        # Log the value
        if self.logging:
            message = str(value)
            self.on_send_log(message)

        # Send the serialized value
        return self.send_serialized(serialized)

    # Send message handler
    def on_send(self, buffer, offset, size):
        raise NotImplementedError("proto.Sender.on_send() not implemented!")


# Fast Binary Encoding proto receiver
class Receiver(fbe.Receiver):
    __slots__ = "_ordermessage_value", "_ordermessage_model", "_balancemessage_value", "_balancemessage_model", "_accountmessage_value", "_accountmessage_model", 

    def __init__(self, buffer=None):
        super().__init__(buffer, False)
        self._ordermessage_value = OrderMessage()
        self._ordermessage_model = OrderMessageModel()
        self._balancemessage_value = BalanceMessage()
        self._balancemessage_model = BalanceMessageModel()
        self._accountmessage_value = AccountMessage()
        self._accountmessage_model = AccountMessageModel()

    # Receive handlers

    def on_receive_ordermessage(self, value):
        pass

    def on_receive_balancemessage(self, value):
        pass

    def on_receive_accountmessage(self, value):
        pass

    def on_receive(self, type, buffer, offset, size):

        if type == OrderMessageModel.TYPE:
            # Deserialize the value from the FBE stream
            self._ordermessage_model.attach_buffer(buffer, offset)
            assert self._ordermessage_model.verify(), "proto.OrderMessage validation failed!"
            (_, deserialized) = self._ordermessage_model.deserialize(self._ordermessage_value)
            assert (deserialized > 0), "proto.OrderMessage deserialization failed!"

            # Log the value
            if self.logging:
                message = str(self._ordermessage_value)
                self.on_receive_log(message)

            # Call receive handler with deserialized value
            self.on_receive_ordermessage(self._ordermessage_value)
            return True

        if type == BalanceMessageModel.TYPE:
            # Deserialize the value from the FBE stream
            self._balancemessage_model.attach_buffer(buffer, offset)
            assert self._balancemessage_model.verify(), "proto.BalanceMessage validation failed!"
            (_, deserialized) = self._balancemessage_model.deserialize(self._balancemessage_value)
            assert (deserialized > 0), "proto.BalanceMessage deserialization failed!"

            # Log the value
            if self.logging:
                message = str(self._balancemessage_value)
                self.on_receive_log(message)

            # Call receive handler with deserialized value
            self.on_receive_balancemessage(self._balancemessage_value)
            return True

        if type == AccountMessageModel.TYPE:
            # Deserialize the value from the FBE stream
            self._accountmessage_model.attach_buffer(buffer, offset)
            assert self._accountmessage_model.verify(), "proto.AccountMessage validation failed!"
            (_, deserialized) = self._accountmessage_model.deserialize(self._accountmessage_value)
            assert (deserialized > 0), "proto.AccountMessage deserialization failed!"

            # Log the value
            if self.logging:
                message = str(self._accountmessage_value)
                self.on_receive_log(message)

            # Call receive handler with deserialized value
            self.on_receive_accountmessage(self._accountmessage_value)
            return True

        return False


# Fast Binary Encoding proto proxy
class Proxy(fbe.Receiver):
    __slots__ = "_ordermessage_model", "_balancemessage_model", "_accountmessage_model", 

    def __init__(self, buffer=None):
        super().__init__(buffer, False)
        self._ordermessage_model = OrderMessageModel()
        self._balancemessage_model = BalanceMessageModel()
        self._accountmessage_model = AccountMessageModel()

    # Receive handlers

    def on_proxy_ordermessage(self, model, type, buffer, offset, size):
        pass

    def on_proxy_balancemessage(self, model, type, buffer, offset, size):
        pass

    def on_proxy_accountmessage(self, model, type, buffer, offset, size):
        pass

    def on_receive(self, type, buffer, offset, size):

        if type == OrderMessageModel.TYPE:
            # Attach the FBE stream to the proxy model
            self._ordermessage_model.attach_buffer(buffer, offset)
            assert self._ordermessage_model.verify(), "proto.OrderMessage validation failed!"

            fbe_begin = self._ordermessage_model.model.get_begin()
            if fbe_begin == 0:
                return False
            # Call proxy handler
            self.on_proxy_ordermessage(self._ordermessage_model, type, buffer, offset, size)
            self._ordermessage_model.model.get_end(fbe_begin)
            return True

        if type == BalanceMessageModel.TYPE:
            # Attach the FBE stream to the proxy model
            self._balancemessage_model.attach_buffer(buffer, offset)
            assert self._balancemessage_model.verify(), "proto.BalanceMessage validation failed!"

            fbe_begin = self._balancemessage_model.model.get_begin()
            if fbe_begin == 0:
                return False
            # Call proxy handler
            self.on_proxy_balancemessage(self._balancemessage_model, type, buffer, offset, size)
            self._balancemessage_model.model.get_end(fbe_begin)
            return True

        if type == AccountMessageModel.TYPE:
            # Attach the FBE stream to the proxy model
            self._accountmessage_model.attach_buffer(buffer, offset)
            assert self._accountmessage_model.verify(), "proto.AccountMessage validation failed!"

            fbe_begin = self._accountmessage_model.model.get_begin()
            if fbe_begin == 0:
                return False
            # Call proxy handler
            self.on_proxy_accountmessage(self._accountmessage_model, type, buffer, offset, size)
            self._accountmessage_model.model.get_end(fbe_begin)
            return True

        return False


# Fast Binary Encoding proto final sender
class FinalSender(fbe.Sender):
    __slots__ = "_ordermessage_model", "_balancemessage_model", "_accountmessage_model", 

    def __init__(self, buffer=None):
        super().__init__(buffer, True)
        self._ordermessage_model = OrderMessageFinalModel(self.buffer)
        self._balancemessage_model = BalanceMessageFinalModel(self.buffer)
        self._accountmessage_model = AccountMessageFinalModel(self.buffer)

    # Sender models accessors

    @property
    def ordermessage_model(self):
        return self._ordermessage_model

    @property
    def balancemessage_model(self):
        return self._balancemessage_model

    @property
    def accountmessage_model(self):
        return self._accountmessage_model

    # Send methods

    def send(self, value):
        if isinstance(value, OrderMessage) and (value.fbe_type == self.ordermessage_model.fbe_type):
            return self.send_ordermessage(value)
        if isinstance(value, BalanceMessage) and (value.fbe_type == self.balancemessage_model.fbe_type):
            return self.send_balancemessage(value)
        if isinstance(value, AccountMessage) and (value.fbe_type == self.accountmessage_model.fbe_type):
            return self.send_accountmessage(value)
        return 0

    def send_ordermessage(self, value):
        # Serialize the value into the FBE stream
        serialized = self.ordermessage_model.serialize(value)
        assert (serialized > 0), "proto.OrderMessage serialization failed!"
        assert self.ordermessage_model.verify(), "proto.OrderMessage validation failed!"

        # Log the value
        if self.logging:
            message = str(value)
            self.on_send_log(message)

        # Send the serialized value
        return self.send_serialized(serialized)

    def send_balancemessage(self, value):
        # Serialize the value into the FBE stream
        serialized = self.balancemessage_model.serialize(value)
        assert (serialized > 0), "proto.BalanceMessage serialization failed!"
        assert self.balancemessage_model.verify(), "proto.BalanceMessage validation failed!"

        # Log the value
        if self.logging:
            message = str(value)
            self.on_send_log(message)

        # Send the serialized value
        return self.send_serialized(serialized)

    def send_accountmessage(self, value):
        # Serialize the value into the FBE stream
        serialized = self.accountmessage_model.serialize(value)
        assert (serialized > 0), "proto.AccountMessage serialization failed!"
        assert self.accountmessage_model.verify(), "proto.AccountMessage validation failed!"

        # Log the value
        if self.logging:
            message = str(value)
            self.on_send_log(message)

        # Send the serialized value
        return self.send_serialized(serialized)

    # Send message handler
    def on_send(self, buffer, offset, size):
        raise NotImplementedError("proto.Sender.on_send() not implemented!")


# Fast Binary Encoding proto final receiver
class FinalReceiver(fbe.Receiver):
    __slots__ = "_ordermessage_value", "_ordermessage_model", "_balancemessage_value", "_balancemessage_model", "_accountmessage_value", "_accountmessage_model", 

    def __init__(self, buffer=None):
        super().__init__(buffer, True)
        self._ordermessage_value = OrderMessage()
        self._ordermessage_model = OrderMessageFinalModel()
        self._balancemessage_value = BalanceMessage()
        self._balancemessage_model = BalanceMessageFinalModel()
        self._accountmessage_value = AccountMessage()
        self._accountmessage_model = AccountMessageFinalModel()

    # Receive handlers

    def on_receive_ordermessage(self, value):
        pass

    def on_receive_balancemessage(self, value):
        pass

    def on_receive_accountmessage(self, value):
        pass

    def on_receive(self, type, buffer, offset, size):

        if type == OrderMessageFinalModel.TYPE:
            # Deserialize the value from the FBE stream
            self._ordermessage_model.attach_buffer(buffer, offset)
            assert self._ordermessage_model.verify(), "proto.OrderMessage validation failed!"
            (_, deserialized) = self._ordermessage_model.deserialize(self._ordermessage_value)
            assert (deserialized > 0), "proto.OrderMessage deserialization failed!"

            # Log the value
            if self.logging:
                message = str(self._ordermessage_value)
                self.on_receive_log(message)

            # Call receive handler with deserialized value
            self.on_receive_ordermessage(self._ordermessage_value)
            return True

        if type == BalanceMessageFinalModel.TYPE:
            # Deserialize the value from the FBE stream
            self._balancemessage_model.attach_buffer(buffer, offset)
            assert self._balancemessage_model.verify(), "proto.BalanceMessage validation failed!"
            (_, deserialized) = self._balancemessage_model.deserialize(self._balancemessage_value)
            assert (deserialized > 0), "proto.BalanceMessage deserialization failed!"

            # Log the value
            if self.logging:
                message = str(self._balancemessage_value)
                self.on_receive_log(message)

            # Call receive handler with deserialized value
            self.on_receive_balancemessage(self._balancemessage_value)
            return True

        if type == AccountMessageFinalModel.TYPE:
            # Deserialize the value from the FBE stream
            self._accountmessage_model.attach_buffer(buffer, offset)
            assert self._accountmessage_model.verify(), "proto.AccountMessage validation failed!"
            (_, deserialized) = self._accountmessage_model.deserialize(self._accountmessage_value)
            assert (deserialized > 0), "proto.AccountMessage deserialization failed!"

            # Log the value
            if self.logging:
                message = str(self._accountmessage_value)
                self.on_receive_log(message)

            # Call receive handler with deserialized value
            self.on_receive_accountmessage(self._accountmessage_value)
            return True

        return False
