#------------------------------------------------------------------------------
# Automatically generated by the Fast Binary Encoding compiler, do not modify!
# https://github.com/chronoxor/FastBinaryEncoding
# Source: FBE
# FBE version: 1.14.5.0
#------------------------------------------------------------------------------

import base64
import decimal
import enum
import json
import struct
import sys
import time
import uuid


class DefaultEnumMeta(enum.EnumMeta):
    default = object()

    def __call__(cls, value=default, *args, **kwargs):
        if value is DefaultEnumMeta.default:
            return next(iter(cls))
        return super().__call__(value, *args, **kwargs)


class JSONEncoder(json.JSONEncoder):
    def default(self, obj):
        if hasattr(obj, "__to_json__"):
            return obj.__to_json__()
        elif isinstance(obj, bytes) or isinstance(obj, bytearray):
            return base64.b64encode(obj).decode('ascii')
        elif isinstance(obj, decimal.Decimal):
            return str(obj)
        elif isinstance(obj, uuid.UUID):
            return str(obj)
        elif isinstance(obj, set):
            return list(obj)
        else:
            return super().default(self, obj)


def epoch():
    return 0


def utc():
    return time.time_ns()


# Fast Binary Encoding write buffer based on the dynamic byte array
class WriteBuffer(object):
    __slots__ = "_buffer", "_offset", "_size",

    def __init__(self, capacity=0):
        self._buffer = bytearray(capacity)
        self._size = 0
        self._offset = 0

    def __bool__(self):
        return not self.empty

    @property
    def empty(self):
        return (self._buffer is None) or (self._size <= 0)

    @property
    def buffer(self):
        return self._buffer

    @property
    def capacity(self):
        return len(self._buffer)

    @property
    def size(self):
        return self._size

    def __len__(self):
        return self._size

    @property
    def offset(self):
        return self._offset

    # Attach an empty memory buffer
    def attach_new(self):
        self._buffer = bytearray()
        self._size = 0
        self._offset = 0

    # Attach an empty memory buffer with a given capacity
    def attach_capacity(self, capacity):
        self._buffer = bytearray(capacity)
        self._size = 0
        self._offset = 0

    # Attach a given memory buffer
    def attach_buffer(self, buffer, offset=0, size=None):
        assert (buffer is not None), "Invalid buffer!"
        if buffer is None:
            raise ValueError("Invalid buffer!")

        if size is None:
            size = len(buffer)

        assert (size > 0), "Invalid size!"
        if size <= 0:
            raise ValueError("Invalid size!")
        assert (offset <= size), "Invalid offset!"
        if offset > size:
            raise ValueError("Invalid offset!")

        if isinstance(buffer, ReadBuffer) or isinstance(buffer, WriteBuffer):
            self._buffer = buffer.buffer
        else:
            self._buffer = buffer
        self._size = size
        self._offset = offset

    # Allocate memory in the current write buffer and return offset to the allocated memory block
    def allocate(self, size):
        assert (size >= 0), "Invalid allocation size!"
        if size < 0:
            raise ValueError("Invalid allocation size!")

        offset = self._size

        # Calculate a new buffer size
        total = self._size + size

        if total <= len(self._buffer):
            self._size = total
            return offset

        data = bytearray(max(total, 2 * len(self._buffer)))
        data[:self._size] = self._buffer
        self._buffer = data
        self._size = total
        return offset

    # Remove some memory of the given size from the current write buffer
    def remove(self, offset, size):
        assert ((offset + size) <= len(self._buffer)), "Invalid offset & size!"
        if (offset + size) > len(self._buffer):
            raise ValueError("Invalid offset & size!")

        del self._buffer[offset:offset + size]
        self._size -= size
        if self._offset >= (offset + size):
            self._offset -= size
        elif self._offset >= offset:
            self._offset -= self._offset - offset
            if self._offset > self._size:
                self._offset = self._size

    # Reserve memory of the given capacity in the current write buffer
    def reserve(self, capacity):
        assert (capacity >= 0), "Invalid reserve capacity!"
        if capacity < 0:
            raise ValueError("Invalid reserve capacity!")

        if capacity > len(self._buffer):
            data = bytearray(max(capacity, 2 * len(self._buffer)))
            data[:self._size] = self._buffer
            self._buffer = data

    # Resize the current write buffer
    def resize(self, size):
        self.reserve(size)
        self._size = size
        if self._offset > self._size:
            self._offset = self._size

    # Reset the current write buffer and its offset
    def reset(self):
        self._size = 0
        self._offset = 0

    # Shift the current write buffer offset
    def shift(self, offset):
        self._offset += offset

    # Unshift the current write buffer offset
    def unshift(self, offset):
        self._offset -= offset


# Fast Binary Encoding read buffer based on the constant byte buffer
class ReadBuffer(object):
    __slots__ = "_buffer", "_offset", "_size",

    def __init__(self):
        self._buffer = None
        self._size = 0
        self._offset = 0

    def __bool__(self):
        return self._buffer is not None

    @property
    def buffer(self):
        return self._buffer

    @property
    def capacity(self):
        return self._size

    @property
    def size(self):
        return self._size

    def __len__(self):
        return self._size

    @property
    def offset(self):
        return self._offset

    # Attach a given memory buffer
    def attach_buffer(self, buffer, offset=0, size=None):
        assert (buffer is not None), "Invalid buffer!"
        if buffer is None:
            raise ValueError("Invalid buffer!")

        if size is None:
            size = len(buffer)

        assert (size > 0), "Invalid size!"
        if size <= 0:
            raise ValueError("Invalid size!")
        assert (offset <= size), "Invalid offset!"
        if offset > size:
            raise ValueError("Invalid offset!")

        if isinstance(buffer, ReadBuffer) or isinstance(buffer, WriteBuffer):
            self._buffer = buffer.buffer
        else:
            self._buffer = buffer
        self._size = size
        self._offset = offset

    # Reset the current read buffer and its offset
    def reset(self):
        self._buffer = None
        self._size = 0
        self._offset = 0

    # Shift the current read buffer offset
    def shift(self, offset):
        self._offset += offset

    # Unshift the current read buffer offset
    def unshift(self, offset):
        self._offset -= offset


# Fast Binary Encoding base model
class Model(object):
    __slots__ = "_buffer",

    def __init__(self, buffer=None):
        if buffer is None:
            buffer = WriteBuffer()
        self._buffer = buffer

    @property
    def buffer(self):
        return self._buffer

    # Attach an empty memory buffer
    def attach_new(self):
        self.buffer.attach_new()

    # Attach an empty memory buffer with a given capacity
    def attach_capacity(self, capacity):
        self.buffer.attach_capacity(capacity)

    # Attach a given memory buffer
    def attach_buffer(self, buffer, offset=0, size=None):
        self.buffer.attach_buffer(buffer, offset, size)

    # Allocate memory in the current write buffer and return offset to the allocated memory block
    def allocate(self, size):
        return self.buffer.allocate(size)

    # Remove some memory of the given size from the current write buffer
    def remove(self, offset, size):
        self.buffer.remove(offset, size)

    # Reserve memory of the given capacity in the current write buffer
    def reserve(self, capacity):
        self.buffer.reserve(capacity)

    # Resize the current write buffer
    def resize(self, size):
        self.buffer.resize(size)

    # Reset the current write buffer and its offset
    def reset(self):
        self.buffer.reset()

    # Shift the current write buffer offset
    def shift(self, offset):
        self.buffer.shift(offset)

    # Unshift the current write buffer offset
    def unshift(self, offset):
        self.buffer.unshift(offset)

    # Buffer I/O methods

    def read_uint32(self, offset):
        return struct.unpack_from("<I", self.buffer.buffer, self.buffer.offset + offset)[0]

    def write_uint32(self, offset, value):
        return struct.pack_into("<I", self.buffer.buffer, self.buffer.offset + offset, value)


# Fast Binary Encoding base field model
class FieldModelBase(object):
    __slots__ = "_buffer", "_offset",

    def __init__(self, buffer, offset):
        self._buffer = buffer
        self._offset = offset

    # Get the field offset
    @property
    def fbe_offset(self):
        return self._offset

    # Set the field offset
    @fbe_offset.setter
    def fbe_offset(self, offset):
        self._offset = offset

    # Get the field size
    @property
    def fbe_size(self):
        return 0

    # Get the field extra size
    @property
    def fbe_extra(self):
        return 0

    # Shift the current field offset
    def fbe_shift(self, offset):
        self._offset += offset

    # Unshift the current field offset
    def fbe_unshift(self, offset):
        self._offset -= offset

    # Buffer I/O methods

    def read_bool(self, offset):
        return struct.unpack_from("<?", self._buffer.buffer, self._buffer.offset + offset)[0]

    def read_byte(self, offset):
        return struct.unpack_from("<B", self._buffer.buffer, self._buffer.offset + offset)[0]

    def read_char(self, offset):
        return chr(struct.unpack_from("<B", self._buffer.buffer, self._buffer.offset + offset)[0])

    def read_wchar(self, offset):
        return chr(struct.unpack_from("<I", self._buffer.buffer, self._buffer.offset + offset)[0])

    def read_int8(self, offset):
        return struct.unpack_from("<b", self._buffer.buffer, self._buffer.offset + offset)[0]

    def read_uint8(self, offset):
        return struct.unpack_from("<B", self._buffer.buffer, self._buffer.offset + offset)[0]

    def read_int16(self, offset):
        return struct.unpack_from("<h", self._buffer.buffer, self._buffer.offset + offset)[0]

    def read_uint16(self, offset):
        return struct.unpack_from("<H", self._buffer.buffer, self._buffer.offset + offset)[0]

    def read_int32(self, offset):
        return struct.unpack_from("<i", self._buffer.buffer, self._buffer.offset + offset)[0]

    def read_uint32(self, offset):
        return struct.unpack_from("<I", self._buffer.buffer, self._buffer.offset + offset)[0]

    def read_int64(self, offset):
        return struct.unpack_from("<q", self._buffer.buffer, self._buffer.offset + offset)[0]

    def read_uint64(self, offset):
        return struct.unpack_from("<Q", self._buffer.buffer, self._buffer.offset + offset)[0]

    def read_uint64_be(self, offset):
        return struct.unpack_from(">Q", self._buffer.buffer, self._buffer.offset + offset)[0]

    def read_float(self, offset):
        return struct.unpack_from("<f", self._buffer.buffer, self._buffer.offset + offset)[0]

    def read_double(self, offset):
        return struct.unpack_from("<d", self._buffer.buffer, self._buffer.offset + offset)[0]

    def read_bytes(self, offset, size):
        return self._buffer.buffer[self._buffer.offset + offset:self._buffer.offset + offset + size]

    def read_uuid(self, offset):
        return uuid.UUID(int=((self.read_uint64_be(offset) << 64) | self.read_uint64_be(offset + 8)))

    def write_bool(self, offset, value):
        struct.pack_into("<?", self._buffer.buffer, self._buffer.offset + offset, value)

    def write_byte(self, offset, value):
        struct.pack_into("<B", self._buffer.buffer, self._buffer.offset + offset, value)

    def write_char(self, offset, value):
        struct.pack_into("<B", self._buffer.buffer, self._buffer.offset + offset, ord(value))

    def write_wchar(self, offset, value):
        struct.pack_into("<I", self._buffer.buffer, self._buffer.offset + offset, ord(value))

    def write_int8(self, offset, value):
        struct.pack_into("<b", self._buffer.buffer, self._buffer.offset + offset, value)

    def write_uint8(self, offset, value):
        struct.pack_into("<B", self._buffer.buffer, self._buffer.offset + offset, value)

    def write_int16(self, offset, value):
        struct.pack_into("<h", self._buffer.buffer, self._buffer.offset + offset, value)

    def write_uint16(self, offset, value):
        struct.pack_into("<H", self._buffer.buffer, self._buffer.offset + offset, value)

    def write_int32(self, offset, value):
        struct.pack_into("<i", self._buffer.buffer, self._buffer.offset + offset, value)

    def write_uint32(self, offset, value):
        struct.pack_into("<I", self._buffer.buffer, self._buffer.offset + offset, value)

    def write_int64(self, offset, value):
        struct.pack_into("<q", self._buffer.buffer, self._buffer.offset + offset, value)

    def write_uint64(self, offset, value):
        struct.pack_into("<Q", self._buffer.buffer, self._buffer.offset + offset, value)

    def write_float(self, offset, value):
        struct.pack_into("<f", self._buffer.buffer, self._buffer.offset + offset, value)

    def write_double(self, offset, value):
        struct.pack_into("<d", self._buffer.buffer, self._buffer.offset + offset, value)

    def write_bytes(self, offset, buffer):
        self._buffer.buffer[self._buffer.offset + offset:self._buffer.offset + offset + len(buffer)] = buffer

    def write_count(self, offset, value, value_count):
        for i in range(value_count):
            self._buffer.buffer[self._buffer.offset + offset + i] = value

    def write_uuid(self, offset, value):
        self._buffer.buffer[self._buffer.offset + offset:self._buffer.offset + offset + 16] = value.bytes


# Fast Binary Encoding field model
class FieldModel(FieldModelBase):
    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)

    # Check if the value is valid
    def verify(self):
        return True


# Fast Binary Encoding bool field model
class FieldModelBool(FieldModel):
    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)

    # Get the field size
    @property
    def fbe_size(self):
        return 1

    # Get the value
    def get(self, defaults=None):
        if defaults is None:
            defaults = False

        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return defaults

        return self.read_bool(self.fbe_offset)

    # Set the value
    def set(self, value):
        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return

        self.write_bool(self.fbe_offset, value)


# Fast Binary Encoding byte field model
class FieldModelByte(FieldModel):
    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)

    # Get the field size
    @property
    def fbe_size(self):
        return 1

    # Get the value
    def get(self, defaults=None):
        if defaults is None:
            defaults = 0

        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return defaults

        return self.read_byte(self.fbe_offset)

    # Set the value
    def set(self, value):
        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return

        self.write_byte(self.fbe_offset, value)


# Fast Binary Encoding char field model
class FieldModelChar(FieldModel):
    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)

    # Get the field size
    @property
    def fbe_size(self):
        return 1

    # Get the value
    def get(self, defaults=None):
        if defaults is None:
            defaults = '\0'

        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return defaults

        return self.read_char(self.fbe_offset)

    # Set the value
    def set(self, value):
        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return

        self.write_char(self.fbe_offset, value)


# Fast Binary Encoding wchar field model
class FieldModelWChar(FieldModel):
    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)

    # Get the field size
    @property
    def fbe_size(self):
        return 4

    # Get the value
    def get(self, defaults=None):
        if defaults is None:
            defaults = '\0'

        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return defaults

        return self.read_wchar(self.fbe_offset)

    # Set the value
    def set(self, value):
        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return

        self.write_wchar(self.fbe_offset, value)


# Fast Binary Encoding int8 field model
class FieldModelInt8(FieldModel):
    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)

    # Get the field size
    @property
    def fbe_size(self):
        return 1

    # Get the value
    def get(self, defaults=None):
        if defaults is None:
            defaults = 0

        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return defaults

        return self.read_int8(self.fbe_offset)

    # Set the value
    def set(self, value):
        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return

        self.write_int8(self.fbe_offset, value)


# Fast Binary Encoding uint8 field model
class FieldModelUInt8(FieldModel):
    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)

    # Get the field size
    @property
    def fbe_size(self):
        return 1

    # Get the value
    def get(self, defaults=None):
        if defaults is None:
            defaults = 0

        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return defaults

        return self.read_uint8(self.fbe_offset)

    # Set the value
    def set(self, value):
        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return

        self.write_uint8(self.fbe_offset, value)


# Fast Binary Encoding int16 field model
class FieldModelInt16(FieldModel):
    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)

    # Get the field size
    @property
    def fbe_size(self):
        return 2

    # Get the value
    def get(self, defaults=None):
        if defaults is None:
            defaults = 0

        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return defaults

        return self.read_int16(self.fbe_offset)

    # Set the value
    def set(self, value):
        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return

        self.write_int16(self.fbe_offset, value)


# Fast Binary Encoding uint16 field model
class FieldModelUInt16(FieldModel):
    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)

    # Get the field size
    @property
    def fbe_size(self):
        return 2

    # Get the value
    def get(self, defaults=None):
        if defaults is None:
            defaults = 0

        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return defaults

        return self.read_uint16(self.fbe_offset)

    # Set the value
    def set(self, value):
        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return

        self.write_uint16(self.fbe_offset, value)


# Fast Binary Encoding int32 field model
class FieldModelInt32(FieldModel):
    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)

    # Get the field size
    @property
    def fbe_size(self):
        return 4

    # Get the value
    def get(self, defaults=None):
        if defaults is None:
            defaults = 0

        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return defaults

        return self.read_int32(self.fbe_offset)

    # Set the value
    def set(self, value):
        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return

        self.write_int32(self.fbe_offset, value)


# Fast Binary Encoding uint32 field model
class FieldModelUInt32(FieldModel):
    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)

    # Get the field size
    @property
    def fbe_size(self):
        return 4

    # Get the value
    def get(self, defaults=None):
        if defaults is None:
            defaults = 0

        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return defaults

        return self.read_uint32(self.fbe_offset)

    # Set the value
    def set(self, value):
        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return

        self.write_uint32(self.fbe_offset, value)


# Fast Binary Encoding int64 field model
class FieldModelInt64(FieldModel):
    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)

    # Get the field size
    @property
    def fbe_size(self):
        return 8

    # Get the value
    def get(self, defaults=None):
        if defaults is None:
            defaults = 0

        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return defaults

        return self.read_int64(self.fbe_offset)

    # Set the value
    def set(self, value):
        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return

        self.write_int64(self.fbe_offset, value)


# Fast Binary Encoding uint64 field model
class FieldModelUInt64(FieldModel):
    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)

    # Get the field size
    @property
    def fbe_size(self):
        return 8

    # Get the value
    def get(self, defaults=None):
        if defaults is None:
            defaults = 0

        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return defaults

        return self.read_uint64(self.fbe_offset)

    # Set the value
    def set(self, value):
        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return

        self.write_uint64(self.fbe_offset, value)


# Fast Binary Encoding float field model
class FieldModelFloat(FieldModel):
    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)

    # Get the field size
    @property
    def fbe_size(self):
        return 4

    # Get the value
    def get(self, defaults=None):
        if defaults is None:
            defaults = 0.0

        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return defaults

        return self.read_float(self.fbe_offset)

    # Set the value
    def set(self, value):
        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return

        self.write_float(self.fbe_offset, value)


# Fast Binary Encoding double field model
class FieldModelDouble(FieldModel):
    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)

    # Get the field size
    @property
    def fbe_size(self):
        return 8

    # Get the value
    def get(self, defaults=None):
        if defaults is None:
            defaults = 0.0

        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return defaults

        return self.read_double(self.fbe_offset)

    # Set the value
    def set(self, value):
        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return

        self.write_double(self.fbe_offset, value)


# Fast Binary Encoding uint64 field model
class FieldModelTimestamp(FieldModel):
    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)

    # Get the field size
    @property
    def fbe_size(self):
        return 8

    # Get the value
    def get(self, defaults=None):
        if defaults is None:
            defaults = 0

        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return defaults

        return self.read_uint64(self.fbe_offset)

    # Set the value
    def set(self, value):
        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return

        self.write_uint64(self.fbe_offset, value)


# Fast Binary Encoding uuid field model
class FieldModelUUID(FieldModel):
    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)

    # Get the field size
    @property
    def fbe_size(self):
        return 16

    # Get the value
    def get(self, defaults=None):
        if defaults is None:
            defaults = uuid.UUID(int=0)

        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return defaults

        return self.read_uuid(self.fbe_offset)

    # Set the value
    def set(self, value):
        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return

        self.write_uuid(self.fbe_offset, value)


# Fast Binary Encoding decimal field model
class FieldModelDecimal(FieldModel):
    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)

    # Get the field size
    @property
    def fbe_size(self):
        return 16

    # Get the decimal value
    def get(self, defaults=None):
        if defaults is None:
            defaults = decimal.Decimal(0)

        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return defaults

        # Read decimal parts
        low = self.read_uint32(self.fbe_offset)
        mid = self.read_uint32(self.fbe_offset + 4)
        high = self.read_uint32(self.fbe_offset + 8)
        flags = self.read_uint32(self.fbe_offset + 12)

        # Calculate decimal value
        negative = (flags & 0x80000000) != 0
        scale = (flags & 0x7FFFFFFF) >> 16
        result = decimal.Decimal(high) * 18446744073709551616
        result += decimal.Decimal(mid) * 4294967296
        result += decimal.Decimal(low)
        result /= pow(10, scale)
        if negative:
            result = -result

        return result

    # Set the decimal value
    def set(self, value):
        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return

        # Extract decimal parts
        parts = value.as_tuple()
        negative = True if parts.sign == 1 else False
        number = int(''.join(map(str, parts.digits)))
        scale = -parts.exponent

        # Check for decimal number overflow
        bits = number.bit_length()
        if (bits < 0) or (bits > 96):
            # Value too big for .NET Decimal (bit length is limited to [0, 96])
            self.write_count(self.fbe_offset, 0, self.fbe_size)
            return

        # Check for decimal scale overflow
        if (scale < 0) or (scale > 28):
            # Value scale exceeds .NET Decimal limit of [0, 28]
            self.write_count(self.fbe_offset, 0, self.fbe_size)
            return

        # Write unscaled value to bytes 0-11
        self.write_bytes(self.fbe_offset, number.to_bytes(12, "little"))

        # Write scale at byte 14
        self.write_byte(self.fbe_offset + 14, scale)

        # Write signum at byte 15
        self.write_byte(self.fbe_offset + 15, 0x80 if negative else 0)


# Fast Binary Encoding bytes field model
class FieldModelBytes(FieldModel):
    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)

    # Get the field size
    @property
    def fbe_size(self):
        return 4

    # Get the field extra size
    @property
    def fbe_extra(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        fbe_bytes_offset = self.read_uint32(self.fbe_offset)
        if (fbe_bytes_offset == 0) or ((self._buffer.offset + fbe_bytes_offset + 4) > self._buffer.size):
            return 0

        fbe_bytes_size = self.read_uint32(fbe_bytes_offset)
        return 4 + fbe_bytes_size

    # Check if the bytes value is valid
    def verify(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return True

        fbe_bytes_offset = self.read_uint32(self.fbe_offset)
        if fbe_bytes_offset == 0:
            return True

        if (self._buffer.offset + fbe_bytes_offset + 4) > self._buffer.size:
            return False

        fbe_bytes_size = self.read_uint32(fbe_bytes_offset)
        if (self._buffer.offset + fbe_bytes_offset + 4 + fbe_bytes_size) > self._buffer.size:
            return False

        return True

    # Get the bytes value
    def get(self, defaults=None):
        if defaults is None:
            defaults = bytearray()

        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return defaults

        fbe_bytes_offset = self.read_uint32(self.fbe_offset)
        if fbe_bytes_offset == 0:
            return defaults

        assert ((self._buffer.offset + fbe_bytes_offset + 4) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + fbe_bytes_offset + 4) > self._buffer.size:
            return defaults

        fbe_bytes_size = self.read_uint32(fbe_bytes_offset)
        assert ((self._buffer.offset + fbe_bytes_offset + 4 + fbe_bytes_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + fbe_bytes_offset + 4 + fbe_bytes_size) > self._buffer.size:
            return defaults

        return self.read_bytes(fbe_bytes_offset + 4, fbe_bytes_size)

    # Set the bytes value
    def set(self, value):
        assert (value is not None), "Invalid bytes value!"
        if value is None:
            raise ValueError("Invalid bytes value!")

        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return

        fbe_bytes_size = len(value)
        fbe_bytes_offset = self._buffer.allocate(4 + fbe_bytes_size) - self._buffer.offset
        assert ((fbe_bytes_offset > 0) and ((self._buffer.offset + fbe_bytes_offset + 4 + fbe_bytes_size) <= self._buffer.size)), "Model is broken!"
        if (fbe_bytes_offset <= 0) or ((self._buffer.offset + fbe_bytes_offset + 4 + fbe_bytes_size) > self._buffer.size):
            return

        self.write_uint32(self.fbe_offset, fbe_bytes_offset)
        self.write_uint32(fbe_bytes_offset, fbe_bytes_size)
        self.write_bytes(fbe_bytes_offset + 4, value)


# Fast Binary Encoding string field model
class FieldModelString(FieldModel):
    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)

    # Get the field size
    @property
    def fbe_size(self):
        return 4

    # Get the field extra size
    @property
    def fbe_extra(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        fbe_string_offset = self.read_uint32(self.fbe_offset)
        if (fbe_string_offset == 0) or ((self._buffer.offset + fbe_string_offset + 4) > self._buffer.size):
            return 0

        fbe_string_size = self.read_uint32(fbe_string_offset)
        return 4 + fbe_string_size

    # Check if the string value is valid
    def verify(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return True

        fbe_string_offset = self.read_uint32(self.fbe_offset)
        if fbe_string_offset == 0:
            return True

        if (self._buffer.offset + fbe_string_offset + 4) > self._buffer.size:
            return False

        fbe_string_size = self.read_uint32(fbe_string_offset)
        if (self._buffer.offset + fbe_string_offset + 4 + fbe_string_size) > self._buffer.size:
            return False

        return True

    # Get the string value
    def get(self, defaults=None):
        if defaults is None:
            defaults = ""

        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return defaults

        fbe_string_offset = self.read_uint32(self.fbe_offset)
        if fbe_string_offset == 0:
            return defaults

        assert ((self._buffer.offset + fbe_string_offset + 4) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + fbe_string_offset + 4) > self._buffer.size:
            return defaults

        fbe_string_size = self.read_uint32(fbe_string_offset)
        assert ((self._buffer.offset + fbe_string_offset + 4 + fbe_string_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + fbe_string_offset + 4 + fbe_string_size) > self._buffer.size:
            return defaults

        data = self.read_bytes(fbe_string_offset + 4, fbe_string_size)
        return data.decode("utf-8")

    # Set the string value
    def set(self, value):
        assert (value is not None), "Invalid string value!"
        if value is None:
            raise ValueError("Invalid string value!")

        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return

        data = value.encode("utf-8")

        fbe_string_size = len(data)
        fbe_string_offset = self._buffer.allocate(4 + fbe_string_size) - self._buffer.offset
        assert ((fbe_string_offset > 0) and ((self._buffer.offset + fbe_string_offset + 4 + fbe_string_size) <= self._buffer.size)), "Model is broken!"
        if (fbe_string_offset <= 0) or ((self._buffer.offset + fbe_string_offset + 4 + fbe_string_size) > self._buffer.size):
            return

        self.write_uint32(self.fbe_offset, fbe_string_offset)
        self.write_uint32(fbe_string_offset, fbe_string_size)
        self.write_bytes(fbe_string_offset + 4, data)


# Fast Binary Encoding optional field model
class FieldModelOptional(FieldModel):
    __slots__ = "_model",

    def __init__(self, model, buffer, offset):
        super().__init__(buffer, offset)
        self._model = model
        self._model.fbe_offset = 0

    # Get the field size
    @property
    def fbe_size(self):
        return 1 + 4

    # Get the field extra size
    @property
    def fbe_extra(self):
        if not self.has_value:
            return 0

        fbe_optional_offset = self.read_uint32(self.fbe_offset + 1)
        if (fbe_optional_offset == 0) or ((self._buffer.offset + fbe_optional_offset + 4) > self._buffer.size):
            return 0

        self._buffer.shift(fbe_optional_offset)
        fbe_result = self.value.fbe_size + self.value.fbe_extra
        self._buffer.unshift(fbe_optional_offset)
        return fbe_result

    # Checks if the object contains a value
    def __bool__(self):
        return self.has_value()

    # Checks if the object contains a value
    @property
    def has_value(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return False

        fbe_has_value = self.read_uint8(self.fbe_offset)
        return fbe_has_value != 0

    # Get the base field model value
    @property
    def value(self):
        return self._model

    # Check if the optional value is valid
    def verify(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return True

        fbe_has_value = self.read_uint8(self.fbe_offset)
        if fbe_has_value == 0:
            return True

        fbe_optional_offset = self.read_uint32(self.fbe_offset + 1)
        if fbe_optional_offset == 0:
            return False

        self._buffer.shift(fbe_optional_offset)
        fbe_result = self.value.verify()
        self._buffer.unshift(fbe_optional_offset)
        return fbe_result

    # Get the optional value (being phase)
    def get_begin(self):
        if not self.has_value:
            return 0

        fbe_optional_offset = self.read_uint32(self.fbe_offset + 1)
        assert (fbe_optional_offset > 0), "Model is broken!"
        if fbe_optional_offset <= 0:
            return 0

        self._buffer.shift(fbe_optional_offset)
        return fbe_optional_offset

    # Get the optional value (end phase)
    def get_end(self, fbe_begin):
        self._buffer.unshift(fbe_begin)

    # Get the optional value
    def get(self, defaults=None):
        fbe_begin = self.get_begin()
        if fbe_begin == 0:
            return defaults
        optional = self.value.get()
        self.get_end(fbe_begin)
        return optional

    # Set the optional value (begin phase)
    def set_begin(self, has_value):
        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        fbe_has_value = 1 if has_value else 0
        self.write_uint8(self.fbe_offset, fbe_has_value)
        if fbe_has_value == 0:
            return 0

        fbe_optional_size = self.value.fbe_size
        fbe_optional_offset = self._buffer.allocate(fbe_optional_size) - self._buffer.offset
        assert ((fbe_optional_offset > 0) and ((self._buffer.offset + fbe_optional_offset + fbe_optional_size) <= self._buffer.size)), "Model is broken!"
        if (fbe_optional_offset <= 0) or ((self._buffer.offset + fbe_optional_offset + fbe_optional_size) > self._buffer.size):
            return 0

        self.write_uint32(self.fbe_offset + 1, fbe_optional_offset)

        self._buffer.shift(fbe_optional_offset)
        return fbe_optional_offset

    # Set the optional value (end phase)
    def set_end(self, fbe_begin):
        self._buffer.unshift(fbe_begin)

    # Set the optional value
    def set(self, optional):
        fbe_begin = self.set_begin(optional is not None)
        if fbe_begin == 0:
            return
        self.value.set(optional)
        self.set_end(fbe_begin)


# Fast Binary Encoding array field model
class FieldModelArray(FieldModel):
    __slots__ = "_model", "_size",

    def __init__(self, model, buffer, offset, size):
        super().__init__(buffer, offset)
        self._model = model
        self._size = size

    # Get the field size
    @property
    def fbe_size(self):
        return self._size * self._model.fbe_size

    # Get the field extra size
    @property
    def fbe_extra(self):
        return 0

    # Get the array offset
    @property
    def offset(self):
        return 0

    # Get the array size
    @property
    def size(self):
        return self._size

    # Array index operator
    def __getitem__(self, index):
        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        assert (index < self._size), "Index is out of bounds!"
        if index >= self._size:
            raise IndexError("Index is out of bounds!")

        self._model.fbe_offset = self.fbe_offset
        self._model.fbe_shift(index * self._model.fbe_size)
        return self._model

    # Check if the array is valid
    def verify(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return False

        self._model.fbe_offset = self.fbe_offset
        for i in range(self._size):
            if not self._model.verify():
                return False
            self._model.fbe_shift(self._model.fbe_size)

        return True

    # Get the array
    def get(self, values=None):
        if values is None:
            values = list()

        values.clear()

        fbe_model = self[0]
        for i in range(self._size):
            value = fbe_model.get()
            values.append(value)
            fbe_model.fbe_shift(fbe_model.fbe_size)

        return values

    # Set the array
    def set(self, values):
        assert (values is not None), "Invalid values parameter!"
        if values is None:
            raise ValueError("Invalid values parameter!")

        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return

        fbe_model = self[0]
        for i in range(min(len(values), self._size)):
            fbe_model.set(values[i])
            fbe_model.fbe_shift(fbe_model.fbe_size)


# Fast Binary Encoding vector field model
class FieldModelVector(FieldModel):
    __slots__ = "_model",

    def __init__(self, model, buffer, offset):
        super().__init__(buffer, offset)
        self._model = model

    # Get the field size
    @property
    def fbe_size(self):
        return 4

    # Get the field extra size
    @property
    def fbe_extra(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        fbe_vector_offset = self.read_uint32(self.fbe_offset)
        if (fbe_vector_offset == 0) or ((self._buffer.offset + fbe_vector_offset + 4) > self._buffer.size):
            return 0

        fbe_vector_size = self.read_uint32(fbe_vector_offset)

        fbe_result = 4
        self._model.fbe_offset = fbe_vector_offset + 4
        for i in range(fbe_vector_size):
            fbe_result += self._model.fbe_size + self._model.fbe_extra
            self._model.fbe_shift(self._model.fbe_size)
        return fbe_result

    # Get the vector offset
    @property
    def offset(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        fbe_vector_offset = self.read_uint32(self.fbe_offset)
        return fbe_vector_offset

    # Get the vector size
    @property
    def size(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        fbe_vector_offset = self.read_uint32(self.fbe_offset)
        if (fbe_vector_offset == 0) or ((self._buffer.offset + fbe_vector_offset + 4) > self._buffer.size):
            return 0

        fbe_vector_size = self.read_uint32(fbe_vector_offset)
        return fbe_vector_size

    # Vector index operator
    def __getitem__(self, index):
        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"

        fbe_vector_offset = self.read_uint32(self.fbe_offset)
        assert ((fbe_vector_offset > 0) and ((self._buffer.offset + fbe_vector_offset + 4) <= self._buffer.size)), "Model is broken!"

        fbe_vector_size = self.read_uint32(fbe_vector_offset)
        assert (index < fbe_vector_size), "Index is out of bounds!"
        if index >= fbe_vector_size:
            raise IndexError("Index is out of bounds!")

        self._model.fbe_offset = fbe_vector_offset + 4
        self._model.fbe_shift(index * self._model.fbe_size)
        return self._model

    # Resize the vector and get its first model
    def resize(self, size):
        fbe_vector_size = size * self._model.fbe_size
        fbe_vector_offset = self._buffer.allocate(4 + fbe_vector_size) - self._buffer.offset
        assert ((fbe_vector_offset > 0) and ((self._buffer.offset + fbe_vector_offset + 4) <= self._buffer.size)), "Model is broken!"

        self.write_uint32(self.fbe_offset, fbe_vector_offset)
        self.write_uint32(fbe_vector_offset, size)
        self.write_count(fbe_vector_offset + 4, 0, fbe_vector_size)

        self._model.fbe_offset = fbe_vector_offset + 4
        return self._model

    # Check if the vector is valid
    def verify(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return True

        fbe_vector_offset = self.read_uint32(self.fbe_offset)
        if fbe_vector_offset == 0:
            return True

        if (self._buffer.offset + fbe_vector_offset + 4) > self._buffer.size:
            return False

        fbe_vector_size = self.read_uint32(fbe_vector_offset)

        self._model.fbe_offset = fbe_vector_offset + 4
        for i in range(fbe_vector_size):
            if not self._model.verify():
                return False
            self._model.fbe_shift(self._model.fbe_size)

        return True

    # Get the vector
    def get(self, values=None):
        if values is None:
            values = list()

        values.clear()

        fbe_vector_size = self.size
        if fbe_vector_size == 0:
            return values

        fbe_model = self[0]
        for i in range(fbe_vector_size):
            value = fbe_model.get()
            values.append(value)
            fbe_model.fbe_shift(fbe_model.fbe_size)

        return values

    # Set the vector
    def set(self, values):
        assert (values is not None), "Invalid values parameter!"
        if values is None:
            raise ValueError("Invalid values parameter!")

        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return

        fbe_model = self.resize(len(values))
        for value in values:
            fbe_model.set(value)
            fbe_model.fbe_shift(fbe_model.fbe_size)


# Fast Binary Encoding set field model
class FieldModelSet(FieldModel):
    __slots__ = "_model",

    def __init__(self, model, buffer, offset):
        super().__init__(buffer, offset)
        self._model = model

    # Get the field size
    @property
    def fbe_size(self):
        return 4

    # Get the field extra size
    @property
    def fbe_extra(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        fbe_set_offset = self.read_uint32(self.fbe_offset)
        if (fbe_set_offset == 0) or ((self._buffer.offset + fbe_set_offset + 4) > self._buffer.size):
            return 0

        fbe_set_size = self.read_uint32(fbe_set_offset)

        fbe_result = 4
        self._model.fbe_offset = fbe_set_offset + 4
        for i in range(fbe_set_size):
            fbe_result += self._model.fbe_size + self._model.fbe_extra
            self._model.fbe_shift(self._model.fbe_size)
        return fbe_result

    # Get the set value offset
    @property
    def offset(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        fbe_set_offset = self.read_uint32(self.fbe_offset)
        return fbe_set_offset

    # Get the set value size
    @property
    def size(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        fbe_set_offset = self.read_uint32(self.fbe_offset)
        if (fbe_set_offset == 0) or ((self._buffer.offset + fbe_set_offset + 4) > self._buffer.size):
            return 0

        fbe_set_size = self.read_uint32(fbe_set_offset)
        return fbe_set_size

    # Set index operator
    def __getitem__(self, index):
        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"

        fbe_set_offset = self.read_uint32(self.fbe_offset)
        assert ((fbe_set_offset > 0) and ((self._buffer.offset + fbe_set_offset + 4) <= self._buffer.size)), "Model is broken!"

        fbe_set_size = self.read_uint32(fbe_set_offset)
        assert (index < fbe_set_size), "Index is out of bounds!"
        if index >= fbe_set_size:
            raise IndexError("Index is out of bounds!")

        self._model.fbe_offset = fbe_set_offset + 4
        self._model.fbe_shift(index * self._model.fbe_size)
        return self._model

    # Resize the set and get its first model
    def resize(self, size):
        fbe_set_size = size * self._model.fbe_size
        fbe_set_offset = self._buffer.allocate(4 + fbe_set_size) - self._buffer.offset
        assert ((fbe_set_offset > 0) and ((self._buffer.offset + fbe_set_offset + 4) <= self._buffer.size)), "Model is broken!"

        self.write_uint32(self.fbe_offset, fbe_set_offset)
        self.write_uint32(fbe_set_offset, size)
        self.write_count(fbe_set_offset + 4, 0, fbe_set_size)

        self._model.fbe_offset = fbe_set_offset + 4
        return self._model

    # Check if the set value is valid
    def verify(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return True

        fbe_set_offset = self.read_uint32(self.fbe_offset)
        if fbe_set_offset == 0:
            return True

        if (self._buffer.offset + fbe_set_offset + 4) > self._buffer.size:
            return False

        fbe_set_size = self.read_uint32(fbe_set_offset)

        self._model.fbe_offset = fbe_set_offset + 4
        for i in range(fbe_set_size):
            if not self._model.verify():
                return False
            self._model.fbe_shift(self._model.fbe_size)

        return True

    # Get the set value
    def get(self, values=None):
        if values is None:
            values = set()

        values.clear()

        fbe_set_size = self.size
        if fbe_set_size == 0:
            return values

        fbe_model = self[0]
        for i in range(fbe_set_size):
            value = fbe_model.get()
            values.add(value)
            fbe_model.fbe_shift(fbe_model.fbe_size)

        return values

    # Set the set value
    def set(self, values):
        assert (values is not None), "Invalid values parameter!"
        if values is None:
            raise ValueError("Invalid values parameter!")

        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return

        fbe_model = self.resize(len(values))
        for value in values:
            fbe_model.set(value)
            fbe_model.fbe_shift(fbe_model.fbe_size)


# Fast Binary Encoding map field model
class FieldModelMap(FieldModel):
    __slots__ = "_model_key", "_model_value",

    def __init__(self, model_key, model_value, buffer, offset):
        super().__init__(buffer, offset)
        self._model_key = model_key
        self._model_value = model_value

    # Get the field size
    @property
    def fbe_size(self):
        return 4

    # Get the field extra size
    @property
    def fbe_extra(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        fbe_map_offset = self.read_uint32(self.fbe_offset)
        if (fbe_map_offset == 0) or ((self._buffer.offset + fbe_map_offset + 4) > self._buffer.size):
            return 0

        fbe_map_size = self.read_uint32(fbe_map_offset)

        fbe_result = 4
        self._model_key.fbe_offset = fbe_map_offset + 4
        self._model_value.fbe_offset = fbe_map_offset + 4 + self._model_key.fbe_size
        for i in range(fbe_map_size):
            fbe_result += self._model_key.fbe_size + self._model_key.fbe_extra
            self._model_key.fbe_shift(self._model_key.fbe_size + self._model_value.fbe_size)
            fbe_result += self._model_value.fbe_size + self._model_value.fbe_extra
            self._model_value.fbe_shift(self._model_key.fbe_size + self._model_value.fbe_size)
        return fbe_result

    # Get the map offset
    @property
    def offset(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        fbe_map_offset = self.read_uint32(self.fbe_offset)
        return fbe_map_offset

    # Get the map size
    @property
    def size(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        fbe_map_offset = self.read_uint32(self.fbe_offset)
        if (fbe_map_offset == 0) or ((self._buffer.offset + fbe_map_offset + 4) > self._buffer.size):
            return 0

        fbe_map_size = self.read_uint32(fbe_map_offset)
        return fbe_map_size

    # Map index operator
    def __getitem__(self, index):
        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"

        fbe_map_offset = self.read_uint32(self.fbe_offset)
        assert ((fbe_map_offset > 0) and ((self._buffer.offset + fbe_map_offset + 4) <= self._buffer.size)), "Model is broken!"

        fbe_map_size = self.read_uint32(fbe_map_offset)
        assert (index < fbe_map_size), "Index is out of bounds!"
        if index >= fbe_map_size:
            raise IndexError("Index is out of bounds!")

        self._model_key.fbe_offset = fbe_map_offset + 4
        self._model_value.fbe_offset = fbe_map_offset + 4 + self._model_key.fbe_size
        self._model_key.fbe_shift(index * (self._model_key.fbe_size + self._model_value.fbe_size))
        self._model_value.fbe_shift(index * (self._model_key.fbe_size + self._model_value.fbe_size))
        return self._model_key, self._model_value

    # Resize the map and get its first model
    def resize(self, size):
        fbe_map_size = size * (self._model_key.fbe_size + self._model_value.fbe_size)
        fbe_map_offset = self._buffer.allocate(4 + fbe_map_size) - self._buffer.offset
        assert ((fbe_map_offset > 0) and ((self._buffer.offset + fbe_map_offset + 4) <= self._buffer.size)), "Model is broken!"

        self.write_uint32(self.fbe_offset, fbe_map_offset)
        self.write_uint32(fbe_map_offset, size)
        self.write_count(fbe_map_offset + 4, 0, fbe_map_size)

        self._model_key.fbe_offset = fbe_map_offset + 4
        self._model_value.fbe_offset = fbe_map_offset + 4 + self._model_key.fbe_size
        return self._model_key, self._model_value

    # Check if the map is valid
    def verify(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return True

        fbe_map_offset = self.read_uint32(self.fbe_offset)
        if fbe_map_offset == 0:
            return True

        if (self._buffer.offset + fbe_map_offset + 4) > self._buffer.size:
            return False

        fbe_map_size = self.read_uint32(fbe_map_offset)

        self._model_key.fbe_offset = fbe_map_offset + 4
        self._model_value.fbe_offset = fbe_map_offset + 4 + self._model_key.fbe_size
        for i in range(fbe_map_size):
            if not self._model_key.verify():
                return False
            self._model_key.fbe_shift(self._model_key.fbe_size + self._model_value.fbe_size)
            if not self._model_value.verify():
                return False
            self._model_value.fbe_shift(self._model_key.fbe_size + self._model_value.fbe_size)

        return True

    # Get the map
    def get(self, values=None):
        if values is None:
            values = dict()

        values.clear()

        fbe_map_size = self.size
        if fbe_map_size == 0:
            return values

        (fbe_model_key, fbe_model_value) = self[0]
        for i in range(fbe_map_size):
            key = fbe_model_key.get()
            value = fbe_model_value.get()
            values[key] = value
            fbe_model_key.fbe_shift(fbe_model_key.fbe_size + fbe_model_value.fbe_size)
            fbe_model_value.fbe_shift(fbe_model_key.fbe_size + fbe_model_value.fbe_size)

        return values

    # Set the map
    def set(self, values):
        assert (values is not None), "Invalid values parameter!"
        if values is None:
            raise ValueError("Invalid values parameter!")

        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return

        (fbe_model_key, fbe_model_value) = self.resize(len(values))
        for (key, value) in values.items():
            fbe_model_key.set(key)
            fbe_model_key.fbe_shift(fbe_model_key.fbe_size + fbe_model_value.fbe_size)
            fbe_model_value.set(value)
            fbe_model_value.fbe_shift(fbe_model_key.fbe_size + fbe_model_value.fbe_size)


# Fast Binary Encoding final model
class FinalModel(FieldModelBase):
    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)

    # Check if the value is valid
    def verify(self):
        raise NotImplementedError("verify() method not implemented!")


# Fast Binary Encoding bool final model
class FinalModelBool(FinalModel):
    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)

    # Get the allocation size
    # noinspection PyUnusedLocal
    def fbe_allocation_size(self, value):
        return self.fbe_size

    # Get the final size
    @property
    def fbe_size(self):
        return 1

    # Check if the value is valid
    def verify(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return sys.maxsize

        return self.fbe_size

    # Get the value
    def get(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return False, 0

        return self.read_bool(self.fbe_offset), self.fbe_size

    # Set the value
    def set(self, value):
        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        self.write_bool(self.fbe_offset, value)
        return self.fbe_size


# Fast Binary Encoding byte final model
class FinalModelByte(FinalModel):
    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)

    # Get the allocation size
    # noinspection PyUnusedLocal
    def fbe_allocation_size(self, value):
        return self.fbe_size

    # Get the final size
    @property
    def fbe_size(self):
        return 1

    # Check if the value is valid
    def verify(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return sys.maxsize

        return self.fbe_size

    # Get the value
    def get(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0, 0

        return self.read_byte(self.fbe_offset), self.fbe_size

    # Set the value
    def set(self, value):
        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        self.write_byte(self.fbe_offset, value)
        return self.fbe_size


# Fast Binary Encoding char final model
class FinalModelChar(FinalModel):
    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)

    # Get the allocation size
    # noinspection PyUnusedLocal
    def fbe_allocation_size(self, value):
        return self.fbe_size

    # Get the final size
    @property
    def fbe_size(self):
        return 1

    # Check if the value is valid
    def verify(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return sys.maxsize

        return self.fbe_size

    # Get the value
    def get(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return '\0', 0

        return self.read_char(self.fbe_offset), self.fbe_size

    # Set the value
    def set(self, value):
        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        self.write_char(self.fbe_offset, value)
        return self.fbe_size


# Fast Binary Encoding wchar final model
class FinalModelWChar(FinalModel):
    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)

    # Get the allocation size
    # noinspection PyUnusedLocal
    def fbe_allocation_size(self, value):
        return self.fbe_size

    # Get the final size
    @property
    def fbe_size(self):
        return 4

    # Check if the value is valid
    def verify(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return sys.maxsize

        return self.fbe_size

    # Get the value
    def get(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return '\0', 0

        return self.read_wchar(self.fbe_offset), self.fbe_size

    # Set the value
    def set(self, value):
        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        self.write_wchar(self.fbe_offset, value)
        return self.fbe_size


# Fast Binary Encoding int8 final model
class FinalModelInt8(FinalModel):
    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)

    # Get the allocation size
    # noinspection PyUnusedLocal
    def fbe_allocation_size(self, value):
        return self.fbe_size

    # Get the final size
    @property
    def fbe_size(self):
        return 1

    # Check if the value is valid
    def verify(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return sys.maxsize

        return self.fbe_size

    # Get the value
    def get(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0, 0

        return self.read_int8(self.fbe_offset), self.fbe_size

    # Set the value
    def set(self, value):
        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        self.write_int8(self.fbe_offset, value)
        return self.fbe_size


# Fast Binary Encoding uint8 final model
class FinalModelUInt8(FinalModel):
    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)

    # Get the allocation size
    # noinspection PyUnusedLocal
    def fbe_allocation_size(self, value):
        return self.fbe_size

    # Get the final size
    @property
    def fbe_size(self):
        return 1

    # Check if the value is valid
    def verify(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return sys.maxsize

        return self.fbe_size

    # Get the value
    def get(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0, 0

        return self.read_uint8(self.fbe_offset), self.fbe_size

    # Set the value
    def set(self, value):
        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        self.write_uint8(self.fbe_offset, value)
        return self.fbe_size


# Fast Binary Encoding int16 final model
class FinalModelInt16(FinalModel):
    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)

    # Get the allocation size
    # noinspection PyUnusedLocal
    def fbe_allocation_size(self, value):
        return self.fbe_size

    # Get the final size
    @property
    def fbe_size(self):
        return 2

    # Check if the value is valid
    def verify(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return sys.maxsize

        return self.fbe_size

    # Get the value
    def get(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0, 0

        return self.read_int16(self.fbe_offset), self.fbe_size

    # Set the value
    def set(self, value):
        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        self.write_int16(self.fbe_offset, value)
        return self.fbe_size


# Fast Binary Encoding uint16 final model
class FinalModelUInt16(FinalModel):
    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)

    # Get the allocation size
    # noinspection PyUnusedLocal
    def fbe_allocation_size(self, value):
        return self.fbe_size

    # Get the final size
    @property
    def fbe_size(self):
        return 2

    # Check if the value is valid
    def verify(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return sys.maxsize

        return self.fbe_size

    # Get the value
    def get(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0, 0

        return self.read_uint16(self.fbe_offset), self.fbe_size

    # Set the value
    def set(self, value):
        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        self.write_uint16(self.fbe_offset, value)
        return self.fbe_size


# Fast Binary Encoding int32 final model
class FinalModelInt32(FinalModel):
    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)

    # Get the allocation size
    # noinspection PyUnusedLocal
    def fbe_allocation_size(self, value):
        return self.fbe_size

    # Get the final size
    @property
    def fbe_size(self):
        return 4

    # Check if the value is valid
    def verify(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return sys.maxsize

        return self.fbe_size

    # Get the value
    def get(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0, 0

        return self.read_int32(self.fbe_offset), self.fbe_size

    # Set the value
    def set(self, value):
        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        self.write_int32(self.fbe_offset, value)
        return self.fbe_size


# Fast Binary Encoding uint32 final model
class FinalModelUInt32(FinalModel):
    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)

    # Get the allocation size
    # noinspection PyUnusedLocal
    def fbe_allocation_size(self, value):
        return self.fbe_size

    # Get the final size
    @property
    def fbe_size(self):
        return 4

    # Check if the value is valid
    def verify(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return sys.maxsize

        return self.fbe_size

    # Get the value
    def get(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0, 0

        return self.read_uint32(self.fbe_offset), self.fbe_size

    # Set the value
    def set(self, value):
        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        self.write_uint32(self.fbe_offset, value)
        return self.fbe_size


# Fast Binary Encoding int64 final model
class FinalModelInt64(FinalModel):
    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)

    # Get the allocation size
    # noinspection PyUnusedLocal
    def fbe_allocation_size(self, value):
        return self.fbe_size

    # Get the final size
    @property
    def fbe_size(self):
        return 8

    # Check if the value is valid
    def verify(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return sys.maxsize

        return self.fbe_size

    # Get the value
    def get(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0, 0

        return self.read_int64(self.fbe_offset), self.fbe_size

    # Set the value
    def set(self, value):
        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        self.write_int64(self.fbe_offset, value)
        return self.fbe_size


# Fast Binary Encoding uint64 final model
class FinalModelUInt64(FinalModel):
    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)

    # Get the allocation size
    # noinspection PyUnusedLocal
    def fbe_allocation_size(self, value):
        return self.fbe_size

    # Get the final size
    @property
    def fbe_size(self):
        return 8

    # Check if the value is valid
    def verify(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return sys.maxsize

        return self.fbe_size

    # Get the value
    def get(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0, 0

        return self.read_uint64(self.fbe_offset), self.fbe_size

    # Set the value
    def set(self, value):
        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        self.write_uint64(self.fbe_offset, value)
        return self.fbe_size


# Fast Binary Encoding float final model
class FinalModelFloat(FinalModel):
    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)

    # Get the allocation size
    # noinspection PyUnusedLocal
    def fbe_allocation_size(self, value):
        return self.fbe_size

    # Get the final size
    @property
    def fbe_size(self):
        return 4

    # Check if the value is valid
    def verify(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return sys.maxsize

        return self.fbe_size

    # Get the value
    def get(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0.0, 0

        return self.read_float(self.fbe_offset), self.fbe_size

    # Set the value
    def set(self, value):
        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        self.write_float(self.fbe_offset, value)
        return self.fbe_size


# Fast Binary Encoding double final model
class FinalModelDouble(FinalModel):
    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)

    # Get the allocation size
    # noinspection PyUnusedLocal
    def fbe_allocation_size(self, value):
        return self.fbe_size

    # Get the final size
    @property
    def fbe_size(self):
        return 8

    # Check if the value is valid
    def verify(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return sys.maxsize

        return self.fbe_size

    # Get the value
    def get(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0.0, 0

        return self.read_double(self.fbe_offset), self.fbe_size

    # Set the value
    def set(self, value):
        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        self.write_double(self.fbe_offset, value)
        return self.fbe_size


# Fast Binary Encoding uint64 final model
class FinalModelTimestamp(FinalModel):
    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)

    # Get the allocation size
    # noinspection PyUnusedLocal
    def fbe_allocation_size(self, value):
        return self.fbe_size

    # Get the final size
    @property
    def fbe_size(self):
        return 8

    # Check if the value is valid
    def verify(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return sys.maxsize

        return self.fbe_size

    # Get the value
    def get(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0, 0

        return self.read_uint64(self.fbe_offset), self.fbe_size

    # Set the value
    def set(self, value):
        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        self.write_uint64(self.fbe_offset, value)
        return self.fbe_size


# Fast Binary Encoding uuid final model
class FinalModelUUID(FinalModel):
    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)

    # Get the allocation size
    # noinspection PyUnusedLocal
    def fbe_allocation_size(self, value):
        return self.fbe_size

    # Get the final size
    @property
    def fbe_size(self):
        return 16

    # Check if the value is valid
    def verify(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return sys.maxsize

        return self.fbe_size

    # Get the value
    def get(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return uuid.UUID(int=0), 0

        return self.read_uuid(self.fbe_offset), self.fbe_size

    # Set the value
    def set(self, value):
        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        self.write_uuid(self.fbe_offset, value)
        return self.fbe_size


# Fast Binary Encoding decimal final model
class FinalModelDecimal(FieldModel):
    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)

    # Get the allocation size
    # noinspection PyUnusedLocal
    def fbe_allocation_size(self, value):
        return self.fbe_size

    # Get the final size
    @property
    def fbe_size(self):
        return 16

    # Check if the decimal value is valid
    def verify(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return sys.maxsize

        return self.fbe_size

    # Get the decimal value
    def get(self):
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return decimal.Decimal(0), 0

        # Read decimal parts
        low = self.read_uint32(self.fbe_offset)
        mid = self.read_uint32(self.fbe_offset + 4)
        high = self.read_uint32(self.fbe_offset + 8)
        flags = self.read_uint32(self.fbe_offset + 12)

        # Calculate decimal value
        negative = (flags & 0x80000000) != 0
        scale = (flags & 0x7FFFFFFF) >> 16
        result = decimal.Decimal(high) * 18446744073709551616
        result += decimal.Decimal(mid) * 4294967296
        result += decimal.Decimal(low)
        result /= pow(10, scale)
        if negative:
            result = -result

        return result, self.fbe_size

    # Set the decimal value
    def set(self, value):
        assert ((self._buffer.offset + self.fbe_offset + self.fbe_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + self.fbe_size) > self._buffer.size:
            return 0

        # Extract decimal parts
        parts = value.as_tuple()
        negative = True if parts.sign == 1 else False
        number = int(''.join(map(str, parts.digits)))
        scale = -parts.exponent

        # Check for decimal number overflow
        if (number.bit_length() < 0) or (number.bit_length() > 96):
            # Value too big for .NET Decimal (bit length is limited to [0, 96])
            self.write_count(self.fbe_offset, 0, self.fbe_size)
            return self.fbe_size

        # Check for decimal scale overflow
        if (scale < 0) or (scale > 28):
            # Value scale exceeds .NET Decimal limit of [0, 28]
            self.write_count(self.fbe_offset, 0, self.fbe_size)
            return self.fbe_size

        # Write unscaled value to bytes 0-11
        self.write_bytes(self.fbe_offset, number.to_bytes(12, "little"))

        # Write scale at byte 14
        self.write_byte(self.fbe_offset + 14, scale)

        # Write signum at byte 15
        self.write_byte(self.fbe_offset + 15, 0x80 if negative else 0)
        return self.fbe_size


# Fast Binary Encoding bytes final model
class FinalModelBytes(FinalModel):
    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)

    # Get the allocation size
    # noinspection PyMethodMayBeStatic
    def fbe_allocation_size(self, value):
        return 4 + len(value)

    # Check if the bytes value is valid
    def verify(self):
        if (self._buffer.offset + self.fbe_offset + 4) > self._buffer.size:
            return sys.maxsize

        fbe_bytes_size = self.read_uint32(self.fbe_offset)
        if (self._buffer.offset + self.fbe_offset + 4 + fbe_bytes_size) > self._buffer.size:
            return sys.maxsize

        return 4 + fbe_bytes_size

    # Get the bytes value
    def get(self):
        if (self._buffer.offset + self.fbe_offset + 4) > self._buffer.size:
            return bytearray(), 0

        fbe_bytes_size = self.read_uint32(self.fbe_offset)
        assert ((self._buffer.offset + self.fbe_offset + 4 + fbe_bytes_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + 4 + fbe_bytes_size) > self._buffer.size:
            return bytearray(), 4

        return self.read_bytes(self.fbe_offset + 4, fbe_bytes_size), (4 + fbe_bytes_size)

    # Set the bytes value
    def set(self, value):
        assert (value is not None), "Invalid bytes value!"
        if value is None:
            raise ValueError("Invalid bytes value!")

        assert ((self._buffer.offset + self.fbe_offset + 4) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + 4) > self._buffer.size:
            return 0

        fbe_bytes_size = len(value)
        assert ((self._buffer.offset + self.fbe_offset + 4 + fbe_bytes_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + 4 + fbe_bytes_size) > self._buffer.size:
            return 4

        self.write_uint32(self.fbe_offset, fbe_bytes_size)
        self.write_bytes(self.fbe_offset + 4, value)
        return 4 + fbe_bytes_size


# Fast Binary Encoding string final model
class FinalModelString(FinalModel):
    def __init__(self, buffer, offset):
        super().__init__(buffer, offset)

    # Get the allocation size
    # noinspection PyMethodMayBeStatic
    def fbe_allocation_size(self, value):
        return 4 + 3 * (len(value) + 1)

    # Check if the string value is valid
    def verify(self):
        if (self._buffer.offset + self.fbe_offset + 4) > self._buffer.size:
            return sys.maxsize

        fbe_string_size = self.read_uint32(self.fbe_offset)
        if (self._buffer.offset + self.fbe_offset + 4 + fbe_string_size) > self._buffer.size:
            return sys.maxsize

        return 4 + fbe_string_size

    # Get the string value
    def get(self):
        if (self._buffer.offset + self.fbe_offset + 4) > self._buffer.size:
            return '', 0

        fbe_string_size = self.read_uint32(self.fbe_offset)
        assert ((self._buffer.offset + self.fbe_offset + 4 + fbe_string_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + 4 + fbe_string_size) > self._buffer.size:
            return '', 4

        data = self.read_bytes(self.fbe_offset + 4, fbe_string_size)
        return data.decode("utf-8"), (4 + fbe_string_size)

    # Set the string value
    def set(self, value):
        assert (value is not None), "Invalid string value!"
        if value is None:
            raise ValueError("Invalid string value!")

        assert ((self._buffer.offset + self.fbe_offset + 4) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + 4) > self._buffer.size:
            return 0

        data = value.encode("utf-8")

        fbe_string_size = len(data)
        assert ((self._buffer.offset + self.fbe_offset + 4 + fbe_string_size) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + 4 + fbe_string_size) > self._buffer.size:
            return 4

        self.write_uint32(self.fbe_offset, fbe_string_size)
        self.write_bytes(self.fbe_offset + 4, data)
        return 4 + fbe_string_size


# Fast Binary Encoding optional final model
class FinalModelOptional(FinalModel):
    __slots__ = "_model",

    def __init__(self, model, buffer, offset):
        super().__init__(buffer, offset)
        self._model = model
        self._model.fbe_offset = 0

    # Get the allocation size
    # noinspection PyMethodMayBeStatic
    def fbe_allocation_size(self, optional):
        return 1 + (self.value.fbe_allocation_size(optional) if optional else 0)

    # Checks if the object contains a value
    def __bool__(self):
        return self.has_value()

    # Checks if the object contains a value
    @property
    def has_value(self):
        if (self._buffer.offset + self.fbe_offset + 1) > self._buffer.size:
            return False

        fbe_has_value = self.read_uint8(self.fbe_offset)
        return fbe_has_value != 0

    # Get the base final model value
    @property
    def value(self):
        return self._model

    # Check if the optional value is valid
    def verify(self):
        if (self._buffer.offset + self.fbe_offset + 1) > self._buffer.size:
            return sys.maxsize

        fbe_has_value = self.read_uint8(self.fbe_offset)
        if fbe_has_value == 0:
            return 1

        self._buffer.shift(self.fbe_offset + 1)
        fbe_result = self.value.verify()
        self._buffer.unshift(self.fbe_offset + 1)
        return 1 + fbe_result

    # Get the optional value
    def get(self):
        if (self._buffer.offset + self.fbe_offset + 1) > self._buffer.size:
            return None, 0

        if not self.has_value:
            return None, 1

        self._buffer.shift(self.fbe_offset + 1)
        optional = self.value.get()
        self._buffer.unshift(self.fbe_offset + 1)
        return optional[0], (1 + optional[1])

    # Set the optional value
    def set(self, optional):
        assert ((self._buffer.offset + self.fbe_offset + 1) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + 1) > self._buffer.size:
            return 0

        fbe_has_value = 1 if optional else 0
        self.write_uint8(self.fbe_offset, fbe_has_value)
        if fbe_has_value == 0:
            return 1

        self._buffer.shift(self.fbe_offset + 1)
        size = self.value.set(optional)
        self._buffer.unshift(self.fbe_offset + 1)
        return 1 + size


# Fast Binary Encoding array final model
class FinalModelArray(FinalModel):
    __slots__ = "_model", "_size",

    def __init__(self, model, buffer, offset, size):
        super().__init__(buffer, offset)
        self._model = model
        self._size = size

    # Get the allocation size
    # noinspection PyMethodMayBeStatic
    def fbe_allocation_size(self, values):
        size = 0
        for i in range(min(len(values), self._size)):
            size += self._model.fbe_allocation_size(values[i])
        return size

    # Check if the array is valid
    def verify(self):
        if (self._buffer.offset + self.fbe_offset) > self._buffer.size:
            return sys.maxsize

        size = 0
        self._model.fbe_offset = self.fbe_offset
        for i in range(self._size):
            offset = self._model.verify()
            if offset == sys.maxsize:
                return sys.maxsize
            self._model.fbe_shift(offset)
            size += offset
        return size

    # Get the array
    def get(self, values=None):
        if values is None:
            values = list()

        values.clear()

        assert ((self._buffer.offset + self.fbe_offset) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset) > self._buffer.size:
            return values, 0

        size = 0
        self._model.fbe_offset = self.fbe_offset
        for i in range(self._size):
            value = self._model.get()
            values.append(value[0])
            self._model.fbe_shift(value[1])
            size += value[1]
        return values, size

    # Set the array
    def set(self, values):
        assert (values is not None), "Invalid values parameter!"
        if values is None:
            raise ValueError("Invalid values parameter!")

        assert ((self._buffer.offset + self.fbe_offset) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset) > self._buffer.size:
            return 0

        size = 0
        self._model.fbe_offset = self.fbe_offset
        for i in range(min(len(values), self._size)):
            offset = self._model.set(values[i])
            self._model.fbe_shift(offset)
            size += offset
        return size


# Fast Binary Encoding vector final model
class FinalModelVector(FinalModel):
    __slots__ = "_model",

    def __init__(self, model, buffer, offset):
        super().__init__(buffer, offset)
        self._model = model

    # Get the allocation size
    # noinspection PyMethodMayBeStatic
    def fbe_allocation_size(self, values):
        size = 4
        for value in values:
            size += self._model.fbe_allocation_size(value)
        return size

    # Check if the vector is valid
    def verify(self):
        if (self._buffer.offset + self.fbe_offset + 4) > self._buffer.size:
            return sys.maxsize

        fbe_vector_size = self.read_uint32(self.fbe_offset)

        size = 4
        self._model.fbe_offset = self.fbe_offset + 4
        for i in range(fbe_vector_size):
            offset = self._model.verify()
            if offset == sys.maxsize:
                return sys.maxsize
            self._model.fbe_shift(offset)
            size += offset
        return size

    # Get the vector
    def get(self, values=None):
        if values is None:
            values = list()

        values.clear()

        assert ((self._buffer.offset + self.fbe_offset + 4) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + 4) > self._buffer.size:
            return values, 0

        fbe_vector_size = self.read_uint32(self.fbe_offset)
        if fbe_vector_size == 0:
            return values, 4

        size = 4
        self._model.fbe_offset = self.fbe_offset + 4
        for i in range(fbe_vector_size):
            value = self._model.get()
            values.append(value[0])
            self._model.fbe_shift(value[1])
            size += value[1]
        return values, size

    # Set the vector
    def set(self, values):
        assert (values is not None), "Invalid values parameter!"
        if values is None:
            raise ValueError("Invalid values parameter!")

        assert ((self._buffer.offset + self.fbe_offset + 4) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + 4) > self._buffer.size:
            return 0

        self.write_uint32(self.fbe_offset, len(values))

        size = 4
        self._model.fbe_offset = self.fbe_offset + 4
        for value in values:
            offset = self._model.set(value)
            self._model.fbe_shift(offset)
            size += offset
        return size


# Fast Binary Encoding set final model
class FinalModelSet(FinalModel):
    __slots__ = "_model",

    def __init__(self, model, buffer, offset):
        super().__init__(buffer, offset)
        self._model = model

    # Get the allocation size
    # noinspection PyMethodMayBeStatic
    def fbe_allocation_size(self, values):
        size = 4
        for value in values:
            size += self._model.fbe_allocation_size(value)
        return size

    # Check if the set value is valid
    def verify(self):
        if (self._buffer.offset + self.fbe_offset + 4) > self._buffer.size:
            return sys.maxsize

        fbe_set_size = self.read_uint32(self.fbe_offset)

        size = 4
        self._model.fbe_offset = self.fbe_offset + 4
        for i in range(fbe_set_size):
            offset = self._model.verify()
            if offset == sys.maxsize:
                return sys.maxsize
            self._model.fbe_shift(offset)
            size += offset
        return size

    # Get the set value
    def get(self, values=None):
        if values is None:
            values = set()

        values.clear()

        assert ((self._buffer.offset + self.fbe_offset + 4) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + 4) > self._buffer.size:
            return values, 0

        fbe_set_size = self.read_uint32(self.fbe_offset)
        if fbe_set_size == 0:
            return values, 4

        size = 4
        self._model.fbe_offset = self.fbe_offset + 4
        for i in range(fbe_set_size):
            value = self._model.get()
            values.add(value[0])
            self._model.fbe_shift(value[1])
            size += value[1]
        return values, size

    # Set the set value
    def set(self, values):
        assert (values is not None), "Invalid values parameter!"
        if values is None:
            raise ValueError("Invalid values parameter!")

        assert ((self._buffer.offset + self.fbe_offset + 4) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + 4) > self._buffer.size:
            return 0

        self.write_uint32(self.fbe_offset, len(values))

        size = 4
        self._model.fbe_offset = self.fbe_offset + 4
        for value in values:
            offset = self._model.set(value)
            self._model.fbe_shift(offset)
            size += offset
        return size


# Fast Binary Encoding map final model
class FinalModelMap(FinalModel):
    __slots__ = "_model_key", "_model_value",

    def __init__(self, model_key, model_value, buffer, offset):
        super().__init__(buffer, offset)
        self._model_key = model_key
        self._model_value = model_value

    # Get the allocation size
    # noinspection PyMethodMayBeStatic
    def fbe_allocation_size(self, values):
        size = 4
        for (key, value) in values.items():
            size += self._model_key.fbe_allocation_size(key)
            size += self._model_value.fbe_allocation_size(value)
        return size

    # Check if the map is valid
    def verify(self):
        if (self._buffer.offset + self.fbe_offset + 4) > self._buffer.size:
            return sys.maxsize

        fbe_map_size = self.read_uint32(self.fbe_offset)

        size = 4
        self._model_key.fbe_offset = self.fbe_offset + 4
        self._model_value.fbe_offset = self.fbe_offset + 4
        for i in range(fbe_map_size):
            offset_key = self._model_key.verify()
            if offset_key == sys.maxsize:
                return sys.maxsize
            self._model_key.fbe_shift(offset_key)
            self._model_value.fbe_shift(offset_key)
            size += offset_key
            offset_value = self._model_value.verify()
            if offset_value == sys.maxsize:
                return sys.maxsize
            self._model_key.fbe_shift(offset_value)
            self._model_value.fbe_shift(offset_value)
            size += offset_value
        return size

    # Get the map
    def get(self, values=None):
        if values is None:
            values = dict()

        values.clear()

        assert ((self._buffer.offset + self.fbe_offset + 4) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + 4) > self._buffer.size:
            return values, 0

        fbe_map_size = self.read_uint32(self.fbe_offset)
        if fbe_map_size == 0:
            return values, 4

        size = 4
        self._model_key.fbe_offset = self.fbe_offset + 4
        self._model_value.fbe_offset = self.fbe_offset + 4
        for i in range(fbe_map_size):
            key = self._model_key.get()
            self._model_key.fbe_shift(key[1])
            self._model_value.fbe_shift(key[1])
            size += key[1]
            value = self._model_value.get()
            self._model_key.fbe_shift(value[1])
            self._model_value.fbe_shift(value[1])
            size += value[1]
            values[key[0]] = value[0]
        return values, size

    # Set the map
    def set(self, values):
        assert (values is not None), "Invalid values parameter!"
        if values is None:
            raise ValueError("Invalid values parameter!")

        assert ((self._buffer.offset + self.fbe_offset + 4) <= self._buffer.size), "Model is broken!"
        if (self._buffer.offset + self.fbe_offset + 4) > self._buffer.size:
            return 0

        self.write_uint32(self.fbe_offset, len(values))

        size = 4
        self._model_key.fbe_offset = self.fbe_offset + 4
        self._model_value.fbe_offset = self.fbe_offset + 4
        for (key, value) in values.items():
            offset_key = self._model_key.set(key)
            self._model_key.fbe_shift(offset_key)
            self._model_value.fbe_shift(offset_key)
            size += offset_key
            offset_value = self._model_value.set(value)
            self._model_key.fbe_shift(offset_value)
            self._model_value.fbe_shift(offset_value)
            size += offset_value
        return size


# Fast Binary Encoding base sender
class Sender(object):
    __slots__ = "_buffer", "_logging", "_final",

    def __init__(self, buffer=None, final=False):
        if buffer is None:
            buffer = WriteBuffer()
        self._buffer = buffer
        self._logging = False
        self._final = final

    # Get the bytes buffer
    @property
    def buffer(self):
        return self._buffer

    # Get the final protocol flag
    @property
    def final(self):
        return self._final

    # Get the logging flag
    @property
    def logging(self):
        return self._logging

    # Set the logging flag
    @logging.setter
    def logging(self, logging):
        self._logging = logging

    # Reset the sender buffer
    def reset(self):
        self._buffer.reset()

    # Send serialized buffer.
    # Direct call of the method requires knowledge about internals of FBE models serialization.
    # Use it with care!
    def send_serialized(self, serialized):
        assert (serialized > 0), "Invalid size of the serialized buffer!"
        if serialized <= 0:
            return 0

        # Shift the send buffer
        self._buffer.shift(serialized)

        # Send the value
        sent = self.on_send(self._buffer.buffer, 0, self._buffer.size)
        self._buffer.remove(0, sent)
        return sent

    # Send message handler
    def on_send(self, buffer, offset, size):
        raise NotImplementedError("Abstract method call!")

    # Send log message handler
    def on_send_log(self, message):
        pass


# Fast Binary Encoding base receiver
class Receiver(object):
    __slots__ = "_buffer", "_logging", "_final",

    def __init__(self, buffer=None, final=False):
        if buffer is None:
            buffer = WriteBuffer()
        self._buffer = buffer
        self._logging = False
        self._final = final

    # Get the bytes buffer
    @property
    def buffer(self):
        return self._buffer

    # Get the final protocol flag
    @property
    def final(self):
        return self._final

    # Get the logging flag
    @property
    def logging(self):
        return self._logging

    # Set the logging flag
    @logging.setter
    def logging(self, logging):
        self._logging = logging

    # Reset the receiver buffer
    def reset(self):
        self._buffer.reset()

    # Receive data
    def receive(self, buffer, offset=0, size=None):
        assert (buffer is not None), "Invalid buffer!"
        if buffer is None:
            raise ValueError("Invalid buffer!")

        if size is None:
            size = len(buffer)

        assert ((offset + size) <= len(buffer)), "Invalid offset & size!"
        if (offset + size) > len(buffer):
            raise ValueError("Invalid offset & size!")

        if size == 0:
            return

        if isinstance(buffer, ReadBuffer) or isinstance(buffer, WriteBuffer):
            buffer = buffer.buffer

        # Storage buffer
        offset0 = self._buffer.offset
        offset1 = self._buffer.size
        size1 = self._buffer.size

        # Receive buffer
        offset2 = 0
        size2 = size

        # While receive buffer is available to handle...
        while offset2 < size2:
            message_buffer = None
            message_offset = 0
            message_size = 0

            # Try to receive message size
            message_size_copied = False
            message_size_found = False
            while not message_size_found:
                # Look into the storage buffer
                if offset0 < size1:
                    count = min(size1 - offset0, 4)
                    if count == 4:
                        message_size_copied = True
                        message_size_found = True
                        message_size = Receiver.read_uint32(self._buffer.buffer, self._buffer.offset + offset0)
                        offset0 += 4
                        break
                    else:
                        # Fill remaining data from the receive buffer
                        if offset2 < size2:
                            count = min(size2 - offset2, 4 - count)

                            # Allocate and refresh the storage buffer
                            self._buffer.allocate(count)
                            size1 += count

                            self._buffer.buffer[offset1:offset1 + count] = buffer[offset + offset2:offset + offset2 + count]
                            offset1 += count
                            offset2 += count
                            continue
                        else:
                            break

                # Look into the receive buffer
                if offset2 < size2:
                    count = min(size2 - offset2, 4)
                    if count == 4:
                        message_size_found = True
                        message_size = Receiver.read_uint32(buffer, offset + offset2)
                        offset2 += 4
                        break
                    else:
                        # Allocate and refresh the storage buffer
                        self._buffer.allocate(count)
                        size1 += count

                        self._buffer.buffer[offset1:offset1 + count] = buffer[offset + offset2:offset + offset2 + count]
                        offset1 += count
                        offset2 += count
                        continue
                else:
                    break

            if not message_size_found:
                return

            # Check the message full size
            min_size = (4 + 4) if self._final else (4 + 4 + 4 + 4)
            assert (message_size >= min_size), "Invalid receive data!"
            if message_size < min_size:
                return

            # Try to receive message body
            message_found = False
            while not message_found:
                # Look into the storage buffer
                if offset0 < size1:
                    count = min(size1 - offset0, message_size - 4)
                    if count == (message_size - 4):
                        message_found = True
                        message_buffer = self._buffer.buffer
                        message_offset = offset0 - 4
                        offset0 += message_size - 4
                        break
                    else:
                        # Fill remaining data from the receive buffer
                        if offset2 < size2:
                            # Copy message size into the storage buffer
                            if not message_size_copied:
                                # Allocate and refresh the storage buffer
                                self._buffer.allocate(4)
                                size1 += 4

                                Receiver.write_uint32(self._buffer.buffer, self._buffer.offset + offset0, message_size)
                                offset0 += 4
                                offset1 += 4

                                message_size_copied = True

                            count = min(size2 - offset2, message_size - 4 - count)

                            # Allocate and refresh the storage buffer
                            self._buffer.allocate(count)
                            size1 += count

                            self._buffer.buffer[offset1:offset1 + count] = buffer[offset + offset2:offset + offset2 + count]
                            offset1 += count
                            offset2 += count
                            continue
                        else:
                            break

                # Look into the receive buffer
                if offset2 < size2:
                    count = min(size2 - offset2, message_size - 4)
                    if not message_size_copied and (count == (message_size - 4)):
                        message_found = True
                        message_buffer = buffer
                        message_offset = offset + offset2 - 4
                        offset2 += message_size - 4
                        break
                    else:
                        # Copy message size into the storage buffer
                        if not message_size_copied:
                            # Allocate and refresh the storage buffer
                            self._buffer.allocate(4)
                            size1 += 4

                            Receiver.write_uint32(self._buffer.buffer, self._buffer.offset + offset0, message_size)
                            offset0 += 4
                            offset1 += 4

                            message_size_copied = True

                        # Allocate and refresh the storage buffer
                        self._buffer.allocate(count)
                        size1 += count

                        self._buffer.buffer[offset1:offset1 + count] = buffer[offset + offset2:offset + offset2 + count]
                        offset1 += count
                        offset2 += count
                        continue
                else:
                    break

            if not message_found:
                # Copy message size into the storage buffer
                if not message_size_copied:
                    # Allocate and refresh the storage buffer
                    self._buffer.allocate(4)
                    size1 += 4

                    Receiver.write_uint32(self._buffer.buffer, self._buffer.offset + offset0, message_size)
                    offset0 += 4
                    offset1 += 4

                    # noinspection PyUnusedLocal
                    message_size_copied = True
                return

            # Read the message parameters
            if self._final:
                # noinspection PyUnusedLocal
                fbe_struct_size = Receiver.read_uint32(message_buffer, message_offset)
                fbe_struct_type = Receiver.read_uint32(message_buffer, message_offset + 4)
            else:
                fbe_struct_offset = Receiver.read_uint32(message_buffer, message_offset + 4)
                # noinspection PyUnusedLocal
                fbe_struct_size = Receiver.read_uint32(message_buffer, message_offset + fbe_struct_offset)
                fbe_struct_type = Receiver.read_uint32(message_buffer, message_offset + fbe_struct_offset + 4)

            # Handle the message
            self.on_receive(fbe_struct_type, message_buffer, message_offset, message_size)

            # Reset the storage buffer
            self._buffer.reset()

            # Refresh the storage buffer
            offset0 = self._buffer.offset
            offset1 = self._buffer.size
            size1 = self._buffer.size

    # Receive message handler
    def on_receive(self, type, buffer, offset, size):
        raise NotImplementedError("Abstract method call!")

    # Receive log message handler
    def on_receive_log(self, message):
        pass

    # Buffer I/O methods

    @staticmethod
    def read_uint32(buffer, offset):
        return struct.unpack_from("<I", buffer, offset)[0]

    @staticmethod
    def write_uint32(buffer, offset, value):
        return struct.pack_into("<I", buffer, offset, value)
