//------------------------------------------------------------------------------
// Automatically generated by the Fast Binary Encoding compiler, do not modify!
// https://github.com/chronoxor/FastBinaryEncoding
// Source: protoex.fbe
// FBE version: 1.14.5.0
//------------------------------------------------------------------------------

/* eslint-disable prefer-const,no-loss-of-precision */
'use strict'

const util = require('util')

const big = require('./big')
const int64 = require('./int64')
const uuid = require('./uuid')

const Big = big.Big // eslint-disable-line
const Int64 = int64.Int64 // eslint-disable-line
const UInt64 = int64.UInt64 // eslint-disable-line
const UUID = uuid.UUID // eslint-disable-line

const fbe = require('./fbe')
const proto = require('./proto')

/**
 * OrderSide enum
 */
class OrderSide {
  /**
   * Initialize enum with a given value
   * @param {OrderSide|number|Int64|UInt64=} value Enum value, defaults is 0
   * @constructor
   */
  constructor (value = 0) {
    if (value instanceof OrderSide) {
      this.value = value.value
    } else {
      this.value = value
    }
  }

  /**
   * Is this enum equal to other one?
   * @this {!OrderSide}
   * @param {!OrderSide} other Other enum
   * @returns {boolean} Equal result
   */
  eq (other) {
    if (!(other instanceof OrderSide)) {
      throw new TypeError('Instance of OrderSide is required!')
    }
    return this.value === other.value
  }

  /**
   * Get enum value
   * @this {!OrderSide}
   * @returns {!number|!Int64|!UInt64} Enum value
   */
  valueOf () {
    return this.value
  }

  /**
   * Convert enum to string
   * @this {!OrderSide}
   * @returns {!string} Enum value string
   */
  toString () {
    if (this.value === OrderSide.buy.value) {
      return 'buy'
    }
    if (this.value === OrderSide.sell.value) {
      return 'sell'
    }
    if (this.value === OrderSide.tell.value) {
      return 'tell'
    }
    return '<unknown>'
  }

  /**
   * Inspect enum
   * @this {!OrderSide}
   * @returns {!string} Enum value string
   */
  [util.inspect.custom] () {
    return this.toString()
  }

  /**
   * Convert enum to JSON
   * @this {!OrderSide}
   * @returns {!number} Enum value for JSON
   */
  toJSON () {
    return this.value
  }

  /**
   * Create enum from object value
   * @param {!number} other Object value
   * @returns {!OrderSide} Created enum
   */
  static fromObject (other) {
    return new OrderSide(other)
  }
}

// noinspection PointlessArithmeticExpressionJS
OrderSide.buy = new OrderSide(0 + 0)
// noinspection PointlessArithmeticExpressionJS
OrderSide.sell = new OrderSide(0 + 1)
// noinspection PointlessArithmeticExpressionJS
OrderSide.tell = new OrderSide(0 + 2)

exports.OrderSide = OrderSide

/**
 * Fast Binary Encoding OrderSide field model
 */
class FieldModelOrderSide extends fbe.FieldModel {
  /**
   * Get the field size
   * @this {!FieldModelOrderSide}
   * @returns {!number} Field size
   */
  get fbeSize () {
    return 1
  }

  /**
   * Get the value
   * @this {!FieldModelOrderSide}
   * @param {OrderSide=} defaults Default value, defaults is new OrderSide()
   * @returns {!OrderSide} Result value
   */
  get (defaults = new OrderSide()) {
    if ((this._buffer.offset + this.fbeOffset + this.fbeSize) > this._buffer.size) {
      return defaults
    }

    return new OrderSide(this.readByte(this.fbeOffset))
  }

  /**
   * Set the value
   * @this {!FieldModelOrderSide}
   * @param {!OrderSide} value Value
   */
  set (value) {
    console.assert(((this._buffer.offset + this.fbeOffset + this.fbeSize) <= this._buffer.size), 'Model is broken!')
    if ((this._buffer.offset + this.fbeOffset + this.fbeSize) > this._buffer.size) {
      return
    }

    this.writeByte(this.fbeOffset, value.value)
  }
}

exports.FieldModelOrderSide = FieldModelOrderSide

/**
 * Fast Binary Encoding OrderSide final model
 */
class FinalModelOrderSide extends fbe.FinalModel {
  /**
   * Get the allocation size
   * @this {!FinalModelOrderSide}
   * @param {!OrderSide} value Value
   * @returns {!number} Allocation size
   */
  fbeAllocationSize (value) {
    return this.fbeSize
  }

  /**
   * Get the final size
   * @this {!FieldModelOrderSide}
   * @returns {!number} Final size
   */
  get fbeSize () {
    return 1
  }

  /**
   * Check if the value is valid
   * @this {!FinalModelOrderSide}
   * @returns {!number} Final model size or Number.MAX_SAFE_INTEGER in case of any error
   */
  verify () {
    if ((this._buffer.offset + this.fbeOffset + this.fbeSize) > this._buffer.size) {
      return Number.MAX_SAFE_INTEGER
    }

    return this.fbeSize
  }

  /**
   * Get the value
   * @this {!FieldModelOrderSide}
   * @returns {!object} Result value and its size
   */
  get () {
    if ((this._buffer.offset + this.fbeOffset + this.fbeSize) > this._buffer.size) {
      return { value: new OrderSide(), size: 0 }
    }

    return { value: new OrderSide(this.readByte(this.fbeOffset)), size: this.fbeSize }
  }

  /**
   * Set the value
   * @this {!FieldModelOrderSide}
   * @param {!OrderSide} value Value
   * @returns {!number} Final model size
   */
  set (value) {
    console.assert(((this._buffer.offset + this.fbeOffset + this.fbeSize) <= this._buffer.size), 'Model is broken!')
    if ((this._buffer.offset + this.fbeOffset + this.fbeSize) > this._buffer.size) {
      return 0
    }

    this.writeByte(this.fbeOffset, value.value)
    return this.fbeSize
  }
}

exports.FinalModelOrderSide = FinalModelOrderSide

/**
 * OrderType enum
 */
class OrderType {
  /**
   * Initialize enum with a given value
   * @param {OrderType|number|Int64|UInt64=} value Enum value, defaults is 0
   * @constructor
   */
  constructor (value = 0) {
    if (value instanceof OrderType) {
      this.value = value.value
    } else {
      this.value = value
    }
  }

  /**
   * Is this enum equal to other one?
   * @this {!OrderType}
   * @param {!OrderType} other Other enum
   * @returns {boolean} Equal result
   */
  eq (other) {
    if (!(other instanceof OrderType)) {
      throw new TypeError('Instance of OrderType is required!')
    }
    return this.value === other.value
  }

  /**
   * Get enum value
   * @this {!OrderType}
   * @returns {!number|!Int64|!UInt64} Enum value
   */
  valueOf () {
    return this.value
  }

  /**
   * Convert enum to string
   * @this {!OrderType}
   * @returns {!string} Enum value string
   */
  toString () {
    if (this.value === OrderType.market.value) {
      return 'market'
    }
    if (this.value === OrderType.limit.value) {
      return 'limit'
    }
    if (this.value === OrderType.stop.value) {
      return 'stop'
    }
    if (this.value === OrderType.stoplimit.value) {
      return 'stoplimit'
    }
    return '<unknown>'
  }

  /**
   * Inspect enum
   * @this {!OrderType}
   * @returns {!string} Enum value string
   */
  [util.inspect.custom] () {
    return this.toString()
  }

  /**
   * Convert enum to JSON
   * @this {!OrderType}
   * @returns {!number} Enum value for JSON
   */
  toJSON () {
    return this.value
  }

  /**
   * Create enum from object value
   * @param {!number} other Object value
   * @returns {!OrderType} Created enum
   */
  static fromObject (other) {
    return new OrderType(other)
  }
}

// noinspection PointlessArithmeticExpressionJS
OrderType.market = new OrderType(0 + 0)
// noinspection PointlessArithmeticExpressionJS
OrderType.limit = new OrderType(0 + 1)
// noinspection PointlessArithmeticExpressionJS
OrderType.stop = new OrderType(0 + 2)
// noinspection PointlessArithmeticExpressionJS
OrderType.stoplimit = new OrderType(0 + 3)

exports.OrderType = OrderType

/**
 * Fast Binary Encoding OrderType field model
 */
class FieldModelOrderType extends fbe.FieldModel {
  /**
   * Get the field size
   * @this {!FieldModelOrderType}
   * @returns {!number} Field size
   */
  get fbeSize () {
    return 1
  }

  /**
   * Get the value
   * @this {!FieldModelOrderType}
   * @param {OrderType=} defaults Default value, defaults is new OrderType()
   * @returns {!OrderType} Result value
   */
  get (defaults = new OrderType()) {
    if ((this._buffer.offset + this.fbeOffset + this.fbeSize) > this._buffer.size) {
      return defaults
    }

    return new OrderType(this.readByte(this.fbeOffset))
  }

  /**
   * Set the value
   * @this {!FieldModelOrderType}
   * @param {!OrderType} value Value
   */
  set (value) {
    console.assert(((this._buffer.offset + this.fbeOffset + this.fbeSize) <= this._buffer.size), 'Model is broken!')
    if ((this._buffer.offset + this.fbeOffset + this.fbeSize) > this._buffer.size) {
      return
    }

    this.writeByte(this.fbeOffset, value.value)
  }
}

exports.FieldModelOrderType = FieldModelOrderType

/**
 * Fast Binary Encoding OrderType final model
 */
class FinalModelOrderType extends fbe.FinalModel {
  /**
   * Get the allocation size
   * @this {!FinalModelOrderType}
   * @param {!OrderType} value Value
   * @returns {!number} Allocation size
   */
  fbeAllocationSize (value) {
    return this.fbeSize
  }

  /**
   * Get the final size
   * @this {!FieldModelOrderType}
   * @returns {!number} Final size
   */
  get fbeSize () {
    return 1
  }

  /**
   * Check if the value is valid
   * @this {!FinalModelOrderType}
   * @returns {!number} Final model size or Number.MAX_SAFE_INTEGER in case of any error
   */
  verify () {
    if ((this._buffer.offset + this.fbeOffset + this.fbeSize) > this._buffer.size) {
      return Number.MAX_SAFE_INTEGER
    }

    return this.fbeSize
  }

  /**
   * Get the value
   * @this {!FieldModelOrderType}
   * @returns {!object} Result value and its size
   */
  get () {
    if ((this._buffer.offset + this.fbeOffset + this.fbeSize) > this._buffer.size) {
      return { value: new OrderType(), size: 0 }
    }

    return { value: new OrderType(this.readByte(this.fbeOffset)), size: this.fbeSize }
  }

  /**
   * Set the value
   * @this {!FieldModelOrderType}
   * @param {!OrderType} value Value
   * @returns {!number} Final model size
   */
  set (value) {
    console.assert(((this._buffer.offset + this.fbeOffset + this.fbeSize) <= this._buffer.size), 'Model is broken!')
    if ((this._buffer.offset + this.fbeOffset + this.fbeSize) > this._buffer.size) {
      return 0
    }

    this.writeByte(this.fbeOffset, value.value)
    return this.fbeSize
  }
}

exports.FinalModelOrderType = FinalModelOrderType

/**
 * StateEx flags
 */
class StateEx {
  /**
   * Initialize flags with a given value
   * @param {StateEx|number|Int64|UInt64=} value Flags value, defaults is 0
   * @constructor
   */
  constructor (value = 0) {
    if (value instanceof StateEx) {
      this.value = value.value
    } else {
      this.value = value
    }
  }

  /**
   * Check for the given flags set state
   * @this {!StateEx}
   * @param {!StateEx|!number|!Int64|!UInt64} flags Flags
   * @returns {!boolean} Flags set state
   */
  hasFlags (flags) {
    if (flags instanceof StateEx) {
      flags = flags.value
    }
    return ((this.value & flags) !== 0) && ((this.value & flags) === flags)
  }

  /**
   * Set the given flags
   * @this {!StateEx}
   * @param {!StateEx|!number|!Int64|!UInt64} flags Flags
   */
  setFlags (flags) {
    if (flags instanceof StateEx) {
      flags = flags.value
    }
    this.value |= flags
    return this
  }

  /**
   * Remove the given flags
   * @this {!StateEx}
   * @param {!StateEx|!number|!Int64|!UInt64} flags Flags
   */
  removeFlags (flags) {
    if (flags instanceof StateEx) {
      flags = flags.value
    }
    this.value &= ~flags
    return this
  }

  /**
   * Is this flags equal to other one?
   * @this {!StateEx}
   * @param {!StateEx} other Other flags
   * @returns {boolean} Equal result
   */
  eq (other) {
    if (!(other instanceof StateEx)) {
      throw new TypeError('Instance of StateEx is required!')
    }
    return this.value === other.value
  }

  /**
   * Get flags value
   * @this {!StateEx}
   * @returns {!number|!Int64|!UInt64} Flags value
   */
  valueOf () {
    return this.value
  }

  /**
   * Convert flags to string
   * @this {!StateEx}
   * @returns {!string} Flags value string
   */
  toString () {
    let result = ''
    let first = true
    if ((this.value & StateEx.unknown.value) && ((this.value & StateEx.unknown.value) === StateEx.unknown.value)) {
      result += (first ? '' : '|') + 'unknown'
      // noinspection JSUnusedAssignment
      first = false
    }
    if ((this.value & StateEx.invalid.value) && ((this.value & StateEx.invalid.value) === StateEx.invalid.value)) {
      result += (first ? '' : '|') + 'invalid'
      // noinspection JSUnusedAssignment
      first = false
    }
    if ((this.value & StateEx.initialized.value) && ((this.value & StateEx.initialized.value) === StateEx.initialized.value)) {
      result += (first ? '' : '|') + 'initialized'
      // noinspection JSUnusedAssignment
      first = false
    }
    if ((this.value & StateEx.calculated.value) && ((this.value & StateEx.calculated.value) === StateEx.calculated.value)) {
      result += (first ? '' : '|') + 'calculated'
      // noinspection JSUnusedAssignment
      first = false
    }
    if ((this.value & StateEx.broken.value) && ((this.value & StateEx.broken.value) === StateEx.broken.value)) {
      result += (first ? '' : '|') + 'broken'
      // noinspection JSUnusedAssignment
      first = false
    }
    if ((this.value & StateEx.happy.value) && ((this.value & StateEx.happy.value) === StateEx.happy.value)) {
      result += (first ? '' : '|') + 'happy'
      // noinspection JSUnusedAssignment
      first = false
    }
    if ((this.value & StateEx.sad.value) && ((this.value & StateEx.sad.value) === StateEx.sad.value)) {
      result += (first ? '' : '|') + 'sad'
      // noinspection JSUnusedAssignment
      first = false
    }
    if ((this.value & StateEx.good.value) && ((this.value & StateEx.good.value) === StateEx.good.value)) {
      result += (first ? '' : '|') + 'good'
      // noinspection JSUnusedAssignment
      first = false
    }
    if ((this.value & StateEx.bad.value) && ((this.value & StateEx.bad.value) === StateEx.bad.value)) {
      result += (first ? '' : '|') + 'bad'
      // noinspection JSUnusedAssignment
      first = false
    }
    return result
  }

  /**
   * Inspect flags
   * @this {!StateEx}
   * @returns {!string} Flags value string
   */
  [util.inspect.custom] () {
    return this.toString()
  }

  /**
   * Convert flags to JSON
   * @this {!StateEx}
   * @returns {!number} Flags value for JSON
   */
  toJSON () {
    return this.value
  }

  /**
   * Create flags from number flags representation
   * @param {!number} flags Number flags representation
   * @returns {!StateEx} Created flags
   */
  static fromFlags (flags) {
    return new StateEx(flags)
  }

  /**
   * Create flags from object value
   * @param {!number} other Object value
   * @returns {!StateEx} Created flags
   */
  static fromObject (other) {
    return new StateEx(other)
  }
}

// noinspection PointlessArithmeticExpressionJS
StateEx.unknown = new StateEx(0x00)
// noinspection PointlessArithmeticExpressionJS
StateEx.invalid = new StateEx(0x01)
// noinspection PointlessArithmeticExpressionJS
StateEx.initialized = new StateEx(0x02)
// noinspection PointlessArithmeticExpressionJS
StateEx.calculated = new StateEx(0x04)
// noinspection PointlessArithmeticExpressionJS
StateEx.broken = new StateEx(0x08)
// noinspection PointlessArithmeticExpressionJS
StateEx.happy = new StateEx(0x10)
// noinspection PointlessArithmeticExpressionJS
StateEx.sad = new StateEx(0x20)
// noinspection PointlessArithmeticExpressionJS
StateEx.good = new StateEx(StateEx.initialized | StateEx.calculated)
// noinspection PointlessArithmeticExpressionJS
StateEx.bad = new StateEx(StateEx.unknown | StateEx.invalid | StateEx.broken)

exports.StateEx = StateEx

/**
 * Fast Binary Encoding StateEx field model
 */
class FieldModelStateEx extends fbe.FieldModel {
  /**
   * Get the field size
   * @this {!FieldModelStateEx}
   * @returns {!number} Field size
   */
  get fbeSize () {
    return 1
  }

  /**
   * Get the value
   * @this {!FieldModelStateEx}
   * @param {StateEx=} defaults Default value, defaults is new StateEx()
   * @returns {!StateEx} Result value
   */
  get (defaults = new StateEx()) {
    if ((this._buffer.offset + this.fbeOffset + this.fbeSize) > this._buffer.size) {
      return defaults
    }

    return new StateEx(this.readByte(this.fbeOffset))
  }

  /**
   * Set the value
   * @this {!FieldModelStateEx}
   * @param {!StateEx} value Value
   */
  set (value) {
    console.assert(((this._buffer.offset + this.fbeOffset + this.fbeSize) <= this._buffer.size), 'Model is broken!')
    if ((this._buffer.offset + this.fbeOffset + this.fbeSize) > this._buffer.size) {
      return
    }

    this.writeByte(this.fbeOffset, value.value)
  }
}

exports.FieldModelStateEx = FieldModelStateEx

/**
 * Fast Binary Encoding StateEx final model
 */
class FinalModelStateEx extends fbe.FinalModel {
  /**
   * Get the allocation size
   * @this {!FinalModelStateEx}
   * @param {!StateEx} value Value
   * @returns {!number} Allocation size
   */
  fbeAllocationSize (value) {
    return this.fbeSize
  }

  /**
   * Get the final size
   * @this {!FieldModelStateEx}
   * @returns {!number} Final size
   */
  get fbeSize () {
    return 1
  }

  /**
   * Check if the value is valid
   * @this {!FinalModelStateEx}
   * @returns {!number} Final model size or Number.MAX_SAFE_INTEGER in case of any error
   */
  verify () {
    if ((this._buffer.offset + this.fbeOffset + this.fbeSize) > this._buffer.size) {
      return Number.MAX_SAFE_INTEGER
    }

    return this.fbeSize
  }

  /**
   * Get the value
   * @this {!FieldModelStateEx}
   * @returns {!object} Result value and its size
   */
  get () {
    if ((this._buffer.offset + this.fbeOffset + this.fbeSize) > this._buffer.size) {
      return { value: new StateEx(), size: 0 }
    }

    return { value: new StateEx(this.readByte(this.fbeOffset)), size: this.fbeSize }
  }

  /**
   * Set the value
   * @this {!FieldModelStateEx}
   * @param {!StateEx} value Value
   * @returns {!number} Final model size
   */
  set (value) {
    console.assert(((this._buffer.offset + this.fbeOffset + this.fbeSize) <= this._buffer.size), 'Model is broken!')
    if ((this._buffer.offset + this.fbeOffset + this.fbeSize) > this._buffer.size) {
      return 0
    }

    this.writeByte(this.fbeOffset, value.value)
    return this.fbeSize
  }
}

exports.FinalModelStateEx = FinalModelStateEx

/**
 * Order struct
 */
class Order {
  /**
   * Initialize struct
   * @param {!number=} id
   * @param {!string=} symbol
   * @param {!OrderSide=} side
   * @param {!OrderType=} type
   * @param {!number=} price
   * @param {!number=} volume
   * @param {!number=} tp
   * @param {!number=} sl
   * @constructor
   */
  constructor (argid = 0, argsymbol = '', argside = new OrderSide(), argtype = new OrderType(), argprice = 0.0, argvolume = 0.0, argtp = 10.0, argsl = -10.0) {
    this.id = argid
    this.symbol = argsymbol
    this.side = argside
    this.type = argtype
    this.price = argprice
    this.volume = argvolume
    this.tp = argtp
    this.sl = argsl
  }

  /**
   * Copy struct (shallow copy)
   * @this {!Order}
   * @param {!Order} other Other struct
   * @returns {!Order} This struct
   */
  copy (other) {
    if (other.id != null) {
      this.id = other.id
    } else {
      this.id = undefined
    }
    if (other.symbol != null) {
      this.symbol = other.symbol
    } else {
      this.symbol = undefined
    }
    if (other.side != null) {
      this.side = OrderSide.fromObject(other.side)
    } else {
      this.side = undefined
    }
    if (other.type != null) {
      this.type = OrderType.fromObject(other.type)
    } else {
      this.type = undefined
    }
    if (other.price != null) {
      this.price = other.price
    } else {
      this.price = undefined
    }
    if (other.volume != null) {
      this.volume = other.volume
    } else {
      this.volume = undefined
    }
    if (other.tp != null) {
      this.tp = other.tp
    } else {
      this.tp = undefined
    }
    if (other.sl != null) {
      this.sl = other.sl
    } else {
      this.sl = undefined
    }
    return this
  }

  /**
   * Clone struct (deep clone)
   * @this {!Order}
   * @returns {!Order} Cloned struct
   */
  clone () {
    // Serialize the struct to the FBE stream
    let writer = new OrderModel(new fbe.WriteBuffer())
    writer.serialize(this)

    // Deserialize the struct from the FBE stream
    let reader = new OrderModel(new fbe.ReadBuffer())
    reader.attachBuffer(writer.buffer)
    return reader.deserialize().value
  }

  /**
   * Is this struct equal to other one?
   * @this {!Order}
   * @param {!Order} other Other struct
   * @returns {boolean} Equal result
   */
  eq (other) {
    if (!(other instanceof Order)) {
      throw new TypeError('Instance of Order is required!')
    }
    // noinspection RedundantIfStatementJS
    if (this.id !== other.id) {
      return false
    }
    return true
  }

  /**
   * Convert struct to string
   * @this {!Order}
   * @returns {!string} Struct value string
   */
  toString () {
    let result = ''
    result += 'Order('
    result += 'id='
    result += this.id.toString()
    result += ',symbol='
    if (this.symbol != null) {
      result += '"' + this.symbol.toString() + '"'
    } else {
      result += 'null'
    }
    result += ',side='
    result += this.side.toString()
    result += ',type='
    result += this.type.toString()
    result += ',price='
    result += this.price.toString()
    result += ',volume='
    result += this.volume.toString()
    result += ',tp='
    result += this.tp.toString()
    result += ',sl='
    result += this.sl.toString()
    result += ')'
    return result
  }

  /**
   * Inspect struct
   * @this {!Order}
   * @returns {!string} Struct value string
   */
  [util.inspect.custom] () {
    return this.toString()
  }

  /**
   * Convert struct to JSON
   * @this {!Order}
   * @returns {!object} Struct value for JSON
   */
  toJSON () {
    return {
      id: ((this.id != null) ? this.id : null),
      symbol: ((this.symbol != null) ? this.symbol : null),
      side: ((this.side != null) ? this.side : null),
      type: ((this.type != null) ? this.type : null),
      price: ((this.price != null) ? this.price : null),
      volume: ((this.volume != null) ? this.volume : null),
      tp: ((this.tp != null) ? this.tp : null),
      sl: ((this.sl != null) ? this.sl : null)
    }
  }

  /**
   * Convert JSON to struct
   * @param {!string} json JSON string
   * @returns {!object} Struct value for JSON
   */
  static fromJSON (json) {
    return Order.fromObject(JSON.parse(json))
  }

  /**
   * Create struct from object value
   * @param {!Order} other Object value
   * @returns {!Order} Created struct
   */
  static fromObject (other) {
    return new Order().copy(other)
  }

  /**
   * Get the FBE type
   * @this {!Order}
   * @returns {!number} FBE type
   */
  get fbeType () {
    return Order.fbeType
  }

  /**
   * Get the FBE type (static)
   * @this {!Order}
   * @returns {!number} FBE type
   */
  static get fbeType () {
    return 1
  }
}

exports.Order = Order

/**
 * Fast Binary Encoding Order field model
 */
class FieldModelOrder extends fbe.FieldModel {
  /**
   * Initialize field model with the given buffer and offset
   * @param {!fbe.ReadBuffer|!fbe.WriteBuffer} buffer Buffer
   * @param {!number} offset Offset
   * @constructor
   */
  constructor (buffer, offset) {
    super(buffer, offset)
    this._id = new fbe.FieldModelInt32(buffer, 4 + 4)
    this._symbol = new fbe.FieldModelString(buffer, this._id.fbeOffset + this._id.fbeSize)
    this._side = new FieldModelOrderSide(buffer, this._symbol.fbeOffset + this._symbol.fbeSize)
    this._type = new FieldModelOrderType(buffer, this._side.fbeOffset + this._side.fbeSize)
    this._price = new fbe.FieldModelDouble(buffer, this._type.fbeOffset + this._type.fbeSize)
    this._volume = new fbe.FieldModelDouble(buffer, this._price.fbeOffset + this._price.fbeSize)
    this._tp = new fbe.FieldModelDouble(buffer, this._volume.fbeOffset + this._volume.fbeSize)
    this._sl = new fbe.FieldModelDouble(buffer, this._tp.fbeOffset + this._tp.fbeSize)
  }

  /**
   * Get the id field model
   * @this {!FieldModelOrder}
   * @returns {!fbe.FieldModelInt32} id field model
   */
  get id () {
    return this._id
  }

  /**
   * Get the symbol field model
   * @this {!FieldModelOrder}
   * @returns {!fbe.FieldModelString} symbol field model
   */
  get symbol () {
    return this._symbol
  }

  /**
   * Get the side field model
   * @this {!FieldModelOrder}
   * @returns {!FieldModelOrderSide} side field model
   */
  get side () {
    return this._side
  }

  /**
   * Get the type field model
   * @this {!FieldModelOrder}
   * @returns {!FieldModelOrderType} type field model
   */
  get type () {
    return this._type
  }

  /**
   * Get the price field model
   * @this {!FieldModelOrder}
   * @returns {!fbe.FieldModelDouble} price field model
   */
  get price () {
    return this._price
  }

  /**
   * Get the volume field model
   * @this {!FieldModelOrder}
   * @returns {!fbe.FieldModelDouble} volume field model
   */
  get volume () {
    return this._volume
  }

  /**
   * Get the tp field model
   * @this {!FieldModelOrder}
   * @returns {!fbe.FieldModelDouble} tp field model
   */
  get tp () {
    return this._tp
  }

  /**
   * Get the sl field model
   * @this {!FieldModelOrder}
   * @returns {!fbe.FieldModelDouble} sl field model
   */
  get sl () {
    return this._sl
  }

  /**
   * Get the field size
   * @this {!FieldModelOrder}
   * @returns {!number} Field size
   */
  get fbeSize () {
    return 4
  }

  /**
   * Get the field body size
   * @this {!FieldModelOrder}
   * @returns {!number} Field body size
   */
  get fbeBody () {
    return 4 + 4 + this.id.fbeSize + this.symbol.fbeSize + this.side.fbeSize + this.type.fbeSize + this.price.fbeSize + this.volume.fbeSize + this.tp.fbeSize + this.sl.fbeSize
  }

  /**
   * Get the field extra size
   * @this {!FieldModelOrder}
   * @returns {!number} Field extra size
   */
  get fbeExtra () {
    if ((this._buffer.offset + this.fbeOffset + this.fbeSize) > this._buffer.size) {
      return 0
    }

    let fbeStructOffset = this.readUInt32(this.fbeOffset)
    if ((fbeStructOffset === 0) || ((this._buffer.offset + fbeStructOffset + 4) > this._buffer.size)) {
      return 0
    }

    this._buffer.shift(fbeStructOffset)

    let fbeResult = this.fbeBody + this.id.fbeExtra + this.symbol.fbeExtra + this.side.fbeExtra + this.type.fbeExtra + this.price.fbeExtra + this.volume.fbeExtra + this.tp.fbeExtra + this.sl.fbeExtra

    this._buffer.unshift(fbeStructOffset)

    return fbeResult
  }

  /**
   * Get the field type
   * @this {!FieldModelOrder}
   * @returns {!number} Field type
   */
  get fbeType () {
    return FieldModelOrder.fbeType
  }

  /**
   * Get the field type (static)
   * @this {!FieldModelOrder}
   * @returns {!number} Field type
   */
  static get fbeType () {
    return 1
  }

  /**
   * Check if the struct value is valid
   * @this {!FieldModelOrder}
   * @param {!boolean} fbeVerifyType Verify model type flag, defaults is true
   * @returns {!boolean} Field model valid state
   */
  verify (fbeVerifyType = true) {
    if ((this._buffer.offset + this.fbeOffset + this.fbeSize) > this._buffer.size) {
      return true
    }

    let fbeStructOffset = this.readUInt32(this.fbeOffset)
    if ((fbeStructOffset === 0) || ((this._buffer.offset + fbeStructOffset + 4 + 4) > this._buffer.size)) {
      return false
    }

    let fbeStructSize = this.readUInt32(fbeStructOffset)
    if (fbeStructSize < (4 + 4)) {
      return false
    }

    let fbeStructType = this.readUInt32(fbeStructOffset + 4)
    if (fbeVerifyType && (fbeStructType !== this.fbeType)) {
      return false
    }

    this._buffer.shift(fbeStructOffset)
    let fbeResult = this.verifyFields(fbeStructSize)
    this._buffer.unshift(fbeStructOffset)
    return fbeResult
  }

  /**
   * Check if the struct fields are valid
   * @this {!FieldModelOrder}
   * @param {!number} fbeStructSize FBE struct size
   * @returns {!boolean} Field model valid state
   */
  verifyFields (fbeStructSize) {
    let fbeCurrentSize = 4 + 4

    if ((fbeCurrentSize + this.id.fbeSize) > fbeStructSize) {
      return true
    }
    if (!this.id.verify()) {
      return false
    }
    // noinspection JSUnusedAssignment
    fbeCurrentSize += this.id.fbeSize

    if ((fbeCurrentSize + this.symbol.fbeSize) > fbeStructSize) {
      return true
    }
    if (!this.symbol.verify()) {
      return false
    }
    // noinspection JSUnusedAssignment
    fbeCurrentSize += this.symbol.fbeSize

    if ((fbeCurrentSize + this.side.fbeSize) > fbeStructSize) {
      return true
    }
    if (!this.side.verify()) {
      return false
    }
    // noinspection JSUnusedAssignment
    fbeCurrentSize += this.side.fbeSize

    if ((fbeCurrentSize + this.type.fbeSize) > fbeStructSize) {
      return true
    }
    if (!this.type.verify()) {
      return false
    }
    // noinspection JSUnusedAssignment
    fbeCurrentSize += this.type.fbeSize

    if ((fbeCurrentSize + this.price.fbeSize) > fbeStructSize) {
      return true
    }
    if (!this.price.verify()) {
      return false
    }
    // noinspection JSUnusedAssignment
    fbeCurrentSize += this.price.fbeSize

    if ((fbeCurrentSize + this.volume.fbeSize) > fbeStructSize) {
      return true
    }
    if (!this.volume.verify()) {
      return false
    }
    // noinspection JSUnusedAssignment
    fbeCurrentSize += this.volume.fbeSize

    if ((fbeCurrentSize + this.tp.fbeSize) > fbeStructSize) {
      return true
    }
    if (!this.tp.verify()) {
      return false
    }
    // noinspection JSUnusedAssignment
    fbeCurrentSize += this.tp.fbeSize

    if ((fbeCurrentSize + this.sl.fbeSize) > fbeStructSize) {
      return true
    }
    if (!this.sl.verify()) {
      return false
    }
    // noinspection JSUnusedAssignment
    fbeCurrentSize += this.sl.fbeSize

    return true
  }

  /**
   * Get the struct value (begin phase)
   * @this {!FieldModelOrder}
   * @returns {!number} Field model begin offset
   */
  getBegin () {
    if ((this._buffer.offset + this.fbeOffset + this.fbeSize) > this._buffer.size) {
      return 0
    }

    let fbeStructOffset = this.readUInt32(this.fbeOffset)
    console.assert((fbeStructOffset > 0) && ((this._buffer.offset + fbeStructOffset + 4 + 4) <= this._buffer.size), 'Model is broken!')
    if ((fbeStructOffset === 0) || ((this._buffer.offset + fbeStructOffset + 4 + 4) > this._buffer.size)) {
      return 0
    }

    let fbeStructSize = this.readUInt32(fbeStructOffset)
    console.assert((fbeStructSize >= (4 + 4)), 'Model is broken!')
    if (fbeStructSize < (4 + 4)) {
      return 0
    }

    this._buffer.shift(fbeStructOffset)
    return fbeStructOffset
  }

  /**
   * Get the struct value (end phase)
   * @this {!FieldModelOrder}
   * @param {!number} fbeBegin Field model begin offset
   */
  getEnd (fbeBegin) {
    this._buffer.unshift(fbeBegin)
  }

  /**
   * Get the struct value
   * @this {!FieldModelOrder}
   * @param {!Order} fbeValue Default value, defaults is new Order()
   * @returns {!Order} Order value
   */
  get (fbeValue = new Order()) {
    let fbeBegin = this.getBegin()
    if (fbeBegin === 0) {
      return fbeValue
    }

    let fbeStructSize = this.readUInt32(0)
    this.getFields(fbeValue, fbeStructSize)
    this.getEnd(fbeBegin)
    return fbeValue
  }

  /**
   * Get the struct fields values
   * @this {!FieldModelOrder}
   * @param {!Order} fbeValue Order value
   * @param {!number} fbeStructSize Struct size
   */
  getFields (fbeValue, fbeStructSize) {
    let fbeCurrentSize = 4 + 4

    if ((fbeCurrentSize + this.id.fbeSize) <= fbeStructSize) {
      fbeValue.id = this.id.get()
    } else {
      fbeValue.id = 0
    }
    // noinspection JSUnusedAssignment
    fbeCurrentSize += this.id.fbeSize

    if ((fbeCurrentSize + this.symbol.fbeSize) <= fbeStructSize) {
      fbeValue.symbol = this.symbol.get()
    } else {
      fbeValue.symbol = ''
    }
    // noinspection JSUnusedAssignment
    fbeCurrentSize += this.symbol.fbeSize

    if ((fbeCurrentSize + this.side.fbeSize) <= fbeStructSize) {
      fbeValue.side = this.side.get()
    } else {
      fbeValue.side = new OrderSide()
    }
    // noinspection JSUnusedAssignment
    fbeCurrentSize += this.side.fbeSize

    if ((fbeCurrentSize + this.type.fbeSize) <= fbeStructSize) {
      fbeValue.type = this.type.get()
    } else {
      fbeValue.type = new OrderType()
    }
    // noinspection JSUnusedAssignment
    fbeCurrentSize += this.type.fbeSize

    if ((fbeCurrentSize + this.price.fbeSize) <= fbeStructSize) {
      fbeValue.price = this.price.get(0.0)
    } else {
      fbeValue.price = 0.0
    }
    // noinspection JSUnusedAssignment
    fbeCurrentSize += this.price.fbeSize

    if ((fbeCurrentSize + this.volume.fbeSize) <= fbeStructSize) {
      fbeValue.volume = this.volume.get(0.0)
    } else {
      fbeValue.volume = 0.0
    }
    // noinspection JSUnusedAssignment
    fbeCurrentSize += this.volume.fbeSize

    if ((fbeCurrentSize + this.tp.fbeSize) <= fbeStructSize) {
      fbeValue.tp = this.tp.get(10.0)
    } else {
      fbeValue.tp = 10.0
    }
    // noinspection JSUnusedAssignment
    fbeCurrentSize += this.tp.fbeSize

    if ((fbeCurrentSize + this.sl.fbeSize) <= fbeStructSize) {
      fbeValue.sl = this.sl.get(-10.0)
    } else {
      fbeValue.sl = -10.0
    }
    // noinspection JSUnusedAssignment
    fbeCurrentSize += this.sl.fbeSize
  }

  /**
   * Set the struct value (begin phase)
   * @this {!FieldModelOrder}
   * @returns {!number} Field model begin offset
   */
  setBegin () {
    console.assert(((this._buffer.offset + this.fbeOffset + this.fbeSize) <= this._buffer.size), 'Model is broken!')
    if ((this._buffer.offset + this.fbeOffset + this.fbeSize) > this._buffer.size) {
      return 0
    }

    let fbeStructSize = this.fbeBody
    let fbeStructOffset = this._buffer.allocate(fbeStructSize) - this._buffer.offset
    console.assert((fbeStructOffset > 0) && ((this._buffer.offset + fbeStructOffset + fbeStructSize) <= this._buffer.size), 'Model is broken!')
    if ((fbeStructOffset <= 0) || ((this._buffer.offset + fbeStructOffset + fbeStructSize) > this._buffer.size)) {
      return 0
    }

    this.writeUInt32(this.fbeOffset, fbeStructOffset)
    this.writeUInt32(fbeStructOffset, fbeStructSize)
    this.writeUInt32(fbeStructOffset + 4, this.fbeType)

    this._buffer.shift(fbeStructOffset)
    return fbeStructOffset
  }

  /**
   * Set the struct value (end phase)
   * @this {!FieldModelOrder}
   * @param {!number} fbeBegin Field model begin offset
   */
  setEnd (fbeBegin) {
    this._buffer.unshift(fbeBegin)
  }

  /**
   * Set the struct value
   * @this {!FieldModelOrder}
   * @param {!Order} fbeValue Order value
   */
  set (fbeValue) {
    let fbeBegin = this.setBegin()
    if (fbeBegin === 0) {
      return
    }

    this.setFields(fbeValue)
    this.setEnd(fbeBegin)
  }

  /**
   * Set the struct fields values
   * @this {!FieldModelOrder}
   * @param {Order} fbeValue Order value
   */
  setFields (fbeValue) {
    this.id.set(fbeValue.id)
    this.symbol.set(fbeValue.symbol)
    this.side.set(fbeValue.side)
    this.type.set(fbeValue.type)
    this.price.set(fbeValue.price)
    this.volume.set(fbeValue.volume)
    this.tp.set(fbeValue.tp)
    this.sl.set(fbeValue.sl)
  }
}

exports.FieldModelOrder = FieldModelOrder

/**
 * Fast Binary Encoding Order model
 */
class OrderModel extends fbe.Model {
  /**
   * Initialize model with the given buffer
   * @param {!fbe.ReadBuffer|!fbe.WriteBuffer} buffer Read/Write buffer, defaults is new fbe.WriteBuffer()
   * @constructor
   */
  constructor (buffer = new fbe.WriteBuffer()) {
    super(buffer)
    this._model = new FieldModelOrder(this.buffer, 4)
  }

  /**
   * Get the Order model
   * @this {!OrderModel}
   * @returns {!FieldModelOrder} model Order model
   */
  get model () {
    return this._model
  }

  /**
   * Get the model size
   * @this {!OrderModel}
   * @returns {!number} Model size
   */
  get fbeSize () {
    return this.model.fbeSize + this.model.fbeExtra
  }

  /**
   * Get the model type
   * @this {!OrderModel}
   * @returns {!number} Model type
   */
  get fbeType () {
    return OrderModel.fbeType
  }

  /**
   * Get the model type (static)
   * @this {!OrderModel}
   * @returns {!number} Model type
   */
  static get fbeType () {
    return FieldModelOrder.fbeType
  }

  /**
   * Check if the struct value is valid
   * @this {!OrderModel}
   * @returns {!boolean} Model valid state
   */
  verify () {
    if ((this.buffer.offset + this.model.fbeOffset - 4) > this.buffer.size) {
      return false
    }

    let fbeFullSize = this.readUInt32(this.model.fbeOffset - 4)
    if (fbeFullSize < this.model.fbeSize) {
      return false
    }

    return this.model.verify()
  }

  /**
   * Create a new model (begin phase)
   * @this {!OrderModel}
   * @returns {!number} Model begin offset
   */
  createBegin () {
    return this.buffer.allocate(4 + this.model.fbeSize)
  }

  /**
   * Create a new model (end phase)
   * @this {!OrderModel}
   * @param {!number} fbeBegin Model begin offset
   */
  createEnd (fbeBegin) {
    let fbeEnd = this.buffer.size
    let fbeFullSize = fbeEnd - fbeBegin
    this.writeUInt32(this.model.fbeOffset - 4, fbeFullSize)
    return fbeFullSize
  }

  /**
   * Serialize the struct value
   * @this {!OrderModel}
   * @param {!Order} value Order value
   * @return {!number} Model begin offset
   */
  serialize (value) {
    let fbeBegin = this.createBegin()
    this.model.set(value)
    return this.createEnd(fbeBegin)
  }

  /**
   * Deserialize the struct value
   * @this {!OrderModel}
   * @param {!Order} value Order value, defaults is new Order()
   * @return {!object} Deserialized Order value and its size
   */
  deserialize (value = new Order()) {
    if ((this.buffer.offset + this.model.fbeOffset - 4) > this.buffer.size) {
      return { value: new Order(), size: 0 }
    }

    let fbeFullSize = this.readUInt32(this.model.fbeOffset - 4)
    console.assert((fbeFullSize >= this.model.fbeSize), 'Model is broken!')
    if (fbeFullSize < this.model.fbeSize) {
      return { value: new Order(), size: 0 }
    }

    this.model.get(value)
    return { value: value, size: fbeFullSize }
  }

  /**
   * Move to the next struct value
   * @this {!OrderModel}
   * @param {!number} prev Previous Order model size
   */
  next (prev) {
    this.model.fbeShift(prev)
  }
}

exports.OrderModel = OrderModel

/**
 * Fast Binary Encoding Order final model
 */
class FinalModelOrder extends fbe.FinalModel {
  /**
   * Initialize final model with the given buffer and offset
   * @param {!fbe.ReadBuffer|!fbe.WriteBuffer} buffer Buffer
   * @param {!number} offset Offset
   * @constructor
   */
  constructor (buffer, offset) {
    super(buffer, offset)
    this._id = new fbe.FinalModelInt32(buffer, 0)
    this._symbol = new fbe.FinalModelString(buffer, 0)
    this._side = new FinalModelOrderSide(buffer, 0)
    this._type = new FinalModelOrderType(buffer, 0)
    this._price = new fbe.FinalModelDouble(buffer, 0)
    this._volume = new fbe.FinalModelDouble(buffer, 0)
    this._tp = new fbe.FinalModelDouble(buffer, 0)
    this._sl = new fbe.FinalModelDouble(buffer, 0)
  }

  /**
   * Get the id final model
   * @this {!FinalModelOrder}
   * @returns {!fbe.FinalModelInt32} id final model
   */
  get id () {
    return this._id
  }

  /**
   * Get the symbol final model
   * @this {!FinalModelOrder}
   * @returns {!fbe.FinalModelString} symbol final model
   */
  get symbol () {
    return this._symbol
  }

  /**
   * Get the side final model
   * @this {!FinalModelOrder}
   * @returns {!FinalModelOrderSide} side final model
   */
  get side () {
    return this._side
  }

  /**
   * Get the type final model
   * @this {!FinalModelOrder}
   * @returns {!FinalModelOrderType} type final model
   */
  get type () {
    return this._type
  }

  /**
   * Get the price final model
   * @this {!FinalModelOrder}
   * @returns {!fbe.FinalModelDouble} price final model
   */
  get price () {
    return this._price
  }

  /**
   * Get the volume final model
   * @this {!FinalModelOrder}
   * @returns {!fbe.FinalModelDouble} volume final model
   */
  get volume () {
    return this._volume
  }

  /**
   * Get the tp final model
   * @this {!FinalModelOrder}
   * @returns {!fbe.FinalModelDouble} tp final model
   */
  get tp () {
    return this._tp
  }

  /**
   * Get the sl final model
   * @this {!FinalModelOrder}
   * @returns {!fbe.FinalModelDouble} sl final model
   */
  get sl () {
    return this._sl
  }

  /**
   * Get the allocation size
   * @this {!FinalModelOrder}
   * @param {!Order} fbeValue Order value
   * @returns {!number} Allocation size
   */
  fbeAllocationSize (fbeValue) {
    return 0 + this.id.fbeAllocationSize(fbeValue.id) + this.symbol.fbeAllocationSize(fbeValue.symbol) + this.side.fbeAllocationSize(fbeValue.side) + this.type.fbeAllocationSize(fbeValue.type) + this.price.fbeAllocationSize(fbeValue.price) + this.volume.fbeAllocationSize(fbeValue.volume) + this.tp.fbeAllocationSize(fbeValue.tp) + this.sl.fbeAllocationSize(fbeValue.sl)
  }

  /**
   * Get the final type
   * @this {!FinalModelOrder}
   * @returns {!number} Final type
   */
  get fbeType () {
    return FinalModelOrder.fbeType
  }

  /**
   * Get the final type (static)
   * @this {!FinalModelOrder}
   * @returns {!number} Final type
   */
  static get fbeType () {
    return 1
  }

  /**
   * Check if the struct value is valid
   * @this {!FinalModelOrder}
   * @returns {!number} Final model size or Number.MAX_SAFE_INTEGER in case of any error
   */
  verify () {
    this._buffer.shift(this.fbeOffset)
    let fbeResult = this.verifyFields()
    this._buffer.unshift(this.fbeOffset)
    return fbeResult
  }

  /**
   * Check if the struct fields are valid
   * @this {!FinalModelOrder}
   * @returns {!number} Final model size or Number.MAX_SAFE_INTEGER in case of any error
   */
  verifyFields () {
    let fbeCurrentOffset = 0
    let fbeFieldSize

    this.id.fbeOffset = fbeCurrentOffset
    fbeFieldSize = this.id.verify()
    if (fbeFieldSize === Number.MAX_SAFE_INTEGER) {
      return Number.MAX_SAFE_INTEGER
    }
    fbeCurrentOffset += fbeFieldSize

    this.symbol.fbeOffset = fbeCurrentOffset
    fbeFieldSize = this.symbol.verify()
    if (fbeFieldSize === Number.MAX_SAFE_INTEGER) {
      return Number.MAX_SAFE_INTEGER
    }
    fbeCurrentOffset += fbeFieldSize

    this.side.fbeOffset = fbeCurrentOffset
    fbeFieldSize = this.side.verify()
    if (fbeFieldSize === Number.MAX_SAFE_INTEGER) {
      return Number.MAX_SAFE_INTEGER
    }
    fbeCurrentOffset += fbeFieldSize

    this.type.fbeOffset = fbeCurrentOffset
    fbeFieldSize = this.type.verify()
    if (fbeFieldSize === Number.MAX_SAFE_INTEGER) {
      return Number.MAX_SAFE_INTEGER
    }
    fbeCurrentOffset += fbeFieldSize

    this.price.fbeOffset = fbeCurrentOffset
    fbeFieldSize = this.price.verify()
    if (fbeFieldSize === Number.MAX_SAFE_INTEGER) {
      return Number.MAX_SAFE_INTEGER
    }
    fbeCurrentOffset += fbeFieldSize

    this.volume.fbeOffset = fbeCurrentOffset
    fbeFieldSize = this.volume.verify()
    if (fbeFieldSize === Number.MAX_SAFE_INTEGER) {
      return Number.MAX_SAFE_INTEGER
    }
    fbeCurrentOffset += fbeFieldSize

    this.tp.fbeOffset = fbeCurrentOffset
    fbeFieldSize = this.tp.verify()
    if (fbeFieldSize === Number.MAX_SAFE_INTEGER) {
      return Number.MAX_SAFE_INTEGER
    }
    fbeCurrentOffset += fbeFieldSize

    this.sl.fbeOffset = fbeCurrentOffset
    fbeFieldSize = this.sl.verify()
    if (fbeFieldSize === Number.MAX_SAFE_INTEGER) {
      return Number.MAX_SAFE_INTEGER
    }
    fbeCurrentOffset += fbeFieldSize

    return fbeCurrentOffset
  }

  /**
   * Get the struct value
   * @this {!FinalModelOrder}
   * @param {!Order} fbeValue Order value, defaults is new Order()
   * @returns {!object} Result struct value and its size
   */
  get (fbeValue = new Order()) {
    this._buffer.shift(this.fbeOffset)
    let fbeSize = this.getFields(fbeValue)
    this._buffer.unshift(this.fbeOffset)
    return { value: fbeValue, size: fbeSize }
  }

  /**
   * Get the struct fields values
   * @this {!FinalModelOrder}
   * @param {!Order} fbeValue Order value
   * @returns {!number} Struct size
   */
  getFields (fbeValue) {
    let fbeCurrentOffset = 0
    let fbeCurrentSize = 0
    let fbeResult

    this.id.fbeOffset = fbeCurrentOffset
    fbeResult = this.id.get()
    fbeValue.id = fbeResult.value
    // noinspection JSUnusedAssignment
    fbeCurrentOffset += fbeResult.size
    fbeCurrentSize += fbeResult.size

    this.symbol.fbeOffset = fbeCurrentOffset
    fbeResult = this.symbol.get()
    fbeValue.symbol = fbeResult.value
    // noinspection JSUnusedAssignment
    fbeCurrentOffset += fbeResult.size
    fbeCurrentSize += fbeResult.size

    this.side.fbeOffset = fbeCurrentOffset
    fbeResult = this.side.get()
    fbeValue.side = fbeResult.value
    // noinspection JSUnusedAssignment
    fbeCurrentOffset += fbeResult.size
    fbeCurrentSize += fbeResult.size

    this.type.fbeOffset = fbeCurrentOffset
    fbeResult = this.type.get()
    fbeValue.type = fbeResult.value
    // noinspection JSUnusedAssignment
    fbeCurrentOffset += fbeResult.size
    fbeCurrentSize += fbeResult.size

    this.price.fbeOffset = fbeCurrentOffset
    fbeResult = this.price.get()
    fbeValue.price = fbeResult.value
    // noinspection JSUnusedAssignment
    fbeCurrentOffset += fbeResult.size
    fbeCurrentSize += fbeResult.size

    this.volume.fbeOffset = fbeCurrentOffset
    fbeResult = this.volume.get()
    fbeValue.volume = fbeResult.value
    // noinspection JSUnusedAssignment
    fbeCurrentOffset += fbeResult.size
    fbeCurrentSize += fbeResult.size

    this.tp.fbeOffset = fbeCurrentOffset
    fbeResult = this.tp.get()
    fbeValue.tp = fbeResult.value
    // noinspection JSUnusedAssignment
    fbeCurrentOffset += fbeResult.size
    fbeCurrentSize += fbeResult.size

    this.sl.fbeOffset = fbeCurrentOffset
    fbeResult = this.sl.get()
    fbeValue.sl = fbeResult.value
    // noinspection JSUnusedAssignment
    fbeCurrentOffset += fbeResult.size
    fbeCurrentSize += fbeResult.size

    return fbeCurrentSize
  }

  /**
   * Set the struct value
   * @this {!FinalModelOrder}
   * @param {!Order} fbeValue Order value
   * @returns {!number} Final model size
   */
  set (fbeValue) {
    this._buffer.shift(this.fbeOffset)
    let fbeSize = this.setFields(fbeValue)
    this._buffer.unshift(this.fbeOffset)
    return fbeSize
  }

  /**
   * Set the struct fields values
   * @this {!FinalModelOrder}
   * @param {Order} fbeValue Order value
   * @returns {!number} Final model size
   */
  setFields (fbeValue) {
    let fbeCurrentOffset = 0
    let fbeCurrentSize = 0
    let fbeFieldSize

    this.id.fbeOffset = fbeCurrentOffset
    fbeFieldSize = this.id.set(fbeValue.id)
    // noinspection JSUnusedAssignment
    fbeCurrentOffset += fbeFieldSize
    fbeCurrentSize += fbeFieldSize

    this.symbol.fbeOffset = fbeCurrentOffset
    fbeFieldSize = this.symbol.set(fbeValue.symbol)
    // noinspection JSUnusedAssignment
    fbeCurrentOffset += fbeFieldSize
    fbeCurrentSize += fbeFieldSize

    this.side.fbeOffset = fbeCurrentOffset
    fbeFieldSize = this.side.set(fbeValue.side)
    // noinspection JSUnusedAssignment
    fbeCurrentOffset += fbeFieldSize
    fbeCurrentSize += fbeFieldSize

    this.type.fbeOffset = fbeCurrentOffset
    fbeFieldSize = this.type.set(fbeValue.type)
    // noinspection JSUnusedAssignment
    fbeCurrentOffset += fbeFieldSize
    fbeCurrentSize += fbeFieldSize

    this.price.fbeOffset = fbeCurrentOffset
    fbeFieldSize = this.price.set(fbeValue.price)
    // noinspection JSUnusedAssignment
    fbeCurrentOffset += fbeFieldSize
    fbeCurrentSize += fbeFieldSize

    this.volume.fbeOffset = fbeCurrentOffset
    fbeFieldSize = this.volume.set(fbeValue.volume)
    // noinspection JSUnusedAssignment
    fbeCurrentOffset += fbeFieldSize
    fbeCurrentSize += fbeFieldSize

    this.tp.fbeOffset = fbeCurrentOffset
    fbeFieldSize = this.tp.set(fbeValue.tp)
    // noinspection JSUnusedAssignment
    fbeCurrentOffset += fbeFieldSize
    fbeCurrentSize += fbeFieldSize

    this.sl.fbeOffset = fbeCurrentOffset
    fbeFieldSize = this.sl.set(fbeValue.sl)
    // noinspection JSUnusedAssignment
    fbeCurrentOffset += fbeFieldSize
    fbeCurrentSize += fbeFieldSize

    return fbeCurrentSize
  }
}

exports.FinalModelOrder = FinalModelOrder

/**
 * Fast Binary Encoding Order final model
 */
class OrderFinalModel extends fbe.Model {
  /**
   * Initialize final model with the given buffer
   * @param {!fbe.ReadBuffer|!fbe.WriteBuffer} buffer Read/Write buffer, defaults is new fbe.WriteBuffer()
   * @constructor
   */
  constructor (buffer = new fbe.WriteBuffer()) {
    super(buffer)
    this._model = new FinalModelOrder(this.buffer, 8)
  }

  /**
   * Get the model type
   * @this {!OrderFinalModel}
   * @returns {!number} Model type
   */
  get fbeType () {
    return OrderFinalModel.fbeType
  }

  /**
   * Get the model type (static)
   * @this {!OrderFinalModel}
   * @returns {!number} Model type
   */
  static get fbeType () {
    return FinalModelOrder.fbeType
  }

  /**
   * Check if the struct value is valid
   * @this {!OrderFinalModel}
   * @returns {!boolean} Model valid state
   */
  verify () {
    if ((this.buffer.offset + this._model.fbeOffset) > this.buffer.size) {
      return false
    }

    let fbeStructSize = this.readUInt32(this._model.fbeOffset - 8)
    let fbeStructType = this.readUInt32(this._model.fbeOffset - 4)
    if ((fbeStructSize <= 0) || (fbeStructType !== this.fbeType)) {
      return false
    }

    return ((8 + this._model.verify()) === fbeStructSize)
  }

  /**
   * Serialize the struct value
   * @this {!OrderFinalModel}
   * @param {!Order} value Order value
   * @return {!number} Struct size
   */
  serialize (value) {
    let fbeInitialSize = this.buffer.size

    let fbeStructType = this.fbeType
    let fbeStructSize = 8 + this._model.fbeAllocationSize(value)
    let fbeStructOffset = this.buffer.allocate(fbeStructSize) - this.buffer.offset
    console.assert(((this.buffer.offset + fbeStructOffset + fbeStructSize) <= this.buffer.size), 'Model is broken!')
    if ((this.buffer.offset + fbeStructOffset + fbeStructSize) > this.buffer.size) {
      return 0
    }

    fbeStructSize = 8 + this._model.set(value)
    this.buffer.resize(fbeInitialSize + fbeStructSize)

    this.writeUInt32(this._model.fbeOffset - 8, fbeStructSize)
    this.writeUInt32(this._model.fbeOffset - 4, fbeStructType)

    return fbeStructSize
  }

  /**
   * Deserialize the struct value
   * @this {!OrderFinalModel}
   * @param {!Order} value Order value, defaults is new Order()
   * @return {!object} Deserialized Order value and its size
   */
  deserialize (value = new Order()) {
    console.assert(((this.buffer.offset + this._model.fbeOffset) <= this.buffer.size), 'Model is broken!')
    if ((this.buffer.offset + this._model.fbeOffset) > this.buffer.size) {
      return { value: new Order(), size: 0 }
    }

    let fbeStructSize = this.readUInt32(this._model.fbeOffset - 8)
    let fbeStructType = this.readUInt32(this._model.fbeOffset - 4)
    console.assert(((fbeStructSize > 0) && (fbeStructType === this.fbeType)), 'Model is broken!')
    if ((fbeStructSize <= 0) || (fbeStructType !== this.fbeType)) {
      return { value: new Order(), size: 8 }
    }

    let fbeResult = this._model.get(value)
    return { value: fbeResult.value, size: (8 + fbeResult.size) }
  }

  /**
   * Move to the next struct value
   * @this {!OrderFinalModel}
   * @param {!number} prev Previous Order model size
   */
  next (prev) {
    this._model.fbeShift(prev)
  }
}

exports.OrderFinalModel = OrderFinalModel

/**
 * Balance struct
 */
class Balance extends proto.Balance {
  /**
   * Initialize struct
   * @param {!proto.Balance=} parent
   * @param {!number=} locked
   * @constructor
   */
  constructor (parent = new proto.Balance(), arglocked = 0.0) {
    super()
    super.copy(parent)
    this.locked = arglocked
  }

  /**
   * Copy struct (shallow copy)
   * @this {!Balance}
   * @param {!Balance} other Other struct
   * @returns {!Balance} This struct
   */
  copy (other) {
    super.copy(other)
    if (other.locked != null) {
      this.locked = other.locked
    } else {
      this.locked = undefined
    }
    return this
  }

  /**
   * Clone struct (deep clone)
   * @this {!Balance}
   * @returns {!Balance} Cloned struct
   */
  clone () {
    // Serialize the struct to the FBE stream
    let writer = new BalanceModel(new fbe.WriteBuffer())
    writer.serialize(this)

    // Deserialize the struct from the FBE stream
    let reader = new BalanceModel(new fbe.ReadBuffer())
    reader.attachBuffer(writer.buffer)
    return reader.deserialize().value
  }

  /**
   * Is this struct equal to other one?
   * @this {!Balance}
   * @param {!Balance} other Other struct
   * @returns {boolean} Equal result
   */
  eq (other) {
    if (!(other instanceof Balance)) {
      throw new TypeError('Instance of Balance is required!')
    }
    // noinspection RedundantIfStatementJS
    if (!super.eq(other)) {
      return false
    }
    return true
  }

  /**
   * Convert struct to string
   * @this {!Balance}
   * @returns {!string} Struct value string
   */
  toString () {
    let result = ''
    result += 'Balance('
    result += super.toString()
    result += ',locked='
    result += this.locked.toString()
    result += ')'
    return result
  }

  /**
   * Inspect struct
   * @this {!Balance}
   * @returns {!string} Struct value string
   */
  [util.inspect.custom] () {
    return this.toString()
  }

  /**
   * Convert struct to JSON
   * @this {!Balance}
   * @returns {!object} Struct value for JSON
   */
  toJSON () {
    let parent = super.toJSON()
    let current = {
      locked: ((this.locked != null) ? this.locked : null)
    }
    return { ...parent, ...current }
  }

  /**
   * Convert JSON to struct
   * @param {!string} json JSON string
   * @returns {!object} Struct value for JSON
   */
  static fromJSON (json) {
    return Balance.fromObject(JSON.parse(json))
  }

  /**
   * Create struct from object value
   * @param {!Balance} other Object value
   * @returns {!Balance} Created struct
   */
  static fromObject (other) {
    return new Balance().copy(other)
  }

  /**
   * Get the FBE type
   * @this {!Balance}
   * @returns {!number} FBE type
   */
  get fbeType () {
    return Balance.fbeType
  }

  /**
   * Get the FBE type (static)
   * @this {!Balance}
   * @returns {!number} FBE type
   */
  static get fbeType () {
    return proto.Balance.fbeType
  }
}

exports.Balance = Balance

/**
 * Fast Binary Encoding Balance field model
 */
class FieldModelBalance extends fbe.FieldModel {
  /**
   * Initialize field model with the given buffer and offset
   * @param {!fbe.ReadBuffer|!fbe.WriteBuffer} buffer Buffer
   * @param {!number} offset Offset
   * @constructor
   */
  constructor (buffer, offset) {
    super(buffer, offset)
    this._parent = new proto.FieldModelBalance(buffer, 4 + 4)
    this._locked = new fbe.FieldModelDouble(buffer, this._parent.fbeOffset + this._parent.fbeBody - 4 - 4)
  }

  /**
   * Get the proto.Balance field model
   * @this {!FieldModelBalance}
   * @returns {!proto.FieldModelBalance} proto.Balance field model
   */
  get parent () {
    return this._parent
  }

  /**
   * Get the locked field model
   * @this {!FieldModelBalance}
   * @returns {!fbe.FieldModelDouble} locked field model
   */
  get locked () {
    return this._locked
  }

  /**
   * Get the field size
   * @this {!FieldModelBalance}
   * @returns {!number} Field size
   */
  get fbeSize () {
    return 4
  }

  /**
   * Get the field body size
   * @this {!FieldModelBalance}
   * @returns {!number} Field body size
   */
  get fbeBody () {
    return 4 + 4 + this.parent.fbeBody - 4 - 4 + this.locked.fbeSize
  }

  /**
   * Get the field extra size
   * @this {!FieldModelBalance}
   * @returns {!number} Field extra size
   */
  get fbeExtra () {
    if ((this._buffer.offset + this.fbeOffset + this.fbeSize) > this._buffer.size) {
      return 0
    }

    let fbeStructOffset = this.readUInt32(this.fbeOffset)
    if ((fbeStructOffset === 0) || ((this._buffer.offset + fbeStructOffset + 4) > this._buffer.size)) {
      return 0
    }

    this._buffer.shift(fbeStructOffset)

    let fbeResult = this.fbeBody + this.parent.fbeExtra + this.locked.fbeExtra

    this._buffer.unshift(fbeStructOffset)

    return fbeResult
  }

  /**
   * Get the field type
   * @this {!FieldModelBalance}
   * @returns {!number} Field type
   */
  get fbeType () {
    return FieldModelBalance.fbeType
  }

  /**
   * Get the field type (static)
   * @this {!FieldModelBalance}
   * @returns {!number} Field type
   */
  static get fbeType () {
    return proto.FieldModelBalance.fbeType
  }

  /**
   * Check if the struct value is valid
   * @this {!FieldModelBalance}
   * @param {!boolean} fbeVerifyType Verify model type flag, defaults is true
   * @returns {!boolean} Field model valid state
   */
  verify (fbeVerifyType = true) {
    if ((this._buffer.offset + this.fbeOffset + this.fbeSize) > this._buffer.size) {
      return true
    }

    let fbeStructOffset = this.readUInt32(this.fbeOffset)
    if ((fbeStructOffset === 0) || ((this._buffer.offset + fbeStructOffset + 4 + 4) > this._buffer.size)) {
      return false
    }

    let fbeStructSize = this.readUInt32(fbeStructOffset)
    if (fbeStructSize < (4 + 4)) {
      return false
    }

    let fbeStructType = this.readUInt32(fbeStructOffset + 4)
    if (fbeVerifyType && (fbeStructType !== this.fbeType)) {
      return false
    }

    this._buffer.shift(fbeStructOffset)
    let fbeResult = this.verifyFields(fbeStructSize)
    this._buffer.unshift(fbeStructOffset)
    return fbeResult
  }

  /**
   * Check if the struct fields are valid
   * @this {!FieldModelBalance}
   * @param {!number} fbeStructSize FBE struct size
   * @returns {!boolean} Field model valid state
   */
  verifyFields (fbeStructSize) {
    let fbeCurrentSize = 4 + 4

    if ((fbeCurrentSize + this.parent.fbeBody - 4 - 4) > fbeStructSize) {
      return true
    }
    if (!this.parent.verifyFields(fbeStructSize)) {
      return false
    }
    // noinspection JSUnusedAssignment
    fbeCurrentSize += this.parent.fbeBody - 4 - 4

    if ((fbeCurrentSize + this.locked.fbeSize) > fbeStructSize) {
      return true
    }
    if (!this.locked.verify()) {
      return false
    }
    // noinspection JSUnusedAssignment
    fbeCurrentSize += this.locked.fbeSize

    return true
  }

  /**
   * Get the struct value (begin phase)
   * @this {!FieldModelBalance}
   * @returns {!number} Field model begin offset
   */
  getBegin () {
    if ((this._buffer.offset + this.fbeOffset + this.fbeSize) > this._buffer.size) {
      return 0
    }

    let fbeStructOffset = this.readUInt32(this.fbeOffset)
    console.assert((fbeStructOffset > 0) && ((this._buffer.offset + fbeStructOffset + 4 + 4) <= this._buffer.size), 'Model is broken!')
    if ((fbeStructOffset === 0) || ((this._buffer.offset + fbeStructOffset + 4 + 4) > this._buffer.size)) {
      return 0
    }

    let fbeStructSize = this.readUInt32(fbeStructOffset)
    console.assert((fbeStructSize >= (4 + 4)), 'Model is broken!')
    if (fbeStructSize < (4 + 4)) {
      return 0
    }

    this._buffer.shift(fbeStructOffset)
    return fbeStructOffset
  }

  /**
   * Get the struct value (end phase)
   * @this {!FieldModelBalance}
   * @param {!number} fbeBegin Field model begin offset
   */
  getEnd (fbeBegin) {
    this._buffer.unshift(fbeBegin)
  }

  /**
   * Get the struct value
   * @this {!FieldModelBalance}
   * @param {!Balance} fbeValue Default value, defaults is new Balance()
   * @returns {!Balance} Balance value
   */
  get (fbeValue = new Balance()) {
    let fbeBegin = this.getBegin()
    if (fbeBegin === 0) {
      return fbeValue
    }

    let fbeStructSize = this.readUInt32(0)
    this.getFields(fbeValue, fbeStructSize)
    this.getEnd(fbeBegin)
    return fbeValue
  }

  /**
   * Get the struct fields values
   * @this {!FieldModelBalance}
   * @param {!Balance} fbeValue Balance value
   * @param {!number} fbeStructSize Struct size
   */
  getFields (fbeValue, fbeStructSize) {
    let fbeCurrentSize = 4 + 4

    if ((fbeCurrentSize + this.parent.fbeBody - 4 - 4) <= fbeStructSize) {
      this.parent.getFields(fbeValue, fbeStructSize)
    }
    // noinspection JSUnusedAssignment
    fbeCurrentSize += this.parent.fbeBody - 4 - 4

    if ((fbeCurrentSize + this.locked.fbeSize) <= fbeStructSize) {
      fbeValue.locked = this.locked.get(0.0)
    } else {
      fbeValue.locked = 0.0
    }
    // noinspection JSUnusedAssignment
    fbeCurrentSize += this.locked.fbeSize
  }

  /**
   * Set the struct value (begin phase)
   * @this {!FieldModelBalance}
   * @returns {!number} Field model begin offset
   */
  setBegin () {
    console.assert(((this._buffer.offset + this.fbeOffset + this.fbeSize) <= this._buffer.size), 'Model is broken!')
    if ((this._buffer.offset + this.fbeOffset + this.fbeSize) > this._buffer.size) {
      return 0
    }

    let fbeStructSize = this.fbeBody
    let fbeStructOffset = this._buffer.allocate(fbeStructSize) - this._buffer.offset
    console.assert((fbeStructOffset > 0) && ((this._buffer.offset + fbeStructOffset + fbeStructSize) <= this._buffer.size), 'Model is broken!')
    if ((fbeStructOffset <= 0) || ((this._buffer.offset + fbeStructOffset + fbeStructSize) > this._buffer.size)) {
      return 0
    }

    this.writeUInt32(this.fbeOffset, fbeStructOffset)
    this.writeUInt32(fbeStructOffset, fbeStructSize)
    this.writeUInt32(fbeStructOffset + 4, this.fbeType)

    this._buffer.shift(fbeStructOffset)
    return fbeStructOffset
  }

  /**
   * Set the struct value (end phase)
   * @this {!FieldModelBalance}
   * @param {!number} fbeBegin Field model begin offset
   */
  setEnd (fbeBegin) {
    this._buffer.unshift(fbeBegin)
  }

  /**
   * Set the struct value
   * @this {!FieldModelBalance}
   * @param {!Balance} fbeValue Balance value
   */
  set (fbeValue) {
    let fbeBegin = this.setBegin()
    if (fbeBegin === 0) {
      return
    }

    this.setFields(fbeValue)
    this.setEnd(fbeBegin)
  }

  /**
   * Set the struct fields values
   * @this {!FieldModelBalance}
   * @param {Balance} fbeValue Balance value
   */
  setFields (fbeValue) {
    this.parent.setFields(fbeValue)
    this.locked.set(fbeValue.locked)
  }
}

exports.FieldModelBalance = FieldModelBalance

/**
 * Fast Binary Encoding Balance model
 */
class BalanceModel extends fbe.Model {
  /**
   * Initialize model with the given buffer
   * @param {!fbe.ReadBuffer|!fbe.WriteBuffer} buffer Read/Write buffer, defaults is new fbe.WriteBuffer()
   * @constructor
   */
  constructor (buffer = new fbe.WriteBuffer()) {
    super(buffer)
    this._model = new FieldModelBalance(this.buffer, 4)
  }

  /**
   * Get the Balance model
   * @this {!BalanceModel}
   * @returns {!FieldModelBalance} model Balance model
   */
  get model () {
    return this._model
  }

  /**
   * Get the model size
   * @this {!BalanceModel}
   * @returns {!number} Model size
   */
  get fbeSize () {
    return this.model.fbeSize + this.model.fbeExtra
  }

  /**
   * Get the model type
   * @this {!BalanceModel}
   * @returns {!number} Model type
   */
  get fbeType () {
    return BalanceModel.fbeType
  }

  /**
   * Get the model type (static)
   * @this {!BalanceModel}
   * @returns {!number} Model type
   */
  static get fbeType () {
    return FieldModelBalance.fbeType
  }

  /**
   * Check if the struct value is valid
   * @this {!BalanceModel}
   * @returns {!boolean} Model valid state
   */
  verify () {
    if ((this.buffer.offset + this.model.fbeOffset - 4) > this.buffer.size) {
      return false
    }

    let fbeFullSize = this.readUInt32(this.model.fbeOffset - 4)
    if (fbeFullSize < this.model.fbeSize) {
      return false
    }

    return this.model.verify()
  }

  /**
   * Create a new model (begin phase)
   * @this {!BalanceModel}
   * @returns {!number} Model begin offset
   */
  createBegin () {
    return this.buffer.allocate(4 + this.model.fbeSize)
  }

  /**
   * Create a new model (end phase)
   * @this {!BalanceModel}
   * @param {!number} fbeBegin Model begin offset
   */
  createEnd (fbeBegin) {
    let fbeEnd = this.buffer.size
    let fbeFullSize = fbeEnd - fbeBegin
    this.writeUInt32(this.model.fbeOffset - 4, fbeFullSize)
    return fbeFullSize
  }

  /**
   * Serialize the struct value
   * @this {!BalanceModel}
   * @param {!Balance} value Balance value
   * @return {!number} Model begin offset
   */
  serialize (value) {
    let fbeBegin = this.createBegin()
    this.model.set(value)
    return this.createEnd(fbeBegin)
  }

  /**
   * Deserialize the struct value
   * @this {!BalanceModel}
   * @param {!Balance} value Balance value, defaults is new Balance()
   * @return {!object} Deserialized Balance value and its size
   */
  deserialize (value = new Balance()) {
    if ((this.buffer.offset + this.model.fbeOffset - 4) > this.buffer.size) {
      return { value: new Balance(), size: 0 }
    }

    let fbeFullSize = this.readUInt32(this.model.fbeOffset - 4)
    console.assert((fbeFullSize >= this.model.fbeSize), 'Model is broken!')
    if (fbeFullSize < this.model.fbeSize) {
      return { value: new Balance(), size: 0 }
    }

    this.model.get(value)
    return { value: value, size: fbeFullSize }
  }

  /**
   * Move to the next struct value
   * @this {!BalanceModel}
   * @param {!number} prev Previous Balance model size
   */
  next (prev) {
    this.model.fbeShift(prev)
  }
}

exports.BalanceModel = BalanceModel

/**
 * Fast Binary Encoding Balance final model
 */
class FinalModelBalance extends fbe.FinalModel {
  /**
   * Initialize final model with the given buffer and offset
   * @param {!fbe.ReadBuffer|!fbe.WriteBuffer} buffer Buffer
   * @param {!number} offset Offset
   * @constructor
   */
  constructor (buffer, offset) {
    super(buffer, offset)
    this._parent = new proto.FinalModelBalance(buffer, 0)
    this._locked = new fbe.FinalModelDouble(buffer, 0)
  }

  /**
   * Get the proto.Balance final model
   * @this {!FinalModelBalance}
   * @returns {!proto.FinalModelBalance} proto.Balance field model
   */
  get parent () {
    return this._parent
  }

  /**
   * Get the locked final model
   * @this {!FinalModelBalance}
   * @returns {!fbe.FinalModelDouble} locked final model
   */
  get locked () {
    return this._locked
  }

  /**
   * Get the allocation size
   * @this {!FinalModelBalance}
   * @param {!Balance} fbeValue Balance value
   * @returns {!number} Allocation size
   */
  fbeAllocationSize (fbeValue) {
    return 0 + this.parent.fbeAllocationSize(fbeValue) + this.locked.fbeAllocationSize(fbeValue.locked)
  }

  /**
   * Get the final type
   * @this {!FinalModelBalance}
   * @returns {!number} Final type
   */
  get fbeType () {
    return FinalModelBalance.fbeType
  }

  /**
   * Get the final type (static)
   * @this {!FinalModelBalance}
   * @returns {!number} Final type
   */
  static get fbeType () {
    return proto.FinalModelBalance.fbeType
  }

  /**
   * Check if the struct value is valid
   * @this {!FinalModelBalance}
   * @returns {!number} Final model size or Number.MAX_SAFE_INTEGER in case of any error
   */
  verify () {
    this._buffer.shift(this.fbeOffset)
    let fbeResult = this.verifyFields()
    this._buffer.unshift(this.fbeOffset)
    return fbeResult
  }

  /**
   * Check if the struct fields are valid
   * @this {!FinalModelBalance}
   * @returns {!number} Final model size or Number.MAX_SAFE_INTEGER in case of any error
   */
  verifyFields () {
    let fbeCurrentOffset = 0
    let fbeFieldSize

    this.parent.fbeOffset = fbeCurrentOffset
    fbeFieldSize = this.parent.verifyFields()
    if (fbeFieldSize === Number.MAX_SAFE_INTEGER) {
      return Number.MAX_SAFE_INTEGER
    }
    fbeCurrentOffset += fbeFieldSize

    this.locked.fbeOffset = fbeCurrentOffset
    fbeFieldSize = this.locked.verify()
    if (fbeFieldSize === Number.MAX_SAFE_INTEGER) {
      return Number.MAX_SAFE_INTEGER
    }
    fbeCurrentOffset += fbeFieldSize

    return fbeCurrentOffset
  }

  /**
   * Get the struct value
   * @this {!FinalModelBalance}
   * @param {!Balance} fbeValue Balance value, defaults is new Balance()
   * @returns {!object} Result struct value and its size
   */
  get (fbeValue = new Balance()) {
    this._buffer.shift(this.fbeOffset)
    let fbeSize = this.getFields(fbeValue)
    this._buffer.unshift(this.fbeOffset)
    return { value: fbeValue, size: fbeSize }
  }

  /**
   * Get the struct fields values
   * @this {!FinalModelBalance}
   * @param {!Balance} fbeValue Balance value
   * @returns {!number} Struct size
   */
  getFields (fbeValue) {
    let fbeCurrentOffset = 0
    let fbeCurrentSize = 0
    let fbeResult

    this.parent.fbeOffset = fbeCurrentOffset
    fbeResult = this.parent.getFields(fbeValue)
    // noinspection JSUnusedAssignment
    fbeCurrentOffset += fbeResult
    fbeCurrentSize += fbeResult

    this.locked.fbeOffset = fbeCurrentOffset
    fbeResult = this.locked.get()
    fbeValue.locked = fbeResult.value
    // noinspection JSUnusedAssignment
    fbeCurrentOffset += fbeResult.size
    fbeCurrentSize += fbeResult.size

    return fbeCurrentSize
  }

  /**
   * Set the struct value
   * @this {!FinalModelBalance}
   * @param {!Balance} fbeValue Balance value
   * @returns {!number} Final model size
   */
  set (fbeValue) {
    this._buffer.shift(this.fbeOffset)
    let fbeSize = this.setFields(fbeValue)
    this._buffer.unshift(this.fbeOffset)
    return fbeSize
  }

  /**
   * Set the struct fields values
   * @this {!FinalModelBalance}
   * @param {Balance} fbeValue Balance value
   * @returns {!number} Final model size
   */
  setFields (fbeValue) {
    let fbeCurrentOffset = 0
    let fbeCurrentSize = 0
    let fbeFieldSize

    this.parent.fbeOffset = fbeCurrentOffset
    fbeFieldSize = this.parent.setFields(fbeValue)
    // noinspection JSUnusedAssignment
    fbeCurrentOffset += fbeFieldSize
    fbeCurrentSize += fbeFieldSize

    this.locked.fbeOffset = fbeCurrentOffset
    fbeFieldSize = this.locked.set(fbeValue.locked)
    // noinspection JSUnusedAssignment
    fbeCurrentOffset += fbeFieldSize
    fbeCurrentSize += fbeFieldSize

    return fbeCurrentSize
  }
}

exports.FinalModelBalance = FinalModelBalance

/**
 * Fast Binary Encoding Balance final model
 */
class BalanceFinalModel extends fbe.Model {
  /**
   * Initialize final model with the given buffer
   * @param {!fbe.ReadBuffer|!fbe.WriteBuffer} buffer Read/Write buffer, defaults is new fbe.WriteBuffer()
   * @constructor
   */
  constructor (buffer = new fbe.WriteBuffer()) {
    super(buffer)
    this._model = new FinalModelBalance(this.buffer, 8)
  }

  /**
   * Get the model type
   * @this {!BalanceFinalModel}
   * @returns {!number} Model type
   */
  get fbeType () {
    return BalanceFinalModel.fbeType
  }

  /**
   * Get the model type (static)
   * @this {!BalanceFinalModel}
   * @returns {!number} Model type
   */
  static get fbeType () {
    return FinalModelBalance.fbeType
  }

  /**
   * Check if the struct value is valid
   * @this {!BalanceFinalModel}
   * @returns {!boolean} Model valid state
   */
  verify () {
    if ((this.buffer.offset + this._model.fbeOffset) > this.buffer.size) {
      return false
    }

    let fbeStructSize = this.readUInt32(this._model.fbeOffset - 8)
    let fbeStructType = this.readUInt32(this._model.fbeOffset - 4)
    if ((fbeStructSize <= 0) || (fbeStructType !== this.fbeType)) {
      return false
    }

    return ((8 + this._model.verify()) === fbeStructSize)
  }

  /**
   * Serialize the struct value
   * @this {!BalanceFinalModel}
   * @param {!Balance} value Balance value
   * @return {!number} Struct size
   */
  serialize (value) {
    let fbeInitialSize = this.buffer.size

    let fbeStructType = this.fbeType
    let fbeStructSize = 8 + this._model.fbeAllocationSize(value)
    let fbeStructOffset = this.buffer.allocate(fbeStructSize) - this.buffer.offset
    console.assert(((this.buffer.offset + fbeStructOffset + fbeStructSize) <= this.buffer.size), 'Model is broken!')
    if ((this.buffer.offset + fbeStructOffset + fbeStructSize) > this.buffer.size) {
      return 0
    }

    fbeStructSize = 8 + this._model.set(value)
    this.buffer.resize(fbeInitialSize + fbeStructSize)

    this.writeUInt32(this._model.fbeOffset - 8, fbeStructSize)
    this.writeUInt32(this._model.fbeOffset - 4, fbeStructType)

    return fbeStructSize
  }

  /**
   * Deserialize the struct value
   * @this {!BalanceFinalModel}
   * @param {!Balance} value Balance value, defaults is new Balance()
   * @return {!object} Deserialized Balance value and its size
   */
  deserialize (value = new Balance()) {
    console.assert(((this.buffer.offset + this._model.fbeOffset) <= this.buffer.size), 'Model is broken!')
    if ((this.buffer.offset + this._model.fbeOffset) > this.buffer.size) {
      return { value: new Balance(), size: 0 }
    }

    let fbeStructSize = this.readUInt32(this._model.fbeOffset - 8)
    let fbeStructType = this.readUInt32(this._model.fbeOffset - 4)
    console.assert(((fbeStructSize > 0) && (fbeStructType === this.fbeType)), 'Model is broken!')
    if ((fbeStructSize <= 0) || (fbeStructType !== this.fbeType)) {
      return { value: new Balance(), size: 8 }
    }

    let fbeResult = this._model.get(value)
    return { value: fbeResult.value, size: (8 + fbeResult.size) }
  }

  /**
   * Move to the next struct value
   * @this {!BalanceFinalModel}
   * @param {!number} prev Previous Balance model size
   */
  next (prev) {
    this._model.fbeShift(prev)
  }
}

exports.BalanceFinalModel = BalanceFinalModel

/**
 * Account struct
 */
class Account {
  /**
   * Initialize struct
   * @param {!number=} id
   * @param {!string=} name
   * @param {!StateEx=} state
   * @param {!Balance=} wallet
   * @param {Balance=} asset
   * @param {!Array=} orders
   * @constructor
   */
  constructor (argid = 0, argname = '', argstate = new StateEx(StateEx.initialized | StateEx.bad | StateEx.sad), argwallet = new Balance(), argasset = undefined, argorders = []) {
    this.id = argid
    this.name = argname
    this.state = argstate
    this.wallet = argwallet
    this.asset = argasset
    this.orders = argorders
  }

  /**
   * Copy struct (shallow copy)
   * @this {!Account}
   * @param {!Account} other Other struct
   * @returns {!Account} This struct
   */
  copy (other) {
    if (other.id != null) {
      this.id = other.id
    } else {
      this.id = undefined
    }
    if (other.name != null) {
      this.name = other.name
    } else {
      this.name = undefined
    }
    if (other.state != null) {
      this.state = StateEx.fromObject(other.state)
    } else {
      this.state = undefined
    }
    if (other.wallet != null) {
      this.wallet = Balance.fromObject(other.wallet)
    } else {
      this.wallet = undefined
    }
    if (other.asset != null) {
      this.asset = Balance.fromObject(other.asset)
    } else {
      this.asset = undefined
    }
    if (other.orders != null) {
      this.orders = []
      for (let item of other.orders) {
        if (item != null) {
          let tempItem
          tempItem = Order.fromObject(item)
          this.orders.push(tempItem)
        } else {
          this.orders.push(undefined)
        }
      }
    } else {
      this.orders = undefined
    }
    return this
  }

  /**
   * Clone struct (deep clone)
   * @this {!Account}
   * @returns {!Account} Cloned struct
   */
  clone () {
    // Serialize the struct to the FBE stream
    let writer = new AccountModel(new fbe.WriteBuffer())
    writer.serialize(this)

    // Deserialize the struct from the FBE stream
    let reader = new AccountModel(new fbe.ReadBuffer())
    reader.attachBuffer(writer.buffer)
    return reader.deserialize().value
  }

  /**
   * Is this struct equal to other one?
   * @this {!Account}
   * @param {!Account} other Other struct
   * @returns {boolean} Equal result
   */
  eq (other) {
    if (!(other instanceof Account)) {
      throw new TypeError('Instance of Account is required!')
    }
    // noinspection RedundantIfStatementJS
    if (this.id !== other.id) {
      return false
    }
    return true
  }

  /**
   * Convert struct to string
   * @this {!Account}
   * @returns {!string} Struct value string
   */
  toString () {
    let result = ''
    result += 'Account('
    result += 'id='
    result += this.id.toString()
    result += ',name='
    if (this.name != null) {
      result += '"' + this.name.toString() + '"'
    } else {
      result += 'null'
    }
    result += ',state='
    result += this.state.toString()
    result += ',wallet='
    result += this.wallet.toString()
    result += ',asset='
    if (this.asset != null) {
      result += this.asset.toString()
    } else {
      result += 'null'
    }
    result += ',orders='
    if (this.orders != null) {
      let first = true
      result += '[' + this.orders.length + ']['
      for (let item of this.orders) {
        result += first ? '' : ','
        result += item.toString()
        first = false
      }
      result += ']'
    } else {
      result += '[0][]'
    }
    result += ')'
    return result
  }

  /**
   * Inspect struct
   * @this {!Account}
   * @returns {!string} Struct value string
   */
  [util.inspect.custom] () {
    return this.toString()
  }

  /**
   * Convert struct to JSON
   * @this {!Account}
   * @returns {!object} Struct value for JSON
   */
  toJSON () {
    return {
      id: ((this.id != null) ? this.id : null),
      name: ((this.name != null) ? this.name : null),
      state: ((this.state != null) ? this.state : null),
      wallet: ((this.wallet != null) ? this.wallet : null),
      asset: ((this.asset != null) ? this.asset : null),
      orders: ((this.orders != null) ? Array.from(this.orders, item => ((item != null) ? item : null)) : null)
    }
  }

  /**
   * Convert JSON to struct
   * @param {!string} json JSON string
   * @returns {!object} Struct value for JSON
   */
  static fromJSON (json) {
    return Account.fromObject(JSON.parse(json))
  }

  /**
   * Create struct from object value
   * @param {!Account} other Object value
   * @returns {!Account} Created struct
   */
  static fromObject (other) {
    return new Account().copy(other)
  }

  /**
   * Get the FBE type
   * @this {!Account}
   * @returns {!number} FBE type
   */
  get fbeType () {
    return Account.fbeType
  }

  /**
   * Get the FBE type (static)
   * @this {!Account}
   * @returns {!number} FBE type
   */
  static get fbeType () {
    return 3
  }
}

exports.Account = Account

/**
 * Fast Binary Encoding Account field model
 */
class FieldModelAccount extends fbe.FieldModel {
  /**
   * Initialize field model with the given buffer and offset
   * @param {!fbe.ReadBuffer|!fbe.WriteBuffer} buffer Buffer
   * @param {!number} offset Offset
   * @constructor
   */
  constructor (buffer, offset) {
    super(buffer, offset)
    this._id = new fbe.FieldModelInt32(buffer, 4 + 4)
    this._name = new fbe.FieldModelString(buffer, this._id.fbeOffset + this._id.fbeSize)
    this._state = new FieldModelStateEx(buffer, this._name.fbeOffset + this._name.fbeSize)
    this._wallet = new FieldModelBalance(buffer, this._state.fbeOffset + this._state.fbeSize)
    this._asset = new fbe.FieldModelOptional(new FieldModelBalance(buffer, this._wallet.fbeOffset + this._wallet.fbeSize), buffer, this._wallet.fbeOffset + this._wallet.fbeSize)
    this._orders = new fbe.FieldModelVector(new FieldModelOrder(buffer, this._asset.fbeOffset + this._asset.fbeSize), buffer, this._asset.fbeOffset + this._asset.fbeSize)
  }

  /**
   * Get the id field model
   * @this {!FieldModelAccount}
   * @returns {!fbe.FieldModelInt32} id field model
   */
  get id () {
    return this._id
  }

  /**
   * Get the name field model
   * @this {!FieldModelAccount}
   * @returns {!fbe.FieldModelString} name field model
   */
  get name () {
    return this._name
  }

  /**
   * Get the state field model
   * @this {!FieldModelAccount}
   * @returns {!FieldModelStateEx} state field model
   */
  get state () {
    return this._state
  }

  /**
   * Get the wallet field model
   * @this {!FieldModelAccount}
   * @returns {!FieldModelBalance} wallet field model
   */
  get wallet () {
    return this._wallet
  }

  /**
   * Get the asset field model
   * @this {!FieldModelAccount}
   * @returns {!fbe.FieldModelOptional} asset field model
   */
  get asset () {
    return this._asset
  }

  /**
   * Get the orders field model
   * @this {!FieldModelAccount}
   * @returns {!fbe.FieldModelVector} orders field model
   */
  get orders () {
    return this._orders
  }

  /**
   * Get the field size
   * @this {!FieldModelAccount}
   * @returns {!number} Field size
   */
  get fbeSize () {
    return 4
  }

  /**
   * Get the field body size
   * @this {!FieldModelAccount}
   * @returns {!number} Field body size
   */
  get fbeBody () {
    return 4 + 4 + this.id.fbeSize + this.name.fbeSize + this.state.fbeSize + this.wallet.fbeSize + this.asset.fbeSize + this.orders.fbeSize
  }

  /**
   * Get the field extra size
   * @this {!FieldModelAccount}
   * @returns {!number} Field extra size
   */
  get fbeExtra () {
    if ((this._buffer.offset + this.fbeOffset + this.fbeSize) > this._buffer.size) {
      return 0
    }

    let fbeStructOffset = this.readUInt32(this.fbeOffset)
    if ((fbeStructOffset === 0) || ((this._buffer.offset + fbeStructOffset + 4) > this._buffer.size)) {
      return 0
    }

    this._buffer.shift(fbeStructOffset)

    let fbeResult = this.fbeBody + this.id.fbeExtra + this.name.fbeExtra + this.state.fbeExtra + this.wallet.fbeExtra + this.asset.fbeExtra + this.orders.fbeExtra

    this._buffer.unshift(fbeStructOffset)

    return fbeResult
  }

  /**
   * Get the field type
   * @this {!FieldModelAccount}
   * @returns {!number} Field type
   */
  get fbeType () {
    return FieldModelAccount.fbeType
  }

  /**
   * Get the field type (static)
   * @this {!FieldModelAccount}
   * @returns {!number} Field type
   */
  static get fbeType () {
    return 3
  }

  /**
   * Check if the struct value is valid
   * @this {!FieldModelAccount}
   * @param {!boolean} fbeVerifyType Verify model type flag, defaults is true
   * @returns {!boolean} Field model valid state
   */
  verify (fbeVerifyType = true) {
    if ((this._buffer.offset + this.fbeOffset + this.fbeSize) > this._buffer.size) {
      return true
    }

    let fbeStructOffset = this.readUInt32(this.fbeOffset)
    if ((fbeStructOffset === 0) || ((this._buffer.offset + fbeStructOffset + 4 + 4) > this._buffer.size)) {
      return false
    }

    let fbeStructSize = this.readUInt32(fbeStructOffset)
    if (fbeStructSize < (4 + 4)) {
      return false
    }

    let fbeStructType = this.readUInt32(fbeStructOffset + 4)
    if (fbeVerifyType && (fbeStructType !== this.fbeType)) {
      return false
    }

    this._buffer.shift(fbeStructOffset)
    let fbeResult = this.verifyFields(fbeStructSize)
    this._buffer.unshift(fbeStructOffset)
    return fbeResult
  }

  /**
   * Check if the struct fields are valid
   * @this {!FieldModelAccount}
   * @param {!number} fbeStructSize FBE struct size
   * @returns {!boolean} Field model valid state
   */
  verifyFields (fbeStructSize) {
    let fbeCurrentSize = 4 + 4

    if ((fbeCurrentSize + this.id.fbeSize) > fbeStructSize) {
      return true
    }
    if (!this.id.verify()) {
      return false
    }
    // noinspection JSUnusedAssignment
    fbeCurrentSize += this.id.fbeSize

    if ((fbeCurrentSize + this.name.fbeSize) > fbeStructSize) {
      return true
    }
    if (!this.name.verify()) {
      return false
    }
    // noinspection JSUnusedAssignment
    fbeCurrentSize += this.name.fbeSize

    if ((fbeCurrentSize + this.state.fbeSize) > fbeStructSize) {
      return true
    }
    if (!this.state.verify()) {
      return false
    }
    // noinspection JSUnusedAssignment
    fbeCurrentSize += this.state.fbeSize

    if ((fbeCurrentSize + this.wallet.fbeSize) > fbeStructSize) {
      return true
    }
    if (!this.wallet.verify()) {
      return false
    }
    // noinspection JSUnusedAssignment
    fbeCurrentSize += this.wallet.fbeSize

    if ((fbeCurrentSize + this.asset.fbeSize) > fbeStructSize) {
      return true
    }
    if (!this.asset.verify()) {
      return false
    }
    // noinspection JSUnusedAssignment
    fbeCurrentSize += this.asset.fbeSize

    if ((fbeCurrentSize + this.orders.fbeSize) > fbeStructSize) {
      return true
    }
    if (!this.orders.verify()) {
      return false
    }
    // noinspection JSUnusedAssignment
    fbeCurrentSize += this.orders.fbeSize

    return true
  }

  /**
   * Get the struct value (begin phase)
   * @this {!FieldModelAccount}
   * @returns {!number} Field model begin offset
   */
  getBegin () {
    if ((this._buffer.offset + this.fbeOffset + this.fbeSize) > this._buffer.size) {
      return 0
    }

    let fbeStructOffset = this.readUInt32(this.fbeOffset)
    console.assert((fbeStructOffset > 0) && ((this._buffer.offset + fbeStructOffset + 4 + 4) <= this._buffer.size), 'Model is broken!')
    if ((fbeStructOffset === 0) || ((this._buffer.offset + fbeStructOffset + 4 + 4) > this._buffer.size)) {
      return 0
    }

    let fbeStructSize = this.readUInt32(fbeStructOffset)
    console.assert((fbeStructSize >= (4 + 4)), 'Model is broken!')
    if (fbeStructSize < (4 + 4)) {
      return 0
    }

    this._buffer.shift(fbeStructOffset)
    return fbeStructOffset
  }

  /**
   * Get the struct value (end phase)
   * @this {!FieldModelAccount}
   * @param {!number} fbeBegin Field model begin offset
   */
  getEnd (fbeBegin) {
    this._buffer.unshift(fbeBegin)
  }

  /**
   * Get the struct value
   * @this {!FieldModelAccount}
   * @param {!Account} fbeValue Default value, defaults is new Account()
   * @returns {!Account} Account value
   */
  get (fbeValue = new Account()) {
    let fbeBegin = this.getBegin()
    if (fbeBegin === 0) {
      return fbeValue
    }

    let fbeStructSize = this.readUInt32(0)
    this.getFields(fbeValue, fbeStructSize)
    this.getEnd(fbeBegin)
    return fbeValue
  }

  /**
   * Get the struct fields values
   * @this {!FieldModelAccount}
   * @param {!Account} fbeValue Account value
   * @param {!number} fbeStructSize Struct size
   */
  getFields (fbeValue, fbeStructSize) {
    let fbeCurrentSize = 4 + 4

    if ((fbeCurrentSize + this.id.fbeSize) <= fbeStructSize) {
      fbeValue.id = this.id.get()
    } else {
      fbeValue.id = 0
    }
    // noinspection JSUnusedAssignment
    fbeCurrentSize += this.id.fbeSize

    if ((fbeCurrentSize + this.name.fbeSize) <= fbeStructSize) {
      fbeValue.name = this.name.get()
    } else {
      fbeValue.name = ''
    }
    // noinspection JSUnusedAssignment
    fbeCurrentSize += this.name.fbeSize

    if ((fbeCurrentSize + this.state.fbeSize) <= fbeStructSize) {
      fbeValue.state = this.state.get(new StateEx(StateEx.initialized | StateEx.bad | StateEx.sad))
    } else {
      fbeValue.state = new StateEx(StateEx.initialized | StateEx.bad | StateEx.sad)
    }
    // noinspection JSUnusedAssignment
    fbeCurrentSize += this.state.fbeSize

    if ((fbeCurrentSize + this.wallet.fbeSize) <= fbeStructSize) {
      fbeValue.wallet = this.wallet.get()
    } else {
      fbeValue.wallet = new Balance()
    }
    // noinspection JSUnusedAssignment
    fbeCurrentSize += this.wallet.fbeSize

    if ((fbeCurrentSize + this.asset.fbeSize) <= fbeStructSize) {
      fbeValue.asset = this.asset.get()
    } else {
      fbeValue.asset = undefined
    }
    // noinspection JSUnusedAssignment
    fbeCurrentSize += this.asset.fbeSize

    if ((fbeCurrentSize + this.orders.fbeSize) <= fbeStructSize) {
      this.orders.get(fbeValue.orders)
    } else {
      fbeValue.orders.length = 0
    }
    // noinspection JSUnusedAssignment
    fbeCurrentSize += this.orders.fbeSize
  }

  /**
   * Set the struct value (begin phase)
   * @this {!FieldModelAccount}
   * @returns {!number} Field model begin offset
   */
  setBegin () {
    console.assert(((this._buffer.offset + this.fbeOffset + this.fbeSize) <= this._buffer.size), 'Model is broken!')
    if ((this._buffer.offset + this.fbeOffset + this.fbeSize) > this._buffer.size) {
      return 0
    }

    let fbeStructSize = this.fbeBody
    let fbeStructOffset = this._buffer.allocate(fbeStructSize) - this._buffer.offset
    console.assert((fbeStructOffset > 0) && ((this._buffer.offset + fbeStructOffset + fbeStructSize) <= this._buffer.size), 'Model is broken!')
    if ((fbeStructOffset <= 0) || ((this._buffer.offset + fbeStructOffset + fbeStructSize) > this._buffer.size)) {
      return 0
    }

    this.writeUInt32(this.fbeOffset, fbeStructOffset)
    this.writeUInt32(fbeStructOffset, fbeStructSize)
    this.writeUInt32(fbeStructOffset + 4, this.fbeType)

    this._buffer.shift(fbeStructOffset)
    return fbeStructOffset
  }

  /**
   * Set the struct value (end phase)
   * @this {!FieldModelAccount}
   * @param {!number} fbeBegin Field model begin offset
   */
  setEnd (fbeBegin) {
    this._buffer.unshift(fbeBegin)
  }

  /**
   * Set the struct value
   * @this {!FieldModelAccount}
   * @param {!Account} fbeValue Account value
   */
  set (fbeValue) {
    let fbeBegin = this.setBegin()
    if (fbeBegin === 0) {
      return
    }

    this.setFields(fbeValue)
    this.setEnd(fbeBegin)
  }

  /**
   * Set the struct fields values
   * @this {!FieldModelAccount}
   * @param {Account} fbeValue Account value
   */
  setFields (fbeValue) {
    this.id.set(fbeValue.id)
    this.name.set(fbeValue.name)
    this.state.set(fbeValue.state)
    this.wallet.set(fbeValue.wallet)
    this.asset.set(fbeValue.asset)
    this.orders.set(fbeValue.orders)
  }
}

exports.FieldModelAccount = FieldModelAccount

/**
 * Fast Binary Encoding Account model
 */
class AccountModel extends fbe.Model {
  /**
   * Initialize model with the given buffer
   * @param {!fbe.ReadBuffer|!fbe.WriteBuffer} buffer Read/Write buffer, defaults is new fbe.WriteBuffer()
   * @constructor
   */
  constructor (buffer = new fbe.WriteBuffer()) {
    super(buffer)
    this._model = new FieldModelAccount(this.buffer, 4)
  }

  /**
   * Get the Account model
   * @this {!AccountModel}
   * @returns {!FieldModelAccount} model Account model
   */
  get model () {
    return this._model
  }

  /**
   * Get the model size
   * @this {!AccountModel}
   * @returns {!number} Model size
   */
  get fbeSize () {
    return this.model.fbeSize + this.model.fbeExtra
  }

  /**
   * Get the model type
   * @this {!AccountModel}
   * @returns {!number} Model type
   */
  get fbeType () {
    return AccountModel.fbeType
  }

  /**
   * Get the model type (static)
   * @this {!AccountModel}
   * @returns {!number} Model type
   */
  static get fbeType () {
    return FieldModelAccount.fbeType
  }

  /**
   * Check if the struct value is valid
   * @this {!AccountModel}
   * @returns {!boolean} Model valid state
   */
  verify () {
    if ((this.buffer.offset + this.model.fbeOffset - 4) > this.buffer.size) {
      return false
    }

    let fbeFullSize = this.readUInt32(this.model.fbeOffset - 4)
    if (fbeFullSize < this.model.fbeSize) {
      return false
    }

    return this.model.verify()
  }

  /**
   * Create a new model (begin phase)
   * @this {!AccountModel}
   * @returns {!number} Model begin offset
   */
  createBegin () {
    return this.buffer.allocate(4 + this.model.fbeSize)
  }

  /**
   * Create a new model (end phase)
   * @this {!AccountModel}
   * @param {!number} fbeBegin Model begin offset
   */
  createEnd (fbeBegin) {
    let fbeEnd = this.buffer.size
    let fbeFullSize = fbeEnd - fbeBegin
    this.writeUInt32(this.model.fbeOffset - 4, fbeFullSize)
    return fbeFullSize
  }

  /**
   * Serialize the struct value
   * @this {!AccountModel}
   * @param {!Account} value Account value
   * @return {!number} Model begin offset
   */
  serialize (value) {
    let fbeBegin = this.createBegin()
    this.model.set(value)
    return this.createEnd(fbeBegin)
  }

  /**
   * Deserialize the struct value
   * @this {!AccountModel}
   * @param {!Account} value Account value, defaults is new Account()
   * @return {!object} Deserialized Account value and its size
   */
  deserialize (value = new Account()) {
    if ((this.buffer.offset + this.model.fbeOffset - 4) > this.buffer.size) {
      return { value: new Account(), size: 0 }
    }

    let fbeFullSize = this.readUInt32(this.model.fbeOffset - 4)
    console.assert((fbeFullSize >= this.model.fbeSize), 'Model is broken!')
    if (fbeFullSize < this.model.fbeSize) {
      return { value: new Account(), size: 0 }
    }

    this.model.get(value)
    return { value: value, size: fbeFullSize }
  }

  /**
   * Move to the next struct value
   * @this {!AccountModel}
   * @param {!number} prev Previous Account model size
   */
  next (prev) {
    this.model.fbeShift(prev)
  }
}

exports.AccountModel = AccountModel

/**
 * Fast Binary Encoding Account final model
 */
class FinalModelAccount extends fbe.FinalModel {
  /**
   * Initialize final model with the given buffer and offset
   * @param {!fbe.ReadBuffer|!fbe.WriteBuffer} buffer Buffer
   * @param {!number} offset Offset
   * @constructor
   */
  constructor (buffer, offset) {
    super(buffer, offset)
    this._id = new fbe.FinalModelInt32(buffer, 0)
    this._name = new fbe.FinalModelString(buffer, 0)
    this._state = new FinalModelStateEx(buffer, 0)
    this._wallet = new FinalModelBalance(buffer, 0)
    this._asset = new fbe.FinalModelOptional(new FinalModelBalance(buffer, 0), buffer, 0)
    this._orders = new fbe.FinalModelVector(new FinalModelOrder(buffer, 0), buffer, 0)
  }

  /**
   * Get the id final model
   * @this {!FinalModelAccount}
   * @returns {!fbe.FinalModelInt32} id final model
   */
  get id () {
    return this._id
  }

  /**
   * Get the name final model
   * @this {!FinalModelAccount}
   * @returns {!fbe.FinalModelString} name final model
   */
  get name () {
    return this._name
  }

  /**
   * Get the state final model
   * @this {!FinalModelAccount}
   * @returns {!FinalModelStateEx} state final model
   */
  get state () {
    return this._state
  }

  /**
   * Get the wallet final model
   * @this {!FinalModelAccount}
   * @returns {!FinalModelBalance} wallet final model
   */
  get wallet () {
    return this._wallet
  }

  /**
   * Get the asset final model
   * @this {!FinalModelAccount}
   * @returns {!fbe.FinalModelOptional} asset final model
   */
  get asset () {
    return this._asset
  }

  /**
   * Get the orders final model
   * @this {!FinalModelAccount}
   * @returns {!fbe.FinalModelVector} orders final model
   */
  get orders () {
    return this._orders
  }

  /**
   * Get the allocation size
   * @this {!FinalModelAccount}
   * @param {!Account} fbeValue Account value
   * @returns {!number} Allocation size
   */
  fbeAllocationSize (fbeValue) {
    return 0 + this.id.fbeAllocationSize(fbeValue.id) + this.name.fbeAllocationSize(fbeValue.name) + this.state.fbeAllocationSize(fbeValue.state) + this.wallet.fbeAllocationSize(fbeValue.wallet) + this.asset.fbeAllocationSize(fbeValue.asset) + this.orders.fbeAllocationSize(fbeValue.orders)
  }

  /**
   * Get the final type
   * @this {!FinalModelAccount}
   * @returns {!number} Final type
   */
  get fbeType () {
    return FinalModelAccount.fbeType
  }

  /**
   * Get the final type (static)
   * @this {!FinalModelAccount}
   * @returns {!number} Final type
   */
  static get fbeType () {
    return 3
  }

  /**
   * Check if the struct value is valid
   * @this {!FinalModelAccount}
   * @returns {!number} Final model size or Number.MAX_SAFE_INTEGER in case of any error
   */
  verify () {
    this._buffer.shift(this.fbeOffset)
    let fbeResult = this.verifyFields()
    this._buffer.unshift(this.fbeOffset)
    return fbeResult
  }

  /**
   * Check if the struct fields are valid
   * @this {!FinalModelAccount}
   * @returns {!number} Final model size or Number.MAX_SAFE_INTEGER in case of any error
   */
  verifyFields () {
    let fbeCurrentOffset = 0
    let fbeFieldSize

    this.id.fbeOffset = fbeCurrentOffset
    fbeFieldSize = this.id.verify()
    if (fbeFieldSize === Number.MAX_SAFE_INTEGER) {
      return Number.MAX_SAFE_INTEGER
    }
    fbeCurrentOffset += fbeFieldSize

    this.name.fbeOffset = fbeCurrentOffset
    fbeFieldSize = this.name.verify()
    if (fbeFieldSize === Number.MAX_SAFE_INTEGER) {
      return Number.MAX_SAFE_INTEGER
    }
    fbeCurrentOffset += fbeFieldSize

    this.state.fbeOffset = fbeCurrentOffset
    fbeFieldSize = this.state.verify()
    if (fbeFieldSize === Number.MAX_SAFE_INTEGER) {
      return Number.MAX_SAFE_INTEGER
    }
    fbeCurrentOffset += fbeFieldSize

    this.wallet.fbeOffset = fbeCurrentOffset
    fbeFieldSize = this.wallet.verify()
    if (fbeFieldSize === Number.MAX_SAFE_INTEGER) {
      return Number.MAX_SAFE_INTEGER
    }
    fbeCurrentOffset += fbeFieldSize

    this.asset.fbeOffset = fbeCurrentOffset
    fbeFieldSize = this.asset.verify()
    if (fbeFieldSize === Number.MAX_SAFE_INTEGER) {
      return Number.MAX_SAFE_INTEGER
    }
    fbeCurrentOffset += fbeFieldSize

    this.orders.fbeOffset = fbeCurrentOffset
    fbeFieldSize = this.orders.verify()
    if (fbeFieldSize === Number.MAX_SAFE_INTEGER) {
      return Number.MAX_SAFE_INTEGER
    }
    fbeCurrentOffset += fbeFieldSize

    return fbeCurrentOffset
  }

  /**
   * Get the struct value
   * @this {!FinalModelAccount}
   * @param {!Account} fbeValue Account value, defaults is new Account()
   * @returns {!object} Result struct value and its size
   */
  get (fbeValue = new Account()) {
    this._buffer.shift(this.fbeOffset)
    let fbeSize = this.getFields(fbeValue)
    this._buffer.unshift(this.fbeOffset)
    return { value: fbeValue, size: fbeSize }
  }

  /**
   * Get the struct fields values
   * @this {!FinalModelAccount}
   * @param {!Account} fbeValue Account value
   * @returns {!number} Struct size
   */
  getFields (fbeValue) {
    let fbeCurrentOffset = 0
    let fbeCurrentSize = 0
    let fbeResult

    this.id.fbeOffset = fbeCurrentOffset
    fbeResult = this.id.get()
    fbeValue.id = fbeResult.value
    // noinspection JSUnusedAssignment
    fbeCurrentOffset += fbeResult.size
    fbeCurrentSize += fbeResult.size

    this.name.fbeOffset = fbeCurrentOffset
    fbeResult = this.name.get()
    fbeValue.name = fbeResult.value
    // noinspection JSUnusedAssignment
    fbeCurrentOffset += fbeResult.size
    fbeCurrentSize += fbeResult.size

    this.state.fbeOffset = fbeCurrentOffset
    fbeResult = this.state.get()
    fbeValue.state = fbeResult.value
    // noinspection JSUnusedAssignment
    fbeCurrentOffset += fbeResult.size
    fbeCurrentSize += fbeResult.size

    this.wallet.fbeOffset = fbeCurrentOffset
    fbeResult = this.wallet.get()
    fbeValue.wallet = fbeResult.value
    // noinspection JSUnusedAssignment
    fbeCurrentOffset += fbeResult.size
    fbeCurrentSize += fbeResult.size

    this.asset.fbeOffset = fbeCurrentOffset
    fbeResult = this.asset.get()
    fbeValue.asset = fbeResult.value
    // noinspection JSUnusedAssignment
    fbeCurrentOffset += fbeResult.size
    fbeCurrentSize += fbeResult.size

    this.orders.fbeOffset = fbeCurrentOffset
    fbeResult = this.orders.get(fbeValue.orders)
    // noinspection JSUnusedAssignment
    fbeCurrentOffset += fbeResult.size
    fbeCurrentSize += fbeResult.size

    return fbeCurrentSize
  }

  /**
   * Set the struct value
   * @this {!FinalModelAccount}
   * @param {!Account} fbeValue Account value
   * @returns {!number} Final model size
   */
  set (fbeValue) {
    this._buffer.shift(this.fbeOffset)
    let fbeSize = this.setFields(fbeValue)
    this._buffer.unshift(this.fbeOffset)
    return fbeSize
  }

  /**
   * Set the struct fields values
   * @this {!FinalModelAccount}
   * @param {Account} fbeValue Account value
   * @returns {!number} Final model size
   */
  setFields (fbeValue) {
    let fbeCurrentOffset = 0
    let fbeCurrentSize = 0
    let fbeFieldSize

    this.id.fbeOffset = fbeCurrentOffset
    fbeFieldSize = this.id.set(fbeValue.id)
    // noinspection JSUnusedAssignment
    fbeCurrentOffset += fbeFieldSize
    fbeCurrentSize += fbeFieldSize

    this.name.fbeOffset = fbeCurrentOffset
    fbeFieldSize = this.name.set(fbeValue.name)
    // noinspection JSUnusedAssignment
    fbeCurrentOffset += fbeFieldSize
    fbeCurrentSize += fbeFieldSize

    this.state.fbeOffset = fbeCurrentOffset
    fbeFieldSize = this.state.set(fbeValue.state)
    // noinspection JSUnusedAssignment
    fbeCurrentOffset += fbeFieldSize
    fbeCurrentSize += fbeFieldSize

    this.wallet.fbeOffset = fbeCurrentOffset
    fbeFieldSize = this.wallet.set(fbeValue.wallet)
    // noinspection JSUnusedAssignment
    fbeCurrentOffset += fbeFieldSize
    fbeCurrentSize += fbeFieldSize

    this.asset.fbeOffset = fbeCurrentOffset
    fbeFieldSize = this.asset.set(fbeValue.asset)
    // noinspection JSUnusedAssignment
    fbeCurrentOffset += fbeFieldSize
    fbeCurrentSize += fbeFieldSize

    this.orders.fbeOffset = fbeCurrentOffset
    fbeFieldSize = this.orders.set(fbeValue.orders)
    // noinspection JSUnusedAssignment
    fbeCurrentOffset += fbeFieldSize
    fbeCurrentSize += fbeFieldSize

    return fbeCurrentSize
  }
}

exports.FinalModelAccount = FinalModelAccount

/**
 * Fast Binary Encoding Account final model
 */
class AccountFinalModel extends fbe.Model {
  /**
   * Initialize final model with the given buffer
   * @param {!fbe.ReadBuffer|!fbe.WriteBuffer} buffer Read/Write buffer, defaults is new fbe.WriteBuffer()
   * @constructor
   */
  constructor (buffer = new fbe.WriteBuffer()) {
    super(buffer)
    this._model = new FinalModelAccount(this.buffer, 8)
  }

  /**
   * Get the model type
   * @this {!AccountFinalModel}
   * @returns {!number} Model type
   */
  get fbeType () {
    return AccountFinalModel.fbeType
  }

  /**
   * Get the model type (static)
   * @this {!AccountFinalModel}
   * @returns {!number} Model type
   */
  static get fbeType () {
    return FinalModelAccount.fbeType
  }

  /**
   * Check if the struct value is valid
   * @this {!AccountFinalModel}
   * @returns {!boolean} Model valid state
   */
  verify () {
    if ((this.buffer.offset + this._model.fbeOffset) > this.buffer.size) {
      return false
    }

    let fbeStructSize = this.readUInt32(this._model.fbeOffset - 8)
    let fbeStructType = this.readUInt32(this._model.fbeOffset - 4)
    if ((fbeStructSize <= 0) || (fbeStructType !== this.fbeType)) {
      return false
    }

    return ((8 + this._model.verify()) === fbeStructSize)
  }

  /**
   * Serialize the struct value
   * @this {!AccountFinalModel}
   * @param {!Account} value Account value
   * @return {!number} Struct size
   */
  serialize (value) {
    let fbeInitialSize = this.buffer.size

    let fbeStructType = this.fbeType
    let fbeStructSize = 8 + this._model.fbeAllocationSize(value)
    let fbeStructOffset = this.buffer.allocate(fbeStructSize) - this.buffer.offset
    console.assert(((this.buffer.offset + fbeStructOffset + fbeStructSize) <= this.buffer.size), 'Model is broken!')
    if ((this.buffer.offset + fbeStructOffset + fbeStructSize) > this.buffer.size) {
      return 0
    }

    fbeStructSize = 8 + this._model.set(value)
    this.buffer.resize(fbeInitialSize + fbeStructSize)

    this.writeUInt32(this._model.fbeOffset - 8, fbeStructSize)
    this.writeUInt32(this._model.fbeOffset - 4, fbeStructType)

    return fbeStructSize
  }

  /**
   * Deserialize the struct value
   * @this {!AccountFinalModel}
   * @param {!Account} value Account value, defaults is new Account()
   * @return {!object} Deserialized Account value and its size
   */
  deserialize (value = new Account()) {
    console.assert(((this.buffer.offset + this._model.fbeOffset) <= this.buffer.size), 'Model is broken!')
    if ((this.buffer.offset + this._model.fbeOffset) > this.buffer.size) {
      return { value: new Account(), size: 0 }
    }

    let fbeStructSize = this.readUInt32(this._model.fbeOffset - 8)
    let fbeStructType = this.readUInt32(this._model.fbeOffset - 4)
    console.assert(((fbeStructSize > 0) && (fbeStructType === this.fbeType)), 'Model is broken!')
    if ((fbeStructSize <= 0) || (fbeStructType !== this.fbeType)) {
      return { value: new Account(), size: 8 }
    }

    let fbeResult = this._model.get(value)
    return { value: fbeResult.value, size: (8 + fbeResult.size) }
  }

  /**
   * Move to the next struct value
   * @this {!AccountFinalModel}
   * @param {!number} prev Previous Account model size
   */
  next (prev) {
    this._model.fbeShift(prev)
  }
}

exports.AccountFinalModel = AccountFinalModel

/**
 * OrderMessage struct
 */
class OrderMessage {
  /**
   * Initialize struct
   * @param {!Order=} body
   * @constructor
   */
  constructor (argbody = new Order()) {
    this.body = argbody
  }

  /**
   * Copy struct (shallow copy)
   * @this {!OrderMessage}
   * @param {!OrderMessage} other Other struct
   * @returns {!OrderMessage} This struct
   */
  copy (other) {
    if (other.body != null) {
      this.body = Order.fromObject(other.body)
    } else {
      this.body = undefined
    }
    return this
  }

  /**
   * Clone struct (deep clone)
   * @this {!OrderMessage}
   * @returns {!OrderMessage} Cloned struct
   */
  clone () {
    // Serialize the struct to the FBE stream
    let writer = new OrderMessageModel(new fbe.WriteBuffer())
    writer.serialize(this)

    // Deserialize the struct from the FBE stream
    let reader = new OrderMessageModel(new fbe.ReadBuffer())
    reader.attachBuffer(writer.buffer)
    return reader.deserialize().value
  }

  /**
   * Is this struct equal to other one?
   * @this {!OrderMessage}
   * @param {!OrderMessage} other Other struct
   * @returns {boolean} Equal result
   */
  eq (other) {
    if (!(other instanceof OrderMessage)) {
      throw new TypeError('Instance of OrderMessage is required!')
    }
    return true
  }

  /**
   * Convert struct to string
   * @this {!OrderMessage}
   * @returns {!string} Struct value string
   */
  toString () {
    let result = ''
    result += 'OrderMessage('
    result += 'body='
    result += this.body.toString()
    result += ')'
    return result
  }

  /**
   * Inspect struct
   * @this {!OrderMessage}
   * @returns {!string} Struct value string
   */
  [util.inspect.custom] () {
    return this.toString()
  }

  /**
   * Convert struct to JSON
   * @this {!OrderMessage}
   * @returns {!object} Struct value for JSON
   */
  toJSON () {
    return {
      body: ((this.body != null) ? this.body : null)
    }
  }

  /**
   * Convert JSON to struct
   * @param {!string} json JSON string
   * @returns {!object} Struct value for JSON
   */
  static fromJSON (json) {
    return OrderMessage.fromObject(JSON.parse(json))
  }

  /**
   * Create struct from object value
   * @param {!OrderMessage} other Object value
   * @returns {!OrderMessage} Created struct
   */
  static fromObject (other) {
    return new OrderMessage().copy(other)
  }

  /**
   * Get the FBE type
   * @this {!OrderMessage}
   * @returns {!number} FBE type
   */
  get fbeType () {
    return OrderMessage.fbeType
  }

  /**
   * Get the FBE type (static)
   * @this {!OrderMessage}
   * @returns {!number} FBE type
   */
  static get fbeType () {
    return 11
  }
}

exports.OrderMessage = OrderMessage

/**
 * Fast Binary Encoding OrderMessage field model
 */
class FieldModelOrderMessage extends fbe.FieldModel {
  /**
   * Initialize field model with the given buffer and offset
   * @param {!fbe.ReadBuffer|!fbe.WriteBuffer} buffer Buffer
   * @param {!number} offset Offset
   * @constructor
   */
  constructor (buffer, offset) {
    super(buffer, offset)
    this._body = new FieldModelOrder(buffer, 4 + 4)
  }

  /**
   * Get the body field model
   * @this {!FieldModelOrderMessage}
   * @returns {!FieldModelOrder} body field model
   */
  get body () {
    return this._body
  }

  /**
   * Get the field size
   * @this {!FieldModelOrderMessage}
   * @returns {!number} Field size
   */
  get fbeSize () {
    return 4
  }

  /**
   * Get the field body size
   * @this {!FieldModelOrderMessage}
   * @returns {!number} Field body size
   */
  get fbeBody () {
    return 4 + 4 + this.body.fbeSize
  }

  /**
   * Get the field extra size
   * @this {!FieldModelOrderMessage}
   * @returns {!number} Field extra size
   */
  get fbeExtra () {
    if ((this._buffer.offset + this.fbeOffset + this.fbeSize) > this._buffer.size) {
      return 0
    }

    let fbeStructOffset = this.readUInt32(this.fbeOffset)
    if ((fbeStructOffset === 0) || ((this._buffer.offset + fbeStructOffset + 4) > this._buffer.size)) {
      return 0
    }

    this._buffer.shift(fbeStructOffset)

    let fbeResult = this.fbeBody + this.body.fbeExtra

    this._buffer.unshift(fbeStructOffset)

    return fbeResult
  }

  /**
   * Get the field type
   * @this {!FieldModelOrderMessage}
   * @returns {!number} Field type
   */
  get fbeType () {
    return FieldModelOrderMessage.fbeType
  }

  /**
   * Get the field type (static)
   * @this {!FieldModelOrderMessage}
   * @returns {!number} Field type
   */
  static get fbeType () {
    return 11
  }

  /**
   * Check if the struct value is valid
   * @this {!FieldModelOrderMessage}
   * @param {!boolean} fbeVerifyType Verify model type flag, defaults is true
   * @returns {!boolean} Field model valid state
   */
  verify (fbeVerifyType = true) {
    if ((this._buffer.offset + this.fbeOffset + this.fbeSize) > this._buffer.size) {
      return true
    }

    let fbeStructOffset = this.readUInt32(this.fbeOffset)
    if ((fbeStructOffset === 0) || ((this._buffer.offset + fbeStructOffset + 4 + 4) > this._buffer.size)) {
      return false
    }

    let fbeStructSize = this.readUInt32(fbeStructOffset)
    if (fbeStructSize < (4 + 4)) {
      return false
    }

    let fbeStructType = this.readUInt32(fbeStructOffset + 4)
    if (fbeVerifyType && (fbeStructType !== this.fbeType)) {
      return false
    }

    this._buffer.shift(fbeStructOffset)
    let fbeResult = this.verifyFields(fbeStructSize)
    this._buffer.unshift(fbeStructOffset)
    return fbeResult
  }

  /**
   * Check if the struct fields are valid
   * @this {!FieldModelOrderMessage}
   * @param {!number} fbeStructSize FBE struct size
   * @returns {!boolean} Field model valid state
   */
  verifyFields (fbeStructSize) {
    let fbeCurrentSize = 4 + 4

    if ((fbeCurrentSize + this.body.fbeSize) > fbeStructSize) {
      return true
    }
    if (!this.body.verify()) {
      return false
    }
    // noinspection JSUnusedAssignment
    fbeCurrentSize += this.body.fbeSize

    return true
  }

  /**
   * Get the struct value (begin phase)
   * @this {!FieldModelOrderMessage}
   * @returns {!number} Field model begin offset
   */
  getBegin () {
    if ((this._buffer.offset + this.fbeOffset + this.fbeSize) > this._buffer.size) {
      return 0
    }

    let fbeStructOffset = this.readUInt32(this.fbeOffset)
    console.assert((fbeStructOffset > 0) && ((this._buffer.offset + fbeStructOffset + 4 + 4) <= this._buffer.size), 'Model is broken!')
    if ((fbeStructOffset === 0) || ((this._buffer.offset + fbeStructOffset + 4 + 4) > this._buffer.size)) {
      return 0
    }

    let fbeStructSize = this.readUInt32(fbeStructOffset)
    console.assert((fbeStructSize >= (4 + 4)), 'Model is broken!')
    if (fbeStructSize < (4 + 4)) {
      return 0
    }

    this._buffer.shift(fbeStructOffset)
    return fbeStructOffset
  }

  /**
   * Get the struct value (end phase)
   * @this {!FieldModelOrderMessage}
   * @param {!number} fbeBegin Field model begin offset
   */
  getEnd (fbeBegin) {
    this._buffer.unshift(fbeBegin)
  }

  /**
   * Get the struct value
   * @this {!FieldModelOrderMessage}
   * @param {!OrderMessage} fbeValue Default value, defaults is new OrderMessage()
   * @returns {!OrderMessage} OrderMessage value
   */
  get (fbeValue = new OrderMessage()) {
    let fbeBegin = this.getBegin()
    if (fbeBegin === 0) {
      return fbeValue
    }

    let fbeStructSize = this.readUInt32(0)
    this.getFields(fbeValue, fbeStructSize)
    this.getEnd(fbeBegin)
    return fbeValue
  }

  /**
   * Get the struct fields values
   * @this {!FieldModelOrderMessage}
   * @param {!OrderMessage} fbeValue OrderMessage value
   * @param {!number} fbeStructSize Struct size
   */
  getFields (fbeValue, fbeStructSize) {
    let fbeCurrentSize = 4 + 4

    if ((fbeCurrentSize + this.body.fbeSize) <= fbeStructSize) {
      fbeValue.body = this.body.get()
    } else {
      fbeValue.body = new Order()
    }
    // noinspection JSUnusedAssignment
    fbeCurrentSize += this.body.fbeSize
  }

  /**
   * Set the struct value (begin phase)
   * @this {!FieldModelOrderMessage}
   * @returns {!number} Field model begin offset
   */
  setBegin () {
    console.assert(((this._buffer.offset + this.fbeOffset + this.fbeSize) <= this._buffer.size), 'Model is broken!')
    if ((this._buffer.offset + this.fbeOffset + this.fbeSize) > this._buffer.size) {
      return 0
    }

    let fbeStructSize = this.fbeBody
    let fbeStructOffset = this._buffer.allocate(fbeStructSize) - this._buffer.offset
    console.assert((fbeStructOffset > 0) && ((this._buffer.offset + fbeStructOffset + fbeStructSize) <= this._buffer.size), 'Model is broken!')
    if ((fbeStructOffset <= 0) || ((this._buffer.offset + fbeStructOffset + fbeStructSize) > this._buffer.size)) {
      return 0
    }

    this.writeUInt32(this.fbeOffset, fbeStructOffset)
    this.writeUInt32(fbeStructOffset, fbeStructSize)
    this.writeUInt32(fbeStructOffset + 4, this.fbeType)

    this._buffer.shift(fbeStructOffset)
    return fbeStructOffset
  }

  /**
   * Set the struct value (end phase)
   * @this {!FieldModelOrderMessage}
   * @param {!number} fbeBegin Field model begin offset
   */
  setEnd (fbeBegin) {
    this._buffer.unshift(fbeBegin)
  }

  /**
   * Set the struct value
   * @this {!FieldModelOrderMessage}
   * @param {!OrderMessage} fbeValue OrderMessage value
   */
  set (fbeValue) {
    let fbeBegin = this.setBegin()
    if (fbeBegin === 0) {
      return
    }

    this.setFields(fbeValue)
    this.setEnd(fbeBegin)
  }

  /**
   * Set the struct fields values
   * @this {!FieldModelOrderMessage}
   * @param {OrderMessage} fbeValue OrderMessage value
   */
  setFields (fbeValue) {
    this.body.set(fbeValue.body)
  }
}

exports.FieldModelOrderMessage = FieldModelOrderMessage

/**
 * Fast Binary Encoding OrderMessage model
 */
class OrderMessageModel extends fbe.Model {
  /**
   * Initialize model with the given buffer
   * @param {!fbe.ReadBuffer|!fbe.WriteBuffer} buffer Read/Write buffer, defaults is new fbe.WriteBuffer()
   * @constructor
   */
  constructor (buffer = new fbe.WriteBuffer()) {
    super(buffer)
    this._model = new FieldModelOrderMessage(this.buffer, 4)
  }

  /**
   * Get the OrderMessage model
   * @this {!OrderMessageModel}
   * @returns {!FieldModelOrderMessage} model OrderMessage model
   */
  get model () {
    return this._model
  }

  /**
   * Get the model size
   * @this {!OrderMessageModel}
   * @returns {!number} Model size
   */
  get fbeSize () {
    return this.model.fbeSize + this.model.fbeExtra
  }

  /**
   * Get the model type
   * @this {!OrderMessageModel}
   * @returns {!number} Model type
   */
  get fbeType () {
    return OrderMessageModel.fbeType
  }

  /**
   * Get the model type (static)
   * @this {!OrderMessageModel}
   * @returns {!number} Model type
   */
  static get fbeType () {
    return FieldModelOrderMessage.fbeType
  }

  /**
   * Check if the struct value is valid
   * @this {!OrderMessageModel}
   * @returns {!boolean} Model valid state
   */
  verify () {
    if ((this.buffer.offset + this.model.fbeOffset - 4) > this.buffer.size) {
      return false
    }

    let fbeFullSize = this.readUInt32(this.model.fbeOffset - 4)
    if (fbeFullSize < this.model.fbeSize) {
      return false
    }

    return this.model.verify()
  }

  /**
   * Create a new model (begin phase)
   * @this {!OrderMessageModel}
   * @returns {!number} Model begin offset
   */
  createBegin () {
    return this.buffer.allocate(4 + this.model.fbeSize)
  }

  /**
   * Create a new model (end phase)
   * @this {!OrderMessageModel}
   * @param {!number} fbeBegin Model begin offset
   */
  createEnd (fbeBegin) {
    let fbeEnd = this.buffer.size
    let fbeFullSize = fbeEnd - fbeBegin
    this.writeUInt32(this.model.fbeOffset - 4, fbeFullSize)
    return fbeFullSize
  }

  /**
   * Serialize the struct value
   * @this {!OrderMessageModel}
   * @param {!OrderMessage} value OrderMessage value
   * @return {!number} Model begin offset
   */
  serialize (value) {
    let fbeBegin = this.createBegin()
    this.model.set(value)
    return this.createEnd(fbeBegin)
  }

  /**
   * Deserialize the struct value
   * @this {!OrderMessageModel}
   * @param {!OrderMessage} value OrderMessage value, defaults is new OrderMessage()
   * @return {!object} Deserialized OrderMessage value and its size
   */
  deserialize (value = new OrderMessage()) {
    if ((this.buffer.offset + this.model.fbeOffset - 4) > this.buffer.size) {
      return { value: new OrderMessage(), size: 0 }
    }

    let fbeFullSize = this.readUInt32(this.model.fbeOffset - 4)
    console.assert((fbeFullSize >= this.model.fbeSize), 'Model is broken!')
    if (fbeFullSize < this.model.fbeSize) {
      return { value: new OrderMessage(), size: 0 }
    }

    this.model.get(value)
    return { value: value, size: fbeFullSize }
  }

  /**
   * Move to the next struct value
   * @this {!OrderMessageModel}
   * @param {!number} prev Previous OrderMessage model size
   */
  next (prev) {
    this.model.fbeShift(prev)
  }
}

exports.OrderMessageModel = OrderMessageModel

/**
 * Fast Binary Encoding OrderMessage final model
 */
class FinalModelOrderMessage extends fbe.FinalModel {
  /**
   * Initialize final model with the given buffer and offset
   * @param {!fbe.ReadBuffer|!fbe.WriteBuffer} buffer Buffer
   * @param {!number} offset Offset
   * @constructor
   */
  constructor (buffer, offset) {
    super(buffer, offset)
    this._body = new FinalModelOrder(buffer, 0)
  }

  /**
   * Get the body final model
   * @this {!FinalModelOrderMessage}
   * @returns {!FinalModelOrder} body final model
   */
  get body () {
    return this._body
  }

  /**
   * Get the allocation size
   * @this {!FinalModelOrderMessage}
   * @param {!OrderMessage} fbeValue OrderMessage value
   * @returns {!number} Allocation size
   */
  fbeAllocationSize (fbeValue) {
    return 0 + this.body.fbeAllocationSize(fbeValue.body)
  }

  /**
   * Get the final type
   * @this {!FinalModelOrderMessage}
   * @returns {!number} Final type
   */
  get fbeType () {
    return FinalModelOrderMessage.fbeType
  }

  /**
   * Get the final type (static)
   * @this {!FinalModelOrderMessage}
   * @returns {!number} Final type
   */
  static get fbeType () {
    return 11
  }

  /**
   * Check if the struct value is valid
   * @this {!FinalModelOrderMessage}
   * @returns {!number} Final model size or Number.MAX_SAFE_INTEGER in case of any error
   */
  verify () {
    this._buffer.shift(this.fbeOffset)
    let fbeResult = this.verifyFields()
    this._buffer.unshift(this.fbeOffset)
    return fbeResult
  }

  /**
   * Check if the struct fields are valid
   * @this {!FinalModelOrderMessage}
   * @returns {!number} Final model size or Number.MAX_SAFE_INTEGER in case of any error
   */
  verifyFields () {
    let fbeCurrentOffset = 0
    let fbeFieldSize

    this.body.fbeOffset = fbeCurrentOffset
    fbeFieldSize = this.body.verify()
    if (fbeFieldSize === Number.MAX_SAFE_INTEGER) {
      return Number.MAX_SAFE_INTEGER
    }
    fbeCurrentOffset += fbeFieldSize

    return fbeCurrentOffset
  }

  /**
   * Get the struct value
   * @this {!FinalModelOrderMessage}
   * @param {!OrderMessage} fbeValue OrderMessage value, defaults is new OrderMessage()
   * @returns {!object} Result struct value and its size
   */
  get (fbeValue = new OrderMessage()) {
    this._buffer.shift(this.fbeOffset)
    let fbeSize = this.getFields(fbeValue)
    this._buffer.unshift(this.fbeOffset)
    return { value: fbeValue, size: fbeSize }
  }

  /**
   * Get the struct fields values
   * @this {!FinalModelOrderMessage}
   * @param {!OrderMessage} fbeValue OrderMessage value
   * @returns {!number} Struct size
   */
  getFields (fbeValue) {
    let fbeCurrentOffset = 0
    let fbeCurrentSize = 0
    let fbeResult

    this.body.fbeOffset = fbeCurrentOffset
    fbeResult = this.body.get()
    fbeValue.body = fbeResult.value
    // noinspection JSUnusedAssignment
    fbeCurrentOffset += fbeResult.size
    fbeCurrentSize += fbeResult.size

    return fbeCurrentSize
  }

  /**
   * Set the struct value
   * @this {!FinalModelOrderMessage}
   * @param {!OrderMessage} fbeValue OrderMessage value
   * @returns {!number} Final model size
   */
  set (fbeValue) {
    this._buffer.shift(this.fbeOffset)
    let fbeSize = this.setFields(fbeValue)
    this._buffer.unshift(this.fbeOffset)
    return fbeSize
  }

  /**
   * Set the struct fields values
   * @this {!FinalModelOrderMessage}
   * @param {OrderMessage} fbeValue OrderMessage value
   * @returns {!number} Final model size
   */
  setFields (fbeValue) {
    let fbeCurrentOffset = 0
    let fbeCurrentSize = 0
    let fbeFieldSize

    this.body.fbeOffset = fbeCurrentOffset
    fbeFieldSize = this.body.set(fbeValue.body)
    // noinspection JSUnusedAssignment
    fbeCurrentOffset += fbeFieldSize
    fbeCurrentSize += fbeFieldSize

    return fbeCurrentSize
  }
}

exports.FinalModelOrderMessage = FinalModelOrderMessage

/**
 * Fast Binary Encoding OrderMessage final model
 */
class OrderMessageFinalModel extends fbe.Model {
  /**
   * Initialize final model with the given buffer
   * @param {!fbe.ReadBuffer|!fbe.WriteBuffer} buffer Read/Write buffer, defaults is new fbe.WriteBuffer()
   * @constructor
   */
  constructor (buffer = new fbe.WriteBuffer()) {
    super(buffer)
    this._model = new FinalModelOrderMessage(this.buffer, 8)
  }

  /**
   * Get the model type
   * @this {!OrderMessageFinalModel}
   * @returns {!number} Model type
   */
  get fbeType () {
    return OrderMessageFinalModel.fbeType
  }

  /**
   * Get the model type (static)
   * @this {!OrderMessageFinalModel}
   * @returns {!number} Model type
   */
  static get fbeType () {
    return FinalModelOrderMessage.fbeType
  }

  /**
   * Check if the struct value is valid
   * @this {!OrderMessageFinalModel}
   * @returns {!boolean} Model valid state
   */
  verify () {
    if ((this.buffer.offset + this._model.fbeOffset) > this.buffer.size) {
      return false
    }

    let fbeStructSize = this.readUInt32(this._model.fbeOffset - 8)
    let fbeStructType = this.readUInt32(this._model.fbeOffset - 4)
    if ((fbeStructSize <= 0) || (fbeStructType !== this.fbeType)) {
      return false
    }

    return ((8 + this._model.verify()) === fbeStructSize)
  }

  /**
   * Serialize the struct value
   * @this {!OrderMessageFinalModel}
   * @param {!OrderMessage} value OrderMessage value
   * @return {!number} Struct size
   */
  serialize (value) {
    let fbeInitialSize = this.buffer.size

    let fbeStructType = this.fbeType
    let fbeStructSize = 8 + this._model.fbeAllocationSize(value)
    let fbeStructOffset = this.buffer.allocate(fbeStructSize) - this.buffer.offset
    console.assert(((this.buffer.offset + fbeStructOffset + fbeStructSize) <= this.buffer.size), 'Model is broken!')
    if ((this.buffer.offset + fbeStructOffset + fbeStructSize) > this.buffer.size) {
      return 0
    }

    fbeStructSize = 8 + this._model.set(value)
    this.buffer.resize(fbeInitialSize + fbeStructSize)

    this.writeUInt32(this._model.fbeOffset - 8, fbeStructSize)
    this.writeUInt32(this._model.fbeOffset - 4, fbeStructType)

    return fbeStructSize
  }

  /**
   * Deserialize the struct value
   * @this {!OrderMessageFinalModel}
   * @param {!OrderMessage} value OrderMessage value, defaults is new OrderMessage()
   * @return {!object} Deserialized OrderMessage value and its size
   */
  deserialize (value = new OrderMessage()) {
    console.assert(((this.buffer.offset + this._model.fbeOffset) <= this.buffer.size), 'Model is broken!')
    if ((this.buffer.offset + this._model.fbeOffset) > this.buffer.size) {
      return { value: new OrderMessage(), size: 0 }
    }

    let fbeStructSize = this.readUInt32(this._model.fbeOffset - 8)
    let fbeStructType = this.readUInt32(this._model.fbeOffset - 4)
    console.assert(((fbeStructSize > 0) && (fbeStructType === this.fbeType)), 'Model is broken!')
    if ((fbeStructSize <= 0) || (fbeStructType !== this.fbeType)) {
      return { value: new OrderMessage(), size: 8 }
    }

    let fbeResult = this._model.get(value)
    return { value: fbeResult.value, size: (8 + fbeResult.size) }
  }

  /**
   * Move to the next struct value
   * @this {!OrderMessageFinalModel}
   * @param {!number} prev Previous OrderMessage model size
   */
  next (prev) {
    this._model.fbeShift(prev)
  }
}

exports.OrderMessageFinalModel = OrderMessageFinalModel

/**
 * BalanceMessage struct
 */
class BalanceMessage {
  /**
   * Initialize struct
   * @param {!Balance=} body
   * @constructor
   */
  constructor (argbody = new Balance()) {
    this.body = argbody
  }

  /**
   * Copy struct (shallow copy)
   * @this {!BalanceMessage}
   * @param {!BalanceMessage} other Other struct
   * @returns {!BalanceMessage} This struct
   */
  copy (other) {
    if (other.body != null) {
      this.body = Balance.fromObject(other.body)
    } else {
      this.body = undefined
    }
    return this
  }

  /**
   * Clone struct (deep clone)
   * @this {!BalanceMessage}
   * @returns {!BalanceMessage} Cloned struct
   */
  clone () {
    // Serialize the struct to the FBE stream
    let writer = new BalanceMessageModel(new fbe.WriteBuffer())
    writer.serialize(this)

    // Deserialize the struct from the FBE stream
    let reader = new BalanceMessageModel(new fbe.ReadBuffer())
    reader.attachBuffer(writer.buffer)
    return reader.deserialize().value
  }

  /**
   * Is this struct equal to other one?
   * @this {!BalanceMessage}
   * @param {!BalanceMessage} other Other struct
   * @returns {boolean} Equal result
   */
  eq (other) {
    if (!(other instanceof BalanceMessage)) {
      throw new TypeError('Instance of BalanceMessage is required!')
    }
    return true
  }

  /**
   * Convert struct to string
   * @this {!BalanceMessage}
   * @returns {!string} Struct value string
   */
  toString () {
    let result = ''
    result += 'BalanceMessage('
    result += 'body='
    result += this.body.toString()
    result += ')'
    return result
  }

  /**
   * Inspect struct
   * @this {!BalanceMessage}
   * @returns {!string} Struct value string
   */
  [util.inspect.custom] () {
    return this.toString()
  }

  /**
   * Convert struct to JSON
   * @this {!BalanceMessage}
   * @returns {!object} Struct value for JSON
   */
  toJSON () {
    return {
      body: ((this.body != null) ? this.body : null)
    }
  }

  /**
   * Convert JSON to struct
   * @param {!string} json JSON string
   * @returns {!object} Struct value for JSON
   */
  static fromJSON (json) {
    return BalanceMessage.fromObject(JSON.parse(json))
  }

  /**
   * Create struct from object value
   * @param {!BalanceMessage} other Object value
   * @returns {!BalanceMessage} Created struct
   */
  static fromObject (other) {
    return new BalanceMessage().copy(other)
  }

  /**
   * Get the FBE type
   * @this {!BalanceMessage}
   * @returns {!number} FBE type
   */
  get fbeType () {
    return BalanceMessage.fbeType
  }

  /**
   * Get the FBE type (static)
   * @this {!BalanceMessage}
   * @returns {!number} FBE type
   */
  static get fbeType () {
    return 12
  }
}

exports.BalanceMessage = BalanceMessage

/**
 * Fast Binary Encoding BalanceMessage field model
 */
class FieldModelBalanceMessage extends fbe.FieldModel {
  /**
   * Initialize field model with the given buffer and offset
   * @param {!fbe.ReadBuffer|!fbe.WriteBuffer} buffer Buffer
   * @param {!number} offset Offset
   * @constructor
   */
  constructor (buffer, offset) {
    super(buffer, offset)
    this._body = new FieldModelBalance(buffer, 4 + 4)
  }

  /**
   * Get the body field model
   * @this {!FieldModelBalanceMessage}
   * @returns {!FieldModelBalance} body field model
   */
  get body () {
    return this._body
  }

  /**
   * Get the field size
   * @this {!FieldModelBalanceMessage}
   * @returns {!number} Field size
   */
  get fbeSize () {
    return 4
  }

  /**
   * Get the field body size
   * @this {!FieldModelBalanceMessage}
   * @returns {!number} Field body size
   */
  get fbeBody () {
    return 4 + 4 + this.body.fbeSize
  }

  /**
   * Get the field extra size
   * @this {!FieldModelBalanceMessage}
   * @returns {!number} Field extra size
   */
  get fbeExtra () {
    if ((this._buffer.offset + this.fbeOffset + this.fbeSize) > this._buffer.size) {
      return 0
    }

    let fbeStructOffset = this.readUInt32(this.fbeOffset)
    if ((fbeStructOffset === 0) || ((this._buffer.offset + fbeStructOffset + 4) > this._buffer.size)) {
      return 0
    }

    this._buffer.shift(fbeStructOffset)

    let fbeResult = this.fbeBody + this.body.fbeExtra

    this._buffer.unshift(fbeStructOffset)

    return fbeResult
  }

  /**
   * Get the field type
   * @this {!FieldModelBalanceMessage}
   * @returns {!number} Field type
   */
  get fbeType () {
    return FieldModelBalanceMessage.fbeType
  }

  /**
   * Get the field type (static)
   * @this {!FieldModelBalanceMessage}
   * @returns {!number} Field type
   */
  static get fbeType () {
    return 12
  }

  /**
   * Check if the struct value is valid
   * @this {!FieldModelBalanceMessage}
   * @param {!boolean} fbeVerifyType Verify model type flag, defaults is true
   * @returns {!boolean} Field model valid state
   */
  verify (fbeVerifyType = true) {
    if ((this._buffer.offset + this.fbeOffset + this.fbeSize) > this._buffer.size) {
      return true
    }

    let fbeStructOffset = this.readUInt32(this.fbeOffset)
    if ((fbeStructOffset === 0) || ((this._buffer.offset + fbeStructOffset + 4 + 4) > this._buffer.size)) {
      return false
    }

    let fbeStructSize = this.readUInt32(fbeStructOffset)
    if (fbeStructSize < (4 + 4)) {
      return false
    }

    let fbeStructType = this.readUInt32(fbeStructOffset + 4)
    if (fbeVerifyType && (fbeStructType !== this.fbeType)) {
      return false
    }

    this._buffer.shift(fbeStructOffset)
    let fbeResult = this.verifyFields(fbeStructSize)
    this._buffer.unshift(fbeStructOffset)
    return fbeResult
  }

  /**
   * Check if the struct fields are valid
   * @this {!FieldModelBalanceMessage}
   * @param {!number} fbeStructSize FBE struct size
   * @returns {!boolean} Field model valid state
   */
  verifyFields (fbeStructSize) {
    let fbeCurrentSize = 4 + 4

    if ((fbeCurrentSize + this.body.fbeSize) > fbeStructSize) {
      return true
    }
    if (!this.body.verify()) {
      return false
    }
    // noinspection JSUnusedAssignment
    fbeCurrentSize += this.body.fbeSize

    return true
  }

  /**
   * Get the struct value (begin phase)
   * @this {!FieldModelBalanceMessage}
   * @returns {!number} Field model begin offset
   */
  getBegin () {
    if ((this._buffer.offset + this.fbeOffset + this.fbeSize) > this._buffer.size) {
      return 0
    }

    let fbeStructOffset = this.readUInt32(this.fbeOffset)
    console.assert((fbeStructOffset > 0) && ((this._buffer.offset + fbeStructOffset + 4 + 4) <= this._buffer.size), 'Model is broken!')
    if ((fbeStructOffset === 0) || ((this._buffer.offset + fbeStructOffset + 4 + 4) > this._buffer.size)) {
      return 0
    }

    let fbeStructSize = this.readUInt32(fbeStructOffset)
    console.assert((fbeStructSize >= (4 + 4)), 'Model is broken!')
    if (fbeStructSize < (4 + 4)) {
      return 0
    }

    this._buffer.shift(fbeStructOffset)
    return fbeStructOffset
  }

  /**
   * Get the struct value (end phase)
   * @this {!FieldModelBalanceMessage}
   * @param {!number} fbeBegin Field model begin offset
   */
  getEnd (fbeBegin) {
    this._buffer.unshift(fbeBegin)
  }

  /**
   * Get the struct value
   * @this {!FieldModelBalanceMessage}
   * @param {!BalanceMessage} fbeValue Default value, defaults is new BalanceMessage()
   * @returns {!BalanceMessage} BalanceMessage value
   */
  get (fbeValue = new BalanceMessage()) {
    let fbeBegin = this.getBegin()
    if (fbeBegin === 0) {
      return fbeValue
    }

    let fbeStructSize = this.readUInt32(0)
    this.getFields(fbeValue, fbeStructSize)
    this.getEnd(fbeBegin)
    return fbeValue
  }

  /**
   * Get the struct fields values
   * @this {!FieldModelBalanceMessage}
   * @param {!BalanceMessage} fbeValue BalanceMessage value
   * @param {!number} fbeStructSize Struct size
   */
  getFields (fbeValue, fbeStructSize) {
    let fbeCurrentSize = 4 + 4

    if ((fbeCurrentSize + this.body.fbeSize) <= fbeStructSize) {
      fbeValue.body = this.body.get()
    } else {
      fbeValue.body = new Balance()
    }
    // noinspection JSUnusedAssignment
    fbeCurrentSize += this.body.fbeSize
  }

  /**
   * Set the struct value (begin phase)
   * @this {!FieldModelBalanceMessage}
   * @returns {!number} Field model begin offset
   */
  setBegin () {
    console.assert(((this._buffer.offset + this.fbeOffset + this.fbeSize) <= this._buffer.size), 'Model is broken!')
    if ((this._buffer.offset + this.fbeOffset + this.fbeSize) > this._buffer.size) {
      return 0
    }

    let fbeStructSize = this.fbeBody
    let fbeStructOffset = this._buffer.allocate(fbeStructSize) - this._buffer.offset
    console.assert((fbeStructOffset > 0) && ((this._buffer.offset + fbeStructOffset + fbeStructSize) <= this._buffer.size), 'Model is broken!')
    if ((fbeStructOffset <= 0) || ((this._buffer.offset + fbeStructOffset + fbeStructSize) > this._buffer.size)) {
      return 0
    }

    this.writeUInt32(this.fbeOffset, fbeStructOffset)
    this.writeUInt32(fbeStructOffset, fbeStructSize)
    this.writeUInt32(fbeStructOffset + 4, this.fbeType)

    this._buffer.shift(fbeStructOffset)
    return fbeStructOffset
  }

  /**
   * Set the struct value (end phase)
   * @this {!FieldModelBalanceMessage}
   * @param {!number} fbeBegin Field model begin offset
   */
  setEnd (fbeBegin) {
    this._buffer.unshift(fbeBegin)
  }

  /**
   * Set the struct value
   * @this {!FieldModelBalanceMessage}
   * @param {!BalanceMessage} fbeValue BalanceMessage value
   */
  set (fbeValue) {
    let fbeBegin = this.setBegin()
    if (fbeBegin === 0) {
      return
    }

    this.setFields(fbeValue)
    this.setEnd(fbeBegin)
  }

  /**
   * Set the struct fields values
   * @this {!FieldModelBalanceMessage}
   * @param {BalanceMessage} fbeValue BalanceMessage value
   */
  setFields (fbeValue) {
    this.body.set(fbeValue.body)
  }
}

exports.FieldModelBalanceMessage = FieldModelBalanceMessage

/**
 * Fast Binary Encoding BalanceMessage model
 */
class BalanceMessageModel extends fbe.Model {
  /**
   * Initialize model with the given buffer
   * @param {!fbe.ReadBuffer|!fbe.WriteBuffer} buffer Read/Write buffer, defaults is new fbe.WriteBuffer()
   * @constructor
   */
  constructor (buffer = new fbe.WriteBuffer()) {
    super(buffer)
    this._model = new FieldModelBalanceMessage(this.buffer, 4)
  }

  /**
   * Get the BalanceMessage model
   * @this {!BalanceMessageModel}
   * @returns {!FieldModelBalanceMessage} model BalanceMessage model
   */
  get model () {
    return this._model
  }

  /**
   * Get the model size
   * @this {!BalanceMessageModel}
   * @returns {!number} Model size
   */
  get fbeSize () {
    return this.model.fbeSize + this.model.fbeExtra
  }

  /**
   * Get the model type
   * @this {!BalanceMessageModel}
   * @returns {!number} Model type
   */
  get fbeType () {
    return BalanceMessageModel.fbeType
  }

  /**
   * Get the model type (static)
   * @this {!BalanceMessageModel}
   * @returns {!number} Model type
   */
  static get fbeType () {
    return FieldModelBalanceMessage.fbeType
  }

  /**
   * Check if the struct value is valid
   * @this {!BalanceMessageModel}
   * @returns {!boolean} Model valid state
   */
  verify () {
    if ((this.buffer.offset + this.model.fbeOffset - 4) > this.buffer.size) {
      return false
    }

    let fbeFullSize = this.readUInt32(this.model.fbeOffset - 4)
    if (fbeFullSize < this.model.fbeSize) {
      return false
    }

    return this.model.verify()
  }

  /**
   * Create a new model (begin phase)
   * @this {!BalanceMessageModel}
   * @returns {!number} Model begin offset
   */
  createBegin () {
    return this.buffer.allocate(4 + this.model.fbeSize)
  }

  /**
   * Create a new model (end phase)
   * @this {!BalanceMessageModel}
   * @param {!number} fbeBegin Model begin offset
   */
  createEnd (fbeBegin) {
    let fbeEnd = this.buffer.size
    let fbeFullSize = fbeEnd - fbeBegin
    this.writeUInt32(this.model.fbeOffset - 4, fbeFullSize)
    return fbeFullSize
  }

  /**
   * Serialize the struct value
   * @this {!BalanceMessageModel}
   * @param {!BalanceMessage} value BalanceMessage value
   * @return {!number} Model begin offset
   */
  serialize (value) {
    let fbeBegin = this.createBegin()
    this.model.set(value)
    return this.createEnd(fbeBegin)
  }

  /**
   * Deserialize the struct value
   * @this {!BalanceMessageModel}
   * @param {!BalanceMessage} value BalanceMessage value, defaults is new BalanceMessage()
   * @return {!object} Deserialized BalanceMessage value and its size
   */
  deserialize (value = new BalanceMessage()) {
    if ((this.buffer.offset + this.model.fbeOffset - 4) > this.buffer.size) {
      return { value: new BalanceMessage(), size: 0 }
    }

    let fbeFullSize = this.readUInt32(this.model.fbeOffset - 4)
    console.assert((fbeFullSize >= this.model.fbeSize), 'Model is broken!')
    if (fbeFullSize < this.model.fbeSize) {
      return { value: new BalanceMessage(), size: 0 }
    }

    this.model.get(value)
    return { value: value, size: fbeFullSize }
  }

  /**
   * Move to the next struct value
   * @this {!BalanceMessageModel}
   * @param {!number} prev Previous BalanceMessage model size
   */
  next (prev) {
    this.model.fbeShift(prev)
  }
}

exports.BalanceMessageModel = BalanceMessageModel

/**
 * Fast Binary Encoding BalanceMessage final model
 */
class FinalModelBalanceMessage extends fbe.FinalModel {
  /**
   * Initialize final model with the given buffer and offset
   * @param {!fbe.ReadBuffer|!fbe.WriteBuffer} buffer Buffer
   * @param {!number} offset Offset
   * @constructor
   */
  constructor (buffer, offset) {
    super(buffer, offset)
    this._body = new FinalModelBalance(buffer, 0)
  }

  /**
   * Get the body final model
   * @this {!FinalModelBalanceMessage}
   * @returns {!FinalModelBalance} body final model
   */
  get body () {
    return this._body
  }

  /**
   * Get the allocation size
   * @this {!FinalModelBalanceMessage}
   * @param {!BalanceMessage} fbeValue BalanceMessage value
   * @returns {!number} Allocation size
   */
  fbeAllocationSize (fbeValue) {
    return 0 + this.body.fbeAllocationSize(fbeValue.body)
  }

  /**
   * Get the final type
   * @this {!FinalModelBalanceMessage}
   * @returns {!number} Final type
   */
  get fbeType () {
    return FinalModelBalanceMessage.fbeType
  }

  /**
   * Get the final type (static)
   * @this {!FinalModelBalanceMessage}
   * @returns {!number} Final type
   */
  static get fbeType () {
    return 12
  }

  /**
   * Check if the struct value is valid
   * @this {!FinalModelBalanceMessage}
   * @returns {!number} Final model size or Number.MAX_SAFE_INTEGER in case of any error
   */
  verify () {
    this._buffer.shift(this.fbeOffset)
    let fbeResult = this.verifyFields()
    this._buffer.unshift(this.fbeOffset)
    return fbeResult
  }

  /**
   * Check if the struct fields are valid
   * @this {!FinalModelBalanceMessage}
   * @returns {!number} Final model size or Number.MAX_SAFE_INTEGER in case of any error
   */
  verifyFields () {
    let fbeCurrentOffset = 0
    let fbeFieldSize

    this.body.fbeOffset = fbeCurrentOffset
    fbeFieldSize = this.body.verify()
    if (fbeFieldSize === Number.MAX_SAFE_INTEGER) {
      return Number.MAX_SAFE_INTEGER
    }
    fbeCurrentOffset += fbeFieldSize

    return fbeCurrentOffset
  }

  /**
   * Get the struct value
   * @this {!FinalModelBalanceMessage}
   * @param {!BalanceMessage} fbeValue BalanceMessage value, defaults is new BalanceMessage()
   * @returns {!object} Result struct value and its size
   */
  get (fbeValue = new BalanceMessage()) {
    this._buffer.shift(this.fbeOffset)
    let fbeSize = this.getFields(fbeValue)
    this._buffer.unshift(this.fbeOffset)
    return { value: fbeValue, size: fbeSize }
  }

  /**
   * Get the struct fields values
   * @this {!FinalModelBalanceMessage}
   * @param {!BalanceMessage} fbeValue BalanceMessage value
   * @returns {!number} Struct size
   */
  getFields (fbeValue) {
    let fbeCurrentOffset = 0
    let fbeCurrentSize = 0
    let fbeResult

    this.body.fbeOffset = fbeCurrentOffset
    fbeResult = this.body.get()
    fbeValue.body = fbeResult.value
    // noinspection JSUnusedAssignment
    fbeCurrentOffset += fbeResult.size
    fbeCurrentSize += fbeResult.size

    return fbeCurrentSize
  }

  /**
   * Set the struct value
   * @this {!FinalModelBalanceMessage}
   * @param {!BalanceMessage} fbeValue BalanceMessage value
   * @returns {!number} Final model size
   */
  set (fbeValue) {
    this._buffer.shift(this.fbeOffset)
    let fbeSize = this.setFields(fbeValue)
    this._buffer.unshift(this.fbeOffset)
    return fbeSize
  }

  /**
   * Set the struct fields values
   * @this {!FinalModelBalanceMessage}
   * @param {BalanceMessage} fbeValue BalanceMessage value
   * @returns {!number} Final model size
   */
  setFields (fbeValue) {
    let fbeCurrentOffset = 0
    let fbeCurrentSize = 0
    let fbeFieldSize

    this.body.fbeOffset = fbeCurrentOffset
    fbeFieldSize = this.body.set(fbeValue.body)
    // noinspection JSUnusedAssignment
    fbeCurrentOffset += fbeFieldSize
    fbeCurrentSize += fbeFieldSize

    return fbeCurrentSize
  }
}

exports.FinalModelBalanceMessage = FinalModelBalanceMessage

/**
 * Fast Binary Encoding BalanceMessage final model
 */
class BalanceMessageFinalModel extends fbe.Model {
  /**
   * Initialize final model with the given buffer
   * @param {!fbe.ReadBuffer|!fbe.WriteBuffer} buffer Read/Write buffer, defaults is new fbe.WriteBuffer()
   * @constructor
   */
  constructor (buffer = new fbe.WriteBuffer()) {
    super(buffer)
    this._model = new FinalModelBalanceMessage(this.buffer, 8)
  }

  /**
   * Get the model type
   * @this {!BalanceMessageFinalModel}
   * @returns {!number} Model type
   */
  get fbeType () {
    return BalanceMessageFinalModel.fbeType
  }

  /**
   * Get the model type (static)
   * @this {!BalanceMessageFinalModel}
   * @returns {!number} Model type
   */
  static get fbeType () {
    return FinalModelBalanceMessage.fbeType
  }

  /**
   * Check if the struct value is valid
   * @this {!BalanceMessageFinalModel}
   * @returns {!boolean} Model valid state
   */
  verify () {
    if ((this.buffer.offset + this._model.fbeOffset) > this.buffer.size) {
      return false
    }

    let fbeStructSize = this.readUInt32(this._model.fbeOffset - 8)
    let fbeStructType = this.readUInt32(this._model.fbeOffset - 4)
    if ((fbeStructSize <= 0) || (fbeStructType !== this.fbeType)) {
      return false
    }

    return ((8 + this._model.verify()) === fbeStructSize)
  }

  /**
   * Serialize the struct value
   * @this {!BalanceMessageFinalModel}
   * @param {!BalanceMessage} value BalanceMessage value
   * @return {!number} Struct size
   */
  serialize (value) {
    let fbeInitialSize = this.buffer.size

    let fbeStructType = this.fbeType
    let fbeStructSize = 8 + this._model.fbeAllocationSize(value)
    let fbeStructOffset = this.buffer.allocate(fbeStructSize) - this.buffer.offset
    console.assert(((this.buffer.offset + fbeStructOffset + fbeStructSize) <= this.buffer.size), 'Model is broken!')
    if ((this.buffer.offset + fbeStructOffset + fbeStructSize) > this.buffer.size) {
      return 0
    }

    fbeStructSize = 8 + this._model.set(value)
    this.buffer.resize(fbeInitialSize + fbeStructSize)

    this.writeUInt32(this._model.fbeOffset - 8, fbeStructSize)
    this.writeUInt32(this._model.fbeOffset - 4, fbeStructType)

    return fbeStructSize
  }

  /**
   * Deserialize the struct value
   * @this {!BalanceMessageFinalModel}
   * @param {!BalanceMessage} value BalanceMessage value, defaults is new BalanceMessage()
   * @return {!object} Deserialized BalanceMessage value and its size
   */
  deserialize (value = new BalanceMessage()) {
    console.assert(((this.buffer.offset + this._model.fbeOffset) <= this.buffer.size), 'Model is broken!')
    if ((this.buffer.offset + this._model.fbeOffset) > this.buffer.size) {
      return { value: new BalanceMessage(), size: 0 }
    }

    let fbeStructSize = this.readUInt32(this._model.fbeOffset - 8)
    let fbeStructType = this.readUInt32(this._model.fbeOffset - 4)
    console.assert(((fbeStructSize > 0) && (fbeStructType === this.fbeType)), 'Model is broken!')
    if ((fbeStructSize <= 0) || (fbeStructType !== this.fbeType)) {
      return { value: new BalanceMessage(), size: 8 }
    }

    let fbeResult = this._model.get(value)
    return { value: fbeResult.value, size: (8 + fbeResult.size) }
  }

  /**
   * Move to the next struct value
   * @this {!BalanceMessageFinalModel}
   * @param {!number} prev Previous BalanceMessage model size
   */
  next (prev) {
    this._model.fbeShift(prev)
  }
}

exports.BalanceMessageFinalModel = BalanceMessageFinalModel

/**
 * AccountMessage struct
 */
class AccountMessage {
  /**
   * Initialize struct
   * @param {!Account=} body
   * @constructor
   */
  constructor (argbody = new Account()) {
    this.body = argbody
  }

  /**
   * Copy struct (shallow copy)
   * @this {!AccountMessage}
   * @param {!AccountMessage} other Other struct
   * @returns {!AccountMessage} This struct
   */
  copy (other) {
    if (other.body != null) {
      this.body = Account.fromObject(other.body)
    } else {
      this.body = undefined
    }
    return this
  }

  /**
   * Clone struct (deep clone)
   * @this {!AccountMessage}
   * @returns {!AccountMessage} Cloned struct
   */
  clone () {
    // Serialize the struct to the FBE stream
    let writer = new AccountMessageModel(new fbe.WriteBuffer())
    writer.serialize(this)

    // Deserialize the struct from the FBE stream
    let reader = new AccountMessageModel(new fbe.ReadBuffer())
    reader.attachBuffer(writer.buffer)
    return reader.deserialize().value
  }

  /**
   * Is this struct equal to other one?
   * @this {!AccountMessage}
   * @param {!AccountMessage} other Other struct
   * @returns {boolean} Equal result
   */
  eq (other) {
    if (!(other instanceof AccountMessage)) {
      throw new TypeError('Instance of AccountMessage is required!')
    }
    return true
  }

  /**
   * Convert struct to string
   * @this {!AccountMessage}
   * @returns {!string} Struct value string
   */
  toString () {
    let result = ''
    result += 'AccountMessage('
    result += 'body='
    result += this.body.toString()
    result += ')'
    return result
  }

  /**
   * Inspect struct
   * @this {!AccountMessage}
   * @returns {!string} Struct value string
   */
  [util.inspect.custom] () {
    return this.toString()
  }

  /**
   * Convert struct to JSON
   * @this {!AccountMessage}
   * @returns {!object} Struct value for JSON
   */
  toJSON () {
    return {
      body: ((this.body != null) ? this.body : null)
    }
  }

  /**
   * Convert JSON to struct
   * @param {!string} json JSON string
   * @returns {!object} Struct value for JSON
   */
  static fromJSON (json) {
    return AccountMessage.fromObject(JSON.parse(json))
  }

  /**
   * Create struct from object value
   * @param {!AccountMessage} other Object value
   * @returns {!AccountMessage} Created struct
   */
  static fromObject (other) {
    return new AccountMessage().copy(other)
  }

  /**
   * Get the FBE type
   * @this {!AccountMessage}
   * @returns {!number} FBE type
   */
  get fbeType () {
    return AccountMessage.fbeType
  }

  /**
   * Get the FBE type (static)
   * @this {!AccountMessage}
   * @returns {!number} FBE type
   */
  static get fbeType () {
    return 13
  }
}

exports.AccountMessage = AccountMessage

/**
 * Fast Binary Encoding AccountMessage field model
 */
class FieldModelAccountMessage extends fbe.FieldModel {
  /**
   * Initialize field model with the given buffer and offset
   * @param {!fbe.ReadBuffer|!fbe.WriteBuffer} buffer Buffer
   * @param {!number} offset Offset
   * @constructor
   */
  constructor (buffer, offset) {
    super(buffer, offset)
    this._body = new FieldModelAccount(buffer, 4 + 4)
  }

  /**
   * Get the body field model
   * @this {!FieldModelAccountMessage}
   * @returns {!FieldModelAccount} body field model
   */
  get body () {
    return this._body
  }

  /**
   * Get the field size
   * @this {!FieldModelAccountMessage}
   * @returns {!number} Field size
   */
  get fbeSize () {
    return 4
  }

  /**
   * Get the field body size
   * @this {!FieldModelAccountMessage}
   * @returns {!number} Field body size
   */
  get fbeBody () {
    return 4 + 4 + this.body.fbeSize
  }

  /**
   * Get the field extra size
   * @this {!FieldModelAccountMessage}
   * @returns {!number} Field extra size
   */
  get fbeExtra () {
    if ((this._buffer.offset + this.fbeOffset + this.fbeSize) > this._buffer.size) {
      return 0
    }

    let fbeStructOffset = this.readUInt32(this.fbeOffset)
    if ((fbeStructOffset === 0) || ((this._buffer.offset + fbeStructOffset + 4) > this._buffer.size)) {
      return 0
    }

    this._buffer.shift(fbeStructOffset)

    let fbeResult = this.fbeBody + this.body.fbeExtra

    this._buffer.unshift(fbeStructOffset)

    return fbeResult
  }

  /**
   * Get the field type
   * @this {!FieldModelAccountMessage}
   * @returns {!number} Field type
   */
  get fbeType () {
    return FieldModelAccountMessage.fbeType
  }

  /**
   * Get the field type (static)
   * @this {!FieldModelAccountMessage}
   * @returns {!number} Field type
   */
  static get fbeType () {
    return 13
  }

  /**
   * Check if the struct value is valid
   * @this {!FieldModelAccountMessage}
   * @param {!boolean} fbeVerifyType Verify model type flag, defaults is true
   * @returns {!boolean} Field model valid state
   */
  verify (fbeVerifyType = true) {
    if ((this._buffer.offset + this.fbeOffset + this.fbeSize) > this._buffer.size) {
      return true
    }

    let fbeStructOffset = this.readUInt32(this.fbeOffset)
    if ((fbeStructOffset === 0) || ((this._buffer.offset + fbeStructOffset + 4 + 4) > this._buffer.size)) {
      return false
    }

    let fbeStructSize = this.readUInt32(fbeStructOffset)
    if (fbeStructSize < (4 + 4)) {
      return false
    }

    let fbeStructType = this.readUInt32(fbeStructOffset + 4)
    if (fbeVerifyType && (fbeStructType !== this.fbeType)) {
      return false
    }

    this._buffer.shift(fbeStructOffset)
    let fbeResult = this.verifyFields(fbeStructSize)
    this._buffer.unshift(fbeStructOffset)
    return fbeResult
  }

  /**
   * Check if the struct fields are valid
   * @this {!FieldModelAccountMessage}
   * @param {!number} fbeStructSize FBE struct size
   * @returns {!boolean} Field model valid state
   */
  verifyFields (fbeStructSize) {
    let fbeCurrentSize = 4 + 4

    if ((fbeCurrentSize + this.body.fbeSize) > fbeStructSize) {
      return true
    }
    if (!this.body.verify()) {
      return false
    }
    // noinspection JSUnusedAssignment
    fbeCurrentSize += this.body.fbeSize

    return true
  }

  /**
   * Get the struct value (begin phase)
   * @this {!FieldModelAccountMessage}
   * @returns {!number} Field model begin offset
   */
  getBegin () {
    if ((this._buffer.offset + this.fbeOffset + this.fbeSize) > this._buffer.size) {
      return 0
    }

    let fbeStructOffset = this.readUInt32(this.fbeOffset)
    console.assert((fbeStructOffset > 0) && ((this._buffer.offset + fbeStructOffset + 4 + 4) <= this._buffer.size), 'Model is broken!')
    if ((fbeStructOffset === 0) || ((this._buffer.offset + fbeStructOffset + 4 + 4) > this._buffer.size)) {
      return 0
    }

    let fbeStructSize = this.readUInt32(fbeStructOffset)
    console.assert((fbeStructSize >= (4 + 4)), 'Model is broken!')
    if (fbeStructSize < (4 + 4)) {
      return 0
    }

    this._buffer.shift(fbeStructOffset)
    return fbeStructOffset
  }

  /**
   * Get the struct value (end phase)
   * @this {!FieldModelAccountMessage}
   * @param {!number} fbeBegin Field model begin offset
   */
  getEnd (fbeBegin) {
    this._buffer.unshift(fbeBegin)
  }

  /**
   * Get the struct value
   * @this {!FieldModelAccountMessage}
   * @param {!AccountMessage} fbeValue Default value, defaults is new AccountMessage()
   * @returns {!AccountMessage} AccountMessage value
   */
  get (fbeValue = new AccountMessage()) {
    let fbeBegin = this.getBegin()
    if (fbeBegin === 0) {
      return fbeValue
    }

    let fbeStructSize = this.readUInt32(0)
    this.getFields(fbeValue, fbeStructSize)
    this.getEnd(fbeBegin)
    return fbeValue
  }

  /**
   * Get the struct fields values
   * @this {!FieldModelAccountMessage}
   * @param {!AccountMessage} fbeValue AccountMessage value
   * @param {!number} fbeStructSize Struct size
   */
  getFields (fbeValue, fbeStructSize) {
    let fbeCurrentSize = 4 + 4

    if ((fbeCurrentSize + this.body.fbeSize) <= fbeStructSize) {
      fbeValue.body = this.body.get()
    } else {
      fbeValue.body = new Account()
    }
    // noinspection JSUnusedAssignment
    fbeCurrentSize += this.body.fbeSize
  }

  /**
   * Set the struct value (begin phase)
   * @this {!FieldModelAccountMessage}
   * @returns {!number} Field model begin offset
   */
  setBegin () {
    console.assert(((this._buffer.offset + this.fbeOffset + this.fbeSize) <= this._buffer.size), 'Model is broken!')
    if ((this._buffer.offset + this.fbeOffset + this.fbeSize) > this._buffer.size) {
      return 0
    }

    let fbeStructSize = this.fbeBody
    let fbeStructOffset = this._buffer.allocate(fbeStructSize) - this._buffer.offset
    console.assert((fbeStructOffset > 0) && ((this._buffer.offset + fbeStructOffset + fbeStructSize) <= this._buffer.size), 'Model is broken!')
    if ((fbeStructOffset <= 0) || ((this._buffer.offset + fbeStructOffset + fbeStructSize) > this._buffer.size)) {
      return 0
    }

    this.writeUInt32(this.fbeOffset, fbeStructOffset)
    this.writeUInt32(fbeStructOffset, fbeStructSize)
    this.writeUInt32(fbeStructOffset + 4, this.fbeType)

    this._buffer.shift(fbeStructOffset)
    return fbeStructOffset
  }

  /**
   * Set the struct value (end phase)
   * @this {!FieldModelAccountMessage}
   * @param {!number} fbeBegin Field model begin offset
   */
  setEnd (fbeBegin) {
    this._buffer.unshift(fbeBegin)
  }

  /**
   * Set the struct value
   * @this {!FieldModelAccountMessage}
   * @param {!AccountMessage} fbeValue AccountMessage value
   */
  set (fbeValue) {
    let fbeBegin = this.setBegin()
    if (fbeBegin === 0) {
      return
    }

    this.setFields(fbeValue)
    this.setEnd(fbeBegin)
  }

  /**
   * Set the struct fields values
   * @this {!FieldModelAccountMessage}
   * @param {AccountMessage} fbeValue AccountMessage value
   */
  setFields (fbeValue) {
    this.body.set(fbeValue.body)
  }
}

exports.FieldModelAccountMessage = FieldModelAccountMessage

/**
 * Fast Binary Encoding AccountMessage model
 */
class AccountMessageModel extends fbe.Model {
  /**
   * Initialize model with the given buffer
   * @param {!fbe.ReadBuffer|!fbe.WriteBuffer} buffer Read/Write buffer, defaults is new fbe.WriteBuffer()
   * @constructor
   */
  constructor (buffer = new fbe.WriteBuffer()) {
    super(buffer)
    this._model = new FieldModelAccountMessage(this.buffer, 4)
  }

  /**
   * Get the AccountMessage model
   * @this {!AccountMessageModel}
   * @returns {!FieldModelAccountMessage} model AccountMessage model
   */
  get model () {
    return this._model
  }

  /**
   * Get the model size
   * @this {!AccountMessageModel}
   * @returns {!number} Model size
   */
  get fbeSize () {
    return this.model.fbeSize + this.model.fbeExtra
  }

  /**
   * Get the model type
   * @this {!AccountMessageModel}
   * @returns {!number} Model type
   */
  get fbeType () {
    return AccountMessageModel.fbeType
  }

  /**
   * Get the model type (static)
   * @this {!AccountMessageModel}
   * @returns {!number} Model type
   */
  static get fbeType () {
    return FieldModelAccountMessage.fbeType
  }

  /**
   * Check if the struct value is valid
   * @this {!AccountMessageModel}
   * @returns {!boolean} Model valid state
   */
  verify () {
    if ((this.buffer.offset + this.model.fbeOffset - 4) > this.buffer.size) {
      return false
    }

    let fbeFullSize = this.readUInt32(this.model.fbeOffset - 4)
    if (fbeFullSize < this.model.fbeSize) {
      return false
    }

    return this.model.verify()
  }

  /**
   * Create a new model (begin phase)
   * @this {!AccountMessageModel}
   * @returns {!number} Model begin offset
   */
  createBegin () {
    return this.buffer.allocate(4 + this.model.fbeSize)
  }

  /**
   * Create a new model (end phase)
   * @this {!AccountMessageModel}
   * @param {!number} fbeBegin Model begin offset
   */
  createEnd (fbeBegin) {
    let fbeEnd = this.buffer.size
    let fbeFullSize = fbeEnd - fbeBegin
    this.writeUInt32(this.model.fbeOffset - 4, fbeFullSize)
    return fbeFullSize
  }

  /**
   * Serialize the struct value
   * @this {!AccountMessageModel}
   * @param {!AccountMessage} value AccountMessage value
   * @return {!number} Model begin offset
   */
  serialize (value) {
    let fbeBegin = this.createBegin()
    this.model.set(value)
    return this.createEnd(fbeBegin)
  }

  /**
   * Deserialize the struct value
   * @this {!AccountMessageModel}
   * @param {!AccountMessage} value AccountMessage value, defaults is new AccountMessage()
   * @return {!object} Deserialized AccountMessage value and its size
   */
  deserialize (value = new AccountMessage()) {
    if ((this.buffer.offset + this.model.fbeOffset - 4) > this.buffer.size) {
      return { value: new AccountMessage(), size: 0 }
    }

    let fbeFullSize = this.readUInt32(this.model.fbeOffset - 4)
    console.assert((fbeFullSize >= this.model.fbeSize), 'Model is broken!')
    if (fbeFullSize < this.model.fbeSize) {
      return { value: new AccountMessage(), size: 0 }
    }

    this.model.get(value)
    return { value: value, size: fbeFullSize }
  }

  /**
   * Move to the next struct value
   * @this {!AccountMessageModel}
   * @param {!number} prev Previous AccountMessage model size
   */
  next (prev) {
    this.model.fbeShift(prev)
  }
}

exports.AccountMessageModel = AccountMessageModel

/**
 * Fast Binary Encoding AccountMessage final model
 */
class FinalModelAccountMessage extends fbe.FinalModel {
  /**
   * Initialize final model with the given buffer and offset
   * @param {!fbe.ReadBuffer|!fbe.WriteBuffer} buffer Buffer
   * @param {!number} offset Offset
   * @constructor
   */
  constructor (buffer, offset) {
    super(buffer, offset)
    this._body = new FinalModelAccount(buffer, 0)
  }

  /**
   * Get the body final model
   * @this {!FinalModelAccountMessage}
   * @returns {!FinalModelAccount} body final model
   */
  get body () {
    return this._body
  }

  /**
   * Get the allocation size
   * @this {!FinalModelAccountMessage}
   * @param {!AccountMessage} fbeValue AccountMessage value
   * @returns {!number} Allocation size
   */
  fbeAllocationSize (fbeValue) {
    return 0 + this.body.fbeAllocationSize(fbeValue.body)
  }

  /**
   * Get the final type
   * @this {!FinalModelAccountMessage}
   * @returns {!number} Final type
   */
  get fbeType () {
    return FinalModelAccountMessage.fbeType
  }

  /**
   * Get the final type (static)
   * @this {!FinalModelAccountMessage}
   * @returns {!number} Final type
   */
  static get fbeType () {
    return 13
  }

  /**
   * Check if the struct value is valid
   * @this {!FinalModelAccountMessage}
   * @returns {!number} Final model size or Number.MAX_SAFE_INTEGER in case of any error
   */
  verify () {
    this._buffer.shift(this.fbeOffset)
    let fbeResult = this.verifyFields()
    this._buffer.unshift(this.fbeOffset)
    return fbeResult
  }

  /**
   * Check if the struct fields are valid
   * @this {!FinalModelAccountMessage}
   * @returns {!number} Final model size or Number.MAX_SAFE_INTEGER in case of any error
   */
  verifyFields () {
    let fbeCurrentOffset = 0
    let fbeFieldSize

    this.body.fbeOffset = fbeCurrentOffset
    fbeFieldSize = this.body.verify()
    if (fbeFieldSize === Number.MAX_SAFE_INTEGER) {
      return Number.MAX_SAFE_INTEGER
    }
    fbeCurrentOffset += fbeFieldSize

    return fbeCurrentOffset
  }

  /**
   * Get the struct value
   * @this {!FinalModelAccountMessage}
   * @param {!AccountMessage} fbeValue AccountMessage value, defaults is new AccountMessage()
   * @returns {!object} Result struct value and its size
   */
  get (fbeValue = new AccountMessage()) {
    this._buffer.shift(this.fbeOffset)
    let fbeSize = this.getFields(fbeValue)
    this._buffer.unshift(this.fbeOffset)
    return { value: fbeValue, size: fbeSize }
  }

  /**
   * Get the struct fields values
   * @this {!FinalModelAccountMessage}
   * @param {!AccountMessage} fbeValue AccountMessage value
   * @returns {!number} Struct size
   */
  getFields (fbeValue) {
    let fbeCurrentOffset = 0
    let fbeCurrentSize = 0
    let fbeResult

    this.body.fbeOffset = fbeCurrentOffset
    fbeResult = this.body.get()
    fbeValue.body = fbeResult.value
    // noinspection JSUnusedAssignment
    fbeCurrentOffset += fbeResult.size
    fbeCurrentSize += fbeResult.size

    return fbeCurrentSize
  }

  /**
   * Set the struct value
   * @this {!FinalModelAccountMessage}
   * @param {!AccountMessage} fbeValue AccountMessage value
   * @returns {!number} Final model size
   */
  set (fbeValue) {
    this._buffer.shift(this.fbeOffset)
    let fbeSize = this.setFields(fbeValue)
    this._buffer.unshift(this.fbeOffset)
    return fbeSize
  }

  /**
   * Set the struct fields values
   * @this {!FinalModelAccountMessage}
   * @param {AccountMessage} fbeValue AccountMessage value
   * @returns {!number} Final model size
   */
  setFields (fbeValue) {
    let fbeCurrentOffset = 0
    let fbeCurrentSize = 0
    let fbeFieldSize

    this.body.fbeOffset = fbeCurrentOffset
    fbeFieldSize = this.body.set(fbeValue.body)
    // noinspection JSUnusedAssignment
    fbeCurrentOffset += fbeFieldSize
    fbeCurrentSize += fbeFieldSize

    return fbeCurrentSize
  }
}

exports.FinalModelAccountMessage = FinalModelAccountMessage

/**
 * Fast Binary Encoding AccountMessage final model
 */
class AccountMessageFinalModel extends fbe.Model {
  /**
   * Initialize final model with the given buffer
   * @param {!fbe.ReadBuffer|!fbe.WriteBuffer} buffer Read/Write buffer, defaults is new fbe.WriteBuffer()
   * @constructor
   */
  constructor (buffer = new fbe.WriteBuffer()) {
    super(buffer)
    this._model = new FinalModelAccountMessage(this.buffer, 8)
  }

  /**
   * Get the model type
   * @this {!AccountMessageFinalModel}
   * @returns {!number} Model type
   */
  get fbeType () {
    return AccountMessageFinalModel.fbeType
  }

  /**
   * Get the model type (static)
   * @this {!AccountMessageFinalModel}
   * @returns {!number} Model type
   */
  static get fbeType () {
    return FinalModelAccountMessage.fbeType
  }

  /**
   * Check if the struct value is valid
   * @this {!AccountMessageFinalModel}
   * @returns {!boolean} Model valid state
   */
  verify () {
    if ((this.buffer.offset + this._model.fbeOffset) > this.buffer.size) {
      return false
    }

    let fbeStructSize = this.readUInt32(this._model.fbeOffset - 8)
    let fbeStructType = this.readUInt32(this._model.fbeOffset - 4)
    if ((fbeStructSize <= 0) || (fbeStructType !== this.fbeType)) {
      return false
    }

    return ((8 + this._model.verify()) === fbeStructSize)
  }

  /**
   * Serialize the struct value
   * @this {!AccountMessageFinalModel}
   * @param {!AccountMessage} value AccountMessage value
   * @return {!number} Struct size
   */
  serialize (value) {
    let fbeInitialSize = this.buffer.size

    let fbeStructType = this.fbeType
    let fbeStructSize = 8 + this._model.fbeAllocationSize(value)
    let fbeStructOffset = this.buffer.allocate(fbeStructSize) - this.buffer.offset
    console.assert(((this.buffer.offset + fbeStructOffset + fbeStructSize) <= this.buffer.size), 'Model is broken!')
    if ((this.buffer.offset + fbeStructOffset + fbeStructSize) > this.buffer.size) {
      return 0
    }

    fbeStructSize = 8 + this._model.set(value)
    this.buffer.resize(fbeInitialSize + fbeStructSize)

    this.writeUInt32(this._model.fbeOffset - 8, fbeStructSize)
    this.writeUInt32(this._model.fbeOffset - 4, fbeStructType)

    return fbeStructSize
  }

  /**
   * Deserialize the struct value
   * @this {!AccountMessageFinalModel}
   * @param {!AccountMessage} value AccountMessage value, defaults is new AccountMessage()
   * @return {!object} Deserialized AccountMessage value and its size
   */
  deserialize (value = new AccountMessage()) {
    console.assert(((this.buffer.offset + this._model.fbeOffset) <= this.buffer.size), 'Model is broken!')
    if ((this.buffer.offset + this._model.fbeOffset) > this.buffer.size) {
      return { value: new AccountMessage(), size: 0 }
    }

    let fbeStructSize = this.readUInt32(this._model.fbeOffset - 8)
    let fbeStructType = this.readUInt32(this._model.fbeOffset - 4)
    console.assert(((fbeStructSize > 0) && (fbeStructType === this.fbeType)), 'Model is broken!')
    if ((fbeStructSize <= 0) || (fbeStructType !== this.fbeType)) {
      return { value: new AccountMessage(), size: 8 }
    }

    let fbeResult = this._model.get(value)
    return { value: fbeResult.value, size: (8 + fbeResult.size) }
  }

  /**
   * Move to the next struct value
   * @this {!AccountMessageFinalModel}
   * @param {!number} prev Previous AccountMessage model size
   */
  next (prev) {
    this._model.fbeShift(prev)
  }
}

exports.AccountMessageFinalModel = AccountMessageFinalModel

// Protocol major version
const ProtocolVersionMajor = 1
// Protocol minor version
const ProtocolVersionMinor = 0

exports.ProtocolVersionMajor = ProtocolVersionMajor
exports.ProtocolVersionMinor = ProtocolVersionMinor

/**
 * Fast Binary Encoding protoex sender
 */
class Sender extends fbe.Sender {
  /**
   * Initialize protoex sender with the given buffer
   * @param {!fbe.WriteBuffer} buffer Write buffer, defaults is new fbe.WriteBuffer()
   * @constructor
   */
  constructor (buffer = new fbe.WriteBuffer()) {
    super(buffer, false)
    this._protoSender = new proto.Sender(this.buffer)
    this._OrderMessageModel = new OrderMessageModel(this.buffer)
    this._BalanceMessageModel = new BalanceMessageModel(this.buffer)
    this._AccountMessageModel = new AccountMessageModel(this.buffer)
    this.onSendHandler = this.onSend
    this.onSendLogHandler = this.onSendLog
  }

  // Imported senders

  /**
   * Get imported proto sender
   * @this {!Sender}
   * @returns {!proto.Sender} proto sender
   */
  get protoSender () {
    return this._protoSender
  }

  // Sender models accessors

  /**
   * Get OrderMessage model
   * @this {!Sender}
   * @returns {!OrderMessageModel} OrderMessage model
   */
  get OrderMessageModel () {
    return this._OrderMessageModel
  }

  /**
   * Get BalanceMessage model
   * @this {!Sender}
   * @returns {!BalanceMessageModel} BalanceMessage model
   */
  get BalanceMessageModel () {
    return this._BalanceMessageModel
  }

  /**
   * Get AccountMessage model
   * @this {!Sender}
   * @returns {!AccountMessageModel} AccountMessage model
   */
  get AccountMessageModel () {
    return this._AccountMessageModel
  }

  // Send methods

  /**
   * Send value
   * @this {!Sender}
   * @param {!object} value Value to send
   * @returns {!number} Sent bytes
   */
  send (value) {
    if ((value instanceof OrderMessage) && (value.fbeType === this.OrderMessageModel.fbeType)) {
      return this.send_OrderMessage(value)
    }
    if ((value instanceof BalanceMessage) && (value.fbeType === this.BalanceMessageModel.fbeType)) {
      return this.send_BalanceMessage(value)
    }
    if ((value instanceof AccountMessage) && (value.fbeType === this.AccountMessageModel.fbeType)) {
      return this.send_AccountMessage(value)
    }
    let result = 0
    result = this._protoSender.send(value)
    if (result > 0) {
      return result
    }
    return 0
  }

  /**
   * Send OrderMessage value
   * @this {!Sender}
   * @param {!OrderMessage} value OrderMessage value to send
   * @returns {!number} Sent bytes
   */
  send_OrderMessage (value) { // eslint-disable-line
    // Serialize the value into the FBE stream
    let serialized = this.OrderMessageModel.serialize(value)
    console.assert((serialized > 0), 'protoex.OrderMessage serialization failed!')
    console.assert(this.OrderMessageModel.verify(), 'protoex.OrderMessage validation failed!')

    // Log the value
    if (this.logging) {
      this.onSendLog(value.toString())
    }

    // Send the serialized value
    return this.sendSerialized(serialized)
  }

  /**
   * Send BalanceMessage value
   * @this {!Sender}
   * @param {!BalanceMessage} value BalanceMessage value to send
   * @returns {!number} Sent bytes
   */
  send_BalanceMessage (value) { // eslint-disable-line
    // Serialize the value into the FBE stream
    let serialized = this.BalanceMessageModel.serialize(value)
    console.assert((serialized > 0), 'protoex.BalanceMessage serialization failed!')
    console.assert(this.BalanceMessageModel.verify(), 'protoex.BalanceMessage validation failed!')

    // Log the value
    if (this.logging) {
      this.onSendLog(value.toString())
    }

    // Send the serialized value
    return this.sendSerialized(serialized)
  }

  /**
   * Send AccountMessage value
   * @this {!Sender}
   * @param {!AccountMessage} value AccountMessage value to send
   * @returns {!number} Sent bytes
   */
  send_AccountMessage (value) { // eslint-disable-line
    // Serialize the value into the FBE stream
    let serialized = this.AccountMessageModel.serialize(value)
    console.assert((serialized > 0), 'protoex.AccountMessage serialization failed!')
    console.assert(this.AccountMessageModel.verify(), 'protoex.AccountMessage validation failed!')

    // Log the value
    if (this.logging) {
      this.onSendLog(value.toString())
    }

    // Send the serialized value
    return this.sendSerialized(serialized)
  }

  /**
   * Send message handler
   * @this {!Sender}
   * @param {!Uint8Array} buffer Buffer to send
   * @param {!number} offset Buffer offset
   * @param {!number} size Buffer size
   */
  onSend (buffer, offset, size) {
    console.assert(true, 'protoex.Sender.onSend() not implemented!')
    debugger // eslint-disable-line
    return 0
  }

  /**
   * Setup send message handler
   * @this {!Sender}
   * @param {!function} handler Send message handler
   */
  set onSendHandler (handler) { // eslint-disable-line
    this.onSend = handler
    this._protoSender.onSendHandler = handler
  }

  /**
   * Setup send log message handler
   * @this {!Sender}
   * @param {!function} handler Send log message handler
   */
  set onSendLogHandler (handler) { // eslint-disable-line
    this.onSendLog = handler
    this._protoSender.onSendLogHandler = handler
  }
}

exports.Sender = Sender

/**
 * Fast Binary Encoding protoex receiver
 */
class Receiver extends fbe.Receiver {
  /**
   * Initialize protoex receiver with the given buffer
   * @param {!fbe.WriteBuffer} buffer Write buffer, defaults is new WriteBuffer()
   * @constructor
   */
  constructor (buffer = new fbe.WriteBuffer()) {
    super(buffer, false)
    this._protoReceiver = new proto.Receiver(this.buffer)
    this._OrderMessageValue = new OrderMessage()
    this._OrderMessageModel = new OrderMessageModel()
    this._BalanceMessageValue = new BalanceMessage()
    this._BalanceMessageModel = new BalanceMessageModel()
    this._AccountMessageValue = new AccountMessage()
    this._AccountMessageModel = new AccountMessageModel()
    this.onReceiveLogHandler = this.onReceiveLog
  }

  // Imported receivers

  /**
   * Get imported proto receiver
   * @this {!Receiver}
   * @returns {Receiver} proto receiver
   */
  get protoReceiver () {
    return this._protoReceiver
  }

  /**
   * Set imported proto receiver
   * @this {!Receiver}
   * @param {Receiver} receiver proto receiver
   */
  set protoReceiver (receiver) {
    this._protoReceiver = receiver
  }

  // Receive handlers

  /**
   * OrderMessage receive handler
   * @this {!Receiver}
   * @param {!OrderMessage} value OrderMessage received value
   */
  onReceive_OrderMessage (value) {}  // eslint-disable-line

  /**
   * BalanceMessage receive handler
   * @this {!Receiver}
   * @param {!BalanceMessage} value BalanceMessage received value
   */
  onReceive_BalanceMessage (value) {}  // eslint-disable-line

  /**
   * AccountMessage receive handler
   * @this {!Receiver}
   * @param {!AccountMessage} value AccountMessage received value
   */
  onReceive_AccountMessage (value) {}  // eslint-disable-line

  /**
   * protoex receive message handler
   * @this {!Receiver}
   * @param {!number} type Message type
   * @param {!Uint8Array} buffer Buffer to send
   * @param {!number} offset Buffer offset
   * @param {!number} size Buffer size
   * @returns {!boolean} Success flag
   */
  onReceive (type, buffer, offset, size) {
    switch (type) {
      case OrderMessageModel.fbeType: {
        // Deserialize the value from the FBE stream
        this._OrderMessageModel.attachBuffer(buffer, offset)
        console.assert(this._OrderMessageModel.verify(), 'protoex.OrderMessage validation failed!')
        let deserialized = this._OrderMessageModel.deserialize(this._OrderMessageValue)
        console.assert((deserialized.size > 0), 'protoex.OrderMessage deserialization failed!')

        // Log the value
        if (this.logging) {
          this.onReceiveLog(this._OrderMessageValue.toString())
        }

        // Call receive handler with deserialized value
        this.onReceive_OrderMessage(this._OrderMessageValue)
        return true
      }
      case BalanceMessageModel.fbeType: {
        // Deserialize the value from the FBE stream
        this._BalanceMessageModel.attachBuffer(buffer, offset)
        console.assert(this._BalanceMessageModel.verify(), 'protoex.BalanceMessage validation failed!')
        let deserialized = this._BalanceMessageModel.deserialize(this._BalanceMessageValue)
        console.assert((deserialized.size > 0), 'protoex.BalanceMessage deserialization failed!')

        // Log the value
        if (this.logging) {
          this.onReceiveLog(this._BalanceMessageValue.toString())
        }

        // Call receive handler with deserialized value
        this.onReceive_BalanceMessage(this._BalanceMessageValue)
        return true
      }
      case AccountMessageModel.fbeType: {
        // Deserialize the value from the FBE stream
        this._AccountMessageModel.attachBuffer(buffer, offset)
        console.assert(this._AccountMessageModel.verify(), 'protoex.AccountMessage validation failed!')
        let deserialized = this._AccountMessageModel.deserialize(this._AccountMessageValue)
        console.assert((deserialized.size > 0), 'protoex.AccountMessage deserialization failed!')

        // Log the value
        if (this.logging) {
          this.onReceiveLog(this._AccountMessageValue.toString())
        }

        // Call receive handler with deserialized value
        this.onReceive_AccountMessage(this._AccountMessageValue)
        return true
      }
      default: break
    }

    // noinspection RedundantIfStatementJS
    if ((this.protoReceiver != null) && this.protoReceiver.onReceive(type, buffer, offset, size)) {
      return true
    }

    return false
  }

  /**
   * Setup receive log message handler
   * @this {!Receiver}
   * @param {!function} handler Receive log message handler
   */
  set onReceiveLogHandler (handler) { // eslint-disable-line
    this.onReceiveLog = handler
    this._protoReceiver.onReceiveLogHandler = handler
  }
}

exports.Receiver = Receiver

/**
 * Fast Binary Encoding protoex proxy
 */
class Proxy extends fbe.Receiver {
  /**
   * Initialize protoex proxy with the given buffer
   * @param {!fbe.WriteBuffer} buffer Write buffer, defaults is new WriteBuffer()
   * @constructor
   */
  constructor (buffer = new fbe.WriteBuffer()) {
    super(buffer, false)
    this._protoProxy = new proto.Proxy(this.buffer)
    this._OrderMessageModel = new OrderMessageModel()
    this._BalanceMessageModel = new BalanceMessageModel()
    this._AccountMessageModel = new AccountMessageModel()
  }

  // Imported proxy

  /**
   * Get imported proto proxy
   * @this {!Proxy}
   * @returns {Proxy} proto proxy
   */
  get protoProxy () {
    return this._protoProxy
  }

  /**
   * Set imported proto proxy
   * @this {!Proxy}
   * @param {Proxy} proxy proto proxy
   */
  set protoProxy (proxy) {
    this._protoProxy = proxy
  }

  // Proxy handlers

  /**
   * OrderMessage proxy handler
   * @this {!Proxy}
   * @param {!OrderMessage} model OrderMessage model
   * @param {!number} type Message type
   * @param {!Uint8Array} buffer Buffer to send
   * @param {!number} offset Buffer offset
   * @param {!number} size Buffer size
   */
  onProxy_OrderMessage (model, type, buffer, offset, size) {}  // eslint-disable-line

  /**
   * BalanceMessage proxy handler
   * @this {!Proxy}
   * @param {!BalanceMessage} model BalanceMessage model
   * @param {!number} type Message type
   * @param {!Uint8Array} buffer Buffer to send
   * @param {!number} offset Buffer offset
   * @param {!number} size Buffer size
   */
  onProxy_BalanceMessage (model, type, buffer, offset, size) {}  // eslint-disable-line

  /**
   * AccountMessage proxy handler
   * @this {!Proxy}
   * @param {!AccountMessage} model AccountMessage model
   * @param {!number} type Message type
   * @param {!Uint8Array} buffer Buffer to send
   * @param {!number} offset Buffer offset
   * @param {!number} size Buffer size
   */
  onProxy_AccountMessage (model, type, buffer, offset, size) {}  // eslint-disable-line

  /**
   * protoex receive message handler
   * @this {!Proxy}
   * @param {!number} type Message type
   * @param {!Uint8Array} buffer Buffer to send
   * @param {!number} offset Buffer offset
   * @param {!number} size Buffer size
   * @returns {!boolean} Success flag
   */
  onReceive (type, buffer, offset, size) {
    switch (type) {
      case OrderMessageModel.fbeType: {
        // Attach the FBE stream to the proxy model
        this._OrderMessageModel.attachBuffer(buffer, offset)
        console.assert(this._OrderMessageModel.verify(), 'protoex.OrderMessage validation failed!')

        let fbeBegin = this._OrderMessageModel.model.getBegin()
        if (fbeBegin === 0) {
          return false
        }
        // Call proxy handler
        this.onProxy_OrderMessage(this._OrderMessageModel, type, buffer, offset, size)
        this._OrderMessageModel.model.getEnd(fbeBegin)
        return true
      }
      case BalanceMessageModel.fbeType: {
        // Attach the FBE stream to the proxy model
        this._BalanceMessageModel.attachBuffer(buffer, offset)
        console.assert(this._BalanceMessageModel.verify(), 'protoex.BalanceMessage validation failed!')

        let fbeBegin = this._BalanceMessageModel.model.getBegin()
        if (fbeBegin === 0) {
          return false
        }
        // Call proxy handler
        this.onProxy_BalanceMessage(this._BalanceMessageModel, type, buffer, offset, size)
        this._BalanceMessageModel.model.getEnd(fbeBegin)
        return true
      }
      case AccountMessageModel.fbeType: {
        // Attach the FBE stream to the proxy model
        this._AccountMessageModel.attachBuffer(buffer, offset)
        console.assert(this._AccountMessageModel.verify(), 'protoex.AccountMessage validation failed!')

        let fbeBegin = this._AccountMessageModel.model.getBegin()
        if (fbeBegin === 0) {
          return false
        }
        // Call proxy handler
        this.onProxy_AccountMessage(this._AccountMessageModel, type, buffer, offset, size)
        this._AccountMessageModel.model.getEnd(fbeBegin)
        return true
      }
      default: break
    }

    // noinspection RedundantIfStatementJS
    if ((this.protoProxy != null) && this.protoProxy.onReceive(type, buffer, offset, size)) {
      return true
    }

    return false
  }
}

exports.Proxy = Proxy

/**
 * Fast Binary Encoding protoex client
 */
class Client extends fbe.Client {
  /**
   * Initialize protoex client with the given buffers
   * @param {!fbe.WriteBuffer} sendBuffer Send buffer, defaults is new fbe.WriteBuffer()
   * @param {!fbe.WriteBuffer} receiveBuffer Receive buffer, defaults is new fbe.WriteBuffer()
   * @constructor
   */
  constructor (sendBuffer = new fbe.WriteBuffer(), receiveBuffer = new fbe.WriteBuffer()) {
    super(sendBuffer, receiveBuffer, false)
    this._protoClient = new proto.Client(this.sendBuffer, this.receiveBuffer)
    this._OrderMessageSenderModel = new OrderMessageModel(this.sendBuffer)
    this._OrderMessageReceiverValue = new OrderMessage()
    this._OrderMessageReceiverModel = new OrderMessageModel()
    this._BalanceMessageSenderModel = new BalanceMessageModel(this.sendBuffer)
    this._BalanceMessageReceiverValue = new BalanceMessage()
    this._BalanceMessageReceiverModel = new BalanceMessageModel()
    this._AccountMessageSenderModel = new AccountMessageModel(this.sendBuffer)
    this._AccountMessageReceiverValue = new AccountMessage()
    this._AccountMessageReceiverModel = new AccountMessageModel()
    this.onSendHandler = this.onSend
    this.onSendLogHandler = this.onSendLog
    this.onReceiveLogHandler = this.onReceiveLog
    this._timestamp = 0
    this._requests_by_id = new Map()
    this._requests_by_timestamp = new Map()
  }

  // Imported clients

  /**
   * Get imported proto client
   * @this {!Client}
   * @returns {!proto.Client} proto client
   */
  get protoClient () {
    return this._protoClient
  }

  // Sender models accessors

  /**
   * Get OrderMessage model
   * @this {!Client}
   * @returns {!OrderMessageModel} OrderMessage sender model
   */
  get OrderMessageSenderModel () {
    return this._OrderMessageSenderModel
  }

  /**
   * Get BalanceMessage model
   * @this {!Client}
   * @returns {!BalanceMessageModel} BalanceMessage sender model
   */
  get BalanceMessageSenderModel () {
    return this._BalanceMessageSenderModel
  }

  /**
   * Get AccountMessage model
   * @this {!Client}
   * @returns {!AccountMessageModel} AccountMessage sender model
   */
  get AccountMessageSenderModel () {
    return this._AccountMessageSenderModel
  }

  // Reset and watchdog methods

  /**
   * Reset the client
   * @this {!Client}
   */
  reset () {
    super.reset()
    this.resetRequests()
  }

  /**
   * Watchdog for timeouts
   * @this {!Client}
   * @param {!number} utc UTC timestamp
   */
  watchdog (utc) {
    this.watchdogRequests(utc)
  }

  // Send methods

  /**
   * Send value
   * @this {!Client}
   * @param {!object} value Value to send
   * @returns {!number} Sent bytes
   */
  send (value) {
    if ((value instanceof OrderMessage) && (value.fbeType === this.OrderMessageSenderModel.fbeType)) {
      return this.send_OrderMessage(value)
    }
    if ((value instanceof BalanceMessage) && (value.fbeType === this.BalanceMessageSenderModel.fbeType)) {
      return this.send_BalanceMessage(value)
    }
    if ((value instanceof AccountMessage) && (value.fbeType === this.AccountMessageSenderModel.fbeType)) {
      return this.send_AccountMessage(value)
    }
    let result = 0
    result = this._protoClient.send(value)
    if (result > 0) {
      return result
    }
    return 0
  }

  /**
   * Send OrderMessage value
   * @this {!Client}
   * @param {!OrderMessage} value OrderMessage value to send
   * @returns {!number} Sent bytes
   */
  send_OrderMessage (value) { // eslint-disable-line
    // Serialize the value into the FBE stream
    let serialized = this.OrderMessageSenderModel.serialize(value)
    console.assert((serialized > 0), 'protoex.OrderMessage serialization failed!')
    console.assert(this.OrderMessageSenderModel.verify(), 'protoex.OrderMessage validation failed!')

    // Log the value
    if (this.logging) {
      this.onSendLog(value.toString())
    }

    // Send the serialized value
    return this.sendSerialized(serialized)
  }

  /**
   * Send BalanceMessage value
   * @this {!Client}
   * @param {!BalanceMessage} value BalanceMessage value to send
   * @returns {!number} Sent bytes
   */
  send_BalanceMessage (value) { // eslint-disable-line
    // Serialize the value into the FBE stream
    let serialized = this.BalanceMessageSenderModel.serialize(value)
    console.assert((serialized > 0), 'protoex.BalanceMessage serialization failed!')
    console.assert(this.BalanceMessageSenderModel.verify(), 'protoex.BalanceMessage validation failed!')

    // Log the value
    if (this.logging) {
      this.onSendLog(value.toString())
    }

    // Send the serialized value
    return this.sendSerialized(serialized)
  }

  /**
   * Send AccountMessage value
   * @this {!Client}
   * @param {!AccountMessage} value AccountMessage value to send
   * @returns {!number} Sent bytes
   */
  send_AccountMessage (value) { // eslint-disable-line
    // Serialize the value into the FBE stream
    let serialized = this.AccountMessageSenderModel.serialize(value)
    console.assert((serialized > 0), 'protoex.AccountMessage serialization failed!')
    console.assert(this.AccountMessageSenderModel.verify(), 'protoex.AccountMessage validation failed!')

    // Log the value
    if (this.logging) {
      this.onSendLog(value.toString())
    }

    // Send the serialized value
    return this.sendSerialized(serialized)
  }

  /**
   * Send message handler
   * @this {!Client}
   * @param {!Uint8Array} buffer Buffer to send
   * @param {!number} offset Buffer offset
   * @param {!number} size Buffer size
   */
  onSend (buffer, offset, size) {
    console.assert(true, 'protoex.Client.onSend() not implemented!')
    debugger // eslint-disable-line
    return 0
  }

  /**
   * Setup send message handler
   * @this {!Client}
   * @param {!function} handler Send message handler
   */
  set onSendHandler (handler) { // eslint-disable-line
    this.onSend = handler
    this._protoClient.onSendHandler = handler
  }

  /**
   * Setup send log message handler
   * @this {!Client}
   * @param {!function} handler Send log message handler
   */
  set onSendLogHandler (handler) { // eslint-disable-line
    this.onSendLog = handler
    this._protoClient.onSendLogHandler = handler
  }

  // Receive handlers

  /**
   * OrderMessage receive handler
   * @this {!Client}
   * @param {!OrderMessage} value OrderMessage received value
   */
  onReceive_OrderMessage (value) {}  // eslint-disable-line

  /**
   * BalanceMessage receive handler
   * @this {!Client}
   * @param {!BalanceMessage} value BalanceMessage received value
   */
  onReceive_BalanceMessage (value) {}  // eslint-disable-line

  /**
   * AccountMessage receive handler
   * @this {!Client}
   * @param {!AccountMessage} value AccountMessage received value
   */
  onReceive_AccountMessage (value) {}  // eslint-disable-line

  /**
   * protoex receive message handler
   * @this {!Client}
   * @param {!number} type Message type
   * @param {!Uint8Array} buffer Buffer to send
   * @param {!number} offset Buffer offset
   * @param {!number} size Buffer size
   * @returns {!boolean} Success flag
   */
  onReceive (type, buffer, offset, size) {
    switch (type) {
      case OrderMessageModel.fbeType: {
        // Deserialize the value from the FBE stream
        this._OrderMessageReceiverModel.attachBuffer(buffer, offset)
        console.assert(this._OrderMessageReceiverModel.verify(), 'protoex.OrderMessage validation failed!')
        let deserialized = this._OrderMessageReceiverModel.deserialize(this._OrderMessageReceiverValue)
        console.assert((deserialized.size > 0), 'protoex.OrderMessage deserialization failed!')

        // Log the value
        if (this.logging) {
          this.onReceiveLog(this._OrderMessageReceiverValue.toString())
        }

        // Call receive handler with deserialized value
        this.onReceive_OrderMessage(this._OrderMessageReceiverValue)
        return true
      }
      case BalanceMessageModel.fbeType: {
        // Deserialize the value from the FBE stream
        this._BalanceMessageReceiverModel.attachBuffer(buffer, offset)
        console.assert(this._BalanceMessageReceiverModel.verify(), 'protoex.BalanceMessage validation failed!')
        let deserialized = this._BalanceMessageReceiverModel.deserialize(this._BalanceMessageReceiverValue)
        console.assert((deserialized.size > 0), 'protoex.BalanceMessage deserialization failed!')

        // Log the value
        if (this.logging) {
          this.onReceiveLog(this._BalanceMessageReceiverValue.toString())
        }

        // Call receive handler with deserialized value
        this.onReceive_BalanceMessage(this._BalanceMessageReceiverValue)
        return true
      }
      case AccountMessageModel.fbeType: {
        // Deserialize the value from the FBE stream
        this._AccountMessageReceiverModel.attachBuffer(buffer, offset)
        console.assert(this._AccountMessageReceiverModel.verify(), 'protoex.AccountMessage validation failed!')
        let deserialized = this._AccountMessageReceiverModel.deserialize(this._AccountMessageReceiverValue)
        console.assert((deserialized.size > 0), 'protoex.AccountMessage deserialization failed!')

        // Log the value
        if (this.logging) {
          this.onReceiveLog(this._AccountMessageReceiverValue.toString())
        }

        // Call receive handler with deserialized value
        this.onReceive_AccountMessage(this._AccountMessageReceiverValue)
        return true
      }
      default: break
    }

    // noinspection RedundantIfStatementJS
    if ((this.protoClient != null) && this.protoClient.onReceive(type, buffer, offset, size)) {
      return true
    }

    return false
  }

  /**
   * Setup receive log message handler
   * @this {!Client}
   * @param {!function} handler Receive log message handler
   */
  set onReceiveLogHandler (handler) { // eslint-disable-line
    this.onReceiveLog = handler
    this._protoClient.onReceiveLogHandler = handler
  }

  // Request methods

  /**
   * Request value
   * @this {!Client}
   * @param {!object} value Value to request
   * @param {!number} timeout Timeout in milliseconds (default is 0)
   * @returns {Promise} Response promise
   */
  request (value, timeout = 0) {
    let promise = new fbe.DeferredPromise()
    let current = Date.now()

    // Send the request message
    let serialized = this.send(value)
    if (serialized > 0) {
      // Calculate the unique timestamp
      this._timestamp = (current <= this._timestamp) ? this._timestamp + 1 : current

      // Register the request
      this._requests_by_id.set(value.id, [this._timestamp, timeout, promise])
      if (timeout > 0) {
        this._requests_by_timestamp.set(this._timestamp, value.id)
      }
    } else {
      promise.reject(new Error('Send request failed!'))
    }

    return promise
  }

  /**
   * Response value
   * @this {!Client}
   * @param {!object} value Value to response
   * @returns {!boolean} Response handle flag
   */
  response (value) {
    let item = this._requests_by_id.get(value.id)
    if (item != null) {
      let timestamp = item[0]
      let promise = item[2]
      promise.resolve(value)
      this._requests_by_id.delete(value.id)
      this._requests_by_timestamp.delete(timestamp)
      return true
    }

    // noinspection RedundantIfStatementJS
    if (this._protoClient.response(value)) {
      return true
    }

    return false
  }

  /**
   * Reject value
   * @this {!Client}
   * @param {!object} value Value to reject
   * @returns {!boolean} Reject handle flag
   */
  reject (value) {
    let item = this._requests_by_id.get(value.id)
    if (item != null) {
      let timestamp = item[0]
      let promise = item[2]
      promise.reject(value)
      this._requests_by_id.delete(value.id)
      this._requests_by_timestamp.delete(timestamp)
      return true
    }

    // noinspection RedundantIfStatementJS
    if (this._protoClient.reject(value)) {
      return true
    }

    return false
  }

  /**
   * Reset client requests
   * @this {!Client}
   */
  resetRequests () {
    this._protoClient.resetRequests()

    for (let [, value] of this._requests_by_id) {
      value[2].reject(new Error('Reset client!'))
    }
    this._requests_by_id.clear()
    this._requests_by_timestamp.clear()
  }

  /**
   * Watchdog client requests for timeouts
   * @this {!Client}
   * @param {!number} utc UTC timestamp in milliseconds
   */
  watchdogRequests (utc) {
    this._protoClient.watchdogRequests(utc)

    for (let [, value] of this._requests_by_timestamp) {
      let item = this._requests_by_id.get(value)
      let id = value
      let timestamp = item[0]
      let timespan = item[1]
      if ((timestamp + timespan) <= utc) {
        let promise = item[2]
        promise.reject(new Error('Timeout!'))
        this._requests_by_id.delete(id)
        this._requests_by_timestamp.delete(timestamp)
      }
    }
  }
}

exports.Client = Client

/**
 * Fast Binary Encoding protoex final sender
 */
class FinalSender extends fbe.Sender {
  /**
   * Initialize protoex sender with the given buffer
   * @param {!fbe.WriteBuffer} buffer Write buffer, defaults is new fbe.WriteBuffer()
   * @constructor
   */
  constructor (buffer = new fbe.WriteBuffer()) {
    super(buffer, true)
    this._protoSender = new proto.FinalSender(this.buffer)
    this._OrderMessageModel = new OrderMessageFinalModel(this.buffer)
    this._BalanceMessageModel = new BalanceMessageFinalModel(this.buffer)
    this._AccountMessageModel = new AccountMessageFinalModel(this.buffer)
    this.onSendHandler = this.onSend
    this.onSendLogHandler = this.onSendLog
  }

  // Imported senders

  /**
   * Get imported proto sender
   * @this {!FinalSender}
   * @returns {!proto.FinalSender} proto sender
   */
  get protoSender () {
    return this._protoSender
  }

  // Sender models accessors

  /**
   * Get OrderMessage model
   * @this {!FinalSender}
   * @returns {!OrderMessageModel} OrderMessage model
   */
  get OrderMessageModel () {
    return this._OrderMessageModel
  }

  /**
   * Get BalanceMessage model
   * @this {!FinalSender}
   * @returns {!BalanceMessageModel} BalanceMessage model
   */
  get BalanceMessageModel () {
    return this._BalanceMessageModel
  }

  /**
   * Get AccountMessage model
   * @this {!FinalSender}
   * @returns {!AccountMessageModel} AccountMessage model
   */
  get AccountMessageModel () {
    return this._AccountMessageModel
  }

  // Send methods

  /**
   * Send value
   * @this {!FinalSender}
   * @param {!object} value Value to send
   * @returns {!number} Sent bytes
   */
  send (value) {
    if ((value instanceof OrderMessage) && (value.fbeType === this.OrderMessageModel.fbeType)) {
      return this.send_OrderMessage(value)
    }
    if ((value instanceof BalanceMessage) && (value.fbeType === this.BalanceMessageModel.fbeType)) {
      return this.send_BalanceMessage(value)
    }
    if ((value instanceof AccountMessage) && (value.fbeType === this.AccountMessageModel.fbeType)) {
      return this.send_AccountMessage(value)
    }
    let result = 0
    result = this._protoSender.send(value)
    if (result > 0) {
      return result
    }
    return 0
  }

  /**
   * Send OrderMessage value
   * @this {!FinalSender}
   * @param {!OrderMessage} value OrderMessage value to send
   * @returns {!number} Sent bytes
   */
  send_OrderMessage (value) { // eslint-disable-line
    // Serialize the value into the FBE stream
    let serialized = this.OrderMessageModel.serialize(value)
    console.assert((serialized > 0), 'protoex.OrderMessage serialization failed!')
    console.assert(this.OrderMessageModel.verify(), 'protoex.OrderMessage validation failed!')

    // Log the value
    if (this.logging) {
      this.onSendLog(value.toString())
    }

    // Send the serialized value
    return this.sendSerialized(serialized)
  }

  /**
   * Send BalanceMessage value
   * @this {!FinalSender}
   * @param {!BalanceMessage} value BalanceMessage value to send
   * @returns {!number} Sent bytes
   */
  send_BalanceMessage (value) { // eslint-disable-line
    // Serialize the value into the FBE stream
    let serialized = this.BalanceMessageModel.serialize(value)
    console.assert((serialized > 0), 'protoex.BalanceMessage serialization failed!')
    console.assert(this.BalanceMessageModel.verify(), 'protoex.BalanceMessage validation failed!')

    // Log the value
    if (this.logging) {
      this.onSendLog(value.toString())
    }

    // Send the serialized value
    return this.sendSerialized(serialized)
  }

  /**
   * Send AccountMessage value
   * @this {!FinalSender}
   * @param {!AccountMessage} value AccountMessage value to send
   * @returns {!number} Sent bytes
   */
  send_AccountMessage (value) { // eslint-disable-line
    // Serialize the value into the FBE stream
    let serialized = this.AccountMessageModel.serialize(value)
    console.assert((serialized > 0), 'protoex.AccountMessage serialization failed!')
    console.assert(this.AccountMessageModel.verify(), 'protoex.AccountMessage validation failed!')

    // Log the value
    if (this.logging) {
      this.onSendLog(value.toString())
    }

    // Send the serialized value
    return this.sendSerialized(serialized)
  }

  /**
   * Send message handler
   * @this {!FinalSender}
   * @param {!Uint8Array} buffer Buffer to send
   * @param {!number} offset Buffer offset
   * @param {!number} size Buffer size
   */
  onSend (buffer, offset, size) {
    console.assert(true, 'protoex.Sender.onSend() not implemented!')
    debugger // eslint-disable-line
    return 0
  }

  /**
   * Setup send message handler
   * @this {!FinalSender}
   * @param {!function} handler Send message handler
   */
  set onSendHandler (handler) { // eslint-disable-line
    this.onSend = handler
    this._protoSender.onSendHandler = handler
  }

  /**
   * Setup send log message handler
   * @this {!FinalSender}
   * @param {!function} handler Send log message handler
   */
  set onSendLogHandler (handler) { // eslint-disable-line
    this.onSendLog = handler
    this._protoSender.onSendLogHandler = handler
  }
}

exports.FinalSender = FinalSender

/**
 * Fast Binary Encoding protoex final receiver
 */
class FinalReceiver extends fbe.Receiver {
  /**
   * Initialize protoex receiver with the given buffer
   * @param {!fbe.WriteBuffer} buffer Write buffer, defaults is new WriteBuffer()
   * @constructor
   */
  constructor (buffer = new fbe.WriteBuffer()) {
    super(buffer, true)
    this._protoReceiver = new proto.FinalReceiver(this.buffer)
    this._OrderMessageValue = new OrderMessage()
    this._OrderMessageModel = new OrderMessageFinalModel()
    this._BalanceMessageValue = new BalanceMessage()
    this._BalanceMessageModel = new BalanceMessageFinalModel()
    this._AccountMessageValue = new AccountMessage()
    this._AccountMessageModel = new AccountMessageFinalModel()
    this.onReceiveLogHandler = this.onReceiveLog
  }

  // Imported receivers

  /**
   * Get imported proto receiver
   * @this {!FinalReceiver}
   * @returns {FinalReceiver} proto receiver
   */
  get protoReceiver () {
    return this._protoReceiver
  }

  /**
   * Set imported proto receiver
   * @this {!FinalReceiver}
   * @param {FinalReceiver} receiver proto receiver
   */
  set protoReceiver (receiver) {
    this._protoReceiver = receiver
  }

  // Receive handlers

  /**
   * OrderMessage receive handler
   * @this {!FinalReceiver}
   * @param {!OrderMessage} value OrderMessage received value
   */
  onReceive_OrderMessage (value) {}  // eslint-disable-line

  /**
   * BalanceMessage receive handler
   * @this {!FinalReceiver}
   * @param {!BalanceMessage} value BalanceMessage received value
   */
  onReceive_BalanceMessage (value) {}  // eslint-disable-line

  /**
   * AccountMessage receive handler
   * @this {!FinalReceiver}
   * @param {!AccountMessage} value AccountMessage received value
   */
  onReceive_AccountMessage (value) {}  // eslint-disable-line

  /**
   * protoex receive message handler
   * @this {!FinalReceiver}
   * @param {!number} type Message type
   * @param {!Uint8Array} buffer Buffer to send
   * @param {!number} offset Buffer offset
   * @param {!number} size Buffer size
   * @returns {!boolean} Success flag
   */
  onReceive (type, buffer, offset, size) {
    switch (type) {
      case OrderMessageFinalModel.fbeType: {
        // Deserialize the value from the FBE stream
        this._OrderMessageModel.attachBuffer(buffer, offset)
        console.assert(this._OrderMessageModel.verify(), 'protoex.OrderMessage validation failed!')
        let deserialized = this._OrderMessageModel.deserialize(this._OrderMessageValue)
        console.assert((deserialized.size > 0), 'protoex.OrderMessage deserialization failed!')

        // Log the value
        if (this.logging) {
          this.onReceiveLog(this._OrderMessageValue.toString())
        }

        // Call receive handler with deserialized value
        this.onReceive_OrderMessage(this._OrderMessageValue)
        return true
      }
      case BalanceMessageFinalModel.fbeType: {
        // Deserialize the value from the FBE stream
        this._BalanceMessageModel.attachBuffer(buffer, offset)
        console.assert(this._BalanceMessageModel.verify(), 'protoex.BalanceMessage validation failed!')
        let deserialized = this._BalanceMessageModel.deserialize(this._BalanceMessageValue)
        console.assert((deserialized.size > 0), 'protoex.BalanceMessage deserialization failed!')

        // Log the value
        if (this.logging) {
          this.onReceiveLog(this._BalanceMessageValue.toString())
        }

        // Call receive handler with deserialized value
        this.onReceive_BalanceMessage(this._BalanceMessageValue)
        return true
      }
      case AccountMessageFinalModel.fbeType: {
        // Deserialize the value from the FBE stream
        this._AccountMessageModel.attachBuffer(buffer, offset)
        console.assert(this._AccountMessageModel.verify(), 'protoex.AccountMessage validation failed!')
        let deserialized = this._AccountMessageModel.deserialize(this._AccountMessageValue)
        console.assert((deserialized.size > 0), 'protoex.AccountMessage deserialization failed!')

        // Log the value
        if (this.logging) {
          this.onReceiveLog(this._AccountMessageValue.toString())
        }

        // Call receive handler with deserialized value
        this.onReceive_AccountMessage(this._AccountMessageValue)
        return true
      }
      default: break
    }

    // noinspection RedundantIfStatementJS
    if ((this.protoReceiver != null) && this.protoReceiver.onReceive(type, buffer, offset, size)) {
      return true
    }

    return false
  }

  /**
   * Setup receive log message handler
   * @this {!FinalReceiver}
   * @param {!function} handler Receive log message handler
   */
  set onReceiveLogHandler (handler) { // eslint-disable-line
    this.onReceiveLog = handler
    this._protoReceiver.onReceiveLogHandler = handler
  }
}

exports.FinalReceiver = FinalReceiver

/**
 * Fast Binary Encoding protoex final client
 */
class FinalClient extends fbe.Client {
  /**
   * Initialize protoex client with the given buffers
   * @param {!fbe.WriteBuffer} sendBuffer Send buffer, defaults is new fbe.WriteBuffer()
   * @param {!fbe.WriteBuffer} receiveBuffer Receive buffer, defaults is new fbe.WriteBuffer()
   * @constructor
   */
  constructor (sendBuffer = new fbe.WriteBuffer(), receiveBuffer = new fbe.WriteBuffer()) {
    super(sendBuffer, receiveBuffer, true)
    this._protoClient = new proto.FinalClient(this.sendBuffer, this.receiveBuffer)
    this._OrderMessageSenderModel = new OrderMessageFinalModel(this.sendBuffer)
    this._OrderMessageReceiverValue = new OrderMessage()
    this._OrderMessageReceiverModel = new OrderMessageFinalModel()
    this._BalanceMessageSenderModel = new BalanceMessageFinalModel(this.sendBuffer)
    this._BalanceMessageReceiverValue = new BalanceMessage()
    this._BalanceMessageReceiverModel = new BalanceMessageFinalModel()
    this._AccountMessageSenderModel = new AccountMessageFinalModel(this.sendBuffer)
    this._AccountMessageReceiverValue = new AccountMessage()
    this._AccountMessageReceiverModel = new AccountMessageFinalModel()
    this.onSendHandler = this.onSend
    this.onSendLogHandler = this.onSendLog
    this.onReceiveLogHandler = this.onReceiveLog
    this._timestamp = 0
    this._requests_by_id = new Map()
    this._requests_by_timestamp = new Map()
  }

  // Imported clients

  /**
   * Get imported proto client
   * @this {!FinalClient}
   * @returns {!proto.FinalClient} proto client
   */
  get protoClient () {
    return this._protoClient
  }

  // Sender models accessors

  /**
   * Get OrderMessage model
   * @this {!FinalClient}
   * @returns {!OrderMessageModel} OrderMessage sender model
   */
  get OrderMessageSenderModel () {
    return this._OrderMessageSenderModel
  }

  /**
   * Get BalanceMessage model
   * @this {!FinalClient}
   * @returns {!BalanceMessageModel} BalanceMessage sender model
   */
  get BalanceMessageSenderModel () {
    return this._BalanceMessageSenderModel
  }

  /**
   * Get AccountMessage model
   * @this {!FinalClient}
   * @returns {!AccountMessageModel} AccountMessage sender model
   */
  get AccountMessageSenderModel () {
    return this._AccountMessageSenderModel
  }

  // Reset and watchdog methods

  /**
   * Reset the client
   * @this {!FinalClient}
   */
  reset () {
    super.reset()
    this.resetRequests()
  }

  /**
   * Watchdog for timeouts
   * @this {!FinalClient}
   * @param {!number} utc UTC timestamp
   */
  watchdog (utc) {
    this.watchdogRequests(utc)
  }

  // Send methods

  /**
   * Send value
   * @this {!FinalClient}
   * @param {!object} value Value to send
   * @returns {!number} Sent bytes
   */
  send (value) {
    if ((value instanceof OrderMessage) && (value.fbeType === this.OrderMessageSenderModel.fbeType)) {
      return this.send_OrderMessage(value)
    }
    if ((value instanceof BalanceMessage) && (value.fbeType === this.BalanceMessageSenderModel.fbeType)) {
      return this.send_BalanceMessage(value)
    }
    if ((value instanceof AccountMessage) && (value.fbeType === this.AccountMessageSenderModel.fbeType)) {
      return this.send_AccountMessage(value)
    }
    let result = 0
    result = this._protoClient.send(value)
    if (result > 0) {
      return result
    }
    return 0
  }

  /**
   * Send OrderMessage value
   * @this {!FinalClient}
   * @param {!OrderMessage} value OrderMessage value to send
   * @returns {!number} Sent bytes
   */
  send_OrderMessage (value) { // eslint-disable-line
    // Serialize the value into the FBE stream
    let serialized = this.OrderMessageSenderModel.serialize(value)
    console.assert((serialized > 0), 'protoex.OrderMessage serialization failed!')
    console.assert(this.OrderMessageSenderModel.verify(), 'protoex.OrderMessage validation failed!')

    // Log the value
    if (this.logging) {
      this.onSendLog(value.toString())
    }

    // Send the serialized value
    return this.sendSerialized(serialized)
  }

  /**
   * Send BalanceMessage value
   * @this {!FinalClient}
   * @param {!BalanceMessage} value BalanceMessage value to send
   * @returns {!number} Sent bytes
   */
  send_BalanceMessage (value) { // eslint-disable-line
    // Serialize the value into the FBE stream
    let serialized = this.BalanceMessageSenderModel.serialize(value)
    console.assert((serialized > 0), 'protoex.BalanceMessage serialization failed!')
    console.assert(this.BalanceMessageSenderModel.verify(), 'protoex.BalanceMessage validation failed!')

    // Log the value
    if (this.logging) {
      this.onSendLog(value.toString())
    }

    // Send the serialized value
    return this.sendSerialized(serialized)
  }

  /**
   * Send AccountMessage value
   * @this {!FinalClient}
   * @param {!AccountMessage} value AccountMessage value to send
   * @returns {!number} Sent bytes
   */
  send_AccountMessage (value) { // eslint-disable-line
    // Serialize the value into the FBE stream
    let serialized = this.AccountMessageSenderModel.serialize(value)
    console.assert((serialized > 0), 'protoex.AccountMessage serialization failed!')
    console.assert(this.AccountMessageSenderModel.verify(), 'protoex.AccountMessage validation failed!')

    // Log the value
    if (this.logging) {
      this.onSendLog(value.toString())
    }

    // Send the serialized value
    return this.sendSerialized(serialized)
  }

  /**
   * Send message handler
   * @this {!FinalClient}
   * @param {!Uint8Array} buffer Buffer to send
   * @param {!number} offset Buffer offset
   * @param {!number} size Buffer size
   */
  onSend (buffer, offset, size) {
    console.assert(true, 'protoex.Client.onSend() not implemented!')
    debugger // eslint-disable-line
    return 0
  }

  /**
   * Setup send message handler
   * @this {!FinalClient}
   * @param {!function} handler Send message handler
   */
  set onSendHandler (handler) { // eslint-disable-line
    this.onSend = handler
    this._protoClient.onSendHandler = handler
  }

  /**
   * Setup send log message handler
   * @this {!FinalClient}
   * @param {!function} handler Send log message handler
   */
  set onSendLogHandler (handler) { // eslint-disable-line
    this.onSendLog = handler
    this._protoClient.onSendLogHandler = handler
  }

  // Receive handlers

  /**
   * OrderMessage receive handler
   * @this {!FinalClient}
   * @param {!OrderMessage} value OrderMessage received value
   */
  onReceive_OrderMessage (value) {}  // eslint-disable-line

  /**
   * BalanceMessage receive handler
   * @this {!FinalClient}
   * @param {!BalanceMessage} value BalanceMessage received value
   */
  onReceive_BalanceMessage (value) {}  // eslint-disable-line

  /**
   * AccountMessage receive handler
   * @this {!FinalClient}
   * @param {!AccountMessage} value AccountMessage received value
   */
  onReceive_AccountMessage (value) {}  // eslint-disable-line

  /**
   * protoex receive message handler
   * @this {!FinalClient}
   * @param {!number} type Message type
   * @param {!Uint8Array} buffer Buffer to send
   * @param {!number} offset Buffer offset
   * @param {!number} size Buffer size
   * @returns {!boolean} Success flag
   */
  onReceive (type, buffer, offset, size) {
    switch (type) {
      case OrderMessageFinalModel.fbeType: {
        // Deserialize the value from the FBE stream
        this._OrderMessageReceiverModel.attachBuffer(buffer, offset)
        console.assert(this._OrderMessageReceiverModel.verify(), 'protoex.OrderMessage validation failed!')
        let deserialized = this._OrderMessageReceiverModel.deserialize(this._OrderMessageReceiverValue)
        console.assert((deserialized.size > 0), 'protoex.OrderMessage deserialization failed!')

        // Log the value
        if (this.logging) {
          this.onReceiveLog(this._OrderMessageReceiverValue.toString())
        }

        // Call receive handler with deserialized value
        this.onReceive_OrderMessage(this._OrderMessageReceiverValue)
        return true
      }
      case BalanceMessageFinalModel.fbeType: {
        // Deserialize the value from the FBE stream
        this._BalanceMessageReceiverModel.attachBuffer(buffer, offset)
        console.assert(this._BalanceMessageReceiverModel.verify(), 'protoex.BalanceMessage validation failed!')
        let deserialized = this._BalanceMessageReceiverModel.deserialize(this._BalanceMessageReceiverValue)
        console.assert((deserialized.size > 0), 'protoex.BalanceMessage deserialization failed!')

        // Log the value
        if (this.logging) {
          this.onReceiveLog(this._BalanceMessageReceiverValue.toString())
        }

        // Call receive handler with deserialized value
        this.onReceive_BalanceMessage(this._BalanceMessageReceiverValue)
        return true
      }
      case AccountMessageFinalModel.fbeType: {
        // Deserialize the value from the FBE stream
        this._AccountMessageReceiverModel.attachBuffer(buffer, offset)
        console.assert(this._AccountMessageReceiverModel.verify(), 'protoex.AccountMessage validation failed!')
        let deserialized = this._AccountMessageReceiverModel.deserialize(this._AccountMessageReceiverValue)
        console.assert((deserialized.size > 0), 'protoex.AccountMessage deserialization failed!')

        // Log the value
        if (this.logging) {
          this.onReceiveLog(this._AccountMessageReceiverValue.toString())
        }

        // Call receive handler with deserialized value
        this.onReceive_AccountMessage(this._AccountMessageReceiverValue)
        return true
      }
      default: break
    }

    // noinspection RedundantIfStatementJS
    if ((this.protoClient != null) && this.protoClient.onReceive(type, buffer, offset, size)) {
      return true
    }

    return false
  }

  /**
   * Setup receive log message handler
   * @this {!FinalClient}
   * @param {!function} handler Receive log message handler
   */
  set onReceiveLogHandler (handler) { // eslint-disable-line
    this.onReceiveLog = handler
    this._protoClient.onReceiveLogHandler = handler
  }

  // Request methods

  /**
   * Request value
   * @this {!FinalClient}
   * @param {!object} value Value to request
   * @param {!number} timeout Timeout in milliseconds (default is 0)
   * @returns {Promise} Response promise
   */
  request (value, timeout = 0) {
    let promise = new fbe.DeferredPromise()
    let current = Date.now()

    // Send the request message
    let serialized = this.send(value)
    if (serialized > 0) {
      // Calculate the unique timestamp
      this._timestamp = (current <= this._timestamp) ? this._timestamp + 1 : current

      // Register the request
      this._requests_by_id.set(value.id, [this._timestamp, timeout, promise])
      if (timeout > 0) {
        this._requests_by_timestamp.set(this._timestamp, value.id)
      }
    } else {
      promise.reject(new Error('Send request failed!'))
    }

    return promise
  }

  /**
   * Response value
   * @this {!FinalClient}
   * @param {!object} value Value to response
   * @returns {!boolean} Response handle flag
   */
  response (value) {
    let item = this._requests_by_id.get(value.id)
    if (item != null) {
      let timestamp = item[0]
      let promise = item[2]
      promise.resolve(value)
      this._requests_by_id.delete(value.id)
      this._requests_by_timestamp.delete(timestamp)
      return true
    }

    // noinspection RedundantIfStatementJS
    if (this._protoClient.response(value)) {
      return true
    }

    return false
  }

  /**
   * Reject value
   * @this {!FinalClient}
   * @param {!object} value Value to reject
   * @returns {!boolean} Reject handle flag
   */
  reject (value) {
    let item = this._requests_by_id.get(value.id)
    if (item != null) {
      let timestamp = item[0]
      let promise = item[2]
      promise.reject(value)
      this._requests_by_id.delete(value.id)
      this._requests_by_timestamp.delete(timestamp)
      return true
    }

    // noinspection RedundantIfStatementJS
    if (this._protoClient.reject(value)) {
      return true
    }

    return false
  }

  /**
   * Reset client requests
   * @this {!FinalClient}
   */
  resetRequests () {
    this._protoClient.resetRequests()

    for (let [, value] of this._requests_by_id) {
      value[2].reject(new Error('Reset client!'))
    }
    this._requests_by_id.clear()
    this._requests_by_timestamp.clear()
  }

  /**
   * Watchdog client requests for timeouts
   * @this {!FinalClient}
   * @param {!number} utc UTC timestamp in milliseconds
   */
  watchdogRequests (utc) {
    this._protoClient.watchdogRequests(utc)

    for (let [, value] of this._requests_by_timestamp) {
      let item = this._requests_by_id.get(value)
      let id = value
      let timestamp = item[0]
      let timespan = item[1]
      if ((timestamp + timespan) <= utc) {
        let promise = item[2]
        promise.reject(new Error('Timeout!'))
        this._requests_by_id.delete(id)
        this._requests_by_timestamp.delete(timestamp)
      }
    }
  }
}

exports.FinalClient = FinalClient
