//------------------------------------------------------------------------------
// <auto-generated>
//     Automatically generated by the Fast Binary Encoding compiler, do not modify!
//     https://github.com/chronoxor/FastBinaryEncoding
//     Source: FBE
//     FBE version: 1.14.5.0
//
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Globalization;
using System.IO;
using System.Linq;
using System.Numerics;
using System.Runtime.Serialization;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
#if UTF8JSON
using Utf8Json;
using Utf8Json.Resolvers;
#elif NEWTONSOFTJSON
using Newtonsoft.Json;
#else
using System.Text.Json;
using System.Text.Json.Serialization;
#endif

namespace com.chronoxor.FBE {

    // Fast Binary Encoding UUID generator
    public static class UuidGenerator
    {
        // Gregorian epoch
        private static readonly DateTime GregorianEpoch = new DateTime(1582, 10, 15, 0, 0, 0, DateTimeKind.Utc);

        // Lock and random generator
        private static readonly object Lock = new object();
        private static readonly Random Generator = new Random();

        // Node & clock sequence bytes
        private static readonly byte[] NodeBytes;
        private static readonly byte[] ClockSequenceBytes;

        // Last UUID generated timestamp
        private static DateTime _last = DateTime.UtcNow;

        static UuidGenerator()
        {
            NodeBytes = new byte[6];
            Generator.NextBytes(NodeBytes);

            ClockSequenceBytes = new byte[2];
            Generator.NextBytes(ClockSequenceBytes);
        }

        // Generate nil UUID0 (all bits set to zero)
        public static Guid Nil() { return new Guid(); }

        // Generate sequential UUID1 (time based version)
        public static Guid Sequential()
        {
            var now = DateTime.UtcNow;

            // Generate new clock sequence bytes to get rid of UUID duplicates
            lock (Lock)
            {
                if (now <= _last)
                    Generator.NextBytes(ClockSequenceBytes);
                _last = now;
            }

            long ticks = (now - GregorianEpoch).Ticks;
            Span<byte> guid = stackalloc byte[16];
            byte[] timestamp = BitConverter.GetBytes(ticks);

            // Copy node
            for (int i = 0; i < Math.Min(6, NodeBytes.Length); i++)
                guid[10 + i] = NodeBytes[i];

            // Copy clock sequence
            for (int i = 0; i < Math.Min(2, ClockSequenceBytes.Length); i++)
                guid[8 + i] = ClockSequenceBytes[i];

            // Copy timestamp
            for (int i = 0; i < Math.Min(8, timestamp.Length); i++)
                guid[i] = timestamp[i];

            // Set the variant
            guid[8] &= 0x3F;
            guid[8] |= 0x80;

            // Set the version
            guid[7] &= 0x0F;
            guid[7] |= 0x10;

            return new Guid(guid);
        }

        // Generate random UUID4 (randomly or pseudo-randomly generated version)
        public static Guid Random() { return Guid.NewGuid(); }
    }

    // Fast Binary Encoding dynamic bytes buffer
    public class Buffer
    {
        private byte[] _data;
        private long _size;
        private long _offset;

        // Is the buffer empty?
        public bool IsEmpty => (_data == null) || (_size == 0);
        // Bytes memory buffer
        public byte[] Data => _data;
        // Bytes memory buffer capacity
        public long Capacity => _data.Length;
        // Bytes memory buffer size
        public long Size => _size;
        // Bytes memory buffer offset
        public long Offset => _offset;

        // Initialize a new expandable buffer with zero capacity
        public Buffer() { Attach(); }
        // Initialize a new expandable buffer with the given capacity
        public Buffer(long capacity) { Attach(capacity); }
        // Initialize a new buffer based on the specified byte array
        public Buffer(byte[] buffer) { Attach(buffer); }
        // Initialize a new buffer based on the specified region (offset) of a byte array
        public Buffer(byte[] buffer, long offset) { Attach(buffer, offset); }
        // Initialize a new buffer based on the specified region (size and offset) of a byte array
        public Buffer(byte[] buffer, long size, long offset) { Attach(buffer, size, offset); }

        #region Attach memory buffer methods

        public void Attach() { _data = new byte[0]; _size = 0; _offset = 0; }
        public void Attach(long capacity) { _data = new byte[capacity]; _size = 0; _offset = 0; }
        public void Attach(byte[] buffer) { _data = buffer; _size = buffer.Length; _offset = 0; }
        public void Attach(byte[] buffer, long offset) { _data = buffer; _size = buffer.Length; _offset = offset; }
        public void Attach(byte[] buffer, long size, long offset) { _data = buffer; _size = size; _offset = offset; }

        #endregion

        #region Memory buffer methods

        // Allocate memory in the current buffer and return offset to the allocated memory block
        public long Allocate(long size)
        {
            Debug.Assert((size >= 0), "Invalid allocation size!");
            if (size < 0)
                throw new ArgumentException("Invalid allocation size!", nameof(size));

            long offset = Size;

            // Calculate a new buffer size
            long total = _size + size;

            if (total <= Capacity)
            {
                _size = total;
                return offset;
            }

            byte[] data = new byte[Math.Max(total, 2 * Capacity)];
            Array.Copy(_data, 0, data, 0, _size);
            _data = data;
            _size = total;
            return offset;
        }

        // Remove some memory of the given size from the current buffer
        public void Remove(long offset, long size)
        {
            Debug.Assert(((offset + size) <= Size), "Invalid offset & size!");
            if ((offset + size) > Size)
                throw new ArgumentException("Invalid offset & size!", nameof(offset));

            Array.Copy(_data, offset + size, _data, offset, _size - size - offset);
            _size -= size;
            if (_offset >= (offset + size))
                _offset -= size;
            else if (_offset >= offset)
            {
                _offset -= _offset - offset;
                if (_offset > Size)
                    _offset = Size;
            }
        }

        // Reserve memory of the given capacity in the current buffer
        public void Reserve(long capacity)
        {
            Debug.Assert((capacity >= 0), "Invalid reserve capacity!");
            if (capacity < 0)
                throw new ArgumentException("Invalid reserve capacity!", nameof(capacity));

            if (capacity > Capacity)
            {
                byte[] data = new byte[Math.Max(capacity, 2 * Capacity)];
                Array.Copy(_data, 0, data, 0, _size);
                _data = data;
            }
        }

        // Resize the current buffer
        public void Resize(long size)
        {
            Reserve(size);
            _size = size;
            if (_offset > _size)
                _offset = _size;
        }

        // Reset the current buffer and its offset
        public void Reset()
        {
            _size = 0;
            _offset = 0;
        }

        // Shift the current buffer offset
        public void Shift(long offset) { _offset += offset; }
        // Unshift the current buffer offset
        public void Unshift(long offset) { _offset -= offset; }

        #endregion

        #region Buffer I/O methods

        public static bool ReadBool(byte[] buffer, long offset)
        {
            return buffer[offset] != 0;
        }

        public static byte ReadByte(byte[] buffer, long offset)
        {
            return buffer[offset];
        }

        public static char ReadChar(byte[] buffer, long offset)
        {
            return (char)ReadUInt8(buffer, offset);
        }

        public static char ReadWChar(byte[] buffer, long offset)
        {
            return (char)ReadUInt32(buffer, offset);
        }

        public static sbyte ReadInt8(byte[] buffer, long offset)
        {
            return (sbyte)buffer[offset];
        }

        public static byte ReadUInt8(byte[] buffer, long offset)
        {
            return buffer[offset];
        }

        public static short ReadInt16(byte[] buffer, long offset)
        {
            return (short)(buffer[offset + 0] | (buffer[offset + 1] << 8));
        }

        public static ushort ReadUInt16(byte[] buffer, long offset)
        {
            return (ushort)(buffer[offset + 0] | (buffer[offset + 1] << 8));
        }

        public static int ReadInt32(byte[] buffer, long offset)
        {
            return (buffer[offset + 0] <<  0)|
                   (buffer[offset + 1] <<  8)|
                   (buffer[offset + 2] << 16)|
                   (buffer[offset + 3] << 24);
        }

        public static uint ReadUInt32(byte[] buffer, long offset)
        {
            return ((uint)buffer[offset + 0] <<  0)|
                   ((uint)buffer[offset + 1] <<  8)|
                   ((uint)buffer[offset + 2] << 16)|
                   ((uint)buffer[offset + 3] << 24);
        }

        public static long ReadInt64(byte[] buffer, long offset)
        {
            return ((long)buffer[offset + 0] <<  0)|
                   ((long)buffer[offset + 1] <<  8)|
                   ((long)buffer[offset + 2] << 16)|
                   ((long)buffer[offset + 3] << 24)|
                   ((long)buffer[offset + 4] << 32)|
                   ((long)buffer[offset + 5] << 40)|
                   ((long)buffer[offset + 6] << 48)|
                   ((long)buffer[offset + 7] << 56);
        }

        public static ulong ReadUInt64(byte[] buffer, long offset)
        {
            return ((ulong)buffer[offset + 0] <<  0)|
                   ((ulong)buffer[offset + 1] <<  8)|
                   ((ulong)buffer[offset + 2] << 16)|
                   ((ulong)buffer[offset + 3] << 24)|
                   ((ulong)buffer[offset + 4] << 32)|
                   ((ulong)buffer[offset + 5] << 40)|
                   ((ulong)buffer[offset + 6] << 48)|
                   ((ulong)buffer[offset + 7] << 56);
        }

        public static ulong ReadUInt64Guid(byte[] buffer, long offset)
        {
            return ((ulong)buffer[offset + 0] << 24)|
                   ((ulong)buffer[offset + 1] << 16)|
                   ((ulong)buffer[offset + 2] <<  8)|
                   ((ulong)buffer[offset + 3] <<  0)|
                   ((ulong)buffer[offset + 4] << 40)|
                   ((ulong)buffer[offset + 5] << 32)|
                   ((ulong)buffer[offset + 6] << 56)|
                   ((ulong)buffer[offset + 7] << 48);
        }

        public static float ReadFloat(byte[] buffer, long offset)
        {
            var bits = default(FloatUnion);
            bits.UIntData = ReadUInt32(buffer, offset);
            return bits.FloatData;
        }

        public static double ReadDouble(byte[] buffer, long offset)
        {
            var bits = default(DoubleUnion);
            bits.ULongData = ReadUInt64(buffer, offset);
            return bits.DoubleData;
        }

        public static decimal ReadDecimal(byte[] buffer, long offset)
        {
            var bits = default(DecimalUnion);
            bits.UIntLow = ReadUInt32(buffer, offset);
            bits.UIntMid = ReadUInt32(buffer, offset + 4);
            bits.UIntHigh = ReadUInt32(buffer, offset + 8);
            bits.UIntFlags = ReadUInt32(buffer, offset + 12);
            return bits.DecimalData;
        }

        public static byte[] ReadBytes(byte[] buffer, long offset, long size)
        {
            byte[] result = new byte[size];
            Array.Copy(buffer, offset, result, 0, (int)size);
            return result;
        }

        public static string ReadString(byte[] buffer, long offset, long size)
        {
            return Encoding.UTF8.GetString(buffer, (int)offset, (int)size);
        }

        public static Guid ReadUUID(byte[] buffer, long offset)
        {
            var bits = default(GuidUnion);
            bits.ULongHigh = ReadUInt64Guid(buffer, offset);
            bits.ULongLow = ReadUInt64(buffer, offset + 8);
            return bits.GuidData;
        }

        public static void Write(byte[] buffer, long offset, bool value)
        {
            buffer[offset] = (byte)(value ? 1 : 0);
        }

        public static void Write(byte[] buffer, long offset, sbyte value)
        {
            buffer[offset] = (byte)value;
        }

        public static void Write(byte[] buffer, long offset, byte value)
        {
            buffer[offset] = value;
        }

        public static void Write(byte[] buffer, long offset, short value)
        {
            buffer[offset + 0] = (byte)(value >>  0);
            buffer[offset + 1] = (byte)(value >>  8);
        }

        public static void Write(byte[] buffer, long offset, ushort value)
        {
            buffer[offset + 0] = (byte)(value >>  0);
            buffer[offset + 1] = (byte)(value >>  8);
        }

        public static void Write(byte[] buffer, long offset, int value)
        {
            buffer[offset + 0] = (byte)(value >>  0);
            buffer[offset + 1] = (byte)(value >>  8);
            buffer[offset + 2] = (byte)(value >> 16);
            buffer[offset + 3] = (byte)(value >> 24);
        }

        public static void Write(byte[] buffer, long offset, uint value)
        {
            buffer[offset + 0] = (byte)(value >>  0);
            buffer[offset + 1] = (byte)(value >>  8);
            buffer[offset + 2] = (byte)(value >> 16);
            buffer[offset + 3] = (byte)(value >> 24);
        }

        public static void Write(byte[] buffer, long offset, long value)
        {
            buffer[offset + 0] = (byte)(value >>  0);
            buffer[offset + 1] = (byte)(value >>  8);
            buffer[offset + 2] = (byte)(value >> 16);
            buffer[offset + 3] = (byte)(value >> 24);
            buffer[offset + 4] = (byte)(value >> 32);
            buffer[offset + 5] = (byte)(value >> 40);
            buffer[offset + 6] = (byte)(value >> 48);
            buffer[offset + 7] = (byte)(value >> 56);
        }

        public static void Write(byte[] buffer, long offset, ulong value)
        {
            buffer[offset + 0] = (byte)(value >>  0);
            buffer[offset + 1] = (byte)(value >>  8);
            buffer[offset + 2] = (byte)(value >> 16);
            buffer[offset + 3] = (byte)(value >> 24);
            buffer[offset + 4] = (byte)(value >> 32);
            buffer[offset + 5] = (byte)(value >> 40);
            buffer[offset + 6] = (byte)(value >> 48);
            buffer[offset + 7] = (byte)(value >> 56);
        }

        public static void WriteGuid(byte[] buffer, long offset, ulong value)
        {
            buffer[offset + 0] = (byte)(value >> 24);
            buffer[offset + 1] = (byte)(value >> 16);
            buffer[offset + 2] = (byte)(value >>  8);
            buffer[offset + 3] = (byte)(value >>  0);
            buffer[offset + 4] = (byte)(value >> 40);
            buffer[offset + 5] = (byte)(value >> 32);
            buffer[offset + 6] = (byte)(value >> 56);
            buffer[offset + 7] = (byte)(value >> 48);
        }

        public static void Write(byte[] buffer, long offset, float value)
        {
            var bits = default(FloatUnion);
            bits.FloatData = value;
            Write(buffer, offset, bits.UIntData);
        }

        public static void Write(byte[] buffer, long offset, double value)
        {
            var bits = default(DoubleUnion);
            bits.DoubleData = value;
            Write(buffer, offset, bits.ULongData);
        }

        public static void Write(byte[] buffer, long offset, decimal value)
        {
            var bits = default(DecimalUnion);
            bits.DecimalData = value;
            Write(buffer, offset, bits.UIntLow);
            Write(buffer, offset + 4, bits.UIntMid);
            Write(buffer, offset + 8, bits.UIntHigh);
            Write(buffer, offset + 12, bits.UIntFlags);
        }

        public static void Write(byte[] buffer, long offset, byte[] value)
        {
            Array.Copy(value, 0, buffer, offset, value.Length);
        }

        public static void Write(byte[] buffer, long offset, byte[] value, long valueOffset, long valueSize)
        {
            Array.Copy(value, valueOffset, buffer, offset, valueSize);
        }

        public static void Write(byte[] buffer, long offset, byte value, long valueCount)
        {
            for (long i = 0; i < valueCount; i++)
                buffer[offset + i] = value;
        }

        public static long Write(byte[] buffer, long offset, string value)
        {
            return Encoding.UTF8.GetBytes(value, 0, value.Length, buffer, (int)offset);
        }

        public static void Write(byte[] buffer, long offset, Guid value)
        {
            var bits = default(GuidUnion);
            bits.GuidData = value;
            WriteGuid(buffer, offset, bits.ULongHigh);
            Write(buffer, offset + 8, bits.ULongLow);
        }

        #endregion

        #region Utilities

        [System.Runtime.InteropServices.StructLayout(System.Runtime.InteropServices.LayoutKind.Explicit)]
        private struct FloatUnion
        {
            [System.Runtime.InteropServices.FieldOffset(0)]
            public uint UIntData;
            [System.Runtime.InteropServices.FieldOffset(0)]
            public float FloatData;
        }

        [System.Runtime.InteropServices.StructLayout(System.Runtime.InteropServices.LayoutKind.Explicit)]
        private struct DoubleUnion
        {
            [System.Runtime.InteropServices.FieldOffset(0)]
            public ulong ULongData;
            [System.Runtime.InteropServices.FieldOffset(0)]
            public double DoubleData;
        }

        [System.Runtime.InteropServices.StructLayout(System.Runtime.InteropServices.LayoutKind.Explicit)]
        private struct DecimalUnion
        {
            [System.Runtime.InteropServices.FieldOffset(0)]
            public uint UIntFlags;
            [System.Runtime.InteropServices.FieldOffset(4)]
            public uint UIntHigh;
            [System.Runtime.InteropServices.FieldOffset(8)]
            public uint UIntLow;
            [System.Runtime.InteropServices.FieldOffset(12)]
            public uint UIntMid;
            [System.Runtime.InteropServices.FieldOffset(0)]
            public decimal DecimalData;
        }

        [System.Runtime.InteropServices.StructLayout(System.Runtime.InteropServices.LayoutKind.Explicit)]
        private struct GuidUnion
        {
            [System.Runtime.InteropServices.FieldOffset(0)]
            public ulong ULongHigh;
            [System.Runtime.InteropServices.FieldOffset(8)]
            public ulong ULongLow;
            [System.Runtime.InteropServices.FieldOffset(0)]
            public Guid GuidData;
        }

        #endregion
    }

    // Fast Binary Encoding base model
    public class Model
    {
        // Bytes buffer
        public Buffer Buffer { get; }

        protected Model() { Buffer = new Buffer(); }
        protected Model(Buffer buffer) { Buffer = buffer; }

        #region Attach memory buffer methods

        public void Attach() { Buffer.Attach(); }
        public void Attach(long capacity) { Buffer.Attach(capacity); }
        public void Attach(byte[] buffer) { Buffer.Attach(buffer); }
        public void Attach(byte[] buffer, long offset) { Buffer.Attach(buffer, offset); }
        public void Attach(byte[] buffer, long size, long offset) { Buffer.Attach(buffer, size, offset); }
        public void Attach(Buffer buffer) { Buffer.Attach(buffer.Data, buffer.Size, buffer.Offset); }
        public void Attach(Buffer buffer, long offset) { Buffer.Attach(buffer.Data, buffer.Size, offset); }

        #endregion

        #region Memory buffer methods

        public long Allocate(long size) { return Buffer.Allocate(size); }
        public void Remove(long offset, long size) { Buffer.Remove(offset, size); }
        public void Reserve(long capacity) { Buffer.Reserve(capacity); }
        public void Resize(long size) { Buffer.Resize(size); }
        public void Reset() { Buffer.Reset(); }
        public void Shift(long offset) { Buffer.Shift(offset); }
        public void Unshift(long offset) { Buffer.Unshift(offset); }

        #endregion

        #region Buffer I/O methods

        protected uint ReadUInt32(long offset) { return Buffer.ReadUInt32(Buffer.Data, Buffer.Offset + offset); }
        protected void Write(long offset, uint value) { Buffer.Write(Buffer.Data, Buffer.Offset + offset, value); }

        #endregion
    }

    // Fast Binary Encoding base types enumeration
    public enum BaseTypes
    {
        BOOL,
        BYTE,
        BYTES,
        CHAR,
        WCHAR,
        INT8,
        UINT8,
        INT16,
        UINT16,
        INT32,
        UINT32,
        INT64,
        UINT64,
        FLOAT,
        DOUBLE,
        DECIMAL,
        UUID,
        STRING,
        TIMESTAMP
    }

    // Fast Binary Encoding base field model
    public abstract class FieldModelBase
    {
        protected Buffer _buffer;
        protected long _offset;

        protected FieldModelBase(Buffer buffer, long offset)
        {
            _buffer = buffer;
            _offset = offset;
        }

        // Get the field offset
        public long FBEOffset { get => _offset; set => _offset = value; }
        // Get the field size
        public virtual long FBESize => 0;
        // Get the field extra size
        public virtual long FBEExtra => 0;

        // Shift the current field offset
        public void FBEShift(long size) { _offset += size; }
        // Unshift the current field offset
        public void FBEUnshift(long size) { _offset -= size; }

        #region Buffer I/O methods

        protected bool ReadBool(long offset) { return Buffer.ReadBool(_buffer.Data, _buffer.Offset + offset); }
        protected byte ReadByte(long offset) { return Buffer.ReadByte(_buffer.Data, _buffer.Offset + offset); }
        protected char ReadChar(long offset) { return Buffer.ReadChar(_buffer.Data, _buffer.Offset + offset); }
        protected char ReadWChar(long offset) { return Buffer.ReadWChar(_buffer.Data, _buffer.Offset + offset); }
        protected sbyte ReadInt8(long offset) { return Buffer.ReadInt8(_buffer.Data, _buffer.Offset + offset); }
        protected byte ReadUInt8(long offset) { return Buffer.ReadUInt8(_buffer.Data, _buffer.Offset + offset); }
        protected short ReadInt16(long offset) { return Buffer.ReadInt16(_buffer.Data, _buffer.Offset + offset); }
        protected ushort ReadUInt16(long offset) { return Buffer.ReadUInt16(_buffer.Data, _buffer.Offset + offset); }
        protected int ReadInt32(long offset) { return Buffer.ReadInt32(_buffer.Data, _buffer.Offset + offset); }
        protected uint ReadUInt32(long offset) { return Buffer.ReadUInt32(_buffer.Data, _buffer.Offset + offset); }
        protected long ReadInt64(long offset) { return Buffer.ReadInt64(_buffer.Data, _buffer.Offset + offset); }
        protected ulong ReadUInt64(long offset) { return Buffer.ReadUInt64(_buffer.Data, _buffer.Offset + offset); }
        protected float ReadFloat(long offset) { return Buffer.ReadFloat(_buffer.Data, _buffer.Offset + offset); }
        protected double ReadDouble(long offset) { return Buffer.ReadDouble(_buffer.Data, _buffer.Offset + offset); }
        protected decimal ReadDecimal(long offset) { return Buffer.ReadDecimal(_buffer.Data, _buffer.Offset + offset); }
        protected byte[] ReadBytes(long offset, long size) { return Buffer.ReadBytes(_buffer.Data, _buffer.Offset + offset, size); }
        protected string ReadString(long offset, long size) { return Buffer.ReadString(_buffer.Data, _buffer.Offset + offset, size); }
        protected Guid ReadUUID(long offset) { return Buffer.ReadUUID(_buffer.Data, _buffer.Offset + offset); }
        protected void Write(long offset, bool value) { Buffer.Write(_buffer.Data, _buffer.Offset + offset, value); }
        protected void Write(long offset, sbyte value) { Buffer.Write(_buffer.Data, _buffer.Offset + offset, value); }
        protected void Write(long offset, byte value) { Buffer.Write(_buffer.Data, _buffer.Offset + offset, value); }
        protected void Write(long offset, short value) { Buffer.Write(_buffer.Data, _buffer.Offset + offset, value); }
        protected void Write(long offset, ushort value) { Buffer.Write(_buffer.Data, _buffer.Offset + offset, value); }
        protected void Write(long offset, int value) { Buffer.Write(_buffer.Data, _buffer.Offset + offset, value); }
        protected void Write(long offset, uint value) { Buffer.Write(_buffer.Data, _buffer.Offset + offset, value); }
        protected void Write(long offset, long value) { Buffer.Write(_buffer.Data, _buffer.Offset + offset, value); }
        protected void Write(long offset, ulong value) { Buffer.Write(_buffer.Data, _buffer.Offset + offset, value); }
        protected void Write(long offset, float value) { Buffer.Write(_buffer.Data, _buffer.Offset + offset, value); }
        protected void Write(long offset, double value) { Buffer.Write(_buffer.Data, _buffer.Offset + offset, value); }
        protected void Write(long offset, decimal value) { Buffer.Write(_buffer.Data, _buffer.Offset + offset, value); }
        protected void Write(long offset, byte[] value) { Buffer.Write(_buffer.Data, _buffer.Offset + offset, value); }
        protected void Write(long offset, byte[] value, long valueOffset, long valueSize) { Buffer.Write(_buffer.Data, _buffer.Offset + offset, value, valueOffset, valueSize); }
        protected void Write(long offset, byte value, long valueCount) { Buffer.Write(_buffer.Data, _buffer.Offset + offset, value, valueCount); }
        protected long Write(long offset, string value) { return Buffer.Write(_buffer.Data, _buffer.Offset + offset, value); }
        protected void Write(long offset, Guid value) { Buffer.Write(_buffer.Data, _buffer.Offset + offset, value); }

        #endregion
    }

    // Fast Binary Encoding field model value type
    public abstract class FieldModelValueType<T> : FieldModelBase
        where T : struct
    {
        protected FieldModelValueType(Buffer buffer, long offset) : base(buffer, offset) {}

        // Clone the field model
        public abstract FieldModelValueType<T> Clone();

        // Check if the value is valid
        public virtual bool Verify() { return true; }

        // Get the value
        public abstract void Get(out T value);
        public abstract void Get(out T value, T defaults);

        // Set the value
        public abstract void Set(T value);

        // Create field model of the given type
        public static FieldModelValueType<T> CreateFieldModel(BaseTypes type, Buffer buffer, long offset)
        {
            switch (type)
            {
                case BaseTypes.BOOL:
                    return new FieldModelBool(buffer, offset) as FieldModelValueType<T>;
                case BaseTypes.BYTE:
                    return new FieldModelByte(buffer, offset) as FieldModelValueType<T>;
                case BaseTypes.CHAR:
                    return new FieldModelChar(buffer, offset) as FieldModelValueType<T>;
                case BaseTypes.WCHAR:
                    return new FieldModelWChar(buffer, offset) as FieldModelValueType<T>;
                case BaseTypes.INT8:
                    return new FieldModelInt8(buffer, offset) as FieldModelValueType<T>;
                case BaseTypes.UINT8:
                    return new FieldModelUInt8(buffer, offset) as FieldModelValueType<T>;
                case BaseTypes.INT16:
                    return new FieldModelInt16(buffer, offset) as FieldModelValueType<T>;
                case BaseTypes.UINT16:
                    return new FieldModelUInt16(buffer, offset) as FieldModelValueType<T>;
                case BaseTypes.INT32:
                    return new FieldModelInt32(buffer, offset) as FieldModelValueType<T>;
                case BaseTypes.UINT32:
                    return new FieldModelUInt32(buffer, offset) as FieldModelValueType<T>;
                case BaseTypes.INT64:
                    return new FieldModelInt64(buffer, offset) as FieldModelValueType<T>;
                case BaseTypes.UINT64:
                    return new FieldModelUInt64(buffer, offset) as FieldModelValueType<T>;
                case BaseTypes.FLOAT:
                    return new FieldModelFloat(buffer, offset) as FieldModelValueType<T>;
                case BaseTypes.DOUBLE:
                    return new FieldModelDouble(buffer, offset) as FieldModelValueType<T>;
                case BaseTypes.DECIMAL:
                    return new FieldModelDecimal(buffer, offset) as FieldModelValueType<T>;
                case BaseTypes.UUID:
                    return new FieldModelUUID(buffer, offset) as FieldModelValueType<T>;
                case BaseTypes.TIMESTAMP:
                    return new FieldModelTimestamp(buffer, offset) as FieldModelValueType<T>;
                default:
                    Debug.Assert(false, "Unknown type!");
                    return null;
            }
        }
    }

    // Fast Binary Encoding field model reference type
    public abstract class FieldModelReferenceType<T> : FieldModelBase
        where T : class
    {
        protected FieldModelReferenceType(Buffer buffer, long offset) : base(buffer, offset) {}

        // Clone the field model
        public abstract FieldModelReferenceType<T> Clone();

        // Check if the value is valid
        public virtual bool Verify() { return true; }

        // Get the value
        public abstract void Get(out T value);
        public abstract void Get(out T value, T defaults);

        // Set the value
        public abstract void Set(T value);

        // Create field model of the given type
        public static FieldModelReferenceType<T> CreateFieldModel(BaseTypes type, Buffer buffer, long offset)
        {
            switch (type)
            {
                case BaseTypes.BYTES:
                    return new FieldModelBytes(buffer, offset) as FieldModelReferenceType<T>;
                case BaseTypes.STRING:
                    return new FieldModelString(buffer, offset) as FieldModelReferenceType<T>;
                default:
                    Debug.Assert(false, "Unknown type!");
                    return null;
            }
        }
    }

    // Fast Binary Encoding bool field model
    public class FieldModelBool : FieldModelValueType<bool>
    {
        public FieldModelBool(Buffer buffer, long offset) : base(buffer, offset) {}

        // Get the field size
        public override long FBESize => 1;

        // Clone the field model
        public override FieldModelValueType<bool> Clone() { return new FieldModelBool(_buffer, _offset); }

        // Get the value
        public override void Get(out bool value) { Get(out value, false); }
        public override void Get(out bool value, bool defaults)
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
            {
                value = defaults;
                return;
            }

            value = ReadBool(FBEOffset);
        }

        // Set the value
        public override void Set(bool value)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            Write(FBEOffset, value);
        }
    }

    // Fast Binary Encoding byte field model
    public class FieldModelByte : FieldModelValueType<byte>
    {
        public FieldModelByte(Buffer buffer, long offset) : base(buffer, offset) {}

        // Get the field size
        public override long FBESize => 1;

        // Clone the field model
        public override FieldModelValueType<byte> Clone() { return new FieldModelByte(_buffer, _offset); }

        // Get the value
        public override void Get(out byte value) { Get(out value, (byte)0); }
        public override void Get(out byte value, byte defaults)
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
            {
                value = defaults;
                return;
            }

            value = ReadByte(FBEOffset);
        }

        // Set the value
        public override void Set(byte value)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            Write(FBEOffset, value);
        }
    }

    // Fast Binary Encoding char field model
    public class FieldModelChar : FieldModelValueType<char>
    {
        public FieldModelChar(Buffer buffer, long offset) : base(buffer, offset) {}

        // Get the field size
        public override long FBESize => 1;

        // Clone the field model
        public override FieldModelValueType<char> Clone() { return new FieldModelChar(_buffer, _offset); }

        // Get the value
        public override void Get(out char value) { Get(out value, '\0'); }
        public override void Get(out char value, char defaults)
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
            {
                value = defaults;
                return;
            }

            value = ReadChar(FBEOffset);
        }

        // Set the value
        public override void Set(char value)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            Write(FBEOffset, (byte)value);
        }
    }

    // Fast Binary Encoding char field model
    public class FieldModelWChar : FieldModelValueType<char>
    {
        public FieldModelWChar(Buffer buffer, long offset) : base(buffer, offset) {}

        // Get the field size
        public override long FBESize => 4;

        // Clone the field model
        public override FieldModelValueType<char> Clone() { return new FieldModelWChar(_buffer, _offset); }

        // Get the value
        public override void Get(out char value) { Get(out value, '\0'); }
        public override void Get(out char value, char defaults)
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
            {
                value = defaults;
                return;
            }

            value = ReadWChar(FBEOffset);
        }

        // Set the value
        public override void Set(char value)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            Write(FBEOffset, (uint)value);
        }
    }

    // Fast Binary Encoding sbyte field model
    public class FieldModelInt8 : FieldModelValueType<sbyte>
    {
        public FieldModelInt8(Buffer buffer, long offset) : base(buffer, offset) {}

        // Get the field size
        public override long FBESize => 1;

        // Clone the field model
        public override FieldModelValueType<sbyte> Clone() { return new FieldModelInt8(_buffer, _offset); }

        // Get the value
        public override void Get(out sbyte value) { Get(out value, 0); }
        public override void Get(out sbyte value, sbyte defaults)
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
            {
                value = defaults;
                return;
            }

            value = ReadInt8(FBEOffset);
        }

        // Set the value
        public override void Set(sbyte value)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            Write(FBEOffset, value);
        }
    }

    // Fast Binary Encoding byte field model
    public class FieldModelUInt8 : FieldModelValueType<byte>
    {
        public FieldModelUInt8(Buffer buffer, long offset) : base(buffer, offset) {}

        // Get the field size
        public override long FBESize => 1;

        // Clone the field model
        public override FieldModelValueType<byte> Clone() { return new FieldModelUInt8(_buffer, _offset); }

        // Get the value
        public override void Get(out byte value) { Get(out value, (byte)0); }
        public override void Get(out byte value, byte defaults)
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
            {
                value = defaults;
                return;
            }

            value = ReadUInt8(FBEOffset);
        }

        // Set the value
        public override void Set(byte value)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            Write(FBEOffset, value);
        }
    }

    // Fast Binary Encoding short field model
    public class FieldModelInt16 : FieldModelValueType<short>
    {
        public FieldModelInt16(Buffer buffer, long offset) : base(buffer, offset) {}

        // Get the field size
        public override long FBESize => 2;

        // Clone the field model
        public override FieldModelValueType<short> Clone() { return new FieldModelInt16(_buffer, _offset); }

        // Get the value
        public override void Get(out short value) { Get(out value, 0); }
        public override void Get(out short value, short defaults)
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
            {
                value = defaults;
                return;
            }

            value = ReadInt16(FBEOffset);
        }

        // Set the value
        public override void Set(short value)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            Write(FBEOffset, value);
        }
    }

    // Fast Binary Encoding ushort field model
    public class FieldModelUInt16 : FieldModelValueType<ushort>
    {
        public FieldModelUInt16(Buffer buffer, long offset) : base(buffer, offset) {}

        // Get the field size
        public override long FBESize => 2;

        // Clone the field model
        public override FieldModelValueType<ushort> Clone() { return new FieldModelUInt16(_buffer, _offset); }

        // Get the value
        public override void Get(out ushort value) { Get(out value, (ushort)0); }
        public override void Get(out ushort value, ushort defaults)
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
            {
                value = defaults;
                return;
            }

            value = ReadUInt16(FBEOffset);
        }

        // Set the value
        public override void Set(ushort value)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            Write(FBEOffset, value);
        }
    }

    // Fast Binary Encoding int field model
    public class FieldModelInt32 : FieldModelValueType<int>
    {
        public FieldModelInt32(Buffer buffer, long offset) : base(buffer, offset) {}

        // Get the field size
        public override long FBESize => 4;

        // Clone the field model
        public override FieldModelValueType<int> Clone() { return new FieldModelInt32(_buffer, _offset); }

        // Get the value
        public override void Get(out int value) { Get(out value, 0); }
        public override void Get(out int value, int defaults)
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
            {
                value = defaults;
                return;
            }

            value = ReadInt32(FBEOffset);
        }

        // Set the value
        public override void Set(int value)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            Write(FBEOffset, value);
        }
    }

    // Fast Binary Encoding uint field model
    public class FieldModelUInt32 : FieldModelValueType<uint>
    {
        public FieldModelUInt32(Buffer buffer, long offset) : base(buffer, offset) {}

        // Get the field size
        public override long FBESize => 4;

        // Clone the field model
        public override FieldModelValueType<uint> Clone() { return new FieldModelUInt32(_buffer, _offset); }

        // Get the value
        public override void Get(out uint value) { Get(out value, 0U); }
        public override void Get(out uint value, uint defaults)
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
            {
                value = defaults;
                return;
            }

            value = ReadUInt32(FBEOffset);
        }

        // Set the value
        public override void Set(uint value)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            Write(FBEOffset, value);
        }
    }

    // Fast Binary Encoding long field model
    public class FieldModelInt64 : FieldModelValueType<long>
    {
        public FieldModelInt64(Buffer buffer, long offset) : base(buffer, offset) {}

        // Get the field size
        public override long FBESize => 8;

        // Clone the field model
        public override FieldModelValueType<long> Clone() { return new FieldModelInt64(_buffer, _offset); }

        // Get the value
        public override void Get(out long value) { Get(out value, 0L); }
        public override void Get(out long value, long defaults)
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
            {
                value = defaults;
                return;
            }

            value = ReadInt64(FBEOffset);
        }

        // Set the value
        public override void Set(long value)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            Write(FBEOffset, value);
        }
    }

    // Fast Binary Encoding ulong field model
    public class FieldModelUInt64 : FieldModelValueType<ulong>
    {
        public FieldModelUInt64(Buffer buffer, long offset) : base(buffer, offset) {}

        // Get the field size
        public override long FBESize => 8;

        // Clone the field model
        public override FieldModelValueType<ulong> Clone() { return new FieldModelUInt64(_buffer, _offset); }

        // Get the value
        public override void Get(out ulong value) { Get(out value, 0UL); }
        public override void Get(out ulong value, ulong defaults)
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
            {
                value = defaults;
                return;
            }

            value = ReadUInt64(FBEOffset);
        }

        // Set the value
        public override void Set(ulong value)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            Write(FBEOffset, value);
        }
    }

    // Fast Binary Encoding float field model
    public class FieldModelFloat : FieldModelValueType<float>
    {
        public FieldModelFloat(Buffer buffer, long offset) : base(buffer, offset) {}

        // Get the field size
        public override long FBESize => 4;

        // Clone the field model
        public override FieldModelValueType<float> Clone() { return new FieldModelFloat(_buffer, _offset); }

        // Get the value
        public override void Get(out float value) { Get(out value, 0.0F); }
        public override void Get(out float value, float defaults)
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
            {
                value = defaults;
                return;
            }

            value = ReadFloat(FBEOffset);
        }

        // Set the value
        public override void Set(float value)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            Write(FBEOffset, value);
        }
    }

    // Fast Binary Encoding double field model
    public class FieldModelDouble : FieldModelValueType<double>
    {
        public FieldModelDouble(Buffer buffer, long offset) : base(buffer, offset) {}

        // Get the field size
        public override long FBESize => 8;

        // Clone the field model
        public override FieldModelValueType<double> Clone() { return new FieldModelDouble(_buffer, _offset); }

        // Get the value
        public override void Get(out double value) { Get(out value, 0.0D); }
        public override void Get(out double value, double defaults)
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
            {
                value = defaults;
                return;
            }

            value = ReadDouble(FBEOffset);
        }

        // Set the value
        public override void Set(double value)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            Write(FBEOffset, value);
        }
    }

    // Fast Binary Encoding decimal field model
    public class FieldModelDecimal : FieldModelValueType<decimal>
    {
        public FieldModelDecimal(Buffer buffer, long offset) : base(buffer, offset) {}

        // Get the field size
        public override long FBESize => 16;

        // Clone the field model
        public override FieldModelValueType<decimal> Clone() { return new FieldModelDecimal(_buffer, _offset); }

        // Get the value
        public override void Get(out decimal value) { Get(out value, 0.0M); }
        public override void Get(out decimal value, decimal defaults)
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
            {
                value = defaults;
                return;
            }

            value = ReadDecimal(FBEOffset);
        }

        // Set the value
        public override void Set(decimal value)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            Write(FBEOffset, value);
        }
    }

    // Fast Binary Encoding Guid field model
    public class FieldModelUUID : FieldModelValueType<Guid>
    {
        public FieldModelUUID(Buffer buffer, long offset) : base(buffer, offset) {}

        // Get the field size
        public override long FBESize => 16;

        // Clone the field model
        public override FieldModelValueType<Guid> Clone() { return new FieldModelUUID(_buffer, _offset); }

        // Get the value
        public override void Get(out Guid value) { Get(out value, UuidGenerator.Nil()); }
        public override void Get(out Guid value, Guid defaults)
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
            {
                value = defaults;
                return;
            }

            value = ReadUUID(FBEOffset);
        }

        // Set the value
        public override void Set(Guid value)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            Write(FBEOffset, value);
        }
    }

    // Fast Binary Encoding timestamp field model
    public class FieldModelTimestamp : FieldModelValueType<DateTime>
    {
        private const long UnixEpoch = 621355968000000000;

        public FieldModelTimestamp(Buffer buffer, long offset) : base(buffer, offset) {}

        // Get the field size
        public override long FBESize => 8;

        // Clone the field model
        public override FieldModelValueType<DateTime> Clone() { return new FieldModelTimestamp(_buffer, _offset); }

        // Get the timestamp value
        public override void Get(out DateTime value) { Get(out value, new DateTime(UnixEpoch, DateTimeKind.Utc)); }
        public override void Get(out DateTime value, DateTime defaults)
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
            {
                value = defaults;
                return;
            }

            ulong ticks = ReadUInt64(FBEOffset) / 100;
            value = new DateTime((long)(UnixEpoch + ticks), DateTimeKind.Utc);
        }

        // Set the timestamp value
        public override void Set(DateTime value)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            ulong nanoseconds = (ulong)((value.Ticks - UnixEpoch) * 100);
            Write(FBEOffset, nanoseconds);
        }
    }

    // Fast Binary Encoding bytes field model
    public class FieldModelBytes : FieldModelReferenceType<MemoryStream>
    {
        public FieldModelBytes(Buffer buffer, long offset) : base(buffer, offset) {}

        // Get the field size
        public override long FBESize => 4;
        // Get the field extra size
        public override long FBEExtra
        {
            get
            {
                if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                    return 0;

                uint fbeBytesOffset = ReadUInt32(FBEOffset);
                if ((fbeBytesOffset == 0) || ((_buffer.Offset + fbeBytesOffset + 4) > _buffer.Size))
                    return 0;

                uint fbeBytesSize = ReadUInt32(fbeBytesOffset);
                return 4 + fbeBytesSize;
            }
        }

        // Clone the field model
        public override FieldModelReferenceType<MemoryStream> Clone() { return new FieldModelBytes(_buffer, _offset); }

        // Check if the bytes value is valid
        public override bool Verify()
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return true;

            uint fbeBytesOffset = ReadUInt32(FBEOffset);
            if (fbeBytesOffset == 0)
                return true;

            if ((_buffer.Offset + fbeBytesOffset + 4) > _buffer.Size)
                return false;

            uint fbeBytesSize = ReadUInt32(fbeBytesOffset);
            if ((_buffer.Offset + fbeBytesOffset + 4 + fbeBytesSize) > _buffer.Size)
                return false;

            return true;
        }

        // Get the bytes value
        public override void Get(out MemoryStream value) { Get(out value, new MemoryStream()); }
        public override void Get(out MemoryStream value, MemoryStream defaults)
        {
            Debug.Assert((defaults != null), "Invalid default bytes value!");
            if (defaults == null)
                throw new ArgumentNullException(nameof(defaults), "Invalid default bytes value!");

            value = defaults;

            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            uint fbeBytesOffset = ReadUInt32(FBEOffset);
            if (fbeBytesOffset == 0)
                return;

            Debug.Assert(((_buffer.Offset + fbeBytesOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + fbeBytesOffset + 4) > _buffer.Size)
                return;

            uint fbeBytesSize = ReadUInt32(fbeBytesOffset);
            Debug.Assert(((_buffer.Offset + fbeBytesOffset + 4 + fbeBytesSize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + fbeBytesOffset + 4 + fbeBytesSize) > _buffer.Size)
                return;

            var buffer = ReadBytes(fbeBytesOffset + 4, fbeBytesSize);
            value.Write(buffer, 0, buffer.Length);
        }

        // Set the bytes value
        public override void Set(MemoryStream value)
        {
            Debug.Assert((value != null), "Invalid bytes value!");
            if (value == null)
                throw new ArgumentNullException(nameof(value), "Invalid bytes value!");

            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            uint fbeBytesSize = (uint)value.Length;
            uint fbeBytesOffset = (uint)(_buffer.Allocate(4 + fbeBytesSize) - _buffer.Offset);
            Debug.Assert(((fbeBytesOffset > 0) && ((_buffer.Offset + fbeBytesOffset + 4 + fbeBytesSize) <= _buffer.Size)), "Model is broken!");
            if ((fbeBytesOffset == 0) || ((_buffer.Offset + fbeBytesOffset + 4 + fbeBytesSize) > _buffer.Size))
                return;

            Write(FBEOffset, fbeBytesOffset);
            Write(fbeBytesOffset, fbeBytesSize);
            Write(fbeBytesOffset + 4, value.GetBuffer(), 0, fbeBytesSize);
        }
    }

    // Fast Binary Encoding string field model
    public class FieldModelString : FieldModelReferenceType<string>
    {
        public FieldModelString(Buffer buffer, long offset) : base(buffer, offset) {}

        // Get the field size
        public override long FBESize => 4;
        // Get the field extra size
        public override long FBEExtra
        {
            get
            {
                if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                    return 0;

                uint fbeStringOffset = ReadUInt32(FBEOffset);
                if ((fbeStringOffset == 0) || ((_buffer.Offset + fbeStringOffset + 4) > _buffer.Size))
                    return 0;

                uint fbeStringSize = ReadUInt32(fbeStringOffset);
                return 4 + fbeStringSize;
            }
        }

        // Clone the field model
        public override FieldModelReferenceType<string> Clone() { return new FieldModelString(_buffer, _offset); }

        // Check if the string value is valid
        public override bool Verify()
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return true;

            uint fbeStringOffset = ReadUInt32(FBEOffset);
            if (fbeStringOffset == 0)
                return true;

            if ((_buffer.Offset + fbeStringOffset + 4) > _buffer.Size)
                return false;

            uint fbeStringSize = ReadUInt32(fbeStringOffset);
            if ((_buffer.Offset + fbeStringOffset + 4 + fbeStringSize) > _buffer.Size)
                return false;

            return true;
        }

        // Get the string value
        public override void Get(out string value) { Get(out value, ""); }
        public override void Get(out string value, string defaults)
        {
            Debug.Assert((defaults != null), "Invalid default string value!");
            if (defaults == null)
                throw new ArgumentNullException(nameof(defaults), "Invalid default string value!");

            value = defaults;

            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            uint fbeStringOffset = ReadUInt32(FBEOffset);
            if (fbeStringOffset == 0)
                return;

            Debug.Assert(((_buffer.Offset + fbeStringOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + fbeStringOffset + 4) > _buffer.Size)
                return;

            uint fbeStringSize = ReadUInt32(fbeStringOffset);
            Debug.Assert(((_buffer.Offset + fbeStringOffset + 4 + fbeStringSize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + fbeStringOffset + 4 + fbeStringSize) > _buffer.Size)
                return;

            value = ReadString(fbeStringOffset + 4, fbeStringSize);
        }

        // Set the string value
        public override void Set(string value)
        {
            Debug.Assert((value != null), "Invalid string value!");
            if (value == null)
                throw new ArgumentNullException(nameof(value), "Invalid string value!");

            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            uint fbeStringSize = (uint)Encoding.UTF8.GetByteCount(value);
            uint fbeStringOffset = (uint)(_buffer.Allocate(4 + fbeStringSize) - _buffer.Offset);
            Debug.Assert(((fbeStringOffset > 0) && ((_buffer.Offset + fbeStringOffset + 4 + fbeStringSize) <= _buffer.Size)), "Model is broken!");
            if ((fbeStringOffset == 0) || ((_buffer.Offset + fbeStringOffset + 4 + fbeStringSize) > _buffer.Size))
                return;

            Write(FBEOffset, fbeStringOffset);
            Write(fbeStringOffset, fbeStringSize);
            Write(fbeStringOffset + 4, value);
        }
    }

    // Fast Binary Encoding field model optional (value type)
    public class FieldModelOptionalValueType<T, TModel> : FieldModelBase
        where T : struct
        where TModel : FieldModelValueType<T>
    {
        public FieldModelOptionalValueType(TModel model, Buffer buffer, long offset) : base(buffer, offset)
        {
            Value = model.Clone() as TModel;
            // Reset the optional model offset
            if (Value != null)
                Value.FBEOffset = 0;
        }

        // Get the field size
        public override long FBESize => 1 + 4;
        // Get the field extra size
        public override long FBEExtra
        {
            get
            {
                if (!HasValue)
                    return 0;

                uint fbeOptionalOffset = ReadUInt32(FBEOffset + 1);
                if ((fbeOptionalOffset == 0) || ((_buffer.Offset + fbeOptionalOffset + 4) > _buffer.Size))
                    return 0;

                _buffer.Shift(fbeOptionalOffset);
                long fbeResult = Value.FBESize + Value.FBEExtra;
                _buffer.Unshift(fbeOptionalOffset);
                return fbeResult;
            }
        }

        // Clone the field model
        public FieldModelOptionalValueType<T, TModel> Clone() { return new FieldModelOptionalValueType<T, TModel>(Value, _buffer, _offset); }

        //! Is the value present?
        public static implicit operator bool(FieldModelOptionalValueType<T, TModel> optional) { return !ReferenceEquals(optional, null) && optional.HasValue; }

        // Checks if the object contains a value
        public bool HasValue
        {
            get
            {
                if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                    return false;

                byte fbeHasValue = ReadUInt8(FBEOffset);
                return (fbeHasValue != 0);
            }
        }

        // Base field model value
        public TModel Value { get; }

        // Check if the optional value is valid
        public virtual bool Verify()
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return true;

            byte fbeHasValue = ReadUInt8(FBEOffset);
            if (fbeHasValue == 0)
                return true;

            uint fbeOptionalOffset = ReadUInt32(FBEOffset + 1);
            if (fbeOptionalOffset == 0)
                return false;

            _buffer.Shift(fbeOptionalOffset);
            bool fbeResult = Value.Verify();
            _buffer.Unshift(fbeOptionalOffset);
            return fbeResult;
        }

        // Get the optional value (being phase)
        public long GetBegin()
        {
            if (!HasValue)
                return 0;

            uint fbeOptionalOffset = ReadUInt32(FBEOffset + 1);
            Debug.Assert((fbeOptionalOffset > 0), "Model is broken!");
            if (fbeOptionalOffset == 0)
                return 0;

            _buffer.Shift(fbeOptionalOffset);
            return fbeOptionalOffset;
        }

        // Get the optional value (end phase)
        public void GetEnd(long fbeBegin)
        {
            _buffer.Unshift(fbeBegin);
        }

        // Get the optional value
        public void Get(out T? optional, T? defaults = null)
        {
            optional = defaults;

            long fbeBegin = GetBegin();
            if (fbeBegin == 0)
                return;

            Value.Get(out var temp);
            optional = temp;

            GetEnd(fbeBegin);
        }

        // Set the optional value (begin phase)
        public long SetBegin(bool hasValue)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return 0;

            byte fbeHasValue = (byte)(hasValue ? 1 : 0);
            Write(FBEOffset, fbeHasValue);
            if (fbeHasValue == 0)
                return 0;

            uint fbeOptionalSize = (uint)Value.FBESize;
            uint fbeOptionalOffset = (uint)(_buffer.Allocate(fbeOptionalSize) - _buffer.Offset);
            Debug.Assert(((fbeOptionalOffset > 0) && ((_buffer.Offset + fbeOptionalOffset + fbeOptionalSize) <= _buffer.Size)), "Model is broken!");
            if ((fbeOptionalOffset == 0) || ((_buffer.Offset + fbeOptionalOffset + fbeOptionalSize) > _buffer.Size))
                return 0;

            Write(FBEOffset + 1, fbeOptionalOffset);

            _buffer.Shift(fbeOptionalOffset);
            return fbeOptionalOffset;
        }

        // Set the optional value (end phase)
        public void SetEnd(long fbeBegin)
        {
            _buffer.Unshift(fbeBegin);
        }

        // Set the optional value
        public void Set(T? optional)
        {
            long fbeBegin = SetBegin(optional.HasValue);
            if (fbeBegin == 0)
                return;

            if (optional.HasValue)
                Value.Set(optional.Value);

            SetEnd(fbeBegin);
        }
    }

    // Fast Binary Encoding field model optional (reference type)
    public class FieldModelOptionalReferenceType<T, TModel> : FieldModelBase
        where T : class
        where TModel : FieldModelReferenceType<T>
    {
        public FieldModelOptionalReferenceType(TModel model, Buffer buffer, long offset) : base(buffer, offset)
        {
            Value = model.Clone() as TModel;
            // Reset the optional model offset
            if (Value != null)
                Value.FBEOffset = 0;
        }

        // Get the field size
        public override long FBESize => 1 + 4;
        // Get the field extra size
        public override long FBEExtra
        {
            get
            {
                if (!HasValue)
                    return 0;

                uint fbeOptionalOffset = ReadUInt32(FBEOffset + 1);
                if ((fbeOptionalOffset == 0) || ((_buffer.Offset + fbeOptionalOffset + 4) > _buffer.Size))
                    return 0;

                _buffer.Shift(fbeOptionalOffset);
                long fbeResult = Value.FBESize + Value.FBEExtra;
                _buffer.Unshift(fbeOptionalOffset);
                return fbeResult;
            }
        }

        // Clone the field model
        public FieldModelOptionalReferenceType<T, TModel> Clone() { return new FieldModelOptionalReferenceType<T, TModel>(Value, _buffer, _offset); }

        //! Is the value present?
        public static implicit operator bool(FieldModelOptionalReferenceType<T, TModel> optional) { return !ReferenceEquals(optional, null) && optional.HasValue; }

        // Checks if the object contains a value
        public bool HasValue
        {
            get
            {
                if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                    return false;

                byte fbeHasValue = ReadUInt8(FBEOffset);
                return (fbeHasValue != 0);
            }
        }

        // Base field model value
        public TModel Value { get; }

        // Check if the optional value is valid
        public virtual bool Verify()
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return true;

            byte fbeHasValue = ReadUInt8(FBEOffset);
            if (fbeHasValue == 0)
                return true;

            uint fbeOptionalOffset = ReadUInt32(FBEOffset + 1);
            if (fbeOptionalOffset == 0)
                return false;

            _buffer.Shift(fbeOptionalOffset);
            bool fbeResult = Value.Verify();
            _buffer.Unshift(fbeOptionalOffset);
            return fbeResult;
        }

        // Get the optional value (being phase)
        public long GetBegin()
        {
            if (!HasValue)
                return 0;

            uint fbeOptionalOffset = ReadUInt32(FBEOffset + 1);
            Debug.Assert((fbeOptionalOffset > 0), "Model is broken!");
            if (fbeOptionalOffset == 0)
                return 0;

            _buffer.Shift(fbeOptionalOffset);
            return fbeOptionalOffset;
        }

        // Get the optional value (end phase)
        public void GetEnd(long fbeBegin)
        {
            _buffer.Unshift(fbeBegin);
        }

        // Get the optional value
        public void Get(out T optional, T defaults = null)
        {
            optional = defaults;

            long fbeBegin = GetBegin();
            if (fbeBegin == 0)
                return;

            Value.Get(out var temp);
            optional = temp;

            GetEnd(fbeBegin);
        }

        // Set the optional value (begin phase)
        public long SetBegin(bool hasValue)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return 0;

            byte fbeHasValue = (byte)(hasValue ? 1 : 0);
            Write(FBEOffset, fbeHasValue);
            if (fbeHasValue == 0)
                return 0;

            uint fbeOptionalSize = (uint)Value.FBESize;
            uint fbeOptionalOffset = (uint)(_buffer.Allocate(fbeOptionalSize) - _buffer.Offset);
            Debug.Assert(((fbeOptionalOffset > 0) && ((_buffer.Offset + fbeOptionalOffset + fbeOptionalSize) <= _buffer.Size)), "Model is broken!");
            if ((fbeOptionalOffset == 0) || ((_buffer.Offset + fbeOptionalOffset + fbeOptionalSize) > _buffer.Size))
                return 0;

            Write(FBEOffset + 1, fbeOptionalOffset);

            _buffer.Shift(fbeOptionalOffset);
            return fbeOptionalOffset;
        }

        // Set the optional value (end phase)
        public void SetEnd(long fbeBegin)
        {
            _buffer.Unshift(fbeBegin);
        }

        // Set the optional value
        public void Set(T optional)
        {
            long fbeBegin = SetBegin(optional != null);
            if (fbeBegin == 0)
                return;

            if (optional != null)
                Value.Set(optional);

            SetEnd(fbeBegin);
        }
    }

    // Fast Binary Encoding field model array (value type)
    public class FieldModelArrayValueType<T, TModel> : FieldModelBase
        where T : struct
        where TModel : FieldModelValueType<T>
    {
        private readonly TModel _model;
        private readonly long _size;

        public FieldModelArrayValueType(TModel model, Buffer buffer, long offset, long size) : base(buffer, offset)
        {
            _model = model.Clone() as TModel;
            _size = size;
        }

        // Get the field size
        public override long FBESize => _size * _model.FBESize;
        // Get the field extra size
        public override long FBEExtra => 0;

        // Clone the field model
        public FieldModelArrayValueType<T, TModel> Clone() { return new FieldModelArrayValueType<T, TModel>(_model, _buffer, _offset, _size); }

        // Get the array offset
        public long Offset => 0;
        // Get the array size
        public long Size => _size;

        // Array index operator
        public TModel this[long index]
        {
            get
            {
                Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
                Debug.Assert((index < _size), "Index is out of bounds!");

                _model.FBEOffset = FBEOffset;
                _model.FBEShift(index * _model.FBESize);
                return _model;
            }
        }

        // Check if the array is valid
        public virtual bool Verify()
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return false;

            _model.FBEOffset = FBEOffset;
            for (long i = _size; i-- > 0;)
            {
                if (!_model.Verify())
                    return false;
                _model.FBEShift(_model.FBESize);
            }

            return true;
        }

        // Get the array
        public void Get(ref T[] values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            values = new T[_size];

            var fbeModel = this[0];
            for (long i = 0; i < _size; i++)
            {
                fbeModel.Get(out values[i]);
                fbeModel.FBEShift(fbeModel.FBESize);
            }
        }

        // Get the array as List
        public void Get(ref List<T> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            values.Clear();
            values.Capacity = (int)_size;

            var fbeModel = this[0];
            for (long i = _size; i-- > 0;)
            {
                fbeModel.Get(out var value);
                values.Add(value);
                fbeModel.FBEShift(fbeModel.FBESize);
            }
        }

        // Set the array
        public void Set(T[] values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            var fbeModel = this[0];
            for (long i = 0; (i < values.Length) && (i < _size); i++)
            {
                fbeModel.Set(values[i]);
                fbeModel.FBEShift(fbeModel.FBESize);
            }
        }

        // Set the array as List
        public void Set(List<T> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            var fbeModel = this[0];
            for (long i = 0; (i < values.Count) && (i < _size); i++)
            {
                fbeModel.Set(values[(int)i]);
                fbeModel.FBEShift(fbeModel.FBESize);
            }
        }
    }

    // Fast Binary Encoding field model array (reference type)
    public class FieldModelArrayReferenceType<T, TModel> : FieldModelBase
        where T : class
        where TModel : FieldModelReferenceType<T>
    {
        private readonly TModel _model;
        private readonly long _size;

        public FieldModelArrayReferenceType(TModel model, Buffer buffer, long offset, long size) : base(buffer, offset)
        {
            _model = model.Clone() as TModel;
            _size = size;
        }

        // Get the field size
        public override long FBESize => _size * _model.FBESize;
        // Get the field extra size
        public override long FBEExtra => 0;

        // Clone the field model
        public FieldModelArrayReferenceType<T, TModel> Clone() { return new FieldModelArrayReferenceType<T, TModel>(_model, _buffer, _offset, _size); }

        // Get the array offset
        public long Offset => 0;
        // Get the array size
        public long Size => _size;

        // Array index operator
        public TModel this[long index]
        {
            get
            {
                Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
                Debug.Assert((index < _size), "Index is out of bounds!");

                _model.FBEOffset = FBEOffset;
                _model.FBEShift(index * _model.FBESize);
                return _model;
            }
        }

        // Check if the array is valid
        public virtual bool Verify()
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return false;

            _model.FBEOffset = FBEOffset;
            for (long i = _size; i-- > 0;)
            {
                if (!_model.Verify())
                    return false;
                _model.FBEShift(_model.FBESize);
            }

            return true;
        }

        // Get the array
        public void Get(ref T[] values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            values = new T[_size];

            var fbeModel = this[0];
            for (long i = 0; i < _size; i++)
            {
                fbeModel.Get(out values[i]);
                fbeModel.FBEShift(fbeModel.FBESize);
            }
        }

        // Get the array as List
        public void Get(ref List<T> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            values.Clear();
            values.Capacity = (int)_size;

            var fbeModel = this[0];
            for (long i = _size; i-- > 0;)
            {
                fbeModel.Get(out var value);
                values.Add(value);
                fbeModel.FBEShift(fbeModel.FBESize);
            }
        }

        // Set the array
        public void Set(T[] values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            var fbeModel = this[0];
            for (long i = 0; (i < values.Length) && (i < _size); i++)
            {
                fbeModel.Set(values[i]);
                fbeModel.FBEShift(fbeModel.FBESize);
            }
        }

        // Set the array as List
        public void Set(List<T> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            var fbeModel = this[0];
            for (long i = 0; (i < values.Count) && (i < _size); i++)
            {
                fbeModel.Set(values[(int)i]);
                fbeModel.FBEShift(fbeModel.FBESize);
            }
        }
    }

    // Fast Binary Encoding field model array (optional value type)
    public class FieldModelArrayOptionalValueType<T, TModel> : FieldModelBase
        where T : struct
        where TModel : FieldModelValueType<T>
    {
        private readonly FieldModelOptionalValueType<T, TModel> _model;
        private readonly long _size;

        public FieldModelArrayOptionalValueType(TModel model, Buffer buffer, long offset, long size) : base(buffer, offset)
        {
            _model = new FieldModelOptionalValueType<T, TModel>(model, buffer, offset);
            _size = size;
        }

        // Get the field size
        public override long FBESize => _size * _model.FBESize;
        // Get the field extra size
        public override long FBEExtra => 0;

        // Clone the field model
        public FieldModelArrayOptionalValueType<T, TModel> Clone() { return new FieldModelArrayOptionalValueType<T, TModel>(_model.Value, _buffer, _offset, _size); }

        // Get the array offset
        public long Offset => 0;
        // Get the array size
        public long Size => _size;

        // Array index operator
        public FieldModelOptionalValueType<T, TModel> this[long index]
        {
            get
            {
                Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
                Debug.Assert((index < _size), "Index is out of bounds!");

                _model.FBEOffset = FBEOffset;
                _model.FBEShift(index * _model.FBESize);
                return _model;
            }
        }

        // Check if the array is valid
        public virtual bool Verify()
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return false;

            _model.FBEOffset = FBEOffset;
            for (long i = _size; i-- > 0;)
            {
                if (!_model.Verify())
                    return false;
                _model.FBEShift(_model.FBESize);
            }

            return true;
        }

        // Get the array
        public void Get(ref T?[] values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            values = new T?[_size];

            var fbeModel = this[0];
            for (long i = 0; i < _size; i++)
            {
                fbeModel.Get(out values[i]);
                fbeModel.FBEShift(fbeModel.FBESize);
            }
        }

        // Get the array as List
        public void Get(ref List<T?> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            values.Clear();
            values.Capacity = (int)_size;

            var fbeModel = this[0];
            for (long i = _size; i-- > 0;)
            {
                fbeModel.Get(out var value);
                values.Add(value);
                fbeModel.FBEShift(fbeModel.FBESize);
            }
        }

        // Set the array
        public void Set(T?[] values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            var fbeModel = this[0];
            for (long i = 0; (i < values.Length) && (i < _size); i++)
            {
                fbeModel.Set(values[i]);
                fbeModel.FBEShift(fbeModel.FBESize);
            }
        }

        // Set the array as List
        public void Set(List<T?> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            var fbeModel = this[0];
            for (long i = 0; (i < values.Count) && (i < _size); i++)
            {
                fbeModel.Set(values[(int)i]);
                fbeModel.FBEShift(fbeModel.FBESize);
            }
        }
    }

    // Fast Binary Encoding field model array (optional reference type)
    public class FieldModelArrayOptionalReferenceType<T, TModel> : FieldModelBase
        where T : class
        where TModel : FieldModelReferenceType<T>
    {
        private readonly FieldModelOptionalReferenceType<T, TModel> _model;
        private readonly long _size;

        public FieldModelArrayOptionalReferenceType(TModel model, Buffer buffer, long offset, long size) : base(buffer, offset)
        {
            _model = new FieldModelOptionalReferenceType<T, TModel>(model, buffer, offset);
            _size = size;
        }

        // Get the field size
        public override long FBESize => _size * _model.FBESize;
        // Get the field extra size
        public override long FBEExtra => 0;

        // Clone the field model
        public FieldModelArrayOptionalReferenceType<T, TModel> Clone() { return new FieldModelArrayOptionalReferenceType<T, TModel>(_model.Value, _buffer, _offset, _size); }

        // Get the array offset
        public long Offset => 0;
        // Get the array size
        public long Size => _size;

        // Array index operator
        public FieldModelOptionalReferenceType<T, TModel> this[long index]
        {
            get
            {
                Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
                Debug.Assert((index < _size), "Index is out of bounds!");

                _model.FBEOffset = FBEOffset;
                _model.FBEShift(index * _model.FBESize);
                return _model;
            }
        }

        // Check if the array is valid
        public virtual bool Verify()
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return false;

            _model.FBEOffset = FBEOffset;
            for (long i = _size; i-- > 0;)
            {
                if (!_model.Verify())
                    return false;
                _model.FBEShift(_model.FBESize);
            }

            return true;
        }

        // Get the array
        public void Get(ref T[] values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            values = new T[_size];

            var fbeModel = this[0];
            for (long i = 0; i < _size; i++)
            {
                fbeModel.Get(out values[i]);
                fbeModel.FBEShift(fbeModel.FBESize);
            }
        }

        // Get the array as List
        public void Get(ref List<T> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            values.Clear();
            values.Capacity = (int)_size;

            var fbeModel = this[0];
            for (long i = _size; i-- > 0;)
            {
                fbeModel.Get(out var value);
                values.Add(value);
                fbeModel.FBEShift(fbeModel.FBESize);
            }
        }

        // Set the array
        public void Set(T[] values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            var fbeModel = this[0];
            for (long i = 0; (i < values.Length) && (i < _size); i++)
            {
                fbeModel.Set(values[i]);
                fbeModel.FBEShift(fbeModel.FBESize);
            }
        }

        // Set the array as List
        public void Set(List<T> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            var fbeModel = this[0];
            for (long i = 0; (i < values.Count) && (i < _size); i++)
            {
                fbeModel.Set(values[(int)i]);
                fbeModel.FBEShift(fbeModel.FBESize);
            }
        }
    }

    // Fast Binary Encoding field model vector (value type)
    public class FieldModelVectorValueType<T, TModel> : FieldModelBase
        where T : struct
        where TModel : FieldModelValueType<T>
    {
        private readonly TModel _model;

        public FieldModelVectorValueType(TModel model, Buffer buffer, long offset) : base(buffer, offset)
        {
            _model = model.Clone() as TModel;
        }

        // Get the field size
        public override long FBESize => 4;
        // Get the field extra size
        public override long FBEExtra
        {
            get
            {
                if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                    return 0;

                uint fbeVectorOffset = ReadUInt32(FBEOffset);
                if ((fbeVectorOffset == 0) || ((_buffer.Offset + fbeVectorOffset + 4) > _buffer.Size))
                    return 0;

                uint fbeVectorSize = ReadUInt32(fbeVectorOffset);

                long fbeResult = 4;
                _model.FBEOffset = fbeVectorOffset + 4;
                for (uint i = fbeVectorSize; i-- > 0;)
                {
                    fbeResult += _model.FBESize + _model.FBEExtra;
                    _model.FBEShift(_model.FBESize);
                }
                return fbeResult;
            }
        }

        // Clone the field model
        public FieldModelVectorValueType<T, TModel> Clone() { return new FieldModelVectorValueType<T, TModel>(_model, _buffer, _offset); }

        // Get the vector offset
        public long Offset
        {
            get
            {
                if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                    return 0;

                uint fbeVectorOffset = ReadUInt32(FBEOffset);
                return fbeVectorOffset;
            }
        }

        // Get the vector size
        public long Size
        {
            get
            {
                if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                    return 0;

                uint fbeVectorOffset = ReadUInt32(FBEOffset);
                if ((fbeVectorOffset == 0) || ((_buffer.Offset + fbeVectorOffset + 4) > _buffer.Size))
                    return 0;

                uint fbeVectorSize = ReadUInt32(fbeVectorOffset);
                return fbeVectorSize;
            }
        }

        // Vector index operator
        public TModel this[long index]
        {
            get
            {
                Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");

                uint fbeVectorOffset = ReadUInt32(FBEOffset);
                Debug.Assert(((fbeVectorOffset > 0) && ((_buffer.Offset + fbeVectorOffset + 4) <= _buffer.Size)), "Model is broken!");

                uint fbeVectorSize = ReadUInt32(fbeVectorOffset);
                Debug.Assert((index < fbeVectorSize), "Index is out of bounds!");

                _model.FBEOffset = fbeVectorOffset + 4;
                _model.FBEShift(index * _model.FBESize);
                return _model;
            }
        }

        // Resize the vector and get its first model
        public TModel Resize(long size)
        {
            uint fbeVectorSize = (uint)(size * _model.FBESize);
            uint fbeVectorOffset = (uint)(_buffer.Allocate(4 + fbeVectorSize) - _buffer.Offset);
            Debug.Assert(((fbeVectorOffset > 0) && ((_buffer.Offset + fbeVectorOffset + 4) <= _buffer.Size)), "Model is broken!");

            Write(FBEOffset, fbeVectorOffset);
            Write(fbeVectorOffset, (uint)size);
            Write(fbeVectorOffset + 4, 0, fbeVectorSize);

            _model.FBEOffset = fbeVectorOffset + 4;
            return _model;
        }

        // Check if the vector is valid
        public virtual bool Verify()
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return true;

            uint fbeVectorOffset = ReadUInt32(FBEOffset);
            if (fbeVectorOffset == 0)
                return true;

            if ((_buffer.Offset + fbeVectorOffset + 4) > _buffer.Size)
                return false;

            uint fbeVectorSize = ReadUInt32(fbeVectorOffset);

            _model.FBEOffset = fbeVectorOffset + 4;
            for (uint i = fbeVectorSize; i-- > 0;)
            {
                if (!_model.Verify())
                    return false;
                _model.FBEShift(_model.FBESize);
            }

            return true;
        }

        // Get the vector as List
        public void Get(ref List<T> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            values.Clear();

            long fbeVectorSize = Size;
            if (fbeVectorSize == 0)
                return;

            values.Capacity = (int)fbeVectorSize;

            var fbeModel = this[0];
            for (long i = fbeVectorSize; i-- > 0;)
            {
                fbeModel.Get(out var value);
                values.Add(value);
                fbeModel.FBEShift(fbeModel.FBESize);
            }
        }

        // Get the vector as LinkedList
        public void Get(ref LinkedList<T> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            values.Clear();

            long fbeVectorSize = Size;
            if (fbeVectorSize == 0)
                return;

            var fbeModel = this[0];
            for (long i = fbeVectorSize; i-- > 0;)
            {
                fbeModel.Get(out var value);
                values.AddLast(value);
                fbeModel.FBEShift(fbeModel.FBESize);
            }
        }

        // Get the vector as HashSet
        public void Get(ref HashSet<T> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            values.Clear();

            long fbeVectorSize = Size;
            if (fbeVectorSize == 0)
                return;

            var fbeModel = this[0];
            for (long i = fbeVectorSize; i-- > 0;)
            {
                fbeModel.Get(out var value);
                values.Add(value);
                fbeModel.FBEShift(fbeModel.FBESize);
            }
        }

        // Set the vector as List
        public void Set(List<T> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            var fbeModel = Resize(values.Count);
            foreach (var value in values)
            {
                fbeModel.Set(value);
                fbeModel.FBEShift(fbeModel.FBESize);
            }
        }

        // Set the vector as LinkedList
        public void Set(LinkedList<T> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            var fbeModel = Resize(values.Count);
            foreach (var value in values)
            {
                fbeModel.Set(value);
                fbeModel.FBEShift(fbeModel.FBESize);
            }
        }

        // Set the vector as HashSet
        public void Set(HashSet<T> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            var fbeModel = Resize(values.Count);
            foreach (var value in values)
            {
                fbeModel.Set(value);
                fbeModel.FBEShift(fbeModel.FBESize);
            }
        }
    }

    // Fast Binary Encoding field model vector (reference type)
    public class FieldModelVectorReferenceType<T, TModel> : FieldModelBase
        where T : class
        where TModel : FieldModelReferenceType<T>
    {
        private readonly TModel _model;

        public FieldModelVectorReferenceType(TModel model, Buffer buffer, long offset) : base(buffer, offset)
        {
            _model = model.Clone() as TModel;
        }

        // Get the field size
        public override long FBESize => 4;
        // Get the field extra size
        public override long FBEExtra
        {
            get
            {
                if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                    return 0;

                uint fbeVectorOffset = ReadUInt32(FBEOffset);
                if ((fbeVectorOffset == 0) || ((_buffer.Offset + fbeVectorOffset + 4) > _buffer.Size))
                    return 0;

                uint fbeVectorSize = ReadUInt32(fbeVectorOffset);

                long fbeResult = 4;
                _model.FBEOffset = fbeVectorOffset + 4;
                for (uint i = fbeVectorSize; i-- > 0;)
                {
                    fbeResult += _model.FBESize + _model.FBEExtra;
                    _model.FBEShift(_model.FBESize);
                }
                return fbeResult;
            }
        }

        // Clone the field model
        public FieldModelVectorReferenceType<T, TModel> Clone() { return new FieldModelVectorReferenceType<T, TModel>(_model, _buffer, _offset); }

        // Get the vector offset
        public long Offset
        {
            get
            {
                if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                    return 0;

                uint fbeVectorOffset = ReadUInt32(FBEOffset);
                return fbeVectorOffset;
            }
        }

        // Get the vector size
        public long Size
        {
            get
            {
                if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                    return 0;

                uint fbeVectorOffset = ReadUInt32(FBEOffset);
                if ((fbeVectorOffset == 0) || ((_buffer.Offset + fbeVectorOffset + 4) > _buffer.Size))
                    return 0;

                uint fbeVectorSize = ReadUInt32(fbeVectorOffset);
                return fbeVectorSize;
            }
        }

        // Vector index operator
        public TModel this[long index]
        {
            get
            {
                Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");

                uint fbeVectorOffset = ReadUInt32(FBEOffset);
                Debug.Assert(((fbeVectorOffset > 0) && ((_buffer.Offset + fbeVectorOffset + 4) <= _buffer.Size)), "Model is broken!");

                uint fbeVectorSize = ReadUInt32(fbeVectorOffset);
                Debug.Assert((index < fbeVectorSize), "Index is out of bounds!");

                _model.FBEOffset = fbeVectorOffset + 4;
                _model.FBEShift(index * _model.FBESize);
                return _model;
            }
        }

        // Resize the vector and get its first model
        public TModel Resize(long size)
        {
            uint fbeVectorSize = (uint)(size * _model.FBESize);
            uint fbeVectorOffset = (uint)(_buffer.Allocate(4 + fbeVectorSize) - _buffer.Offset);
            Debug.Assert(((fbeVectorOffset > 0) && ((_buffer.Offset + fbeVectorOffset + 4) <= _buffer.Size)), "Model is broken!");

            Write(FBEOffset, fbeVectorOffset);
            Write(fbeVectorOffset, (uint)size);
            Write(fbeVectorOffset + 4, 0, fbeVectorSize);

            _model.FBEOffset = fbeVectorOffset + 4;
            return _model;
        }

        // Check if the vector is valid
        public virtual bool Verify()
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return true;

            uint fbeVectorOffset = ReadUInt32(FBEOffset);
            if (fbeVectorOffset == 0)
                return true;

            if ((_buffer.Offset + fbeVectorOffset + 4) > _buffer.Size)
                return false;

            uint fbeVectorSize = ReadUInt32(fbeVectorOffset);

            _model.FBEOffset = fbeVectorOffset + 4;
            for (uint i = fbeVectorSize; i-- > 0;)
            {
                if (!_model.Verify())
                    return false;
                _model.FBEShift(_model.FBESize);
            }

            return true;
        }

        // Get the vector as List
        public void Get(ref List<T> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            values.Clear();

            long fbeVectorSize = Size;
            if (fbeVectorSize == 0)
                return;

            values.Capacity = (int)fbeVectorSize;

            var fbeModel = this[0];
            for (long i = fbeVectorSize; i-- > 0;)
            {
                fbeModel.Get(out var value);
                values.Add(value);
                fbeModel.FBEShift(fbeModel.FBESize);
            }
        }

        // Get the vector as LinkedList
        public void Get(ref LinkedList<T> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            values.Clear();

            long fbeVectorSize = Size;
            if (fbeVectorSize == 0)
                return;

            var fbeModel = this[0];
            for (long i = fbeVectorSize; i-- > 0;)
            {
                fbeModel.Get(out var value);
                values.AddLast(value);
                fbeModel.FBEShift(fbeModel.FBESize);
            }
        }

        // Get the vector as HashSet
        public void Get(ref HashSet<T> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            values.Clear();

            long fbeVectorSize = Size;
            if (fbeVectorSize == 0)
                return;

            var fbeModel = this[0];
            for (long i = fbeVectorSize; i-- > 0;)
            {
                fbeModel.Get(out var value);
                values.Add(value);
                fbeModel.FBEShift(fbeModel.FBESize);
            }
        }

        // Set the vector as List
        public void Set(List<T> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            var fbeModel = Resize(values.Count);
            foreach (var value in values)
            {
                fbeModel.Set(value);
                fbeModel.FBEShift(fbeModel.FBESize);
            }
        }

        // Set the vector as LinkedList
        public void Set(LinkedList<T> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            var fbeModel = Resize(values.Count);
            foreach (var value in values)
            {
                fbeModel.Set(value);
                fbeModel.FBEShift(fbeModel.FBESize);
            }
        }

        // Set the vector as HashSet
        public void Set(HashSet<T> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            var fbeModel = Resize(values.Count);
            foreach (var value in values)
            {
                fbeModel.Set(value);
                fbeModel.FBEShift(fbeModel.FBESize);
            }
        }
    }

    // Fast Binary Encoding field model vector (optional value type)
    public class FieldModelVectorOptionalValueType<T, TModel> : FieldModelBase
        where T : struct
        where TModel : FieldModelValueType<T>
    {
        private readonly FieldModelOptionalValueType<T, TModel> _model;

        public FieldModelVectorOptionalValueType(TModel model, Buffer buffer, long offset) : base(buffer, offset)
        {
            _model = new FieldModelOptionalValueType<T, TModel>(model, buffer, offset);
        }

        // Get the field size
        public override long FBESize => 4;
        // Get the field extra size
        public override long FBEExtra
        {
            get
            {
                if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                    return 0;

                uint fbeVectorOffset = ReadUInt32(FBEOffset);
                if ((fbeVectorOffset == 0) || ((_buffer.Offset + fbeVectorOffset + 4) > _buffer.Size))
                    return 0;

                uint fbeVectorSize = ReadUInt32(fbeVectorOffset);

                long fbeResult = 4;
                _model.FBEOffset = fbeVectorOffset + 4;
                for (uint i = fbeVectorSize; i-- > 0;)
                {
                    fbeResult += _model.FBESize + _model.FBEExtra;
                    _model.FBEShift(_model.FBESize);
                }
                return fbeResult;
            }
        }

        // Clone the field model
        public FieldModelVectorOptionalValueType<T, TModel> Clone() { return new FieldModelVectorOptionalValueType<T, TModel>(_model.Value, _buffer, _offset); }

        // Get the vector offset
        public long Offset
        {
            get
            {
                if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                    return 0;

                uint fbeVectorOffset = ReadUInt32(FBEOffset);
                return fbeVectorOffset;
            }
        }

        // Get the vector size
        public long Size
        {
            get
            {
                if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                    return 0;

                uint fbeVectorOffset = ReadUInt32(FBEOffset);
                if ((fbeVectorOffset == 0) || ((_buffer.Offset + fbeVectorOffset + 4) > _buffer.Size))
                    return 0;

                uint fbeVectorSize = ReadUInt32(fbeVectorOffset);
                return fbeVectorSize;
            }
        }

        // Vector index operator
        public FieldModelOptionalValueType<T, TModel> this[long index]
        {
            get
            {
                Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");

                uint fbeVectorOffset = ReadUInt32(FBEOffset);
                Debug.Assert(((fbeVectorOffset > 0) && ((_buffer.Offset + fbeVectorOffset + 4) <= _buffer.Size)), "Model is broken!");

                uint fbeVectorSize = ReadUInt32(fbeVectorOffset);
                Debug.Assert((index < fbeVectorSize), "Index is out of bounds!");

                _model.FBEOffset = fbeVectorOffset + 4;
                _model.FBEShift(index * _model.FBESize);
                return _model;
            }
        }

        // Resize the vector and get its first model
        public FieldModelOptionalValueType<T, TModel> Resize(long size)
        {
            uint fbeVectorSize = (uint)(size * _model.FBESize);
            uint fbeVectorOffset = (uint)(_buffer.Allocate(4 + fbeVectorSize) - _buffer.Offset);
            Debug.Assert(((fbeVectorOffset > 0) && ((_buffer.Offset + fbeVectorOffset + 4) <= _buffer.Size)), "Model is broken!");

            Write(FBEOffset, fbeVectorOffset);
            Write(fbeVectorOffset, (uint)size);
            Write(fbeVectorOffset + 4, 0, fbeVectorSize);

            _model.FBEOffset = fbeVectorOffset + 4;
            return _model;
        }

        // Check if the vector is valid
        public virtual bool Verify()
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return true;

            uint fbeVectorOffset = ReadUInt32(FBEOffset);
            if (fbeVectorOffset == 0)
                return true;

            if ((_buffer.Offset + fbeVectorOffset + 4) > _buffer.Size)
                return false;

            uint fbeVectorSize = ReadUInt32(fbeVectorOffset);

            _model.FBEOffset = fbeVectorOffset + 4;
            for (uint i = fbeVectorSize; i-- > 0;)
            {
                if (!_model.Verify())
                    return false;
                _model.FBEShift(_model.FBESize);
            }

            return true;
        }

        // Get the vector as List
        public void Get(ref List<T?> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            values.Clear();

            long fbeVectorSize = Size;
            if (fbeVectorSize == 0)
                return;

            values.Capacity = (int)fbeVectorSize;

            var fbeModel = this[0];
            for (long i = fbeVectorSize; i-- > 0;)
            {
                fbeModel.Get(out var value);
                values.Add(value);
                fbeModel.FBEShift(fbeModel.FBESize);
            }
        }

        // Get the vector as LinkedList
        public void Get(ref LinkedList<T?> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            values.Clear();

            long fbeVectorSize = Size;
            if (fbeVectorSize == 0)
                return;

            var fbeModel = this[0];
            for (long i = fbeVectorSize; i-- > 0;)
            {
                fbeModel.Get(out var value);
                values.AddLast(value);
                fbeModel.FBEShift(fbeModel.FBESize);
            }
        }

        // Get the vector as HashSet
        public void Get(ref HashSet<T?> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            values.Clear();

            long fbeVectorSize = Size;
            if (fbeVectorSize == 0)
                return;

            var fbeModel = this[0];
            for (long i = fbeVectorSize; i-- > 0;)
            {
                fbeModel.Get(out var value);
                values.Add(value);
                fbeModel.FBEShift(fbeModel.FBESize);
            }
        }

        // Set the vector as List
        public void Set(List<T?> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            var fbeModel = Resize(values.Count);
            foreach (var value in values)
            {
                fbeModel.Set(value);
                fbeModel.FBEShift(fbeModel.FBESize);
            }
        }

        // Set the vector as LinkedList
        public void Set(LinkedList<T?> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            var fbeModel = Resize(values.Count);
            foreach (var value in values)
            {
                fbeModel.Set(value);
                fbeModel.FBEShift(fbeModel.FBESize);
            }
        }

        // Set the vector as HashSet
        public void Set(HashSet<T?> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            var fbeModel = Resize(values.Count);
            foreach (var value in values)
            {
                fbeModel.Set(value);
                fbeModel.FBEShift(fbeModel.FBESize);
            }
        }
    }

    // Fast Binary Encoding field model vector (optional reference type)
    public class FieldModelVectorOptionalReferenceType<T, TModel> : FieldModelBase
        where T : class
        where TModel : FieldModelReferenceType<T>
    {
        private readonly FieldModelOptionalReferenceType<T, TModel> _model;

        public FieldModelVectorOptionalReferenceType(TModel model, Buffer buffer, long offset) : base(buffer, offset)
        {
            _model = new FieldModelOptionalReferenceType<T, TModel>(model, buffer, offset);
        }

        // Get the field size
        public override long FBESize => 4;
        // Get the field extra size
        public override long FBEExtra
        {
            get
            {
                if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                    return 0;

                uint fbeVectorOffset = ReadUInt32(FBEOffset);
                if ((fbeVectorOffset == 0) || ((_buffer.Offset + fbeVectorOffset + 4) > _buffer.Size))
                    return 0;

                uint fbeVectorSize = ReadUInt32(fbeVectorOffset);

                long fbeResult = 4;
                _model.FBEOffset = fbeVectorOffset + 4;
                for (uint i = fbeVectorSize; i-- > 0;)
                {
                    fbeResult += _model.FBESize + _model.FBEExtra;
                    _model.FBEShift(_model.FBESize);
                }
                return fbeResult;
            }
        }

        // Clone the field model
        public FieldModelVectorOptionalReferenceType<T, TModel> Clone() { return new FieldModelVectorOptionalReferenceType<T, TModel>(_model.Value, _buffer, _offset); }

        // Get the vector offset
        public long Offset
        {
            get
            {
                if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                    return 0;

                uint fbeVectorOffset = ReadUInt32(FBEOffset);
                return fbeVectorOffset;
            }
        }

        // Get the vector size
        public long Size
        {
            get
            {
                if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                    return 0;

                uint fbeVectorOffset = ReadUInt32(FBEOffset);
                if ((fbeVectorOffset == 0) || ((_buffer.Offset + fbeVectorOffset + 4) > _buffer.Size))
                    return 0;

                uint fbeVectorSize = ReadUInt32(fbeVectorOffset);
                return fbeVectorSize;
            }
        }

        // Vector index operator
        public FieldModelOptionalReferenceType<T, TModel> this[long index]
        {
            get
            {
                Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");

                uint fbeVectorOffset = ReadUInt32(FBEOffset);
                Debug.Assert(((fbeVectorOffset > 0) && ((_buffer.Offset + fbeVectorOffset + 4) <= _buffer.Size)), "Model is broken!");

                uint fbeVectorSize = ReadUInt32(fbeVectorOffset);
                Debug.Assert((index < fbeVectorSize), "Index is out of bounds!");

                _model.FBEOffset = fbeVectorOffset + 4;
                _model.FBEShift(index * _model.FBESize);
                return _model;
            }
        }

        // Resize the vector and get its first model
        public FieldModelOptionalReferenceType<T, TModel> Resize(long size)
        {
            uint fbeVectorSize = (uint)(size * _model.FBESize);
            uint fbeVectorOffset = (uint)(_buffer.Allocate(4 + fbeVectorSize) - _buffer.Offset);
            Debug.Assert(((fbeVectorOffset > 0) && ((_buffer.Offset + fbeVectorOffset + 4) <= _buffer.Size)), "Model is broken!");

            Write(FBEOffset, fbeVectorOffset);
            Write(fbeVectorOffset, (uint)size);
            Write(fbeVectorOffset + 4, 0, fbeVectorSize);

            _model.FBEOffset = fbeVectorOffset + 4;
            return _model;
        }

        // Check if the vector is valid
        public virtual bool Verify()
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return true;

            uint fbeVectorOffset = ReadUInt32(FBEOffset);
            if (fbeVectorOffset == 0)
                return true;

            if ((_buffer.Offset + fbeVectorOffset + 4) > _buffer.Size)
                return false;

            uint fbeVectorSize = ReadUInt32(fbeVectorOffset);

            _model.FBEOffset = fbeVectorOffset + 4;
            for (uint i = fbeVectorSize; i-- > 0;)
            {
                if (!_model.Verify())
                    return false;
                _model.FBEShift(_model.FBESize);
            }

            return true;
        }

        // Get the vector as List
        public void Get(ref List<T> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            values.Clear();

            long fbeVectorSize = Size;
            if (fbeVectorSize == 0)
                return;

            values.Capacity = (int)fbeVectorSize;

            var fbeModel = this[0];
            for (long i = fbeVectorSize; i-- > 0;)
            {
                fbeModel.Get(out var value);
                values.Add(value);
                fbeModel.FBEShift(fbeModel.FBESize);
            }
        }

        // Get the vector as LinkedList
        public void Get(ref LinkedList<T> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            values.Clear();

            long fbeVectorSize = Size;
            if (fbeVectorSize == 0)
                return;

            var fbeModel = this[0];
            for (long i = fbeVectorSize; i-- > 0;)
            {
                fbeModel.Get(out var value);
                values.AddLast(value);
                fbeModel.FBEShift(fbeModel.FBESize);
            }
        }

        // Get the vector as HashSet
        public void Get(ref HashSet<T> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            values.Clear();

            long fbeVectorSize = Size;
            if (fbeVectorSize == 0)
                return;

            var fbeModel = this[0];
            for (long i = fbeVectorSize; i-- > 0;)
            {
                fbeModel.Get(out var value);
                values.Add(value);
                fbeModel.FBEShift(fbeModel.FBESize);
            }
        }

        // Set the vector as List
        public void Set(List<T> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            var fbeModel = Resize(values.Count);
            foreach (var value in values)
            {
                fbeModel.Set(value);
                fbeModel.FBEShift(fbeModel.FBESize);
            }
        }

        // Set the vector as LinkedList
        public void Set(LinkedList<T> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            var fbeModel = Resize(values.Count);
            foreach (var value in values)
            {
                fbeModel.Set(value);
                fbeModel.FBEShift(fbeModel.FBESize);
            }
        }

        // Set the vector as HashSet
        public void Set(HashSet<T> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            var fbeModel = Resize(values.Count);
            foreach (var value in values)
            {
                fbeModel.Set(value);
                fbeModel.FBEShift(fbeModel.FBESize);
            }
        }
    }

    // Fast Binary Encoding field model map (value type key, value type value)
    public class FieldModelMapValueTypeKeyValueTypeValue<TKey, TKeyModel, TValue, TValueModel> : FieldModelBase
        where TKey : struct
        where TKeyModel : FieldModelValueType<TKey>
        where TValue : struct
        where TValueModel : FieldModelValueType<TValue>
    {
        private readonly TKeyModel _modelKey;
        private readonly TValueModel _modelValue;

        public FieldModelMapValueTypeKeyValueTypeValue(TKeyModel modelKey, TValueModel modelValue, Buffer buffer, long offset) : base(buffer, offset)
        {
            _modelKey = modelKey.Clone() as TKeyModel;
            _modelValue = modelValue.Clone() as TValueModel;
        }

        // Get the field size
        public override long FBESize => 4;
        // Get the field extra size
        public override long FBEExtra
        {
            get
            {
                if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                    return 0;

                uint fbeMapOffset = ReadUInt32(FBEOffset);
                if ((fbeMapOffset == 0) || ((_buffer.Offset + fbeMapOffset + 4) > _buffer.Size))
                    return 0;

                uint fbeMapSize = ReadUInt32(fbeMapOffset);

                long fbeResult = 4;
                _modelKey.FBEOffset = fbeMapOffset + 4;
                _modelValue.FBEOffset = fbeMapOffset + 4 + _modelKey.FBESize;
                for (uint i = fbeMapSize; i-- > 0;)
                {
                    fbeResult += _modelKey.FBESize + _modelKey.FBEExtra;
                    _modelKey.FBEShift(_modelKey.FBESize + _modelValue.FBESize);

                    fbeResult += _modelValue.FBESize + _modelValue.FBEExtra;
                    _modelValue.FBEShift(_modelKey.FBESize + _modelValue.FBESize);
                }
                return fbeResult;
            }
        }

        // Clone the field model
        public FieldModelMapValueTypeKeyValueTypeValue<TKey, TKeyModel, TValue, TValueModel> Clone() { return new FieldModelMapValueTypeKeyValueTypeValue<TKey, TKeyModel, TValue, TValueModel>(_modelKey, _modelValue, _buffer, _offset); }

        // Get the map offset
        public long Offset
        {
            get
            {
                if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                    return 0;

                uint fbeMapOffset = ReadUInt32(FBEOffset);
                return fbeMapOffset;
            }
        }

        // Get the map size
        public long Size
        {
            get
            {
                if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                    return 0;

                uint fbeMapOffset = ReadUInt32(FBEOffset);
                if ((fbeMapOffset == 0) || ((_buffer.Offset + fbeMapOffset + 4) > _buffer.Size))
                    return 0;

                uint fbeMapSize = ReadUInt32(fbeMapOffset);
                return fbeMapSize;
            }
        }

        // Map index operator
        public KeyValuePair<TKeyModel, TValueModel> this[long index]
        {
            get
            {
                Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");

                uint fbeMapOffset = ReadUInt32(FBEOffset);
                Debug.Assert(((fbeMapOffset > 0) && ((_buffer.Offset + fbeMapOffset + 4) <= _buffer.Size)), "Model is broken!");

                uint fbeMapSize = ReadUInt32(fbeMapOffset);
                Debug.Assert((index < fbeMapSize), "Index is out of bounds!");

                _modelKey.FBEOffset = fbeMapOffset + 4;
                _modelValue.FBEOffset = fbeMapOffset + 4 + _modelKey.FBESize;
                _modelKey.FBEShift(index * (_modelKey.FBESize + _modelValue.FBESize));
                _modelValue.FBEShift(index * (_modelKey.FBESize + _modelValue.FBESize));
                return new KeyValuePair<TKeyModel, TValueModel>(_modelKey, _modelValue);
            }
        }

        // Resize the map and get its first model
        public KeyValuePair<TKeyModel, TValueModel> Resize(long size)
        {
            uint fbeMapSize = (uint)(size * (_modelKey.FBESize + _modelValue.FBESize));
            uint fbeMapOffset = (uint)(_buffer.Allocate(4 + fbeMapSize) - _buffer.Offset);
            Debug.Assert(((fbeMapOffset > 0) && ((_buffer.Offset + fbeMapOffset + 4) <= _buffer.Size)), "Model is broken!");

            Write(FBEOffset, fbeMapOffset);
            Write(fbeMapOffset, (uint)size);
            Write(fbeMapOffset + 4, 0, fbeMapSize);

            _modelKey.FBEOffset = fbeMapOffset + 4;
            _modelValue.FBEOffset = fbeMapOffset + 4 + _modelKey.FBESize;
            return new KeyValuePair<TKeyModel, TValueModel>(_modelKey, _modelValue);
        }

        // Check if the map is valid
        public virtual bool Verify()
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return true;

            uint fbeMapOffset = ReadUInt32(FBEOffset);
            if (fbeMapOffset == 0)
                return true;

            if ((_buffer.Offset + fbeMapOffset + 4) > _buffer.Size)
                return false;

            uint fbeMapSize = ReadUInt32(fbeMapOffset);

            _modelKey.FBEOffset = fbeMapOffset + 4;
            _modelValue.FBEOffset = fbeMapOffset + 4 + _modelKey.FBESize;
            for (uint i = fbeMapSize; i-- > 0;)
            {
                if (!_modelKey.Verify())
                    return false;
                _modelKey.FBEShift(_modelKey.FBESize + _modelValue.FBESize);
                if (!_modelValue.Verify())
                    return false;
                _modelValue.FBEShift(_modelKey.FBESize + _modelValue.FBESize);
            }

            return true;
        }

        // Get the map as Dictionary
        public void Get(ref Dictionary<TKey, TValue> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            values.Clear();

            long fbeMapSize = Size;
            if (fbeMapSize == 0)
                return;

            var fbeModel = this[0];
            for (long i = fbeMapSize; i-- > 0;)
            {
                fbeModel.Key.Get(out var key);
                fbeModel.Value.Get(out var value);
                values.Add(key, value);
                fbeModel.Key.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
                fbeModel.Value.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
            }
        }

        // Get the map as SortedDictionary
        public void Get(ref SortedDictionary<TKey, TValue> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            values.Clear();

            long fbeMapSize = Size;
            if (fbeMapSize == 0)
                return;

            var fbeModel = this[0];
            for (long i = fbeMapSize; i-- > 0;)
            {
                fbeModel.Key.Get(out var key);
                fbeModel.Value.Get(out var value);
                values.Add(key, value);
                fbeModel.Key.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
                fbeModel.Value.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
            }
        }

        // Set the map as Dictionary
        public void Set(Dictionary<TKey, TValue> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            var fbeModel = Resize(values.Count);
            foreach (var value in values)
            {
                fbeModel.Key.Set(value.Key);
                fbeModel.Key.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
                fbeModel.Value.Set(value.Value);
                fbeModel.Value.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
            }
        }

        // Set the map as SortedDictionary
        public void Set(SortedDictionary<TKey, TValue> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            var fbeModel = Resize(values.Count);
            foreach (var value in values)
            {
                fbeModel.Key.Set(value.Key);
                fbeModel.Key.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
                fbeModel.Value.Set(value.Value);
                fbeModel.Value.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
            }
        }
    }

    // Fast Binary Encoding field model map (value type key, reference type value)
    public class FieldModelMapValueTypeKeyReferenceTypeValue<TKey, TKeyModel, TValue, TValueModel> : FieldModelBase
        where TKey : struct
        where TKeyModel : FieldModelValueType<TKey>
        where TValue : class
        where TValueModel : FieldModelReferenceType<TValue>
    {
        private readonly TKeyModel _modelKey;
        private readonly TValueModel _modelValue;

        public FieldModelMapValueTypeKeyReferenceTypeValue(TKeyModel modelKey, TValueModel modelValue, Buffer buffer, long offset) : base(buffer, offset)
        {
            _modelKey = modelKey.Clone() as TKeyModel;
            _modelValue = modelValue.Clone() as TValueModel;
        }

        // Get the field size
        public override long FBESize => 4;
        // Get the field extra size
        public override long FBEExtra
        {
            get
            {
                if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                    return 0;

                uint fbeMapOffset = ReadUInt32(FBEOffset);
                if ((fbeMapOffset == 0) || ((_buffer.Offset + fbeMapOffset + 4) > _buffer.Size))
                    return 0;

                uint fbeMapSize = ReadUInt32(fbeMapOffset);

                long fbeResult = 4;
                _modelKey.FBEOffset = fbeMapOffset + 4;
                _modelValue.FBEOffset = fbeMapOffset + 4 + _modelKey.FBESize;
                for (uint i = fbeMapSize; i-- > 0;)
                {
                    fbeResult += _modelKey.FBESize + _modelKey.FBEExtra;
                    _modelKey.FBEShift(_modelKey.FBESize + _modelValue.FBESize);

                    fbeResult += _modelValue.FBESize + _modelValue.FBEExtra;
                    _modelValue.FBEShift(_modelKey.FBESize + _modelValue.FBESize);
                }
                return fbeResult;
            }
        }

        // Clone the field model
        public FieldModelMapValueTypeKeyReferenceTypeValue<TKey, TKeyModel, TValue, TValueModel> Clone() { return new FieldModelMapValueTypeKeyReferenceTypeValue<TKey, TKeyModel, TValue, TValueModel>(_modelKey, _modelValue, _buffer, _offset); }

        // Get the map offset
        public long Offset
        {
            get
            {
                if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                    return 0;

                uint fbeMapOffset = ReadUInt32(FBEOffset);
                return fbeMapOffset;
            }
        }

        // Get the map size
        public long Size
        {
            get
            {
                if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                    return 0;

                uint fbeMapOffset = ReadUInt32(FBEOffset);
                if ((fbeMapOffset == 0) || ((_buffer.Offset + fbeMapOffset + 4) > _buffer.Size))
                    return 0;

                uint fbeMapSize = ReadUInt32(fbeMapOffset);
                return fbeMapSize;
            }
        }

        // Map index operator
        public KeyValuePair<TKeyModel, TValueModel> this[long index]
        {
            get
            {
                Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");

                uint fbeMapOffset = ReadUInt32(FBEOffset);
                Debug.Assert(((fbeMapOffset > 0) && ((_buffer.Offset + fbeMapOffset + 4) <= _buffer.Size)), "Model is broken!");

                uint fbeMapSize = ReadUInt32(fbeMapOffset);
                Debug.Assert((index < fbeMapSize), "Index is out of bounds!");

                _modelKey.FBEOffset = fbeMapOffset + 4;
                _modelValue.FBEOffset = fbeMapOffset + 4 + _modelKey.FBESize;
                _modelKey.FBEShift(index * (_modelKey.FBESize + _modelValue.FBESize));
                _modelValue.FBEShift(index * (_modelKey.FBESize + _modelValue.FBESize));
                return new KeyValuePair<TKeyModel, TValueModel>(_modelKey, _modelValue);
            }
        }

        // Resize the map and get its first model
        public KeyValuePair<TKeyModel, TValueModel> Resize(long size)
        {
            uint fbeMapSize = (uint)(size * (_modelKey.FBESize + _modelValue.FBESize));
            uint fbeMapOffset = (uint)(_buffer.Allocate(4 + fbeMapSize) - _buffer.Offset);
            Debug.Assert(((fbeMapOffset > 0) && ((_buffer.Offset + fbeMapOffset + 4) <= _buffer.Size)), "Model is broken!");

            Write(FBEOffset, fbeMapOffset);
            Write(fbeMapOffset, (uint)size);
            Write(fbeMapOffset + 4, 0, fbeMapSize);

            _modelKey.FBEOffset = fbeMapOffset + 4;
            _modelValue.FBEOffset = fbeMapOffset + 4 + _modelKey.FBESize;
            return new KeyValuePair<TKeyModel, TValueModel>(_modelKey, _modelValue);
        }

        // Check if the map is valid
        public virtual bool Verify()
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return true;

            uint fbeMapOffset = ReadUInt32(FBEOffset);
            if (fbeMapOffset == 0)
                return true;

            if ((_buffer.Offset + fbeMapOffset + 4) > _buffer.Size)
                return false;

            uint fbeMapSize = ReadUInt32(fbeMapOffset);

            _modelKey.FBEOffset = fbeMapOffset + 4;
            _modelValue.FBEOffset = fbeMapOffset + 4 + _modelKey.FBESize;
            for (uint i = fbeMapSize; i-- > 0;)
            {
                if (!_modelKey.Verify())
                    return false;
                _modelKey.FBEShift(_modelKey.FBESize + _modelValue.FBESize);
                if (!_modelValue.Verify())
                    return false;
                _modelValue.FBEShift(_modelKey.FBESize + _modelValue.FBESize);
            }

            return true;
        }

        // Get the map as Dictionary
        public void Get(ref Dictionary<TKey, TValue> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            values.Clear();

            long fbeMapSize = Size;
            if (fbeMapSize == 0)
                return;

            var fbeModel = this[0];
            for (long i = fbeMapSize; i-- > 0;)
            {
                fbeModel.Key.Get(out var key);
                fbeModel.Value.Get(out var value);
                values.Add(key, value);
                fbeModel.Key.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
                fbeModel.Value.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
            }
        }

        // Get the map as SortedDictionary
        public void Get(ref SortedDictionary<TKey, TValue> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            values.Clear();

            long fbeMapSize = Size;
            if (fbeMapSize == 0)
                return;

            var fbeModel = this[0];
            for (long i = fbeMapSize; i-- > 0;)
            {
                fbeModel.Key.Get(out var key);
                fbeModel.Value.Get(out var value);
                values.Add(key, value);
                fbeModel.Key.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
                fbeModel.Value.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
            }
        }

        // Set the map as Dictionary
        public void Set(Dictionary<TKey, TValue> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            var fbeModel = Resize(values.Count);
            foreach (var value in values)
            {
                fbeModel.Key.Set(value.Key);
                fbeModel.Key.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
                fbeModel.Value.Set(value.Value);
                fbeModel.Value.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
            }
        }

        // Set the map as SortedDictionary
        public void Set(SortedDictionary<TKey, TValue> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            var fbeModel = Resize(values.Count);
            foreach (var value in values)
            {
                fbeModel.Key.Set(value.Key);
                fbeModel.Key.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
                fbeModel.Value.Set(value.Value);
                fbeModel.Value.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
            }
        }
    }

    // Fast Binary Encoding field model map (value type key, optional value type value)
    public class FieldModelMapValueTypeKeyOptionalValueTypeValue<TKey, TKeyModel, TValue, TValueModel> : FieldModelBase
        where TKey : struct
        where TKeyModel : FieldModelValueType<TKey>
        where TValue : struct
        where TValueModel : FieldModelValueType<TValue>
    {
        private readonly TKeyModel _modelKey;
        private readonly FieldModelOptionalValueType<TValue, TValueModel> _modelValue;

        public FieldModelMapValueTypeKeyOptionalValueTypeValue(TKeyModel modelKey, TValueModel modelValue, Buffer buffer, long offset) : base(buffer, offset)
        {
            _modelKey = modelKey.Clone() as TKeyModel;
            _modelValue = new FieldModelOptionalValueType<TValue, TValueModel>(modelValue, buffer, offset);
        }

        // Get the field size
        public override long FBESize => 4;
        // Get the field extra size
        public override long FBEExtra
        {
            get
            {
                if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                    return 0;

                uint fbeMapOffset = ReadUInt32(FBEOffset);
                if ((fbeMapOffset == 0) || ((_buffer.Offset + fbeMapOffset + 4) > _buffer.Size))
                    return 0;

                uint fbeMapSize = ReadUInt32(fbeMapOffset);

                long fbeResult = 4;
                _modelKey.FBEOffset = fbeMapOffset + 4;
                _modelValue.FBEOffset = fbeMapOffset + 4 + _modelKey.FBESize;
                for (uint i = fbeMapSize; i-- > 0;)
                {
                    fbeResult += _modelKey.FBESize + _modelKey.FBEExtra;
                    _modelKey.FBEShift(_modelKey.FBESize + _modelValue.FBESize);

                    fbeResult += _modelValue.FBESize + _modelValue.FBEExtra;
                    _modelValue.FBEShift(_modelKey.FBESize + _modelValue.FBESize);
                }
                return fbeResult;
            }
        }

        // Clone the field model
        public FieldModelMapValueTypeKeyOptionalValueTypeValue<TKey, TKeyModel, TValue, TValueModel> Clone() { return new FieldModelMapValueTypeKeyOptionalValueTypeValue<TKey, TKeyModel, TValue, TValueModel>(_modelKey, _modelValue.Value, _buffer, _offset); }

        // Get the map offset
        public long Offset
        {
            get
            {
                if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                    return 0;

                uint fbeMapOffset = ReadUInt32(FBEOffset);
                return fbeMapOffset;
            }
        }

        // Get the map size
        public long Size
        {
            get
            {
                if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                    return 0;

                uint fbeMapOffset = ReadUInt32(FBEOffset);
                if ((fbeMapOffset == 0) || ((_buffer.Offset + fbeMapOffset + 4) > _buffer.Size))
                    return 0;

                uint fbeMapSize = ReadUInt32(fbeMapOffset);
                return fbeMapSize;
            }
        }

        // Map index operator
        public KeyValuePair<TKeyModel, FieldModelOptionalValueType<TValue, TValueModel>> this[long index]
        {
            get
            {
                Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");

                uint fbeMapOffset = ReadUInt32(FBEOffset);
                Debug.Assert(((fbeMapOffset > 0) && ((_buffer.Offset + fbeMapOffset + 4) <= _buffer.Size)), "Model is broken!");

                uint fbeMapSize = ReadUInt32(fbeMapOffset);
                Debug.Assert((index < fbeMapSize), "Index is out of bounds!");

                _modelKey.FBEOffset = fbeMapOffset + 4;
                _modelValue.FBEOffset = fbeMapOffset + 4 + _modelKey.FBESize;
                _modelKey.FBEShift(index * (_modelKey.FBESize + _modelValue.FBESize));
                _modelValue.FBEShift(index * (_modelKey.FBESize + _modelValue.FBESize));
                return new KeyValuePair<TKeyModel, FieldModelOptionalValueType<TValue, TValueModel>>(_modelKey, _modelValue);
            }
        }

        // Resize the map and get its first model
        public KeyValuePair<TKeyModel, FieldModelOptionalValueType<TValue, TValueModel>> Resize(long size)
        {
            uint fbeMapSize = (uint)(size * (_modelKey.FBESize + _modelValue.FBESize));
            uint fbeMapOffset = (uint)(_buffer.Allocate(4 + fbeMapSize) - _buffer.Offset);
            Debug.Assert(((fbeMapOffset > 0) && ((_buffer.Offset + fbeMapOffset + 4) <= _buffer.Size)), "Model is broken!");

            Write(FBEOffset, fbeMapOffset);
            Write(fbeMapOffset, (uint)size);
            Write(fbeMapOffset + 4, 0, fbeMapSize);

            _modelKey.FBEOffset = fbeMapOffset + 4;
            _modelValue.FBEOffset = fbeMapOffset + 4 + _modelKey.FBESize;
            return new KeyValuePair<TKeyModel, FieldModelOptionalValueType<TValue, TValueModel>>(_modelKey, _modelValue);
        }

        // Check if the map is valid
        public virtual bool Verify()
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return true;

            uint fbeMapOffset = ReadUInt32(FBEOffset);
            if (fbeMapOffset == 0)
                return true;

            if ((_buffer.Offset + fbeMapOffset + 4) > _buffer.Size)
                return false;

            uint fbeMapSize = ReadUInt32(fbeMapOffset);

            _modelKey.FBEOffset = fbeMapOffset + 4;
            _modelValue.FBEOffset = fbeMapOffset + 4 + _modelKey.FBESize;
            for (uint i = fbeMapSize; i-- > 0;)
            {
                if (!_modelKey.Verify())
                    return false;
                _modelKey.FBEShift(_modelKey.FBESize + _modelValue.FBESize);
                if (!_modelValue.Verify())
                    return false;
                _modelValue.FBEShift(_modelKey.FBESize + _modelValue.FBESize);
            }

            return true;
        }

        // Get the map as Dictionary
        public void Get(ref Dictionary<TKey, TValue?> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            values.Clear();

            long fbeMapSize = Size;
            if (fbeMapSize == 0)
                return;

            var fbeModel = this[0];
            for (long i = fbeMapSize; i-- > 0;)
            {
                fbeModel.Key.Get(out var key);
                fbeModel.Value.Get(out var value);
                values.Add(key, value);
                fbeModel.Key.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
                fbeModel.Value.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
            }
        }

        // Get the map as SortedDictionary
        public void Get(ref SortedDictionary<TKey, TValue?> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            values.Clear();

            long fbeMapSize = Size;
            if (fbeMapSize == 0)
                return;

            var fbeModel = this[0];
            for (long i = fbeMapSize; i-- > 0;)
            {
                fbeModel.Key.Get(out var key);
                fbeModel.Value.Get(out var value);
                values.Add(key, value);
                fbeModel.Key.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
                fbeModel.Value.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
            }
        }

        // Set the map as Dictionary
        public void Set(Dictionary<TKey, TValue?> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            var fbeModel = Resize(values.Count);
            foreach (var value in values)
            {
                fbeModel.Key.Set(value.Key);
                fbeModel.Key.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
                fbeModel.Value.Set(value.Value);
                fbeModel.Value.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
            }
        }

        // Set the map as SortedDictionary
        public void Set(SortedDictionary<TKey, TValue?> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            var fbeModel = Resize(values.Count);
            foreach (var value in values)
            {
                fbeModel.Key.Set(value.Key);
                fbeModel.Key.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
                fbeModel.Value.Set(value.Value);
                fbeModel.Value.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
            }
        }
    }

    // Fast Binary Encoding field model map (value type key, optional reference type value)
    public class FieldModelMapValueTypeKeyOptionalReferenceTypeValue<TKey, TKeyModel, TValue, TValueModel> : FieldModelBase
        where TKey : struct
        where TKeyModel : FieldModelValueType<TKey>
        where TValue : class
        where TValueModel : FieldModelReferenceType<TValue>
    {
        private readonly TKeyModel _modelKey;
        private readonly FieldModelOptionalReferenceType<TValue, TValueModel> _modelValue;

        public FieldModelMapValueTypeKeyOptionalReferenceTypeValue(TKeyModel modelKey, TValueModel modelValue, Buffer buffer, long offset) : base(buffer, offset)
        {
            _modelKey = modelKey.Clone() as TKeyModel;
            _modelValue = new FieldModelOptionalReferenceType<TValue, TValueModel>(modelValue, buffer, offset);
        }

        // Get the field size
        public override long FBESize => 4;
        // Get the field extra size
        public override long FBEExtra
        {
            get
            {
                if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                    return 0;

                uint fbeMapOffset = ReadUInt32(FBEOffset);
                if ((fbeMapOffset == 0) || ((_buffer.Offset + fbeMapOffset + 4) > _buffer.Size))
                    return 0;

                uint fbeMapSize = ReadUInt32(fbeMapOffset);

                long fbeResult = 4;
                _modelKey.FBEOffset = fbeMapOffset + 4;
                _modelValue.FBEOffset = fbeMapOffset + 4 + _modelKey.FBESize;
                for (uint i = fbeMapSize; i-- > 0;)
                {
                    fbeResult += _modelKey.FBESize + _modelKey.FBEExtra;
                    _modelKey.FBEShift(_modelKey.FBESize + _modelValue.FBESize);

                    fbeResult += _modelValue.FBESize + _modelValue.FBEExtra;
                    _modelValue.FBEShift(_modelKey.FBESize + _modelValue.FBESize);
                }
                return fbeResult;
            }
        }

        // Clone the field model
        public FieldModelMapValueTypeKeyOptionalReferenceTypeValue<TKey, TKeyModel, TValue, TValueModel> Clone() { return new FieldModelMapValueTypeKeyOptionalReferenceTypeValue<TKey, TKeyModel, TValue, TValueModel>(_modelKey, _modelValue.Value, _buffer, _offset); }

        // Get the map offset
        public long Offset
        {
            get
            {
                if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                    return 0;

                uint fbeMapOffset = ReadUInt32(FBEOffset);
                return fbeMapOffset;
            }
        }

        // Get the map size
        public long Size
        {
            get
            {
                if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                    return 0;

                uint fbeMapOffset = ReadUInt32(FBEOffset);
                if ((fbeMapOffset == 0) || ((_buffer.Offset + fbeMapOffset + 4) > _buffer.Size))
                    return 0;

                uint fbeMapSize = ReadUInt32(fbeMapOffset);
                return fbeMapSize;
            }
        }

        // Map index operator
        public KeyValuePair<TKeyModel, FieldModelOptionalReferenceType<TValue, TValueModel>> this[long index]
        {
            get
            {
                Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");

                uint fbeMapOffset = ReadUInt32(FBEOffset);
                Debug.Assert(((fbeMapOffset > 0) && ((_buffer.Offset + fbeMapOffset + 4) <= _buffer.Size)), "Model is broken!");

                uint fbeMapSize = ReadUInt32(fbeMapOffset);
                Debug.Assert((index < fbeMapSize), "Index is out of bounds!");

                _modelKey.FBEOffset = fbeMapOffset + 4;
                _modelValue.FBEOffset = fbeMapOffset + 4 + _modelKey.FBESize;
                _modelKey.FBEShift(index * (_modelKey.FBESize + _modelValue.FBESize));
                _modelValue.FBEShift(index * (_modelKey.FBESize + _modelValue.FBESize));
                return new KeyValuePair<TKeyModel, FieldModelOptionalReferenceType<TValue, TValueModel>>(_modelKey, _modelValue);
            }
        }

        // Resize the map and get its first model
        public KeyValuePair<TKeyModel, FieldModelOptionalReferenceType<TValue, TValueModel>> Resize(long size)
        {
            uint fbeMapSize = (uint)(size * (_modelKey.FBESize + _modelValue.FBESize));
            uint fbeMapOffset = (uint)(_buffer.Allocate(4 + fbeMapSize) - _buffer.Offset);
            Debug.Assert(((fbeMapOffset > 0) && ((_buffer.Offset + fbeMapOffset + 4) <= _buffer.Size)), "Model is broken!");

            Write(FBEOffset, fbeMapOffset);
            Write(fbeMapOffset, (uint)size);
            Write(fbeMapOffset + 4, 0, fbeMapSize);

            _modelKey.FBEOffset = fbeMapOffset + 4;
            _modelValue.FBEOffset = fbeMapOffset + 4 + _modelKey.FBESize;
            return new KeyValuePair<TKeyModel, FieldModelOptionalReferenceType<TValue, TValueModel>>(_modelKey, _modelValue);
        }

        // Check if the map is valid
        public virtual bool Verify()
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return true;

            uint fbeMapOffset = ReadUInt32(FBEOffset);
            if (fbeMapOffset == 0)
                return true;

            if ((_buffer.Offset + fbeMapOffset + 4) > _buffer.Size)
                return false;

            uint fbeMapSize = ReadUInt32(fbeMapOffset);

            _modelKey.FBEOffset = fbeMapOffset + 4;
            _modelValue.FBEOffset = fbeMapOffset + 4 + _modelKey.FBESize;
            for (uint i = fbeMapSize; i-- > 0;)
            {
                if (!_modelKey.Verify())
                    return false;
                _modelKey.FBEShift(_modelKey.FBESize + _modelValue.FBESize);
                if (!_modelValue.Verify())
                    return false;
                _modelValue.FBEShift(_modelKey.FBESize + _modelValue.FBESize);
            }

            return true;
        }

        // Get the map as Dictionary
        public void Get(ref Dictionary<TKey, TValue> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            values.Clear();

            long fbeMapSize = Size;
            if (fbeMapSize == 0)
                return;

            var fbeModel = this[0];
            for (long i = fbeMapSize; i-- > 0;)
            {
                fbeModel.Key.Get(out var key);
                fbeModel.Value.Get(out var value);
                values.Add(key, value);
                fbeModel.Key.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
                fbeModel.Value.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
            }
        }

        // Get the map as SortedDictionary
        public void Get(ref SortedDictionary<TKey, TValue> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            values.Clear();

            long fbeMapSize = Size;
            if (fbeMapSize == 0)
                return;

            var fbeModel = this[0];
            for (long i = fbeMapSize; i-- > 0;)
            {
                fbeModel.Key.Get(out var key);
                fbeModel.Value.Get(out var value);
                values.Add(key, value);
                fbeModel.Key.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
                fbeModel.Value.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
            }
        }

        // Set the map as Dictionary
        public void Set(Dictionary<TKey, TValue> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            var fbeModel = Resize(values.Count);
            foreach (var value in values)
            {
                fbeModel.Key.Set(value.Key);
                fbeModel.Key.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
                fbeModel.Value.Set(value.Value);
                fbeModel.Value.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
            }
        }

        // Set the map as SortedDictionary
        public void Set(SortedDictionary<TKey, TValue> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            var fbeModel = Resize(values.Count);
            foreach (var value in values)
            {
                fbeModel.Key.Set(value.Key);
                fbeModel.Key.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
                fbeModel.Value.Set(value.Value);
                fbeModel.Value.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
            }
        }
    }

    // Fast Binary Encoding field model map (reference type key, value type value)
    public class FieldModelMapReferenceTypeKeyValueTypeValue<TKey, TKeyModel, TValue, TValueModel> : FieldModelBase
        where TKey : class
        where TKeyModel : FieldModelReferenceType<TKey>
        where TValue : struct
        where TValueModel : FieldModelValueType<TValue>
    {
        private readonly TKeyModel _modelKey;
        private readonly TValueModel _modelValue;

        public FieldModelMapReferenceTypeKeyValueTypeValue(TKeyModel modelKey, TValueModel modelValue, Buffer buffer, long offset) : base(buffer, offset)
        {
            _modelKey = modelKey.Clone() as TKeyModel;
            _modelValue = modelValue.Clone() as TValueModel;
        }

        // Get the field size
        public override long FBESize => 4;
        // Get the field extra size
        public override long FBEExtra
        {
            get
            {
                if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                    return 0;

                uint fbeMapOffset = ReadUInt32(FBEOffset);
                if ((fbeMapOffset == 0) || ((_buffer.Offset + fbeMapOffset + 4) > _buffer.Size))
                    return 0;

                uint fbeMapSize = ReadUInt32(fbeMapOffset);

                long fbeResult = 4;
                _modelKey.FBEOffset = fbeMapOffset + 4;
                _modelValue.FBEOffset = fbeMapOffset + 4 + _modelKey.FBESize;
                for (uint i = fbeMapSize; i-- > 0;)
                {
                    fbeResult += _modelKey.FBESize + _modelKey.FBEExtra;
                    _modelKey.FBEShift(_modelKey.FBESize + _modelValue.FBESize);

                    fbeResult += _modelValue.FBESize + _modelValue.FBEExtra;
                    _modelValue.FBEShift(_modelKey.FBESize + _modelValue.FBESize);
                }
                return fbeResult;
            }
        }

        // Clone the field model
        public FieldModelMapReferenceTypeKeyValueTypeValue<TKey, TKeyModel, TValue, TValueModel> Clone() { return new FieldModelMapReferenceTypeKeyValueTypeValue<TKey, TKeyModel, TValue, TValueModel>(_modelKey, _modelValue, _buffer, _offset); }

        // Get the map offset
        public long Offset
        {
            get
            {
                if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                    return 0;

                uint fbeMapOffset = ReadUInt32(FBEOffset);
                return fbeMapOffset;
            }
        }

        // Get the map size
        public long Size
        {
            get
            {
                if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                    return 0;

                uint fbeMapOffset = ReadUInt32(FBEOffset);
                if ((fbeMapOffset == 0) || ((_buffer.Offset + fbeMapOffset + 4) > _buffer.Size))
                    return 0;

                uint fbeMapSize = ReadUInt32(fbeMapOffset);
                return fbeMapSize;
            }
        }

        // Map index operator
        public KeyValuePair<TKeyModel, TValueModel> this[long index]
        {
            get
            {
                Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");

                uint fbeMapOffset = ReadUInt32(FBEOffset);
                Debug.Assert(((fbeMapOffset > 0) && ((_buffer.Offset + fbeMapOffset + 4) <= _buffer.Size)), "Model is broken!");

                uint fbeMapSize = ReadUInt32(fbeMapOffset);
                Debug.Assert((index < fbeMapSize), "Index is out of bounds!");

                _modelKey.FBEOffset = fbeMapOffset + 4;
                _modelValue.FBEOffset = fbeMapOffset + 4 + _modelKey.FBESize;
                _modelKey.FBEShift(index * (_modelKey.FBESize + _modelValue.FBESize));
                _modelValue.FBEShift(index * (_modelKey.FBESize + _modelValue.FBESize));
                return new KeyValuePair<TKeyModel, TValueModel>(_modelKey, _modelValue);
            }
        }

        // Resize the map and get its first model
        public KeyValuePair<TKeyModel, TValueModel> Resize(long size)
        {
            uint fbeMapSize = (uint)(size * (_modelKey.FBESize + _modelValue.FBESize));
            uint fbeMapOffset = (uint)(_buffer.Allocate(4 + fbeMapSize) - _buffer.Offset);
            Debug.Assert(((fbeMapOffset > 0) && ((_buffer.Offset + fbeMapOffset + 4) <= _buffer.Size)), "Model is broken!");

            Write(FBEOffset, fbeMapOffset);
            Write(fbeMapOffset, (uint)size);
            Write(fbeMapOffset + 4, 0, fbeMapSize);

            _modelKey.FBEOffset = fbeMapOffset + 4;
            _modelValue.FBEOffset = fbeMapOffset + 4 + _modelKey.FBESize;
            return new KeyValuePair<TKeyModel, TValueModel>(_modelKey, _modelValue);
        }

        // Check if the map is valid
        public virtual bool Verify()
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return true;

            uint fbeMapOffset = ReadUInt32(FBEOffset);
            if (fbeMapOffset == 0)
                return true;

            if ((_buffer.Offset + fbeMapOffset + 4) > _buffer.Size)
                return false;

            uint fbeMapSize = ReadUInt32(fbeMapOffset);

            _modelKey.FBEOffset = fbeMapOffset + 4;
            _modelValue.FBEOffset = fbeMapOffset + 4 + _modelKey.FBESize;
            for (uint i = fbeMapSize; i-- > 0;)
            {
                if (!_modelKey.Verify())
                    return false;
                _modelKey.FBEShift(_modelKey.FBESize + _modelValue.FBESize);
                if (!_modelValue.Verify())
                    return false;
                _modelValue.FBEShift(_modelKey.FBESize + _modelValue.FBESize);
            }

            return true;
        }

        // Get the map as Dictionary
        public void Get(ref Dictionary<TKey, TValue> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            values.Clear();

            long fbeMapSize = Size;
            if (fbeMapSize == 0)
                return;

            var fbeModel = this[0];
            for (long i = fbeMapSize; i-- > 0;)
            {
                fbeModel.Key.Get(out var key);
                fbeModel.Value.Get(out var value);
                values.Add(key, value);
                fbeModel.Key.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
                fbeModel.Value.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
            }
        }

        // Get the map as SortedDictionary
        public void Get(ref SortedDictionary<TKey, TValue> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            values.Clear();

            long fbeMapSize = Size;
            if (fbeMapSize == 0)
                return;

            var fbeModel = this[0];
            for (long i = fbeMapSize; i-- > 0;)
            {
                fbeModel.Key.Get(out var key);
                fbeModel.Value.Get(out var value);
                values.Add(key, value);
                fbeModel.Key.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
                fbeModel.Value.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
            }
        }

        // Set the map as Dictionary
        public void Set(Dictionary<TKey, TValue> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            var fbeModel = Resize(values.Count);
            foreach (var value in values)
            {
                fbeModel.Key.Set(value.Key);
                fbeModel.Key.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
                fbeModel.Value.Set(value.Value);
                fbeModel.Value.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
            }
        }

        // Set the map as SortedDictionary
        public void Set(SortedDictionary<TKey, TValue> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            var fbeModel = Resize(values.Count);
            foreach (var value in values)
            {
                fbeModel.Key.Set(value.Key);
                fbeModel.Key.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
                fbeModel.Value.Set(value.Value);
                fbeModel.Value.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
            }
        }
    }

    // Fast Binary Encoding field model map (reference type key, reference type value)
    public class FieldModelMapReferenceTypeKeyReferenceTypeValue<TKey, TKeyModel, TValue, TValueModel> : FieldModelBase
        where TKey : class
        where TKeyModel : FieldModelReferenceType<TKey>
        where TValue : class
        where TValueModel : FieldModelReferenceType<TValue>
    {
        private readonly TKeyModel _modelKey;
        private readonly TValueModel _modelValue;

        public FieldModelMapReferenceTypeKeyReferenceTypeValue(TKeyModel modelKey, TValueModel modelValue, Buffer buffer, long offset) : base(buffer, offset)
        {
            _modelKey = modelKey.Clone() as TKeyModel;
            _modelValue = modelValue.Clone() as TValueModel;
        }

        // Get the field size
        public override long FBESize => 4;
        // Get the field extra size
        public override long FBEExtra
        {
            get
            {
                if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                    return 0;

                uint fbeMapOffset = ReadUInt32(FBEOffset);
                if ((fbeMapOffset == 0) || ((_buffer.Offset + fbeMapOffset + 4) > _buffer.Size))
                    return 0;

                uint fbeMapSize = ReadUInt32(fbeMapOffset);

                long fbeResult = 4;
                _modelKey.FBEOffset = fbeMapOffset + 4;
                _modelValue.FBEOffset = fbeMapOffset + 4 + _modelKey.FBESize;
                for (uint i = fbeMapSize; i-- > 0;)
                {
                    fbeResult += _modelKey.FBESize + _modelKey.FBEExtra;
                    _modelKey.FBEShift(_modelKey.FBESize + _modelValue.FBESize);

                    fbeResult += _modelValue.FBESize + _modelValue.FBEExtra;
                    _modelValue.FBEShift(_modelKey.FBESize + _modelValue.FBESize);
                }
                return fbeResult;
            }
        }

        // Clone the field model
        public FieldModelMapReferenceTypeKeyReferenceTypeValue<TKey, TKeyModel, TValue, TValueModel> Clone() { return new FieldModelMapReferenceTypeKeyReferenceTypeValue<TKey, TKeyModel, TValue, TValueModel>(_modelKey, _modelValue, _buffer, _offset); }

        // Get the map offset
        public long Offset
        {
            get
            {
                if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                    return 0;

                uint fbeMapOffset = ReadUInt32(FBEOffset);
                return fbeMapOffset;
            }
        }

        // Get the map size
        public long Size
        {
            get
            {
                if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                    return 0;

                uint fbeMapOffset = ReadUInt32(FBEOffset);
                if ((fbeMapOffset == 0) || ((_buffer.Offset + fbeMapOffset + 4) > _buffer.Size))
                    return 0;

                uint fbeMapSize = ReadUInt32(fbeMapOffset);
                return fbeMapSize;
            }
        }

        // Map index operator
        public KeyValuePair<TKeyModel, TValueModel> this[long index]
        {
            get
            {
                Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");

                uint fbeMapOffset = ReadUInt32(FBEOffset);
                Debug.Assert(((fbeMapOffset > 0) && ((_buffer.Offset + fbeMapOffset + 4) <= _buffer.Size)), "Model is broken!");

                uint fbeMapSize = ReadUInt32(fbeMapOffset);
                Debug.Assert((index < fbeMapSize), "Index is out of bounds!");

                _modelKey.FBEOffset = fbeMapOffset + 4;
                _modelValue.FBEOffset = fbeMapOffset + 4 + _modelKey.FBESize;
                _modelKey.FBEShift(index * (_modelKey.FBESize + _modelValue.FBESize));
                _modelValue.FBEShift(index * (_modelKey.FBESize + _modelValue.FBESize));
                return new KeyValuePair<TKeyModel, TValueModel>(_modelKey, _modelValue);
            }
        }

        // Resize the map and get its first model
        public KeyValuePair<TKeyModel, TValueModel> Resize(long size)
        {
            uint fbeMapSize = (uint)(size * (_modelKey.FBESize + _modelValue.FBESize));
            uint fbeMapOffset = (uint)(_buffer.Allocate(4 + fbeMapSize) - _buffer.Offset);
            Debug.Assert(((fbeMapOffset > 0) && ((_buffer.Offset + fbeMapOffset + 4) <= _buffer.Size)), "Model is broken!");

            Write(FBEOffset, fbeMapOffset);
            Write(fbeMapOffset, (uint)size);
            Write(fbeMapOffset + 4, 0, fbeMapSize);

            _modelKey.FBEOffset = fbeMapOffset + 4;
            _modelValue.FBEOffset = fbeMapOffset + 4 + _modelKey.FBESize;
            return new KeyValuePair<TKeyModel, TValueModel>(_modelKey, _modelValue);
        }

        // Check if the map is valid
        public virtual bool Verify()
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return true;

            uint fbeMapOffset = ReadUInt32(FBEOffset);
            if (fbeMapOffset == 0)
                return true;

            if ((_buffer.Offset + fbeMapOffset + 4) > _buffer.Size)
                return false;

            uint fbeMapSize = ReadUInt32(fbeMapOffset);

            _modelKey.FBEOffset = fbeMapOffset + 4;
            _modelValue.FBEOffset = fbeMapOffset + 4 + _modelKey.FBESize;
            for (uint i = fbeMapSize; i-- > 0;)
            {
                if (!_modelKey.Verify())
                    return false;
                _modelKey.FBEShift(_modelKey.FBESize + _modelValue.FBESize);
                if (!_modelValue.Verify())
                    return false;
                _modelValue.FBEShift(_modelKey.FBESize + _modelValue.FBESize);
            }

            return true;
        }

        // Get the map as Dictionary
        public void Get(ref Dictionary<TKey, TValue> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            values.Clear();

            long fbeMapSize = Size;
            if (fbeMapSize == 0)
                return;

            var fbeModel = this[0];
            for (long i = fbeMapSize; i-- > 0;)
            {
                fbeModel.Key.Get(out var key);
                fbeModel.Value.Get(out var value);
                values.Add(key, value);
                fbeModel.Key.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
                fbeModel.Value.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
            }
        }

        // Get the map as SortedDictionary
        public void Get(ref SortedDictionary<TKey, TValue> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            values.Clear();

            long fbeMapSize = Size;
            if (fbeMapSize == 0)
                return;

            var fbeModel = this[0];
            for (long i = fbeMapSize; i-- > 0;)
            {
                fbeModel.Key.Get(out var key);
                fbeModel.Value.Get(out var value);
                values.Add(key, value);
                fbeModel.Key.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
                fbeModel.Value.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
            }
        }

        // Set the map as Dictionary
        public void Set(Dictionary<TKey, TValue> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            var fbeModel = Resize(values.Count);
            foreach (var value in values)
            {
                fbeModel.Key.Set(value.Key);
                fbeModel.Key.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
                fbeModel.Value.Set(value.Value);
                fbeModel.Value.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
            }
        }

        // Set the map as SortedDictionary
        public void Set(SortedDictionary<TKey, TValue> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            var fbeModel = Resize(values.Count);
            foreach (var value in values)
            {
                fbeModel.Key.Set(value.Key);
                fbeModel.Key.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
                fbeModel.Value.Set(value.Value);
                fbeModel.Value.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
            }
        }
    }

    // Fast Binary Encoding field model map (reference type key, optional value type value)
    public class FieldModelMapReferenceTypeKeyOptionalValueTypeValue<TKey, TKeyModel, TValue, TValueModel> : FieldModelBase
        where TKey : class
        where TKeyModel : FieldModelReferenceType<TKey>
        where TValue : struct
        where TValueModel : FieldModelValueType<TValue>
    {
        private readonly TKeyModel _modelKey;
        private readonly FieldModelOptionalValueType<TValue, TValueModel> _modelValue;

        public FieldModelMapReferenceTypeKeyOptionalValueTypeValue(TKeyModel modelKey, TValueModel modelValue, Buffer buffer, long offset) : base(buffer, offset)
        {
            _modelKey = modelKey.Clone() as TKeyModel;
            _modelValue = new FieldModelOptionalValueType<TValue, TValueModel>(modelValue, buffer, offset);
        }

        // Get the field size
        public override long FBESize => 4;
        // Get the field extra size
        public override long FBEExtra
        {
            get
            {
                if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                    return 0;

                uint fbeMapOffset = ReadUInt32(FBEOffset);
                if ((fbeMapOffset == 0) || ((_buffer.Offset + fbeMapOffset + 4) > _buffer.Size))
                    return 0;

                uint fbeMapSize = ReadUInt32(fbeMapOffset);

                long fbeResult = 4;
                _modelKey.FBEOffset = fbeMapOffset + 4;
                _modelValue.FBEOffset = fbeMapOffset + 4 + _modelKey.FBESize;
                for (uint i = fbeMapSize; i-- > 0;)
                {
                    fbeResult += _modelKey.FBESize + _modelKey.FBEExtra;
                    _modelKey.FBEShift(_modelKey.FBESize + _modelValue.FBESize);

                    fbeResult += _modelValue.FBESize + _modelValue.FBEExtra;
                    _modelValue.FBEShift(_modelKey.FBESize + _modelValue.FBESize);
                }
                return fbeResult;
            }
        }

        // Clone the field model
        public FieldModelMapReferenceTypeKeyOptionalValueTypeValue<TKey, TKeyModel, TValue, TValueModel> Clone() { return new FieldModelMapReferenceTypeKeyOptionalValueTypeValue<TKey, TKeyModel, TValue, TValueModel>(_modelKey, _modelValue.Value, _buffer, _offset); }

        // Get the map offset
        public long Offset
        {
            get
            {
                if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                    return 0;

                uint fbeMapOffset = ReadUInt32(FBEOffset);
                return fbeMapOffset;
            }
        }

        // Get the map size
        public long Size
        {
            get
            {
                if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                    return 0;

                uint fbeMapOffset = ReadUInt32(FBEOffset);
                if ((fbeMapOffset == 0) || ((_buffer.Offset + fbeMapOffset + 4) > _buffer.Size))
                    return 0;

                uint fbeMapSize = ReadUInt32(fbeMapOffset);
                return fbeMapSize;
            }
        }

        // Map index operator
        public KeyValuePair<TKeyModel, FieldModelOptionalValueType<TValue, TValueModel>> this[long index]
        {
            get
            {
                Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");

                uint fbeMapOffset = ReadUInt32(FBEOffset);
                Debug.Assert(((fbeMapOffset > 0) && ((_buffer.Offset + fbeMapOffset + 4) <= _buffer.Size)), "Model is broken!");

                uint fbeMapSize = ReadUInt32(fbeMapOffset);
                Debug.Assert((index < fbeMapSize), "Index is out of bounds!");

                _modelKey.FBEOffset = fbeMapOffset + 4;
                _modelValue.FBEOffset = fbeMapOffset + 4 + _modelKey.FBESize;
                _modelKey.FBEShift(index * (_modelKey.FBESize + _modelValue.FBESize));
                _modelValue.FBEShift(index * (_modelKey.FBESize + _modelValue.FBESize));
                return new KeyValuePair<TKeyModel, FieldModelOptionalValueType<TValue, TValueModel>>(_modelKey, _modelValue);
            }
        }

        // Resize the map and get its first model
        public KeyValuePair<TKeyModel, FieldModelOptionalValueType<TValue, TValueModel>> Resize(long size)
        {
            uint fbeMapSize = (uint)(size * (_modelKey.FBESize + _modelValue.FBESize));
            uint fbeMapOffset = (uint)(_buffer.Allocate(4 + fbeMapSize) - _buffer.Offset);
            Debug.Assert(((fbeMapOffset > 0) && ((_buffer.Offset + fbeMapOffset + 4) <= _buffer.Size)), "Model is broken!");

            Write(FBEOffset, fbeMapOffset);
            Write(fbeMapOffset, (uint)size);
            Write(fbeMapOffset + 4, 0, fbeMapSize);

            _modelKey.FBEOffset = fbeMapOffset + 4;
            _modelValue.FBEOffset = fbeMapOffset + 4 + _modelKey.FBESize;
            return new KeyValuePair<TKeyModel, FieldModelOptionalValueType<TValue, TValueModel>>(_modelKey, _modelValue);
        }

        // Check if the map is valid
        public virtual bool Verify()
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return true;

            uint fbeMapOffset = ReadUInt32(FBEOffset);
            if (fbeMapOffset == 0)
                return true;

            if ((_buffer.Offset + fbeMapOffset + 4) > _buffer.Size)
                return false;

            uint fbeMapSize = ReadUInt32(fbeMapOffset);

            _modelKey.FBEOffset = fbeMapOffset + 4;
            _modelValue.FBEOffset = fbeMapOffset + 4 + _modelKey.FBESize;
            for (uint i = fbeMapSize; i-- > 0;)
            {
                if (!_modelKey.Verify())
                    return false;
                _modelKey.FBEShift(_modelKey.FBESize + _modelValue.FBESize);
                if (!_modelValue.Verify())
                    return false;
                _modelValue.FBEShift(_modelKey.FBESize + _modelValue.FBESize);
            }

            return true;
        }

        // Get the map as Dictionary
        public void Get(ref Dictionary<TKey, TValue?> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            values.Clear();

            long fbeMapSize = Size;
            if (fbeMapSize == 0)
                return;

            var fbeModel = this[0];
            for (long i = fbeMapSize; i-- > 0;)
            {
                fbeModel.Key.Get(out var key);
                fbeModel.Value.Get(out var value);
                values.Add(key, value);
                fbeModel.Key.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
                fbeModel.Value.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
            }
        }

        // Get the map as SortedDictionary
        public void Get(ref SortedDictionary<TKey, TValue?> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            values.Clear();

            long fbeMapSize = Size;
            if (fbeMapSize == 0)
                return;

            var fbeModel = this[0];
            for (long i = fbeMapSize; i-- > 0;)
            {
                fbeModel.Key.Get(out var key);
                fbeModel.Value.Get(out var value);
                values.Add(key, value);
                fbeModel.Key.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
                fbeModel.Value.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
            }
        }

        // Set the map as Dictionary
        public void Set(Dictionary<TKey, TValue?> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            var fbeModel = Resize(values.Count);
            foreach (var value in values)
            {
                fbeModel.Key.Set(value.Key);
                fbeModel.Key.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
                fbeModel.Value.Set(value.Value);
                fbeModel.Value.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
            }
        }

        // Set the map as SortedDictionary
        public void Set(SortedDictionary<TKey, TValue?> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            var fbeModel = Resize(values.Count);
            foreach (var value in values)
            {
                fbeModel.Key.Set(value.Key);
                fbeModel.Key.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
                fbeModel.Value.Set(value.Value);
                fbeModel.Value.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
            }
        }
    }

    // Fast Binary Encoding field model map (reference type key, optional reference type value)
    public class FieldModelMapReferenceTypeKeyOptionalReferenceTypeValue<TKey, TKeyModel, TValue, TValueModel> : FieldModelBase
        where TKey : class
        where TKeyModel : FieldModelReferenceType<TKey>
        where TValue : class
        where TValueModel : FieldModelReferenceType<TValue>
    {
        private readonly TKeyModel _modelKey;
        private readonly FieldModelOptionalReferenceType<TValue, TValueModel> _modelValue;

        public FieldModelMapReferenceTypeKeyOptionalReferenceTypeValue(TKeyModel modelKey, TValueModel modelValue, Buffer buffer, long offset) : base(buffer, offset)
        {
            _modelKey = modelKey.Clone() as TKeyModel;
            _modelValue = new FieldModelOptionalReferenceType<TValue, TValueModel>(modelValue, buffer, offset);
        }

        // Get the field size
        public override long FBESize => 4;
        // Get the field extra size
        public override long FBEExtra
        {
            get
            {
                if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                    return 0;

                uint fbeMapOffset = ReadUInt32(FBEOffset);
                if ((fbeMapOffset == 0) || ((_buffer.Offset + fbeMapOffset + 4) > _buffer.Size))
                    return 0;

                uint fbeMapSize = ReadUInt32(fbeMapOffset);

                long fbeResult = 4;
                _modelKey.FBEOffset = fbeMapOffset + 4;
                _modelValue.FBEOffset = fbeMapOffset + 4 + _modelKey.FBESize;
                for (uint i = fbeMapSize; i-- > 0;)
                {
                    fbeResult += _modelKey.FBESize + _modelKey.FBEExtra;
                    _modelKey.FBEShift(_modelKey.FBESize + _modelValue.FBESize);

                    fbeResult += _modelValue.FBESize + _modelValue.FBEExtra;
                    _modelValue.FBEShift(_modelKey.FBESize + _modelValue.FBESize);
                }
                return fbeResult;
            }
        }

        // Clone the field model
        public FieldModelMapReferenceTypeKeyOptionalReferenceTypeValue<TKey, TKeyModel, TValue, TValueModel> Clone() { return new FieldModelMapReferenceTypeKeyOptionalReferenceTypeValue<TKey, TKeyModel, TValue, TValueModel>(_modelKey, _modelValue.Value, _buffer, _offset); }

        // Get the map offset
        public long Offset
        {
            get
            {
                if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                    return 0;

                uint fbeMapOffset = ReadUInt32(FBEOffset);
                return fbeMapOffset;
            }
        }

        // Get the map size
        public long Size
        {
            get
            {
                if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                    return 0;

                uint fbeMapOffset = ReadUInt32(FBEOffset);
                if ((fbeMapOffset == 0) || ((_buffer.Offset + fbeMapOffset + 4) > _buffer.Size))
                    return 0;

                uint fbeMapSize = ReadUInt32(fbeMapOffset);
                return fbeMapSize;
            }
        }

        // Map index operator
        public KeyValuePair<TKeyModel, FieldModelOptionalReferenceType<TValue, TValueModel>> this[long index]
        {
            get
            {
                Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");

                uint fbeMapOffset = ReadUInt32(FBEOffset);
                Debug.Assert(((fbeMapOffset > 0) && ((_buffer.Offset + fbeMapOffset + 4) <= _buffer.Size)), "Model is broken!");

                uint fbeMapSize = ReadUInt32(fbeMapOffset);
                Debug.Assert((index < fbeMapSize), "Index is out of bounds!");

                _modelKey.FBEOffset = fbeMapOffset + 4;
                _modelValue.FBEOffset = fbeMapOffset + 4 + _modelKey.FBESize;
                _modelKey.FBEShift(index * (_modelKey.FBESize + _modelValue.FBESize));
                _modelValue.FBEShift(index * (_modelKey.FBESize + _modelValue.FBESize));
                return new KeyValuePair<TKeyModel, FieldModelOptionalReferenceType<TValue, TValueModel>>(_modelKey, _modelValue);
            }
        }

        // Resize the map and get its first model
        public KeyValuePair<TKeyModel, FieldModelOptionalReferenceType<TValue, TValueModel>> Resize(long size)
        {
            uint fbeMapSize = (uint)(size * (_modelKey.FBESize + _modelValue.FBESize));
            uint fbeMapOffset = (uint)(_buffer.Allocate(4 + fbeMapSize) - _buffer.Offset);
            Debug.Assert(((fbeMapOffset > 0) && ((_buffer.Offset + fbeMapOffset + 4) <= _buffer.Size)), "Model is broken!");

            Write(FBEOffset, fbeMapOffset);
            Write(fbeMapOffset, (uint)size);
            Write(fbeMapOffset + 4, 0, fbeMapSize);

            _modelKey.FBEOffset = fbeMapOffset + 4;
            _modelValue.FBEOffset = fbeMapOffset + 4 + _modelKey.FBESize;
            return new KeyValuePair<TKeyModel, FieldModelOptionalReferenceType<TValue, TValueModel>>(_modelKey, _modelValue);
        }

        // Check if the map is valid
        public virtual bool Verify()
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return true;

            uint fbeMapOffset = ReadUInt32(FBEOffset);
            if (fbeMapOffset == 0)
                return true;

            if ((_buffer.Offset + fbeMapOffset + 4) > _buffer.Size)
                return false;

            uint fbeMapSize = ReadUInt32(fbeMapOffset);

            _modelKey.FBEOffset = fbeMapOffset + 4;
            _modelValue.FBEOffset = fbeMapOffset + 4 + _modelKey.FBESize;
            for (uint i = fbeMapSize; i-- > 0;)
            {
                if (!_modelKey.Verify())
                    return false;
                _modelKey.FBEShift(_modelKey.FBESize + _modelValue.FBESize);
                if (!_modelValue.Verify())
                    return false;
                _modelValue.FBEShift(_modelKey.FBESize + _modelValue.FBESize);
            }

            return true;
        }

        // Get the map as Dictionary
        public void Get(ref Dictionary<TKey, TValue> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            values.Clear();

            long fbeMapSize = Size;
            if (fbeMapSize == 0)
                return;

            var fbeModel = this[0];
            for (long i = fbeMapSize; i-- > 0;)
            {
                fbeModel.Key.Get(out var key);
                fbeModel.Value.Get(out var value);
                values.Add(key, value);
                fbeModel.Key.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
                fbeModel.Value.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
            }
        }

        // Get the map as SortedDictionary
        public void Get(ref SortedDictionary<TKey, TValue> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            values.Clear();

            long fbeMapSize = Size;
            if (fbeMapSize == 0)
                return;

            var fbeModel = this[0];
            for (long i = fbeMapSize; i-- > 0;)
            {
                fbeModel.Key.Get(out var key);
                fbeModel.Value.Get(out var value);
                values.Add(key, value);
                fbeModel.Key.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
                fbeModel.Value.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
            }
        }

        // Set the map as Dictionary
        public void Set(Dictionary<TKey, TValue> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            var fbeModel = Resize(values.Count);
            foreach (var value in values)
            {
                fbeModel.Key.Set(value.Key);
                fbeModel.Key.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
                fbeModel.Value.Set(value.Value);
                fbeModel.Value.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
            }
        }

        // Set the map as SortedDictionary
        public void Set(SortedDictionary<TKey, TValue> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return;

            var fbeModel = Resize(values.Count);
            foreach (var value in values)
            {
                fbeModel.Key.Set(value.Key);
                fbeModel.Key.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
                fbeModel.Value.Set(value.Value);
                fbeModel.Value.FBEShift(fbeModel.Key.FBESize + fbeModel.Value.FBESize);
            }
        }
    }

    // Fast Binary Encoding final model value type
    public abstract class FinalModelValueType<T> : FieldModelBase
        where T : struct
    {
        protected FinalModelValueType(Buffer buffer, long offset) : base(buffer, offset) {}

        // Get the allocation size
        public abstract long FBEAllocationSize(T value);

        // Clone the final model
        public abstract FinalModelValueType<T> Clone();

        // Check if the value is valid
        public abstract long Verify();

        // Get the value
        public abstract long Get(out T value);

        // Set the value
        public abstract long Set(T value);

        // Create final model of the given type
        public static FinalModelValueType<T> CreateFinalModel(BaseTypes type, Buffer buffer, long offset)
        {
            switch (type)
            {
                case BaseTypes.BOOL:
                    return new FinalModelBool(buffer, offset) as FinalModelValueType<T>;
                case BaseTypes.BYTE:
                    return new FinalModelByte(buffer, offset) as FinalModelValueType<T>;
                case BaseTypes.CHAR:
                    return new FinalModelChar(buffer, offset) as FinalModelValueType<T>;
                case BaseTypes.WCHAR:
                    return new FinalModelWChar(buffer, offset) as FinalModelValueType<T>;
                case BaseTypes.INT8:
                    return new FinalModelInt8(buffer, offset) as FinalModelValueType<T>;
                case BaseTypes.UINT8:
                    return new FinalModelUInt8(buffer, offset) as FinalModelValueType<T>;
                case BaseTypes.INT16:
                    return new FinalModelInt16(buffer, offset) as FinalModelValueType<T>;
                case BaseTypes.UINT16:
                    return new FinalModelUInt16(buffer, offset) as FinalModelValueType<T>;
                case BaseTypes.INT32:
                    return new FinalModelInt32(buffer, offset) as FinalModelValueType<T>;
                case BaseTypes.UINT32:
                    return new FinalModelUInt32(buffer, offset) as FinalModelValueType<T>;
                case BaseTypes.INT64:
                    return new FinalModelInt64(buffer, offset) as FinalModelValueType<T>;
                case BaseTypes.UINT64:
                    return new FinalModelUInt64(buffer, offset) as FinalModelValueType<T>;
                case BaseTypes.FLOAT:
                    return new FinalModelFloat(buffer, offset) as FinalModelValueType<T>;
                case BaseTypes.DOUBLE:
                    return new FinalModelDouble(buffer, offset) as FinalModelValueType<T>;
                case BaseTypes.DECIMAL:
                    return new FinalModelDecimal(buffer, offset) as FinalModelValueType<T>;
                case BaseTypes.UUID:
                    return new FinalModelUUID(buffer, offset) as FinalModelValueType<T>;
                case BaseTypes.TIMESTAMP:
                    return new FinalModelTimestamp(buffer, offset) as FinalModelValueType<T>;
                default:
                    Debug.Assert(false, "Unknown type!");
                    return null;
            }
        }
    }

    // Fast Binary Encoding final model reference type
    public abstract class FinalModelReferenceType<T> : FieldModelBase
        where T : class
    {
        protected FinalModelReferenceType(Buffer buffer, long offset) : base(buffer, offset) {}

        // Get the allocation size
        public abstract long FBEAllocationSize(T value);

        // Clone the final model
        public abstract FinalModelReferenceType<T> Clone();

        // Check if the value is valid
        public abstract long Verify();

        // Get the value
        public abstract long Get(out T value);

        // Set the value
        public abstract long Set(T value);

        // Create final model of the given type
        public static FinalModelReferenceType<T> CreateFinalModel(BaseTypes type, Buffer buffer, long offset)
        {
            switch (type)
            {
                case BaseTypes.BYTES:
                    return new FinalModelBytes(buffer, offset) as FinalModelReferenceType<T>;
                case BaseTypes.STRING:
                    return new FinalModelString(buffer, offset) as FinalModelReferenceType<T>;
                default:
                    Debug.Assert(false, "Unknown type!");
                    return null;
            }
        }
    }

    // Fast Binary Encoding bool final model
    public class FinalModelBool : FinalModelValueType<bool>
    {
        public FinalModelBool(Buffer buffer, long offset) : base(buffer, offset) {}

        // Get the allocation size
        public override long FBEAllocationSize(bool value) { return FBESize; }

        // Get the final size
        public override long FBESize => 1;

        // Clone the final model
        public override FinalModelValueType<bool> Clone() { return new FinalModelBool(_buffer, _offset); }

        // Check if the value is valid
        public override long Verify()
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return long.MaxValue;

            return FBESize;
        }

        // Get the value
        public override long Get(out bool value)
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
            {
                value = false;
                return 0;
            }

            value = ReadBool(FBEOffset);
            return FBESize;
        }

        // Set the value
        public override long Set(bool value)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return 0;

            Write(FBEOffset, value);
            return FBESize;
        }
    }

    // Fast Binary Encoding byte final model
    public class FinalModelByte : FinalModelValueType<byte>
    {
        public FinalModelByte(Buffer buffer, long offset) : base(buffer, offset) {}

        // Get the allocation size
        public override long FBEAllocationSize(byte value) { return FBESize; }

        // Get the final size
        public override long FBESize => 1;

        // Clone the final model
        public override FinalModelValueType<byte> Clone() { return new FinalModelByte(_buffer, _offset); }

        // Check if the value is valid
        public override long Verify()
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return long.MaxValue;

            return FBESize;
        }

        // Get the value
        public override long Get(out byte value)
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
            {
                value = (byte)0;
                return 0;
            }

            value = ReadByte(FBEOffset);
            return FBESize;
        }

        // Set the value
        public override long Set(byte value)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return 0;

            Write(FBEOffset, value);
            return FBESize;
        }
    }

    // Fast Binary Encoding char final model
    public class FinalModelChar : FinalModelValueType<char>
    {
        public FinalModelChar(Buffer buffer, long offset) : base(buffer, offset) {}

        // Get the allocation size
        public override long FBEAllocationSize(char value) { return FBESize; }

        // Get the final size
        public override long FBESize => 1;

        // Clone the final model
        public override FinalModelValueType<char> Clone() { return new FinalModelChar(_buffer, _offset); }

        // Check if the value is valid
        public override long Verify()
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return long.MaxValue;

            return FBESize;
        }

        // Get the value
        public override long Get(out char value)
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
            {
                value = '\0';
                return 0;
            }

            value = ReadChar(FBEOffset);
            return FBESize;
        }

        // Set the value
        public override long Set(char value)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return 0;

            Write(FBEOffset, (byte)value);
            return FBESize;
        }
    }

    // Fast Binary Encoding char final model
    public class FinalModelWChar : FinalModelValueType<char>
    {
        public FinalModelWChar(Buffer buffer, long offset) : base(buffer, offset) {}

        // Get the allocation size
        public override long FBEAllocationSize(char value) { return FBESize; }

        // Get the final size
        public override long FBESize => 4;

        // Clone the final model
        public override FinalModelValueType<char> Clone() { return new FinalModelWChar(_buffer, _offset); }

        // Check if the value is valid
        public override long Verify()
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return long.MaxValue;

            return FBESize;
        }

        // Get the value
        public override long Get(out char value)
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
            {
                value = '\0';
                return 0;
            }

            value = ReadWChar(FBEOffset);
            return FBESize;
        }

        // Set the value
        public override long Set(char value)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return 0;

            Write(FBEOffset, (uint)value);
            return FBESize;
        }
    }

    // Fast Binary Encoding sbyte final model
    public class FinalModelInt8 : FinalModelValueType<sbyte>
    {
        public FinalModelInt8(Buffer buffer, long offset) : base(buffer, offset) {}

        // Get the allocation size
        public override long FBEAllocationSize(sbyte value) { return FBESize; }

        // Get the final size
        public override long FBESize => 1;

        // Clone the final model
        public override FinalModelValueType<sbyte> Clone() { return new FinalModelInt8(_buffer, _offset); }

        // Check if the value is valid
        public override long Verify()
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return long.MaxValue;

            return FBESize;
        }

        // Get the value
        public override long Get(out sbyte value)
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
            {
                value = 0;
                return 0;
            }

            value = ReadInt8(FBEOffset);
            return FBESize;
        }

        // Set the value
        public override long Set(sbyte value)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return 0;

            Write(FBEOffset, value);
            return FBESize;
        }
    }

    // Fast Binary Encoding byte final model
    public class FinalModelUInt8 : FinalModelValueType<byte>
    {
        public FinalModelUInt8(Buffer buffer, long offset) : base(buffer, offset) {}

        // Get the allocation size
        public override long FBEAllocationSize(byte value) { return FBESize; }

        // Get the final size
        public override long FBESize => 1;

        // Clone the final model
        public override FinalModelValueType<byte> Clone() { return new FinalModelUInt8(_buffer, _offset); }

        // Check if the value is valid
        public override long Verify()
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return long.MaxValue;

            return FBESize;
        }

        // Get the value
        public override long Get(out byte value)
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
            {
                value = (byte)0;
                return 0;
            }

            value = ReadUInt8(FBEOffset);
            return FBESize;
        }

        // Set the value
        public override long Set(byte value)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return 0;

            Write(FBEOffset, value);
            return FBESize;
        }
    }

    // Fast Binary Encoding short final model
    public class FinalModelInt16 : FinalModelValueType<short>
    {
        public FinalModelInt16(Buffer buffer, long offset) : base(buffer, offset) {}

        // Get the allocation size
        public override long FBEAllocationSize(short value) { return FBESize; }

        // Get the final size
        public override long FBESize => 2;

        // Clone the final model
        public override FinalModelValueType<short> Clone() { return new FinalModelInt16(_buffer, _offset); }

        // Check if the value is valid
        public override long Verify()
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return long.MaxValue;

            return FBESize;
        }

        // Get the value
        public override long Get(out short value)
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
            {
                value = 0;
                return 0;
            }

            value = ReadInt16(FBEOffset);
            return FBESize;
        }

        // Set the value
        public override long Set(short value)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return 0;

            Write(FBEOffset, value);
            return FBESize;
        }
    }

    // Fast Binary Encoding ushort final model
    public class FinalModelUInt16 : FinalModelValueType<ushort>
    {
        public FinalModelUInt16(Buffer buffer, long offset) : base(buffer, offset) {}

        // Get the allocation size
        public override long FBEAllocationSize(ushort value) { return FBESize; }

        // Get the final size
        public override long FBESize => 2;

        // Clone the final model
        public override FinalModelValueType<ushort> Clone() { return new FinalModelUInt16(_buffer, _offset); }

        // Check if the value is valid
        public override long Verify()
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return long.MaxValue;

            return FBESize;
        }

        // Get the value
        public override long Get(out ushort value)
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
            {
                value = (ushort)0;
                return 0;
            }

            value = ReadUInt16(FBEOffset);
            return FBESize;
        }

        // Set the value
        public override long Set(ushort value)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return 0;

            Write(FBEOffset, value);
            return FBESize;
        }
    }

    // Fast Binary Encoding int final model
    public class FinalModelInt32 : FinalModelValueType<int>
    {
        public FinalModelInt32(Buffer buffer, long offset) : base(buffer, offset) {}

        // Get the allocation size
        public override long FBEAllocationSize(int value) { return FBESize; }

        // Get the final size
        public override long FBESize => 4;

        // Clone the final model
        public override FinalModelValueType<int> Clone() { return new FinalModelInt32(_buffer, _offset); }

        // Check if the value is valid
        public override long Verify()
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return long.MaxValue;

            return FBESize;
        }

        // Get the value
        public override long Get(out int value)
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
            {
                value = 0;
                return 0;
            }

            value = ReadInt32(FBEOffset);
            return FBESize;
        }

        // Set the value
        public override long Set(int value)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return 0;

            Write(FBEOffset, value);
            return FBESize;
        }
    }

    // Fast Binary Encoding uint final model
    public class FinalModelUInt32 : FinalModelValueType<uint>
    {
        public FinalModelUInt32(Buffer buffer, long offset) : base(buffer, offset) {}

        // Get the allocation size
        public override long FBEAllocationSize(uint value) { return FBESize; }

        // Get the final size
        public override long FBESize => 4;

        // Clone the final model
        public override FinalModelValueType<uint> Clone() { return new FinalModelUInt32(_buffer, _offset); }

        // Check if the value is valid
        public override long Verify()
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return long.MaxValue;

            return FBESize;
        }

        // Get the value
        public override long Get(out uint value)
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
            {
                value = 0U;
                return 0;
            }

            value = ReadUInt32(FBEOffset);
            return FBESize;
        }

        // Set the value
        public override long Set(uint value)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return 0;

            Write(FBEOffset, value);
            return FBESize;
        }
    }

    // Fast Binary Encoding long final model
    public class FinalModelInt64 : FinalModelValueType<long>
    {
        public FinalModelInt64(Buffer buffer, long offset) : base(buffer, offset) {}

        // Get the allocation size
        public override long FBEAllocationSize(long value) { return FBESize; }

        // Get the final size
        public override long FBESize => 8;

        // Clone the final model
        public override FinalModelValueType<long> Clone() { return new FinalModelInt64(_buffer, _offset); }

        // Check if the value is valid
        public override long Verify()
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return long.MaxValue;

            return FBESize;
        }

        // Get the value
        public override long Get(out long value)
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
            {
                value = 0L;
                return 0;
            }

            value = ReadInt64(FBEOffset);
            return FBESize;
        }

        // Set the value
        public override long Set(long value)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return 0;

            Write(FBEOffset, value);
            return FBESize;
        }
    }

    // Fast Binary Encoding ulong final model
    public class FinalModelUInt64 : FinalModelValueType<ulong>
    {
        public FinalModelUInt64(Buffer buffer, long offset) : base(buffer, offset) {}

        // Get the allocation size
        public override long FBEAllocationSize(ulong value) { return FBESize; }

        // Get the final size
        public override long FBESize => 8;

        // Clone the final model
        public override FinalModelValueType<ulong> Clone() { return new FinalModelUInt64(_buffer, _offset); }

        // Check if the value is valid
        public override long Verify()
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return long.MaxValue;

            return FBESize;
        }

        // Get the value
        public override long Get(out ulong value)
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
            {
                value = 0UL;
                return 0;
            }

            value = ReadUInt64(FBEOffset);
            return FBESize;
        }

        // Set the value
        public override long Set(ulong value)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return 0;

            Write(FBEOffset, value);
            return FBESize;
        }
    }

    // Fast Binary Encoding float final model
    public class FinalModelFloat : FinalModelValueType<float>
    {
        public FinalModelFloat(Buffer buffer, long offset) : base(buffer, offset) {}

        // Get the allocation size
        public override long FBEAllocationSize(float value) { return FBESize; }

        // Get the final size
        public override long FBESize => 4;

        // Clone the final model
        public override FinalModelValueType<float> Clone() { return new FinalModelFloat(_buffer, _offset); }

        // Check if the value is valid
        public override long Verify()
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return long.MaxValue;

            return FBESize;
        }

        // Get the value
        public override long Get(out float value)
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
            {
                value = 0.0F;
                return 0;
            }

            value = ReadFloat(FBEOffset);
            return FBESize;
        }

        // Set the value
        public override long Set(float value)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return 0;

            Write(FBEOffset, value);
            return FBESize;
        }
    }

    // Fast Binary Encoding double final model
    public class FinalModelDouble : FinalModelValueType<double>
    {
        public FinalModelDouble(Buffer buffer, long offset) : base(buffer, offset) {}

        // Get the allocation size
        public override long FBEAllocationSize(double value) { return FBESize; }

        // Get the final size
        public override long FBESize => 8;

        // Clone the final model
        public override FinalModelValueType<double> Clone() { return new FinalModelDouble(_buffer, _offset); }

        // Check if the value is valid
        public override long Verify()
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return long.MaxValue;

            return FBESize;
        }

        // Get the value
        public override long Get(out double value)
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
            {
                value = 0.0D;
                return 0;
            }

            value = ReadDouble(FBEOffset);
            return FBESize;
        }

        // Set the value
        public override long Set(double value)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return 0;

            Write(FBEOffset, value);
            return FBESize;
        }
    }

    // Fast Binary Encoding decimal final model
    public class FinalModelDecimal : FinalModelValueType<decimal>
    {
        public FinalModelDecimal(Buffer buffer, long offset) : base(buffer, offset) {}

        // Get the allocation size
        public override long FBEAllocationSize(decimal value) { return FBESize; }

        // Get the final size
        public override long FBESize => 16;

        // Clone the final model
        public override FinalModelValueType<decimal> Clone() { return new FinalModelDecimal(_buffer, _offset); }

        // Check if the value is valid
        public override long Verify()
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return long.MaxValue;

            return FBESize;
        }

        // Get the value
        public override long Get(out decimal value)
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
            {
                value = 0.0M;
                return 0;
            }

            value = ReadDecimal(FBEOffset);
            return FBESize;
        }

        // Set the value
        public override long Set(decimal value)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return 0;

            Write(FBEOffset, value);
            return FBESize;
        }
    }

    // Fast Binary Encoding Guid final model
    public class FinalModelUUID : FinalModelValueType<Guid>
    {
        public FinalModelUUID(Buffer buffer, long offset) : base(buffer, offset) {}

        // Get the allocation size
        public override long FBEAllocationSize(Guid value) { return FBESize; }

        // Get the final size
        public override long FBESize => 16;

        // Clone the final model
        public override FinalModelValueType<Guid> Clone() { return new FinalModelUUID(_buffer, _offset); }

        // Check if the value is valid
        public override long Verify()
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return long.MaxValue;

            return FBESize;
        }

        // Get the value
        public override long Get(out Guid value)
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
            {
                value = UuidGenerator.Nil();
                return 0;
            }

            value = ReadUUID(FBEOffset);
            return FBESize;
        }

        // Set the value
        public override long Set(Guid value)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return 0;

            Write(FBEOffset, value);
            return FBESize;
        }
    }

    // Fast Binary Encoding timestamp final model
    public class FinalModelTimestamp : FinalModelValueType<DateTime>
    {
        private const long UnixEpoch = 621355968000000000;

        public FinalModelTimestamp(Buffer buffer, long offset) : base(buffer, offset) {}

        // Get the allocation size
        public override long FBEAllocationSize(DateTime value) { return FBESize; }

        // Get the final size
        public override long FBESize => 8;

        // Clone the final model
        public override FinalModelValueType<DateTime> Clone() { return new FinalModelTimestamp(_buffer, _offset); }

        // Check if the temestamp value is valid
        public override long Verify()
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return long.MaxValue;

            return FBESize;
        }

        // Get the timestamp value
        public override long Get(out DateTime value)
        {
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
            {
                value = new DateTime(UnixEpoch, DateTimeKind.Utc);
                return 0;
            }

            ulong ticks = ReadUInt64(FBEOffset) / 100;
            value = new DateTime((long)(UnixEpoch + ticks), DateTimeKind.Utc);
            return FBESize;
        }

        // Set the timestamp value
        public override long Set(DateTime value)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return 0;

            ulong nanoseconds = (ulong)((value.Ticks - UnixEpoch) * 100);
            Write(FBEOffset, nanoseconds);
            return FBESize;
        }
    }

    // Fast Binary Encoding bytes final model
    public class FinalModelBytes : FinalModelReferenceType<MemoryStream>
    {
        public FinalModelBytes(Buffer buffer, long offset) : base(buffer, offset) {}

        // Get the allocation size
        public override long FBEAllocationSize(MemoryStream value) { return 4 + value.Length; }

        // Clone the final model
        public override FinalModelReferenceType<MemoryStream> Clone() { return new FinalModelBytes(_buffer, _offset); }

        // Check if the bytes value is valid
        public override long Verify()
        {
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return long.MaxValue;

            uint fbeBytesSize = ReadUInt32(FBEOffset);
            if ((_buffer.Offset + FBEOffset + 4 + fbeBytesSize) > _buffer.Size)
                return long.MaxValue;

            return 4 + fbeBytesSize;
        }

        // Get the bytes value
        public override long Get(out MemoryStream value)
        {
            value = new MemoryStream();

            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return 0;

            uint fbeBytesSize = ReadUInt32(FBEOffset);
            Debug.Assert(((_buffer.Offset + FBEOffset + 4 + fbeBytesSize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4 + fbeBytesSize) > _buffer.Size)
                return 4;

            var buffer = ReadBytes(FBEOffset + 4, fbeBytesSize);
            value.Write(buffer, 0, buffer.Length);
            return 4 + fbeBytesSize;
        }

        // Set the bytes value
        public override long Set(MemoryStream value)
        {
            Debug.Assert((value != null), "Invalid bytes value!");
            if (value == null)
                throw new ArgumentNullException(nameof(value), "Invalid bytes value!");

            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return 0;

            uint fbeBytesSize = (uint)value.Length;
            Debug.Assert(((_buffer.Offset + FBEOffset + 4 + fbeBytesSize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4 + fbeBytesSize) > _buffer.Size)
                return 4;

            Write(FBEOffset, fbeBytesSize);
            Write(FBEOffset + 4, value.GetBuffer(), 0, fbeBytesSize);
            return 4 + fbeBytesSize;
        }
    }

    // Fast Binary Encoding string final model
    public class FinalModelString : FinalModelReferenceType<string>
    {
        public FinalModelString(Buffer buffer, long offset) : base(buffer, offset) {}

        // Get the allocation size
        public override long FBEAllocationSize(string value) { return 4 + Encoding.UTF8.GetMaxByteCount(value.Length); }

        // Clone the final model
        public override FinalModelReferenceType<string> Clone() { return new FinalModelString(_buffer, _offset); }

        // Check if the string value is valid
        public override long Verify()
        {
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return long.MaxValue;

            uint fbeStringSize = ReadUInt32(FBEOffset);
            if ((_buffer.Offset + FBEOffset + 4 + fbeStringSize) > _buffer.Size)
                return long.MaxValue;

            return 4 + fbeStringSize;
        }

        // Get the string value
        public override long Get(out string value)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
            {
                value = "";
                return 0;
            }

            uint fbeStringSize = ReadUInt32(FBEOffset);
            Debug.Assert(((_buffer.Offset + FBEOffset + 4 + fbeStringSize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4 + fbeStringSize) > _buffer.Size)
            {
                value = "";
                return 4;
            }

            value = ReadString(FBEOffset + 4, fbeStringSize);
            return 4 + fbeStringSize;
        }

        // Set the string value
        public override long Set(string value)
        {
            Debug.Assert((value != null), "Invalid string value!");
            if (value == null)
                throw new ArgumentNullException(nameof(value), "Invalid string value!");

            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return 0;

            uint fbeStringSize = (uint)Write(FBEOffset + 4, value);
            Debug.Assert(((_buffer.Offset + FBEOffset + 4 + fbeStringSize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4 + fbeStringSize) > _buffer.Size)
                return 4;

            Write(FBEOffset, fbeStringSize);
            return 4 + fbeStringSize;
        }
    }

    // Fast Binary Encoding final model optional (value type)
    public class FinalModelOptionalValueType<T, TModel> : FieldModelBase
        where T : struct
        where TModel : FinalModelValueType<T>
    {
        public FinalModelOptionalValueType(TModel model, Buffer buffer, long offset) : base(buffer, offset)
        {
            Value = model.Clone() as TModel;
            // Reset the optional model offset
            if (Value != null)
                Value.FBEOffset = 0;
        }

        // Get the allocation size
        public long FBEAllocationSize(T? optional) { return 1 + ((optional.HasValue) ? Value.FBEAllocationSize(optional.Value) : 0); }

        // Clone the final model
        public FinalModelOptionalValueType<T, TModel> Clone() { return new FinalModelOptionalValueType<T, TModel>(Value, _buffer, _offset); }

        //! Is the value present?
        public static implicit operator bool(FinalModelOptionalValueType<T, TModel> optional) { return !ReferenceEquals(optional, null) && optional.HasValue; }

        // Checks if the object contains a value
        public bool HasValue
        {
            get
            {
                if ((_buffer.Offset + FBEOffset + 1) > _buffer.Size)
                    return false;

                byte fbeHasValue = ReadUInt8(FBEOffset);
                return (fbeHasValue != 0);
            }
        }

        // Base final model value
        public TModel Value { get; }

        // Check if the optional value is valid
        public virtual long Verify()
        {
            if ((_buffer.Offset + FBEOffset + 1) > _buffer.Size)
                return long.MaxValue;

            byte fbeHasValue = ReadUInt8(FBEOffset);
            if (fbeHasValue == 0)
                return 1;

            _buffer.Shift(FBEOffset + 1);
            long fbeResult = Value.Verify();
            _buffer.Unshift(FBEOffset + 1);
            return 1 + fbeResult;
        }

        // Get the optional value
        public long Get(out T? optional)
        {
            optional = null;

            Debug.Assert(((_buffer.Offset + FBEOffset + 1) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 1) > _buffer.Size)
                return 0;

            if (!HasValue)
                return 1;

            _buffer.Shift(FBEOffset + 1);
            long size = Value.Get(out var temp);
            optional = temp;
            _buffer.Unshift(FBEOffset + 1);
            return 1 + size;
        }

        // Set the optional value
        public long Set(T? optional)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + 1) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 1) > _buffer.Size)
                return 0;

            byte fbeHasValue = (byte)((optional.HasValue) ? 1 : 0);
            Write(FBEOffset, fbeHasValue);
            if (fbeHasValue == 0)
                return 1;

            _buffer.Shift(FBEOffset + 1);
            long size = 0;
            if (optional.HasValue)
                size = Value.Set(optional.Value);
            _buffer.Unshift(FBEOffset + 1);
            return 1 + size;
        }
    }

    // Fast Binary Encoding final model optional (reference type)
    public class FinalModelOptionalReferenceType<T, TModel> : FieldModelBase
        where T : class
        where TModel : FinalModelReferenceType<T>
    {
        public FinalModelOptionalReferenceType(TModel model, Buffer buffer, long offset) : base(buffer, offset)
        {
            Value = model.Clone() as TModel;
            // Reset the optional model offset
            if (Value != null)
                Value.FBEOffset = 0;
        }

        // Get the allocation size
        public long FBEAllocationSize(T optional) { return 1 + ((optional != null) ? Value.FBEAllocationSize(optional) : 0); }

        // Clone the final model
        public FinalModelOptionalReferenceType<T, TModel> Clone() { return new FinalModelOptionalReferenceType<T, TModel>(Value, _buffer, _offset); }

        //! Is the value present?
        public static implicit operator bool(FinalModelOptionalReferenceType<T, TModel> optional) { return !ReferenceEquals(optional, null) && optional.HasValue; }

        // Checks if the object contains a value
        public bool HasValue
        {
            get
            {
                if ((_buffer.Offset + FBEOffset + 1) > _buffer.Size)
                    return false;

                byte fbeHasValue = ReadUInt8(FBEOffset);
                return (fbeHasValue != 0);
            }
        }

        // Base final model value
        public TModel Value { get; }

        // Check if the optional value is valid
        public virtual long Verify()
        {
            if ((_buffer.Offset + FBEOffset + 1) > _buffer.Size)
                return long.MaxValue;

            byte fbeHasValue = ReadUInt8(FBEOffset);
            if (fbeHasValue == 0)
                return 1;

            _buffer.Shift(FBEOffset + 1);
            long fbeResult = Value.Verify();
            _buffer.Unshift(FBEOffset + 1);
            return 1 + fbeResult;
        }

        // Get the optional value
        public long Get(out T optional)
        {
            optional = null;

            Debug.Assert(((_buffer.Offset + FBEOffset + 1) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 1) > _buffer.Size)
                return 0;

            if (!HasValue)
                return 1;

            _buffer.Shift(FBEOffset + 1);
            long size = Value.Get(out var temp);
            optional = temp;
            _buffer.Unshift(FBEOffset + 1);
            return 1 + size;
        }

        // Set the optional value
        public long Set(T optional)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + 1) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 1) > _buffer.Size)
                return 0;

            byte fbeHasValue = (byte)((optional != null) ? 1 : 0);
            Write(FBEOffset, fbeHasValue);
            if (fbeHasValue == 0)
                return 1;

            _buffer.Shift(FBEOffset + 1);
            long size = 0;
            if (optional != null)
                size = Value.Set(optional);
            _buffer.Unshift(FBEOffset + 1);
            return 1 + size;
        }
    }

    // Fast Binary Encoding final model array (value type)
    public class FinalModelArrayValueType<T, TModel> : FieldModelBase
        where T : struct
        where TModel : FinalModelValueType<T>
    {
        private readonly TModel _model;
        private readonly long _size;

        public FinalModelArrayValueType(TModel model, Buffer buffer, long offset, long size) : base(buffer, offset)
        {
            _model = model.Clone() as TModel;
            _size = size;
        }

        // Get the allocation size
        public long FBEAllocationSize(T[] values)
        {
            long size = 0;
            for (long i = 0; (i < values.Length) && (i < _size); i++)
                size += _model.FBEAllocationSize(values[i]);
            return size;
        }
        public long FBEAllocationSize(List<T> values)
        {
            long size = 0;
            for (long i = 0; (i < values.Count) && (i < _size); i++)
                size += _model.FBEAllocationSize(values[(int)i]);
            return size;
        }

        // Clone the final model
        public FinalModelArrayValueType<T, TModel> Clone() { return new FinalModelArrayValueType<T, TModel>(_model, _buffer, _offset, _size); }

        // Check if the array is valid
        public virtual long Verify()
        {
            if ((_buffer.Offset + FBEOffset) > _buffer.Size)
                return long.MaxValue;

            long size = 0;
            _model.FBEOffset = FBEOffset;
            for (long i = _size; i-- > 0;)
            {
                long offset = _model.Verify();
                if (offset == long.MaxValue)
                    return long.MaxValue;
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }

        // Get the array
        public long Get(out T[] values)
        {
            values = new T[_size];

            Debug.Assert(((_buffer.Offset + FBEOffset) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset) > _buffer.Size)
                return 0;

            long size = 0;
            _model.FBEOffset = FBEOffset;
            for (long i = 0; i < _size; i++)
            {
                long offset = _model.Get(out values[i]);
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }

        // Get the array as List
        public long Get(out List<T> values)
        {
            values = new List<T>((int)_size);

            Debug.Assert(((_buffer.Offset + FBEOffset) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset) > _buffer.Size)
                return 0;

            long size = 0;
            _model.FBEOffset = FBEOffset;
            for (long i = _size; i-- > 0;)
            {
                long offset = _model.Get(out var value);
                values.Add(value);
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }

        // Set the array
        public long Set(T[] values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset) > _buffer.Size)
                return 0;

            long size = 0;
            _model.FBEOffset = FBEOffset;
            for (long i = 0; (i < values.Length) && (i < _size); i++)
            {
                long offset = _model.Set(values[i]);
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }

        // Set the array as List
        public long Set(List<T> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset) > _buffer.Size)
                return 0;

            long size = 0;
            _model.FBEOffset = FBEOffset;
            for (long i = 0; (i < values.Count) && (i < _size); i++)
            {
                long offset = _model.Set(values[(int)i]);
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }
    }

    // Fast Binary Encoding final model array (reference type)
    public class FinalModelArrayReferenceType<T, TModel> : FieldModelBase
        where T : class
        where TModel : FinalModelReferenceType<T>
    {
        private readonly TModel _model;
        private readonly long _size;

        public FinalModelArrayReferenceType(TModel model, Buffer buffer, long offset, long size) : base(buffer, offset)
        {
            _model = model.Clone() as TModel;
            _size = size;
        }

        // Get the allocation size
        public long FBEAllocationSize(T[] values)
        {
            long size = 0;
            for (long i = 0; (i < values.Length) && (i < _size); i++)
                size += _model.FBEAllocationSize(values[i]);
            return size;
        }
        public long FBEAllocationSize(List<T> values)
        {
            long size = 0;
            for (long i = 0; (i < values.Count) && (i < _size); i++)
                size += _model.FBEAllocationSize(values[(int)i]);
            return size;
        }

        // Clone the final model
        public FinalModelArrayReferenceType<T, TModel> Clone() { return new FinalModelArrayReferenceType<T, TModel>(_model, _buffer, _offset, _size); }

        // Check if the array is valid
        public virtual long Verify()
        {
            if ((_buffer.Offset + FBEOffset) > _buffer.Size)
                return long.MaxValue;

            long size = 0;
            _model.FBEOffset = FBEOffset;
            for (long i = _size; i-- > 0;)
            {
                long offset = _model.Verify();
                if (offset == long.MaxValue)
                    return long.MaxValue;
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }

        // Get the array
        public long Get(out T[] values)
        {
            values = new T[_size];

            Debug.Assert(((_buffer.Offset + FBEOffset) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset) > _buffer.Size)
                return 0;

            long size = 0;
            _model.FBEOffset = FBEOffset;
            for (long i = 0; i < _size; i++)
            {
                long offset = _model.Get(out values[i]);
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }

        // Get the array as List
        public long Get(out List<T> values)
        {
            values = new List<T>((int)_size);

            Debug.Assert(((_buffer.Offset + FBEOffset) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset) > _buffer.Size)
                return 0;

            long size = 0;
            _model.FBEOffset = FBEOffset;
            for (long i = _size; i-- > 0;)
            {
                long offset = _model.Get(out var value);
                values.Add(value);
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }

        // Set the array
        public long Set(T[] values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset) > _buffer.Size)
                return 0;

            long size = 0;
            _model.FBEOffset = FBEOffset;
            for (long i = 0; (i < values.Length) && (i < _size); i++)
            {
                long offset = _model.Set(values[i]);
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }

        // Set the array as List
        public long Set(List<T> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset) > _buffer.Size)
                return 0;

            long size = 0;
            _model.FBEOffset = FBEOffset;
            for (long i = 0; (i < values.Count) && (i < _size); i++)
            {
                long offset = _model.Set(values[(int)i]);
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }
    }

    // Fast Binary Encoding final model array (optional value type)
    public class FinalModelArrayOptionalValueType<T, TModel> : FieldModelBase
        where T : struct
        where TModel : FinalModelValueType<T>
    {
        private readonly FinalModelOptionalValueType<T, TModel> _model;
        private readonly long _size;

        public FinalModelArrayOptionalValueType(TModel model, Buffer buffer, long offset, long size) : base(buffer, offset)
        {
            _model = new FinalModelOptionalValueType<T, TModel>(model, buffer, offset);
            _size = size;
        }

        // Get the allocation size
        public long FBEAllocationSize(T?[] values)
        {
            long size = 0;
            for (long i = 0; (i < values.Length) && (i < _size); i++)
                size += _model.FBEAllocationSize(values[i]);
            return size;
        }
        public long FBEAllocationSize(List<T?> values)
        {
            long size = 0;
            for (long i = 0; (i < values.Count) && (i < _size); i++)
                size += _model.FBEAllocationSize(values[(int)i]);
            return size;
        }

        // Clone the final model
        public FinalModelArrayOptionalValueType<T, TModel> Clone() { return new FinalModelArrayOptionalValueType<T, TModel>(_model.Value, _buffer, _offset, _size); }

        // Check if the array is valid
        public virtual long Verify()
        {
            if ((_buffer.Offset + FBEOffset) > _buffer.Size)
                return long.MaxValue;

            long size = 0;
            _model.FBEOffset = FBEOffset;
            for (long i = _size; i-- > 0;)
            {
                long offset = _model.Verify();
                if (offset == long.MaxValue)
                    return long.MaxValue;
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }

        // Get the array
        public long Get(out T?[] values)
        {
            values = new T?[_size];

            Debug.Assert(((_buffer.Offset + FBEOffset) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset) > _buffer.Size)
                return 0;

            long size = 0;
            _model.FBEOffset = FBEOffset;
            for (long i = 0; i < _size; i++)
            {
                long offset = _model.Get(out values[i]);
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }

        // Get the array as List
        public long Get(out List<T?> values)
        {
            values = new List<T?>((int)_size);

            Debug.Assert(((_buffer.Offset + FBEOffset) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset) > _buffer.Size)
                return 0;

            long size = 0;
            _model.FBEOffset = FBEOffset;
            for (long i = _size; i-- > 0;)
            {
                long offset = _model.Get(out var value);
                values.Add(value);
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }

        // Set the array
        public long Set(T?[] values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset) > _buffer.Size)
                return 0;

            long size = 0;
            _model.FBEOffset = FBEOffset;
            for (long i = 0; (i < values.Length) && (i < _size); i++)
            {
                long offset = _model.Set(values[i]);
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }

        // Set the array as List
        public long Set(List<T?> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset) > _buffer.Size)
                return 0;

            long size = 0;
            _model.FBEOffset = FBEOffset;
            for (long i = 0; (i < values.Count) && (i < _size); i++)
            {
                long offset = _model.Set(values[(int)i]);
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }
    }

    // Fast Binary Encoding final model array (optional reference type)
    public class FinalModelArrayOptionalReferenceType<T, TModel> : FieldModelBase
        where T : class
        where TModel : FinalModelReferenceType<T>
    {
        private readonly FinalModelOptionalReferenceType<T, TModel> _model;
        private readonly long _size;

        public FinalModelArrayOptionalReferenceType(TModel model, Buffer buffer, long offset, long size) : base(buffer, offset)
        {
            _model = new FinalModelOptionalReferenceType<T, TModel>(model, buffer, offset);
            _size = size;
        }

        // Get the allocation size
        public long FBEAllocationSize(T[] values)
        {
            long size = 0;
            for (long i = 0; (i < values.Length) && (i < _size); i++)
                size += _model.FBEAllocationSize(values[i]);
            return size;
        }
        public long FBEAllocationSize(List<T> values)
        {
            long size = 0;
            for (long i = 0; (i < values.Count) && (i < _size); i++)
                size += _model.FBEAllocationSize(values[(int)i]);
            return size;
        }

        // Clone the final model
        public FinalModelArrayOptionalReferenceType<T, TModel> Clone() { return new FinalModelArrayOptionalReferenceType<T, TModel>(_model.Value, _buffer, _offset, _size); }

        // Check if the array is valid
        public virtual long Verify()
        {
            if ((_buffer.Offset + FBEOffset) > _buffer.Size)
                return long.MaxValue;

            long size = 0;
            _model.FBEOffset = FBEOffset;
            for (long i = _size; i-- > 0;)
            {
                long offset = _model.Verify();
                if (offset == long.MaxValue)
                    return long.MaxValue;
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }

        // Get the array
        public long Get(out T[] values)
        {
            values = new T[_size];

            Debug.Assert(((_buffer.Offset + FBEOffset) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset) > _buffer.Size)
                return 0;

            long size = 0;
            _model.FBEOffset = FBEOffset;
            for (long i = 0; i < _size; i++)
            {
                long offset = _model.Get(out values[i]);
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }

        // Get the array as List
        public long Get(out List<T> values)
        {
            values = new List<T>((int)_size);

            Debug.Assert(((_buffer.Offset + FBEOffset) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset) > _buffer.Size)
                return 0;

            long size = 0;
            _model.FBEOffset = FBEOffset;
            for (long i = _size; i-- > 0;)
            {
                long offset = _model.Get(out var value);
                values.Add(value);
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }

        // Set the array
        public long Set(T[] values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset) > _buffer.Size)
                return 0;

            long size = 0;
            _model.FBEOffset = FBEOffset;
            for (long i = 0; (i < values.Length) && (i < _size); i++)
            {
                long offset = _model.Set(values[i]);
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }

        // Set the array as List
        public long Set(List<T> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset) > _buffer.Size)
                return 0;

            long size = 0;
            _model.FBEOffset = FBEOffset;
            for (long i = 0; (i < values.Count) && (i < _size); i++)
            {
                long offset = _model.Set(values[(int)i]);
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }
    }

    // Fast Binary Encoding final model vector (value type)
    public class FinalModelVectorValueType<T, TModel> : FieldModelBase
        where T : struct
        where TModel : FinalModelValueType<T>
    {
        private readonly TModel _model;

        public FinalModelVectorValueType(TModel model, Buffer buffer, long offset) : base(buffer, offset)
        {
            _model = model.Clone() as TModel;
        }

        // Get the allocation size
        public long FBEAllocationSize(List<T> values)
        {
            long size = 4;
            foreach (var value in values)
                size += _model.FBEAllocationSize(value);
            return size;
        }
        public long FBEAllocationSize(LinkedList<T> values)
        {
            long size = 4;
            foreach (var value in values)
                size += _model.FBEAllocationSize(value);
            return size;
        }
        public long FBEAllocationSize(HashSet<T> values)
        {
            long size = 4;
            foreach (var value in values)
                size += _model.FBEAllocationSize(value);
            return size;
        }

        // Clone the final model
        public FinalModelVectorValueType<T, TModel> Clone() { return new FinalModelVectorValueType<T, TModel>(_model, _buffer, _offset); }

        // Check if the vector is valid
        public virtual long Verify()
        {
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return long.MaxValue;

            uint fbeVectorSize = ReadUInt32(FBEOffset);

            long size = 4;
            _model.FBEOffset = FBEOffset + 4;
            for (uint i = fbeVectorSize; i-- > 0;)
            {
                long offset = _model.Verify();
                if (offset == long.MaxValue)
                    return long.MaxValue;
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }

        // Get the vector as List
        public long Get(out List<T> values)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
            {
                values = new List<T>();
                return 0;
            }

            long fbeVectorSize = ReadUInt32(FBEOffset);
            if (fbeVectorSize == 0)
            {
                values = new List<T>();
                return 4;
            }

            values = new List<T>((int)fbeVectorSize);

            long size = 4;
            _model.FBEOffset = FBEOffset + 4;
            for (long i = fbeVectorSize; i-- > 0;)
            {
                long offset = _model.Get(out var value);
                values.Add(value);
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }

        // Get the vector as LinkedList
        public long Get(out LinkedList<T> values)
        {
            values = new LinkedList<T>();

            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return 0;

            long fbeVectorSize = ReadUInt32(FBEOffset);
            if (fbeVectorSize == 0)
                return 4;

            long size = 4;
            _model.FBEOffset = FBEOffset + 4;
            for (long i = fbeVectorSize; i-- > 0;)
            {
                long offset = _model.Get(out var value);
                values.AddLast(value);
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }

        // Get the vector as HashSet
        public long Get(out HashSet<T> values)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
            {
                values = new HashSet<T>();
                return 0;
            }

            long fbeVectorSize = ReadUInt32(FBEOffset);
            if (fbeVectorSize == 0)
            {
                values = new HashSet<T>();
                return 4;
            }

            values = new HashSet<T>((int)fbeVectorSize);

            long size = 4;
            _model.FBEOffset = FBEOffset + 4;
            for (long i = fbeVectorSize; i-- > 0;)
            {
                long offset = _model.Get(out var value);
                values.Add(value);
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }

        // Set the vector as List
        public long Set(List<T> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return 0;

            Write(FBEOffset, (uint)values.Count);

            long size = 4;
            _model.FBEOffset = FBEOffset + 4;
            foreach (var value in values)
            {
                long offset = _model.Set(value);
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }

        // Set the vector as LinkedList
        public long Set(LinkedList<T> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return 0;

            Write(FBEOffset, (uint)values.Count);

            long size = 4;
            _model.FBEOffset = FBEOffset + 4;
            foreach (var value in values)
            {
                long offset = _model.Set(value);
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }

        // Set the vector as HashSet
        public long Set(HashSet<T> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return 0;

            Write(FBEOffset, (uint)values.Count);

            long size = 4;
            _model.FBEOffset = FBEOffset + 4;
            foreach (var value in values)
            {
                long offset = _model.Set(value);
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }
    }

    // Fast Binary Encoding final model vector (reference type)
    public class FinalModelVectorReferenceType<T, TModel> : FieldModelBase
        where T : class
        where TModel : FinalModelReferenceType<T>
    {
        private readonly TModel _model;

        public FinalModelVectorReferenceType(TModel model, Buffer buffer, long offset) : base(buffer, offset)
        {
            _model = model.Clone() as TModel;
        }

        // Get the allocation size
        public long FBEAllocationSize(List<T> values)
        {
            long size = 4;
            foreach (var value in values)
                size += _model.FBEAllocationSize(value);
            return size;
        }
        public long FBEAllocationSize(LinkedList<T> values)
        {
            long size = 4;
            foreach (var value in values)
                size += _model.FBEAllocationSize(value);
            return size;
        }
        public long FBEAllocationSize(HashSet<T> values)
        {
            long size = 4;
            foreach (var value in values)
                size += _model.FBEAllocationSize(value);
            return size;
        }

        // Clone the final model
        public FinalModelVectorReferenceType<T, TModel> Clone() { return new FinalModelVectorReferenceType<T, TModel>(_model, _buffer, _offset); }

        // Check if the vector is valid
        public virtual long Verify()
        {
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return long.MaxValue;

            uint fbeVectorSize = ReadUInt32(FBEOffset);

            long size = 4;
            _model.FBEOffset = FBEOffset + 4;
            for (uint i = fbeVectorSize; i-- > 0;)
            {
                long offset = _model.Verify();
                if (offset == long.MaxValue)
                    return long.MaxValue;
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }

        // Get the vector as List
        public long Get(out List<T> values)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
            {
                values = new List<T>();
                return 0;
            }

            long fbeVectorSize = ReadUInt32(FBEOffset);
            if (fbeVectorSize == 0)
            {
                values = new List<T>();
                return 4;
            }

            values = new List<T>((int)fbeVectorSize);

            long size = 4;
            _model.FBEOffset = FBEOffset + 4;
            for (long i = fbeVectorSize; i-- > 0;)
            {
                long offset = _model.Get(out var value);
                values.Add(value);
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }

        // Get the vector as LinkedList
        public long Get(out LinkedList<T> values)
        {
            values = new LinkedList<T>();

            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return 0;

            long fbeVectorSize = ReadUInt32(FBEOffset);
            if (fbeVectorSize == 0)
                return 4;

            long size = 4;
            _model.FBEOffset = FBEOffset + 4;
            for (long i = fbeVectorSize; i-- > 0;)
            {
                long offset = _model.Get(out var value);
                values.AddLast(value);
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }

        // Get the vector as HashSet
        public long Get(out HashSet<T> values)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
            {
                values = new HashSet<T>();
                return 0;
            }

            long fbeVectorSize = ReadUInt32(FBEOffset);
            if (fbeVectorSize == 0)
            {
                values = new HashSet<T>();
                return 4;
            }

            values = new HashSet<T>((int)fbeVectorSize);

            long size = 4;
            _model.FBEOffset = FBEOffset + 4;
            for (long i = fbeVectorSize; i-- > 0;)
            {
                long offset = _model.Get(out var value);
                values.Add(value);
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }

        // Set the vector as List
        public long Set(List<T> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return 0;

            Write(FBEOffset, (uint)values.Count);

            long size = 4;
            _model.FBEOffset = FBEOffset + 4;
            foreach (var value in values)
            {
                long offset = _model.Set(value);
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }

        // Set the vector as LinkedList
        public long Set(LinkedList<T> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return 0;

            Write(FBEOffset, (uint)values.Count);

            long size = 4;
            _model.FBEOffset = FBEOffset + 4;
            foreach (var value in values)
            {
                long offset = _model.Set(value);
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }

        // Set the vector as HashSet
        public long Set(HashSet<T> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return 0;

            Write(FBEOffset, (uint)values.Count);

            long size = 4;
            _model.FBEOffset = FBEOffset + 4;
            foreach (var value in values)
            {
                long offset = _model.Set(value);
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }
    }

    // Fast Binary Encoding final model vector (optional value type)
    public class FinalModelVectorOptionalValueType<T, TModel> : FieldModelBase
        where T : struct
        where TModel : FinalModelValueType<T>
    {
        private readonly FinalModelOptionalValueType<T, TModel> _model;

        public FinalModelVectorOptionalValueType(TModel model, Buffer buffer, long offset) : base(buffer, offset)
        {
            _model = new FinalModelOptionalValueType<T, TModel>(model, buffer, offset);
        }

        // Get the allocation size
        public long FBEAllocationSize(List<T?> values)
        {
            long size = 4;
            foreach (var value in values)
                size += _model.FBEAllocationSize(value);
            return size;
        }
        public long FBEAllocationSize(LinkedList<T?> values)
        {
            long size = 4;
            foreach (var value in values)
                size += _model.FBEAllocationSize(value);
            return size;
        }
        public long FBEAllocationSize(HashSet<T?> values)
        {
            long size = 4;
            foreach (var value in values)
                size += _model.FBEAllocationSize(value);
            return size;
        }

        // Clone the final model
        public FinalModelVectorOptionalValueType<T, TModel> Clone() { return new FinalModelVectorOptionalValueType<T, TModel>(_model.Value, _buffer, _offset); }

        // Check if the vector is valid
        public virtual long Verify()
        {
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return long.MaxValue;

            uint fbeVectorSize = ReadUInt32(FBEOffset);

            long size = 4;
            _model.FBEOffset = FBEOffset + 4;
            for (uint i = fbeVectorSize; i-- > 0;)
            {
                long offset = _model.Verify();
                if (offset == long.MaxValue)
                    return long.MaxValue;
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }

        // Get the vector as List
        public long Get(out List<T?> values)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
            {
                values = new List<T?>();
                return 0;
            }

            long fbeVectorSize = ReadUInt32(FBEOffset);
            if (fbeVectorSize == 0)
            {
                values = new List<T?>();
                return 4;
            }

            values = new List<T?>((int)fbeVectorSize);

            long size = 4;
            _model.FBEOffset = FBEOffset + 4;
            for (long i = fbeVectorSize; i-- > 0;)
            {
                long offset = _model.Get(out var value);
                values.Add(value);
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }

        // Get the vector as LinkedList
        public long Get(out LinkedList<T?> values)
        {
            values = new LinkedList<T?>();

            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return 0;

            long fbeVectorSize = ReadUInt32(FBEOffset);
            if (fbeVectorSize == 0)
                return 4;

            long size = 4;
            _model.FBEOffset = FBEOffset + 4;
            for (long i = fbeVectorSize; i-- > 0;)
            {
                long offset = _model.Get(out var value);
                values.AddLast(value);
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }

        // Get the vector as HashSet
        public long Get(out HashSet<T?> values)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
            {
                values = new HashSet<T?>();
                return 0;
            }

            long fbeVectorSize = ReadUInt32(FBEOffset);
            if (fbeVectorSize == 0)
            {
                values = new HashSet<T?>();
                return 4;
            }

            values = new HashSet<T?>((int)fbeVectorSize);

            long size = 4;
            _model.FBEOffset = FBEOffset + 4;
            for (long i = fbeVectorSize; i-- > 0;)
            {
                long offset = _model.Get(out var value);
                values.Add(value);
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }

        // Set the vector as List
        public long Set(List<T?> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return 0;

            Write(FBEOffset, (uint)values.Count);

            long size = 4;
            _model.FBEOffset = FBEOffset + 4;
            foreach (var value in values)
            {
                long offset = _model.Set(value);
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }

        // Set the vector as LinkedList
        public long Set(LinkedList<T?> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return 0;

            Write(FBEOffset, (uint)values.Count);

            long size = 4;
            _model.FBEOffset = FBEOffset + 4;
            foreach (var value in values)
            {
                long offset = _model.Set(value);
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }

        // Set the vector as HashSet
        public long Set(HashSet<T?> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return 0;

            Write(FBEOffset, (uint)values.Count);

            long size = 4;
            _model.FBEOffset = FBEOffset + 4;
            foreach (var value in values)
            {
                long offset = _model.Set(value);
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }
    }

    // Fast Binary Encoding final model vector (optional reference type)
    public class FinalModelVectorOptionalReferenceType<T, TModel> : FieldModelBase
        where T : class
        where TModel : FinalModelReferenceType<T>
    {
        private readonly FinalModelOptionalReferenceType<T, TModel> _model;

        public FinalModelVectorOptionalReferenceType(TModel model, Buffer buffer, long offset) : base(buffer, offset)
        {
            _model = new FinalModelOptionalReferenceType<T, TModel>(model, buffer, offset);
        }

        // Get the allocation size
        public long FBEAllocationSize(List<T> values)
        {
            long size = 4;
            foreach (var value in values)
                size += _model.FBEAllocationSize(value);
            return size;
        }
        public long FBEAllocationSize(LinkedList<T> values)
        {
            long size = 4;
            foreach (var value in values)
                size += _model.FBEAllocationSize(value);
            return size;
        }
        public long FBEAllocationSize(HashSet<T> values)
        {
            long size = 4;
            foreach (var value in values)
                size += _model.FBEAllocationSize(value);
            return size;
        }

        // Clone the final model
        public FinalModelVectorOptionalReferenceType<T, TModel> Clone() { return new FinalModelVectorOptionalReferenceType<T, TModel>(_model.Value, _buffer, _offset); }

        // Check if the vector is valid
        public virtual long Verify()
        {
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return long.MaxValue;

            uint fbeVectorSize = ReadUInt32(FBEOffset);

            long size = 4;
            _model.FBEOffset = FBEOffset + 4;
            for (uint i = fbeVectorSize; i-- > 0;)
            {
                long offset = _model.Verify();
                if (offset == long.MaxValue)
                    return long.MaxValue;
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }

        // Get the vector as List
        public long Get(out List<T> values)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
            {
                values = new List<T>();
                return 0;
            }

            long fbeVectorSize = ReadUInt32(FBEOffset);
            if (fbeVectorSize == 0)
            {
                values = new List<T>();
                return 4;
            }

            values = new List<T>((int)fbeVectorSize);

            long size = 4;
            _model.FBEOffset = FBEOffset + 4;
            for (long i = fbeVectorSize; i-- > 0;)
            {
                long offset = _model.Get(out var value);
                values.Add(value);
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }

        // Get the vector as LinkedList
        public long Get(out LinkedList<T> values)
        {
            values = new LinkedList<T>();

            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return 0;

            long fbeVectorSize = ReadUInt32(FBEOffset);
            if (fbeVectorSize == 0)
                return 4;

            long size = 4;
            _model.FBEOffset = FBEOffset + 4;
            for (long i = fbeVectorSize; i-- > 0;)
            {
                long offset = _model.Get(out var value);
                values.AddLast(value);
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }

        // Get the vector as HashSet
        public long Get(out HashSet<T> values)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
            {
                values = new HashSet<T>();
                return 0;
            }

            long fbeVectorSize = ReadUInt32(FBEOffset);
            if (fbeVectorSize == 0)
            {
                values = new HashSet<T>();
                return 4;
            }

            values = new HashSet<T>((int)fbeVectorSize);

            long size = 4;
            _model.FBEOffset = FBEOffset + 4;
            for (long i = fbeVectorSize; i-- > 0;)
            {
                long offset = _model.Get(out var value);
                values.Add(value);
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }

        // Set the vector as List
        public long Set(List<T> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return 0;

            Write(FBEOffset, (uint)values.Count);

            long size = 4;
            _model.FBEOffset = FBEOffset + 4;
            foreach (var value in values)
            {
                long offset = _model.Set(value);
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }

        // Set the vector as LinkedList
        public long Set(LinkedList<T> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return 0;

            Write(FBEOffset, (uint)values.Count);

            long size = 4;
            _model.FBEOffset = FBEOffset + 4;
            foreach (var value in values)
            {
                long offset = _model.Set(value);
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }

        // Set the vector as HashSet
        public long Set(HashSet<T> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + FBESize) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + FBESize) > _buffer.Size)
                return 0;

            Write(FBEOffset, (uint)values.Count);

            long size = 4;
            _model.FBEOffset = FBEOffset + 4;
            foreach (var value in values)
            {
                long offset = _model.Set(value);
                _model.FBEShift(offset);
                size += offset;
            }
            return size;
        }
    }

    // Fast Binary Encoding final model map (value type key, value type value)
    public class FinalModelMapValueTypeKeyValueTypeValue<TKey, TKeyModel, TValue, TValueModel> : FieldModelBase
        where TKey : struct
        where TKeyModel : FinalModelValueType<TKey>
        where TValue : struct
        where TValueModel : FinalModelValueType<TValue>
    {
        private readonly TKeyModel _modelKey;
        private readonly TValueModel _modelValue;

        public FinalModelMapValueTypeKeyValueTypeValue(TKeyModel modelKey, TValueModel modelValue, Buffer buffer, long offset) : base(buffer, offset)
        {
            _modelKey = modelKey.Clone() as TKeyModel;
            _modelValue = modelValue.Clone() as TValueModel;
        }

        // Get the allocation size
        public long FBEAllocationSize(Dictionary<TKey, TValue> values)
        {
            long size = 4;
            foreach (var value in values)
            {
                size += _modelKey.FBEAllocationSize(value.Key);
                size += _modelValue.FBEAllocationSize(value.Value);
            }
            return size;
        }
        public long FBEAllocationSize(SortedDictionary<TKey, TValue> values)
        {
            long size = 4;
            foreach (var value in values)
            {
                size += _modelKey.FBEAllocationSize(value.Key);
                size += _modelValue.FBEAllocationSize(value.Value);
            }
            return size;
        }

        // Clone the final model
        public FinalModelMapValueTypeKeyValueTypeValue<TKey, TKeyModel, TValue, TValueModel> Clone() { return new FinalModelMapValueTypeKeyValueTypeValue<TKey, TKeyModel, TValue, TValueModel>(_modelKey, _modelValue, _buffer, _offset); }

        // Check if the map is valid
        public virtual long Verify()
        {
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return long.MaxValue;

            uint fbeMapSize = ReadUInt32(FBEOffset);

            long size = 4;
            _modelKey.FBEOffset = FBEOffset + 4;
            _modelValue.FBEOffset = FBEOffset + 4;
            for (uint i = fbeMapSize; i-- > 0;)
            {
                long offsetKey = _modelKey.Verify();
                if (offsetKey == long.MaxValue)
                    return long.MaxValue;
                _modelKey.FBEShift(offsetKey);
                _modelValue.FBEShift(offsetKey);
                size += offsetKey;
                long offsetValue = _modelValue.Verify();
                if (offsetValue == long.MaxValue)
                    return long.MaxValue;
                _modelKey.FBEShift(offsetValue);
                _modelValue.FBEShift(offsetValue);
                size += offsetValue;
            }
            return size;
        }

        // Get the map as Dictionary
        public long Get(out Dictionary<TKey, TValue> values)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
            {
                values = new Dictionary<TKey, TValue>();
                return 0;
            }

            long fbeMapSize = ReadUInt32(FBEOffset);
            if (fbeMapSize == 0)
            {
                values = new Dictionary<TKey, TValue>();
                return 4;
            }

            values = new Dictionary<TKey, TValue>((int)fbeMapSize);

            long size = 4;
            _modelKey.FBEOffset = FBEOffset + 4;
            _modelValue.FBEOffset = FBEOffset + 4;
            for (long i = fbeMapSize; i-- > 0;)
            {
                long offsetKey = _modelKey.Get(out var key);
                _modelKey.FBEShift(offsetKey);
                _modelValue.FBEShift(offsetKey);
                long offsetValue = _modelValue.Get(out var value);
                _modelKey.FBEShift(offsetValue);
                _modelValue.FBEShift(offsetValue);
                values.Add(key, value);
                size += offsetKey + offsetValue;
            }
            return size;
        }

        // Get the map as SortedDictionary
        public long Get(out SortedDictionary<TKey, TValue> values)
        {
            values = new SortedDictionary<TKey, TValue>();

            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return 0;

            long fbeMapSize = ReadUInt32(FBEOffset);
            if (fbeMapSize == 0)
                return 4;

            long size = 4;
            _modelKey.FBEOffset = FBEOffset + 4;
            _modelValue.FBEOffset = FBEOffset + 4;
            for (long i = fbeMapSize; i-- > 0;)
            {
                long offsetKey = _modelKey.Get(out var key);
                _modelKey.FBEShift(offsetKey);
                _modelValue.FBEShift(offsetKey);
                long offsetValue = _modelValue.Get(out var value);
                _modelKey.FBEShift(offsetValue);
                _modelValue.FBEShift(offsetValue);
                values.Add(key, value);
                size += offsetKey + offsetValue;
            }
            return size;
        }

        // Set the map as Dictionary
        public long Set(Dictionary<TKey, TValue> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return 0;

            Write(FBEOffset, (uint)values.Count);

            long size = 4;
            _modelKey.FBEOffset = FBEOffset + 4;
            _modelValue.FBEOffset = FBEOffset + 4;
            foreach (var value in values)
            {
                long offsetKey = _modelKey.Set(value.Key);
                _modelKey.FBEShift(offsetKey);
                _modelValue.FBEShift(offsetKey);
                long offsetValue = _modelValue.Set(value.Value);
                _modelKey.FBEShift(offsetValue);
                _modelValue.FBEShift(offsetValue);
                size += offsetKey + offsetValue;
            }
            return size;
        }

        // Set the map as SortedDictionary
        public long Set(SortedDictionary<TKey, TValue> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return 0;

            Write(FBEOffset, (uint)values.Count);

            long size = 4;
            _modelKey.FBEOffset = FBEOffset + 4;
            _modelValue.FBEOffset = FBEOffset + 4;
            foreach (var value in values)
            {
                long offsetKey = _modelKey.Set(value.Key);
                _modelKey.FBEShift(offsetKey);
                _modelValue.FBEShift(offsetKey);
                long offsetValue = _modelValue.Set(value.Value);
                _modelKey.FBEShift(offsetValue);
                _modelValue.FBEShift(offsetValue);
                size += offsetKey + offsetValue;
            }
            return size;
        }
    }

    // Fast Binary Encoding final model map (value type key, reference type value)
    public class FinalModelMapValueTypeKeyReferenceTypeValue<TKey, TKeyModel, TValue, TValueModel> : FieldModelBase
        where TKey : struct
        where TKeyModel : FinalModelValueType<TKey>
        where TValue : class
        where TValueModel : FinalModelReferenceType<TValue>
    {
        private readonly TKeyModel _modelKey;
        private readonly TValueModel _modelValue;

        public FinalModelMapValueTypeKeyReferenceTypeValue(TKeyModel modelKey, TValueModel modelValue, Buffer buffer, long offset) : base(buffer, offset)
        {
            _modelKey = modelKey.Clone() as TKeyModel;
            _modelValue = modelValue.Clone() as TValueModel;
        }

        // Get the allocation size
        public long FBEAllocationSize(Dictionary<TKey, TValue> values)
        {
            long size = 4;
            foreach (var value in values)
            {
                size += _modelKey.FBEAllocationSize(value.Key);
                size += _modelValue.FBEAllocationSize(value.Value);
            }
            return size;
        }
        public long FBEAllocationSize(SortedDictionary<TKey, TValue> values)
        {
            long size = 4;
            foreach (var value in values)
            {
                size += _modelKey.FBEAllocationSize(value.Key);
                size += _modelValue.FBEAllocationSize(value.Value);
            }
            return size;
        }

        // Clone the final model
        public FinalModelMapValueTypeKeyReferenceTypeValue<TKey, TKeyModel, TValue, TValueModel> Clone() { return new FinalModelMapValueTypeKeyReferenceTypeValue<TKey, TKeyModel, TValue, TValueModel>(_modelKey, _modelValue, _buffer, _offset); }

        // Check if the map is valid
        public virtual long Verify()
        {
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return long.MaxValue;

            uint fbeMapSize = ReadUInt32(FBEOffset);

            long size = 4;
            _modelKey.FBEOffset = FBEOffset + 4;
            _modelValue.FBEOffset = FBEOffset + 4;
            for (uint i = fbeMapSize; i-- > 0;)
            {
                long offsetKey = _modelKey.Verify();
                if (offsetKey == long.MaxValue)
                    return long.MaxValue;
                _modelKey.FBEShift(offsetKey);
                _modelValue.FBEShift(offsetKey);
                size += offsetKey;
                long offsetValue = _modelValue.Verify();
                if (offsetValue == long.MaxValue)
                    return long.MaxValue;
                _modelKey.FBEShift(offsetValue);
                _modelValue.FBEShift(offsetValue);
                size += offsetValue;
            }
            return size;
        }

        // Get the map as Dictionary
        public long Get(out Dictionary<TKey, TValue> values)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
            {
                values = new Dictionary<TKey, TValue>();
                return 0;
            }

            long fbeMapSize = ReadUInt32(FBEOffset);
            if (fbeMapSize == 0)
            {
                values = new Dictionary<TKey, TValue>();
                return 4;
            }

            values = new Dictionary<TKey, TValue>((int)fbeMapSize);

            long size = 4;
            _modelKey.FBEOffset = FBEOffset + 4;
            _modelValue.FBEOffset = FBEOffset + 4;
            for (long i = fbeMapSize; i-- > 0;)
            {
                long offsetKey = _modelKey.Get(out var key);
                _modelKey.FBEShift(offsetKey);
                _modelValue.FBEShift(offsetKey);
                long offsetValue = _modelValue.Get(out var value);
                _modelKey.FBEShift(offsetValue);
                _modelValue.FBEShift(offsetValue);
                values.Add(key, value);
                size += offsetKey + offsetValue;
            }
            return size;
        }

        // Get the map as SortedDictionary
        public long Get(out SortedDictionary<TKey, TValue> values)
        {
            values = new SortedDictionary<TKey, TValue>();

            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return 0;

            long fbeMapSize = ReadUInt32(FBEOffset);
            if (fbeMapSize == 0)
                return 4;

            long size = 4;
            _modelKey.FBEOffset = FBEOffset + 4;
            _modelValue.FBEOffset = FBEOffset + 4;
            for (long i = fbeMapSize; i-- > 0;)
            {
                long offsetKey = _modelKey.Get(out var key);
                _modelKey.FBEShift(offsetKey);
                _modelValue.FBEShift(offsetKey);
                long offsetValue = _modelValue.Get(out var value);
                _modelKey.FBEShift(offsetValue);
                _modelValue.FBEShift(offsetValue);
                values.Add(key, value);
                size += offsetKey + offsetValue;
            }
            return size;
        }

        // Set the map as Dictionary
        public long Set(Dictionary<TKey, TValue> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return 0;

            Write(FBEOffset, (uint)values.Count);

            long size = 4;
            _modelKey.FBEOffset = FBEOffset + 4;
            _modelValue.FBEOffset = FBEOffset + 4;
            foreach (var value in values)
            {
                long offsetKey = _modelKey.Set(value.Key);
                _modelKey.FBEShift(offsetKey);
                _modelValue.FBEShift(offsetKey);
                long offsetValue = _modelValue.Set(value.Value);
                _modelKey.FBEShift(offsetValue);
                _modelValue.FBEShift(offsetValue);
                size += offsetKey + offsetValue;
            }
            return size;
        }

        // Set the map as SortedDictionary
        public long Set(SortedDictionary<TKey, TValue> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return 0;

            Write(FBEOffset, (uint)values.Count);

            long size = 4;
            _modelKey.FBEOffset = FBEOffset + 4;
            _modelValue.FBEOffset = FBEOffset + 4;
            foreach (var value in values)
            {
                long offsetKey = _modelKey.Set(value.Key);
                _modelKey.FBEShift(offsetKey);
                _modelValue.FBEShift(offsetKey);
                long offsetValue = _modelValue.Set(value.Value);
                _modelKey.FBEShift(offsetValue);
                _modelValue.FBEShift(offsetValue);
                size += offsetKey + offsetValue;
            }
            return size;
        }
    }

    // Fast Binary Encoding final model map (value type key, optional value type value)
    public class FinalModelMapValueTypeKeyOptionalValueTypeValue<TKey, TKeyModel, TValue, TValueModel> : FieldModelBase
        where TKey : struct
        where TKeyModel : FinalModelValueType<TKey>
        where TValue : struct
        where TValueModel : FinalModelValueType<TValue>
    {
        private readonly TKeyModel _modelKey;
        private readonly FinalModelOptionalValueType<TValue, TValueModel> _modelValue;

        public FinalModelMapValueTypeKeyOptionalValueTypeValue(TKeyModel modelKey, TValueModel modelValue, Buffer buffer, long offset) : base(buffer, offset)
        {
            _modelKey = modelKey.Clone() as TKeyModel;
            _modelValue = new FinalModelOptionalValueType<TValue, TValueModel>(modelValue, buffer, offset);
        }

        // Get the allocation size
        public long FBEAllocationSize(Dictionary<TKey, TValue?> values)
        {
            long size = 4;
            foreach (var value in values)
            {
                size += _modelKey.FBEAllocationSize(value.Key);
                size += _modelValue.FBEAllocationSize(value.Value);
            }
            return size;
        }
        public long FBEAllocationSize(SortedDictionary<TKey, TValue?> values)
        {
            long size = 4;
            foreach (var value in values)
            {
                size += _modelKey.FBEAllocationSize(value.Key);
                size += _modelValue.FBEAllocationSize(value.Value);
            }
            return size;
        }

        // Clone the final model
        public FinalModelMapValueTypeKeyOptionalValueTypeValue<TKey, TKeyModel, TValue, TValueModel> Clone() { return new FinalModelMapValueTypeKeyOptionalValueTypeValue<TKey, TKeyModel, TValue, TValueModel>(_modelKey, _modelValue.Value, _buffer, _offset); }

        // Check if the map is valid
        public virtual long Verify()
        {
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return long.MaxValue;

            uint fbeMapSize = ReadUInt32(FBEOffset);

            long size = 4;
            _modelKey.FBEOffset = FBEOffset + 4;
            _modelValue.FBEOffset = FBEOffset + 4;
            for (uint i = fbeMapSize; i-- > 0;)
            {
                long offsetKey = _modelKey.Verify();
                if (offsetKey == long.MaxValue)
                    return long.MaxValue;
                _modelKey.FBEShift(offsetKey);
                _modelValue.FBEShift(offsetKey);
                size += offsetKey;
                long offsetValue = _modelValue.Verify();
                if (offsetValue == long.MaxValue)
                    return long.MaxValue;
                _modelKey.FBEShift(offsetValue);
                _modelValue.FBEShift(offsetValue);
                size += offsetValue;
            }
            return size;
        }

        // Get the map as Dictionary
        public long Get(out Dictionary<TKey, TValue?> values)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
            {
                values = new Dictionary<TKey, TValue?>();
                return 0;
            }

            long fbeMapSize = ReadUInt32(FBEOffset);
            if (fbeMapSize == 0)
            {
                values = new Dictionary<TKey, TValue?>();
                return 4;
            }

            values = new Dictionary<TKey, TValue?>((int)fbeMapSize);

            long size = 4;
            _modelKey.FBEOffset = FBEOffset + 4;
            _modelValue.FBEOffset = FBEOffset + 4;
            for (long i = fbeMapSize; i-- > 0;)
            {
                long offsetKey = _modelKey.Get(out var key);
                _modelKey.FBEShift(offsetKey);
                _modelValue.FBEShift(offsetKey);
                long offsetValue = _modelValue.Get(out var value);
                _modelKey.FBEShift(offsetValue);
                _modelValue.FBEShift(offsetValue);
                values.Add(key, value);
                size += offsetKey + offsetValue;
            }
            return size;
        }

        // Get the map as SortedDictionary
        public long Get(out SortedDictionary<TKey, TValue?> values)
        {
            values = new SortedDictionary<TKey, TValue?>();

            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return 0;

            long fbeMapSize = ReadUInt32(FBEOffset);
            if (fbeMapSize == 0)
                return 4;

            long size = 4;
            _modelKey.FBEOffset = FBEOffset + 4;
            _modelValue.FBEOffset = FBEOffset + 4;
            for (long i = fbeMapSize; i-- > 0;)
            {
                long offsetKey = _modelKey.Get(out var key);
                _modelKey.FBEShift(offsetKey);
                _modelValue.FBEShift(offsetKey);
                long offsetValue = _modelValue.Get(out var value);
                _modelKey.FBEShift(offsetValue);
                _modelValue.FBEShift(offsetValue);
                values.Add(key, value);
                size += offsetKey + offsetValue;
            }
            return size;
        }

        // Set the map as Dictionary
        public long Set(Dictionary<TKey, TValue?> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return 0;

            Write(FBEOffset, (uint)values.Count);

            long size = 4;
            _modelKey.FBEOffset = FBEOffset + 4;
            _modelValue.FBEOffset = FBEOffset + 4;
            foreach (var value in values)
            {
                long offsetKey = _modelKey.Set(value.Key);
                _modelKey.FBEShift(offsetKey);
                _modelValue.FBEShift(offsetKey);
                long offsetValue = _modelValue.Set(value.Value);
                _modelKey.FBEShift(offsetValue);
                _modelValue.FBEShift(offsetValue);
                size += offsetKey + offsetValue;
            }
            return size;
        }

        // Set the map as SortedDictionary
        public long Set(SortedDictionary<TKey, TValue?> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return 0;

            Write(FBEOffset, (uint)values.Count);

            long size = 4;
            _modelKey.FBEOffset = FBEOffset + 4;
            _modelValue.FBEOffset = FBEOffset + 4;
            foreach (var value in values)
            {
                long offsetKey = _modelKey.Set(value.Key);
                _modelKey.FBEShift(offsetKey);
                _modelValue.FBEShift(offsetKey);
                long offsetValue = _modelValue.Set(value.Value);
                _modelKey.FBEShift(offsetValue);
                _modelValue.FBEShift(offsetValue);
                size += offsetKey + offsetValue;
            }
            return size;
        }
    }

    // Fast Binary Encoding final model map (value type key, optional reference type value)
    public class FinalModelMapValueTypeKeyOptionalReferenceTypeValue<TKey, TKeyModel, TValue, TValueModel> : FieldModelBase
        where TKey : struct
        where TKeyModel : FinalModelValueType<TKey>
        where TValue : class
        where TValueModel : FinalModelReferenceType<TValue>
    {
        private readonly TKeyModel _modelKey;
        private readonly FinalModelOptionalReferenceType<TValue, TValueModel> _modelValue;

        public FinalModelMapValueTypeKeyOptionalReferenceTypeValue(TKeyModel modelKey, TValueModel modelValue, Buffer buffer, long offset) : base(buffer, offset)
        {
            _modelKey = modelKey.Clone() as TKeyModel;
            _modelValue = new FinalModelOptionalReferenceType<TValue, TValueModel>(modelValue, buffer, offset);
        }

        // Get the allocation size
        public long FBEAllocationSize(Dictionary<TKey, TValue> values)
        {
            long size = 4;
            foreach (var value in values)
            {
                size += _modelKey.FBEAllocationSize(value.Key);
                size += _modelValue.FBEAllocationSize(value.Value);
            }
            return size;
        }
        public long FBEAllocationSize(SortedDictionary<TKey, TValue> values)
        {
            long size = 4;
            foreach (var value in values)
            {
                size += _modelKey.FBEAllocationSize(value.Key);
                size += _modelValue.FBEAllocationSize(value.Value);
            }
            return size;
        }

        // Clone the final model
        public FinalModelMapValueTypeKeyOptionalReferenceTypeValue<TKey, TKeyModel, TValue, TValueModel> Clone() { return new FinalModelMapValueTypeKeyOptionalReferenceTypeValue<TKey, TKeyModel, TValue, TValueModel>(_modelKey, _modelValue.Value, _buffer, _offset); }

        // Check if the map is valid
        public virtual long Verify()
        {
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return long.MaxValue;

            uint fbeMapSize = ReadUInt32(FBEOffset);

            long size = 4;
            _modelKey.FBEOffset = FBEOffset + 4;
            _modelValue.FBEOffset = FBEOffset + 4;
            for (uint i = fbeMapSize; i-- > 0;)
            {
                long offsetKey = _modelKey.Verify();
                if (offsetKey == long.MaxValue)
                    return long.MaxValue;
                _modelKey.FBEShift(offsetKey);
                _modelValue.FBEShift(offsetKey);
                size += offsetKey;
                long offsetValue = _modelValue.Verify();
                if (offsetValue == long.MaxValue)
                    return long.MaxValue;
                _modelKey.FBEShift(offsetValue);
                _modelValue.FBEShift(offsetValue);
                size += offsetValue;
            }
            return size;
        }

        // Get the map as Dictionary
        public long Get(out Dictionary<TKey, TValue> values)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
            {
                values = new Dictionary<TKey, TValue>();
                return 0;
            }

            long fbeMapSize = ReadUInt32(FBEOffset);
            if (fbeMapSize == 0)
            {
                values = new Dictionary<TKey, TValue>();
                return 4;
            }

            values = new Dictionary<TKey, TValue>((int)fbeMapSize);

            long size = 4;
            _modelKey.FBEOffset = FBEOffset + 4;
            _modelValue.FBEOffset = FBEOffset + 4;
            for (long i = fbeMapSize; i-- > 0;)
            {
                long offsetKey = _modelKey.Get(out var key);
                _modelKey.FBEShift(offsetKey);
                _modelValue.FBEShift(offsetKey);
                long offsetValue = _modelValue.Get(out var value);
                _modelKey.FBEShift(offsetValue);
                _modelValue.FBEShift(offsetValue);
                values.Add(key, value);
                size += offsetKey + offsetValue;
            }
            return size;
        }

        // Get the map as SortedDictionary
        public long Get(out SortedDictionary<TKey, TValue> values)
        {
            values = new SortedDictionary<TKey, TValue>();

            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return 0;

            long fbeMapSize = ReadUInt32(FBEOffset);
            if (fbeMapSize == 0)
                return 4;

            long size = 4;
            _modelKey.FBEOffset = FBEOffset + 4;
            _modelValue.FBEOffset = FBEOffset + 4;
            for (long i = fbeMapSize; i-- > 0;)
            {
                long offsetKey = _modelKey.Get(out var key);
                _modelKey.FBEShift(offsetKey);
                _modelValue.FBEShift(offsetKey);
                long offsetValue = _modelValue.Get(out var value);
                _modelKey.FBEShift(offsetValue);
                _modelValue.FBEShift(offsetValue);
                values.Add(key, value);
                size += offsetKey + offsetValue;
            }
            return size;
        }

        // Set the map as Dictionary
        public long Set(Dictionary<TKey, TValue> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return 0;

            Write(FBEOffset, (uint)values.Count);

            long size = 4;
            _modelKey.FBEOffset = FBEOffset + 4;
            _modelValue.FBEOffset = FBEOffset + 4;
            foreach (var value in values)
            {
                long offsetKey = _modelKey.Set(value.Key);
                _modelKey.FBEShift(offsetKey);
                _modelValue.FBEShift(offsetKey);
                long offsetValue = _modelValue.Set(value.Value);
                _modelKey.FBEShift(offsetValue);
                _modelValue.FBEShift(offsetValue);
                size += offsetKey + offsetValue;
            }
            return size;
        }

        // Set the map as SortedDictionary
        public long Set(SortedDictionary<TKey, TValue> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return 0;

            Write(FBEOffset, (uint)values.Count);

            long size = 4;
            _modelKey.FBEOffset = FBEOffset + 4;
            _modelValue.FBEOffset = FBEOffset + 4;
            foreach (var value in values)
            {
                long offsetKey = _modelKey.Set(value.Key);
                _modelKey.FBEShift(offsetKey);
                _modelValue.FBEShift(offsetKey);
                long offsetValue = _modelValue.Set(value.Value);
                _modelKey.FBEShift(offsetValue);
                _modelValue.FBEShift(offsetValue);
                size += offsetKey + offsetValue;
            }
            return size;
        }
    }

    // Fast Binary Encoding final model map (reference type key, value type value)
    public class FinalModelMapReferenceTypeKeyValueTypeValue<TKey, TKeyModel, TValue, TValueModel> : FieldModelBase
        where TKey : class
        where TKeyModel : FinalModelReferenceType<TKey>
        where TValue : struct
        where TValueModel : FinalModelValueType<TValue>
    {
        private readonly TKeyModel _modelKey;
        private readonly TValueModel _modelValue;

        public FinalModelMapReferenceTypeKeyValueTypeValue(TKeyModel modelKey, TValueModel modelValue, Buffer buffer, long offset) : base(buffer, offset)
        {
            _modelKey = modelKey.Clone() as TKeyModel;
            _modelValue = modelValue.Clone() as TValueModel;
        }

        // Get the allocation size
        public long FBEAllocationSize(Dictionary<TKey, TValue> values)
        {
            long size = 4;
            foreach (var value in values)
            {
                size += _modelKey.FBEAllocationSize(value.Key);
                size += _modelValue.FBEAllocationSize(value.Value);
            }
            return size;
        }
        public long FBEAllocationSize(SortedDictionary<TKey, TValue> values)
        {
            long size = 4;
            foreach (var value in values)
            {
                size += _modelKey.FBEAllocationSize(value.Key);
                size += _modelValue.FBEAllocationSize(value.Value);
            }
            return size;
        }

        // Clone the final model
        public FinalModelMapReferenceTypeKeyValueTypeValue<TKey, TKeyModel, TValue, TValueModel> Clone() { return new FinalModelMapReferenceTypeKeyValueTypeValue<TKey, TKeyModel, TValue, TValueModel>(_modelKey, _modelValue, _buffer, _offset); }

        // Check if the map is valid
        public virtual long Verify()
        {
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return long.MaxValue;

            uint fbeMapSize = ReadUInt32(FBEOffset);

            long size = 4;
            _modelKey.FBEOffset = FBEOffset + 4;
            _modelValue.FBEOffset = FBEOffset + 4;
            for (uint i = fbeMapSize; i-- > 0;)
            {
                long offsetKey = _modelKey.Verify();
                if (offsetKey == long.MaxValue)
                    return long.MaxValue;
                _modelKey.FBEShift(offsetKey);
                _modelValue.FBEShift(offsetKey);
                size += offsetKey;
                long offsetValue = _modelValue.Verify();
                if (offsetValue == long.MaxValue)
                    return long.MaxValue;
                _modelKey.FBEShift(offsetValue);
                _modelValue.FBEShift(offsetValue);
                size += offsetValue;
            }
            return size;
        }

        // Get the map as Dictionary
        public long Get(out Dictionary<TKey, TValue> values)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
            {
                values = new Dictionary<TKey, TValue>();
                return 0;
            }

            long fbeMapSize = ReadUInt32(FBEOffset);
            if (fbeMapSize == 0)
            {
                values = new Dictionary<TKey, TValue>();
                return 4;
            }

            values = new Dictionary<TKey, TValue>((int)fbeMapSize);

            long size = 4;
            _modelKey.FBEOffset = FBEOffset + 4;
            _modelValue.FBEOffset = FBEOffset + 4;
            for (long i = fbeMapSize; i-- > 0;)
            {
                long offsetKey = _modelKey.Get(out var key);
                _modelKey.FBEShift(offsetKey);
                _modelValue.FBEShift(offsetKey);
                long offsetValue = _modelValue.Get(out var value);
                _modelKey.FBEShift(offsetValue);
                _modelValue.FBEShift(offsetValue);
                values.Add(key, value);
                size += offsetKey + offsetValue;
            }
            return size;
        }

        // Get the map as SortedDictionary
        public long Get(out SortedDictionary<TKey, TValue> values)
        {
            values = new SortedDictionary<TKey, TValue>();

            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return 0;

            long fbeMapSize = ReadUInt32(FBEOffset);
            if (fbeMapSize == 0)
                return 4;

            long size = 4;
            _modelKey.FBEOffset = FBEOffset + 4;
            _modelValue.FBEOffset = FBEOffset + 4;
            for (long i = fbeMapSize; i-- > 0;)
            {
                long offsetKey = _modelKey.Get(out var key);
                _modelKey.FBEShift(offsetKey);
                _modelValue.FBEShift(offsetKey);
                long offsetValue = _modelValue.Get(out var value);
                _modelKey.FBEShift(offsetValue);
                _modelValue.FBEShift(offsetValue);
                values.Add(key, value);
                size += offsetKey + offsetValue;
            }
            return size;
        }

        // Set the map as Dictionary
        public long Set(Dictionary<TKey, TValue> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return 0;

            Write(FBEOffset, (uint)values.Count);

            long size = 4;
            _modelKey.FBEOffset = FBEOffset + 4;
            _modelValue.FBEOffset = FBEOffset + 4;
            foreach (var value in values)
            {
                long offsetKey = _modelKey.Set(value.Key);
                _modelKey.FBEShift(offsetKey);
                _modelValue.FBEShift(offsetKey);
                long offsetValue = _modelValue.Set(value.Value);
                _modelKey.FBEShift(offsetValue);
                _modelValue.FBEShift(offsetValue);
                size += offsetKey + offsetValue;
            }
            return size;
        }

        // Set the map as SortedDictionary
        public long Set(SortedDictionary<TKey, TValue> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return 0;

            Write(FBEOffset, (uint)values.Count);

            long size = 4;
            _modelKey.FBEOffset = FBEOffset + 4;
            _modelValue.FBEOffset = FBEOffset + 4;
            foreach (var value in values)
            {
                long offsetKey = _modelKey.Set(value.Key);
                _modelKey.FBEShift(offsetKey);
                _modelValue.FBEShift(offsetKey);
                long offsetValue = _modelValue.Set(value.Value);
                _modelKey.FBEShift(offsetValue);
                _modelValue.FBEShift(offsetValue);
                size += offsetKey + offsetValue;
            }
            return size;
        }
    }

    // Fast Binary Encoding final model map (reference type key, reference type value)
    public class FinalModelMapReferenceTypeKeyReferenceTypeValue<TKey, TKeyModel, TValue, TValueModel> : FieldModelBase
        where TKey : class
        where TKeyModel : FinalModelReferenceType<TKey>
        where TValue : class
        where TValueModel : FinalModelReferenceType<TValue>
    {
        private readonly TKeyModel _modelKey;
        private readonly TValueModel _modelValue;

        public FinalModelMapReferenceTypeKeyReferenceTypeValue(TKeyModel modelKey, TValueModel modelValue, Buffer buffer, long offset) : base(buffer, offset)
        {
            _modelKey = modelKey.Clone() as TKeyModel;
            _modelValue = modelValue.Clone() as TValueModel;
        }

        // Get the allocation size
        public long FBEAllocationSize(Dictionary<TKey, TValue> values)
        {
            long size = 4;
            foreach (var value in values)
            {
                size += _modelKey.FBEAllocationSize(value.Key);
                size += _modelValue.FBEAllocationSize(value.Value);
            }
            return size;
        }
        public long FBEAllocationSize(SortedDictionary<TKey, TValue> values)
        {
            long size = 4;
            foreach (var value in values)
            {
                size += _modelKey.FBEAllocationSize(value.Key);
                size += _modelValue.FBEAllocationSize(value.Value);
            }
            return size;
        }

        // Clone the final model
        public FinalModelMapReferenceTypeKeyReferenceTypeValue<TKey, TKeyModel, TValue, TValueModel> Clone() { return new FinalModelMapReferenceTypeKeyReferenceTypeValue<TKey, TKeyModel, TValue, TValueModel>(_modelKey, _modelValue, _buffer, _offset); }

        // Check if the map is valid
        public virtual long Verify()
        {
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return long.MaxValue;

            uint fbeMapSize = ReadUInt32(FBEOffset);

            long size = 4;
            _modelKey.FBEOffset = FBEOffset + 4;
            _modelValue.FBEOffset = FBEOffset + 4;
            for (uint i = fbeMapSize; i-- > 0;)
            {
                long offsetKey = _modelKey.Verify();
                if (offsetKey == long.MaxValue)
                    return long.MaxValue;
                _modelKey.FBEShift(offsetKey);
                _modelValue.FBEShift(offsetKey);
                size += offsetKey;
                long offsetValue = _modelValue.Verify();
                if (offsetValue == long.MaxValue)
                    return long.MaxValue;
                _modelKey.FBEShift(offsetValue);
                _modelValue.FBEShift(offsetValue);
                size += offsetValue;
            }
            return size;
        }

        // Get the map as Dictionary
        public long Get(out Dictionary<TKey, TValue> values)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
            {
                values = new Dictionary<TKey, TValue>();
                return 0;
            }

            long fbeMapSize = ReadUInt32(FBEOffset);
            if (fbeMapSize == 0)
            {
                values = new Dictionary<TKey, TValue>();
                return 4;
            }

            values = new Dictionary<TKey, TValue>((int)fbeMapSize);

            long size = 4;
            _modelKey.FBEOffset = FBEOffset + 4;
            _modelValue.FBEOffset = FBEOffset + 4;
            for (long i = fbeMapSize; i-- > 0;)
            {
                long offsetKey = _modelKey.Get(out var key);
                _modelKey.FBEShift(offsetKey);
                _modelValue.FBEShift(offsetKey);
                long offsetValue = _modelValue.Get(out var value);
                _modelKey.FBEShift(offsetValue);
                _modelValue.FBEShift(offsetValue);
                values.Add(key, value);
                size += offsetKey + offsetValue;
            }
            return size;
        }

        // Get the map as SortedDictionary
        public long Get(out SortedDictionary<TKey, TValue> values)
        {
            values = new SortedDictionary<TKey, TValue>();

            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return 0;

            long fbeMapSize = ReadUInt32(FBEOffset);
            if (fbeMapSize == 0)
                return 4;

            long size = 4;
            _modelKey.FBEOffset = FBEOffset + 4;
            _modelValue.FBEOffset = FBEOffset + 4;
            for (long i = fbeMapSize; i-- > 0;)
            {
                long offsetKey = _modelKey.Get(out var key);
                _modelKey.FBEShift(offsetKey);
                _modelValue.FBEShift(offsetKey);
                long offsetValue = _modelValue.Get(out var value);
                _modelKey.FBEShift(offsetValue);
                _modelValue.FBEShift(offsetValue);
                values.Add(key, value);
                size += offsetKey + offsetValue;
            }
            return size;
        }

        // Set the map as Dictionary
        public long Set(Dictionary<TKey, TValue> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return 0;

            Write(FBEOffset, (uint)values.Count);

            long size = 4;
            _modelKey.FBEOffset = FBEOffset + 4;
            _modelValue.FBEOffset = FBEOffset + 4;
            foreach (var value in values)
            {
                long offsetKey = _modelKey.Set(value.Key);
                _modelKey.FBEShift(offsetKey);
                _modelValue.FBEShift(offsetKey);
                long offsetValue = _modelValue.Set(value.Value);
                _modelKey.FBEShift(offsetValue);
                _modelValue.FBEShift(offsetValue);
                size += offsetKey + offsetValue;
            }
            return size;
        }

        // Set the map as SortedDictionary
        public long Set(SortedDictionary<TKey, TValue> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return 0;

            Write(FBEOffset, (uint)values.Count);

            long size = 4;
            _modelKey.FBEOffset = FBEOffset + 4;
            _modelValue.FBEOffset = FBEOffset + 4;
            foreach (var value in values)
            {
                long offsetKey = _modelKey.Set(value.Key);
                _modelKey.FBEShift(offsetKey);
                _modelValue.FBEShift(offsetKey);
                long offsetValue = _modelValue.Set(value.Value);
                _modelKey.FBEShift(offsetValue);
                _modelValue.FBEShift(offsetValue);
                size += offsetKey + offsetValue;
            }
            return size;
        }
    }

    // Fast Binary Encoding final model map (reference type key, optional value type value)
    public class FinalModelMapReferenceTypeKeyOptionalValueTypeValue<TKey, TKeyModel, TValue, TValueModel> : FieldModelBase
        where TKey : class
        where TKeyModel : FinalModelReferenceType<TKey>
        where TValue : struct
        where TValueModel : FinalModelValueType<TValue>
    {
        private readonly TKeyModel _modelKey;
        private readonly FinalModelOptionalValueType<TValue, TValueModel> _modelValue;

        public FinalModelMapReferenceTypeKeyOptionalValueTypeValue(TKeyModel modelKey, TValueModel modelValue, Buffer buffer, long offset) : base(buffer, offset)
        {
            _modelKey = modelKey.Clone() as TKeyModel;
            _modelValue = new FinalModelOptionalValueType<TValue, TValueModel>(modelValue, buffer, offset);
        }

        // Get the allocation size
        public long FBEAllocationSize(Dictionary<TKey, TValue?> values)
        {
            long size = 4;
            foreach (var value in values)
            {
                size += _modelKey.FBEAllocationSize(value.Key);
                size += _modelValue.FBEAllocationSize(value.Value);
            }
            return size;
        }
        public long FBEAllocationSize(SortedDictionary<TKey, TValue?> values)
        {
            long size = 4;
            foreach (var value in values)
            {
                size += _modelKey.FBEAllocationSize(value.Key);
                size += _modelValue.FBEAllocationSize(value.Value);
            }
            return size;
        }

        // Clone the final model
        public FinalModelMapReferenceTypeKeyOptionalValueTypeValue<TKey, TKeyModel, TValue, TValueModel> Clone() { return new FinalModelMapReferenceTypeKeyOptionalValueTypeValue<TKey, TKeyModel, TValue, TValueModel>(_modelKey, _modelValue.Value, _buffer, _offset); }

        // Check if the map is valid
        public virtual long Verify()
        {
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return long.MaxValue;

            uint fbeMapSize = ReadUInt32(FBEOffset);

            long size = 4;
            _modelKey.FBEOffset = FBEOffset + 4;
            _modelValue.FBEOffset = FBEOffset + 4;
            for (uint i = fbeMapSize; i-- > 0;)
            {
                long offsetKey = _modelKey.Verify();
                if (offsetKey == long.MaxValue)
                    return long.MaxValue;
                _modelKey.FBEShift(offsetKey);
                _modelValue.FBEShift(offsetKey);
                size += offsetKey;
                long offsetValue = _modelValue.Verify();
                if (offsetValue == long.MaxValue)
                    return long.MaxValue;
                _modelKey.FBEShift(offsetValue);
                _modelValue.FBEShift(offsetValue);
                size += offsetValue;
            }
            return size;
        }

        // Get the map as Dictionary
        public long Get(out Dictionary<TKey, TValue?> values)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
            {
                values = new Dictionary<TKey, TValue?>();
                return 0;
            }

            long fbeMapSize = ReadUInt32(FBEOffset);
            if (fbeMapSize == 0)
            {
                values = new Dictionary<TKey, TValue?>();
                return 4;
            }

            values = new Dictionary<TKey, TValue?>((int)fbeMapSize);

            long size = 4;
            _modelKey.FBEOffset = FBEOffset + 4;
            _modelValue.FBEOffset = FBEOffset + 4;
            for (long i = fbeMapSize; i-- > 0;)
            {
                long offsetKey = _modelKey.Get(out var key);
                _modelKey.FBEShift(offsetKey);
                _modelValue.FBEShift(offsetKey);
                long offsetValue = _modelValue.Get(out var value);
                _modelKey.FBEShift(offsetValue);
                _modelValue.FBEShift(offsetValue);
                values.Add(key, value);
                size += offsetKey + offsetValue;
            }
            return size;
        }

        // Get the map as SortedDictionary
        public long Get(out SortedDictionary<TKey, TValue?> values)
        {
            values = new SortedDictionary<TKey, TValue?>();

            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return 0;

            long fbeMapSize = ReadUInt32(FBEOffset);
            if (fbeMapSize == 0)
                return 4;

            long size = 4;
            _modelKey.FBEOffset = FBEOffset + 4;
            _modelValue.FBEOffset = FBEOffset + 4;
            for (long i = fbeMapSize; i-- > 0;)
            {
                long offsetKey = _modelKey.Get(out var key);
                _modelKey.FBEShift(offsetKey);
                _modelValue.FBEShift(offsetKey);
                long offsetValue = _modelValue.Get(out var value);
                _modelKey.FBEShift(offsetValue);
                _modelValue.FBEShift(offsetValue);
                values.Add(key, value);
                size += offsetKey + offsetValue;
            }
            return size;
        }

        // Set the map as Dictionary
        public long Set(Dictionary<TKey, TValue?> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return 0;

            Write(FBEOffset, (uint)values.Count);

            long size = 4;
            _modelKey.FBEOffset = FBEOffset + 4;
            _modelValue.FBEOffset = FBEOffset + 4;
            foreach (var value in values)
            {
                long offsetKey = _modelKey.Set(value.Key);
                _modelKey.FBEShift(offsetKey);
                _modelValue.FBEShift(offsetKey);
                long offsetValue = _modelValue.Set(value.Value);
                _modelKey.FBEShift(offsetValue);
                _modelValue.FBEShift(offsetValue);
                size += offsetKey + offsetValue;
            }
            return size;
        }

        // Set the map as SortedDictionary
        public long Set(SortedDictionary<TKey, TValue?> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return 0;

            Write(FBEOffset, (uint)values.Count);

            long size = 4;
            _modelKey.FBEOffset = FBEOffset + 4;
            _modelValue.FBEOffset = FBEOffset + 4;
            foreach (var value in values)
            {
                long offsetKey = _modelKey.Set(value.Key);
                _modelKey.FBEShift(offsetKey);
                _modelValue.FBEShift(offsetKey);
                long offsetValue = _modelValue.Set(value.Value);
                _modelKey.FBEShift(offsetValue);
                _modelValue.FBEShift(offsetValue);
                size += offsetKey + offsetValue;
            }
            return size;
        }
    }

    // Fast Binary Encoding final model map (reference type key, optional reference type value)
    public class FinalModelMapReferenceTypeKeyOptionalReferenceTypeValue<TKey, TKeyModel, TValue, TValueModel> : FieldModelBase
        where TKey : class
        where TKeyModel : FinalModelReferenceType<TKey>
        where TValue : class
        where TValueModel : FinalModelReferenceType<TValue>
    {
        private readonly TKeyModel _modelKey;
        private readonly FinalModelOptionalReferenceType<TValue, TValueModel> _modelValue;

        public FinalModelMapReferenceTypeKeyOptionalReferenceTypeValue(TKeyModel modelKey, TValueModel modelValue, Buffer buffer, long offset) : base(buffer, offset)
        {
            _modelKey = modelKey.Clone() as TKeyModel;
            _modelValue = new FinalModelOptionalReferenceType<TValue, TValueModel>(modelValue, buffer, offset);
        }

        // Get the allocation size
        public long FBEAllocationSize(Dictionary<TKey, TValue> values)
        {
            long size = 4;
            foreach (var value in values)
            {
                size += _modelKey.FBEAllocationSize(value.Key);
                size += _modelValue.FBEAllocationSize(value.Value);
            }
            return size;
        }
        public long FBEAllocationSize(SortedDictionary<TKey, TValue> values)
        {
            long size = 4;
            foreach (var value in values)
            {
                size += _modelKey.FBEAllocationSize(value.Key);
                size += _modelValue.FBEAllocationSize(value.Value);
            }
            return size;
        }

        // Clone the final model
        public FinalModelMapReferenceTypeKeyOptionalReferenceTypeValue<TKey, TKeyModel, TValue, TValueModel> Clone() { return new FinalModelMapReferenceTypeKeyOptionalReferenceTypeValue<TKey, TKeyModel, TValue, TValueModel>(_modelKey, _modelValue.Value, _buffer, _offset); }

        // Check if the map is valid
        public virtual long Verify()
        {
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return long.MaxValue;

            uint fbeMapSize = ReadUInt32(FBEOffset);

            long size = 4;
            _modelKey.FBEOffset = FBEOffset + 4;
            _modelValue.FBEOffset = FBEOffset + 4;
            for (uint i = fbeMapSize; i-- > 0;)
            {
                long offsetKey = _modelKey.Verify();
                if (offsetKey == long.MaxValue)
                    return long.MaxValue;
                _modelKey.FBEShift(offsetKey);
                _modelValue.FBEShift(offsetKey);
                size += offsetKey;
                long offsetValue = _modelValue.Verify();
                if (offsetValue == long.MaxValue)
                    return long.MaxValue;
                _modelKey.FBEShift(offsetValue);
                _modelValue.FBEShift(offsetValue);
                size += offsetValue;
            }
            return size;
        }

        // Get the map as Dictionary
        public long Get(out Dictionary<TKey, TValue> values)
        {
            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
            {
                values = new Dictionary<TKey, TValue>();
                return 0;
            }

            long fbeMapSize = ReadUInt32(FBEOffset);
            if (fbeMapSize == 0)
            {
                values = new Dictionary<TKey, TValue>();
                return 4;
            }

            values = new Dictionary<TKey, TValue>((int)fbeMapSize);

            long size = 4;
            _modelKey.FBEOffset = FBEOffset + 4;
            _modelValue.FBEOffset = FBEOffset + 4;
            for (long i = fbeMapSize; i-- > 0;)
            {
                long offsetKey = _modelKey.Get(out var key);
                _modelKey.FBEShift(offsetKey);
                _modelValue.FBEShift(offsetKey);
                long offsetValue = _modelValue.Get(out var value);
                _modelKey.FBEShift(offsetValue);
                _modelValue.FBEShift(offsetValue);
                values.Add(key, value);
                size += offsetKey + offsetValue;
            }
            return size;
        }

        // Get the map as SortedDictionary
        public long Get(out SortedDictionary<TKey, TValue> values)
        {
            values = new SortedDictionary<TKey, TValue>();

            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return 0;

            long fbeMapSize = ReadUInt32(FBEOffset);
            if (fbeMapSize == 0)
                return 4;

            long size = 4;
            _modelKey.FBEOffset = FBEOffset + 4;
            _modelValue.FBEOffset = FBEOffset + 4;
            for (long i = fbeMapSize; i-- > 0;)
            {
                long offsetKey = _modelKey.Get(out var key);
                _modelKey.FBEShift(offsetKey);
                _modelValue.FBEShift(offsetKey);
                long offsetValue = _modelValue.Get(out var value);
                _modelKey.FBEShift(offsetValue);
                _modelValue.FBEShift(offsetValue);
                values.Add(key, value);
                size += offsetKey + offsetValue;
            }
            return size;
        }

        // Set the map as Dictionary
        public long Set(Dictionary<TKey, TValue> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return 0;

            Write(FBEOffset, (uint)values.Count);

            long size = 4;
            _modelKey.FBEOffset = FBEOffset + 4;
            _modelValue.FBEOffset = FBEOffset + 4;
            foreach (var value in values)
            {
                long offsetKey = _modelKey.Set(value.Key);
                _modelKey.FBEShift(offsetKey);
                _modelValue.FBEShift(offsetKey);
                long offsetValue = _modelValue.Set(value.Value);
                _modelKey.FBEShift(offsetValue);
                _modelValue.FBEShift(offsetValue);
                size += offsetKey + offsetValue;
            }
            return size;
        }

        // Set the map as SortedDictionary
        public long Set(SortedDictionary<TKey, TValue> values)
        {
            Debug.Assert((values != null), "Invalid values parameter!");
            if (values == null)
                throw new ArgumentNullException(nameof(values), "Invalid values parameter!");

            Debug.Assert(((_buffer.Offset + FBEOffset + 4) <= _buffer.Size), "Model is broken!");
            if ((_buffer.Offset + FBEOffset + 4) > _buffer.Size)
                return 0;

            Write(FBEOffset, (uint)values.Count);

            long size = 4;
            _modelKey.FBEOffset = FBEOffset + 4;
            _modelValue.FBEOffset = FBEOffset + 4;
            foreach (var value in values)
            {
                long offsetKey = _modelKey.Set(value.Key);
                _modelKey.FBEShift(offsetKey);
                _modelValue.FBEShift(offsetKey);
                long offsetValue = _modelValue.Set(value.Value);
                _modelKey.FBEShift(offsetValue);
                _modelValue.FBEShift(offsetValue);
                size += offsetKey + offsetValue;
            }
            return size;
        }
    }

    // Fast Binary Encoding base sender listener interface
    public interface ISenderListener
    {
        // Send message handler
        long OnSend(byte[] buffer, long offset, long size) { return size; }
        // Send log message handler
        void OnSendLog(string message) {}
    }

    // Fast Binary Encoding base sender
    public abstract class Sender : ISenderListener
    {
        // Bytes buffer
        public Buffer Buffer { get; }
        // Logging flag
        public bool Logging { get; set; }
        // Final protocol flag
        public bool Final { get; }

        protected Sender(bool final) { Buffer = new Buffer(); Final = final; }
        protected Sender(Buffer buffer, bool final) { Buffer = buffer; Final = final; }

        // Reset the sender buffer
        public void Reset() { Buffer.Reset(); }

        // Send serialized buffer.
        // Direct call of the method requires knowledge about internals of FBE models serialization.
        // Use it with care!
        public long SendSerialized(ISenderListener listener, long serialized)
        {
            Debug.Assert((serialized > 0), "Invalid size of the serialized buffer!");
            if (serialized == 0)
                return 0;

            // Shift the send buffer
            Buffer.Shift(serialized);

            // Send the value
            long sent = listener.OnSend(Buffer.Data, 0, Buffer.Size);
            Buffer.Remove(0, sent);
            return sent;
        }
    }

    // Fast Binary Encoding base receiver listener interface
    public interface IReceiverListener
    {
        // Receive log message handler
        void OnReceiveLog(string message) {}
    }

    // Fast Binary Encoding base receiver
    public abstract class Receiver : IReceiverListener
    {
        // Bytes buffer
        public Buffer Buffer { get; private set; }
        // Logging flag
        public bool Logging { get; set; }
        // Final protocol flag
        public bool Final { get; }

        protected Receiver(bool final) { Buffer = new Buffer(); Final = final; }
        protected Receiver(Buffer buffer, bool final) { Buffer = buffer; Final = final; }

        // Reset the receiver buffer
        public void Reset() { Buffer.Reset(); }

        // Receive data
        public void Receive(Buffer buffer) { Receive(buffer.Data, 0, buffer.Size); }
        public void Receive(byte[] buffer) { Receive(buffer, 0, buffer.Length); }
        public void Receive(byte[] buffer, long offset, long size)
        {
            Debug.Assert((buffer != null), "Invalid buffer!");
            if (buffer == null)
                throw new ArgumentException("Invalid buffer!", nameof(buffer));
            Debug.Assert(((offset + size) <= buffer.Length), "Invalid offset & size!");
            if ((offset + size) > buffer.Length)
                throw new ArgumentException("Invalid offset & size!", nameof(offset));

            if (size == 0)
                return;

            // Storage buffer
            long offset0 = Buffer.Offset;
            long offset1 = Buffer.Size;
            long size1 = Buffer.Size;

            // Receive buffer
            long offset2 = 0;
            long size2 = size;

            // While receive buffer is available to handle...
            while (offset2 < size2)
            {
                byte[] messageBuffer = null;
                long messageOffset = 0;
                long messageSize = 0;

                // Try to receive message size
                bool messageSizeCopied = false;
                bool messageSizeFound = false;
                while (!messageSizeFound)
                {
                    // Look into the storage buffer
                    if (offset0 < size1)
                    {
                        long count = Math.Min(size1 - offset0, 4);
                        if (count == 4)
                        {
                            messageSizeCopied = true;
                            messageSizeFound = true;
                            messageSize = Buffer.ReadUInt32(Buffer.Data, offset0);
                            offset0 += 4;
                            break;
                        }
                        else
                        {
                            // Fill remaining data from the receive buffer
                            if (offset2 < size2)
                            {
                                count = Math.Min(size2 - offset2, 4 - count);

                                // Allocate and refresh the storage buffer
                                Buffer.Allocate(count);
                                size1 += count;

                                Array.Copy(buffer, offset + offset2, Buffer.Data, offset1, count);
                                offset1 += count;
                                offset2 += count;
                                continue;
                            }
                            else
                                break;
                        }
                    }

                    // Look into the receive buffer
                    if (offset2 < size2)
                    {
                        long count = Math.Min(size2 - offset2, 4);
                        if (count == 4)
                        {
                            messageSizeFound = true;
                            messageSize = Buffer.ReadUInt32(buffer, offset + offset2);
                            offset2 += 4;
                            break;
                        }
                        else
                        {
                            // Allocate and refresh the storage buffer
                            Buffer.Allocate(count);
                            size1 += count;

                            Array.Copy(buffer, offset + offset2, Buffer.Data, offset1, count);
                            offset1 += count;
                            offset2 += count;
                            continue;
                        }
                    }
                    else
                        break;
                }

                if (!messageSizeFound)
                    return;

                // Check the message full size
                long minSize = Final ? (4 + 4) : (4 + 4 + 4 + 4);
                Debug.Assert((messageSize >= minSize), "Invalid receive data!");
                if (messageSize < minSize)
                    return;

                // Try to receive message body
                bool messageFound = false;
                while (!messageFound)
                {
                    // Look into the storage buffer
                    if (offset0 < size1)
                    {
                        long count = Math.Min(size1 - offset0, messageSize - 4);
                        if (count == (messageSize - 4))
                        {
                            messageFound = true;
                            messageBuffer = Buffer.Data;
                            messageOffset = offset0 - 4;
                            offset0 += messageSize - 4;
                            break;
                        }
                        else
                        {
                            // Fill remaining data from the receive buffer
                            if (offset2 < size2)
                            {
                                // Copy message size into the storage buffer
                                if (!messageSizeCopied)
                                {
                                    // Allocate and refresh the storage buffer
                                    Buffer.Allocate(4);
                                    size1 += 4;

                                    Buffer.Write(Buffer.Data, offset0, (uint)messageSize);
                                    offset0 += 4;
                                    offset1 += 4;

                                    messageSizeCopied = true;
                                }

                                count = Math.Min(size2 - offset2, messageSize - 4 - count);

                                // Allocate and refresh the storage buffer
                                Buffer.Allocate(count);
                                size1 += count;

                                Array.Copy(buffer, offset + offset2, Buffer.Data, offset1, count);
                                offset1 += count;
                                offset2 += count;
                                continue;
                            }
                            else
                                break;
                        }
                    }

                    // Look into the receive buffer
                    if (offset2 < size2)
                    {
                        long count = Math.Min(size2 - offset2, messageSize - 4);
                        if (!messageSizeCopied && (count == (messageSize - 4)))
                        {
                            messageFound = true;
                            messageBuffer = buffer;
                            messageOffset = offset + offset2 - 4;
                            offset2 += messageSize - 4;
                            break;
                        }
                        else
                        {
                            // Copy message size into the storage buffer
                            if (!messageSizeCopied)
                            {
                                // Allocate and refresh the storage buffer
                                Buffer.Allocate(4);
                                size1 += 4;

                                Buffer.Write(Buffer.Data, offset0, (uint)messageSize);
                                offset0 += 4;
                                offset1 += 4;

                                messageSizeCopied = true;
                            }

                            // Allocate and refresh the storage buffer
                            Buffer.Allocate(count);
                            size1 += count;

                            Array.Copy(buffer, offset + offset2, Buffer.Data, offset1, count);
                            offset1 += count;
                            offset2 += count;
                            continue;
                        }
                    }
                    else
                        break;
                }

                if (!messageFound)
                {
                    // Copy message size into the storage buffer
                    if (!messageSizeCopied)
                    {
                        // Allocate and refresh the storage buffer
                        Buffer.Allocate(4);
                        size1 += 4;

                        Buffer.Write(Buffer.Data, offset0, (uint)messageSize);
                        offset0 += 4;
                        offset1 += 4;

                        messageSizeCopied = true;
                    }
                    return;
                }

                uint fbeStructSize;
                uint fbeStructType;

                // Read the message parameters
                if (Final)
                {
                    fbeStructSize = Buffer.ReadUInt32(messageBuffer, messageOffset);
                    fbeStructType = Buffer.ReadUInt32(messageBuffer, messageOffset + 4);
                }
                else
                {
                    uint fbeStructOffset = Buffer.ReadUInt32(messageBuffer, messageOffset + 4);
                    fbeStructSize = Buffer.ReadUInt32(messageBuffer, messageOffset + fbeStructOffset);
                    fbeStructType = Buffer.ReadUInt32(messageBuffer, messageOffset + fbeStructOffset + 4);
                }

                // Handle the message
                OnReceive(fbeStructType, messageBuffer, messageOffset, messageSize);

                // Reset the storage buffer
                Buffer.Reset();

                // Refresh the storage buffer
                offset0 = Buffer.Offset;
                offset1 = Buffer.Size;
                size1 = Buffer.Size;
            }
        }

        // Receive message handler
        internal abstract bool OnReceive(long type, byte[] buffer, long offset, long size);
    }

    // Fast Binary Encoding base client listener interface
    public interface IClientListener : ISenderListener, IReceiverListener
    {
    }

    // Fast Binary Encoding base client
    public abstract class Client : IClientListener
    {
        // Send bytes buffer
        public Buffer SendBuffer { get; }
        // Receive bytes buffer
        public Buffer ReceiveBuffer { get; }
        // Logging flag
        public bool Logging { get; set; }
        // Final protocol flag
        public bool Final { get; }

        // Client mutex lock
        protected Mutex Lock { get; }
        // Client timestamp
        protected DateTime Timestamp { get; set; }

        protected Client(bool final) : this(new Buffer(), new Buffer(), final) {}
        protected Client(Buffer sendBuffer, Buffer receiveBuffer, bool final) { SendBuffer = sendBuffer; ReceiveBuffer = receiveBuffer; Final = final; Lock = new Mutex(); Timestamp = new DateTime(1970, 1, 1, 0, 0, 0, DateTimeKind.Utc); }

        // Reset the client buffers
        public void Reset()
        {
            lock (Lock)
            {
                ResetRequests();
            }
        }

        // Reset client requests
        internal virtual void ResetRequests()
        {
            SendBuffer.Reset();
            ReceiveBuffer.Reset();
        }

        // Watchdog for timeouts
        public void Watchdog(DateTime utc)
        {
            lock (Lock)
            {
                WatchdogRequests(utc);
            }
        }

        // Watchdog client requests for timeouts
        internal virtual void WatchdogRequests(DateTime utc)
        {
        }

        // Send serialized buffer.
        // Direct call of the method requires knowledge about internals of FBE models serialization.
        // Use it with care!
        public long SendSerialized(ISenderListener listener, long serialized)
        {
            Debug.Assert((serialized > 0), "Invalid size of the serialized buffer!");
            if (serialized == 0)
                return 0;

            // Shift the send buffer
            SendBuffer.Shift(serialized);

            // Send the value
            long sent = listener.OnSend(SendBuffer.Data, 0, SendBuffer.Size);
            SendBuffer.Remove(0, sent);
            return sent;
        }

        // Receive data
        public void Receive(Buffer buffer) { Receive(buffer.Data, 0, buffer.Size); }
        public void Receive(byte[] buffer) { Receive(buffer, 0, buffer.Length); }
        public void Receive(byte[] buffer, long offset, long size)
        {
            Debug.Assert((buffer != null), "Invalid buffer!");
            if (buffer == null)
                throw new ArgumentException("Invalid buffer!", nameof(buffer));
            Debug.Assert(((offset + size) <= buffer.Length), "Invalid offset & size!");
            if ((offset + size) > buffer.Length)
                throw new ArgumentException("Invalid offset & size!", nameof(offset));

            if (size == 0)
                return;

            // Storage buffer
            long offset0 = ReceiveBuffer.Offset;
            long offset1 = ReceiveBuffer.Size;
            long size1 = ReceiveBuffer.Size;

            // Receive buffer
            long offset2 = 0;
            long size2 = size;

            // While receive buffer is available to handle...
            while (offset2 < size2)
            {
                byte[] messageBuffer = null;
                long messageOffset = 0;
                long messageSize = 0;

                // Try to receive message size
                bool messageSizeCopied = false;
                bool messageSizeFound = false;
                while (!messageSizeFound)
                {
                    // Look into the storage buffer
                    if (offset0 < size1)
                    {
                        long count = Math.Min(size1 - offset0, 4);
                        if (count == 4)
                        {
                            messageSizeCopied = true;
                            messageSizeFound = true;
                            messageSize = Buffer.ReadUInt32(ReceiveBuffer.Data, offset0);
                            offset0 += 4;
                            break;
                        }
                        else
                        {
                            // Fill remaining data from the receive buffer
                            if (offset2 < size2)
                            {
                                count = Math.Min(size2 - offset2, 4 - count);

                                // Allocate and refresh the storage buffer
                                ReceiveBuffer.Allocate(count);
                                size1 += count;

                                Array.Copy(buffer, offset + offset2, ReceiveBuffer.Data, offset1, count);
                                offset1 += count;
                                offset2 += count;
                                continue;
                            }
                            else
                                break;
                        }
                    }

                    // Look into the receive buffer
                    if (offset2 < size2)
                    {
                        long count = Math.Min(size2 - offset2, 4);
                        if (count == 4)
                        {
                            messageSizeFound = true;
                            messageSize = Buffer.ReadUInt32(buffer, offset + offset2);
                            offset2 += 4;
                            break;
                        }
                        else
                        {
                            // Allocate and refresh the storage buffer
                            ReceiveBuffer.Allocate(count);
                            size1 += count;

                            Array.Copy(buffer, offset + offset2, ReceiveBuffer.Data, offset1, count);
                            offset1 += count;
                            offset2 += count;
                            continue;
                        }
                    }
                    else
                        break;
                }

                if (!messageSizeFound)
                    return;

                // Check the message full size
                long minSize = Final ? (4 + 4) : (4 + 4 + 4 + 4);
                Debug.Assert((messageSize >= minSize), "Invalid receive data!");
                if (messageSize < minSize)
                    return;

                // Try to receive message body
                bool messageFound = false;
                while (!messageFound)
                {
                    // Look into the storage buffer
                    if (offset0 < size1)
                    {
                        long count = Math.Min(size1 - offset0, messageSize - 4);
                        if (count == (messageSize - 4))
                        {
                            messageFound = true;
                            messageBuffer = ReceiveBuffer.Data;
                            messageOffset = offset0 - 4;
                            offset0 += messageSize - 4;
                            break;
                        }
                        else
                        {
                            // Fill remaining data from the receive buffer
                            if (offset2 < size2)
                            {
                                // Copy message size into the storage buffer
                                if (!messageSizeCopied)
                                {
                                    // Allocate and refresh the storage buffer
                                    ReceiveBuffer.Allocate(4);
                                    size1 += 4;

                                    Buffer.Write(ReceiveBuffer.Data, offset0, (uint)messageSize);
                                    offset0 += 4;
                                    offset1 += 4;

                                    messageSizeCopied = true;
                                }

                                count = Math.Min(size2 - offset2, messageSize - 4 - count);

                                // Allocate and refresh the storage buffer
                                ReceiveBuffer.Allocate(count);
                                size1 += count;

                                Array.Copy(buffer, offset + offset2, ReceiveBuffer.Data, offset1, count);
                                offset1 += count;
                                offset2 += count;
                                continue;
                            }
                            else
                                break;
                        }
                    }

                    // Look into the receive buffer
                    if (offset2 < size2)
                    {
                        long count = Math.Min(size2 - offset2, messageSize - 4);
                        if (!messageSizeCopied && (count == (messageSize - 4)))
                        {
                            messageFound = true;
                            messageBuffer = buffer;
                            messageOffset = offset + offset2 - 4;
                            offset2 += messageSize - 4;
                            break;
                        }
                        else
                        {
                            // Copy message size into the storage buffer
                            if (!messageSizeCopied)
                            {
                                // Allocate and refresh the storage buffer
                                ReceiveBuffer.Allocate(4);
                                size1 += 4;

                                Buffer.Write(ReceiveBuffer.Data, offset0, (uint)messageSize);
                                offset0 += 4;
                                offset1 += 4;

                                messageSizeCopied = true;
                            }

                            // Allocate and refresh the storage buffer
                            ReceiveBuffer.Allocate(count);
                            size1 += count;

                            Array.Copy(buffer, offset + offset2, ReceiveBuffer.Data, offset1, count);
                            offset1 += count;
                            offset2 += count;
                            continue;
                        }
                    }
                    else
                        break;
                }

                if (!messageFound)
                {
                    // Copy message size into the storage buffer
                    if (!messageSizeCopied)
                    {
                        // Allocate and refresh the storage buffer
                        ReceiveBuffer.Allocate(4);
                        size1 += 4;

                        Buffer.Write(ReceiveBuffer.Data, offset0, (uint)messageSize);
                        offset0 += 4;
                        offset1 += 4;

                        messageSizeCopied = true;
                    }
                    return;
                }

                uint fbeStructSize;
                uint fbeStructType;

                // Read the message parameters
                if (Final)
                {
                    fbeStructSize = Buffer.ReadUInt32(messageBuffer, messageOffset);
                    fbeStructType = Buffer.ReadUInt32(messageBuffer, messageOffset + 4);
                }
                else
                {
                    uint fbeStructOffset = Buffer.ReadUInt32(messageBuffer, messageOffset + 4);
                    fbeStructSize = Buffer.ReadUInt32(messageBuffer, messageOffset + fbeStructOffset);
                    fbeStructType = Buffer.ReadUInt32(messageBuffer, messageOffset + fbeStructOffset + 4);
                }

                // Handle the message
                OnReceive(fbeStructType, messageBuffer, messageOffset, messageSize);

                // Reset the storage buffer
                ReceiveBuffer.Reset();

                // Refresh the storage buffer
                offset0 = ReceiveBuffer.Offset;
                offset1 = ReceiveBuffer.Size;
                size1 = ReceiveBuffer.Size;
            }
        }

        // Receive message handler
        internal abstract bool OnReceive(long type, byte[] buffer, long offset, long size);
    }

#if UTF8JSON
    public sealed class ByteArrayFormatter : IJsonFormatter<byte[]>
    {
        public void Serialize(ref JsonWriter writer, byte[] value, IJsonFormatterResolver formatterResolver)
        {
            if (value == null)
            {
                writer.WriteNull();
                return;
            }

            writer.WriteBeginArray();

            if (value.Length != 0)
                writer.WriteByte(value[0]);
            for (int i = 1; i < value.Length; i++)
            {
                writer.WriteValueSeparator();
                writer.WriteByte(value[i]);
            }

            writer.WriteEndArray();
        }

        public byte[] Deserialize(ref JsonReader reader, IJsonFormatterResolver formatterResolver)
        {
            if (reader.ReadIsNull())
                return null;

            reader.ReadIsBeginArrayWithVerify();
            var array = new byte[4];
            var count = 0;
            while (!reader.ReadIsEndArrayWithSkipValueSeparator(ref count))
            {
                if (array.Length < count)
                    Array.Resize(ref array, count * 2);
                array[count - 1] = reader.ReadByte();
            }

            Array.Resize(ref array, count);
            return array;
        }
    }

    public class BytesFormatter : IJsonFormatter<MemoryStream>
    {
        public void Serialize(ref JsonWriter writer, MemoryStream value, IJsonFormatterResolver jsonFormatterResolver)
        {
            if (value == null)
            {
                writer.WriteNull();
                return;
            }

            writer.WriteString(System.Convert.ToBase64String(value.GetBuffer()));
        }

        public MemoryStream Deserialize(ref JsonReader reader, IJsonFormatterResolver jsonFormatterResolver)
        {
            if (reader.ReadIsNull())
                return null;

            var buffer = System.Convert.FromBase64String(reader.ReadString());
            return new MemoryStream(buffer, 0, buffer.Length, true, true);
        }
    }

    public class CharFormatter : IJsonFormatter<Char>
    {
        public void Serialize(ref JsonWriter writer, Char value, IJsonFormatterResolver jsonFormatterResolver)
        {
            writer.WriteUInt32(value);
        }

        public Char Deserialize(ref JsonReader reader, IJsonFormatterResolver jsonFormatterResolver)
        {
            return (char)reader.ReadUInt32();
        }
    }

    public class CharNullableFormatter : IJsonFormatter<Char?>
    {
        public void Serialize(ref JsonWriter writer, Char? value, IJsonFormatterResolver jsonFormatterResolver)
        {
            if (!value.HasValue)
            {
                writer.WriteNull();
                return;
            }

            writer.WriteUInt32(value.Value);
        }

        public Char? Deserialize(ref JsonReader reader, IJsonFormatterResolver jsonFormatterResolver)
        {
            if (reader.ReadIsNull())
                return null;

            return (char)reader.ReadUInt32();
        }
    }

    public class DateTimeFormatter : IJsonFormatter<DateTime>
    {
        private const long UnixEpoch = 621355968000000000;

        public void Serialize(ref JsonWriter writer, DateTime value, IJsonFormatterResolver jsonFormatterResolver)
        {
            ulong nanoseconds = (ulong)((value.Ticks - UnixEpoch) * 100);
            writer.WriteUInt64(nanoseconds);
        }

        public DateTime Deserialize(ref JsonReader reader, IJsonFormatterResolver jsonFormatterResolver)
        {
            ulong ticks = (ulong)(long)reader.ReadUInt64() / 100;
            return new DateTime((long)(UnixEpoch + ticks), DateTimeKind.Utc);
        }
    }

    public class DateTimeNullableFormatter : IJsonFormatter<DateTime?>
    {
        private const long UnixEpoch = 621355968000000000;

        public void Serialize(ref JsonWriter writer, DateTime? value, IJsonFormatterResolver jsonFormatterResolver)
        {
            if (!value.HasValue)
            {
                writer.WriteNull();
                return;
            }

            ulong nanoseconds = (ulong)((value.Value.Ticks - UnixEpoch) * 100);
            writer.WriteUInt64(nanoseconds);
        }

        public DateTime? Deserialize(ref JsonReader reader, IJsonFormatterResolver jsonFormatterResolver)
        {
            if (reader.ReadIsNull())
                return null;

            ulong ticks = (ulong)(long)reader.ReadUInt64() / 100;
            return new DateTime((long)(UnixEpoch + ticks), DateTimeKind.Utc);
        }
    }

    public class DecimalFormatter : IJsonFormatter<Decimal>
    {
        public void Serialize(ref JsonWriter writer, Decimal value, IJsonFormatterResolver jsonFormatterResolver)
        {
            writer.WriteString(value.ToString(CultureInfo.InvariantCulture));
        }

        public Decimal Deserialize(ref JsonReader reader, IJsonFormatterResolver jsonFormatterResolver)
        {
            return Decimal.Parse(reader.ReadString(), CultureInfo.InvariantCulture);
        }
    }

    public class GuidFormatter : IJsonFormatter<Guid>
    {
        public void Serialize(ref JsonWriter writer, Guid value, IJsonFormatterResolver jsonFormatterResolver)
        {
            writer.WriteString(value.ToString());
        }

        public Guid Deserialize(ref JsonReader reader, IJsonFormatterResolver jsonFormatterResolver)
        {
            return Guid.Parse(reader.ReadString());
        }
    }

    // Fast Binary Encoding base JSON converter
    public static class Json
    {
        static Json()
        {
            CompositeResolver.RegisterAndSetAsDefault(new IJsonFormatter[]
            {
                new ByteArrayFormatter(),
                new BytesFormatter(),
                new CharFormatter(),
                new CharNullableFormatter(),
                new DateTimeFormatter(),
                new DateTimeNullableFormatter(),
                new DecimalFormatter(),
                new GuidFormatter()
            }, new[] { StandardResolver.Default });
        }

        public static string ToJson<T>(T value) { return Encoding.UTF8.GetString(JsonSerializer.Serialize(value)); }
        public static T FromJson<T>(string json) { return JsonSerializer.Deserialize<T>(json); }
    }
#elif NEWTONSOFTJSON
    public class BytesConverter : JsonConverter
    {
        public override bool CanConvert(Type objectType)
        {
            return (objectType == typeof(MemoryStream));
        }

        public override void WriteJson(JsonWriter writer, object value, JsonSerializer serializer)
        {
            writer.WriteValue(System.Convert.ToBase64String(((MemoryStream)value).GetBuffer()));
        }

        public override object ReadJson(JsonReader reader, Type objectType, object existingValue, JsonSerializer serializer)
        {
            if (reader.Value == null)
                return null;

            var buffer = System.Convert.FromBase64String((string)reader.Value);
            return new MemoryStream(buffer, 0, buffer.Length, true, true);
        }
    }

    public class CharConverter : JsonConverter
    {
        public override bool CanConvert(Type objectType)
        {
            return (objectType == typeof(Char)) || (objectType == typeof(Char?));
        }

        public override void WriteJson(JsonWriter writer, object value, JsonSerializer serializer)
        {
            writer.WriteValue((long)(char)value);
        }

        public override object ReadJson(JsonReader reader, Type objectType, object existingValue, JsonSerializer serializer)
        {
            if (reader.Value == null)
                return null;

            return (char)(long)reader.Value;
        }
    }

    public class DateTimeConverter : JsonConverter
    {
        private const long UnixEpoch = 621355968000000000;

        public override bool CanConvert(Type objectType)
        {
            return (objectType == typeof(DateTime)) || (objectType == typeof(DateTime?));
        }

        public override void WriteJson(JsonWriter writer, object value, JsonSerializer serializer)
        {
            ulong nanoseconds = (ulong)((((DateTime)value).Ticks - UnixEpoch) * 100);
            writer.WriteValue(nanoseconds);
        }

        public override object ReadJson(JsonReader reader, Type objectType, object existingValue, JsonSerializer serializer)
        {
            if (reader.Value == null)
                return null;

            ulong ticks = (ulong)(long)reader.Value / 100;
            return new DateTime((long)(UnixEpoch + ticks), DateTimeKind.Utc);
        }
    }

    public class DecimalConverter : JsonConverter
    {
        public override bool CanConvert(Type objectType)
        {
            return (objectType == typeof(Decimal)) || (objectType == typeof(Decimal?));
        }

        public override void WriteJson(JsonWriter writer, object value, JsonSerializer serializer)
        {
            writer.WriteValue(((Decimal)value).ToString(CultureInfo.InvariantCulture));
        }

        public override object ReadJson(JsonReader reader, Type objectType, object existingValue, JsonSerializer serializer)
        {
            if (reader.Value == null)
                return null;

            return Decimal.Parse((string)reader.Value, CultureInfo.InvariantCulture);
        }
    }

    public class GuidConverter : JsonConverter
    {
        public override bool CanConvert(Type objectType)
        {
            return (objectType == typeof(Guid)) || (objectType == typeof(Guid?));
        }

        public override void WriteJson(JsonWriter writer, object value, JsonSerializer serializer)
        {
            writer.WriteValue(((Guid)value).ToString());
        }

        public override object ReadJson(JsonReader reader, Type objectType, object existingValue, JsonSerializer serializer)
        {
            if (reader.Value == null)
                return null;

            return Guid.Parse((string)reader.Value);
        }
    }

    // Fast Binary Encoding base JSON converter
    public static class Json
    {
        static Json()
        {
            JsonConvert.DefaultSettings = () => new JsonSerializerSettings
            {
                Converters = new List<JsonConverter>
                {
                    new BytesConverter(),
                    new CharConverter(),
                    new DateTimeConverter(),
                    new DecimalConverter(),
                    new GuidConverter()
                }
            };
        }

        public static string ToJson<T>(T value) { return JsonConvert.SerializeObject(value); }
        public static T FromJson<T>(string json) { return JsonConvert.DeserializeObject<T>(json); }
    }
#else
    public class ByteArrayConverter : JsonConverter<byte[]>
    {
        public override void Write(Utf8JsonWriter writer, byte[] value, JsonSerializerOptions options)
        {
            writer.WriteStartArray();

            if (value.Length != 0)
                writer.WriteNumberValue(value[0]);
            for (int i = 1; i < value.Length; i++)
                writer.WriteNumberValue(value[i]);

            writer.WriteEndArray();
        }

        public override byte[] Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
        {
            if (reader.TokenType != JsonTokenType.StartArray)
                throw new JsonException("Expected start array token!");

            var array = new byte[4];
            var count = 0;
            while (reader.Read())
            {
                if (reader.TokenType == JsonTokenType.EndArray)
                    break;
                count++;
                if (array.Length < count)
                    Array.Resize(ref array, count * 2);
                array[count - 1] = reader.GetByte();
            }

            Array.Resize(ref array, count);
            return array;
        }
    }

    public class BytesConverter : JsonConverter<MemoryStream>
    {
        public override void Write(Utf8JsonWriter writer, MemoryStream value, JsonSerializerOptions options) => writer.WriteStringValue(System.Convert.ToBase64String(value.GetBuffer()));

        public override MemoryStream Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
        {
            var buffer = System.Convert.FromBase64String(reader.GetString());
            return new MemoryStream(buffer, 0, buffer.Length, true, true);
        }
    }

    public class CharConverter : JsonConverter<Char>
    {
        public override void Write(Utf8JsonWriter writer, Char value, JsonSerializerOptions options) => writer.WriteNumberValue(value);
        public override Char Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options) => (Char)reader.GetInt64();
    }

    public class DateTimeConverter : JsonConverter<DateTime>
    {
        private const long UnixEpoch = 621355968000000000;

        public override void Write(Utf8JsonWriter writer, DateTime value, JsonSerializerOptions options)
        {
            ulong nanoseconds = (ulong)((value.Ticks - UnixEpoch) * 100);
            writer.WriteNumberValue(nanoseconds);
        }

        public override DateTime Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
        {
            ulong ticks = reader.GetUInt64() / 100;
            return new DateTime((long)(UnixEpoch + ticks), DateTimeKind.Utc);
        }
    }

    public class DecimalConverter : JsonConverter<Decimal>
    {
        public override void Write(Utf8JsonWriter writer, Decimal value, JsonSerializerOptions options) => writer.WriteStringValue(value.ToString(CultureInfo.InvariantCulture));
        public override Decimal Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options) => Decimal.Parse(reader.GetString(), CultureInfo.InvariantCulture);
    }

    // Fast Binary Encoding base JSON converter
    public static class Json
    {
        private static readonly JsonSerializerOptions DefaultOptions;

        static Json()
        {
            DefaultOptions = new JsonSerializerOptions(JsonSerializerDefaults.General)
            {
                IncludeFields = true
            };
            DefaultOptions.Converters.Add(new ByteArrayConverter());
            DefaultOptions.Converters.Add(new BytesConverter());
            DefaultOptions.Converters.Add(new CharConverter());
            DefaultOptions.Converters.Add(new DateTimeConverter());
            DefaultOptions.Converters.Add(new DecimalConverter());
        }

        public static string ToJson<T>(T value) { return JsonSerializer.Serialize(value, DefaultOptions); }
        public static T FromJson<T>(string json) { return JsonSerializer.Deserialize<T>(json, DefaultOptions); }
    }
#endif

} // namespace com.chronoxor.FBE
