<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

### Table of Contents

-   [Convert](#convert)
    -   [exports](#exports)
-   [Drop](#drop)
    -   [exports](#exports-1)
-   [Values](#values)
    -   [exports](#exports-2)
-   [Update](#update)
    -   [exports](#exports-3)
    -   [replacementCallback - Function to run to rename the field](#replacementcallback---function-to-run-to-rename-the-field)
-   [Fields](#fields)
    -   [exports](#exports-4)
-   [Rename](#rename)
    -   [exports](#exports-5)
    -   [replacementCallback - Function to run to rename the field](#replacementcallback---function-to-run-to-rename-the-field-1)

## Convert

### exports

Converts the given field to an array, unless it is already an array

**Parameters**

-   `patterns` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** A file path or glob pattern to search for files to modify
-   `field` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** The field you want to convert
-   `options` **[Object](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object)** Configuration options
    -   `options.ignore` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** A file path or glob pattern to search for files not to modify. Defaults to "node_modules".

**Examples**

```javascript
var fmp = require("front-matter-manipulator")
 
fmp.convert("_posts/example-post.md", "categories")
```

```javascript
var fmp = require("front-matter-manipulator")
var options = {
    ignore: "_posts/subdirectory/*.md"
}
 
fmp.convert("_posts/**‏/*.md", "categories", options)
```

## Drop

### exports

Deletes the given fields from the front matter

**Parameters**

-   `patterns` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** A file path or glob pattern to search for files to modify
-   `fields` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** A space delimited list of fields you wish to drop
-   `options` **[Object](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object)** Configuration options
    -   `options.ignore` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** A file path or glob pattern to search for files not to modify. Defaults to "node_modules".
    -   `options.exclude` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** Exclude files that have a certain values. Formatted as a comma delimited list of key value pairs.
    -   `options.include` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** Only include files that have a certain values. Formatted as a comma delimited list of key value pairs.

**Examples**

```javascript
var fmp = require("front-matter-manipulator")
 
fmp.drop("_posts/example-post.md", "categories tags")
```

```javascript
var fmp = require("front-matter-manipulator")
var options = {
    ignore: "_posts/subdirectory/*.md",
    include: "layout=post",
    exclude: "featured=true"
}
 
fmp.drop("**‏/*.md", "categories tags", options)
```

## Values

### exports

Retrieves all fields for one or more files

**Parameters**

-   `patterns` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** A file path or glob pattern to search for files
-   `fields` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** A space delimited list of fields to get values for
-   `options` **[Object](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object)** Configuration options
    -   `options.ignore` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** A file path or glob pattern to search for files not to modify. Defaults to "node_modules".
    -   `options.outputFile` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** path to a file where output should be saved

**Examples**

```javascript
var fmp = require("front-matter-manipulator")
 
fmp.values("_posts/example-post.md", "categories tags")
```

```javascript
var fmp = require("front-matter-manipulator")
var options = {
    ignore: "_posts/subdirectory/*.md"
}
 
fmp.values("**‏/*.md", "categories tags", options)
```

Returns **[Object](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object)** values

## Update

### exports

Updates the given key value pair's value

**Parameters**

-   `patterns` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** A file path or glob pattern to search for files to modify
-   `field` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** The name of the field you wish to update
-   `replacement` **([string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String) | replacementCallback)** The new value of the field
-   `options` **[Object](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object)** Configuration options
    -   `options.ignore` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** A file path or glob pattern to search for files not to modify. Defaults to "node_modules".
    -   `options.exclude` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** Exclude files that have a certain values. Formatted as a comma delimited list of key value pairs.
    -   `options.include` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** Only include files that have a certain values. Formatted as a comma delimited list of key value pairs.

**Examples**

```javascript
var fmp = require("front-matter-manipulator")
 
fmp.update("_posts/example-post.md", "draft", "true")
```

```javascript
var fmp = require("front-matter-manipulator")
var options = {
    ignore: "_posts/subdirectory/*.md",
    include: "layout=post",
    exclude: "featured=true"
}
 
fmp.rename("**‏/*.md", "draft", "true", options)
```

### replacementCallback - Function to run to rename the field

Optional replacement function to be run for each match

Type: [Function](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Statements/function)

**Parameters**

-   `value` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** The field's current value
-   `field` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** The current field permutation
-   `filePath` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** The current file's path

**Examples**

```javascript
var fmp = require("front-matter-manipulator")
function replacement(field, filePath) {
    if (field.indexOf(0) > -1) { // Update if array index 0
       replacement = "newKey"
    }
}    

fmp.rename("**‏/*.md", "categories", replacement, options)
```

Returns **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** replacement - The replacement value

## Fields

### exports

Retrieves all fields for one or more files

**Parameters**

-   `patterns` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** A file path or glob pattern to search for files
-   `options` **[Object](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object)** Configuration options
    -   `options.ignore` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** A file path or glob pattern to search for files not to modify. Defaults to "node_modules".
    -   `options.exclude` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** Exclude files that have a certain values. Formatted as a comma delimited list of key value pairs.
    -   `options.include` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** Only include files that have a certain values. Formatted as a comma delimited list of key value pairs.
    -   `options.outputFile` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** path to a file where output should be saved
    -   `options.outputstring` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** output values as a space delimited string instead of JSON

**Examples**

```javascript
var fmp = require("front-matter-manipulator")
 
fmp.fields("_posts/example-post.md")
```

```javascript
var fmp = require("front-matter-manipulator")
var options = {
    ignore: "_posts/subdirectory/*.md",
    include: "layout=post",
    exclude: "featured=true"
}
 
fmp.fields("**‏/*.md", options)
```

Returns **[Object](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object)** fields

## Rename

### exports

Renames the given field

**Parameters**

-   `patterns` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** A file path or glob pattern to search for files to modify
-   `key`  
-   `replacement` **([string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String) | replacementCallback)** The replacement name for the field.
-   `options` **[Object](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object)** Configuration options
    -   `options.ignore` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** A file path or glob pattern to search for files not to modify. Defaults to "node_modules".
    -   `options.exclude` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** Exclude files that have a certain values. Formatted as a comma delimited list of key value pairs.
    -   `options.include` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** Only include files that have a certain values. Formatted as a comma delimited list of key value pairs.
-   `field` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** The name of the field you wish to rename

**Examples**

```javascript
var fmp = require("front-matter-manipulator")
 
fmp.rename("_posts/example-post.md", "categories", "tags")
```

```javascript
var fmp = require("front-matter-manipulator")
var options = {
    ignore: "_posts/subdirectory/*.md",
    include: "layout=post",
    exclude: "featured=true"
}
 
fmp.rename("**‏/*.md", "categories", "tags", options)
```

### replacementCallback - Function to run to rename the field

Optional replacement function to be run for each match

Type: [Function](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Statements/function)

**Parameters**

-   `field` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** The current field permutation
-   `filePath` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** The current file's path

**Examples**

```javascript
var fmp = require("front-matter-manipulator")
function replacement(field, filePath) {
    if (field.indexOf(0) > -1) { // Update if array index 0
       replacement = "newKey"
    }
}    

fmp.rename("**‏/*.md", "categories", replacement, options)
```

Returns **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** replacement - The replacement field name
