/*
 * Chomp Food & Recipe Database API Documentation
 *
 * ## Important An **[API key](https://chompthis.com/api/)** is required for access to this API. * Get a **Food Data API** key at **[https://chompthis.com/api](https://chompthis.com/api/)**. * Get a **Recipe Data API** key at **[https://chompthis.com/api/recipes](https://chompthis.com/api/recipes/)**.  ### Getting Started   * Subscribe to the **[Food Data API](https://chompthis.com/api/#pricing)** or the **[Recipe Data API](https://chompthis.com/api/recipes/#pricing)**.   * Scroll down and click the \"**Authorize**\" button.   * Enter your API key into the \"**value**\" input, click the \"**Authorize**\" button, then click the \"**Close**\" button.   * Scroll down to the section titled \"**default**\" and click on the API endpoint you wish to use.   * Click the \"**Try it out**\" button.   * Enter the information the endpoint requires.   * Click the \"**Execute**\" button.  ### Example    * Branded food response object: **[View example &raquo;](https://raw.githubusercontent.com/chompfoods/examples/master/branded-food-response-object.json)**   * Ingredient response object: **[View example &raquo;](https://raw.githubusercontent.com/chompfoods/examples/master/ingredient-response-object.json)**   * Recipe response object: **[View example &raquo;](https://raw.githubusercontent.com/chompfoods/examples/master/example-recipe-response.json)**   * Error response object: **[View example &raquo;](https://raw.githubusercontent.com/chompfoods/examples/master/error-response-object.json)**  ### How Do I Find My API Key?   * Your API key was sent to the email address you used to create your subscription.   * You will also find your API key in the **[Client Center](https://chompthis.com/api/manage.php)**.   * Read **[this article](https://desk.zoho.com/portal/chompthis/kb/articles/how-do-i-find-my-api-key)** for more information.  ### I'm a Premium subscriber. How do I access the API?   * All Premium subscribers must pass in a unique user ID for each user on their platform that is accessing data from the Chomp API. A user ID can be any string of letters and numbers that you assign to your user. Simply add \"user_id\" as a URL parameter when calling the API. *You must add a \"user_id\" URL parameter to every call you make to ANY endpoint.*     * **Example**        > ```ENDPOINT.php?api_key=API_KEY&code=CODE&user_id=USER_ID```  ### Helpful Links   * **Help & Support**     * [Knowledge Base &raquo;](https://desk.zoho.com/portal/chompthis/kb/chomp)     * [Support &raquo;](https://chompthis.com/api/ticket-new.php)     * [Client Center &raquo;](https://chompthis.com/api/manage.php)   * **Pricing**     * [Food Data API Subscription Options &raquo;](https://chompthis.com/api/)     * [Recipe Data API Subscription Options &raquo;](https://chompthis.com/api/recipes/)     * [Food Data API Cost Calculator &raquo;](https://chompthis.com/api/cost-calculator.php)     * [Recipe Data API Cost Calculator &raquo;](https://chompthis.com/api/recipes/cost-calculator.php)   * **Guidelines**     * [Terms & License &raquo;](https://chompthis.com/api/terms.php)     * [Attribution &raquo;](https://chompthis.com/api/docs/attribution.php) 
 *
 * OpenAPI spec version: 1.0.0-oas3
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel.DataAnnotations;
using System.Runtime.Serialization;
using Newtonsoft.Json;

namespace IO.Swagger.Models
{ 
    /// <summary>
    /// An object containing this item&#x27;s compatibility grades for each supported diet
    /// </summary>
    [DataContract]
    public partial class RecipeObjectMeta : IEquatable<RecipeObjectMeta>
    { 
        /// <summary>
        /// URL to the recipe. You must link back to the recipe when displaying it.
        /// </summary>
        /// <value>URL to the recipe. You must link back to the recipe when displaying it.</value>
        [DataMember(Name="url")]
        public string Url { get; set; }

        /// <summary>
        /// Gets or Sets Images
        /// </summary>
        [DataMember(Name="images")]
        public RecipeObjectMetaImages Images { get; set; }

        /// <summary>
        /// The source of the recipe. You must attribute this source when displaying this recipe.
        /// </summary>
        /// <value>The source of the recipe. You must attribute this source when displaying this recipe.</value>
        [DataMember(Name="source")]
        public string Source { get; set; }

        /// <summary>
        /// This recipe&#x27;s cuisine
        /// </summary>
        /// <value>This recipe&#x27;s cuisine</value>
        [DataMember(Name="cuisine")]
        public string Cuisine { get; set; }

        /// <summary>
        /// The date when this recipe was created
        /// </summary>
        /// <value>The date when this recipe was created</value>
        [DataMember(Name="created")]
        public string Created { get; set; }

        /// <summary>
        /// The date when this recipe was most recently modified
        /// </summary>
        /// <value>The date when this recipe was most recently modified</value>
        [DataMember(Name="modified")]
        public string Modified { get; set; }

        /// <summary>
        /// Additional information about this recipe&#x27;s nutrients
        /// </summary>
        /// <value>Additional information about this recipe&#x27;s nutrients</value>
        [DataMember(Name="nutrients_notice")]
        public string NutrientsNotice { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class RecipeObjectMeta {\n");
            sb.Append("  Url: ").Append(Url).Append("\n");
            sb.Append("  Images: ").Append(Images).Append("\n");
            sb.Append("  Source: ").Append(Source).Append("\n");
            sb.Append("  Cuisine: ").Append(Cuisine).Append("\n");
            sb.Append("  Created: ").Append(Created).Append("\n");
            sb.Append("  Modified: ").Append(Modified).Append("\n");
            sb.Append("  NutrientsNotice: ").Append(NutrientsNotice).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="obj">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object obj)
        {
            if (ReferenceEquals(null, obj)) return false;
            if (ReferenceEquals(this, obj)) return true;
            return obj.GetType() == GetType() && Equals((RecipeObjectMeta)obj);
        }

        /// <summary>
        /// Returns true if RecipeObjectMeta instances are equal
        /// </summary>
        /// <param name="other">Instance of RecipeObjectMeta to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(RecipeObjectMeta other)
        {
            if (ReferenceEquals(null, other)) return false;
            if (ReferenceEquals(this, other)) return true;

            return 
                (
                    Url == other.Url ||
                    Url != null &&
                    Url.Equals(other.Url)
                ) && 
                (
                    Images == other.Images ||
                    Images != null &&
                    Images.Equals(other.Images)
                ) && 
                (
                    Source == other.Source ||
                    Source != null &&
                    Source.Equals(other.Source)
                ) && 
                (
                    Cuisine == other.Cuisine ||
                    Cuisine != null &&
                    Cuisine.Equals(other.Cuisine)
                ) && 
                (
                    Created == other.Created ||
                    Created != null &&
                    Created.Equals(other.Created)
                ) && 
                (
                    Modified == other.Modified ||
                    Modified != null &&
                    Modified.Equals(other.Modified)
                ) && 
                (
                    NutrientsNotice == other.NutrientsNotice ||
                    NutrientsNotice != null &&
                    NutrientsNotice.Equals(other.NutrientsNotice)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                var hashCode = 41;
                // Suitable nullity checks etc, of course :)
                    if (Url != null)
                    hashCode = hashCode * 59 + Url.GetHashCode();
                    if (Images != null)
                    hashCode = hashCode * 59 + Images.GetHashCode();
                    if (Source != null)
                    hashCode = hashCode * 59 + Source.GetHashCode();
                    if (Cuisine != null)
                    hashCode = hashCode * 59 + Cuisine.GetHashCode();
                    if (Created != null)
                    hashCode = hashCode * 59 + Created.GetHashCode();
                    if (Modified != null)
                    hashCode = hashCode * 59 + Modified.GetHashCode();
                    if (NutrientsNotice != null)
                    hashCode = hashCode * 59 + NutrientsNotice.GetHashCode();
                return hashCode;
            }
        }

        #region Operators
        #pragma warning disable 1591

        public static bool operator ==(RecipeObjectMeta left, RecipeObjectMeta right)
        {
            return Equals(left, right);
        }

        public static bool operator !=(RecipeObjectMeta left, RecipeObjectMeta right)
        {
            return !Equals(left, right);
        }

        #pragma warning restore 1591
        #endregion Operators
    }
}
