/*
 * Chomp Food & Recipe Database API Documentation
 *
 * ## Important An **[API key](https://chompthis.com/api/)** is required for access to this API. * Get a **Food Data API** key at **[https://chompthis.com/api](https://chompthis.com/api/)**. * Get a **Recipe Data API** key at **[https://chompthis.com/api/recipes](https://chompthis.com/api/recipes/)**.  ### Getting Started   * Subscribe to the **[Food Data API](https://chompthis.com/api/#pricing)** or the **[Recipe Data API](https://chompthis.com/api/recipes/#pricing)**.   * Scroll down and click the \"**Authorize**\" button.   * Enter your API key into the \"**value**\" input, click the \"**Authorize**\" button, then click the \"**Close**\" button.   * Scroll down to the section titled \"**default**\" and click on the API endpoint you wish to use.   * Click the \"**Try it out**\" button.   * Enter the information the endpoint requires.   * Click the \"**Execute**\" button.  ### Example    * Branded food response object: **[View example &raquo;](https://raw.githubusercontent.com/chompfoods/examples/master/branded-food-response-object.json)**   * Ingredient response object: **[View example &raquo;](https://raw.githubusercontent.com/chompfoods/examples/master/ingredient-response-object.json)**   * Recipe response object: **[View example &raquo;](https://raw.githubusercontent.com/chompfoods/examples/master/example-recipe-response.json)**   * Error response object: **[View example &raquo;](https://raw.githubusercontent.com/chompfoods/examples/master/error-response-object.json)**  ### How Do I Find My API Key?   * Your API key was sent to the email address you used to create your subscription.   * You will also find your API key in the **[Client Center](https://chompthis.com/api/manage.php)**.   * Read **[this article](https://desk.zoho.com/portal/chompthis/kb/articles/how-do-i-find-my-api-key)** for more information.  ### I'm a Premium subscriber. How do I access the API?   * All Premium subscribers must pass in a unique user ID for each user on their platform that is accessing data from the Chomp API. A user ID can be any string of letters and numbers that you assign to your user. Simply add \"user_id\" as a URL parameter when calling the API. *You must add a \"user_id\" URL parameter to every call you make to ANY endpoint.*     * **Example**        > ```ENDPOINT.php?api_key=API_KEY&code=CODE&user_id=USER_ID```  ### Helpful Links   * **Help & Support**     * [Knowledge Base &raquo;](https://desk.zoho.com/portal/chompthis/kb/chomp)     * [Support &raquo;](https://chompthis.com/api/ticket-new.php)     * [Client Center &raquo;](https://chompthis.com/api/manage.php)   * **Pricing**     * [Food Data API Subscription Options &raquo;](https://chompthis.com/api/)     * [Recipe Data API Subscription Options &raquo;](https://chompthis.com/api/recipes/)     * [Food Data API Cost Calculator &raquo;](https://chompthis.com/api/cost-calculator.php)     * [Recipe Data API Cost Calculator &raquo;](https://chompthis.com/api/recipes/cost-calculator.php)   * **Guidelines**     * [Terms & License &raquo;](https://chompthis.com/api/terms.php)     * [Attribution &raquo;](https://chompthis.com/api/docs/attribution.php) 
 *
 * OpenAPI spec version: 1.0.0-oas3
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel.DataAnnotations;
using System.Runtime.Serialization;
using Newtonsoft.Json;

namespace IO.Swagger.Models
{ 
    /// <summary>
    /// An object containing information for this specific item.
    /// </summary>
    [DataContract]
    public partial class BrandedFoodObjectItems : IEquatable<BrandedFoodObjectItems>
    { 
        /// <summary>
        /// EAN/UPC barcode
        /// </summary>
        /// <value>EAN/UPC barcode</value>
        [DataMember(Name="barcode")]
        public string Barcode { get; set; }

        /// <summary>
        /// Item name as provided by brand owner or as shown on packaging
        /// </summary>
        /// <value>Item name as provided by brand owner or as shown on packaging</value>
        [DataMember(Name="name")]
        public string Name { get; set; }

        /// <summary>
        /// The brand name that owns this item
        /// </summary>
        /// <value>The brand name that owns this item</value>
        [DataMember(Name="brand")]
        public string Brand { get; set; }

        /// <summary>
        /// This food item&#x27;s ingredients from greatest quantity to least
        /// </summary>
        /// <value>This food item&#x27;s ingredients from greatest quantity to least</value>
        [DataMember(Name="ingredients")]
        public string Ingredients { get; set; }

        /// <summary>
        /// Gets or Sets Package
        /// </summary>
        [DataMember(Name="package")]
        public BrandedFoodObjectPackage Package { get; set; }

        /// <summary>
        /// Gets or Sets Serving
        /// </summary>
        [DataMember(Name="serving")]
        public BrandedFoodObjectServing Serving { get; set; }

        /// <summary>
        /// Gets or Sets Categories
        /// </summary>
        [DataMember(Name="categories")]
        public List<string> Categories { get; set; }

        /// <summary>
        /// An array containing nutrient informatio objects for this food item
        /// </summary>
        /// <value>An array containing nutrient informatio objects for this food item</value>
        [DataMember(Name="nutrients")]
        public List<BrandedFoodObjectNutrients> Nutrients { get; set; }

        /// <summary>
        /// Gets or Sets DietLabels
        /// </summary>
        [DataMember(Name="diet_labels")]
        public BrandedFoodObjectDietLabels DietLabels { get; set; }

        /// <summary>
        /// An array of ingredient objects that were flagged while grading this item for compatibility with each diet
        /// </summary>
        /// <value>An array of ingredient objects that were flagged while grading this item for compatibility with each diet</value>
        [DataMember(Name="diet_flags")]
        public List<BrandedFoodObjectDietFlags> DietFlags { get; set; }

        /// <summary>
        /// Gets or Sets PackagingPhotos
        /// </summary>
        [DataMember(Name="packaging_photos")]
        public BrandedFoodObjectPackagingPhotos PackagingPhotos { get; set; }

        /// <summary>
        /// An array of ingredients in this item that may cause allergic reactions in people
        /// </summary>
        /// <value>An array of ingredients in this item that may cause allergic reactions in people</value>
        [DataMember(Name="allergens")]
        public List<string> Allergens { get; set; }

        /// <summary>
        /// An array of brands we have associated with this item. Some items are sold by more than 1 brand.
        /// </summary>
        /// <value>An array of brands we have associated with this item. Some items are sold by more than 1 brand.</value>
        [DataMember(Name="brand_list")]
        public List<string> BrandList { get; set; }

        /// <summary>
        /// An array of countries where this item is sold
        /// </summary>
        /// <value>An array of countries where this item is sold</value>
        [DataMember(Name="countries")]
        public List<string> Countries { get; set; }

        /// <summary>
        /// Gets or Sets CountryDetails
        /// </summary>
        [DataMember(Name="country_details")]
        public BrandedFoodObjectCountryDetails CountryDetails { get; set; }

        /// <summary>
        /// An array of ingredients made from palm oil
        /// </summary>
        /// <value>An array of ingredients made from palm oil</value>
        [DataMember(Name="palm_oil_ingredients")]
        public List<string> PalmOilIngredients { get; set; }

        /// <summary>
        /// An array of this item&#x27;s ingredients
        /// </summary>
        /// <value>An array of this item&#x27;s ingredients</value>
        [DataMember(Name="ingredient_list")]
        public List<string> IngredientList { get; set; }

        /// <summary>
        /// A boolean indicating if we have English ingredients for this item
        /// </summary>
        /// <value>A boolean indicating if we have English ingredients for this item</value>
        [DataMember(Name="has_english_ingredients")]
        public bool? HasEnglishIngredients { get; set; }

        /// <summary>
        /// An array of minerals that this item contains
        /// </summary>
        /// <value>An array of minerals that this item contains</value>
        [DataMember(Name="minerals")]
        public List<string> Minerals { get; set; }

        /// <summary>
        /// An array of trace ingredients that may be found in this item
        /// </summary>
        /// <value>An array of trace ingredients that may be found in this item</value>
        [DataMember(Name="traces")]
        public List<string> Traces { get; set; }

        /// <summary>
        /// An array of vitamins that are found in this item
        /// </summary>
        /// <value>An array of vitamins that are found in this item</value>
        [DataMember(Name="vitamins")]
        public List<string> Vitamins { get; set; }

        /// <summary>
        /// A description of this item
        /// </summary>
        /// <value>A description of this item</value>
        [DataMember(Name="description")]
        public string Description { get; set; }

        /// <summary>
        /// An array of keywords that can be used to describe this item
        /// </summary>
        /// <value>An array of keywords that can be used to describe this item</value>
        [DataMember(Name="keywords")]
        public List<string> Keywords { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class BrandedFoodObjectItems {\n");
            sb.Append("  Barcode: ").Append(Barcode).Append("\n");
            sb.Append("  Name: ").Append(Name).Append("\n");
            sb.Append("  Brand: ").Append(Brand).Append("\n");
            sb.Append("  Ingredients: ").Append(Ingredients).Append("\n");
            sb.Append("  Package: ").Append(Package).Append("\n");
            sb.Append("  Serving: ").Append(Serving).Append("\n");
            sb.Append("  Categories: ").Append(Categories).Append("\n");
            sb.Append("  Nutrients: ").Append(Nutrients).Append("\n");
            sb.Append("  DietLabels: ").Append(DietLabels).Append("\n");
            sb.Append("  DietFlags: ").Append(DietFlags).Append("\n");
            sb.Append("  PackagingPhotos: ").Append(PackagingPhotos).Append("\n");
            sb.Append("  Allergens: ").Append(Allergens).Append("\n");
            sb.Append("  BrandList: ").Append(BrandList).Append("\n");
            sb.Append("  Countries: ").Append(Countries).Append("\n");
            sb.Append("  CountryDetails: ").Append(CountryDetails).Append("\n");
            sb.Append("  PalmOilIngredients: ").Append(PalmOilIngredients).Append("\n");
            sb.Append("  IngredientList: ").Append(IngredientList).Append("\n");
            sb.Append("  HasEnglishIngredients: ").Append(HasEnglishIngredients).Append("\n");
            sb.Append("  Minerals: ").Append(Minerals).Append("\n");
            sb.Append("  Traces: ").Append(Traces).Append("\n");
            sb.Append("  Vitamins: ").Append(Vitamins).Append("\n");
            sb.Append("  Description: ").Append(Description).Append("\n");
            sb.Append("  Keywords: ").Append(Keywords).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="obj">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object obj)
        {
            if (ReferenceEquals(null, obj)) return false;
            if (ReferenceEquals(this, obj)) return true;
            return obj.GetType() == GetType() && Equals((BrandedFoodObjectItems)obj);
        }

        /// <summary>
        /// Returns true if BrandedFoodObjectItems instances are equal
        /// </summary>
        /// <param name="other">Instance of BrandedFoodObjectItems to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(BrandedFoodObjectItems other)
        {
            if (ReferenceEquals(null, other)) return false;
            if (ReferenceEquals(this, other)) return true;

            return 
                (
                    Barcode == other.Barcode ||
                    Barcode != null &&
                    Barcode.Equals(other.Barcode)
                ) && 
                (
                    Name == other.Name ||
                    Name != null &&
                    Name.Equals(other.Name)
                ) && 
                (
                    Brand == other.Brand ||
                    Brand != null &&
                    Brand.Equals(other.Brand)
                ) && 
                (
                    Ingredients == other.Ingredients ||
                    Ingredients != null &&
                    Ingredients.Equals(other.Ingredients)
                ) && 
                (
                    Package == other.Package ||
                    Package != null &&
                    Package.Equals(other.Package)
                ) && 
                (
                    Serving == other.Serving ||
                    Serving != null &&
                    Serving.Equals(other.Serving)
                ) && 
                (
                    Categories == other.Categories ||
                    Categories != null &&
                    Categories.SequenceEqual(other.Categories)
                ) && 
                (
                    Nutrients == other.Nutrients ||
                    Nutrients != null &&
                    Nutrients.SequenceEqual(other.Nutrients)
                ) && 
                (
                    DietLabels == other.DietLabels ||
                    DietLabels != null &&
                    DietLabels.Equals(other.DietLabels)
                ) && 
                (
                    DietFlags == other.DietFlags ||
                    DietFlags != null &&
                    DietFlags.SequenceEqual(other.DietFlags)
                ) && 
                (
                    PackagingPhotos == other.PackagingPhotos ||
                    PackagingPhotos != null &&
                    PackagingPhotos.Equals(other.PackagingPhotos)
                ) && 
                (
                    Allergens == other.Allergens ||
                    Allergens != null &&
                    Allergens.SequenceEqual(other.Allergens)
                ) && 
                (
                    BrandList == other.BrandList ||
                    BrandList != null &&
                    BrandList.SequenceEqual(other.BrandList)
                ) && 
                (
                    Countries == other.Countries ||
                    Countries != null &&
                    Countries.SequenceEqual(other.Countries)
                ) && 
                (
                    CountryDetails == other.CountryDetails ||
                    CountryDetails != null &&
                    CountryDetails.Equals(other.CountryDetails)
                ) && 
                (
                    PalmOilIngredients == other.PalmOilIngredients ||
                    PalmOilIngredients != null &&
                    PalmOilIngredients.SequenceEqual(other.PalmOilIngredients)
                ) && 
                (
                    IngredientList == other.IngredientList ||
                    IngredientList != null &&
                    IngredientList.SequenceEqual(other.IngredientList)
                ) && 
                (
                    HasEnglishIngredients == other.HasEnglishIngredients ||
                    HasEnglishIngredients != null &&
                    HasEnglishIngredients.Equals(other.HasEnglishIngredients)
                ) && 
                (
                    Minerals == other.Minerals ||
                    Minerals != null &&
                    Minerals.SequenceEqual(other.Minerals)
                ) && 
                (
                    Traces == other.Traces ||
                    Traces != null &&
                    Traces.SequenceEqual(other.Traces)
                ) && 
                (
                    Vitamins == other.Vitamins ||
                    Vitamins != null &&
                    Vitamins.SequenceEqual(other.Vitamins)
                ) && 
                (
                    Description == other.Description ||
                    Description != null &&
                    Description.Equals(other.Description)
                ) && 
                (
                    Keywords == other.Keywords ||
                    Keywords != null &&
                    Keywords.SequenceEqual(other.Keywords)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                var hashCode = 41;
                // Suitable nullity checks etc, of course :)
                    if (Barcode != null)
                    hashCode = hashCode * 59 + Barcode.GetHashCode();
                    if (Name != null)
                    hashCode = hashCode * 59 + Name.GetHashCode();
                    if (Brand != null)
                    hashCode = hashCode * 59 + Brand.GetHashCode();
                    if (Ingredients != null)
                    hashCode = hashCode * 59 + Ingredients.GetHashCode();
                    if (Package != null)
                    hashCode = hashCode * 59 + Package.GetHashCode();
                    if (Serving != null)
                    hashCode = hashCode * 59 + Serving.GetHashCode();
                    if (Categories != null)
                    hashCode = hashCode * 59 + Categories.GetHashCode();
                    if (Nutrients != null)
                    hashCode = hashCode * 59 + Nutrients.GetHashCode();
                    if (DietLabels != null)
                    hashCode = hashCode * 59 + DietLabels.GetHashCode();
                    if (DietFlags != null)
                    hashCode = hashCode * 59 + DietFlags.GetHashCode();
                    if (PackagingPhotos != null)
                    hashCode = hashCode * 59 + PackagingPhotos.GetHashCode();
                    if (Allergens != null)
                    hashCode = hashCode * 59 + Allergens.GetHashCode();
                    if (BrandList != null)
                    hashCode = hashCode * 59 + BrandList.GetHashCode();
                    if (Countries != null)
                    hashCode = hashCode * 59 + Countries.GetHashCode();
                    if (CountryDetails != null)
                    hashCode = hashCode * 59 + CountryDetails.GetHashCode();
                    if (PalmOilIngredients != null)
                    hashCode = hashCode * 59 + PalmOilIngredients.GetHashCode();
                    if (IngredientList != null)
                    hashCode = hashCode * 59 + IngredientList.GetHashCode();
                    if (HasEnglishIngredients != null)
                    hashCode = hashCode * 59 + HasEnglishIngredients.GetHashCode();
                    if (Minerals != null)
                    hashCode = hashCode * 59 + Minerals.GetHashCode();
                    if (Traces != null)
                    hashCode = hashCode * 59 + Traces.GetHashCode();
                    if (Vitamins != null)
                    hashCode = hashCode * 59 + Vitamins.GetHashCode();
                    if (Description != null)
                    hashCode = hashCode * 59 + Description.GetHashCode();
                    if (Keywords != null)
                    hashCode = hashCode * 59 + Keywords.GetHashCode();
                return hashCode;
            }
        }

        #region Operators
        #pragma warning disable 1591

        public static bool operator ==(BrandedFoodObjectItems left, BrandedFoodObjectItems right)
        {
            return Equals(left, right);
        }

        public static bool operator !=(BrandedFoodObjectItems left, BrandedFoodObjectItems right)
        {
            return !Equals(left, right);
        }

        #pragma warning restore 1591
        #endregion Operators
    }
}
