<?php
/**
 * Class OpenStreetmapAPITest
 *
 * @created      05.03.2024
 * @author       smiley <smiley@chillerlan.net>
 * @copyright    2024 smiley
 * @license      MIT
 */

namespace chillerlan\OAuthTest\Providers\Live;

use chillerlan\HTTP\Utils\MessageUtil;
use chillerlan\OAuth\Providers\OpenStreetmap2;
use chillerlan\OAuthTest\Providers\OAuth2APITestAbstract;

/**
 * @property \chillerlan\OAuth\Providers\OpenStreetmap2 $provider
 */
class OpenStreetmap2APITest extends OAuth2APITestAbstract{

	protected string $FQN = OpenStreetmap2::class;
	protected string $ENV = 'OPENSTREETMAP2';

	public function testMe():void{
		$this::assertSame($this->testuser, MessageUtil::decodeJSON($this->provider->me())->user->display_name);
	}

}
