// +build stanfordrel

package treebank

import "github.com/chewxy/lingo"

var dependencyTable map[string]lingo.DependencyType = map[string]lingo.DependencyType{
	"root":       lingo.Root,
	"dep":        lingo.Dep,
	"aux":        lingo.Aux,
	"auxpass":    lingo.AuxPass,
	"cop":        lingo.Cop,
	"arg":        lingo.Arg,
	"agent":      lingo.Agent,
	"comp":       lingo.Comp,
	"acomp":      lingo.AComp,
	"ccomp":      lingo.CComp,
	"xcomp":      lingo.XComp,
	"obj":        lingo.Obj,
	"dobj":       lingo.DObj,
	"iobj":       lingo.IObj,
	"pobj":       lingo.PObj,
	"subj":       lingo.Subj,
	"nsubj":      lingo.NSubj,
	"nsubjpass":  lingo.NSubjPass,
	"csubj":      lingo.CSubj,
	"csubjpass":  lingo.CSubjPass,
	"cc":         lingo.Coordination,
	"conj":       lingo.Conj,
	"expl":       lingo.Expl,
	"mod":        lingo.Mod,
	"amod":       lingo.AMod,
	"appos":      lingo.Appos,
	"advcl":      lingo.Advcl,
	"det":        lingo.Det,
	"predet":     lingo.Predet,
	"preconj":    lingo.Preconj,
	"vmod":       lingo.Vmod,
	"mwe":        lingo.MWE,
	"mark":       lingo.Mark,
	"advmod":     lingo.AdvMod,
	"neg":        lingo.Neg,
	"rcmod":      lingo.RCMod,
	"quantmod":   lingo.QuantMod,
	"nn":         lingo.NounMod,
	"npadvmod":   lingo.NPAdvMod,
	"tmod":       lingo.TMod,
	"num":        lingo.Num,
	"number":     lingo.NumberElement,
	"prep":       lingo.Prep,
	"poss":       lingo.Poss,
	"possessive": lingo.Possessive,
	"prt":        lingo.PRT,
	"parataxis":  lingo.Parataxis,
	"goeswith":   lingo.GoesWith,
	"punct":      lingo.Punct,
	"ref":        lingo.Ref,
	"sdep":       lingo.SDep,
	"xsubj":      lingo.XSubj,

	// additional stuff not found in the original, but found in EWT
	"case":       lingo.Case,
	"compound":   lingo.Compound,
	"nmod":       lingo.NMod,
	"discourse":  lingo.Discourse,
	"nummod":     lingo.NumMod,
	"relcl":      lingo.RelCl,
	"nfincl":     lingo.NFinCl,
	"nmod:poss":  lingo.NMod_Poss,
	"nmod:npmod": lingo.NMod_NPMod,
	"vocative":   lingo.Vocative,
	"list":       lingo.List,
	"mwprep":     lingo.MWPrep,
	"remnant":    lingo.Remnant,
	"acl":        lingo.Acl,
	"npmod":      lingo.NPMod,
	"mdvod":      lingo.MDVod,
	"detmod":     lingo.DetMod,

	// found in NNParser
	"pcomp": lingo.PComp,

	"-NULL-": lingo.Dep,
}
