# Simple Python Weather App With Flask

This is a simple Flask web application that allows users to fetch and display weather information for a given city.

## Getting Started

### Prerequisites

- Python 3.x
- Flask
- Requests library

### Installation

1. **Clone the repository** to your local machine:

    ```bash
    git clone <REPOSITORY URL>
    ```

2. **Navigate to the project directory**:

    ```bash
    cd flask-weather-app
    ```

3. **Install the required packages**:

    ```bash
    pip install Flask requests
    ```

4. **Set up your OpenWeatherMap API key**. Replace `'YOUR_API_KEY'` in `app.py` with your actual API key.

5. **Run the application**:

    ```bash
    python app.py
    ```

    The app will be accessible at [http://localhost:5000](http://localhost:5000).

## Usage

1. **Enter the city name** in the provided form.
2. **Click the "Submit" button**.
3. The application will display the temperature and weather description.

## License

This project is licensed under the [MIT License](LICENSE).

## Acknowledgements

- Weather data is provided by [OpenWeatherMap](https://openweathermap.org/).
- This app was built using the Flask web framework.
