# Dice Roller

A simple web application to simulate the rolling of dice, built with Streamlit.

## Live Demo

Check out the live demo of the Dice Roller: [https://dice-roller.streamlit.app/](https://dice-roller.streamlit.app/)

## Features

- User can select the number of dice to roll.
- Upon rolling, a visual representation of each die and its value is shown.
- The application provides a fun and interactive way to simulate dice rolls.

## How to Use

1. Open the Dice Roller web app.
2. Use the slider to select the number of dice you want to roll.
3. Click the "Generate Random Dice" button.
4. The rolled dice and their values will be displayed below.

## Dependencies

To install and run the Dice Roller, you'll need:

- `streamlit`: For rendering and serving the web application.
- `dice_art`: For the visual representation of the dice.

You can install these dependencies using the provided `requirements.txt` file:

```
pip install -r requirements.txt
```

## Running the App

After installing the dependencies, run the Streamlit app using the following command:

```
streamlit run main.py
```

