"""Generate the code reference pages and navigation."""

from pathlib import Path
import os
import fnmatch
import mkdocs_gen_files

nav = mkdocs_gen_files.Nav()

core_code_dir = 'cheshire_cat_api'

all_paths = []
for path in sorted(Path(core_code_dir).rglob("*.py")):
    all_paths.append(path)

paths = all_paths  # [p for p in all_paths for k in KEEP_PAGES if fnmatch.fnmatch(str(p), f"*{k}.py")]

for path in paths:

    module_path = path.relative_to(core_code_dir).with_suffix("")
    doc_path = path.relative_to(core_code_dir).with_suffix(".md")
    full_doc_path = Path("API_Documentation", doc_path)

    parts = tuple(module_path.parts)

    if parts[-1] == "__init__":
        # if parts[:-1] == ():
        # parts = parts[:-1]
        # doc_path = doc_path.with_name("index.md")
        # print(parts)
        continue
        #full_doc_path = full_doc_path.with_name("index.md")
    elif parts[-1] == "__main__":
        continue

    nav[parts] = doc_path.as_posix()  #

    with mkdocs_gen_files.open(full_doc_path, "w") as fd:
        ident = ".".join(parts)
        fd.write(f"::: {core_code_dir}.{ident}")  # {ident}

    mkdocs_gen_files.set_edit_path(full_doc_path, path)

with mkdocs_gen_files.open("API_Documentation/SUMMARY.md", "w") as nav_file:  #
    if os.path.exists(core_code_dir):
        nav_file.writelines(nav.build_literate_nav())  #
    else:
        nav_file.writelines(["Do not edit: here will be documentation generated by mkdocstrings"])