# coding: utf-8

"""
    😸 Cheshire-Cat API

    Production ready AI assistant framework

    The version of the OpenAPI document: 1.3.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictInt, StrictStr
from pydantic import Field
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class BodyUploadUrl(BaseModel):
    """
    BodyUploadUrl
    """ # noqa: E501
    url: StrictStr = Field(description="URL of the website to which you want to save the content")
    chunk_size: Optional[StrictInt] = Field(default=400, description="Maximum length of each chunk after the document is split (in characters)")
    chunk_overlap: Optional[StrictInt] = Field(default=100, description="Chunk overlap (in characters)")
    __properties: ClassVar[List[str]] = ["url", "chunk_size", "chunk_overlap"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of BodyUploadUrl from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of BodyUploadUrl from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "url": obj.get("url"),
            "chunk_size": obj.get("chunk_size") if obj.get("chunk_size") is not None else 400,
            "chunk_overlap": obj.get("chunk_overlap") if obj.get("chunk_overlap") is not None else 100
        })
        return _obj


