# Cheshire Cat API client
API to develop Python clients to interact with the Cheshire Cat.

The package allows instantiating a [WebSocket](#documentation-for-websocket) client and provides the API to interact with all the [endpoints](#documentation-for-api-endpoints).

A part of this Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project.

For deeper documentation about the available endpoints, please refer to the API [ReDoc](http://localhost:1865/redoc).
The official Cheshire Cat documentation is available [here](https://cheshire-cat-ai.github.io/docs/).

## Requirements.

Python 3.10

## Installation & Usage
### pip install

You can install the API with `pip`:

```sh
pip install cheshire-cat-api
```

Then import the package:
```python
import cheshire_cat_api as ccat
```

[//]: # (### Tests)

[//]: # ()
[//]: # (Execute `pytest` to run the tests.)

### Interact with the HTTP Endpoints

## Available APIs

The `CatClient` has the following attributes to easily interface with the related APis:

- memory
- plugins
- rabbit_hole
- status
- embedder
- settings
- llm

#### Instantiate connection

```python
import cheshire_cat_api as ccat

# A config is necessary to set up base parameters like
# URL, port, user_id, etc.
config = ccat.Config(user_id="my_user_42")

# Connect to the API
cat_client = ccat.CatClient(
    config=config
)
```

#### Plugin API - Retrieve plugins

```python
# Now retrieve a list of the available plugins
plugins = cat_client.plugins.get_available_plugins()
```

#### RabbitHole API - Upload a URL

```python
from cheshire_cat_api.models.body_upload_url import BodyUploadUrl

# Please note that interacting with the RabbitHole to upload
# a URL requires structuring the body like this

body_upload_url = BodyUploadUrl(
    url="https://cheshire-cat-ai.github.io/docs/conceptual/cheshire_cat/rabbit_hole/"
)

# then you can make the request as follows
response = cat_client.rabbit_hole.upload_url(body_upload_url)
```

### Send a WebSocket message

```python
import time
import cheshire_cat_api as ccat

# A config is necessary to set up base parameters like
# URL, port, user_id, etc.
config = ccat.Config(user_id="my_user_42")
cat_client = ccat.CatClient(config=config)

# Connect to the WebSocket API
cat_client.connect_ws()

while not cat_client.is_ws_connected: 
# A better handling is strongly advised to avoid an infinite loop 
    time.sleep(1)
    
# Send the message
cat_client.send(message="Hello Cat!")

# Close connection
cat_client.close()
```

## Documentation for Config

Both the classes are available with:
```python
from cheshire_cat_api import Config
```

| Class    | Name                | Default     | Description                               |
|----------|---------------------|-------------|-------------------------------------------|
| *Config* | `base_url`          | "localhost" | base URL where the Cat is hosted          |
| *Config* | `port`              | 1865        | port for the connection                   |
| *Config* | `user_id`           | "user"      | id of the client                          |
| *Config* | `auth_key`          | ""          | authentication key for the http endpoints |
| *Config* | `secure_connection` | False       | if to use secure protocol                 |

## Low-level API

For a more advanced usage, you can directly interact with the auto-generated client.
For documentation see [here](mkdocs/)

[//]: # (## Documentation for API Endpoints)

[//]: # ()
[//]: # (All URIs are relative to *http://localhost*)

[//]: # ()
[//]: # (| Class                           | Method        | HTTP request                                            | Description                 |)

[//]: # (|---------------------------------|---------------|---------------------------------------------------------|-----------------------------|)

[//]: # (| *MemoryApi*                     | **wipe_memory_point** | **DELETE** /memory/point/{collection_id}/{memory_id}/   | Delete Element In Memory    |)

[//]: # (| *MemoryApi*                     | **get_collections** | **GET** /memory/collections/                            | Get Collections             |)

[//]: # (| *MemoryApi*                     | **recall_memories_from_text** | **GET** /memory/recall/                                 | Recall Memories From Text   |)

[//]: # (| *MemoryApi*                     | **wipe_collections** | **DELETE** /memory/wipe-collections/                    | Wipe Collections            |)

[//]: # (| *MemoryApi*                     | **wipe_conversation_history** | **DELETE** /memory/working-memory/conversation-history/ | Wipe Conversation History   |)

[//]: # (| *MemoryApi*                     | **wipe_single_collection** | **DELETE** /memory/collections/{collection_id}          | Wipe Single Collection      |)

[//]: # (| *MemoryApi*                    | **get_conversation_history** | **GET** /memory/conversation_history/ |)

[//]: # (| **Memory**)

[//]: # (| *PluginsApi*                    | **delete_plugin** | **DELETE** /plugins/{plugin_id}                         | Delete Plugin               |)

[//]: # (| *PluginsApi*                    | **get_plugin_details** | **GET** /plugins/{plugin_id}                            | Get Plugin Details          |)

[//]: # (| *PluginsApi*                    | **get_plugin_settings** | **GET** /plugins/settings/{plugin_id}                   | Get Plugin Settings         |)

[//]: # (| *PluginsApi*                    | **install_plugin** | **POST** /plugins/upload/                               | Install Plugin              |)

[//]: # (| *PluginsApi*                    | **list_available_plugins** | **GET** /plugins/                                       | List Available Plugins      |)

[//]: # (| *PluginsApi*                    | **toggle_plugin** | **PUT** /plugins/toggle/{plugin_id}                     | Toggle Plugin               |)

[//]: # (| *PluginsApi*                    | **upsert_plugin_settings** | **PUT** /plugins/settings/{plugin_id}                   | Upsert Plugin Settings      |)

[//]: # (| *RabbitHoleApi*                 | **upload_file** | **POST** /rabbithole/                                   | Upload File                 |)

[//]: # (| *RabbitHoleApi*                 | **upload_memory** | **POST** /rabbithole/memory/                            | Upload Memory               |)

[//]: # (| *RabbitHoleApi*                 | **upload_url** | **POST** /rabbithole/web/                               | Upload Url                  |)

[//]: # (| *SettingsEmbedderApi*           | **get_embedder_settings** | **GET** /settings/embedder/                             | Get Embedder Settings       |)

[//]: # (| *SettingsEmbedderApi*           | **upsert_embedder_setting** | **PUT** /settings/embedder/{languageEmbedderName}       | Upsert Embedder Setting     |)

[//]: # (| *SettingsGeneralApi*            | **create_setting** | **POST** /settings/                                     | Create Setting              |)

[//]: # (| *SettingsGeneralApi*            | **delete_setting** | **DELETE** /settings/{settingId}                        | Delete Setting              |)

[//]: # (| *SettingsGeneralApi*            | **get_setting** | **GET** /settings/{settingId}                           | Get Setting                 |)

[//]: # (| *SettingsGeneralApi*            | **get_settings** | **GET** /settings/                                      | Get Settings                |)

[//]: # (| *SettingsGeneralApi*            | **update_setting** | **PUT** /settings/{settingId}                           | Update Setting              |)

[//]: # (| *SettingsLargeLanguageModelApi* | **get_llm_settings** | **GET** /settings/llm/                                  | Get Llm Settings            |)

[//]: # (| *SettingsLargeLanguageModelApi* | **upsert_llm_setting** | **PUT** /settings/llm/{languageModelName}               | Upsert Llm Setting          |)

[//]: # (| *SettingsPromptApi*             | **get_default_prompt_settings** | **GET** /settings/prompt/                               | Get Default Prompt Settings |)

[//]: # (| *StatusApi*                     | **home**      | **GET** /                                               | Home                        |)

[//]: # (## Documentation For Models)

[//]: # ()
[//]: # ( - [BodyUploadUrl]&#40;docs/BodyUploadUrl.md&#41;)

[//]: # ( - [HTTPValidationError]&#40;docs/HTTPValidationError.md&#41;)

[//]: # ( - [LocationInner]&#40;docs/LocationInner.md&#41;)

[//]: # ( - [SettingBody]&#40;docs/SettingBody.md&#41;)

[//]: # ( - [ValidationError]&#40;docs/ValidationError.md&#41;)




