<p align="center"><img src="./Readme-Assets/logo.png" width="200" /></p>

<p align="center">
    <picture>
      <source 
        srcset="./Readme-Assets/light-text.png"
        media="(prefers-color-scheme: dark)"
      />
      <img 
        src="./Readme-Assets/dark-text.png" 
        alt="Logo Text"
        width="800"
       />
    </picture>
  </p>
<h4 align="center">🔥The Wildfire Detection Node Network 🔥</h4>
<h6>
This project focuses on creating a wireless mesh network for early wildfire detection using LoRa. Wildfires pose significant threats to ecosystems, property, and human life, especially in remote areas where detection and response times are often delayed. The system leverages multiple nodes equipped with smoke sensors spread across a forest, forming a mesh network to relay fire alerts to a gateway, which then sends the alerts to a remote monitoring system.
</h6>

### Key Features:
- **Early Detection**: Detect wildfires at an early stage to enable a faster response.
- **Local Mesh Communication**: Nodes communicate wirelessly and locally, relaying data to the hub, ensuring reliable communication even in rugged environments.
- **Low Power Consumption**: Designed for long-term deployment in remote areas with limited access to power.
- **Scalability**: Easily expandable by adding more nodes to the network.
- **Reliability**: Ensures the network can function even if some nodes are temporarily out of communication range.

<br>
<p align="center">
<a href="https://github.com/chathura-de-silva/Firesense/wiki">
<img src="./Readme-Assets/ReadMoreButton.png" a
style="width: 60%; height: auto;" alt="Wiki Button" 
></a>
</p>


<div align="center">
	<code><img width="50" src="./Readme-Assets/192108891-d86b6220-e232-423a-bf5f-90903e6887c3.png" alt="Visual Studio Code" title="Visual Studio Code"/></code>
	<code><img width="50" src="./Readme-Assets/192106073-90fffafe-3562-4ff9-a37e-c77a2da0ff58.png" alt="C++" title="C++"/></code>
	<code><img width="50" src="./Readme-Assets/node-red-icon.png" alt="Node-Red" title="Node-Red"/></code>
	<code><img width="50" src="./Readme-Assets/PlatformIO_logo.svg" alt="PlatformIO" title="UPlatformIO"/></code>
	<code><img width="50" src="./Readme-Assets/255505529-a57a85ba-e2dd-4036-85b6-7e1532391627.png" alt="Arduino" title="Arduino"/></code>
</div>

## License

This project is licensed under the MIT License. See the [LICENSE](./LICENSE.txt) file for details.
