# Governance

The governance model adopted in ChaosBlade is influenced by many CNCF projects.

## Principles

- **Open**: ChaosBlade is open source community.
- **Welcoming and respectful**: See [Code of Conduct](https://github.com/cncf/foundation/blob/master/code-of-conduct.md).
- **Transparent and accessible**: Work and collaboration should be done in public.
- **Merit**: Ideas and contributions are accepted according to their technical merit
  and alignment with project objectives, scope and design principles.

## Project Maintainers

Maintainers are the first and foremost contributors that are committed to the success of ChaosBlade project.
They normally take the following responsibilities:

- Classify GitHub issues and perform pull request reviews for other maintainers and the community.

- During GitHub issue classification, apply all applicable [labels](https://github.com/chaosblade-io/chaosblade/labels)
  to each new issue. Labels are extremely useful for follow-up of future issues. Which labels to apply
  is somewhat subjective so just use your best judgment.

- Make sure that ongoing PRs are moving forward at the right pace or closing them if they are not
  moving in a productive direction.

- Participate when called upon in the security release process. Note
  that although this should be a rare occurrence, if a serious vulnerability is found, the process
  may take up to several full days of work to implement.

## Process of becoming a maintainer

- Talk to one of the existing project [maintainers](MAINTAINERS.md) that you are interested in becoming a
  maintainer and he will nominate you as a new maintainer. After nomination, you will need to
  create a PR to update the list in [MAINTAINERS.md](MAINTAINERS.md).
- We will expect you to start contributing increasingly complicated PRs, under the guidance
  of the existing maintainers.
- We may ask you to do some PRs from our backlog. As you gain experience with the code base and our standards,
  we will ask you to do code reviews for incoming PRs.
- Once the existing maintainers have made a consensus that the nominating maintainer has deep understanding
  about the project and is able to independently take the maintainer responsibilities,
  the PR will be approved and the new maintainer becomes active.

## When does a maintainer lose maintainer status

- If a maintainer is no longer interested or cannot perform the maintainer duties listed above, they
should volunteer to be moved to emeritus status.

- In extreme cases this can also occur by a vote of the maintainers per the voting process. The voting
process is a simple majority in which each maintainer receives one vote.

## Decision making process

Decisions are made based on consensus between maintainers.
Proposals and ideas can either be submitted for agreement via a github issue or PR,
or by sending an email to `chaosblade.io.01@gmail.com`.

In general, we prefer that technical issues and maintainer membership are amicably worked out between the persons involved.
If a dispute cannot be decided independently, get a third-party maintainer (e.g. a mutual contact with some background
on the issue, but not involved in the conflict) to intercede and the final decision will be made.
Decision making process should be transparent to adhere to the principles of ChaosBlade project.

## Code of Conduct

The ChaosBlade [Code of Conduct](CODE_OF_CONDUCT.md) is aligned with the CNCF Code of Conduct.

## Release process
Eligibility to be a release manager:

- MUST be an active Maintainer
- MUST have the GPG fingerprint listed in the maintainer list

Release steps:

- Open an issue to propose making a new release. The proposal should be public, with an exception for vulnerability fixes. If this is the first time for you to take a role of release management, you SHOULD make a beta (or alpha, RC) release as an exercise before releasing GA.
- Make sure that all the merged PRs are associated with the correct Milestone.
- Run git tag --sign vX.Y.Z-beta.W .
- Run git push UPSTREAM vX.Y.Z-beta.W .
- Wait for the Release action on GitHub Actions to complete. A draft release will appear in https://github.com/chaosblade-io/chaosblade/releases .
- Add release notes in the draft release, to explain the changes and show appreciation to the contributors. Make sure to fulfill the Release manager: [ADD YOUR NAME HERE] (@[ADD YOUR GITHUB ID HERE]) line with your name. e.g., Release manager: MandssS (@MandssS) .
- Click the Set as a pre-release checkbox if this release is a beta (or alpha, RC).
- Click the Publish release button.
- Close the Milestone.


## Credits

Some contents in this documents have been borrowed from [BFE](https://github.com/bfenetworks/bfe/blob/develop/GOVERNANCE.md) and [CoreDNS](https://github.com/coredns/coredns/blob/master/GOVERNANCE.md) projects.
