---
title: "Chapter 10 Outlook: Introduction of C++20"
type: book-en-us
order: 10
---

# Chapter 10 Outlook: Introduction of C++20

[TOC]

C++20 seems to be an exciting update.
For example, as early as C++11, the `Concept`,
which was eager to call for high-altitude but ultimately lost, is now on the line.
The C++ Organizing Committee decided to vote to finalize C++20 with many proposals,
such as **Concepts**/**Module**/**Coroutine**/**Ranges**/ and so on.
In this chapter, we'll take a look at some of the important features that
C++20 will introduce.

## Concept

The concept is a further enhancement to C++ template programming.
In simple terms, the concept is a compile-time feature.
It allows the compiler to evaluate template parameters at compile-time,
greatly enhancing our experience with template programming in C++.
When programming with templates, we often encounter a variety of heinous errors.
This is because we have so far been unable to check and limit template parameters.
For example, the following two lines of code can cause a lot of
almost unreadable compilation errors:

```cpp
#include <list>
#include <algorithm>
int main() {
    std::list<int> l = {1, 2, 3};
    std::sort(l.begin(), l.end());
    return 0;
}
```

The root cause of this code error is that `std::sort` must provide
a random iterator for the sorting container, otherwise it will not be used,
and we know that `std::list` does not support random access.
In the conceptual language, the iterator in `std::list` does not satisfy
the constraint of the concept of random iterators in `std::sort`.
After introducing the concept, we can constrain the template parameters
like this:

```cpp
template <typename T>
requires Sortable<T> // Sortable is a concept
void sort(T& c);
```

abbreviate as:

```cpp
template<Sortable T> // T is a Sortable typename
void sort(T& c)
```

Even use it directly as a type:

```cpp
void sort(Sortable& c); // c is a Sortable type object
```

Let's look at a practical example.

TODO:

## Module

TODO:

## Contract

TODO:

## Range

TODO:

## Coroutine

TODO:

## Conclusion

In general, I finally saw the exciting features of Concepts/Ranges/Modules in C++20.
This is still full of charm for a programming language that is already in its thirties.

[Table of Content](./toc.md) | [Previous Chapter](./09-others.md) | [Next Chapter](./appendix1.md)

## Further Readings

- [Why Concepts didn't make C++17？](http://honermann.net/blog/2016/03/06/why-concepts-didnt-make-cxx17/)
- [C++11/14/17/20 Compiler Support](https://en.cppreference.com/w/cpp/compiler_support)
- [C++ History](https://en.cppreference.com/w/cpp/language/history)

## Licenses

<a rel="license" href="https://creativecommons.org/licenses/by-nc-nd/4.0/"><img alt="Creative Commons License" style="border-width:0" src="https://i.creativecommons.org/l/by-nc-nd/4.0/88x31.png" /></a><br />This work was written by [Ou Changkun](https://changkun.de) and licensed under a <a rel="license" href="https://creativecommons.org/licenses/by-nc-nd/4.0/">Creative Commons Attribution-NonCommercial-NoDerivatives 4.0 International License</a>. The code of this repository is open sourced under the [MIT license](../../LICENSE).
