# Contribution guidelines

Thank you for your interest in contributing to this project! There are a few rules to follow in order to ensure quality. If you do not follow the
guidelines, your contribution might be rejected.

1. Make sure to create an issue describing what you would like to do
    - Please wait for a maintainer to approve the proposed changes.
2. Make sure to work in a fork and in a separate branch
    - **Create your branch from the `develop` branch**
    - For features the branch is usually called `feature/my-cool-feature` or `feature-my-cool-feature`.
    - For bugfixes the branch is usually called `fix/my-cool-feature` or `fix-my-cool-feature`.
3. Only create a pull request if your changes are ready to be reviewed and merged
    - **Merge into `develop`, not `master`**
    - If you want to change something after you have created your pull request please write a small notice in your pr. When you're done, make sure to
      ping a maintainer / request a review.
4. Please use the issue and pull request templates

# Code guidelines

Please follow the [Google Java styleguide](https://google.github.io/styleguide/javaguide.html). Please also document your code, especially in complex
and convoluted methods.

### Maintainers

[@cerus](https://github.com/cerus)
