// This file has been generated by Py++.

#include "boost/python.hpp"
#include "generators/include/python_CEGUIOpenGLRenderer.h"
#include "OpenGLRenderer.pypp.hpp"

namespace bp = boost::python;

struct OpenGLRenderer_wrapper : CEGUI::OpenGLRenderer, bp::wrapper< CEGUI::OpenGLRenderer > {

    OpenGLRenderer_wrapper(::CEGUI::OpenGLRenderer::TextureTargetType const tt_type )
    : CEGUI::OpenGLRenderer( tt_type )
      , bp::wrapper< CEGUI::OpenGLRenderer >(){
        // constructor
    
    }

    OpenGLRenderer_wrapper(::CEGUI::Sizef const & display_size, ::CEGUI::OpenGLRenderer::TextureTargetType const tt_type )
    : CEGUI::OpenGLRenderer( boost::ref(display_size), tt_type )
      , bp::wrapper< CEGUI::OpenGLRenderer >(){
        // constructor
    
    }

    virtual void beginRendering(  ) {
        if( bp::override func_beginRendering = this->get_override( "beginRendering" ) )
            func_beginRendering(  );
        else{
            this->CEGUI::OpenGLRenderer::beginRendering(  );
        }
    }
    
    void default_beginRendering(  ) {
        CEGUI::OpenGLRenderer::beginRendering( );
    }

    void cleanupExtraStates(  ){
        CEGUI::OpenGLRenderer::cleanupExtraStates(  );
    }

    virtual ::CEGUI::OpenGLGeometryBufferBase * createGeometryBuffer_impl(  ){
        if( bp::override func_createGeometryBuffer_impl = this->get_override( "createGeometryBuffer_impl" ) )
            return func_createGeometryBuffer_impl(  );
        else{
            return this->CEGUI::OpenGLRenderer::createGeometryBuffer_impl(  );
        }
    }
    
    virtual ::CEGUI::OpenGLGeometryBufferBase * default_createGeometryBuffer_impl(  ){
        return CEGUI::OpenGLRenderer::createGeometryBuffer_impl( );
    }

    virtual ::CEGUI::TextureTarget * createTextureTarget_impl(  ){
        if( bp::override func_createTextureTarget_impl = this->get_override( "createTextureTarget_impl" ) )
            return func_createTextureTarget_impl(  );
        else{
            return this->CEGUI::OpenGLRenderer::createTextureTarget_impl(  );
        }
    }
    
    virtual ::CEGUI::TextureTarget * default_createTextureTarget_impl(  ){
        return CEGUI::OpenGLRenderer::createTextureTarget_impl( );
    }

    virtual void endRendering(  ) {
        if( bp::override func_endRendering = this->get_override( "endRendering" ) )
            func_endRendering(  );
        else{
            this->CEGUI::OpenGLRenderer::endRendering(  );
        }
    }
    
    void default_endRendering(  ) {
        CEGUI::OpenGLRenderer::endRendering( );
    }

    void initialiseGLExtensions(  ){
        CEGUI::OpenGLRenderer::initialiseGLExtensions(  );
    }

    void initialiseRendererIDString(  ){
        CEGUI::OpenGLRenderer::initialiseRendererIDString(  );
    }

    void initialiseTextureTargetFactory( ::CEGUI::OpenGLRenderer::TextureTargetType const tt_type ){
        CEGUI::OpenGLRenderer::initialiseTextureTargetFactory( tt_type );
    }

    virtual bool isS3TCSupported(  ) const  {
        if( bp::override func_isS3TCSupported = this->get_override( "isS3TCSupported" ) )
            return func_isS3TCSupported(  );
        else{
            return this->CEGUI::OpenGLRenderer::isS3TCSupported(  );
        }
    }
    
    bool default_isS3TCSupported(  ) const  {
        return CEGUI::OpenGLRenderer::isS3TCSupported( );
    }

    void setupExtraStates(  ){
        CEGUI::OpenGLRenderer::setupExtraStates(  );
    }

    virtual void setupRenderingBlendMode( ::CEGUI::BlendMode const mode, bool const force=false ) {
        if( bp::override func_setupRenderingBlendMode = this->get_override( "setupRenderingBlendMode" ) )
            func_setupRenderingBlendMode( mode, force );
        else{
            this->CEGUI::OpenGLRenderer::setupRenderingBlendMode( mode, force );
        }
    }
    
    void default_setupRenderingBlendMode( ::CEGUI::BlendMode const mode, bool const force=false ) {
        CEGUI::OpenGLRenderer::setupRenderingBlendMode( mode, force );
    }

    virtual ::CEGUI::TextureTarget * createTextureTarget(  ) {
        if( bp::override func_createTextureTarget = this->get_override( "createTextureTarget" ) )
            return func_createTextureTarget(  );
        else{
            return this->CEGUI::OpenGLRendererBase::createTextureTarget(  );
        }
    }
    
    ::CEGUI::TextureTarget * default_createTextureTarget(  ) {
        return CEGUI::OpenGLRendererBase::createTextureTarget( );
    }

    virtual void destroyAllGeometryBuffers(  ) {
        if( bp::override func_destroyAllGeometryBuffers = this->get_override( "destroyAllGeometryBuffers" ) )
            func_destroyAllGeometryBuffers(  );
        else{
            this->CEGUI::OpenGLRendererBase::destroyAllGeometryBuffers(  );
        }
    }
    
    void default_destroyAllGeometryBuffers(  ) {
        CEGUI::OpenGLRendererBase::destroyAllGeometryBuffers( );
    }

    virtual void destroyAllTextureTargets(  ) {
        if( bp::override func_destroyAllTextureTargets = this->get_override( "destroyAllTextureTargets" ) )
            func_destroyAllTextureTargets(  );
        else{
            this->CEGUI::OpenGLRendererBase::destroyAllTextureTargets(  );
        }
    }
    
    void default_destroyAllTextureTargets(  ) {
        CEGUI::OpenGLRendererBase::destroyAllTextureTargets( );
    }

    virtual void destroyAllTextures(  ) {
        if( bp::override func_destroyAllTextures = this->get_override( "destroyAllTextures" ) )
            func_destroyAllTextures(  );
        else{
            this->CEGUI::OpenGLRendererBase::destroyAllTextures(  );
        }
    }
    
    void default_destroyAllTextures(  ) {
        CEGUI::OpenGLRendererBase::destroyAllTextures( );
    }

    virtual void destroyGeometryBuffer( ::CEGUI::GeometryBuffer const & buffer ) {
        if( bp::override func_destroyGeometryBuffer = this->get_override( "destroyGeometryBuffer" ) )
            func_destroyGeometryBuffer( boost::ref(buffer) );
        else{
            this->CEGUI::OpenGLRendererBase::destroyGeometryBuffer( boost::ref(buffer) );
        }
    }
    
    void default_destroyGeometryBuffer( ::CEGUI::GeometryBuffer const & buffer ) {
        CEGUI::OpenGLRendererBase::destroyGeometryBuffer( boost::ref(buffer) );
    }

    virtual void destroyTexture( ::CEGUI::Texture & texture ) {
        if( bp::override func_destroyTexture = this->get_override( "destroyTexture" ) )
            func_destroyTexture( boost::ref(texture) );
        else{
            this->CEGUI::OpenGLRendererBase::destroyTexture( boost::ref(texture) );
        }
    }
    
    void default_destroyTexture( ::CEGUI::Texture & texture ) {
        CEGUI::OpenGLRendererBase::destroyTexture( boost::ref(texture) );
    }

    virtual void destroyTexture( ::CEGUI::String const & name ) {
        if( bp::override func_destroyTexture = this->get_override( "destroyTexture" ) )
            func_destroyTexture( boost::ref(name) );
        else{
            this->CEGUI::OpenGLRendererBase::destroyTexture( boost::ref(name) );
        }
    }
    
    void default_destroyTexture( ::CEGUI::String const & name ) {
        CEGUI::OpenGLRendererBase::destroyTexture( boost::ref(name) );
    }

    virtual void destroyTextureTarget( ::CEGUI::TextureTarget * target ) {
        if( bp::override func_destroyTextureTarget = this->get_override( "destroyTextureTarget" ) )
            func_destroyTextureTarget( boost::python::ptr(target) );
        else{
            this->CEGUI::OpenGLRendererBase::destroyTextureTarget( boost::python::ptr(target) );
        }
    }
    
    void default_destroyTextureTarget( ::CEGUI::TextureTarget * target ) {
        CEGUI::OpenGLRendererBase::destroyTextureTarget( boost::python::ptr(target) );
    }

    virtual ::CEGUI::Sizef getAdjustedTextureSize( ::CEGUI::Sizef const & sz ) const  {
        if( bp::override func_getAdjustedTextureSize = this->get_override( "getAdjustedTextureSize" ) )
            return func_getAdjustedTextureSize( boost::ref(sz) );
        else{
            return this->CEGUI::OpenGLRendererBase::getAdjustedTextureSize( boost::ref(sz) );
        }
    }
    
    ::CEGUI::Sizef default_getAdjustedTextureSize( ::CEGUI::Sizef const & sz ) const  {
        return CEGUI::OpenGLRendererBase::getAdjustedTextureSize( boost::ref(sz) );
    }

    virtual ::CEGUI::uint getMaxTextureSize(  ) const  {
        if( bp::override func_getMaxTextureSize = this->get_override( "getMaxTextureSize" ) )
            return func_getMaxTextureSize(  );
        else{
            return this->CEGUI::OpenGLRendererBase::getMaxTextureSize(  );
        }
    }
    
    ::CEGUI::uint default_getMaxTextureSize(  ) const  {
        return CEGUI::OpenGLRendererBase::getMaxTextureSize( );
    }

    void initialiseDisplaySizeWithViewportSize(  ){
        CEGUI::OpenGLRendererBase::initialiseDisplaySizeWithViewportSize(  );
    }

    void initialiseMaxTextureSize(  ){
        CEGUI::OpenGLRendererBase::initialiseMaxTextureSize(  );
    }

    virtual bool isTextureDefined( ::CEGUI::String const & name ) const  {
        if( bp::override func_isTextureDefined = this->get_override( "isTextureDefined" ) )
            return func_isTextureDefined( boost::ref(name) );
        else{
            return this->CEGUI::OpenGLRendererBase::isTextureDefined( boost::ref(name) );
        }
    }
    
    bool default_isTextureDefined( ::CEGUI::String const & name ) const  {
        return CEGUI::OpenGLRendererBase::isTextureDefined( boost::ref(name) );
    }

    static void logTextureCreation( ::CEGUI::String const & name ){
        CEGUI::OpenGLRendererBase::logTextureCreation( boost::ref(name) );
    }

    static void logTextureDestruction( ::CEGUI::String const & name ){
        CEGUI::OpenGLRendererBase::logTextureDestruction( boost::ref(name) );
    }

    virtual void setDisplaySize( ::CEGUI::Sizef const & sz ) {
        if( bp::override func_setDisplaySize = this->get_override( "setDisplaySize" ) )
            func_setDisplaySize( boost::ref(sz) );
        else{
            this->CEGUI::OpenGLRendererBase::setDisplaySize( boost::ref(sz) );
        }
    }
    
    void default_setDisplaySize( ::CEGUI::Sizef const & sz ) {
        CEGUI::OpenGLRendererBase::setDisplaySize( boost::ref(sz) );
    }

};

void register_OpenGLRenderer_class(){

    { //::CEGUI::OpenGLRenderer
        typedef bp::class_< OpenGLRenderer_wrapper, bp::bases< CEGUI::OpenGLRendererBase >, boost::noncopyable > OpenGLRenderer_exposer_t;
        OpenGLRenderer_exposer_t OpenGLRenderer_exposer = OpenGLRenderer_exposer_t( "OpenGLRenderer", "*!\n\
        \n\
            Renderer class to interface with OpenGL\n\
        *\n", bp::no_init );
        bp::scope OpenGLRenderer_scope( OpenGLRenderer_exposer );
        bp::enum_< CEGUI::OpenGLRenderer::TextureTargetType>("TextureTargetType")
            .value("TextureTargetType::AUTO", CEGUI::OpenGLRenderer::TextureTargetType::AUTO)
            .value("TextureTargetType::FBO", CEGUI::OpenGLRenderer::TextureTargetType::FBO)
            .value("TextureTargetType::PBUFFER", CEGUI::OpenGLRenderer::TextureTargetType::PBUFFER)
            .value("TextureTargetType::NONE", CEGUI::OpenGLRenderer::TextureTargetType::NONE)
            .export_values()
            ;
        OpenGLRenderer_exposer.def( bp::init< CEGUI::OpenGLRenderer::TextureTargetType >(( bp::arg("tt_type") ), "*!\n\
            \n\
                Constructor for OpenGL Renderer objects\n\
        \n\
            @param tt_type\n\
                Specifies one of the TextureTargetType enumerated values indicating the\n\
                desired TextureTarget type to be used.\n\
            *\n") );
        OpenGLRenderer_exposer.def( bp::init< CEGUI::Sizef const &, CEGUI::OpenGLRenderer::TextureTargetType >(( bp::arg("display_size"), bp::arg("tt_type") ), "*!\n\
            \n\
                Constructor for OpenGL Renderer objects.\n\
        \n\
            @param display_size\n\
                Size object describing the initial display resolution.\n\
        \n\
            @param tt_type\n\
                Specifies one of the TextureTargetType enumerated values indicating the\n\
                desired TextureTarget type to be used.\n\
            *\n") );
        { //::CEGUI::OpenGLRenderer::beginRendering
        
            typedef void ( ::CEGUI::OpenGLRenderer::*beginRendering_function_type )(  ) ;
            typedef void ( OpenGLRenderer_wrapper::*default_beginRendering_function_type )(  ) ;
            
            OpenGLRenderer_exposer.def( 
                "beginRendering"
                , beginRendering_function_type(&::CEGUI::OpenGLRenderer::beginRendering)
                , default_beginRendering_function_type(&OpenGLRenderer_wrapper::default_beginRendering) );
        
        }
        { //::CEGUI::OpenGLRenderer::bootstrapSystem
        
            typedef ::CEGUI::OpenGLRenderer & ( *bootstrapSystem_function_type )( ::CEGUI::OpenGLRenderer::TextureTargetType const,int const );
            
            OpenGLRenderer_exposer.def( 
                "bootstrapSystem"
                , bootstrapSystem_function_type( &::CEGUI::OpenGLRenderer::bootstrapSystem )
                , ( bp::arg("tt_type")=::CEGUI::OpenGLRenderer::TextureTargetType::AUTO, bp::arg("abi")=(int const)(208) )
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::OpenGLRenderer::bootstrapSystem
        
            typedef ::CEGUI::OpenGLRenderer & ( *bootstrapSystem_function_type )( ::CEGUI::Sizef const &,::CEGUI::OpenGLRenderer::TextureTargetType const,int const );
            
            OpenGLRenderer_exposer.def( 
                "bootstrapSystem"
                , bootstrapSystem_function_type( &::CEGUI::OpenGLRenderer::bootstrapSystem )
                , ( bp::arg("display_size"), bp::arg("tt_type")=::CEGUI::OpenGLRenderer::TextureTargetType::AUTO, bp::arg("abi")=(int const)(208) )
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::OpenGLRenderer::cleanupExtraStates
        
            typedef void ( OpenGLRenderer_wrapper::*cleanupExtraStates_function_type )(  ) ;
            
            OpenGLRenderer_exposer.def( 
                "cleanupExtraStates"
                , cleanupExtraStates_function_type( &OpenGLRenderer_wrapper::cleanupExtraStates )
                , "! cleanup the extra GL states enabled via enableExtraStateSettings\n" );
        
        }
        { //::CEGUI::OpenGLRenderer::create
        
            typedef ::CEGUI::OpenGLRenderer & ( *create_function_type )( ::CEGUI::OpenGLRenderer::TextureTargetType const,int const );
            
            OpenGLRenderer_exposer.def( 
                "create"
                , create_function_type( &::CEGUI::OpenGLRenderer::create )
                , ( bp::arg("tt_type")=::CEGUI::OpenGLRenderer::TextureTargetType::AUTO, bp::arg("abi")=(int const)(208) )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    Create an OpenGLRenderer object.\n\
            \n\
                @param tt_type\n\
                    Specifies one of the TextureTargetType enumerated values indicating the\n\
                    desired TextureTarget type to be used.\n\
            \n\
                @param abi\n\
                    This must be set to CEGUI_VERSION_ABI\n\
                *\n" );
        
        }
        { //::CEGUI::OpenGLRenderer::create
        
            typedef ::CEGUI::OpenGLRenderer & ( *create_function_type )( ::CEGUI::Sizef const &,::CEGUI::OpenGLRenderer::TextureTargetType const,int const );
            
            OpenGLRenderer_exposer.def( 
                "create"
                , create_function_type( &::CEGUI::OpenGLRenderer::create )
                , ( bp::arg("display_size"), bp::arg("tt_type")=::CEGUI::OpenGLRenderer::TextureTargetType::AUTO, bp::arg("abi")=(int const)(208) )
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::OpenGLRenderer::createGeometryBuffer_impl
        
            typedef ::CEGUI::OpenGLGeometryBufferBase * ( OpenGLRenderer_wrapper::*createGeometryBuffer_impl_function_type )(  ) ;
            
            OpenGLRenderer_exposer.def( 
                "createGeometryBuffer_impl"
                , createGeometryBuffer_impl_function_type( &OpenGLRenderer_wrapper::default_createGeometryBuffer_impl )
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::OpenGLRenderer::createTextureTarget_impl
        
            typedef ::CEGUI::TextureTarget * ( OpenGLRenderer_wrapper::*createTextureTarget_impl_function_type )(  ) ;
            
            OpenGLRenderer_exposer.def( 
                "createTextureTarget_impl"
                , createTextureTarget_impl_function_type( &OpenGLRenderer_wrapper::default_createTextureTarget_impl )
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::OpenGLRenderer::destroy
        
            typedef void ( *destroy_function_type )( ::CEGUI::OpenGLRenderer & );
            
            OpenGLRenderer_exposer.def( 
                "destroy"
                , destroy_function_type( &::CEGUI::OpenGLRenderer::destroy )
                , ( bp::arg("renderer") )
                , "*!\n\
                \n\
                    Destroy an OpenGLRenderer object.\n\
            \n\
                @param renderer\n\
                    The OpenGLRenderer object to be destroyed.\n\
                *\n" );
        
        }
        { //::CEGUI::OpenGLRenderer::destroySystem
        
            typedef void ( *destroySystem_function_type )(  );
            
            OpenGLRenderer_exposer.def( 
                "destroySystem"
                , destroySystem_function_type( &::CEGUI::OpenGLRenderer::destroySystem )
                , "*!\n\
                \n\
                    Convenience function to cleanup the CEGUI system and related objects\n\
                    that were created by calling the bootstrapSystem function.\n\
            \n\
                    This function will destroy the following objects for you:\n\
                    - CEGUI.System\n\
                    - CEGUI.DefaultResourceProvider\n\
                    - CEGUI.OpenGLRenderer\n\
            \n\
                \note\n\
                    If you did not initialise CEGUI by calling the bootstrapSystem function,\n\
                    you should  e not call this, but rather delete any objects you created\n\
                    manually.\n\
                *\n" );
        
        }
        { //::CEGUI::OpenGLRenderer::endRendering
        
            typedef void ( ::CEGUI::OpenGLRenderer::*endRendering_function_type )(  ) ;
            typedef void ( OpenGLRenderer_wrapper::*default_endRendering_function_type )(  ) ;
            
            OpenGLRenderer_exposer.def( 
                "endRendering"
                , endRendering_function_type(&::CEGUI::OpenGLRenderer::endRendering)
                , default_endRendering_function_type(&OpenGLRenderer_wrapper::default_endRendering) );
        
        }
        { //::CEGUI::OpenGLRenderer::initialiseGLExtensions
        
            typedef void ( OpenGLRenderer_wrapper::*initialiseGLExtensions_function_type )(  ) ;
            
            OpenGLRenderer_exposer.def( 
                "initialiseGLExtensions"
                , initialiseGLExtensions_function_type( &OpenGLRenderer_wrapper::initialiseGLExtensions ) );
        
        }
        { //::CEGUI::OpenGLRenderer::initialiseRendererIDString
        
            typedef void ( OpenGLRenderer_wrapper::*initialiseRendererIDString_function_type )(  ) ;
            
            OpenGLRenderer_exposer.def( 
                "initialiseRendererIDString"
                , initialiseRendererIDString_function_type( &OpenGLRenderer_wrapper::initialiseRendererIDString )
                , "! set up renderer id string.\n" );
        
        }
        { //::CEGUI::OpenGLRenderer::initialiseTextureTargetFactory
        
            typedef void ( OpenGLRenderer_wrapper::*initialiseTextureTargetFactory_function_type )( ::CEGUI::OpenGLRenderer::TextureTargetType const ) ;
            
            OpenGLRenderer_exposer.def( 
                "initialiseTextureTargetFactory"
                , initialiseTextureTargetFactory_function_type( &OpenGLRenderer_wrapper::initialiseTextureTargetFactory )
                , ( bp::arg("tt_type") )
                , "! initialise OGLTextureTargetFactory that will generate TextureTargets\n" );
        
        }
        { //::CEGUI::OpenGLRenderer::isS3TCSupported
        
            typedef bool ( ::CEGUI::OpenGLRenderer::*isS3TCSupported_function_type )(  ) const;
            typedef bool ( OpenGLRenderer_wrapper::*default_isS3TCSupported_function_type )(  ) const;
            
            OpenGLRenderer_exposer.def( 
                "isS3TCSupported"
                , isS3TCSupported_function_type(&::CEGUI::OpenGLRenderer::isS3TCSupported)
                , default_isS3TCSupported_function_type(&OpenGLRenderer_wrapper::default_isS3TCSupported) );
        
        }
        { //::CEGUI::OpenGLRenderer::setupExtraStates
        
            typedef void ( OpenGLRenderer_wrapper::*setupExtraStates_function_type )(  ) ;
            
            OpenGLRenderer_exposer.def( 
                "setupExtraStates"
                , setupExtraStates_function_type( &OpenGLRenderer_wrapper::setupExtraStates )
                , "! init the extra GL states enabled via enableExtraStateSettings\n" );
        
        }
        { //::CEGUI::OpenGLRenderer::setupRenderingBlendMode
        
            typedef void ( ::CEGUI::OpenGLRenderer::*setupRenderingBlendMode_function_type )( ::CEGUI::BlendMode const,bool const ) ;
            typedef void ( OpenGLRenderer_wrapper::*default_setupRenderingBlendMode_function_type )( ::CEGUI::BlendMode const,bool const ) ;
            
            OpenGLRenderer_exposer.def( 
                "setupRenderingBlendMode"
                , setupRenderingBlendMode_function_type(&::CEGUI::OpenGLRenderer::setupRenderingBlendMode)
                , default_setupRenderingBlendMode_function_type(&OpenGLRenderer_wrapper::default_setupRenderingBlendMode)
                , ( bp::arg("mode"), bp::arg("force")=(bool const)(false) ) );
        
        }
        { //::CEGUI::OpenGLRendererBase::createGeometryBuffer
        
            typedef ::CEGUI::GeometryBuffer & ( ::CEGUI::OpenGLRendererBase::*createGeometryBuffer_function_type )(  ) ;
            
            OpenGLRenderer_exposer.def( 
                "createGeometryBuffer"
                , createGeometryBuffer_function_type(&::CEGUI::OpenGLRendererBase::createGeometryBuffer)
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::OpenGLRendererBase::createTexture
        
            typedef ::CEGUI::Texture & ( ::CEGUI::OpenGLRendererBase::*createTexture_function_type )( ::CEGUI::String const & ) ;
            
            OpenGLRenderer_exposer.def( 
                "createTexture"
                , createTexture_function_type(&::CEGUI::OpenGLRendererBase::createTexture)
                , ( bp::arg("name") )
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::OpenGLRendererBase::createTexture
        
            typedef ::CEGUI::Texture & ( ::CEGUI::OpenGLRendererBase::*createTexture_function_type )( ::CEGUI::String const &,::CEGUI::String const &,::CEGUI::String const & ) ;
            
            OpenGLRenderer_exposer.def( 
                "createTexture"
                , createTexture_function_type(&::CEGUI::OpenGLRendererBase::createTexture)
                , ( bp::arg("name"), bp::arg("filename"), bp::arg("resourceGroup") )
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::OpenGLRendererBase::createTexture
        
            typedef ::CEGUI::Texture & ( ::CEGUI::OpenGLRendererBase::*createTexture_function_type )( ::CEGUI::String const &,::CEGUI::Sizef const & ) ;
            
            OpenGLRenderer_exposer.def( 
                "createTexture"
                , createTexture_function_type(&::CEGUI::OpenGLRendererBase::createTexture)
                , ( bp::arg("name"), bp::arg("size") )
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::OpenGLRendererBase::createTexture
        
            typedef ::CEGUI::Texture & ( ::CEGUI::OpenGLRendererBase::*createTexture_function_type )( ::CEGUI::String const &,::GLuint,::CEGUI::Sizef const & ) ;
            
            OpenGLRenderer_exposer.def( 
                "createTexture"
                , createTexture_function_type( &::CEGUI::OpenGLRendererBase::createTexture )
                , ( bp::arg("name"), bp::arg("tex"), bp::arg("sz") )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    Create a texture that uses an existing OpenGL texture with the specified\n\
                    size.  Note that it is your responsibility to ensure that the OpenGL\n\
                    texture is valid and that the specified size is accurate.\n\
            \n\
                @param sz\n\
                    Size object that describes the pixel size of the OpenGL texture\n\
                    identified by  tex.\n\
            \n\
                @param name\n\
                    String holding the name for the new texture.  Texture names must be\n\
                    unique within the Renderer.\n\
            \n\
                @return\n\
                    Texture object that wraps the OpenGL texture  tex, and whose size is\n\
                    specified to be  sz.\n\
            \n\
                @exceptions\n\
                    - AlreadyExistsException - thrown if a Texture object named  name\n\
                      already exists within the system.\n\
                *\n" );
        
        }
        { //::CEGUI::OpenGLRendererBase::createTextureTarget
        
            typedef ::CEGUI::TextureTarget * ( ::CEGUI::OpenGLRendererBase::*createTextureTarget_function_type )(  ) ;
            typedef ::CEGUI::TextureTarget * ( OpenGLRenderer_wrapper::*default_createTextureTarget_function_type )(  ) ;
            
            OpenGLRenderer_exposer.def( 
                "createTextureTarget"
                , createTextureTarget_function_type(&::CEGUI::OpenGLRendererBase::createTextureTarget)
                , default_createTextureTarget_function_type(&OpenGLRenderer_wrapper::default_createTextureTarget)
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::OpenGLRendererBase::destroyAllGeometryBuffers
        
            typedef void ( ::CEGUI::OpenGLRendererBase::*destroyAllGeometryBuffers_function_type )(  ) ;
            typedef void ( OpenGLRenderer_wrapper::*default_destroyAllGeometryBuffers_function_type )(  ) ;
            
            OpenGLRenderer_exposer.def( 
                "destroyAllGeometryBuffers"
                , destroyAllGeometryBuffers_function_type(&::CEGUI::OpenGLRendererBase::destroyAllGeometryBuffers)
                , default_destroyAllGeometryBuffers_function_type(&OpenGLRenderer_wrapper::default_destroyAllGeometryBuffers) );
        
        }
        { //::CEGUI::OpenGLRendererBase::destroyAllTextureTargets
        
            typedef void ( ::CEGUI::OpenGLRendererBase::*destroyAllTextureTargets_function_type )(  ) ;
            typedef void ( OpenGLRenderer_wrapper::*default_destroyAllTextureTargets_function_type )(  ) ;
            
            OpenGLRenderer_exposer.def( 
                "destroyAllTextureTargets"
                , destroyAllTextureTargets_function_type(&::CEGUI::OpenGLRendererBase::destroyAllTextureTargets)
                , default_destroyAllTextureTargets_function_type(&OpenGLRenderer_wrapper::default_destroyAllTextureTargets) );
        
        }
        { //::CEGUI::OpenGLRendererBase::destroyAllTextures
        
            typedef void ( ::CEGUI::OpenGLRendererBase::*destroyAllTextures_function_type )(  ) ;
            typedef void ( OpenGLRenderer_wrapper::*default_destroyAllTextures_function_type )(  ) ;
            
            OpenGLRenderer_exposer.def( 
                "destroyAllTextures"
                , destroyAllTextures_function_type(&::CEGUI::OpenGLRendererBase::destroyAllTextures)
                , default_destroyAllTextures_function_type(&OpenGLRenderer_wrapper::default_destroyAllTextures) );
        
        }
        { //::CEGUI::OpenGLRendererBase::destroyGeometryBuffer
        
            typedef void ( ::CEGUI::OpenGLRendererBase::*destroyGeometryBuffer_function_type )( ::CEGUI::GeometryBuffer const & ) ;
            typedef void ( OpenGLRenderer_wrapper::*default_destroyGeometryBuffer_function_type )( ::CEGUI::GeometryBuffer const & ) ;
            
            OpenGLRenderer_exposer.def( 
                "destroyGeometryBuffer"
                , destroyGeometryBuffer_function_type(&::CEGUI::OpenGLRendererBase::destroyGeometryBuffer)
                , default_destroyGeometryBuffer_function_type(&OpenGLRenderer_wrapper::default_destroyGeometryBuffer)
                , ( bp::arg("buffer") ) );
        
        }
        { //::CEGUI::OpenGLRendererBase::destroyTexture
        
            typedef void ( ::CEGUI::OpenGLRendererBase::*destroyTexture_function_type )( ::CEGUI::Texture & ) ;
            typedef void ( OpenGLRenderer_wrapper::*default_destroyTexture_function_type )( ::CEGUI::Texture & ) ;
            
            OpenGLRenderer_exposer.def( 
                "destroyTexture"
                , destroyTexture_function_type(&::CEGUI::OpenGLRendererBase::destroyTexture)
                , default_destroyTexture_function_type(&OpenGLRenderer_wrapper::default_destroyTexture)
                , ( bp::arg("texture") ) );
        
        }
        { //::CEGUI::OpenGLRendererBase::destroyTexture
        
            typedef void ( ::CEGUI::OpenGLRendererBase::*destroyTexture_function_type )( ::CEGUI::String const & ) ;
            typedef void ( OpenGLRenderer_wrapper::*default_destroyTexture_function_type )( ::CEGUI::String const & ) ;
            
            OpenGLRenderer_exposer.def( 
                "destroyTexture"
                , destroyTexture_function_type(&::CEGUI::OpenGLRendererBase::destroyTexture)
                , default_destroyTexture_function_type(&OpenGLRenderer_wrapper::default_destroyTexture)
                , ( bp::arg("name") ) );
        
        }
        { //::CEGUI::OpenGLRendererBase::destroyTextureTarget
        
            typedef void ( ::CEGUI::OpenGLRendererBase::*destroyTextureTarget_function_type )( ::CEGUI::TextureTarget * ) ;
            typedef void ( OpenGLRenderer_wrapper::*default_destroyTextureTarget_function_type )( ::CEGUI::TextureTarget * ) ;
            
            OpenGLRenderer_exposer.def( 
                "destroyTextureTarget"
                , destroyTextureTarget_function_type(&::CEGUI::OpenGLRendererBase::destroyTextureTarget)
                , default_destroyTextureTarget_function_type(&OpenGLRenderer_wrapper::default_destroyTextureTarget)
                , ( bp::arg("target") ) );
        
        }
        { //::CEGUI::OpenGLRendererBase::getAdjustedTextureSize
        
            typedef ::CEGUI::Sizef ( ::CEGUI::OpenGLRendererBase::*getAdjustedTextureSize_function_type )( ::CEGUI::Sizef const & ) const;
            typedef ::CEGUI::Sizef ( OpenGLRenderer_wrapper::*default_getAdjustedTextureSize_function_type )( ::CEGUI::Sizef const & ) const;
            
            OpenGLRenderer_exposer.def( 
                "getAdjustedTextureSize"
                , getAdjustedTextureSize_function_type(&::CEGUI::OpenGLRendererBase::getAdjustedTextureSize)
                , default_getAdjustedTextureSize_function_type(&OpenGLRenderer_wrapper::default_getAdjustedTextureSize)
                , ( bp::arg("sz") ) );
        
        }
        { //::CEGUI::OpenGLRendererBase::getDefaultRenderTarget
        
            typedef ::CEGUI::RenderTarget & ( ::CEGUI::OpenGLRendererBase::*getDefaultRenderTarget_function_type )(  ) ;
            
            OpenGLRenderer_exposer.def( 
                "getDefaultRenderTarget"
                , getDefaultRenderTarget_function_type(&::CEGUI::OpenGLRendererBase::getDefaultRenderTarget)
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::OpenGLRendererBase::getDisplayDPI
        
            typedef ::CEGUI::Vector2f const & ( ::CEGUI::OpenGLRendererBase::*getDisplayDPI_function_type )(  ) const;
            
            OpenGLRenderer_exposer.def( 
                "getDisplayDPI"
                , getDisplayDPI_function_type(&::CEGUI::OpenGLRendererBase::getDisplayDPI)
                , bp::return_value_policy< bp::copy_const_reference >() );
        
        }
        { //::CEGUI::OpenGLRendererBase::getDisplaySize
        
            typedef ::CEGUI::Sizef const & ( ::CEGUI::OpenGLRendererBase::*getDisplaySize_function_type )(  ) const;
            
            OpenGLRenderer_exposer.def( 
                "getDisplaySize"
                , getDisplaySize_function_type(&::CEGUI::OpenGLRendererBase::getDisplaySize)
                , bp::return_value_policy< bp::copy_const_reference >() );
        
        }
        { //::CEGUI::OpenGLRendererBase::getIdentifierString
        
            typedef ::CEGUI::String const & ( ::CEGUI::OpenGLRendererBase::*getIdentifierString_function_type )(  ) const;
            
            OpenGLRenderer_exposer.def( 
                "getIdentifierString"
                , getIdentifierString_function_type(&::CEGUI::OpenGLRendererBase::getIdentifierString)
                , bp::return_value_policy< bp::copy_const_reference >() );
        
        }
        { //::CEGUI::OpenGLRendererBase::getMaxTextureSize
        
            typedef ::CEGUI::uint ( ::CEGUI::OpenGLRendererBase::*getMaxTextureSize_function_type )(  ) const;
            typedef ::CEGUI::uint ( OpenGLRenderer_wrapper::*default_getMaxTextureSize_function_type )(  ) const;
            
            OpenGLRenderer_exposer.def( 
                "getMaxTextureSize"
                , getMaxTextureSize_function_type(&::CEGUI::OpenGLRendererBase::getMaxTextureSize)
                , default_getMaxTextureSize_function_type(&OpenGLRenderer_wrapper::default_getMaxTextureSize) );
        
        }
        { //::CEGUI::OpenGLRendererBase::getTexture
        
            typedef ::CEGUI::Texture & ( ::CEGUI::OpenGLRendererBase::*getTexture_function_type )( ::CEGUI::String const & ) const;
            
            OpenGLRenderer_exposer.def( 
                "getTexture"
                , getTexture_function_type(&::CEGUI::OpenGLRendererBase::getTexture)
                , ( bp::arg("name") )
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::OpenGLRendererBase::initialiseDisplaySizeWithViewportSize
        
            typedef void ( OpenGLRenderer_wrapper::*initialiseDisplaySizeWithViewportSize_function_type )(  ) ;
            
            OpenGLRenderer_exposer.def( 
                "initialiseDisplaySizeWithViewportSize"
                , initialiseDisplaySizeWithViewportSize_function_type( &OpenGLRenderer_wrapper::initialiseDisplaySizeWithViewportSize )
                , "! helper to set display size with current viewport size.\n" );
        
        }
        { //::CEGUI::OpenGLRendererBase::initialiseMaxTextureSize
        
            typedef void ( OpenGLRenderer_wrapper::*initialiseMaxTextureSize_function_type )(  ) ;
            
            OpenGLRenderer_exposer.def( 
                "initialiseMaxTextureSize"
                , initialiseMaxTextureSize_function_type( &OpenGLRenderer_wrapper::initialiseMaxTextureSize )
                , "! helper to set (rough) max texture size.\n" );
        
        }
        { //::CEGUI::OpenGLRendererBase::isTextureDefined
        
            typedef bool ( ::CEGUI::OpenGLRendererBase::*isTextureDefined_function_type )( ::CEGUI::String const & ) const;
            typedef bool ( OpenGLRenderer_wrapper::*default_isTextureDefined_function_type )( ::CEGUI::String const & ) const;
            
            OpenGLRenderer_exposer.def( 
                "isTextureDefined"
                , isTextureDefined_function_type(&::CEGUI::OpenGLRendererBase::isTextureDefined)
                , default_isTextureDefined_function_type(&OpenGLRenderer_wrapper::default_isTextureDefined)
                , ( bp::arg("name") ) );
        
        }
        { //::CEGUI::OpenGLRendererBase::logTextureCreation
        
            typedef void ( *logTextureCreation_function_type )( ::CEGUI::String const & );
            
            OpenGLRenderer_exposer.def( 
                "logTextureCreation"
                , logTextureCreation_function_type( &OpenGLRenderer_wrapper::logTextureCreation )
                , ( bp::arg("name") )
                , "! helper to safely log the creation of a named texture\n" );
        
        }
        { //::CEGUI::OpenGLRendererBase::logTextureDestruction
        
            typedef void ( *logTextureDestruction_function_type )( ::CEGUI::String const & );
            
            OpenGLRenderer_exposer.def( 
                "logTextureDestruction"
                , logTextureDestruction_function_type( &OpenGLRenderer_wrapper::logTextureDestruction )
                , ( bp::arg("name") )
                , "! helper to safely log the creation of a named texture\n\
            ! helper to safely log the destruction of a named texture\n" );
        
        }
        { //::CEGUI::OpenGLRendererBase::setDisplaySize
        
            typedef void ( ::CEGUI::OpenGLRendererBase::*setDisplaySize_function_type )( ::CEGUI::Sizef const & ) ;
            typedef void ( OpenGLRenderer_wrapper::*default_setDisplaySize_function_type )( ::CEGUI::Sizef const & ) ;
            
            OpenGLRenderer_exposer.def( 
                "setDisplaySize"
                , setDisplaySize_function_type(&::CEGUI::OpenGLRendererBase::setDisplaySize)
                , default_setDisplaySize_function_type(&OpenGLRenderer_wrapper::default_setDisplaySize)
                , ( bp::arg("sz") ) );
        
        }
        OpenGLRenderer_exposer.staticmethod( "bootstrapSystem" );
        OpenGLRenderer_exposer.staticmethod( "create" );
        OpenGLRenderer_exposer.staticmethod( "destroy" );
        OpenGLRenderer_exposer.staticmethod( "destroySystem" );
        OpenGLRenderer_exposer.staticmethod( "logTextureCreation" );
        OpenGLRenderer_exposer.staticmethod( "logTextureDestruction" );
    }

}
