#include <stdint.h>
#include <util.h>
#include <drivers/video/vga/vga.h>
#include <stdio.h>
#include <timer.h>
#include "idt.h"
#include <kernel/kernel.h>

struct idt_entry_struct idt_entries[256];
struct idt_ptr_struct idt_ptr;

extern void idt_flush(uint32_t);
extern void syscall_int();

void idt_init()
{
	idt_ptr.limit = sizeof(struct idt_entry_struct) * 256 - 1;
	idt_ptr.base = (uint32_t) &idt_entries;

	__memset(&idt_entries, 0, sizeof(struct idt_entry_struct) * 256);

	//0x20 commands and 0x21 data
	//0xA0 commands and 0xA1 data
	outPortB(0x20, 0x11);
	outPortB(0xA0, 0x11);

	outPortB(0x21, 0x20);
	outPortB(0xA1, 0x28);

	outPortB(0x21,0x04);
	outPortB(0xA1,0x02);

	outPortB(0x21, 0x01);
	outPortB(0xA1, 0x01);

	outPortB(0x21, 0x0);
	outPortB(0xA1, 0x0);

	setIdtGate(0, (uint32_t)isr0,0x08, 0x8E);
	setIdtGate(1, (uint32_t)isr1,0x08, 0x8E);
	setIdtGate(2, (uint32_t)isr2,0x08, 0x8E);
	setIdtGate(3, (uint32_t)isr3,0x08, 0x8E);
	setIdtGate(4, (uint32_t)isr4, 0x08, 0x8E);
	setIdtGate(5, (uint32_t)isr5, 0x08, 0x8E);
	setIdtGate(6, (uint32_t)isr6, 0x08, 0x8E);
	setIdtGate(7, (uint32_t)isr7, 0x08, 0x8E);
	setIdtGate(8, (uint32_t)isr8, 0x08, 0x8E);
	setIdtGate(9, (uint32_t)isr9, 0x08, 0x8E);
	setIdtGate(10, (uint32_t)isr10, 0x08, 0x8E);
	setIdtGate(11, (uint32_t)isr11, 0x08, 0x8E);
	setIdtGate(12, (uint32_t)isr12, 0x08, 0x8E);
	setIdtGate(13, (uint32_t)isr13, 0x08, 0x8E);
	setIdtGate(14, (uint32_t)isr14, 0x08, 0x8E);
	setIdtGate(15, (uint32_t)isr15, 0x08, 0x8E);
	setIdtGate(16, (uint32_t)isr16, 0x08, 0x8E);
	setIdtGate(17, (uint32_t)isr17, 0x08, 0x8E);
	setIdtGate(18, (uint32_t)isr18, 0x08, 0x8E);
	setIdtGate(19, (uint32_t)isr19, 0x08, 0x8E);
	setIdtGate(20, (uint32_t)isr20, 0x08, 0x8E);
	setIdtGate(21, (uint32_t)isr21, 0x08, 0x8E);
	setIdtGate(22, (uint32_t)isr22, 0x08, 0x8E);
	setIdtGate(23, (uint32_t)isr23, 0x08, 0x8E);
	setIdtGate(24, (uint32_t)isr24, 0x08, 0x8E);
	setIdtGate(25, (uint32_t)isr25, 0x08, 0x8E);
	setIdtGate(26, (uint32_t)isr26, 0x08, 0x8E);
	setIdtGate(27, (uint32_t)isr27, 0x08, 0x8E);
	setIdtGate(28, (uint32_t)isr28, 0x08, 0x8E);
	setIdtGate(29, (uint32_t)isr29, 0x08, 0x8E);
	setIdtGate(30, (uint32_t)isr30, 0x08, 0x8E);
	setIdtGate(31, (uint32_t)isr31, 0x08, 0x8E);

	setIdtGate(32, (uint32_t)irq0, 0x08, 0x8E);
	setIdtGate(33, (uint32_t)irq1, 0x08, 0x8E);
	setIdtGate(34, (uint32_t)irq2, 0x08, 0x8E);
	setIdtGate(35, (uint32_t)irq3, 0x08, 0x8E);
	setIdtGate(36, (uint32_t)irq4, 0x08, 0x8E);
	setIdtGate(37, (uint32_t)irq5, 0x08, 0x8E);
	setIdtGate(38, (uint32_t)irq6, 0x08, 0x8E);
	setIdtGate(39, (uint32_t)irq7, 0x08, 0x8E);
	setIdtGate(40, (uint32_t)irq8, 0x08, 0x8E);
	setIdtGate(41, (uint32_t)irq9, 0x08, 0x8E);
	setIdtGate(42, (uint32_t)irq10, 0x08, 0x8E);
	setIdtGate(43, (uint32_t)irq11, 0x08, 0x8E);
	setIdtGate(44, (uint32_t)irq12, 0x08, 0x8E);
	setIdtGate(45, (uint32_t)irq13, 0x08, 0x8E);
	setIdtGate(46, (uint32_t)irq14, 0x08, 0x8E);
	setIdtGate(47, (uint32_t)irq15, 0x08, 0x8E);


	setIdtGate(128, (uint32_t)isr128, 0x08, 0x8E); //system calls (0x80)
	setIdtGate(177, (uint32_t)isr177, 0x08, 0x8E); //system calls (0xB1)

	idt_flush((uint32_t)&idt_ptr);
	__printf("[idt] OK\n");
}

void setIdtGate(uint8_t num, uint32_t base, uint16_t sel, uint8_t flags)
{
	idt_entries[num].base_low = base & 0xFFFF;
	idt_entries[num].base_high = (base >> 16) & 0xFFFF;
	idt_entries[num].sel = sel;
	idt_entries[num].always0 = 0;
	idt_entries[num].flags = flags | 0x60;
}


char* exception_messages[] = {
	"division by zero ",
	"debug",
	"non maskable interrupt ",
	"breakpoint ",
	"into detected overflow ",
	"out of bounds ",
	"invalid opcode ",
	"no coprocessor ",
	"double fault ",
	"coprocessor segment overrun ",
	"bad tss ",
	"segment not present ",
	"stack fault ",
	"general protection fault ",
	"page fault ",
	"unknown interrupt ",
	"coprocessor fault ",
	"alignment fault ",
	"machine check ",
	"reserved ):",
	"reserved ):",
	"reserved ):",
	"reserved ):",
	"reserved ):",
	"reserved ):",
	"reserved ):",
	"reserved ):",
	"reserved ):",
	"reserved ):",
	"reserved ):",
	"reserved ):",
	"reserved ):"
};

void page_fault_handler(struct InterruptRegisters* regs)
{
	uint32_t faulting_address;
	asm volatile("mov %%cr2, %0" : "=r"(faulting_address));
	__printf("page fault at address: %p\n", (void*)faulting_address);
	for(;;);
}

void isr_handler(struct InterruptRegisters* regs)
{
        if (regs->int_no == 14) {
		__printf("error code/type: %s\n", exception_messages[regs->int_no]);
                page_fault_handler(regs);
                dump_registers();
	} else if (regs->int_no < 32) {
		__printf("error code/type: %s\n", exception_messages[regs->int_no]);
		dump_registers();
		asm("cli\n hlt");
	}
}


void *irq_routines[16] = {
	0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0
};

void idt_install(int irq, void (*handler)(struct InterruptRegisters *r))
{
	irq_routines[irq] = handler;
}

void idt_uninstall(int irq)
{
	irq_routines[irq] = 0;
}

void irq_handler(struct InterruptRegisters* regs)
{
	void (*handler)(struct InterruptRegisters *regs);

	handler = irq_routines[regs->int_no - 32];

	if (handler) {
		handler(regs);
	}

	if (regs->int_no >= 40) {
		outPortB(0xA0, 0x20);
	}

	outPortB(0x20,0x20);
}
