---
relatedlinks: https://www.youtube.com/watch?v=pqV0Z1qwbkg
---

# How to contribute to LXD

% Include content from [../CONTRIBUTING.md](../CONTRIBUTING.md)
```{include} ../CONTRIBUTING.md
    :start-after: <!-- Include start contributing -->
    :end-before: <!-- Include end contributing -->
```

## Contribute to the code

Follow the steps below to set up your development environment to get started working on new features for LXD.

### Install LXD from source

To build the dependencies, follow the instructions in {ref}`installing_from_source`.

### Add your fork as a remote

After setting up your build environment, add your GitHub fork as a remote:

    git remote add myfork git@github.com:<your_username>/lxd.git
    git remote update

Then switch to it:

    git checkout myfork/main

### Build LXD

Finally, you should be able to run `make` inside the repository and build your fork of the project.

At this point, you most likely want to create a new branch for your changes on your fork:

```bash
git checkout -b [name_of_your_new_branch]
git push myfork [name_of_your_new_branch]
```

### Important notes for new LXD contributors

- Persistent data is stored in the `LXD_DIR` directory, which is generated by `lxd init`.
  The `LXD_DIR` defaults to `/var/lib/lxd`, or `/var/snap/lxd/common/lxd` for snap users.
- As you develop, you may want to change the `LXD_DIR` for your fork of LXD so as to avoid version conflicts.
- Binaries compiled from your source will be generated in the `$(go env GOPATH)/bin` directory by default.
   - You will need to explicitly invoke these binaries (not the global `lxd` you may have installed) when testing your changes.
   - You may choose to create an alias in your `~/.bashrc` to call these binaries with the appropriate flags more conveniently.
- If you have a `systemd` service configured to run the LXD daemon from a previous installation of LXD, you may want to disable it to avoid version conflicts.

## Contribute to the documentation

We want LXD to be as easy and straight-forward to use as possible.
Therefore, we aim to provide documentation that contains the information that users need to work with LXD, that covers all common use cases, and that answers typical questions.

You can contribute to the documentation in various different ways.
We appreciate your contributions!

Typical ways to contribute are:

- Add or update documentation for new features or feature improvements that you contribute to the code.
  We'll review the documentation update and merge it together with your code.
- Add or update documentation that clarifies any doubts you had when working with the product.
  Such contributions can be done through a pull request or through a post in the [Tutorials](https://discourse.ubuntu.com/c/lxd/tutorials/146) section on the forum.
  New tutorials will be considered for inclusion in the docs (through a link or by including the actual content).
- To request a fix to the documentation, open a documentation issue on [GitHub](https://github.com/canonical/lxd/issues).
  We'll evaluate the issue and update the documentation accordingly.
- Post a question or a suggestion on the [forum](https://discourse.ubuntu.com/c/lxd/126).
  We'll monitor the posts and, if needed, update the documentation accordingly.
- Ask questions or provide suggestions in the `#lxd` channel on [IRC](https://web.libera.chat/#lxd).
  Given the dynamic nature of IRC, we cannot guarantee answers or reactions to IRC posts, but we monitor the channel and try to improve our documentation based on the received feedback.

If images are added (`doc/images`), prioritize either SVG or PNG format and make sure to optimize PNG images for smaller size using a service like [TinyPNG](https://tinypng.com/) or similar.

% Include content from [README.md](README.md)
```{include} README.md
    :start-after: <!-- Include start docs -->
```

When you open a pull request, a preview of the documentation output is built automatically.
To see the output, view the details for the `docs/readthedocs.com:canonical-lxd` check on the pull request.

### Automatic documentation checks

GitHub runs automatic checks on the documentation to verify the spelling, the validity of links, correct formatting of the Markdown files, and the use of inclusive language.

You can (and should!) run these tests locally as well with the following commands:

- Check the spelling: `make doc-spellcheck` (or `make doc-spelling` to first build the documentation and then check it)
- Check the validity of links: `make doc-linkcheck`
- Check the Markdown formatting: `make doc-lint`
- Check for inclusive language: `make doc-woke`

### Document instructions (how-to guides)

LXD can be used with different clients, most importantly the command-line interface (CLI), the API, and the UI.
The documentation contains instructions for all of these.
Therefore, when adding or updating how-to guides, remember to update the documentation for all clients.

Information that is different for each client should be put on tabs:

`````
````{tabs}
```{group-tab} CLI
[...]
```
```{group-tab} API
[...]
```
```{group-tab} UI
[...]
```
````
`````

```{tip}
You might need to increase the number of backticks (`) if there are code blocks or other directives in the tab content.
```

Adhere to the following guidelines when adding instructions:

CLI instructions
: - Add a link to the command reference of the `lxc` command (syntax example: ``[`lxc init`](lxc_init.md)``).
  - You don't need to document all available flags of a command, but you should mention any that are especially relevant.
  - Examples are very helpful, so add a few if it makes sense.

API instructions
: - If possible, use [`lxc query`](lxc_query.md) to demonstrate the API calls.
    For more complicated calls, use curl or other widely available tools.
  - In the request data, include all fields that are required for the request to succeed.
    Keep it as simple as possible though - no need to include all available fields.
  - Add a link to the API call reference (syntax example: ``[`POST /1.0/instances`](swagger:/instances/instances_post)``).

UI instructions
: - You can include screenshots to illustrate the instructions, but use them sparingly.
    Screenshots are difficult to maintain and keep up-to-date.
  - When referring to labels in the UI, use the `{guilabel}` role.
    For example: ``To create an instance, go to the {guilabel}`Instances` section and click {guilabel}`Create instance`.``

### Document configuration options

The documentation of configuration options is extracted from comments in the Go code.
Look for comments that start with `lxdmeta:generate` in the code.

When you add or change a configuration option, make sure to include the required documentation comment for it.
See the [`lxd-metadata` README file](https://github.com/canonical/lxd/blob/main/lxd/lxd-metadata/README.md) for information about the format.

Then run `make generate-config` to re-generate the `doc/metadata.txt` file.
The updated file should be checked in.

The documentation includes sections from the `doc/metadata.txt` to display a group of configuration options.
For example, to include the core server options:

````
% Include content from [metadata.txt](metadata.txt)
```{include} metadata.txt
    :start-after: <!-- config group server-core start -->
    :end-before: <!-- config group server-core end -->
```
````

If you add a configuration option to an existing group, you don't need to do any updates to the documentation files.
The new option will automatically be picked up.
You only need to add an include to a documentation file if you are defining a new group.
