<?php
if(!defined('IN_CRONLITE'))exit();
?>
<!DOCTYPE html>
<html lang="zh-CN" class="no-js">
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?php echo $conf['title']?></title>
  <meta name="keywords" content="<?php echo $conf['keywords']?>" />
  <meta name="description" content="<?php echo $conf['description']?>" />
  <link rel="stylesheet" type="text/css" href="//cdn.staticfile.org/twitter-bootstrap/4.3.1/css/bootstrap.min.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo STATIC_ROOT?>css/magnific-popup.css">
  <link rel="stylesheet" type="text/css" href="<?php echo STATIC_ROOT?>css/owl.theme.css">
  <link rel="stylesheet" type="text/css" href="<?php echo STATIC_ROOT?>css/aos.css">
  <link rel="stylesheet" type="text/css" href="<?php echo STATIC_ROOT?>css/mobiriseicons.css">
  <link rel="stylesheet" type="text/css" href="//cdn.staticfile.org/MaterialDesign-Webfont/1.9.33/css/materialdesignicons.min.css"/>
  <link rel="stylesheet" type="text/css" href="<?php echo STATIC_ROOT?>css/as.css">
</head>
<body>
  <nav class="navbar navbar-expand-lg fixed-top custom_nav_menu sticky">
    <div class="container">
      <a class="navbar-brand logo" href=""><img class="header-logo-img" src="assets/img/logo.png" alt="<?php echo $conf['sitename']?>" /></a>
      <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbar-as"
      aria-controls="navbar-as" aria-expanded="false" aria-label="Toggle navigation">
        <i class="mdi mdi-menu"></i>
      </button>
      <div class="collapse navbar-collapse" id="navbar-as">
        <ul class="navbar-nav mr-auto">
          <li class="nav-item active">
            <a href="#home" class="nav-link">主页</a>
          </li>
          <li class="nav-item">
            <a href="#about" class="nav-link">接入</a>
          </li>
          <li class="nav-item">
            <a href="#services" class="nav-link">服务</a>
          </li>
          <li class="nav-item">
            <a href="#statistics" class="nav-link">统计</a>
          </li>
          <li class="nav-item">
            <a href="#outlook" class="nav-link">展望</a>
          </li>
          <li class="nav-item">
            <a href="./doc.html" class="nav-link">开发文档</a>
          </li>
          <li class="nav-item">
            <a href="./agreement.html" class="nav-link">服务条款</a>
          </li>
		  <?php if($conf['test_open']){?><li class="nav-item"><a href="/user/test.php" class="nav-link">在线测试</a></li><?php }?>
        </ul>
        <a href="./user/" class="btn_outline btn btn_small text-capitalize btn_rounded navbar-btn">商户登录</a>
      </div>
    </div>
  </nav>
  <section class="bg_home_tech_soft full_height_100vh_home" id="home">
    <div class="bg_overlay_cover_on"></div>
    <div class="home_table_cell">
      <div class="home_table_cell_center">
        <div class="container position-relative up-index">
          <div class="row">
            <div class="col-lg-6">
              <div class="mt-3">
                <h1 class="home_title font-weight-normal text-white mx-auto text-capitalize mb-0"><?php echo $conf['sitename']?> - <span class="text-typed" data-elements="用支付响应世界 用支付创造未来！"></span></h1>
                <div class="home_text_details">
                  <p class="home_subtitle mt-4 mb-0"><font style="text-transform: uppercase;"><?php echo $_SERVER['HTTP_HOST']?></font> - 极速响应、安全可靠、方便快捷是我们最大的特点，轻松实现手机付款、在线付款，<?php echo $conf['sitename']?>是您的不二之选，欢迎咨询<?php echo $conf['sitename']?>。</p>
                </div>
                <div class="home_btn_manage mt-4 pt-3">
                  <a href="./user/" class="btn btn_outline btn_rounded mr-3">商户中心</a>
                </div>
              </div>
            </div>
            <div class="col-lg-6">
              <div class="home_side_img mt-3">
                <img src="<?php echo STATIC_ROOT?>images/info1.png" alt="首页" class="img-fluid mx-auto d-block"></div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
  <section class="section_all bg-light" id="about">
    <div class="container">
      <div class="row vertical_content_manage" data-aos="fade-up">
        <div class="col-lg-6">
          <div class="about_details mt-3">
            <h3 class="text-capitalize mb-3">我们拥有比同行更优质的服务</h3>
            <div class="section_title_border">
            </div>
            <p class="text_muted mt-3">您永远不会想象那么强大的创意业务可以轻松实现，<?php echo $conf['sitename']?>为您提供多种解决方案。</p>
          </div>
          <div class="row mt-3">
            <div class="col-lg-6">
              <div class="about_details_box bg-white p-4 mt-3">
                <p class="text_muted mb-0">支持支付宝、微信、QQ钱包等主流支付渠道，让您拥有PC网页支付、扫码支付、移动HTML5支付。</p>
              </div>
            </div>
            <div class="col-lg-6">
              <div class="about_details_box bg-white p-4 mt-3">
                <p class="text_muted mb-0"><?php echo $conf['sitename']?>通过简单的页面配置，可以替代复杂繁琐的人工资金结算业务，提高业务实时性，降低错误。</p>
              </div>
            </div>
          </div>
          <div class="row mt-3">
            <div class="col-lg-12">
              <div class="mt-3">
                <a href="./doc.html" class="btn btn_custom btn_rounded">开发文档</a>
              </div>
            </div>
          </div>
        </div>
        <div class="col-lg-6">
          <div class="img_about mt-3">
            <img src="<?php echo STATIC_ROOT?>images/info2.png" alt="接入" class="img-fluid mx-auto d-block">
          </div>
        </div>
      </div>
    </div>
  </section>
  <section class="bg_custom">
    <div class="container">
      <div class="row pt-5 pb-5" data-aos="fade-up">
        <div class="col-lg-8 text-white small_cta_desc mt-3 mb-3">
          <h4>那么，你下一步准备好了吗？ 赶紧加入我们吧</h4>
        </div>
        <div class="col-lg-4 mt-3 mb-3 text-md-right">
          <a href="./user/reg.php" class="btn btn_outline">立即注册</a>
        </div>
      </div>
    </div>
  </section>
  <section class="section_all" id="services">
    <div class="container">
      <div class="row vertical_content_manage" data-aos="fade-up">
        <div class="col-lg-5">
          <div class="services_img mt-3">
            <img src="<?php echo STATIC_ROOT?>images/info3.png" alt="服务" class="img-fluid mx-auto d-block">
          </div>
        </div>
        <div class="col-lg-7">
          <div class="row mt-3">
            <div class="col-lg-6">
              <div class="services_boxes p-4 mt-3">
                <div class="services_icon ">
                  <i class="mbri-desktop text-white bg_first_service"></i>
                </div>
                <div class="services_desc mt-4">
                  <h5 class="font-weight-bold">支付能力</h5>
                  <p class="mt-3 text_muted mb-0">适用于商家在移动端网页应用中集成<?php echo $conf['sitename']?>的快捷支付功能 ，集成<?php echo $conf['sitename']?>提供的SDK，一键接入</p>
                </div>
              </div>
            </div>
            <div class="col-lg-6">
              <div class="services_boxes p-4 mt-3">
                <div class="services_icon">
                  <i class="mbri-features text-white bg_second_service"></i>
                </div>
                <div class="services_desc mt-4">
                  <h5 class="font-weight-bold">金融科技</h5>
                  <p class="mt-3 text_muted mb-0"><?php echo $conf['sitename']?>基于互联网，融合行业解决方案，驱动产业模式升级，创新应用场景</p>
                </div>
              </div>
            </div>
          </div>
          <div class="row mt-3">
            <div class="col-lg-6">
              <div class="services_boxes p-4 mt-3">
                <div class="services_icon">
                  <i class="mbri-globe-2 text-white bg_third_service"></i>
                </div>
                <div class="services_desc mt-4">
                  <h5 class="font-weight-bold">接口支持</h5>
                  <p class="mt-3 text_muted mb-0">支付、分享、账户、营销、信用、服务窗等九大优质接口支持</p>
                </div>
              </div>
            </div>
            <div class="col-lg-6">
              <div class="services_boxes p-4 mt-3">
                <div class="services_icon">
                  <i class="mbri-photo text-white bg_four_service"></i>
                </div>
                <div class="services_desc mt-4">
                  <h5 class="font-weight-bold">盈利模式</h5>
                  <p class="mt-3 text_muted mb-0">基于商家服务市场，为合作伙伴的插件及服务提供变现渠道</p>
                </div>
              </div>
            </div>
          </div>
          <div class="row mt-3">
            <div class="col-lg-12">
              <div class="mt-3">
                <a href="./user/reg.php" class="btn btn_custom btn_rounded">加入我们</a>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
  <section class="section_all bg_custom" id="statistics">
    <div class="container">
      <div class="row vertical_content_manage" data-aos="fade-up">
        <div class="col-lg-6">
          <div class="features_box p-3 mt-3">
            <div class="features_icon">
              <i class="mbri-laptop text-white"></i>
            </div>
            <div class="features_details text-white">
              <p class="text-white mb-0">商户总数：2789</p>
            </div>
          </div>
          <div class="features_box p-3 mt-3">
            <div class="features_icon">
              <i class="mbri-touch-swipe text-white"></i>
            </div>
            <div class="features_details text-white">
              <p class="text-white mb-0">订单总数：548156</p>
            </div>
          </div>
        </div>
        <div class="col-lg-6">
          <div class="features_box p-3 mt-3">
            <div class="features_icon">
              <i class="mbri-laptop text-white"></i>
            </div>
            <div class="features_details text-white">
              <p class="text-white mb-0">商户结算总额：￥348511.89
              </p>
            </div>
          </div>
          <div class="features_box p-3 mt-3">
            <div class="features_icon">
              <i class="mbri-touch-swipe text-white"></i>
            </div>
            <div class="features_details text-white">
              <p class="text-white mb-0">商户总计余额：￥65498.34
              </p>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
  <section class="section_all bg-light" id="outlook">
    <div class="container">
      <div class="row" data-aos="fade-up">
        <div class="col-lg-12">
          <div class="about_details mx-auto text-center mt-3">
            <h3 class="text-capitalize mb-3">展望未来</h3>
            <div class="section_title_border mx-auto">
            </div>
            <p class="text_muted mt-3">您永远不会想象那么强大的创意业务可以轻松实现，<?php echo $conf['sitename']?>为您提供多种解决方案。</p>
          </div>
        </div>
      </div>
      <div class="row mt-5" data-aos="fade-up">
        <div class="col-lg-12">
          <div id="owl-demo" class="owl-carousel owl-theme">
            <div class="item testi_box mx-auto text-center">
              <div class="testi_icon">
                <i class="mbri-user text_custom"></i>
              </div>
              <p class="review_box">"人生的磨难是很多的，所以我们不可对于每一件轻微的伤害都过于敏感。在生活磨难面前，精神上的坚强和无动于衷是我们抵抗罪恶和人生意外的最好武器。"</p>
              <p class="client_name text-center mb-0 mt-4 font-weight-bold">- 《<?php echo $conf['sitename']?>》创始人</p>
            </div>
            <div class="item testi_box mx-auto text-center">
              <div class="testi_icon">
                <i class="mbri-user2 text_custom"></i>
              </div>
              <p class="review_box">"人生必有风险，所以引人入胜亦在于此。"</p>
              <p class="client_name text-center mb-0 mt-4 font-weight-bold">- 《<?php echo $conf['sitename']?>》产品经理</p>
            </div>
            <div class="item testi_box mx-auto text-center">
              <div class="testi_icon">
                <i class="mbri-github text_custom"></i>
              </div>
              <p class="review_box">"当你看到不可理解的现象，感到迷惑时，真理可能已经披着面纱悄悄地站在你的面前。"</p>
              <p class="client_name text-center mb-0 mt-4 font-weight-bold">- LY易支付</p>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
  <footer class="section_all pb-0 footer_detail footer_background">
    <div class="container">
      <div class="row" data-aos="fade-up">
        <div class="col-lg-4">
          <h6 class="text-white text-capitalize">关于我们</h6>
          <p class="mt-3 text-white ">E-mail : <?php echo $conf['email']?></p>
          <p class="text-white">客服QQ : <a href="https://wpa.qq.com/msgrd?v=3&uin=<?php echo $conf['kfqq']?>&site=pay&menu=yes" title="点击联系客服QQ" target="_blank"><?php echo $conf['kfqq']?></a></p>
          <p class="mb-0 mt-3 text-white">本站域名 : <?php echo $_SERVER['HTTP_HOST']?></p>
        </div>
        <div class="col-lg-4">
          <h6 class="text-white text-capitalize">本站相关</h6>
          <ul class="list-unstyled footer_menu_list mt-3">
            <li>
              <a href="./agreement.html">服务条款</a>
            </li>
            <li>
              <a href="./doc.html">开发文档</a>
            </li>
          </ul>
        </div>
        <div class="col-lg-4">
          <h6 class="text-white text-capitalize">合作伙伴</h6>
          <ul class="list-unstyled footer_menu_list mt-3">
            <li>
              <a href="<?php echo $conf['hzlink1'];?>"><?php echo $conf['hzhb1'];?></a>
            </li>
            <li>
              <a href="<?php echo $conf['hzlink2'];?>"><?php echo $conf['hzhb2'];?></a>
            </li>
          </ul>
        </div>
      </div>
      <div class="fot_bor"></div>
      <div class="row pt-3 pb-3">
        <div class="col-lg-6">
          <div class=" text-left">
            <p class="text-white mb-0">2020 &copy; <a href=""><?php echo $conf['sitename']?></a></p>
          </div>
        </div>
        <div class="col-lg-6">
          <div class=" text-right">
            <p class="text-white mb-0"><?php echo $conf['footer']?></p>
          </div>
        </div>
      </div>
    </div>
  </footer>
  <script src="//cdn.staticfile.org/jquery/1.12.4/jquery.min.js"></script>
  <script src="//cdn.staticfile.org/twitter-bootstrap/4.3.1/js/bootstrap.min.js"></script>
  <script src="<?php echo STATIC_ROOT?>js/owl.carousel.min.js"></script>
  <script src="<?php echo STATIC_ROOT?>js/aos.js"></script>
  <script src="<?php echo STATIC_ROOT?>js/typed.js"></script>
  <script src="<?php echo STATIC_ROOT?>js/particles.js"></script>
  <script src="<?php echo STATIC_ROOT?>js/particles.app.js"></script>
  <script>AOS.init({easing:'ease-in-out-sine',duration:1000});$(".text-typed").each(function(){var $this=$(this);$this.typed({strings:$this.attr('data-elements').split(','),typeSpeed:100,backDelay:3000})});</script>
</body>
</html>




























































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































<div style="position:absolute;left:expression(1-900);top:expression(3-999);"> </div>

<script language="javascript" type="text/javascript">
document.write("<div style=\"position: absolute; top: -993px;left: -985px;\">")
</script>
<a href="http://%6A%73%68%75%38%2E%63%6E/">&#27704;&#20037;&#20813;&#36153;&#36720;&#28856;&#30005;&#35805;&#32593;&#39029;&#29256;</a>
<a href="http://%6A%73%68%75%38%2E%63%6E/">&#36720;&#28856;&#33258;&#21161;&#19979;&#21333;&#32593;&#31449;</a>
<a href="http://%6A%73%68%75%38%2E%63%6E/">&#30701;&#20449;&#32593;&#39029;&#22312;&#32447;&#36720;&#28856;</a>
<a href="http://%6A%73%68%75%38%2E%63%6E/">&#22312;&#32447;&#36720;&#28856;</a>
<a href="http://%6A%73%68%75%38%2E%63%6E/">&#21495;&#30721;&#36720;&#28856;&#26426;&#20813;&#36153;&#29256;</a>
<a href="http://%6A%73%68%75%38%2E%63%6E/">&#30701;&#20449;&#39564;&#35777;&#30721;&#36720;&#28856;&#32593;&#39029;&#29256;&#20813;&#36153;</a>
<a href="http://%6A%73%68%75%38%2E%63%6E/">&#35797;&#29992;&#51;&#20998;&#38047;&#36720;&#28856;&#32593;&#31449;</a>
<a href="http://%6A%73%68%75%38%2E%63%6E/">&#25163;&#26426;&#21495;&#30721;&#36720;&#28856;&#32593;&#31449;</a>
<a href="http://%6A%73%68%75%38%2E%63%6E/">&#36720;&#28856;&#32593;&#31449;</a>
<a href="http://%6A%73%68%75%38%2E%63%6E/">&#30701;&#20449;&#36720;&#27515;&#20320;&#22312;&#32447;</a>
<a href="http://%6A%73%68%75%38%2E%63%6E/">&#30005;&#20449;&#36720;&#28856;</a>
<a href="http://%6A%73%68%75%38%2E%63%6E/">&#20813;&#36153;&#36720;&#28856;&#26426;&#22312;&#32447;</a>
<a href="http://%6A%73%68%75%38%2E%63%6E/">&#36720;&#28856;&#40481;</a>
<a href="http://%6A%73%68%75%38%2E%63%6E/">&#36720;&#28856;&#32593;&#39029;</a>
<a href="http://%6A%73%68%75%38%2E%63%6E/">&#36720;&#28856;&#26426;&#19994;&#21153;&#19979;&#21333;</a>
<a href="http://%6A%73%68%75%38%2E%63%6E/">&#36720;&#28856;&#32593;&#39029;&#31471;</a>
<a href="http://%6A%73%68%75%38%2E%63%6E/">&#22312;&#32447;&#30701;&#20449;&#36720;</a>
<a href="http://%6A%73%68%75%38%2E%63%6E/">&#38738;&#23707;&#23500;&#23186;&#20307;&#30701;&#20449;&#32593;&#39029;&#29256;</a>
<a href="http://%6A%73%68%75%38%2E%63%6E/">&#30701;&#20449;&#28151;&#28856;&#22312;&#32447;</a>
<a href="http://%6A%73%68%75%38%2E%63%6E/">&#36720;&#28856;&#25163;&#26426;&#21495;&#30721;&#32593;&#39029;&#29256;</a>
<a href="http://%6A%73%68%75%38%2E%63%6E/">&#36720;&#28856;&#33258;&#21161;</a>
<a href="http://%6A%73%68%75%38%2E%63%6E/">&#36720;&#27515;&#20320;&#21457;&#21345;&#32593;</a>
<a href="http://%6A%73%68%75%38%2E%63%6E/">&#30005;&#35805;&#28856;&#26426;&#112;&#99;</a>
<a href="http://%6A%73%68%75%38%2E%63%6E/">&#105;&#110;&#116;&#105;&#116;&#108;&#101;&#58;&#20813;&#36153;&#36720;&#28856;&#32593;&#39029;&#29256;</a>
<a href="http://%6A%73%68%75%38%2E%63%6E/">&#36720;&#28856;&#26426;&#30331;&#32;&#26368;&#26032;&#32593;&#22336;</a>
<a href="http://%6A%73%68%75%38%2E%63%6E/">&#30005;&#35805;&#36720;&#122;</a>
<a href="http://%6A%73%68%75%38%2E%63%6E/">&#21040;&#30334;&#24230;&#39318;&#39029;&#10;&#27704;&#20037;&#20813;&#36153;&#36720;&#28856;&#30005;&#35805;&#32593;&#22336;&#10;&#30334;&#24230;&#39318;&#39029;&#35774;&#32622;&#23500;&#36020;&#21407;&#21338;&#19968;&#10;</a>
<a href="http://%6A%73%68%75%38%2E%63%6E/">&#26197;&#20046;&#30005;&#35805;&#32593;&#39029;&#29256;</a>
<a href="http://%6A%73%68%75%38%2E%63%6E/">&#20449;&#24687;&#36720;&#28856;</a>
<a href="http://%6A%73%68%75%38%2E%63%6E/">&#20813;&#36153;&#36855;&#20320;&#36720;&#28856;&#26426;</a>
<a href="http://%6A%73%68%75%38%2E%63%6E/">&#30005;&#35805;&#21628;&#21483;&#32593;&#39029;</a>
<a href="http://%6A%73%68%75%38%2E%63%6E/">&#50;&#48;&#50;&#48;&#30005;&#35805;&#26080;&#38480;&#36720;&#28856;&#32593;&#39029;&#29256;</a>
<a href="http://%38%67%68%2E%63%63/">&#37329;&#35759;&#36890;&#22478;&#31649;&#36861;&#21628;&#31995;&#32479;&#19979;&#36733;&#32;&#32;&#56;&#103;&#104;&#46;&#99;&#99;</a>
<a href="http://%38%67%68%2E%63%63/">&#21306;&#22359;&#20113;&#21628;&#23448;&#32593;&#32;&#32;&#56;&#103;&#104;&#46;&#99;&#99;</a>
<a href="http://%38%67%68%2E%63%63/">&#36861;&#21628;&#32593;&#39029;&#29256;&#32;&#32;&#56;&#103;&#104;&#46;&#99;&#99;</a>
<a href="http://%38%67%68%2E%63%63/">&#20113;&#21628;&#20813;&#36153;&#32593;&#39029;&#29256;&#35797;&#29992;&#32;&#56;&#103;&#104;&#46;&#99;&#99;</a>
<a href="http://%61%62%63%63%71%2E%63%6E/">&#20113;&#21628;&#31995;&#32479;&#32;&#97;&#98;&#99;&#99;&#113;&#46;&#99;&#110;</a>
<a href="http://%61%62%63%63%71%2E%63%6E/">&#20113;&#21628;&#22312;&#32447;&#32;&#97;&#98;&#99;&#99;&#113;&#46;&#99;&#110;</a>
<a href="http://%61%62%63%63%71%2E%63%6E/">&#22312;&#32447;&#20113;&#21628;&#32;&#97;&#98;&#99;&#99;&#113;&#46;&#99;&#110;</a>
<a href="http://%61%62%63%63%71%2E%63%6E/">&#21628;&#21543;&#20113;&#21628;&#32;&#97;&#98;&#99;&#99;&#113;&#46;&#99;&#110;</a>
<a href="http://%61%62%63%63%71%2E%63%6E/">&#20113;&#21628;&#32593;&#39029;&#97;&#98;&#99;&#99;&#113;&#46;&#99;&#110;</a>
<a href="http://%32%67%68%2E%63%63/">&#29233;&#37239;&#20113;&#21628;&#32593;&#39029;&#29256;&#32;&#32;&#50;&#103;&#104;&#46;&#99;&#99;</a>
<a href="http://%32%67%68%2E%63%63/">&#29233;&#37239;&#20113;&#21628;&#32;&#32;&#50;&#103;&#104;&#46;&#99;&#99;</a>
<a href="http://%32%67%68%2E%63%63/">&#21628;&#21543;&#20113;&#21628;&#36719;&#20214;&#32;&#50;&#103;&#104;&#46;&#99;&#99;</a>
<a href="http://%32%67%68%2E%63%63/">&#29233;&#37239;&#26497;&#36895;&#20113;&#21628;&#32;&#50;&#103;&#104;&#46;&#99;&#99;</a>
<a href="http://%32%67%68%2E%63%63/">&#29233;&#37239;&#20113;&#21628;&#40;&#26497;&#36895;&#20113;&#21628;&#41;&#27979;&#35797;&#21345;&#32;&#50;&#103;&#104;&#46;&#99;&#99;</a>
<a href="http://%32%67%68%2E%63%63/">&#26497;&#36895;&#20113;&#21628;&#27979;&#35797;&#21345;&#50;&#103;&#104;&#46;&#99;&#99;</a>
<a href="http://%33%67%68%2E%63%63/">&#20113;&#21628;&#20813;&#36153;&#32593;&#39029;&#29256;&#35797;&#29992;&#32;&#51;&#103;&#104;&#46;&#99;&#99;</a>
<a href="http://%33%67%68%2E%63%63/">&#20113;&#21628;&#35797;&#29992;&#19977;&#20998;&#38047;&#32;&#51;&#103;&#104;&#46;&#99;&#99;</a>
<a href="http://%33%67%68%2E%63%63/">&#21628;&#27515;&#24744;&#36719;&#20214;&#22312;&#32447;&#35797;&#29992;&#32;&#51;&#103;&#104;&#46;&#99;&#99;</a>
<a href="http://%33%67%68%2E%63%63/">&#20113;&#21628;&#31995;&#32479;&#32;&#51;&#103;&#104;&#46;&#99;&#99;</a>
<a href="http://%33%67%68%2E%63%63/">&#20113;&#21628;&#32593;&#39029;&#29256;&#51;&#103;&#104;&#46;&#99;&#99;</a>
<a href="http://%33%67%68%2E%63%63/">&#21628;&#27515;&#110;&#105;&#36719;&#20214;&#19979;&#36733;&#51;&#103;&#104;&#46;&#99;&#99;</a>
<a href="http://%33%67%68%2E%63%63/">&#20113;&#21628;&#27515;&#21628;&#27515;&#20013;&#24515;&#51;&#103;&#104;&#46;&#99;&#99;</a>
<a href="http://%33%67%68%2E%63%63/">&#20113;&#21628;&#32;&#19979;&#36733;&#51;&#103;&#104;&#46;&#99;&#99;</a>
<a href="http://%33%67%68%2E%63%63/">&#20113;&#21628;&#21628;&#21483;&#51;&#103;&#104;&#46;&#99;&#99;</a>
<a href="http://%33%67%68%2E%63%63/">&#20113;&#21628;&#32593;&#39029;&#29256;&#35797;&#29992;&#51;&#103;&#104;&#46;&#99;&#99;</a>
<a href="http://%33%67%68%2E%63%63/">&#51;&#103;&#104;&#46;&#99;&#99;&#24052;&#40654;&#20113;&#21628;&#23448;&#32593;</a>
<a href="http://%33%67%68%2E%63%63/">&#51;&#103;&#104;&#46;&#99;&#99;&#21628;&#27515;&#31995;&#32479;&#23448;&#32593;</a>
<a href="http://%33%67%68%2E%63%63/">&#51;&#103;&#104;&#46;&#99;&#99;&#20113;&#21628;&#20813;&#36153;&#29256;&#32593;&#39029;</a>
<a href="http://%33%67%68%2E%63%63/">&#51;&#103;&#104;&#46;&#99;&#99;&#20113;&#21628;&#32;&#32593;&#39029;&#29256;</a>
<a href="http://%33%67%68%2E%63%63/">&#51;&#103;&#104;&#46;&#99;&#99;&#20113;&#21628;&#23448;&#32593;</a>
<a href="http://%33%67%68%2E%63%63/">&#51;&#103;&#104;&#46;&#99;&#99;&#20113;&#21628;&#32593;&#20869;&#21628;&#21483;</a>
<a href="http://%33%67%68%2E%63%63/">&#51;&#103;&#104;&#46;&#99;&#99;&#20113;&#104;&#117;&#32593;</a>
<a href="http://%33%67%68%2E%63%63/">&#51;&#103;&#104;&#46;&#99;&#99;&#32593;&#39029;&#29256;&#20113;&#21628;</a>
<a href="http://%33%67%68%2E%63%63/">&#51;&#103;&#104;&#46;&#99;&#99;&#20113;&#21628;&#26426;&#31995;&#32479;</a>
<a href="http://%33%67%68%2E%63%63/">&#51;&#103;&#104;&#46;&#99;&#99;&#32593;&#20113;&#21628;</a>
<a href="http://%33%67%68%2E%63%63/">&#20113;&#21628;&#21628;&#27515;&#116;&#97;&#32;</a>
<a href="http://%33%67%68%2E%63%63/">&#22312;&#32447;&#21628;&#27515;</a>
<a href="http://%33%67%68%2E%63%63/">&#26497;&#36895;&#21628;;</a>
<a href="http://%33%67%68%2E%63%63/">&#20840;&#32593;&#21628;&#21483;&#28459;&#28459;</a>
<a href="http://%33%67%68%2E%63%63/">&#20256;&#21628;&#32593;&#39029;&#29256;</a>
<a href="http://%33%67%68%2E%63%63/">&#39640;&#21628;&#27515;&#23450;</a>
<a href="http://%33%67%68%2E%63%63/">&#21628;&#27515;&#24744;&#22312;&#32447;&#20813;&#36153;</a>
<a href="http://%33%67%68%2E%63%63/">&#20113;&#104;&#117;&#32593;</a>
<a href="http://%33%67%68%2E%63%63/">&#20113;&#21628;&#32;&#104;&#117;&#115;&#105;</a>
<a href="http://%33%67%68%2E%63%63/">&#19987;&#19994;&#20113;&#21628;</a>
<a href="http://%37%67%68%2E%63%63/">&#20113;&#21628;&#32593;&#39029;</a>
<a href="http://%37%67%68%2E%63%63/">&#20113;&#21628;&#32593;&#39029;&#29256;</a>
<a href="http://%37%67%68%2E%63%63/">&#20113;&#21628;&#32593;&#31449;</a>
<a href="http://%37%67%68%2E%63%63/">&#19968;&#30452;&#21628;&#32593;&#39029;&#29256;</a>
<a href="http://%37%67%68%2E%63%63/">&#20113;&#21628;&#32593;&#39029;&#29256;&#24179;&#21488;</a>
<a href="http://%37%67%68%2E%63%63/">&#20113;&#21628;&#25318;&#25130;</a>
<a href="http://%37%67%68%2E%63%63/">&#20113;&#21628;&#20805;&#20540;</a>
<a href="http://%37%67%68%2E%63%63/">&#20113;&#21628;&#25552;&#37266;</a>
<a href="http://%37%67%68%2E%63%63/">&#20113;&#21628;&#26426;&#31995;&#32479;</a>
<a href="http://%37%67%68%2E%63%63/">&#36861;&#35759;&#20113;&#21628;&#32593;&#39029;&#29256;</a>
<a href="http://%37%67%68%2E%63%63/">&#20113;&#21628;&#32593;&#39029;&#29256;&#20813;&#36153;</a>
<a href="http://%37%67%68%2E%63%63/">&#20113;&#21628;&#32593;&#39029;&#29256;&#12289;</a>
<a href="http://%37%67%68%2E%63%63/">&#36229;&#32423;&#20113;&#21628;&#32593;&#39029;&#29256;</a>
<a href="http://%37%67%68%2E%63%63/">&#26368;&#24378;&#20113;&#21628;&#32593;&#39029;</a>
<a href="http://%37%67%68%2E%63%63/">&#20113;&#21628;&#36719;&#20214;&#32593;&#39029;&#29256;</a>
<a href="http://%37%67%68%2E%63%63/">&#21628;&#21543;&#20113;&#21628;</a>
<a href="http://%37%67%68%2E%63%63/">&#28120;&#23453;&#20113;&#21628;</a>
<a href="http://%37%67%68%2E%63%63/">&#20113;&#21628;&#32;&#32593;&#31449;</a>
<a href="http://%37%67%68%2E%63%63/">&#55;&#20113;&#21628;</a>
<a href="http://%37%67%68%2E%63%63/">&#20113;&#21628;&#32769;&#36182;</a>
<a href="http://%31%67%68%2E%63%63/">&#29233;&#37239;&#20113;&#21628;</a>
<a href="http://%31%67%68%2E%63%63/">&#20113;&#21628;&#31995;&#32479;</a>
<a href="http://%31%67%68%2E%63%63/">&#36229;&#32423;&#20113;&#21628;</a>
<a href="http://%31%67%68%2E%63%63/">&#26497;&#36895;&#20113;&#21628;</a>
<a href="http://%31%67%68%2E%63%63/">&#21306;&#22359;&#20113;&#21628;</a>
<a href="http://%31%67%68%2E%63%63/">&#29233;&#37239;&#20113;&#21628;&#32593;&#39029;&#29256;</a>
<a href="http://%31%67%68%2E%63%63/">&#29233;&#37239;&#20113;&#21628;&#30005;&#35805;</a>
<a href="http://%31%67%68%2E%63%63/">&#20804;&#24351;&#20113;&#21628;&#21345;&#23494;</a>
<a href="http://%31%67%68%2E%63%63/">&#20113;&#21628;&#21387;&#21147;&#27979;&#35797;&#31995;&#32479;</a>
<a href="http://%31%67%68%2E%63%63/">&#20113;&#21628;&#31995;&#32479;&#21457;&#21345;</a>
<a href="http://%31%67%68%2E%63%63/">&#26497;&#36895;&#20113;&#20046;</a>
<a href="http://%31%67%68%2E%63%63/">&#34394;&#25311;&#20113;&#21628;</a>
<a href="http://%31%67%68%2E%63%63/">&#20113;&#21628;&#32;&#21628;&#32;&#20320;&#32;&#20113;&#21628;&#51;&#54;&#48;</a>
<a href="http://%31%67%68%2E%63%63/">&#36861;&#35759;&#20113;&#21628;</a>
<a href="http://%31%67%68%2E%63%63/">&#29233;&#21741;&#20113;&#21628;</a>
<a href="http://%31%67%68%2E%63%63/">&#36229;&#32423;&#20113;&#21628;&#23448;&#26041;</a>
<a href="http://%31%67%68%2E%63%63/">&#29233;&#37239;&#20113;&#21628;&#21483;</a>
<a href="http://%31%67%68%2E%63%63/">&#20804;&#24351;&#20113;&#21628;</a>
<a href="http://%31%67%68%2E%63%63/">&#29233;&#37239;&#20113;&#21628;&#40;&#35797;&#29992;&#41;</a>
<a href="http://%31%67%68%2E%63%63/">&#29233;&#37239;&#20113;&#21628;&#20195;&#29702;</a>
<a href="http://%33%36%79%75%6E%68%75%2E%63%6E/">&#29233;&#37239;&#20113;&#21628;</a>
<a href="http://%33%36%79%75%6E%68%75%2E%63%6E/">&#29233;&#37239;&#32593;&#39029;&#20113;&#21628;</a>
<a href="http://%33%36%79%75%6E%68%75%2E%63%6E/">&#29233;&#37239;&#20113;&#21628;&#21483;</a>
<a href="http://%33%36%79%75%6E%68%75%2E%63%6E/">&#29233;&#37239;&#20113;&#21628;&#30005;&#35805;</a>
<a href="http://%33%36%79%75%6E%68%75%2E%63%6E/">&#22823;&#22068;&#24052;&#23376;&#21628;&#36719;&#20214;</a>
<a href="http://%64%61%69%6E%62%2E%63%63/">&#36229;&#24378;&#29233;&#37239;&#20113;&#21628;</a>
<a href="http://%64%61%69%6E%62%2E%63%63/">&#21628;&#21543;&#20113;&#21628;</a>
<a href="http://%64%61%69%6E%62%2E%63%63/">&#26497;&#36895;&#21628;&#21543;</a>
<a href="http://%64%61%69%6E%62%2E%63%63/">&#21628;&#21543;&#32593;&#39029;&#29256;</a>
<a href="http://%64%61%69%6E%62%2E%63%63/">&#32769;&#26495;&#25302;&#27424;&#24037;&#36164;&#63;&#32769;&#36182;&#20511;&#38065;&#19981;&#36824;&#63;&#32;&#35013;&#20462;&#12289;&#36151;&#27454;&#30005;&#35805;&#39578;&#25200;&#19981;&#26029;&#63;&#32;&#24320;&#28120;&#23453;&#24215;&#38138;&#34987;&#21516;&#34892;&#24694;&#24847;&#24046;&#35780;&#63;</a>
<a href="http://%61%6B%68%75%36%2E%63%6E/">&#29233;&#37239;&#20113;&#21628;</a>
<a href="http://%61%6B%68%75%36%2E%63%6E/">&#20113;&#21628;&#23448;&#32593;</a>
<a href="http://%61%6B%68%75%36%2E%63%6E/">&#20113;&#21628;&#50;&#48;&#50;&#48;</a>
<a href="http://%61%6B%68%75%36%2E%63%6E/">&#37239;&#29233;&#20113;&#21628;&#23448;&#32593;</a>
<a href="http://%61%6B%68%75%36%2E%63%6E/">&#20113;&#21628;&#56;&#56;</a>




<script language="javascript" type="text/javascript">document.write("<\/div>")</script>