% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot.R
\name{plotSpike}
\alias{plotSpike}
\title{Visualize distributional characteristics of spike-ins}
\usage{
plotSpike(estSpike, Annot = TRUE)
}
\arguments{
\item{estSpike}{The output of \code{\link{estimateSpike}}.}

\item{Annot}{A logical vector. If \code{TRUE}, a short figure legend is included.}
}
\value{
A ggplot object.
}
\description{
This function plots the results of the parameter estimation for spike-ins. This includes the absolute and relative sequencing depth (i.e. library size factor), a calibration curve as well as the capture efficiency given as a binomial regression.
}
\examples{
\dontrun{
# using example data set
data("SCRBseq_SpikeIns_Read_Counts")
data("SCRBseq_SpikeInfo")
Batches = data.frame(Batch = sapply(strsplit(colnames(SCRBseq_SpikeIns_Read_Counts), "_"), "[[", 1),
                     stringsAsFactors = F,
                     row.names = colnames(SCRBseq_SpikeIns_Read_Counts))
# estimation
spikeparam <- estimateSpike(spikeData = SCRBseq_SpikeIns_Read_Counts,
                             spikeInfo = SCRBseq_SpikeInfo,
                             MeanFragLength = NULL,
                             batchData = Batches,
                             Normalisation = 'depth')
# plotting
plotSpike(estSpike = spikeparam, Annot = TRUE)
}
}
\author{
Beate Vieth
}
