% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot.R
\name{plotEvalDist}
\alias{plotEvalDist}
\title{Visualize distribution assessment}
\usage{
plotEvalDist(evalDistRes, Annot=TRUE)
}
\arguments{
\item{evalDistRes}{The output of \code{\link{evaluateDist}}.}

\item{Annot}{A logical vector. If \code{TRUE}, a short description of the plot is included.}
}
\value{
A ggplot object.
}
\description{
This function plots the results of \code{\link{evaluateDist}} to assess goodness-of-fit testing.
}
\examples{
\dontrun{
## using example data set, but run it for fraction of genes
data("CELseq2_Gene_UMI_Counts")
evalDistRes <- evaluateDist(countData = CELseq2_Gene_UMI_Counts, batchData = NULL,
                            spikeData = NULL, spikeInfo = NULL,
                            Lengths = NULL, MeanFragLengths = NULL,
                            RNAseq = "singlecell", Protocol = "UMI",
                            Normalisation = "scran",
                            GeneFilter = 0.1, SampleFilter = 3,
                            FracGenes = 0.1,
                            verbose = TRUE)
plotEvalDist(evalDistRes)
}
}
\author{
Beate Vieth, Ines Hellmann
}
