% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{GeneCounts}
\alias{GeneCounts}
\title{Ziegenhain et al. 2017: Gene Expression Matrices}
\format{
An object of class \code{"data.frame"}, with genes per row and cells per column.
}
\source{
\url{https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE75790}.
}
\usage{
data(CELseq2_Gene_Read_Counts)
data(CELseq2_Gene_UMI_Counts)
data(DropSeq_Gene_Read_Counts)
data(DropSeq_Gene_UMI_Counts)
data(MARSseq_Gene_Read_Counts)
data(MARSseq_Gene_UMI_Counts)
data(SCRBseq_Gene_Read_Counts)
data(SCRBseq_Gene_UMI_Counts)
data(SmartSeq_Gene_Read_Counts)
data(SmartSeq2_Gene_Read_Counts)
}
\description{
J1 mESC were cultured in ground pluripotency states by 2i/LIF culture as described previously.\cr
The cells were sorted (FACS) and processed in two batches.\cr
Library preparations were performed with different protocols. Furthermore, spike-ins (ERCC) were added.\cr
"CELseq2" : Library preparations were performed with CEL-seq2 on the Fluidigm C1, as described in Hashimshony et al. 2016.\cr
"DropSeq": Drop-seq protocol by emulsion of single-cells with primer-microbreads, as described in Macosko et al. 2015.\cr
"MARSseq" : MARS-seq protocol from FACS-sorted single cells as described in Jaitin et al. 2014.\cr
"SCRBseq" : SCRB-seq protocol from FACS-sorted single cells as described in Soumillon et al. 2014.\cr
"SmartSeq" : Library preparation was performed with the Fluidigm C1 platform as per manufacturers' protocol.\cr
"SmartSeq2" : Library preparations were performed using the Smart-seq2 protocol, as described in Picelli et al. 2013.\cr
\cr
Data Processing:\cr
base-calls were performed with Illumina bcl2fastq.\cr
All cDNA reads were aligned with Star v2.4.0.\cr
SCRB-seq and Drop-seq protocol reads were tagged with its mate-pair UMI and cell barcode; unique reads were obtained.\cr
Smart-seq and Smart-seq2 reads were assigned to genes using Rsubread.\cr
Only cells were considered with at least 1,000,000 reads.\cr
The R Data files are once for Read Counts and once for UMI Counts per Library Preparation Protocol.
}
\keyword{datasets}
