# Spotify Web API for PHP Documentation
There are a lot of things possible with the Spotify Web API and these pages exist to give you an overview of how to make the most out of them. Which methods and options are available, how to use them, and what to do when something goes wrong.

First, start by checking out the [Getting started guide](/docs/getting-started.md) before continuing with the examples below.

## Examples
* **Authorization**
    * [Obtaining an access token using the Authorization Code Flow](/docs/examples/access-token-with-authorization-code-flow.md)
    * [Obtaining an access token using the Client Credentials Flow](/docs/examples/access-token-with-client-credentials-flow.md)
    * [Working with scopes](/docs/examples/working-with-scopes.md)
* **Fetching data**
    * [Fetching catalog information](/docs/examples/fetching-catalog-information.md)
    * [Fetching Spotify featured content](/docs/examples/fetching-spotify-featured-content.md)
    * [Searching the Spotify catalog](/docs/examples/searching-the-spotify-catalog.md)
* **Managing users**
    * [Controlling user playback](/docs/examples/controlling-user-playback.md)
    * [Following artists, playlists, and users](/docs/examples/following-artists-playlists-and-users.md)
    * [Managing a user's library](/docs/examples/managing-user-library.md)
    * [Managing a user's playlists](/docs/examples/managing-user-playlists.md)
    * [Managing a user's profile](/docs/examples/managing-user-profiles.md)
* **Working with the API**
    * [Changing return type](/docs/examples/changing-return-type.md)
    * [Handling errors](/docs/examples/handling-errors.md)

## Method Reference
A full method reference listing all public methods is [available here](/docs/method-reference/).
