Source: https://en.wikipedia.org/wiki/List_of_logic_symbols
Source: https://en.wikipedia.org/wiki/List_of_mathematical_symbols

# Basic logic symbols

⇒ (U+21D2), → (U+2192), ⊃ (U+2283)
x = 2  ⇒  x² = 4 is true, but x² = 4  ⇒  x = 2 is in general false (since x could be −2).

⇔ (U+21D4), ≡ (U+2261), ↔ (U+2194)
x + 5 = y + 2  ⇔  x + 3 = y

¬ (U+00AC), ˜ (U+02DC), ! (U+0021)
¬(¬A)  ⇔  A
x ≠ y  ⇔  ¬(x = y)

∧ (U+2227), · (U+00B7), & (U+0026)
n < 4  ∧  n > 2  ⇔  n = 3 when n is a natural number.

∨ (U+2228), + (U+002B), ∥ (U+2225)
n ≥ 4  ∨  n ≤ 2  ⇔ n ≠ 3 when n is a natural number.

⊕ (U+2295), ⊻ (U+22BB)
(¬A) ⊕ A is always true, and A ⊕ A always false, if vacuous truth is excluded.

⊤ (U+22A4), T, 1
A ⇒ ⊤ is always true.

⊥ (U+22A5), F, 0
⊥ ⇒ A is always true.

∀ (U+2200), ()
∀ n ∈ ℕ: n2 ≥ n.

∃ (U+2203)
∃ n ∈ ℕ: n is even.

≔ (U+2254) or := (U+003A U+003D), ≡ (U+2261), :⇔ (U+003A U+229C)
cosh x ≔ (1/2)(exp x + exp (−x))
A XOR B :⇔ (A ∨ B) ∧ ¬(A ∧ B)

( and )
(8 ÷ 4) ÷ 2 = 2 ÷ 2 = 1, but 8 ÷ (4 ÷ 2) = 8 ÷ 2 = 4.

⊢ (U+22A2)
A → B ⊢ ¬B → ¬A

⊨ (U+22A8)
A → B ⊨ ¬B → ¬A

# Math

## Basic symbols

+
2 + 7 = 9
A₁ = {3, 4, 5, 6} ∧ A₂ = {7, 8, 9, 10} ⇒
A₁ + A₂ = {(3, 1), (4, 1), (5, 1), (6, 1), (7, 2), (8, 2), (9, 2), (10, 2)}

-
36 − 11 = 25
−(−5) = 5
{1, 2, 4} − {1, 3, 4} = {2}

±
The equation x = 5 ± √4, has two solutions, x = 7 and x = 3.
If a = 100 ± 1 mm, then a ≥ 99 mm and a ≤ 101 mm.

∓
cos(x ± y) = cos(x) cos(y) ∓ sin(x) sin(y).

×, ⋅, ·
7 ⋅ 8 = 56
(1, 2, 5) ⋅ (3, 4, −1) = 6
(1, 2, 5) × (3, 4, −1) = (−22, 16, −2)
3 · 4 = 12

| · |

÷, ⁄
2 ÷ 4 = 0.5
12 ⁄ 4 = 3
{0, a, 2a, b, b + a, b + 2a} / {0, b} = {{0, b}, {a, b + a}, {2a, b + 2a}}
If we define ~ by x ~ y ⇔ x − y ∈ ℤ, then ℝ ⁄ ~ = {x + n : n ∈ ℤ, x ∈ [0,1)}.

√
√4 = 2
√−1 = i

∑
4 ∑(k = 1) k² = 1² + 2² + 3² + 4² = 1 + 4 + 9 + 16 = 30

∫
∫ x²dx = (x³ / 3) + C

∮
If C is a Jordan curve about 0, then ∮ C (1/z)dz = 2πi.

…, ⋯, ⋮, ⋰, ⋱
1/2 + 1/4 + 1/8 + 1/16 + ⋯ = 1

∴
All humans are mortal. Socrates is a human. ∴ Socrates is mortal.

∵
11 is prime ∵ it has no positive integer factors other than itself and one.

!
4! = 1 × 2 × 3 × 4 = 24
!(!A) ⇔ A
x ≠ y ⇔ !(x = y)

¬, ˜
¬(¬A) ⇔ A
x ≠ y ⇔ ¬(x = y)

∝
if y = 2x, then y ∝ x.

∞
lim(x → 0) 1 / |x| = ∞

■, □, ∎, ▮, ‣
Used to mark the end of a proof. ■

## Symbols based on equality

=
2 = 2
1 + 1 = 2
36 - 5 = 31

≠
2 + 2 ≠ 5
36 - 5 ≠ 30

≈
π ≈ 3.14159
Q₈ / C₂ ≈ V

~
X ~ N(0,1), the standard normal distribution
2 ~ 5
8 × 9 ~ 100
but π² ≈ 10
x ~ x+1
1 ~ 5 mod 4

=:, :=, ≡, :⇔, ≜, ≝, ≐

≅
V ≅ C₂ × C₂

≡
5 ≡ 2 (mod 3)

⇔, ↔
x + 5 = y + 2 ⇔ x + 3 = y

:=, =:
Let a := 3, then... f(x) := x + 3

## Symbols that point left or right

>, <
3 < 4
5 > 4
5Z < Z
A₃ < S₃

≪, ≫
0.003 ≪ 1000000
x ≪ ex
If c is the counting measure on [0,1] and μ is the Lebesgue measure, then μ ≪ c.

≤, ≥
3 ≤ 4 and 5 ≤ 5
5 ≥ 4 and 5 ≥ 5
Z ≤ Z
A₃ ≤ S₃
If
  ∃f ∈ F. ∀x ∈ N. x ∈ A ⇔ f(x) ∈ B
then
  A ≤F B

≦, ≧
10a ≡ 5 (mod 5) for 1 ≦ a ≦ 10

≺, ≻
If L₁ ≺ L₂ and L₂ ∈ P, then L₁ ∈ P.

◅, ▻
Z(G) ◅ G
(2) ◅ Z
R ▻ S = R - R ⋉ S

⇒, →, ⊃
x = 6 ⇒ x² − 5 = 36 − 5 = 31 is true, but x² − 5 = 36 −5 = 31 ⇒ x = 6 is in general false (since x could be −6).

⊆, ⊂
(A ∩ B) ⊆ A
ℕ ⊂ ℚ
ℚ ⊂ ℝ

⊇, ⊃
(A ∪ B) ⊇ B
ℝ ⊃ ℚ

→
Let f: ℤ → ℕ ∪ {0} be defined by f(x) := x2.

↦
Let f: x ↦ x + 1 (the successor function).

<:, <·
If S <: T and T <: U then S <: U (transitivity).
{1, 8} <• {1, 3, 8} among the subsets of {1, 2, ..., 10} ordered by containment.

⊧
A ⊧ A ∨ ¬A

⊢
A → B ⊢ ¬B → ¬A

⟨|, |>
A qubit's state can be represented as α|0⟩+ β|1⟩, where α and β are complex numbers s.t. |α|2 + |β|2 = 1.
