#region "Copyright"
//
// Copyright (C) 2003 Clayton Harbour
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// As a special exception, the copyright holders of this library give you
// permission to link this library with independent modules to produce an
// executable, regardless of the license terms of these independent
// modules, and to copy and distribute the resulting executable under
// terms of your choice, provided that you also meet, for each linked
// independent module, the terms and conditions of the license of that
// module.  An independent module is a module which is not derived from
// or based on this library.  If you modify this library, you may extend
// this exception to your version of the library, but you are not
// obligated to do so.  If you do not wish to do so, delete this
// exception statement from your version.
//
//    <author>Clayton Harbour</author>
#endregion

using System;

using NUnit.Framework;
using log4net;

using ICSharpCode.SharpCvsLib.Client;
using ICSharpCode.SharpCvsLib.Exceptions;
using ICSharpCode.SharpCvsLib.Misc;
using ICSharpCode.SharpCvsLib.Tests.Config;

namespace ICSharpCode.SharpCvsLib.Commands {
	/// <summary>
	/// Test the recursive tag command.
	/// </summary>
	[TestFixture]
	public class RTagCommandTest {

        private SharpCvsLibTestsConfig settings = SharpCvsLibTestsConfig.GetInstance();
        private const String TEST_TAG_1 = "TEST_1";

        /// <summary>
        /// Create a new instance of the rtag command test.
        /// </summary>
		public RTagCommandTest() {
		}

        /// <summary>
        /// Test that we can add a tag to the repository.
        /// </summary>
        [Test]
        public void TestAddTag () {
            CvsRoot root = new CvsRoot (this.settings.Config.Cvsroot);
            WorkingDirectory workingDirectory =
                new WorkingDirectory (root,
                this.settings.Config.LocalPath,
                this.settings.Config.Module);
            CVSServerConnection connection = new CVSServerConnection ();
            this.Checkout (workingDirectory, connection);

            RTagCommand command = new RTagCommand(workingDirectory);
            command.TagName = TEST_TAG_1;

            connection.Connect (workingDirectory, this.settings.ValidPassword);
            command.Execute (connection);
        }

        /// <summary>
        /// Test that the given tag can be removed from the cvs repository using
        ///     the rtag command.
        /// </summary>
        [Test]
        public void TestRemoveTag () {
            CvsRoot root = new CvsRoot (this.settings.Config.Cvsroot);
            WorkingDirectory workingDirectory =
                new WorkingDirectory (root,
                this.settings.Config.LocalPath,
                this.settings.Config.Module);
            CVSServerConnection connection = new CVSServerConnection ();
            this.Checkout (workingDirectory, connection);

            RTagCommand command = new RTagCommand(workingDirectory);
            command.TagName = TEST_TAG_1;
            command.DeleteTag = true;

            connection.Connect (workingDirectory, this.settings.Config.ValidPassword);
            command.Execute (connection);
        }

        private void Checkout (WorkingDirectory workingDirectory, CVSServerConnection connection) {
            Assert.IsNotNull (connection);

            ICommand command = new CheckoutModuleCommand (workingDirectory);
            Assert.IsNotNull (command);

            try {
                connection.Connect (workingDirectory, this.settings.Config.ValidPassword);
            } catch (AuthenticationException) {
                Assert.IsTrue (true);
            }

            command.Execute (connection);
            connection.Close ();
        }
	}
}
