#region "Copyright"
// ResponseFactory.cs
// Copyright (C) 2001 Mike Krueger
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// As a special exception, the copyright holders of this library give you
// permission to link this library with independent modules to produce an
// executable, regardless of the license terms of these independent
// modules, and to copy and distribute the resulting executable under
// terms of your choice, provided that you also meet, for each linked
// independent module, the terms and conditions of the license of that
// module.  An independent module is a module which is not derived from
// or based on this library.  If you modify this library, you may extend
// this exception to your version of the library, but you are not
// obligated to do so.  If you do not wish to do so, delete this
// exception statement from your version.
#endregion

using ICSharpCode.SharpCvsLib.Attributes;
using ICSharpCode.SharpCvsLib.Client;
using ICSharpCode.SharpCvsLib.Streams;

namespace ICSharpCode.SharpCvsLib.Responses {
    /// <summary>
    /// Factory method for instanciating the correct response handler
    ///     for the cvs response.
    /// </summary>
    [Author("Mike Krueger", "mike@icsharpcode.net", "2001")]
    [Author("Clayton Harbour", "claytonharbour@sporadicism.com", "2005")]
    public sealed class ResponseFactory {
        /// <summary>
        /// Create the response object based on the response string.
        /// </summary>
        /// <param name="responseStr"></param>
        /// <returns></returns>
        public static IResponse CreateResponse(string responseStr) {
            IResponse response;
            switch (responseStr) {
                case "M":
                    response = new MessageResponse();
                    break;
                case "E":
                    // NOTE: The error message response is overloaded from the server
                    //  so there is some complexity hidden in this class...responses
                    //  are basically being delegated to other responses in here.
                    response = new ErrorMessageResponse();
                    break;
                case "MT":
                    response = new MessageTaggedResponse();
                    break;
                case "Checked-in":
                    response = new CheckedInResponse();
                    break;
                case "New-entry":
                    response = new NewEntryResponse();
                    break;
                case "Mod-time":
                    response = new ModTimeResponse();
                    break;
                case "ok":
                    ResetErrorResponseHandlers();
                    response = new OkResponse();
                    break;
                case "error":
                    response = new ErrorResponse();
                    break;
                case "Merged":
                    response = new MergedResponse();
                    break;
                case "Updated":
                    response = new UpdatedResponse();
                    break;
                case "Created":
                    response = new CreatedResponse();
                    break;
                case "Module-expansion":
                    response = new ModuleExpansionResponse();
                    break;
                case "Clear-sticky":
                    response = new ClearStickyResponse();
                    break;
                case "Set-static-directory":
                    response = new SetStaticDirectoryResponse();
                    break;
                case "Clear-static-directory":
                    response = new ClearStaticDirectoryResponse();
                    break;
                case "Valid-requests":
                    response = new ValidRequestsResponse();
                    break;
                case "Set-sticky":
                    response = new SetStickyResponse ();
                    break;
                case "Removed":
                    response = new RemovedResponse();
                    break;
                default:
                    response = null;
                    break;
            }
            return response;
        }

        private static void ResetErrorResponseHandlers () {
            ListResponse.IsHandling = false;
        }
    }
}
