#region "Copyright"
// Copyright (C) 2003 Clayton Harbour
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// As a special exception, the copyright holders of this library give you
// permission to link this library with independent modules to produce an
// executable, regardless of the license terms of these independent
// modules, and to copy and distribute the resulting executable under
// terms of your choice, provided that you also meet, for each linked
// independent module, the terms and conditions of the license of that
// module.  An independent module is a module which is not derived from
// or based on this library.  If you modify this library, you may extend
// this exception to your version of the library, but you are not
// obligated to do so.  If you do not wish to do so, delete this
// exception statement from your version.
//
//    <author>Clayton Harbour</author>
//
#endregion

using System;
using System.Collections;
using System.IO;

using log4net;

using NUnit.Framework;

using ICSharpCode.SharpCvsLib.Tests.Util;
using ICSharpCode.SharpCvsLib.Tests;
using ICSharpCode.SharpCvsLib.Commands;

namespace ICSharpCode.SharpCvsLib.FileSystem {
    /// <summary>
    /// Test the file system probe finds and returns the correct number of
    ///     existing and non-existing files given the list of original files.
    /// </summary>
    [TestFixture]
    public class ProbeTest : AbstractTest {
        private readonly ILog LOGGER = LogManager.GetLogger(typeof(ProbeTest));
        /// <summary>
        /// Tests that probe works correctly with only files specified
        ///     (i.e. no recursion).
        /// </summary>
        [Test]
        public void TestNoCvsFiles () {
            String searchDir = this.GetTempPath();
            Probe probe = new Probe ();
            probe.Start = searchDir;

            probe.Execute();
            Assert.IsNotNull(probe.Files);
            foreach (String file in probe.Files) {
                LOGGER.Debug ("file=[" + file + "]");
            }
            Assert.IsTrue(probe.Files.Count == 0);
        }

        /// <summary>
        /// Test that the default module finds cvs files in the probe directory.
        /// </summary>
        [Test]
        public void TestWithDefaultTestModule() {
            this.CheckoutTestModule();
            Probe probe = new Probe();
            probe.Start = this.GetTempPath();

            probe.Execute();

            Assert.IsNotNull(probe.Files);
            Assert.IsTrue(probe.Files.Count > 0);
        }
    }
}
