; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!

[Setup]
OutputBaseFilename=.\MakeStudioSetup_Actual
AppName=Make Studio
AppVerName=Make Studio
DefaultDirName={pf}\optiMEAS\MakeStudio
DefaultGroupName=optiMEAS\MakeStudio
LicenseFile=License.rtf
Compression=lzma
SolidCompression=true
AllowRootDirectory=false
AlwaysShowDirOnReadyPage=true
ChangesAssociations=true
EnableDirDoesntExistWarning=true
AppSupportURL=http://www.optimeas.de
AppUpdatesURL=http://www.optimeas.de
AppCopyright=optiMEAS 2018
ShowLanguageDialog=yes

[Registry]
Root: HKCR; Subkey: .jmk; ValueType: string; ValueName: ; ValueData: makestudio; Flags: uninsdeletevalue
Root: HKCR; Subkey: makestudio; ValueType: string; ValueName: ; ValueData: Make Studio Utility; Flags: uninsdeletekey
Root: HKCR; Subkey: makestudio\DefaultIcon; ValueType: string; ValueName: ; ValueData: {app}\MAKESTUDIO.EXE,0
Root: HKCR; Subkey: makestudio\shell\open\command; ValueType: string; ValueName: ; ValueData: """{app}\MAKESTUDIO.EXE"" ""%1"""

[Types]
Name: FULL; Description: Full installation
Name: CUSTOM; Description: Custom installation; Flags: IsCustom

[CustomMessages]
; -----------
; en Language
RegisterIdeClientForUseIn_Product=Register IDE wizard for use in %1
RegisterFor_Product_Version_IDE=Register for %1 IDE

[Components]
Name: GUI; Description: Framework; Types: FULL CUSTOM
Name: PLGDELPHI32; Description: Delphi 32 Plugin; Types: FULL CUSTOM
Name: PLGJVCS; Description: JVCS Plugin; Types: FULL CUSTOM
Name: PLGUTILS; Description: Utilities Plugin; Types: FULL CUSTOM
Name: PLGWISE; Description: Wise Installer Plugin; Types: FULL CUSTOM
Name: PLGPASSOLO; Description: Passolo Localization Plugin; Types: FULL CUSTOM
Name: PLGEASYBACKUP; Description: Easy Backup Plugin; Types: FULL CUSTOM
Name: PLGTEMPLATE; Description: Plugin Wizard and Samples; Types: FULL CUSTOM
Name: PLGDIALOGS; Description: Dialogs Plugin; Types: FULL CUSTOM
Name: PLGHELPMAN; Description: Help and Manual Plugin; Types: FULL CUSTOM
Name: PLGRESOURCE; Description: Version Resource Plugin; Types: FULL CUSTOM
Name: PLGINNOSETUP; Description: Inno Setup Plugin; Types: FULL CUSTOM
Name: PLGZIP; Description: Zip Plugin; Types: FULL CUSTOM
Name: PLGNSIS; Description: NSIS Setup Plugin; Types: FULL CUSTOM
Name: PLGPSCRIPT; Description: Pascal Script Plugin; Types: FULL CUSTOM
Name: PLGWIZARD; Description: Code Wizard for own Plugins; Types: FULL CUSTOM
Name: PLGEMAIL; Description: Email Plugin; Types: FULL CUSTOM
Name: PLGMSBUILD; Description: .Net MSBuild Plugin; Types: FULL CUSTOM

[Tasks]
Name: desktopicon; Description: {cm:CreateDesktopIcon}; GroupDescription: {cm:AdditionalIcons}; Flags: unchecked
Name: quicklaunchicon; Description: {cm:CreateQuickLaunchIcon}; GroupDescription: {cm:AdditionalIcons}; Flags: unchecked

[Files]
Source: "..\bin\makestudio.exe"; DestDir: "{app}"; Flags: ignoreversion overwritereadonly; Components: GUI
Source: "..\bin\makestudio.dll"; DestDir: "{app}"; Flags: ignoreversion overwritereadonly; Components: GUI
Source: "..\bin\ms.exe"; DestDir: "{app}"; Flags: ignoreversion overwritereadonly; Components: GUI
Source: "..\bin\makestudio.kwd"; DestDir: "{app}"; Flags: ignoreversion overwritereadonly; Components: GUI
Source: "..\bin\jvcs_Plugin.jpl"; DestDir: "{app}"; Flags: ignoreversion overwritereadonly; Components: PLGJVCS
Source: "..\bin\delphi32_Plugin.jpl"; DestDir: "{app}"; Flags: ignoreversion overwritereadonly; Components: PLGDELPHI32
Source: "..\bin\EasyBackup_Plugin.jpl"; DestDir: "{app}"; Flags: ignoreversion overwritereadonly; Components: PLGEASYBACKUP
Source: "..\bin\utils_Plugin.jpl"; DestDir: "{app}"; Flags: ignoreversion overwritereadonly; Components: PLGUTILS
Source: "..\bin\passolo_Plugin.jpl"; DestDir: "{app}"; Flags: ignoreversion overwritereadonly; Components: PLGPASSOLO
Source: "..\bin\wise_Plugin.jpl"; DestDir: "{app}"; Flags: ignoreversion overwritereadonly; Components: PLGWISE
Source: "..\bin\dialogs_Plugin.jpl"; DestDir: "{app}"; Flags: ignoreversion overwritereadonly; Components: PLGDIALOGS
Source: "..\bin\helpandmanual_Plugin.jpl"; DestDir: "{app}"; Flags: ignoreversion overwritereadonly; Components: PLGHELPMAN
Source: "..\bin\resources_Plugin.jpl"; DestDir: "{app}"; Flags: ignoreversion overwritereadonly; Components: PLGRESOURCE
Source: "..\bin\innosetup_Plugin.jpl"; DestDir: "{app}"; Flags: ignoreversion overwritereadonly; Components: PLGINNOSETUP
Source: "..\bin\zip_Plugin.jpl"; DestDir: "{app}"; Flags: ignoreversion overwritereadonly; Components: PLGZIP
Source: "..\source\plugins\pluginzip\Dll\DelZip179.dll"; DestDir: "{app}"; Flags: ignoreversion overwritereadonly; Components: PLGZIP
Source: "..\source\plugins\pluginzip\Dll\DelZip192.dll"; DestDir: "{app}"; Flags: ignoreversion overwritereadonly; Components: PLGZIP
Source: "..\source\plugins\pluginzip\Dll\DelZip190.dll"; DestDir: "{app}"; Flags: ignoreversion overwritereadonly; Components: PLGZIP
Source: "..\bin\nsis_Plugin.jpl"; DestDir: "{app}"; Flags: ignoreversion overwritereadonly; Components: PLGNSIS
Source: "..\bin\pscript_Plugin.jpl"; DestDir: "{app}"; Flags: ignoreversion overwritereadonly; Components: PLGPSCRIPT
Source: "..\bin\codewizard.jpl"; DestDir: "{app}"; Flags: ignoreversion overwritereadonly; Components: PLGWIZARD
Source: "..\bin\email_plugin.jpl"; DestDir: "{app}"; Flags: ignoreversion overwritereadonly; Components: PLGEMAIL
Source: "..\bin\msbuild_plugin.jpl"; DestDir: "{app}"; Flags: ignoreversion overwritereadonly; Components: PLGMSBUILD
Source: "..\source\framework\makestudio_TLB.pas"; DestDir: "{app}\Source\Lib"; Flags: ignoreversion overwritereadonly; Components: PLGTEMPLATE

;Basic Help Files
Source: "..\doc\help\startup\makestudio.hhp"; DestDir: "{app}\help"; Flags: ignoreversion overwritereadonly; Components: GUI
Source: "..\doc\help\startup\makestudio.hhc"; DestDir: "{app}\help"; Flags: ignoreversion overwritereadonly; Components: GUI
Source: "..\doc\help\startup\makestudio.hhk"; DestDir: "{app}\help"; Flags: ignoreversion overwritereadonly; Components: GUI
Source: "..\doc\help\startup\makestudio.htm"; DestDir: "{app}\help"; Flags: ignoreversion overwritereadonly; Components: GUI
Source: "..\doc\help\startup\mainform.jpg"; DestDir: "{app}\help"; Flags: ignoreversion overwritereadonly; Components: GUI
Source: "..\doc\history\History.chm"; DestDir: "{app}\Help"; Flags: ignoreversion overwritereadonly
Source: "..\doc\history\History.txt"; DestDir: "{app}\Help"; Flags: ignoreversion overwritereadonly
Source: "..\doc\help\makestudio\makestudiomain.chm"; DestDir: "{app}\Help"; Flags: ignoreversion overwritereadonly
Source: "..\doc\help\makestudio\makestudiomain.txt"; DestDir: "{app}\Help"; Flags: ignoreversion overwritereadonly

;Source Examples
Source: "..\source\examples\borland\delphi\d2005\jedimakeplugin_Actions.dfm"; DestDir: "{app}\examples\borland\delphi\d2005"; Flags: ignoreversion
Source: "..\source\examples\borland\delphi\d2005\jedimakeplugin_Actions.pas"; DestDir: "{app}\examples\borland\delphi\d2005"; Flags: ignoreversion
Source: "..\source\examples\borland\delphi\d2005\jedimakeplugin_Actiontest.dfm"; DestDir: "{app}\examples\borland\delphi\d2005"; Flags: ignoreversion
Source: "..\source\examples\borland\delphi\d2005\jedimakeplugin_Actiontest.pas"; DestDir: "{app}\examples\borland\delphi\d2005"; Flags: ignoreversion
Source: "..\source\examples\borland\delphi\d2005\jedimakeplugin_ExampleCommand.pas"; DestDir: "{app}\examples\borland\delphi\d2005"; Flags: ignoreversion
Source: "..\source\examples\borland\delphi\d2005\jedimakeplugin_ExampleCommand_Edit.dfm"; DestDir: "{app}\examples\borland\delphi\d2005"; Flags: ignoreversion
Source: "..\source\examples\borland\delphi\d2005\jedimakeplugin_ExampleCommand_Edit.pas"; DestDir: "{app}\examples\borland\delphi\d2005"; Flags: ignoreversion
Source: "..\source\examples\borland\delphi\d2005\jedimakeplugin_Example_D2005.bdsproj"; DestDir: "{app}\examples\borland\delphi\d2005"; Flags: ignoreversion
Source: "..\source\examples\borland\delphi\d2005\jedimakeplugin_Example_D2005.cfg"; DestDir: "{app}\examples\borland\delphi\d2005"; Flags: ignoreversion
Source: "..\source\examples\borland\delphi\d2005\jedimakeplugin_Example_D2005.dpr"; DestDir: "{app}\examples\borland\delphi\d2005"; Flags: ignoreversion
Source: "..\source\examples\borland\delphi\d2005\jedimakeplugin_Example_D2005.res"; DestDir: "{app}\examples\borland\delphi\d2005"; Flags: ignoreversion
Source: "..\source\examples\borland\delphi\d2005\jedimakeplugin_Vars.pas"; DestDir: "{app}\examples\borland\delphi\d2005"; Flags: ignoreversion
Source: "..\source\examples\borland\delphi\d2006\jedimakeplugin_Actions.dfm"; DestDir: "{app}\examples\borland\delphi\d2006"; Flags: ignoreversion
Source: "..\source\examples\borland\delphi\d2006\jedimakeplugin_Actions.pas"; DestDir: "{app}\examples\borland\delphi\d2006"; Flags: ignoreversion
Source: "..\source\examples\borland\delphi\d2006\jedimakeplugin_Actiontest.dfm"; DestDir: "{app}\examples\borland\delphi\d2006"; Flags: ignoreversion
Source: "..\source\examples\borland\delphi\d2006\jedimakeplugin_Actiontest.pas"; DestDir: "{app}\examples\borland\delphi\d2006"; Flags: ignoreversion
Source: "..\source\examples\borland\delphi\d2006\jedimakeplugin_ExampleCommand.pas"; DestDir: "{app}\examples\borland\delphi\d2006"; Flags: ignoreversion
Source: "..\source\examples\borland\delphi\d2006\jedimakeplugin_ExampleCommand_Edit.dfm"; DestDir: "{app}\examples\borland\delphi\d2006"; Flags: ignoreversion
Source: "..\source\examples\borland\delphi\d2006\jedimakeplugin_ExampleCommand_Edit.pas"; DestDir: "{app}\examples\borland\delphi\d2006"; Flags: ignoreversion
Source: "..\source\examples\borland\delphi\d2006\jedimakeplugin_Example_D2005.bdsproj"; DestDir: "{app}\examples\borland\delphi\d2006"; Flags: ignoreversion
Source: "..\source\examples\borland\delphi\d2006\jedimakeplugin_Example_D2005.cfg"; DestDir: "{app}\examples\borland\delphi\d2006"; Flags: ignoreversion
Source: "..\source\examples\borland\delphi\d2006\jedimakeplugin_Example_D2005.dpr"; DestDir: "{app}\examples\borland\delphi\d2006"; Flags: ignoreversion
Source: "..\source\examples\borland\delphi\d2006\jedimakeplugin_Example_D2005.res"; DestDir: "{app}\examples\borland\delphi\d2006"; Flags: ignoreversion
Source: "..\source\examples\borland\delphi\d2006\jedimakeplugin_Example_D2006.bdsproj"; DestDir: "{app}\examples\borland\delphi\d2006"; Flags: ignoreversion
Source: "..\source\examples\borland\delphi\d2006\jedimakeplugin_Example_D2006.cfg"; DestDir: "{app}\examples\borland\delphi\d2006"; Flags: ignoreversion
Source: "..\source\examples\borland\delphi\d2006\jedimakeplugin_Example_D2006.dpr"; DestDir: "{app}\examples\borland\delphi\d2006"; Flags: ignoreversion
Source: "..\source\examples\borland\delphi\d2006\jedimakeplugin_Example_D2006.res"; DestDir: "{app}\examples\borland\delphi\d2006"; Flags: ignoreversion
Source: "..\source\examples\borland\delphi\d2006\jedimakeplugin_Vars.pas"; DestDir: "{app}\examples\borland\delphi\d2006"; Flags: ignoreversion
Source: "..\source\examples\borland\delphi\d7\jedimakeplugin_Actions.dfm"; DestDir: "{app}\examples\borland\delphi\d7"; Flags: ignoreversion
Source: "..\source\examples\borland\delphi\d7\jedimakeplugin_Actions.pas"; DestDir: "{app}\examples\borland\delphi\d7"; Flags: ignoreversion
Source: "..\source\examples\borland\delphi\d7\jedimakeplugin_Actiontest.dfm"; DestDir: "{app}\examples\borland\delphi\d7"; Flags: ignoreversion
Source: "..\source\examples\borland\delphi\d7\jedimakeplugin_Actiontest.pas"; DestDir: "{app}\examples\borland\delphi\d7"; Flags: ignoreversion
Source: "..\source\examples\borland\delphi\d7\jedimakeplugin_ExampleCommand.pas"; DestDir: "{app}\examples\borland\delphi\d7"; Flags: ignoreversion
Source: "..\source\examples\borland\delphi\d7\jedimakeplugin_ExampleCommand_Edit.dfm"; DestDir: "{app}\examples\borland\delphi\d7"; Flags: ignoreversion
Source: "..\source\examples\borland\delphi\d7\jedimakeplugin_ExampleCommand_Edit.pas"; DestDir: "{app}\examples\borland\delphi\d7"; Flags: ignoreversion
Source: "..\source\examples\borland\delphi\d7\jedimakeplugin_Example_D7.cfg"; DestDir: "{app}\examples\borland\delphi\d7"; Flags: ignoreversion
Source: "..\source\examples\borland\delphi\d7\jedimakeplugin_Example_D7.dpr"; DestDir: "{app}\examples\borland\delphi\d7"; Flags: ignoreversion
Source: "..\source\examples\borland\delphi\d7\jedimakeplugin_Example_D7.jpl"; DestDir: "{app}\examples\borland\delphi\d7"; Flags: ignoreversion
Source: "..\source\examples\borland\delphi\d7\jedimakeplugin_Example_D7.res"; DestDir: "{app}\examples\borland\delphi\d7"; Flags: ignoreversion
Source: "..\source\examples\borland\delphi\d7\jedimakeplugin_Vars.pas"; DestDir: "{app}\examples\borland\delphi\d7"; Flags: ignoreversion
Source: "..\source\examples\lazarus\jedimakeplugin_Actions.lfm"; DestDir: "{app}\examples\lazarus"; Flags: ignoreversion
Source: "..\source\examples\lazarus\jedimakeplugin_Actions.lrs"; DestDir: "{app}\examples\lazarus"; Flags: ignoreversion
Source: "..\source\examples\lazarus\jedimakeplugin_Actions.pas"; DestDir: "{app}\examples\lazarus"; Flags: ignoreversion
Source: "..\source\examples\lazarus\jedimakeplugin_Actiontest.lfm"; DestDir: "{app}\examples\lazarus"; Flags: ignoreversion
Source: "..\source\examples\lazarus\jedimakeplugin_Actiontest.pas"; DestDir: "{app}\examples\lazarus"; Flags: ignoreversion
Source: "..\source\examples\lazarus\jedimakeplugin_ExampleCommand.pas"; DestDir: "{app}\examples\lazarus"; Flags: ignoreversion
Source: "..\source\examples\lazarus\jedimakeplugin_ExampleCommand_Edit.lfm"; DestDir: "{app}\examples\lazarus"; Flags: ignoreversion
Source: "..\source\examples\lazarus\jedimakeplugin_ExampleCommand_Edit.lrs"; DestDir: "{app}\examples\lazarus"; Flags: ignoreversion
Source: "..\source\examples\lazarus\jedimakeplugin_ExampleCommand_Edit.pas"; DestDir: "{app}\examples\lazarus"; Flags: ignoreversion
Source: "..\source\examples\lazarus\jedimakeplugin_Example_D7.lpi"; DestDir: "{app}\examples\lazarus"; Flags: ignoreversion
Source: "..\source\examples\lazarus\jedimakeplugin_Example_D7.lpr"; DestDir: "{app}\examples\lazarus"; Flags: ignoreversion
Source: "..\source\examples\lazarus\jedimakeplugin_Vars.pas"; DestDir: "{app}\examples\lazarus"; Flags: ignoreversion
Source: "..\source\examples\lazarus\backup\jedimakeplugin_Actions.lfm.bak"; DestDir: "{app}\examples\lazarus\backup"; Flags: ignoreversion
Source: "..\source\examples\lazarus\backup\jedimakeplugin_Actions.lrs.bak"; DestDir: "{app}\examples\lazarus\backup"; Flags: ignoreversion
Source: "..\source\examples\lazarus\backup\jedimakeplugin_Actions.pas.bak"; DestDir: "{app}\examples\lazarus\backup"; Flags: ignoreversion
Source: "..\source\examples\lazarus\backup\jedimakeplugin_ExampleCommand_Edit.lfm.bak"; DestDir: "{app}\examples\lazarus\backup"; Flags: ignoreversion
Source: "..\source\examples\lazarus\backup\jedimakeplugin_ExampleCommand_Edit.pas.bak"; DestDir: "{app}\examples\lazarus\backup"; Flags: ignoreversion
Source: "..\source\examples\lazarus\backup\jedimakeplugin_Example_D7.lpi.bak"; DestDir: "{app}\examples\lazarus\backup"; Flags: ignoreversion
Source: "..\source\examples\lazarus\backup\jedimakeplugin_Example_D7.lpr.bak"; DestDir: "{app}\examples\lazarus\backup"; Flags: ignoreversion
Source: "..\source\examples\Qt\4.7\plugin_qt_test\plugin_qt_test.cpp"; DestDir: "{app}\examples\Qt\4.7\plugin_qt_test"; Flags: ignoreversion
Source: "..\source\examples\Qt\4.7\plugin_qt_test\plugin_qt_test.h"; DestDir: "{app}\examples\Qt\4.7\plugin_qt_test"; Flags: ignoreversion
Source: "..\source\examples\Qt\4.7\plugin_qt_test\plugin_qt_test.pro"; DestDir: "{app}\examples\Qt\4.7\plugin_qt_test"; Flags: ignoreversion
Source: "..\source\examples\Qt\4.7\plugin_qt_test\plugin_qt_test_global.h"; DestDir: "{app}\examples\Qt\4.7\plugin_qt_test"; Flags: ignoreversion
Source: "..\source\examples\Qt\4.7\qtdlltest_pas\Project14.dpr"; DestDir: "{app}\examples\Qt\4.7\qtdlltest_pas"; Flags: ignoreversion
Source: "..\source\examples\Qt\4.7\qtdlltest_pas\Project14.dproj"; DestDir: "{app}\examples\Qt\4.7\qtdlltest_pas"; Flags: ignoreversion
Source: "..\source\examples\Qt\4.7\qtdlltest_pas\Project14.res"; DestDir: "{app}\examples\Qt\4.7\qtdlltest_pas"; Flags: ignoreversion
Source: "..\source\examples\Qt\4.7\qtdlltest_pas\Unit13.dfm"; DestDir: "{app}\examples\Qt\4.7\qtdlltest_pas"; Flags: ignoreversion
Source: "..\source\examples\Qt\4.7\qtdlltest_pas\Unit13.pas"; DestDir: "{app}\examples\Qt\4.7\qtdlltest_pas"; Flags: ignoreversion
Source: "..\source\examples\sharpdevelop\2.0\jpl.sharpdevelop.testplugin\Actions.cs"; DestDir: "{app}\examples\sharpdevelop\2.0\jpl.sharpdevelop.testplugin"; Flags: ignoreversion
Source: "..\source\examples\sharpdevelop\2.0\jpl.sharpdevelop.testplugin\Actions.Designer.cs"; DestDir: "{app}\examples\sharpdevelop\2.0\jpl.sharpdevelop.testplugin"; Flags: ignoreversion
Source: "..\source\examples\sharpdevelop\2.0\jpl.sharpdevelop.testplugin\AssemblyInfo.cs"; DestDir: "{app}\examples\sharpdevelop\2.0\jpl.sharpdevelop.testplugin"; Flags: ignoreversion
Source: "..\source\examples\sharpdevelop\2.0\jpl.sharpdevelop.testplugin\Command.cs"; DestDir: "{app}\examples\sharpdevelop\2.0\jpl.sharpdevelop.testplugin"; Flags: ignoreversion
Source: "..\source\examples\sharpdevelop\2.0\jpl.sharpdevelop.testplugin\CommandEdit.cs"; DestDir: "{app}\examples\sharpdevelop\2.0\jpl.sharpdevelop.testplugin"; Flags: ignoreversion
Source: "..\source\examples\sharpdevelop\2.0\jpl.sharpdevelop.testplugin\CommandEdit.resx"; DestDir: "{app}\examples\sharpdevelop\2.0\jpl.sharpdevelop.testplugin"; Flags: ignoreversion
Source: "..\source\examples\sharpdevelop\2.0\jpl.sharpdevelop.testplugin\jpl.sharpdevelop.testplugin.csproj"; DestDir: "{app}\examples\sharpdevelop\2.0\jpl.sharpdevelop.testplugin"; Flags: ignoreversion
Source: "..\source\examples\sharpdevelop\2.0\jpl.sharpdevelop.testplugin\jpl.sharpdevelop.testplugin.sln"; DestDir: "{app}\examples\sharpdevelop\2.0\jpl.sharpdevelop.testplugin"; Flags: ignoreversion
Source: "..\source\examples\sharpdevelop\2.0\jpl.sharpdevelop.testplugin\PluginInterface.cs"; DestDir: "{app}\examples\sharpdevelop\2.0\jpl.sharpdevelop.testplugin"; Flags: ignoreversion
Source: "..\source\examples\visual studio\vs2005express\csharp\Actions.cs"; DestDir: "{app}\examples\visual studio\vs2005express\csharp"; Flags: ignoreversion
Source: "..\source\examples\visual studio\vs2005express\csharp\Actions.Designer.cs"; DestDir: "{app}\examples\visual studio\vs2005express\csharp"; Flags: ignoreversion
Source: "..\source\examples\visual studio\vs2005express\csharp\Actions.resx"; DestDir: "{app}\examples\visual studio\vs2005express\csharp"; Flags: ignoreversion
Source: "..\source\examples\visual studio\vs2005express\csharp\AssemblyInfo.cs"; DestDir: "{app}\examples\visual studio\vs2005express\csharp"; Flags: ignoreversion
Source: "..\source\examples\visual studio\vs2005express\csharp\Command.cs"; DestDir: "{app}\examples\visual studio\vs2005express\csharp"; Flags: ignoreversion
Source: "..\source\examples\visual studio\vs2005express\csharp\EditCommand.cs"; DestDir: "{app}\examples\visual studio\vs2005express\csharp"; Flags: ignoreversion
Source: "..\source\examples\visual studio\vs2005express\csharp\EditCommand.Designer.cs"; DestDir: "{app}\examples\visual studio\vs2005express\csharp"; Flags: ignoreversion
Source: "..\source\examples\visual studio\vs2005express\csharp\EditCommand.resx"; DestDir: "{app}\examples\visual studio\vs2005express\csharp"; Flags: ignoreversion
Source: "..\source\examples\visual studio\vs2005express\csharp\jpl.vscsharp2005.testplugin.csproj"; DestDir: "{app}\examples\visual studio\vs2005express\csharp"; Flags: ignoreversion
Source: "..\source\examples\visual studio\vs2005express\csharp\jpl.vscsharp2005.testplugin.sln"; DestDir: "{app}\examples\visual studio\vs2005express\csharp"; Flags: ignoreversion
Source: "..\source\examples\visual studio\vs2005express\csharp\jpl.vscsharp2005.testplugin.suo"; DestDir: "{app}\examples\visual studio\vs2005express\csharp"; Flags: ignoreversion
Source: "..\source\examples\visual studio\vs2005express\csharp\PluginInterface.cs"; DestDir: "{app}\examples\visual studio\vs2005express\csharp"; Flags: ignoreversion
Source: "..\source\examples\visual studio\vs2010express\csharp\Actions.cs"; DestDir: "{app}\examples\visual studio\vs2010express\csharp"; Flags: ignoreversion
Source: "..\source\examples\visual studio\vs2010express\csharp\AssemblyInfo.cs"; DestDir: "{app}\examples\visual studio\vs2010express\csharp"; Flags: ignoreversion
Source: "..\source\examples\visual studio\vs2010express\csharp\Command includes ownerdraw.cs"; DestDir: "{app}\examples\visual studio\vs2010express\csharp"; Flags: ignoreversion
Source: "..\source\examples\visual studio\vs2010express\csharp\Command.cs"; DestDir: "{app}\examples\visual studio\vs2010express\csharp"; Flags: ignoreversion
Source: "..\source\examples\visual studio\vs2010express\csharp\EditCommand.cs"; DestDir: "{app}\examples\visual studio\vs2010express\csharp"; Flags: ignoreversion
Source: "..\source\examples\visual studio\vs2010express\csharp\EditCommand.Designer.cs"; DestDir: "{app}\examples\visual studio\vs2010express\csharp"; Flags: ignoreversion
Source: "..\source\examples\visual studio\vs2010express\csharp\EditCommand.resx"; DestDir: "{app}\examples\visual studio\vs2010express\csharp"; Flags: ignoreversion
Source: "..\source\examples\visual studio\vs2010express\csharp\jpl.vscs2010.testplugin.csproj"; DestDir: "{app}\examples\visual studio\vs2010express\csharp"; Flags: ignoreversion
Source: "..\source\examples\visual studio\vs2010express\csharp\jpl.vscs2010.testplugin.sln"; DestDir: "{app}\examples\visual studio\vs2010express\csharp"; Flags: ignoreversion
Source: "..\source\examples\visual studio\vs2010express\csharp\Plugin.cs"; DestDir: "{app}\examples\visual studio\vs2010express\csharp"; Flags: ignoreversion
Source: "..\source\examples\visual studio\vs2010express\csharp\Properties\Resources.Designer.cs"; DestDir: "{app}\examples\visual studio\vs2010express\csharp\Properties"; Flags: ignoreversion
Source: "..\source\examples\visual studio\vs2010express\csharp\Properties\Resources.resx"; DestDir: "{app}\examples\visual studio\vs2010express\csharp\Properties"; Flags: ignoreversion
Source: "..\source\examples\visual studio\vs2010express\csharp\Resources\cs.bmp"; DestDir: "{app}\examples\visual studio\vs2010express\csharp\Resources"; Flags: ignoreversion

[Icons]
Name: "{group}\Make Studio"; Filename: {app}\makestudio.exe
Name: {group}\{cm:UninstallProgram,Make Studio}; Filename: {uninstallexe}
Name: {userdesktop}\Make Studio; Filename: {app}\makestudio.exe; Tasks: desktopicon
Name: {userappdata}\Microsoft\Internet Explorer\Quick Launch\Make Studio; Filename: {app}\makestudio.exe; Tasks: quicklaunchicon

[Run]
Filename: {app}\makestudio.exe; Description: {cm:LaunchProgram,Make Studio}; Flags: nowait postinstall skipifsilent

[Dirs]
Name: {app}\Source
Name: {app}\Source\Lib
Name: {app}\Help; Permissions: everyone-full
Name: {cf}\Help; Permissions: everyone-full
Name: "{app}\examples\borland"
Name: "{app}\examples\borland\delphi"
Name: "{app}\examples\borland\delphi\d2005"
Name: "{app}\examples\borland\delphi\d2006"
Name: "{app}\examples\borland\delphi\d7"
Name: "{app}\examples\lazarus"
Name: "{app}\examples\lazarus\backup"
Name: "{app}\examples\Qt"
Name: "{app}\examples\Qt\4.7"
Name: "{app}\examples\Qt\4.7\plugin_qt_test"
Name: "{app}\examples\Qt\4.7\qtdlltest_pas"
Name: "{app}\examples\sharpdevelop"
Name: "{app}\examples\sharpdevelop\2.0"
Name: "{app}\examples\sharpdevelop\2.0\jpl.sharpdevelop.testplugin"
Name: "{app}\examples\sharpdevelop\2.0\jpl.sharpdevelop.testplugin\bin"
Name: "{app}\examples\sharpdevelop\2.0\jpl.sharpdevelop.testplugin\bin\debug"
Name: "{app}\examples\sharpdevelop\2.0\jpl.sharpdevelop.testplugin\obj"
Name: "{app}\examples\visual studio"
Name: "{app}\examples\visual studio\vs2005express"
Name: "{app}\examples\visual studio\vs2005express\csharp"
Name: "{app}\examples\visual studio\vs2005express\csharp\obj"
Name: "{app}\examples\visual studio\vs2005express\csharp\obj\release"
Name: "{app}\examples\visual studio\vs2010express"
Name: "{app}\examples\visual studio\vs2010express\csharp"
Name: "{app}\examples\visual studio\vs2010express\csharp\obj"
Name: "{app}\examples\visual studio\vs2010express\csharp\obj\x86"
Name: "{app}\examples\visual studio\vs2010express\csharp\obj\x86\Debug"
Name: "{app}\examples\visual studio\vs2010express\csharp\obj\x86\Debug\TempPE"
Name: "{app}\examples\visual studio\vs2010express\csharp\Properties"
Name: "{app}\examples\visual studio\vs2010express\csharp\Resources"

[Code]
// some often used consts
const
  C_RSK_DELPHI      = 'Delphi';
  C_RSK_CPP_BUILDER = 'C++Builder';
  C_RSK_BDS         = 'BDS';

  C_RSK_1_0 = '1.0';
  C_RSK_2_0 = '2.0';
  C_RSK_3_0 = '3.0';
  C_RSK_5_0 = '5.0';
  C_RSK_6_0 = '6.0';
  C_RSK_7_0 = '7.0';

  C_RVAL_JVCSIDEClient = 'MAKESTUDIOWizard';

// some global variables
var
  g_bHaveRegMoved : Boolean;


{ =============================================================================
  Purpose  : Create a chapter file
  Parameter: chm File, Chapter
}
procedure CreateMergedHelpFileChapter( aFilename:String; aChapter:String; aContentFile:String);
var s:String;
begin
  s := ChangeFileExt( aFilename, '.txt');
  SaveStringToFile( s, 'Chapter='+aChapter, false);
  if aContentFile<>'' then
    SaveStringToFile( s, #13#10 + 'ContentFile='+aContentFile, true);
end;

{ =============================================================================
  Purpose  : Copy an existing chm File into the tworks help directory and
             create a chapter file
  Parameter: chm File, Chapter
}
procedure CopyMergedHelpFile( aFilename:String; aChapter:String; aContentFile:String);
var s :String;
begin

  //Copy File
  s := ExtractFileName( aFilename);
  s := ExpandConstant('{app}\Help\') + s;

  if FileExists( s) then
    DeleteFile( s);

  FileCopy( aFilename, s, False);

  //create Chapter File
  CreateMergedHelpFileChapter( s, aChapter, aContentFile);
end;

{ =============================================================================
  Purpose  : Detect installed (Win32) Delphi version
  Parameter: sVersion[5.0, 6.0, 7.0]
}
function GetDelphiDetected(const sVersion : String) : Boolean;
Begin
  result := RegKeyExists(HKCU, 'Software\Borland\Delphi\'+sVersion);
End;

{ =============================================================================
  Purpose  : Detect any Delphi version (5,6,7)
}
function GetAnyDelphiDetected() : Boolean;
Begin
  // D5, D6 or D7 installed?
  result := GetDelphiDetected(C_RSK_5_0) or
            GetDelphiDetected(C_RSK_6_0) or
            GetDelphiDetected(C_RSK_7_0);
End;

{ =============================================================================
  Purpose  : Detect installed Borland Developer Studio version
  Parameter: sVersion[1.0, 2.0, 3.0]
}
function GetBDSDetected(const sVersion : String) : Boolean;
Begin
  result := RegKeyExists(HKCU, 'Software\Borland\BDS\'+sVersion);
End;

{ =============================================================================
  Purpose  : Detect installed Borland Developer Studio product version (.NET)
             includes also Delphi8, D2005
  Parameter: sVersion[1.0, 2.0, 3.0]
}
{ =============================================================================
  Purpose  : Detect any BDS version (C#Builder, D8, D2k5)
}
function GetAnyBDSDetected() : Boolean;
Begin
  // C#Builder, D8, D2k5 installed?
  result := GetBDSDetected(C_RSK_1_0) or
            GetBDSDetected(C_RSK_2_0) or
            GetBDSDetected(C_RSK_3_0);
End;

{ =============================================================================
  Purpose  : Detect if FreeVCS IDE DLL is installed for
             one Delphi version (5,6,7)
  Parameter: sVersion[5.0, 6.0, 7.0]
}
function GetDelphiFreeVCSDetected(const sVersion : String) : Boolean;
Begin
  result := RegKeyExists(HKCU, 'Software\Borland\Delphi\'+sVersion+'\Version Control\FreeVCS');
End;

{ =============================================================================
  Purpose  : Register appropriate IDE client, either VCSManager or Expert
  Result   : FALSE = terminate Setup
             TRUE  = continue Setup
}
procedure RegisterJvcsMakIdeClient(const sProduct, sVersion : String);
Var
  bUseVCSManager : Boolean;
  sIDEDLL : String;
  sRegKey : String;
  sValue : String;
begin
  bUseVCSManager := false;
  sIDEDll := AddBackSlash(ExpandConstant('{app}'));
  sRegKey := '';
  // -----------------
  // IF Delphi (Win32)
  if sProduct = C_RSK_DELPHI then
  begin
    if (sVersion = C_RSK_5_0) then
    begin
      sIDEDLL := sIDEDLL + 'JVCSMakPluginWizardD5.dll';
    end
    else if sVersion = C_RSK_6_0 then
    begin
      sIDEDLL := sIDEDLL + 'JVCSMakPluginWizardD6.dll';
    end
    else if sVersion = C_RSK_7_0 then
    begin
      sIDEDLL := sIDEDLL + 'JVCSMakPluginWizardD7.dll';
    end;
  end
  // -------------
  // IF Delphi (.NET)
  else if sProduct = C_RSK_BDS then
  begin
    if sVersion = C_RSK_3_0 then
    begin
      sIDEDLL := sIDEDLL + 'JVCSMakPluginWizardD9.dll';
    end;
  end;

  RegWriteStringValue (HKCU, 'Software\Borland\'+sProduct+'\'+sVersion+'\Experts', C_RVAL_JVCSIDEClient, sIDEDll);
end;


{ =============================================================================
  Purpose  : InnoSetup event handler which is called during initialization
             of the setup process
  Result   : FALSE = terminate Setup
             TRUE  = continue Setup
}
function InitializeSetup(): Boolean;
Begin
  // Initialization
  result := true;

  g_bHaveRegMoved := false;
End;


{ =============================================================================
  Purpose  : InnoSetup event handler which is called on change to another
             wizard page
}
procedure CurPageChanged(CurPage: Integer);
Var
  sSelTasks   : String;
  sSrc : String;
  sDst : String;
  bMigrateSuccess : Boolean;
Begin
  Case CurPage of
  wpSelectDir :
    Begin
    End;
  wpFinished:  // setup is finished, finalizing tasks
    Begin
      sSelTasks := WizardSelectedTasks(false);
      // ===================================
      // Register Delphi (5,6,7) IDE client
      // ===================================
      if (Pos('IDE_DELPHI_REGISTER\D7',sSelTasks)>0) then
        RegisterJvcsMakIdeClient(C_RSK_DELPHI, C_RSK_7_0);
      // ===================================
      // Register BDS (3) IDE client
      // ===================================
      if (Pos('IDE_DELPHI_REGISTER\BDS3',sSelTasks)>0)  then
        RegisterJvcsMakIdeClient(C_RSK_BDS, C_RSK_3_0);

    End;  // curPage = csTerminate
  End;  // case
End;
