
/* Bismillah */

/*

basic.js (v1.7.4) Create interactive user interfaces with basic programming skills.
- Project Site: https://bug7a.github.io/basic.js/

Copyright 2020-2024 Bugra Ozden <bugra.ozden@gmail.com>
- https://github.com/bug7a

Licensed under the Apache License, Version 2.0

*/

!function(){"use strict";let t={},e=window;e.basic=t,t.startTime=Date.now(),t.ACTION_COLOR="#689BD2",t.ACTION2_COLOR="cadetblue",t.WARNING_COLOR="tomato",t.ALERT_COLOR="gold",t.CANCEL_COLOR="lightgray",t.TEXT_COLOR="rgba(0, 0, 0, 0.8)",t.BACKGROUND_COLOR="whitesmoke",t.DARK_BACKGROUND_COLOR="#141414",t.FONT_SIZE=20,t.BUTTON_WIDTH=130,t.BUTTON_HEIGHT=50,t.BUTTON_COLOR=t.ACTION_COLOR,t.BUTTON_TEXT_COLOR="rgba(0, 0, 0, 0.65)",t.TEXTBOX_WIDTH=270,t.TEXTBOX_HEIGHT=50,t.gunler=["Pazar","Pazartesi","Salı","\xc7arşamba","Perşembe","Cuma","Cumartesi"],t.days=["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],t.aylar=["Ocak","Şubat","Mart","Nisan","Mayıs","Haziran","Temmuz","Ağustos","Eyl\xfcl","Ekim","Kasım","Aralık"],t.months=["January","February","March","April","May","June","July","August","September","October","November","December"],e.that=null,e.previousThat=null,e.prevThat=null;let n,i,o,s={};s.objectAndFunctionList=[];let r={};r.WITH_MOTION_TIME=50,r.DONT_MOTION_TIME=40,t.start=function(){e.page=new h,page.containerBox=null,setDefaultContainerBox(page),page.bodyElement.style.margin="0px",page.bodyElement.style.overflow="hidden",page.mainBox=createBox(0,0,page.width,page.height),page.mainBox.containerBox=null,that.element.style.position="fixed",that.color="transparent",page.onResize(function(){"function"==typeof page.refreshSize&&page.refreshSize()}),"function"==typeof start&&(start(),t.afterStart()),"function"!=typeof loop||o||setLoopTimer(1e3)},t.afterStart=function(){},e.println=function(t,e="log"){console[e](t)},e.random=function(t,e){let n=0;return void 0!=e?e<t?console.error("basic.js: random(): The second parameter (number) must be greater than the first."):n=t+Math.round(Math.random()*(e-t)):console.error("basic.js: random(): Two parameters (numbers) must be sent."),n},e.num=function(t,e="float"){return"float"==e?Math.round(100*parseFloat(t))/100:"integer"==e||"int"==e?parseInt(t):void 0},e.str=function(t){return String(t)},e.isMobile=function(){let t=0,e=navigator.userAgent||navigator.vendor||window.opera;return(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino|android|ipad|playbook|silk/i.test(e)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(e.substr(0,4)))&&(t=1),t},e.go=function(t,e="_self"){return window.open(t,e)},e.twoDigitFormat=function(t){return t<=9&&(t="0"+t),t},e.storage={save(t,e){window.localStorage.setItem(t,JSON.stringify(e))},load:t=>JSON.parse(window.localStorage.getItem(t)),remove(t){window.localStorage.removeItem(t)}},e.clock={get hour(){return new Date().getHours()},get minute(){return new Date().getMinutes()},get second(){return new Date().getSeconds()},get milisecond(){return new Date().getMilliseconds()}},e.date={get year(){return new Date().getFullYear()},get monthNumber(){let l=new Date().getMonth();return++l},get ayAdi(){return t.aylar[this.monthNumber-1]},get monthName(){return t.months[this.monthNumber-1]},get dayNumber(){return new Date().getDay()},get gunAdi(){return t.gunler[this.dayNumber]},get dayName(){return t.days[this.dayNumber]},get today(){return new Date().getDate()},get now(){return Date.now()}};class a{constructor(t){this._type=t,this._visible=1,this._displayType="block",this._opacity=1,this._rotate=0,this._motionString="none",this._clickable=0,this._eventFuncList=[]}get parentBox(){return this._containerBox}set parentBox(t){this._containerBox=t}get containerBox(){return this._containerBox}set containerBox(t){this._containerBox=t}get left(){return"absolute"==this.position?parseFloat(this.contElement.style.left):this.contElement.offsetLeft}set left(t){this.contElement.style.right="",this.contElement.style.left=parseFloat(t)+"px"}get top(){return"absolute"==this.position?parseFloat(this.contElement.style.top):this.contElement.offsetTop}set top(t){this.contElement.style.bottom="",this.contElement.style.top=parseFloat(t)+"px"}get right(){return parseFloat(this.contElement.style.right)}set right(t){this.contElement.style.left="",this.contElement.style.right=parseFloat(t)+"px"}get bottom(){return parseFloat(this.contElement.style.bottom)}set bottom(t){this.contElement.style.top="",this.contElement.style.bottom=parseFloat(t)+"px"}get width(){return"string"!=typeof this._width?this._width||0:this.contElement.offsetWidth}set width(t){this._width=t,"string"!=typeof t?this.contElement.style.width=parseFloat(t)+"px":this.contElement.style.width=t}get height(){return"string"!=typeof this._height?this._height||0:this.contElement.offsetHeight}set height(t){this._height=t,"string"!=typeof t?this.contElement.style.height=parseFloat(t)+"px":this.contElement.style.height=t}get rotate(){return this._rotate}set rotate(t){this._rotate=parseInt(t),this.contElement.style.transform="rotate("+t+"deg)"}get visible(){return this._visible}set visible(t){this._visible=t,this.contElement.style.display&&"none"!=this.contElement.style.display&&(this._displayType=this.contElement.style.display),this.contElement.style.display=1==t?this._displayType:"none"}get clickable(){return this._clickable}set clickable(t){this._clickable=t,this.contElement.style.pointerEvents=1==t?"auto":"none"}get opacity(){return this._opacity}set opacity(t){this._opacity=t,this.contElement.style.opacity=t}get color(){return this._backgroundColor}set color(t){this._backgroundColor=t,this.contElement.style.backgroundColor=t}get border(){return this._border}set border(t){this._border=t,this.contElement.style.borderWidth=t+"px"}get borderColor(){return this._borderColor}set borderColor(t){this._borderColor=t,this.contElement.style.borderColor=t}get round(){return this._round}set round(t){this._round=t,this.contElement.style.borderRadius=t+"px"}get fontSize(){return this._fontSize}set fontSize(t){this._fontSize=t,this.element.style.fontSize=t+"px"}get textSize(){return this._fontSize}set textSize(t){this._fontSize=t,this.element.style.fontSize=t+"px"}get textColor(){return this._textColor}set textColor(t){this._textColor=t,this.element.style.color=t}get textAlign(){return this._textAlign}set textAlign(t){this._textAlign=t,this.element.style.textAlign=t}get position(){return this.contElement.style.position?this.contElement.style.position:"absolute"}set position(t){this.contElement.style.position=t,"relative"==t&&(this.left=0,this.top=0)}center(t){f(this,t)}centerBy(t,e){$(this,t,e)}aline(t,e,n=0,i){y(this,t,e,n,i)}remove(){this.contElement.remove()}props(t,e,n){b(this,t,e,n)}_addEventListener(t,e,n){let i=this;var o=function(t){e(i,t)};n.addEventListener(t,o);var s={};s.eventName=t,s.originalFunc=e,s.func=o,s.element=n,this._eventFuncList.push(s)}_removeEventListener(t,e,n){for(var i=null,o=0;o<this._eventFuncList.length;o++)if(this._eventFuncList[o].originalFunc==e){i=this._eventFuncList[o].func,this._eventFuncList.splice(o,1);break}i&&n.removeEventListener(t,i)}onResize(t){s.onResize(this,t)}remove_onResize(t){s.remove_onResize(this.element,t)}setMotion(t){var e=this;setTimeout(function(){e.setMotionNow(t)},r.DONT_MOTION_TIME)}getMotion(){return this._motionString}setMotionNow(t){this._motionString=t,this.contElement.style.transition=t}withMotion(t){var e=this;setTimeout(function(){e.canMotionNow(),t(e)},r.WITH_MOTION_TIME)}dontMotion(){this.contElement.style.transition="none";var t=this;setTimeout(function(){t.contElement.style.transition=t._motionString},r.DONT_MOTION_TIME)}canMotionNow(){this.contElement.style.transition=this._motionString}}class h{constructor(){this._bodyElement=document.getElementsByTagName("BODY")[0],this._element=this._bodyElement,this._backgroundColor="white",this._zoom=1}get elem(){return this._element}get element(){return this._element}get contElement(){return this._element}get bodyElement(){return this._bodyElement}get mainBox(){return this._box}set mainBox(t){this._box=t,this._element=this._box.element}get width(){let e;return e=window.innerWidth||document.documentElement.clientWidth||document.body.clientWidth,t.withPageZoom(e)}get height(){let e;return e=window.innerHeight||document.documentElement.clientHeight||document.body.clientHeight,t.withPageZoom(e)}get zoom(){return this._zoom}set zoom(t){this._zoom=t,this.bodyElement.style.transformOrigin="top left",this.bodyElement.style.transform="scale("+t+")",page.refreshSize()}get color(){return this._backgroundColor}set color(t){this._backgroundColor=t,this.bodyElement.style.backgroundColor=t}fit(t=document.body.clientWidth,e){page.zoom=1;let n=page.width;n>(e=e||t)?page.zoom=e/t:page.zoom=n/t}refreshSize(){page.mainBox.width=page.width,page.mainBox.height=page.height}onClick(t){this._box._addEventListener("click",t,window)}remove_onClick(t){this._box._removeEventListener("click",t,window)}onResize(t){this._box._addEventListener("resize",t,window)}remove_onResize(t){this._box._removeEventListener("resize",t,window)}add(t){t.containerBox!=this&&(t.containerBox=this,this.element.appendChild(t.contElement))}}class c extends a{constructor(t=-1e3,e=-1e3,i=100,o=100){super("box"),this._backgroundColor="whitesmoke",this._border=0,this._borderColor="rgba(0, 0, 0, 0.6)",this._round=0,this._fontSize=16,this._textColor="rgba(0, 0, 0, 0.8)",this._textAlign="left";let s=document.createElement("DIV");s.classList.add("basic_box"),s.style.left=t+"px",s.style.top=e+"px",this._element=s,this._containerBox=n,n.element.appendChild(this._element),this.width=i,this.height=o,"flex"==n.element.style.display&&(this.position="relative"),makeBasicObject(this)}get elem(){return this._element}get element(){return this._element}get contElement(){return this._element}get text(){return this.element.innerHTML}set text(t){this.element.innerHTML=t}get html(){return this.element.innerHTML}set html(t){this.element.innerHTML=t}get scrollX(){return"auto"==this.contElement.style.overflowX?1:0}get scrollY(){return"auto"==this.contElement.style.overflowY?1:0}set scrollX(t){this.contElement.style.overflowX="hidden",1==t&&(this.clickable=1,this.contElement.style.overflowX="auto")}set scrollY(t){this.contElement.style.overflowY="hidden",1==t&&(this.clickable=1,this.contElement.style.overflowY="auto")}onClick(t){this.clickable=1,this._addEventListener("click",t,this.contElement)}remove_onClick(t){this._removeEventListener("click",t,this.contElement)}add(t){t.containerBox!=this&&(t.containerBox=this,this.element.appendChild(t.contElement))}in(t){var e=getDefaultContainerBox();setDefaultContainerBox(this),t(this),setDefaultContainerBox(e)}}e.createBox=function(t,e,n,i){return new c(t,e,n,i)};class m extends a{constructor(e=-1e3,i=-1e3,o=t.BUTTON_WIDTH,s=t.BUTTON_HEIGHT){super("button"),this._backgroundColor=t.BUTTON_COLOR,this._border=1,this._borderColor="rgba(0, 0, 0, 0.40)",this._round=4,this._fontSize=20,this._textColor=t.BUTTON_TEXT_COLOR,this._textAlign="center",this._clickable=1;let r=document.createElement("BUTTON");r.innerHTML="Button",r.classList.add("basic_button"),r.setAttribute("type","button"),r.style.left=e+"px",r.style.top=i+"px",this._element=r,this._containerBox=n,n.element.appendChild(this._element),this.width=o,this.height=s,"flex"==n.element.style.display&&(this.position="relative"),makeBasicObject(this)}get elem(){return this._element}get element(){return this._element}get contElement(){return this._element}get buttonElement(){return this._element}get text(){return this.buttonElement.innerHTML}set text(t){this.buttonElement.innerHTML=t}get value(){return this.buttonElement.value}set value(t){this.buttonElement.value=t}get enabled(){return this.buttonElement.disabled?0:1}set enabled(t){this.buttonElement.disabled=t?0:1}get minimal(){return this.buttonElement.classList.contains("minimal")?1:0}set minimal(t){t?this.buttonElement.classList.add("minimal"):this.buttonElement.classList.remove("minimal")}get spaceX(){return parseInt(this.contElement.style.paddingLeft)||0}set spaceX(t){this.contElement.style.paddingLeft=t+"px",this.contElement.style.paddingRight=t+"px"}onClick(t){this.clickable=1,this._addEventListener("click",t,this.buttonElement)}remove_onClick(t){this._removeEventListener("click",t,this.buttonElement)}add(t){console.error("basic.js: add(): Insertion cannot be made inside the Button object.")}}e.createButton=function(t,e,n,i){return new m(t,e,n,i)};class u extends a{constructor(e=-1e3,i=-1e3,o=t.TEXTBOX_WIDTH,s=t.TEXTBOX_HEIGHT){super("textbox"),this._backgroundColor="white",this._border=1,this._borderColor="#4A4A4A",this._round=4,this._fontSize=20,this._textColor="#4A4A4A",this._textAlign="left",this._clickable=1;let r=document.createElement("DIV");r.classList.add("basic_textbox-main"),this._mainElement=r;let l=document.createElement("DIV");l.classList.add("basic_textbox-title"),l.innerHTML="",this._titleElement=l;let a=document.createElement("INPUT");a.value="",a.classList.add("basic_textbox"),a.setAttribute("type","text"),a.style.width="100%",a.style.height="100%",this._element=a,r.style.left=e+"px",r.style.top=i+"px",r.appendChild(this._titleElement),r.appendChild(this._element),this._containerBox=n,n.element.appendChild(this._mainElement),this.width=o,this.height=s,"flex"==n.element.style.display&&(this.position="relative"),makeBasicObject(this)}get elem(){return this._mainElement}get element(){return this._mainElement}get inputElement(){return this._element}get contElement(){return this._mainElement}get titleElement(){return this._titleElement}get text(){return this.inputElement.value}set text(t){this.inputElement.value=t.toString()}get color(){return super.color}set color(t){this._backgroundColor=t,this.inputElement.style.backgroundColor=t}get title(){return this.titleElement.innerHTML}set title(t){this.titleElement.innerHTML=t}get enabled(){return this.inputElement.disabled?0:1}set enabled(t){this.inputElement.disabled=t?0:1}set border(t){this._border=t,this.inputElement.style.borderWidth=t+"px"}get border(){return super.border}get borderColor(){return super.borderColor}set borderColor(t){this._borderColor=t,this.inputElement.style.borderColor=t}set round(t){this._round=t,this.inputElement.style.borderRadius=t+"px"}get round(){return super.round}get clickable(){return super.clickable}set clickable(t){this._clickable=t,this.inputElement.style.pointerEvents=1==t?"auto":"none"}get fontSize(){return super.fontSize}set fontSize(t){this._fontSize=t,this.inputElement.style.fontSize=t+"px"}get textSize(){return super.textSize}set textSize(t){this._fontSize=t,this.inputElement.style.fontSize=t+"px"}get textColor(){return super.textColor}set textColor(t){this._textColor=t,this.inputElement.style.color=t}get textAlign(){return super.textAlign}set textAlign(t){this._textAlign=t,this.inputElement.style.textAlign=t}get minimal(){return this.inputElement.classList.contains("minimal")?1:0}set minimal(t){t?this.inputElement.classList.add("minimal"):this.inputElement.classList.remove("minimal")}onChange(t){this._addEventListener("change",t,this.inputElement)}remove_onChange(t){this._removeEventListener("change",t,this.inputElement)}add(t){console.error("basic.js: add(): Insertion cannot be made inside the TextBox object.")}}e.createTextBox=function(t,e,n,i){return new u(t,e,n,i)},e.createInput=function(t,e,n,i){return new u(t,e,n,i)};class d extends a{constructor(t=-1e3,e=-1e3,i="auto",o="auto"){super("label"),this._backgroundColor="transparent",this._border=0,this._borderColor="rgba(0, 0, 0, 0.6)",this._round=0,this._fontSize=20,this._textColor="rgba(0, 0, 0, 0.8)",this._textAlign="left";let s=document.createElement("DIV");s.innerHTML="Label Text",s.classList.add("basic_label"),s.style.left=t+"px",s.style.top=e+"px",this._element=s,this._containerBox=n,n.element.appendChild(this._element),this.width=i,this.height=o,"flex"==n.element.style.display&&(this.position="relative"),makeBasicObject(this)}get elem(){return this._element}get element(){return this._element}get contElement(){return this._element}get text(){return this.element.innerHTML}set text(t){this.element.innerHTML=t}get space(){return parseInt(this.contElement.style.padding)||0}set space(t){this.contElement.style.padding=t+"px"}get spaceX(){return parseInt(this.contElement.style.paddingLeft)||0}set spaceX(t){this.contElement.style.paddingLeft=t+"px",this.contElement.style.paddingRight=t+"px"}get spaceY(){return parseInt(this.contElement.style.paddingTop)||0}set spaceY(t){this.contElement.style.paddingTop=t+"px",this.contElement.style.paddingBottom=t+"px"}onClick(t){this.clickable=1,this._addEventListener("click",t,this.contElement)}remove_onClick(t){this._removeEventListener("click",t,this.contElement)}add(t){console.error("basic.js: add(): Insertion cannot be made inside the Label object.")}}e.createLabel=function(t,e,n,i){return new d(t,e,n,i)};class p extends a{constructor(t=-1e3,e=-1e3,i=0,o=0){super("image"),this._autoSize=1,this._space=0,this._backgroundColor="transparent",this._border=0,this._borderColor="rgba(0, 0, 0, 0.6)",this._round=0;let s=document.createElement("IMG");s.classList.add("basic_image"),s.style.left=t+"px",s.style.top=e+"px",this._element=s,this._containerBox=n,n.element.appendChild(this._element),super.width=i,super.height=o;var r=this;(i||o)&&(this.autoSize=0),s.addEventListener("load",function(){if(r.autoSize>0){let t=r.autoSize;r.width=parseInt(r.naturalWidth/t)+"px",r.height=parseInt(r.naturalHeight/t)+"px"}}),"flex"==n.element.style.display&&(this.position="relative"),makeBasicObject(this)}get elem(){return this._element}get element(){return this._element}get imageElement(){return this._element}get contElement(){return this._element}get width(){return super.width}set width(t){this.autoSize=0,super.width=t}get height(){return super.height}set height(t){this.autoSize=0,super.height=t}get naturalWidth(){return this.imageElement.naturalWidth}get naturalHeight(){return this.imageElement.naturalHeight}get autoSize(){return this._autoSize}set autoSize(t){this._autoSize=t}get space(){return this._space}set space(t){t>50&&(t=50),t<0&&(t=0),this._space=t;var e=parseInt(this.width/100*t),n=parseInt(this.height/100*t);this.contElement.style.paddingLeft=e+"px",this.contElement.style.paddingRight=e+"px",this.contElement.style.paddingTop=n+"px",this.contElement.style.paddingBottom=n+"px"}onClick(t){this.clickable=1,this._addEventListener("click",t,this.contElement)}remove_onClick(t){this._removeEventListener("click",t,this.contElement)}onLoad(t){this._addEventListener("load",t,this.imageElement)}remove_onLoad(t){this._removeEventListener("load",t,this.imageElement)}load(t){this.imageElement.setAttribute("src",t)}add(t){console.error("basic.js: add(): Insertion cannot be made inside the BImage object.")}}e.createImage=function(t,e,n,i){return new p(t,e,n,i)},e.createIcon=function(t,e,n,i){return new p(t,e,n,i)};class g{constructor(){let t=document.createElement("AUDIO"),e=document.createElement("SOURCE");t.appendChild(e),this._element=t,document.body.appendChild(this._element),makeBasicObject(this)}get element(){return this._element}get soundElement(){return this._element}get contElement(){return this._element}get time(){return this.element.timr}get timeLeft(){return this.element.timeLeft}get currentTime(){return this.element.currentTime}get paused(){return this.element.paused}get playing(){return!this.element.paused}get loop(){return"loop"==this.element.getAttribute("loop")?1:0}set loop(t){1==t?this.element.setAttribute("loop","loop"):this.element.setAttribute("loop","")}play(){this.paused&&this.element.play()}pause(t){this.paused||this.element.pause()}stop(){this.paused||(this.element.pause(),this.element.currentTime=0)}onLoad(t){let e=this;this.element.addEventListener("canplaythrough",function(){t(e)})}load(t){let e="audio/wav";"mp3"==t.substr(-3).toLowerCase()&&(e="audio/mpeg"),this.element.children[0].setAttribute("src",t),this.element.children[0].setAttribute("type",e)}remove(){this.contElement.remove()}}let b=function(t,e=[],n=[],i=[]){let o={};for(let s in e)o[s]=e[s];for(let r in n)o[r]=n[r];for(let l in i)o[l]=i[l];for(let a in o)t[a]=o[a]},f=function(t,e){if("left"==e||!e){let n=t.containerBox.width-2*(t.containerBox.border||0);t.left=parseInt((n-t.width)/2)}if("top"==e||!e){let i=t.containerBox.height-2*(t.containerBox.border||0);t.top=parseInt((i-t.height)/2)}},$=function(t,e,n){if("left"==n||!n){let i=e.width;t.left=parseInt((i-t.width)/2)+e.left,n&&(t.top=e.top)}if("top"==n||!n){let o=e.height;t.top=parseInt((o-t.height)/2)+e.top,n&&(t.left=e.left)}},y=function(t,e,n,i,o){if("left"==n?(isNaN(e.left)?isNaN(e.right)||(t.right=parseInt(e.right+e.width+i)):t.left=parseInt(e.left-t.width-i),isNaN(e.top)?t.bottom=parseInt(e.bottom):t.top=parseInt(e.top)):"top"==n?(isNaN(e.top)?isNaN(e.bottom)||(t.bottom=parseInt(e.bottom+e.height+i)):t.top=parseInt(e.top-t.height-i),isNaN(e.left)?t.right=parseInt(e.right):t.left=parseInt(e.left)):"right"==n?(isNaN(e.left)?isNaN(e.right)||(t.right=parseInt(e.right-t.width-i)):t.left=parseInt(e.left+e.width+i),isNaN(e.top)?t.bottom=parseInt(e.bottom):t.top=parseInt(e.top)):"bottom"==n?(isNaN(e.top)?isNaN(e.bottom)||(t.bottom=parseInt(e.bottom-t.height-i)):t.top=parseInt(e.top+e.height+i),isNaN(e.left)?t.right=parseInt(e.right):t.left=parseInt(e.left)):(isNaN(e.top)?isNaN(e.bottom)||(t.bottom=parseInt(e.bottom)):t.top=parseInt(e.top),isNaN(e.left)?isNaN(e.right)||(t.right=parseInt(e.right)):t.left=parseInt(e.left)),"left"==n||"right"==n){var s=e.height-t.height;switch(o){case"top":isNaN(e.top)&&(isNaN(e.bottom)||(t.bottom+=parseInt(s)));break;case"bottom":isNaN(e.top)?isNaN(e.bottom):t.top+=parseInt(s);break;case"center":isNaN(e.top)?isNaN(e.bottom)||(t.bottom+=parseInt(s/2)):t.top+=parseInt(s/2)}}else if("top"==n||"bottom"==n){var s=e.width-t.width;switch(o){case"left":isNaN(e.left)&&(isNaN(e.right)||(t.right=parseInt(e.right+s)));break;case"right":isNaN(e.left)?isNaN(e.right):t.left+=parseInt(s);break;case"center":isNaN(e.left)?isNaN(e.right)||(t.right+=parseInt(s/2)):t.left+=parseInt(s/2)}}};t.withPageZoom=function(t){return parseFloat(t*(1/page.zoom))},e.withPageZoom=t.withPageZoom,t.setLoopTimer=function(t){"function"==typeof loop&&(o&&(o=clearInterval(o)),0==t||(o=setInterval(loop,t)))},e.setLoopTimer=t.setLoopTimer,t.setDefaultContainerBox=function(t){i=n||page,n=t},e.setDefaultContainerBox=t.setDefaultContainerBox,t.restoreDefaultContainerBox=function(){n=i||page},e.restoreDefaultContainerBox=t.restoreDefaultContainerBox,t.getDefaultContainerBox=function(){return n},e.getDefaultContainerBox=t.getDefaultContainerBox,t.makeBasicObject=function(t){prevThat=previousThat=that,that=t},e.makeBasicObject=t.makeBasicObject,s.onResize=function(t,e){var n={};n.obj=t,n.elem=t.element,n.func=e,s.objectAndFunctionList.push(n),s.whenDetected.observe(t.element)},s.remove_onResize=function(t,e){for(var n=s.objectAndFunctionList.length-1;n>=0;n--)s.objectAndFunctionList[n].elem==t&&s.objectAndFunctionList[n].func==e&&s.objectAndFunctionList.splice(n,1);s.whenDetected.unobserve(t)},s.whenDetected=new ResizeObserver(function(t){for(var e=s,n=0;n<t.length;n++)for(var i=0;i<e.objectAndFunctionList.length;i++)t[n].target==e.objectAndFunctionList[i].elem&&e.objectAndFunctionList[i].func(e.objectAndFunctionList[i].obj)});let E=[],x=null,v=function(){x&&clearTimeout(x),x=setTimeout(function(){let t=E.length-1;t>0&&console.warn("basic.js: Some started boxes were not ended. Count: "+t)},100)};e.startFlexBox=function(t={},e,n,i,o){let s={},r=null;for(let l in"object"==typeof t?(r=createBox(0,0,"100%","100%"),s=t):"object"==typeof e?(r=createBox(t,0,"100%","100%"),s=e):"object"==typeof n?(r=createBox(t,e,"100%","100%"),s=n):"object"==typeof i?(r=createBox(t,e,n,"100%"),s=i):"object"==typeof o?(r=createBox(t,e,n,i),s=o):r=createBox(t,e,n,i),s.flexDirection||(s.flexDirection="row"),s.flexWrap||(s.flexWrap="nowrap"),s.alignContent||(s.alignContent="center"),s.justifyContent||(s.justifyContent="center"),s.alignItems||(s.alignItems="center"),s.color||(s.color="transparent"),r.props(s),that.element.style.display="flex",s)r.element.style[l]=s[l];return 0==E.length&&E.push(getDefaultContainerBox()),setDefaultContainerBox(r),E.push(r),v(),r},e.startBox=function(t={},e,n,i,o){let s={},r=null;return"object"==typeof t?(r=createBox(),s=t):"object"==typeof e?(r=createBox(t),s=e):"object"==typeof n?(r=createBox(t,e),s=n):"object"==typeof i?(r=createBox(t,e,n),s=i):"object"==typeof o?(r=createBox(t,e,n,i),s=o):r=createBox(t,e,n,i),r.props(s),0==E.length&&E.push(getDefaultContainerBox()),setDefaultContainerBox(r),E.push(r),v(),r},e.endBox=function(){E.length>1&&E.pop(),setDefaultContainerBox(E[E.length-1]),1==E.length&&(E=[])},e.endFlexBox=e.endBox,t.useImageAsText=function(e={},n){e.boxSize||(e.boxSize=16),e.outerSpaceRight||(e.outerSpaceRight=0),e.outerSpaceLeft||(e.outerSpaceLeft=0),t.saveCurrentThat();let i=document.createElement("span");i.style.display="inline-block",i.style.marginRight=e.outerSpaceRight+"px",i.style.marginLeft=e.outerSpaceLeft+"px";let o=createBox(0,0,e.boxSize,e.boxSize);return that.color="transparent",that.element.style.position="relative",that.element.style.overflow="visible",createImage(0,0),o.add(that),n(that),that.center(),i.appendChild(o.element),t.restoreThatFromSaved(),i.outerHTML},e.useImageAsText=t.useImageAsText;let w=null,T=null;t.saveCurrentThat=function(){w=that,T=previousThat},e.saveCurrentThat=t.saveCurrentThat,t.restoreThatFromSaved=function(){that=w,prevThat=previousThat=T},e.restoreThatFromSaved=t.restoreThatFromSaved,e.Label=function(t,e,n,i,o){let s={},r=null;return"object"==typeof t?(r=createLabel(),s=t):"object"==typeof e?(r=createLabel(t),s=e):"object"==typeof n?(r=createLabel(t,e),s=n):"object"==typeof i?(r=createLabel(t,e,n),s=i):"object"==typeof o?(r=createLabel(t,e,n,i),s=o):r=createLabel(t,e,n,i),r.props(s),r},e.Input=function(t,e,n,i,o){let s={},r=null;return"object"==typeof t?(r=createTextBox(),s=t):"object"==typeof e?(r=createTextBox(t),s=e):"object"==typeof n?(r=createTextBox(t,e),s=n):"object"==typeof i?(r=createTextBox(t,e,n),s=i):"object"==typeof o?(r=createTextBox(t,e,n,i),s=o):r=createTextBox(t,e,n,i),r.props(s),r},e.Icon=function(t,e,n,i,o){let s={},r=null;return"object"==typeof t?(r=createImage(),s=t):"object"==typeof e?(r=createImage(t),s=e):"object"==typeof n?(r=createImage(t,e),s=n):"object"==typeof i?(r=createImage(t,e,n),s=i):"object"==typeof o?(r=createImage(t,e,n,i),s=o):r=createImage(t,e,n,i),r.props(s),r},e.Box=function(t,e,n,i,o){let s={},r=null;return"object"==typeof t?(r=createBox(),s=t):"object"==typeof e?(r=createBox(t),s=e):"object"==typeof n?(r=createBox(t,e),s=n):"object"==typeof i?(r=createBox(t,e,n),s=i):"object"==typeof o?(r=createBox(t,e,n,i),s=o):r=createBox(t,e,n,i),r.props(s),r},e.Button=function(t,e,n,i,o){let s={},r=null;return"object"==typeof t?(r=createButton(),s=t):"object"==typeof e?(r=createButton(t),s=e):"object"==typeof n?(r=createButton(t,e),s=n):"object"==typeof i?(r=createButton(t,e,n),s=i):"object"==typeof o?(r=createButton(t,e,n,i),s=o):r=createButton(t,e,n,i),r.props(s),r},window.addEventListener("load",function(){t.start()})}();