#pragma once

#include <uart/uart.h>

#define UART8250_BASE 0x10000000

typedef enum
{
    UART_8250_TRASMITTER_HOLDING_BUFFER = 0,
    UART_8250_RECEIVER_BUFFER = 0,
    UART_8250_DIVISOR_LATCH_LB = 0,
    UART_8250_INTERRUPT_ENABLE = 1,
    UART_8250_DIVISOR_LATCH_HB = 1,
    UART_8250_INTERRUPT_IDENTIFICATION = 2,
    UART_8250_FIFO_CONTROL = 2,
    UART_8250_LINE_CONTROL = 3,
    UART_8250_MODEM_CONTROL = 4,
    UART_8250_LINE_STATUS = 5,
    UART_8250_MODEM_STATUS = 6,
    UART_8250_SCRATCH = 7,
} Uart8250Registers;

typedef enum
{
    UART_8250_LSR_FIFO_ERROR = 0x80,
    UART_8250_LSR_TRANSMITTER_EMPTY = 0x40,
    UART_8250_LSR_TRANSMITTER_HOLD_REG_EMPTY = 0x20,
    UART_8250_LSR_BREAK_INT_ERROR = 0x10,
    UART_8250_LSR_FRAME_ERROR = 0x08,
    UART_8250_LSR_PARITY_ERROR = 0x04,
    UART_8250_LSR_OVERRUN_ERROR = 0x02,
    UART_8250_LSR_DATA_READY = 0x01,
} Uart8250LineStatus;

Uart *uart8250_init(void);
