![Banner](meta/shared/cover.png)

<br/>

<p align="center">
  Striking modernist shapes and bold use of modern C are the hallmarks of <b>BRUTAL</b>.<br>
  Inspired by brutalist design <b>BRUTAL</b> combines the ideals of UNIX from the 1970s<br> with modern technology and engineering.
</p>

<br/>

# BRUTAL

<a href="https://github.com/brutal-org/brutal/issues">
  <img src="https://img.shields.io/github/issues/brutal-org/brutal">
</a>
<a href="https://github.com/brutal-org/brutal/network">
  <img src="https://img.shields.io/github/forks/brutal-org/brutal">
</a>
<a href="https://github.com/brutal-org/brutal/stargazers">
  <img src="https://img.shields.io/github/stars/brutal-org/brutal">
</a>
<a href="https://github.com/brutal-org/brutal/blob/main/license">
  <img src="https://img.shields.io/github/license/brutal-org/brutal">
</a>
<a href="https://codecov.io/gh/brutal-org/brutal"><img src="https://codecov.io/gh/brutal-org/brutal/branch/main/graph/badge.svg?token=T4R6TEF56Z" alt="codecov"></a>
<a href="https://github.com/brutal-org/brutal/actions/workflows/ubuntu.yml"><img src="https://github.com/brutal-org/brutal/actions/workflows/ubuntu.yml/badge.svg" alt="Build and Test (Ubuntu)"></a>
<a href="https://github.com/brutal-org/brutal/actions/workflows/darwin.yml"><img src="https://github.com/brutal-org/brutal/actions/workflows/darwin.yml/badge.svg" alt="Build and Test (Darwin)"></a>
<br>
<br>

- **BRUTAL** is an operating system built from scratch in modern C.
- **BRUTAL** is built on top of a capability based micro-kernel.
- **BRUTAL** targets x86_64, i686, RISC-V and ARM.
- **BRUTAL** exposes its features to developers through clean APIs.
- **BRUTAL** features a rich and modern C library complete with fibers, custom allocators, generic data structures, and more...

## Screenshots

<p align="center">
<img src="meta/screenshots/2022-03-26.png" />
<br>
BRUTAL running in QEMU 6.2
</p>

## Build Instructions

BRUTAL is pretty easy to to build from source using GNUMake, NASM and LLVM.

See [building.md](meta/building.md) for more details.

## Roadmap

Right now the main goal of brutal is to run doom.

See [roadmap.md](meta/roadmap.md) for more information on how we plan to get there and where you can contribute.

## Credits

This project takes inspirations and/or reuse code from the following projects.

See [credits.md](meta/credits.md)

## License

<a href="https://opensource.org/licenses/MIT">
  <img align="right" height="96" alt="MIT License" src="meta/shared/mit-license.png" />
</a>

The brutal operating system and its core components are licensed under the **MIT License**.

The full text of the license can be accessed via [this link](https://opensource.org/licenses/MIT) and is also included in the [license](license) file of this software package.
